/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import overflowdb.Direction;
import overflowdb.Edge;
import overflowdb.NodeDb;
import overflowdb.NodeRef;

public class DummyEdgeIterator
implements Iterator<Edge> {
    private final Object[] array;
    private int current;
    private final int begin;
    private final int exclusiveEnd;
    private final int strideSize;
    private final Direction direction;
    private final String label;
    private final NodeRef<?> thisRef;
    private Edge nextCached;

    public DummyEdgeIterator(Object[] objectArray, int n, int n2, int n3, Direction direction, String string, NodeRef<?> nodeRef) {
        this.array = objectArray;
        this.begin = n;
        this.current = n;
        this.exclusiveEnd = n2;
        this.strideSize = n3;
        this.direction = direction;
        this.label = string;
        this.thisRef = nodeRef;
    }

    @Override
    public final boolean hasNext() {
        return this.peekNext() != null;
    }

    private Edge peekNext() {
        if (this.nextCached != null) {
            return this.nextCached;
        }
        while (this.current < this.exclusiveEnd && this.array[this.current] == null) {
            this.current += this.strideSize;
        }
        if (this.current < this.exclusiveEnd) {
            this.nextCached = this.readNext();
            this.current += this.strideSize;
            return this.peekNext();
        }
        return null;
    }

    private Edge readNext() {
        Edge edge;
        NodeRef nodeRef = (NodeRef)this.array[this.current];
        if (this.direction == Direction.OUT) {
            edge = ((NodeDb)this.thisRef.get()).instantiateDummyEdge(this.label, this.thisRef, nodeRef);
            edge.setOutBlockOffset(this.current - this.begin);
        } else {
            edge = ((NodeDb)this.thisRef.get()).instantiateDummyEdge(this.label, nodeRef, this.thisRef);
            edge.setInBlockOffset(this.current - this.begin);
        }
        return edge;
    }

    @Override
    public Edge next() {
        if (this.hasNext()) {
            Edge edge = this.peekNext();
            this.nextCached = null;
            return edge;
        }
        throw new NoSuchElementException();
    }
}

