/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorUtils {
    public static <A> ArrayList<A> toArrayList(Iterator<A> iterator) {
        ArrayList<A> arrayList = new ArrayList<A>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <A> Iterator<A> fromSingle(A a) {
        return new SingleIterator<A>(a);
    }

    @SafeVarargs
    public static <A> Iterator<A> from(A ... AArray) {
        return Arrays.stream(AArray).iterator();
    }

    public static <S, E> Iterator<E> map(final Iterator<S> iterator, final Function<S, E> function) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public E next() {
                return function.apply(iterator.next());
            }
        };
    }

    public static <S, E> Iterator<E> flatMap(final Iterator<S> iterator, final Function<S, Iterator<E>> function) {
        return new Iterator<E>(){
            private Iterator<E> currentIterator = Collections.emptyIterator();

            @Override
            public boolean hasNext() {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                while (iterator.hasNext()) {
                    this.currentIterator = (Iterator)function.apply(iterator.next());
                    if (!this.currentIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    public static <S> Iterator<S> filter(final Iterator<S> iterator, final Predicate<S> predicate) {
        return new Iterator<S>(){
            S nextResult = null;

            @Override
            public boolean hasNext() {
                if (null != this.nextResult) {
                    return true;
                }
                this.advance();
                return null != this.nextResult;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            @Override
            public S next() {
                try {
                    if (null != this.nextResult) {
                        Object s = this.nextResult;
                        return s;
                    }
                    this.advance();
                    if (null != this.nextResult) {
                        Object s = this.nextResult;
                        return s;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.nextResult = null;
                }
            }

            private void advance() {
                this.nextResult = null;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!predicate.test(e)) continue;
                    this.nextResult = e;
                    return;
                }
            }
        };
    }

    public static class SingleIterator<A>
    implements Iterator<A> {
        private A element;

        public SingleIterator(A a) {
            this.element = a;
        }

        @Override
        public boolean hasNext() {
            return this.element != null;
        }

        @Override
        public A next() {
            A a = this.element;
            this.element = null;
            return a;
        }
    }

    public static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] elems;
        private int pos;

        public ArrayIterator(E[] EArray) {
            this.elems = EArray;
            this.pos = 0;
        }

        @Override
        public E next() {
            return this.elems[this.pos++];
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.elems.length;
        }
    }
}

