/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class MultiIterator<T>
implements Iterator<T>,
Serializable {
    private final List<Iterator<? extends T>> iterators = new ArrayList<Iterator<? extends T>>();
    private int current = 0;

    @SafeVarargs
    public static <A> MultiIterator<A> from(Iterator<A> ... iteratorArray) {
        MultiIterator<A> multiIterator = new MultiIterator<A>();
        for (Iterator<A> iterator : iteratorArray) {
            multiIterator.addIterator(iterator);
        }
        return multiIterator;
    }

    public void addIterator(Iterator<? extends T> iterator) {
        this.iterators.add(iterator);
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.iterators.size()) {
            return false;
        }
        Iterator<T> iterator = this.iterators.get(this.current);
        while (true) {
            if (iterator.hasNext()) {
                return true;
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            iterator = this.iterators.get(this.current);
        }
        return false;
    }

    @Override
    public void remove() {
        this.iterators.get(this.current).remove();
    }

    @Override
    public T next() {
        if (this.iterators.isEmpty()) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = this.iterators.get(this.current);
        while (true) {
            if (iterator.hasNext()) {
                return iterator.next();
            }
            ++this.current;
            if (this.current >= this.iterators.size()) break;
            iterator = this.iterators.get(this.current);
        }
        throw new NoSuchElementException();
    }

    public void clear() {
        this.iterators.clear();
        this.current = 0;
    }
}

