/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import overflowdb.Node;
import overflowdb.storage.NodesWriter;

public class NodesList {
    private Node[] nodes;
    private int size = 0;
    private TLongIntMap nodeIndexByNodeId;
    private TMap<String, ArrayList<Node>> nodesByLabel;
    private final BitSet emptySlots;
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public NodesList() {
        this(10000);
    }

    public NodesList(int n) {
        this.nodes = new Node[n];
        this.emptySlots = new BitSet(n);
        this.nodeIndexByNodeId = new TLongIntHashMap(n);
        this.nodesByLabel = new THashMap(10);
    }

    public synchronized void add(Node node) {
        this.verifyUniqueId(node);
        int n = this.tryClaimEmptySlot();
        if (n == -1) {
            n = this.size;
            this.ensureCapacity(this.size + 1);
        }
        this.nodes[n] = node;
        this.nodeIndexByNodeId.put(node.id(), n);
        if (this.nodesByLabel != null) {
            this.nodesByLabel(node.label()).add(node);
        }
        ++this.size;
    }

    private void verifyUniqueId(Node node) {
        if (this.nodeIndexByNodeId.containsKey(node.id())) {
            Node node2 = this.nodeById(node.id());
            throw new AssertionError((Object)("different Node with same id already exists in this NodesList: " + String.valueOf(node2)));
        }
    }

    private int tryClaimEmptySlot() {
        int n = this.emptySlots.nextSetBit(0);
        if (n != -1) {
            this.emptySlots.clear(n);
        }
        return n;
    }

    public boolean contains(long l) {
        return this.nodeIndexByNodeId.containsKey(l);
    }

    public Node nodeById(long l) {
        if (this.nodeIndexByNodeId.containsKey(l)) {
            return this.nodes[this.nodeIndexByNodeId.get(l)];
        }
        return null;
    }

    public synchronized void remove(Node node) {
        int n = this.nodeIndexByNodeId.remove(node.id());
        this.nodes[n] = null;
        this.emptySlots.set(n);
        this.nodesByLabel = null;
        --this.size;
        this.compactMaybe();
    }

    public int size() {
        return this.size;
    }

    private TMap<String, ArrayList<Node>> getNodesByLabel() {
        TMap<String, ArrayList<Node>> tMap = this.nodesByLabel;
        if (tMap != null) {
            return tMap;
        }
        this.initialiseNodesByLabel();
        return this.getNodesByLabel();
    }

    private synchronized void initialiseNodesByLabel() {
        if (this.nodesByLabel == null) {
            THashMap tHashMap = new THashMap();
            for (Node node : this.nodes) {
                if (node == null) continue;
                ArrayList arrayList = (ArrayList)tHashMap.computeIfAbsent((Object)node.label(), string -> new ArrayList());
                arrayList.add(node);
            }
            this.nodesByLabel = tHashMap;
        }
    }

    public ArrayList<Node> nodesByLabel(String string2) {
        TMap<String, ArrayList<Node>> tMap = this.getNodesByLabel();
        return (ArrayList)tMap.computeIfAbsent((Object)string2, string -> new ArrayList());
    }

    public Set<String> nodeLabels() {
        TMap<String, ArrayList<Node>> tMap = this.getNodesByLabel();
        HashSet<String> hashSet = new HashSet<String>(tMap.size());
        tMap.forEach((string, arrayList) -> {
            if (!arrayList.isEmpty()) {
                hashSet.add((String)string);
            }
        });
        return hashSet;
    }

    public synchronized Iterator<Node> iterator() {
        return new NodesIterator(Arrays.copyOf(this.nodes, this.nodes.length));
    }

    private void ensureCapacity(int n) {
        if (this.nodes.length < n) {
            this.grow(n);
        }
    }

    private void compactMaybe() {
        int n = this.emptySlots.cardinality();
        if (n > 10000 && n * 100 / this.nodes.length >= 30) {
            this.compact();
        }
    }

    synchronized void compact() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.size);
        Iterator<Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.nodes = arrayList.toArray(new Node[this.size]);
        this.emptySlots.clear();
        this.nodeIndexByNodeId = new TLongIntHashMap(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            Node node = this.nodes[i];
            this.nodeIndexByNodeId.put(node.id(), i);
        }
    }

    private synchronized void grow(int n) {
        int n2 = this.nodes.length;
        int n3 = n2 + (n2 >> 1);
        if (n3 - n < 0) {
            n3 = n;
        }
        if (n3 - 0x7FFFFFF7 > 0) {
            n3 = NodesList.hugeCapacity(n);
        }
        this.nodes = Arrays.copyOf(this.nodes, n3);
    }

    private static int hugeCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError();
        }
        return n > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    protected int _elementDataSize() {
        return this.nodes.length;
    }

    public int cardinality(String string) {
        TMap<String, ArrayList<Node>> tMap = this.getNodesByLabel();
        if (tMap.containsKey((Object)string)) {
            return ((ArrayList)tMap.get((Object)string)).size();
        }
        return 0;
    }

    public void persistAll(NodesWriter nodesWriter) {
        nodesWriter.writeAndClearBatched(Arrays.spliterator(this.nodes), this.nodes.length);
    }

    public static class NodesIterator
    implements Iterator<Node> {
        final Node[] nodes;
        int idx = 0;
        Node nextPeeked = null;

        public NodesIterator(Node[] nodeArray) {
            this.nodes = nodeArray;
        }

        @Override
        public boolean hasNext() {
            while (this.nextPeeked == null && this.idx < this.nodes.length) {
                this.nextPeeked = this.nodes[this.idx++];
            }
            return this.nextPeeked != null;
        }

        @Override
        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node node = this.nextPeeked;
            this.nextPeeked = null;
            return node;
        }
    }
}

