/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Map;
import overflowdb.Node;

public class PropertyHelper {
    public static void attachProperties(Node node, Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("The provided key/value array length must be a multiple of two");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(String.format("The provided key must be of type `String`, but was: %s (value=%s)", object.getClass(), object));
            }
            node.setProperty((String)object, object2);
        }
    }

    public static Object[] toKeyValueArray(Map<String, Object> map) {
        Object[] objectArray = new Object[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            objectArray[n++] = entry.getKey();
            objectArray[n++] = entry.getValue();
        }
        return objectArray;
    }
}

