/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import overflowdb.Config;
import overflowdb.EdgeFactory;
import overflowdb.Graph;
import overflowdb.NodeFactory;
import overflowdb.formats.Importer;
import overflowdb.formats.ImporterMain;
import overflowdb.formats.ImporterMain$Config$;
import overflowdb.formats.graphml.GraphMLImporter$;
import overflowdb.formats.graphson.GraphSONImporter$;
import overflowdb.formats.package$Format$;
import scala.App;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;
import scopt.OParser;
import scopt.OParser$;
import scopt.OParserBuilder;
import scopt.Read$;

public final class ImporterMain$
implements App,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ImporterMain$.class.getDeclaredField("parser$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ImporterMain$.class.getDeclaredField("builder$lzy1"));
    private static long executionStart;
    private static String[] scala$App$$_args;
    private static ListBuffer scala$App$$initCode;
    private volatile Object builder$lzy1;
    private volatile Object parser$lzy1;
    private static final ImporterMain$Config$ Config;
    public static final ImporterMain$ MODULE$;

    private ImporterMain$() {
    }

    static {
        MODULE$ = new ImporterMain$();
        App.$init$((App)MODULE$);
        Statics.releaseFence();
    }

    public final long executionStart() {
        return executionStart;
    }

    public String[] scala$App$$_args() {
        return scala$App$$_args;
    }

    public ListBuffer scala$App$$initCode() {
        return scala$App$$initCode;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        scala$App$$_args = x$1;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$0) {
        executionStart = x$0;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$0) {
        scala$App$$initCode = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ImporterMain$.class);
    }

    public Function1<String[], BoxedUnit> apply(scala.collection.immutable.Seq<NodeFactory<?>> nodeFactories, scala.collection.immutable.Seq<EdgeFactory<?>> edgeFactories, Function1<Object, Object> convertPropertyForPersistence) {
        return (JProcedure1 & Serializable)args -> OParser$.MODULE$.parse(MODULE$.parser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)ImporterMain$Config$.MODULE$.apply((scala.collection.immutable.Seq<Path>)package$.MODULE$.Nil(), null, Paths.get("/dev/null", new String[0]))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            ImporterMain.Config config = x$1;
            if (config != null) {
                Importer importer;
                ImporterMain.Config config2 = ImporterMain$Config$.MODULE$.unapply(config);
                scala.collection.immutable.Seq<Path> seq = config2._1();
                Enumeration.Value value = config2._2();
                Path path = config2._3();
                scala.collection.immutable.Seq<Path> inputFiles = seq;
                Enumeration.Value format = value;
                Path outputFile = path;
                scala.collection.immutable.Seq nonExistent = (scala.collection.immutable.Seq)inputFiles.filterNot((Function1 & Serializable)_$1 -> Files.exists(_$1, new LinkOption[0]));
                if (nonExistent.nonEmpty()) {
                    throw new AssertionError((Object)("given input files " + nonExistent + " do not exist"));
                }
                Files.deleteIfExists(outputFile);
                Enumeration.Value value2 = format;
                Enumeration.Value value3 = package$Format$.MODULE$.GraphML();
                Enumeration.Value value4 = value2;
                if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                    importer = GraphMLImporter$.MODULE$;
                } else {
                    Enumeration.Value value5 = package$Format$.MODULE$.GraphSON();
                    Enumeration.Value value6 = value2;
                    if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                        importer = GraphSONImporter$.MODULE$;
                    } else {
                        throw new MatchError((Object)value2);
                    }
                }
                GraphMLImporter$ importer2 = importer;
                Config odbConfig = overflowdb.Config.withoutOverflow().withStorageLocation(outputFile);
                Using$.MODULE$.resource((Object)Graph.open((Config)odbConfig, (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)nodeFactories).asJava(), (List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)edgeFactories).asJava(), _$2 -> convertPropertyForPersistence.apply(_$2)), (Function1)(JProcedure1 & Serializable)graph -> importer2.runImport((Graph)graph, inputFiles), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                return;
            }
            throw new MatchError((Object)config);
        });
    }

    public Function1<Object, Object> apply$default$3() {
        return (Function1 & Serializable)x -> Predef$.MODULE$.identity(x);
    }

    private OParserBuilder<ImporterMain.Config> builder() {
        Object object = this.builder$lzy1;
        if (object instanceof OParserBuilder) {
            return (OParserBuilder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (OParserBuilder)this.builder$lzyINIT1();
    }

    private Object builder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.builder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    OParserBuilder oParserBuilder = null;
                    try {
                        oParserBuilder = OParser$.MODULE$.builder();
                        object2 = oParserBuilder == null ? LazyVals.NullValue$.MODULE$ : oParserBuilder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.builder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return oParserBuilder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private OParser<BoxedUnit, ImporterMain.Config> parser() {
        Object object = this.parser$lzy1;
        if (object instanceof OParser) {
            return (OParser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (OParser)this.parser$lzyINIT1();
    }

    private Object parser$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.parser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    OParser oParser = null;
                    try {
                        oParser = OParser$.MODULE$.sequence(this.builder().programName("odb-import"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OParser[]{this.builder().help("help").text("prints this usage text"), this.builder().opt('f', "format", Read$.MODULE$.stringRead()).required().action((Function2 & Serializable)(x, c) -> {
                            Enumeration.Value value = (Enumeration.Value)package$Format$.MODULE$.byNameLowercase().apply(x);
                            scala.collection.immutable.Seq<Path> seq = c.copy$default$1();
                            Path path = c.copy$default$3();
                            return c.copy(seq, value, path);
                        }).text("import format, one of [" + package$Format$.MODULE$.valuesAsStringLowercase().mkString("|") + "]"), this.builder().opt('o', "out", Read$.MODULE$.fileRead()).required().action((Function2 & Serializable)(x, c) -> {
                            Path path = x.toPath();
                            scala.collection.immutable.Seq<Path> seq = c.copy$default$1();
                            Enumeration.Value value = c.copy$default$2();
                            return c.copy(seq, value, path);
                        }).text("output file for overflowdb binary, e.g. out.odb"), this.builder().arg("inputFiles", Read$.MODULE$.fileRead()).required().unbounded().action((Function2 & Serializable)(x, c) -> c.copy((scala.collection.immutable.Seq<Path>)((scala.collection.immutable.Seq)c.inputFiles().$colon$plus((Object)x.toPath())), c.copy$default$2(), c.copy$default$3())).text("input files - must exist and be readable")}));
                        object2 = oParser == null ? LazyVals.NullValue$.MODULE$ : oParser;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.parser$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return oParser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

