/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphml;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import overflowdb.Edge;
import overflowdb.Element;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.ExportResult$;
import overflowdb.formats.Exporter;
import overflowdb.formats.graphml.package;
import overflowdb.formats.graphml.package$PropertyContext$;
import overflowdb.formats.graphml.package$Type$;
import overflowdb.formats.package$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;
import scala.xml.PrettyPrinter;
import scala.xml.Utility$;
import scala.xml.XML$;

public final class GraphMLExporter$
implements Exporter,
Serializable {
    public static final GraphMLExporter$ MODULE$ = new GraphMLExporter$();

    private GraphMLExporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLExporter$.class);
    }

    @Override
    public String defaultFileExtension() {
        return "xml";
    }

    @Override
    public ExportResult runExport(IterableOnce<Node> nodes, IterableOnce<Edge> edges, Path outputFile) {
        Path outFile = package$.MODULE$.resolveOutputFileSingle(outputFile, "export." + this.defaultFileExtension());
        Map nodePropertyContextById = (Map)Map$.MODULE$.empty();
        Map edgePropertyContextById = (Map)Map$.MODULE$.empty();
        AtomicInteger discardedListPropertyCount = new AtomicInteger(0);
        Seq nodeEntries = nodes.iterator().map((Function1 & Serializable)node -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<node id=\"" + node.id() + "\">\n         |    <data key=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel() + "\">" + node.label() + "</data>\n         |    " + MODULE$.dataEntries("node", (Element)node, (Map<String, package.PropertyContext>)nodePropertyContextById, discardedListPropertyCount) + "\n         |</node>\n         |"))).toSeq();
        Seq edgeEntries = edges.iterator().map((Function1 & Serializable)edge -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<edge source=\"" + edge.outNode().id() + "\" target=\"" + edge.inNode().id() + "\">\n         |    <data key=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel() + "\">" + edge.label() + "</data>\n         |    " + MODULE$.dataEntries("edge", (Element)edge, (Map<String, package.PropertyContext>)edgePropertyContextById, discardedListPropertyCount) + "\n         |</edge>\n         |"))).toSeq();
        String nodePropertyKeyEntries = this.propertyKeyXml$1("node", nodePropertyContextById);
        String edgePropertyKeyEntries = this.propertyKeyXml$1("edge", edgePropertyContextById);
        String xml = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n       |<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n       |  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n       |  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n       |    <key id=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel() + "\" for=\"node\" attr.name=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForNodeLabel() + "\" attr.type=\"string\"></key>\n       |    <key id=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel() + "\" for=\"edge\" attr.name=\"" + overflowdb.formats.graphml.package$.MODULE$.KeyForEdgeLabel() + "\" attr.type=\"string\"></key>\n       |    " + nodePropertyKeyEntries + "\n       |    " + edgePropertyKeyEntries + "\n       |    <graph id=\"G\" edgedefault=\"directed\">\n       |      " + nodeEntries.mkString(System.lineSeparator()) + "\n       |      " + edgeEntries.mkString(System.lineSeparator()) + "\n       |    </graph>\n       |</graphml>\n       |")).trim();
        package$.MODULE$.writeFile(outFile, xml);
        this.xmlFormatInPlace(outFile);
        Option additionalInfo = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)discardedListPropertyCount.get())).filter((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 > 0).map((Function1 & Serializable)count -> GraphMLExporter$.$anonfun$4(BoxesRunTime.unboxToInt((Object)count)));
        return ExportResult$.MODULE$.apply(nodeEntries.size(), edgeEntries.size(), (Seq<Path>)((Seq)((SeqOps)new .colon.colon((Object)outFile, (List)Nil$.MODULE$))), (Option<String>)additionalInfo);
    }

    private String dataEntries(String prefix, Element element, Map<String, package.PropertyContext> propertyContextById, AtomicInteger discardedListPropertyCount) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(element.propertiesMap()).asScala().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String propertyName = (String)tuple2._1();
                Object propertyValue = tuple2._2();
                if (package$.MODULE$.isList(propertyValue.getClass())) {
                    discardedListPropertyCount.incrementAndGet();
                    return "";
                }
                String encodedPropertyName = prefix + "__" + element.label() + "__" + propertyName;
                Enumeration.Value graphMLTpe = package$Type$.MODULE$.fromRuntimeClass(propertyValue.getClass());
                if (!propertyContextById.contains((Object)encodedPropertyName)) {
                    propertyContextById.update((Object)encodedPropertyName, (Object)package$PropertyContext$.MODULE$.apply(propertyName, graphMLTpe));
                }
                String xmlEncoded = Utility$.MODULE$.escape(propertyValue.toString());
                return "<data key=\"" + encodedPropertyName + "\">" + xmlEncoded + "</data>";
            }
            throw new MatchError((Object)tuple2);
        })).mkString(System.lineSeparator());
    }

    private void xmlFormatInPlace(Path xmlFile) {
        Elem xml = (Elem)XML$.MODULE$.loadFile(xmlFile.toFile());
        PrettyPrinter prettyPrinter = new PrettyPrinter(120, 2);
        String formatted = prettyPrinter.format((scala.xml.Node)xml, prettyPrinter.format$default$2());
        package$.MODULE$.writeFile(xmlFile, formatted);
    }

    private final String propertyKeyXml$1(String forAttr, Map propsMap) {
        return ((IterableOnceOps)propsMap.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                package.PropertyContext propertyContext = (package.PropertyContext)tuple2._2();
                String key = (String)tuple2._1();
                if (propertyContext != null) {
                    package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
                    String string = propertyContext2._1();
                    Enumeration.Value value = propertyContext2._2();
                    String name = string;
                    Enumeration.Value tpe = value;
                    return "<key id=\"" + key + "\" for=\"" + forAttr + "\" attr.name=\"" + name + "\" attr.type=\"" + tpe + "\"></key>";
                }
            }
            throw new MatchError((Object)tuple2);
        })).mkString(System.lineSeparator());
    }

    private static final /* synthetic */ String $anonfun$4(int count) {
        return "warning: discarded " + count + " list properties (because they are not supported by the graphml spec)";
    }
}

