/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.formats.graphml;

import java.io.Serializable;
import java.nio.file.Path;
import overflowdb.Graph;
import overflowdb.formats.Importer;
import overflowdb.formats.graphml.package;
import overflowdb.formats.graphml.package$;
import overflowdb.formats.graphml.package$PropertyContext$;
import overflowdb.formats.graphml.package$Type$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public final class GraphMLImporter$
implements Importer,
Serializable {
    public static final GraphMLImporter$ MODULE$ = new GraphMLImporter$();

    private GraphMLImporter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLImporter$.class);
    }

    @Override
    public void runImport(Graph graph, Seq<Path> inputFiles) {
        if (inputFiles.size() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)("input must be exactly one file, but got " + inputFiles.size()));
        }
        Elem doc = (Elem)XML$.MODULE$.loadFile(((Path)inputFiles.head()).toFile());
        NodeSeq keyEntries = doc.$bslash("key");
        NodeSeq graphXml = doc.$bslash("graph");
        Map<String, package.PropertyContext> nodePropertyContextById = this.parsePropertyEntries("node", keyEntries);
        graphXml.$bslash("node").foreach((Function1)(JProcedure1 & Serializable)node -> MODULE$.addNode(graph, (Node)node, nodePropertyContextById));
        Map<String, package.PropertyContext> edgePropertyContextById = this.parsePropertyEntries("edge", keyEntries);
        graphXml.$bslash("edge").foreach((Function1)(JProcedure1 & Serializable)edge -> MODULE$.addEdge(graph, (Node)edge, edgePropertyContextById));
    }

    private Map<String, package.PropertyContext> parsePropertyEntries(String forElementType, NodeSeq keyEntries) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)keyEntries.filter((Function1 & Serializable)_$1 -> {
            String string = _$1.$bslash$at("for");
            String string2 = forElementType;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).map((Function1 & Serializable)node -> {
            String id = node.$bslash$at("id");
            String name = node.$bslash$at("attr.name");
            String graphmlType = node.$bslash$at("attr.type");
            return Tuple2$.MODULE$.apply((Object)id, (Object)package$PropertyContext$.MODULE$.apply(name, package$Type$.MODULE$.withName(graphmlType)));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void addNode(Graph graph, Node node, Map<String, package.PropertyContext> propertyContextById) {
        String id2 = node.$bslash$at("id");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        node.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForNodeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                label$1.elem = Option$.MODULE$.apply((Object)value);
                return BoxedUnit.UNIT;
            }
            String key = string;
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.getOrElse((Object)key, () -> GraphMLImporter$.$anonfun$1(key));
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
            String string4 = propertyContext2._1();
            Enumeration.Value value2 = propertyContext2._2();
            String name = string4;
            Enumeration.Value tpe = value2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = MODULE$.convertValue(value, tpe2, node);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(id2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)id -> ((Option)label$2.elem).foreach((Function1 & Serializable)label -> graph.addNode(id, label, (Object[])Arrays$.MODULE$.seqToArray((Seq)keyValuePairs.result(), Object.class))));
    }

    private void addEdge(Graph graph, Node edge, Map<String, package.PropertyContext> propertyContextById) {
        String sourceId2 = edge.$bslash$at("source");
        String targetId = edge.$bslash$at("target");
        ObjectRef label = ObjectRef.create((Object)None$.MODULE$);
        Builder keyValuePairs = scala.package$.MODULE$.Seq().newBuilder();
        edge.$bslash("data").foreach((Function1 & Serializable)entry -> {
            String value = entry.text();
            String string = entry.$bslash$at("key");
            String string2 = package$.MODULE$.KeyForEdgeLabel();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                label$3.elem = Option$.MODULE$.apply((Object)value);
                return BoxedUnit.UNIT;
            }
            String key = string;
            package.PropertyContext propertyContext = (package.PropertyContext)propertyContextById.getOrElse((Object)key, () -> GraphMLImporter$.$anonfun$2(key));
            if (propertyContext == null) {
                throw new MatchError((Object)propertyContext);
            }
            package.PropertyContext propertyContext2 = package$PropertyContext$.MODULE$.unapply(propertyContext);
            String string4 = propertyContext2._1();
            Enumeration.Value value2 = propertyContext2._2();
            String name = string4;
            Enumeration.Value tpe = value2;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)tpe);
            String name2 = (String)tuple2._1();
            Enumeration.Value tpe2 = (Enumeration.Value)tuple2._2();
            Object convertedValue = MODULE$.convertValue(value, tpe2, edge);
            return keyValuePairs.addAll((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name2, convertedValue})));
        });
        StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(sourceId2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)sourceId -> Option$.MODULE$.apply((Object)graph.node(sourceId)).foreach((Function1)(JProcedure1 & Serializable)source -> StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(targetId)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)targetId -> Option$.MODULE$.apply((Object)graph.node(targetId)).foreach((Function1)(JProcedure1 & Serializable)target -> ((Option)label$7.elem).foreach((Function1 & Serializable)label -> source.addEdge(label, target, (Object[])Arrays$.MODULE$.seqToArray((Seq)keyValuePairs.result(), Object.class)))))));
    }

    private Object convertValue(String stringValue, Enumeration.Value tpe, Node context) {
        Try<Object> try_ = this.tryConvertScalarValue(stringValue, tpe);
        if (try_ instanceof Success) {
            Object value = ((Success)try_).value();
            return value;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            throw new AssertionError("unable to parse `" + stringValue + "` of tpe=" + tpe + ". context: " + context, e);
        }
        throw new MatchError(try_);
    }

    private Try<Object> tryConvertScalarValue(String stringValue, Enumeration.Value tpe) {
        return Try$.MODULE$.apply(() -> GraphMLImporter$.tryConvertScalarValue$$anonfun$1(tpe, stringValue));
    }

    private static final package.PropertyContext $anonfun$1(String key$1) {
        throw new AssertionError((Object)("key " + key$1 + " not found in propertyContext..."));
    }

    private static final package.PropertyContext $anonfun$2(String key$2) {
        throw new AssertionError((Object)("key " + key$2 + " not found in propertyContext..."));
    }

    private static final Object tryConvertScalarValue$$anonfun$1(Enumeration.Value tpe$1, String stringValue$1) {
        Enumeration.Value value = tpe$1;
        Enumeration.Value value2 = package$Type$.MODULE$.Boolean();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value4 = package$Type$.MODULE$.Int();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value6 = package$Type$.MODULE$.Long();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value8 = package$Type$.MODULE$.Float();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value10 = package$Type$.MODULE$.Double();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(stringValue$1)));
        }
        Enumeration.Value value12 = package$Type$.MODULE$.String();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return stringValue$1;
        }
        throw new MatchError((Object)value);
    }
}

