/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.passes.callgraph;

import io.appthreat.x2cpg.Defines$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.codepropertygraph.generated.traversal.CallTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.TypeDeclTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.TypeTraversalExtGen$;
import io.shiftleft.passes.CpgPass;
import io.shiftleft.passes.CpgPass$;
import io.shiftleft.semanticcpg.language.nodemethods.CallMethods$;
import io.shiftleft.semanticcpg.language.nodemethods.ExpressionMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import java.io.Serializable;
import overflowdb.BatchedUpdate;
import overflowdb.NodeDb;
import overflowdb.NodeOrDetachedNode;
import overflowdb.NodeRef;
import overflowdb.traversal.TraversalLogicExt$;
import overflowdb.traversal.TraversalSugarExt$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DynamicCallLinker
extends CpgPass {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DynamicCallLinker.class.getDeclaredField("methodMap$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DynamicCallLinker.class.getDeclaredField("typeMap$lzy1"));
    private final Cpg cpg;
    private volatile Object typeMap$lzy1;
    private volatile Object methodMap$lzy1;
    private final Map<String, LinkedHashSet<String>> methodCandidatesByFullName;
    private final Map<String, LinkedHashSet<String>> subclassCache;
    private final Map<String, LinkedHashSet<String>> superclassCache;

    public DynamicCallLinker(Cpg cpg) {
        this.cpg = cpg;
        super(cpg, CpgPass$.MODULE$.$lessinit$greater$default$2(), CpgPass$.MODULE$.$lessinit$greater$default$3());
        this.methodCandidatesByFullName = (Map)Map$.MODULE$.empty();
        this.subclassCache = (Map)Map$.MODULE$.empty();
        this.superclassCache = (Map)Map$.MODULE$.empty();
    }

    private scala.collection.immutable.Map<String, TypeDecl> typeMap() {
        Object object = this.typeMap$lzy1;
        if (object instanceof scala.collection.immutable.Map) {
            return (scala.collection.immutable.Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Map)this.typeMap$lzyINIT1();
    }

    private Object typeMap$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.typeMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Map map = null;
                    try {
                        map = package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().map((Function1 & Serializable)td -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)td.fullName());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, td);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.typeMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private scala.collection.immutable.Map<String, Method> methodMap() {
        Object object = this.methodMap$lzy1;
        if (object instanceof scala.collection.immutable.Map) {
            return (scala.collection.immutable.Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (scala.collection.immutable.Map)this.methodMap$lzyINIT1();
    }

    private Object methodMap$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.methodMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    scala.collection.immutable.Map map = null;
                    try {
                        map = package$.MODULE$.toNodeTypeStarters(this.cpg).method().filterNot((Function1 & Serializable)_$1 -> _$1.name().startsWith("<operator>")).map((Function1 & Serializable)m -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)m.fullName());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, m);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.methodMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        if (!package$.MODULE$.toNodeTypeStarters(this.cpg).call().exists((Function1 & Serializable)_$2 -> {
            String string = _$2.dispatchType();
            String string2 = "DYNAMIC_DISPATCH";
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            return;
        }
        this.buildMethodCandidates();
        this.subclassCache.clear();
        Iterator iterator = package$.MODULE$.toTraversalLogicExt((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).call());
        Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator, (Function1 & Serializable)_$3 -> {
            Iterator iterator = package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$3);
            return CallTraversalExtGen$.MODULE$.dispatchTypeExact$extension(iterator, "DYNAMIC_DISPATCH");
        }));
        List dynamicCalls = TraversalSugarExt$.MODULE$.l$extension(iterator2);
        dynamicCalls.grouped(10).foreach((Function1)(JProcedure1 & Serializable)callBatch -> {
            callBatch.foreach((Function1)(JProcedure1 & Serializable)call -> {
                try {
                    this.linkDynamicCall((Call)call, dstGraph);
                }
                catch (Exception ex) {
                    System.err.println("Error linking dynamic call " + call.code() + ": " + ex.getMessage());
                }
            });
            System.gc();
        });
    }

    private void buildMethodCandidates() {
        package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl().foreach((Function1)(JProcedure1 & Serializable)typeDecl -> typeDecl._methodViaAstOut().foreach((Function1)(JProcedure1 & Serializable)method -> {
            String methodName = method.fullName();
            LinkedHashSet candidates = (LinkedHashSet)this.allSubclasses(typeDecl.fullName()).flatMap((Function1 & Serializable)_$4 -> this.staticLookup((String)_$4, (Method)method));
            if (candidates.nonEmpty()) {
                this.methodCandidatesByFullName.put((Object)methodName, (Object)candidates);
                return;
            }
        }));
    }

    private LinkedHashSet<String> allSubclasses(String typeDeclFullName) {
        return this.inheritanceTraversal(typeDeclFullName, this.subclassCache, false);
    }

    private LinkedHashSet<String> allSuperClasses(String typeDeclFullName) {
        return this.inheritanceTraversal(typeDeclFullName, this.superclassCache, true);
    }

    private LinkedHashSet<String> inheritanceTraversal(String typDeclFullName, Map<String, LinkedHashSet<String>> cache, boolean inSuperDirection) {
        Option option = cache.get((Object)typDeclFullName);
        if (option instanceof Some) {
            LinkedHashSet classes = (LinkedHashSet)((Some)option).value();
            return classes;
        }
        if (None$.MODULE$.equals(option)) {
            Iterator iterator = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
            Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterator, typDeclFullName));
            LinkedHashSet total = (LinkedHashSet)TraversalSugarExt$.MODULE$.headOption$extension(iterator2).map((Function1 & Serializable)t -> this.traverseInheritance((TypeDecl)t, inSuperDirection, this.traverseInheritance$default$3())).getOrElse(DynamicCallLinker::$anonfun$4);
            cache.put((Object)typDeclFullName, (Object)total);
            return total;
        }
        throw new MatchError((Object)option);
    }

    private LinkedHashSet<String> traverseInheritance(TypeDecl current, boolean up, Set<TypeDecl> visited) {
        Iterator iterator;
        if (visited.contains((Object)current)) {
            return LinkedHashSet$.MODULE$.empty();
        }
        visited.$plus$eq((Object)current);
        if (up) {
            Iterator iterator2 = package$.MODULE$.toTypeTraversalExtGen((IterableOnce)current.inheritsFromOut());
            iterator = TypeTraversalExtGen$.MODULE$.referencedTypeDecl$extension(iterator2);
        } else {
            Iterator iterator3 = package$.MODULE$.toTypeTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typ());
            Iterator iterator4 = package$.MODULE$.toTraversalSugarExt((IterableOnce)TypeTraversalExtGen$.MODULE$.fullNameExact$extension(iterator3, current.fullName()).flatMap((Function1 & Serializable)_$5 -> _$5.inheritsFromIn()));
            iterator = TraversalSugarExt$.MODULE$.collectAll$extension(iterator4, ClassTag$.MODULE$.apply(TypeDecl.class));
        }
        Iterator nextNodes = iterator;
        LinkedHashSet result = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{current.fullName()}));
        nextNodes.foreach((Function1 & Serializable)t -> (LinkedHashSet)result.$plus$plus$eq(this.traverseInheritance((TypeDecl)t, up, visited)));
        return result;
    }

    private Set<TypeDecl> traverseInheritance$default$3() {
        return (Set)Set$.MODULE$.empty();
    }

    private Option<String> staticLookup(String subclass, Method baseMethod) {
        Option option = this.typeMap().get((Object)subclass);
        if (option instanceof Some) {
            TypeDecl sc = (TypeDecl)((Some)option).value();
            Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)sc._methodViaAstOut());
            Iterator iterator2 = package$.MODULE$.toTraversalLogicExt((IterableOnce)MethodTraversalExtGen$.MODULE$.nameExact$extension(iterator, baseMethod.name()));
            Iterator iterator3 = package$.MODULE$.toTraversalSugarExt((IterableOnce)TraversalLogicExt$.MODULE$.and$extension(iterator2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)_$6 -> {
                Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$6);
                return MethodTraversalExtGen$.MODULE$.signatureExact$extension(iterator, baseMethod.signature());
            }})).map((Function1 & Serializable)_$7 -> _$7.fullName()));
            return TraversalSugarExt$.MODULE$.headOption$extension(iterator3);
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private boolean resolveCallInSuperClasses(Call call) {
        String string = call.methodFullName();
        if ("<operator>.indirectFieldAccess".equals(string)) {
            return this.resolveIndirectFieldAccess(call);
        }
        return this.resolveRegularMethodInSuperclass(call);
    }

    private boolean resolveRegularMethodInSuperclass(Call call) {
        Tuple2<String, String> tuple2 = this.splitMethodSignature(call);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fullName = (String)tuple2._1();
        String signature = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fullName, (Object)signature);
        String fullName2 = (String)tuple22._1();
        String signature2 = (String)tuple22._2();
        String typeDeclFullName = fullName2.replace("." + call.name(), "");
        Iterator iterator = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
        Iterator iterator2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterator, (Seq)this.allSuperClasses(typeDeclFullName).toIndexedSeq()));
        Iterator iterator3 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)AstNodeTraversal$.MODULE$.astChildren$extension(iterator2));
        Iterator iterator4 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isMethod$extension(iterator3));
        Iterator iterator5 = package$.MODULE$.toTraversalLogicExt((IterableOnce)MethodTraversalExtGen$.MODULE$.nameExact$extension(iterator4, call.name()));
        Iterator iterator6 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)TraversalLogicExt$.MODULE$.and$extension(iterator5, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)_$8 -> {
            Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$8);
            return MethodTraversalExtGen$.MODULE$.signatureExact$extension(iterator, signature2);
        }})));
        Iterator iterator7 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator6));
        List candidates = TraversalSugarExt$.MODULE$.l$extension(iterator7);
        if (candidates.nonEmpty()) {
            this.methodCandidatesByFullName.put((Object)call.methodFullName(), (Object)((SetOps)this.methodCandidatesByFullName.getOrElse((Object)call.methodFullName(), DynamicCallLinker::resolveRegularMethodInSuperclass$$anonfun$1)).$plus$plus((IterableOnce)candidates));
            return true;
        }
        return false;
    }

    private boolean resolveIndirectFieldAccess(Call call) {
        Iterator iterator = package$.MODULE$.toTraversalSugarExt((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
        String calledMethodName = ((Expression)TraversalSugarExt$.MODULE$.last$extension(iterator)).code();
        Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
        Iterator iterator3 = package$.MODULE$.toTraversalSugarExt((IterableOnce)ExpressionMethods$.MODULE$.typ$extension(package$.MODULE$.toExpressionMethods((Expression)TraversalSugarExt$.MODULE$.head$extension(iterator2))));
        List fieldTypes = TraversalSugarExt$.MODULE$.l$extension(iterator3);
        fieldTypes.foreach((Function1)(JProcedure1 & Serializable)ft -> {
            LinkedHashSet subTypes = (LinkedHashSet)this.allSubclasses(ft.fullName()).filterNot((Function1 & Serializable)_$9 -> {
                String string = _$9;
                String string2 = ft.fullName();
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            if (subTypes.nonEmpty()) {
                Iterator iterator = package$.MODULE$.toTypeDeclTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).typeDecl());
                Iterator iterator2 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)TypeDeclTraversalExtGen$.MODULE$.fullNameExact$extension(iterator, (Seq)subTypes.toIndexedSeq()));
                Iterator iterator3 = package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)AstNodeTraversal$.MODULE$.astChildren$extension(iterator2));
                Iterator iterator4 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isMethod$extension(iterator3));
                Iterator iterator5 = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.name$extension(iterator4, calledMethodName));
                Iterator iterator6 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator5));
                List candidateMethods = TraversalSugarExt$.MODULE$.l$extension(iterator6);
                if (candidateMethods.nonEmpty()) {
                    this.methodCandidatesByFullName.put((Object)calledMethodName, (Object)((SetOps)this.methodCandidatesByFullName.getOrElse((Object)calledMethodName, DynamicCallLinker::resolveIndirectFieldAccess$$anonfun$1$$anonfun$1)).$plus$plus((IterableOnce)candidateMethods));
                    return;
                }
                return;
            }
        });
        return true;
    }

    private Tuple2<String, String> splitMethodSignature(Call call) {
        String fullName = call.methodFullName();
        int idx = fullName.contains(":") ? fullName.lastIndexOf(":") : fullName.lastIndexOf(".");
        return Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(fullName), idx), (Object)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(fullName), idx + 1));
    }

    private void linkDynamicCall(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        String string;
        if (!this.isValidCall(call)) {
            return;
        }
        boolean resolved = this.resolveCallInSuperClasses(call);
        if (call.methodFullName().startsWith("<operator>") && resolved) {
            Iterator iterator = package$.MODULE$.toTraversalSugarExt((IterableOnce)CallMethods$.MODULE$.argument$extension(package$.MODULE$.toCallMethods(call)));
            string = ((Expression)TraversalSugarExt$.MODULE$.last$extension(iterator)).code();
        } else {
            string = call.methodFullName();
        }
        String methodNameToUse = string;
        Option option = this.methodCandidatesByFullName.get((Object)methodNameToUse);
        if (option instanceof Some) {
            LinkedHashSet targets = (LinkedHashSet)((Some)option).value();
            Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)call.callOut());
            Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator));
            scala.collection.immutable.Set existingEdges = TraversalSugarExt$.MODULE$.toSetImmutable$extension(iterator2);
            scala.collection.immutable.Set targetMethods = ((IterableOnceOps)targets.flatMap((Function1 & Serializable)fullName -> this.resolveMethod((String)fullName))).toSet();
            Tuple2 tuple2 = targetMethods.partition((Function1 & Serializable)_$10 -> _$10.isExternal());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Set externalMethods = (scala.collection.immutable.Set)tuple2._1();
            scala.collection.immutable.Set internalMethods = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)externalMethods, (Object)internalMethods);
            scala.collection.immutable.Set externalMethods2 = (scala.collection.immutable.Set)tuple22._1();
            scala.collection.immutable.Set internalMethods2 = (scala.collection.immutable.Set)tuple22._2();
            scala.collection.immutable.Set finalTargets = externalMethods2.nonEmpty() && internalMethods2.nonEmpty() ? internalMethods2 : targetMethods;
            finalTargets.foreach((Function1 & Serializable)tgt -> {
                if (!existingEdges.contains((Object)tgt.fullName())) {
                    return dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)tgt, "CALL");
                }
                this.fallbackToStaticResolution(call, dstGraph);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.fallbackToStaticResolution(call, dstGraph);
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidCall(Call call) {
        String string = call.methodFullName();
        String string2 = "<empty>";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = call.methodFullName();
        String string4 = Defines$.MODULE$.DynamicCallUnknownFullName();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    private Option<Method> resolveMethod(String fullName) {
        if (this.cpg.graph().indexManager.isIndexed("FULL_NAME")) {
            return this.methodFullNameToNode(fullName);
        }
        Iterator iterator = package$.MODULE$.toMethodTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(this.cpg).method());
        Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MethodTraversalExtGen$.MODULE$.fullNameExact$extension(iterator, fullName));
        return TraversalSugarExt$.MODULE$.headOption$extension(iterator2);
    }

    private void fallbackToStaticResolution(Call call, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Option option = this.methodMap().get((Object)call.methodFullName());
        if (option instanceof Some) {
            Method target = (Method)((Some)option).value();
            dstGraph.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)target, "CALL");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private Option<Method> methodFullNameToNode(String fullName) {
        return this.nodesWithFullName(fullName).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NodeRef x) {
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method m = (Method)nodeRef;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NodeRef x, Function1 function1) {
                NodeRef nodeRef = x;
                if (nodeRef instanceof Method) {
                    Method m = (Method)nodeRef;
                    return m;
                }
                return function1.apply((Object)x);
            }
        });
    }

    private Iterable<NodeRef<? extends NodeDb>> nodesWithFullName(String name) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.cpg.graph().indexManager.lookup("FULL_NAME", (Object)name)).asScala();
    }

    private static final LinkedHashSet $anonfun$4() {
        return LinkedHashSet$.MODULE$.empty();
    }

    private static final LinkedHashSet resolveRegularMethodInSuperclass$$anonfun$1() {
        return LinkedHashSet$.MODULE$.empty();
    }

    private static final LinkedHashSet resolveIndirectFieldAccess$$anonfun$1$$anonfun$1() {
        return LinkedHashSet$.MODULE$.empty();
    }
}

