/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.passes.frontend;

import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile$;
import io.shiftleft.codepropertygraph.generated.traversal.MetaDataTraversalExtGen$;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.traversal.TraversalSugarExt$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public abstract class XConfigFileCreationPass
extends ConcurrentWriterCpgPass<File> {
    private final Logger logger = LoggerFactory.getLogger((Class)this.getClass());
    private final String rootDir;

    public XConfigFileCreationPass(Cpg cpg) {
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        Iterator iterator = package$.MODULE$.toMetaDataTraversalExtGen((IterableOnce)package$.MODULE$.toNodeTypeStarters(cpg).metaData());
        Iterator iterator2 = package$.MODULE$.toTraversalSugarExt((IterableOnce)MetaDataTraversalExtGen$.MODULE$.root$extension(iterator));
        this.rootDir = (String)TraversalSugarExt$.MODULE$.headOption$extension(iterator2).getOrElse(XConfigFileCreationPass::$init$$$anonfun$1);
    }

    public abstract List<Function1<File, Object>> configFileFilters();

    public File[] generateParts() {
        if (this.rootDir.isBlank()) {
            this.logger.debug("Unable to recover project directory for configuration file pass.");
            return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
        }
        Try try_ = Try$.MODULE$.apply(this::generateParts$$anonfun$1);
        if (try_ instanceof Success) {
            File file2 = (File)((Success)try_).value();
            File file3 = file2;
            if (file3.isDirectory(file3.isDirectory$default$1())) {
                return (File[])file3.listRecursively(file3.listRecursively$default$1()).filter((Function1 & Serializable)file -> this.isConfigFile((File)file)).toArray(ClassTag$.MODULE$.apply(File.class));
            }
            File file4 = file2;
            if (this.isConfigFile(file4)) {
                return new File[]{file4};
            }
        }
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, File file) {
        Try try_ = Try$.MODULE$.apply(() -> XConfigFileCreationPass.runOnPart$$anonfun$1(file));
        if (try_ instanceof Success) {
            String content = (String)((Success)try_).value();
            String name = this.configFileName(file);
            NewConfigFile configNode = NewConfigFile$.MODULE$.apply().name(name).content(content);
            this.logger.debug("Adding config file " + name);
            diffGraph.addNode((DetachedNodeData)configNode);
            return;
        }
        if (try_ instanceof Failure) {
            Throwable error = ((Failure)try_).exception();
            this.logger.debug("Unable to create config file node for " + file.canonicalPath() + ": " + error);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private String configFileName(File configFile) {
        return (String)Try$.MODULE$.apply(this::configFileName$$anonfun$1).map((Function1 & Serializable)_$1 -> _$1.relativize(configFile.path().toAbsolutePath()).toString()).orElse(() -> XConfigFileCreationPass.configFileName$$anonfun$3(configFile)).getOrElse(() -> XConfigFileCreationPass.configFileName$$anonfun$4(configFile));
    }

    public boolean extensionFilter(String extension, File file) {
        return file.extension().contains((Object)extension);
    }

    public boolean pathEndFilter(String pathEnd, File file) {
        return file.canonicalPath().endsWith(pathEnd);
    }

    public boolean pathRegexFilter(String pathRegex, File file) {
        return file.canonicalPath().matches(pathRegex);
    }

    private boolean isConfigFile(File file) {
        return this.configFileFilters().exists((Function1 & Serializable)predicate -> BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)file)));
    }

    private static final String $init$$$anonfun$1() {
        return "<empty>";
    }

    private final File generateParts$$anonfun$1() {
        return File$.MODULE$.apply(this.rootDir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private static final String runOnPart$$anonfun$1(File file$1) {
        return IOUtils$.MODULE$.readEntireFile(file$1.path());
    }

    private final Path configFileName$$anonfun$1() {
        return Paths.get(this.rootDir, new String[0]).toAbsolutePath();
    }

    private static final String configFileName$$anonfun$3$$anonfun$1(File configFile$3) {
        return configFile$3.pathAsString();
    }

    private static final Try configFileName$$anonfun$3(File configFile$2) {
        return Try$.MODULE$.apply(() -> XConfigFileCreationPass.configFileName$$anonfun$3$$anonfun$1(configFile$2));
    }

    private static final String configFileName$$anonfun$4(File configFile$4) {
        return configFile$4.name();
    }
}

