/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.passes.taggers;

import io.circe.Decoder$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.traversal.CallTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.ConfigFileTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.FileTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.MetaDataTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.MethodParameterInTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.MethodTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.StoredNodeTraversalExtGen$;
import io.shiftleft.passes.CpgPass;
import io.shiftleft.passes.CpgPass$;
import io.shiftleft.semanticcpg.language.NodeSteps$;
import io.shiftleft.semanticcpg.language.callgraphextension.MethodTraversal$;
import io.shiftleft.semanticcpg.language.operatorextension.OpAstNodeTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.CallTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.ExpressionTraversal$;
import java.io.File;
import java.io.Serializable;
import java.util.regex.Pattern;
import overflowdb.BatchedUpdate;
import overflowdb.traversal.TraversalLogicExt$;
import overflowdb.traversal.TraversalSugarExt$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public class ChennaiTagsPass
extends CpgPass {
    private final Cpg atom;
    private final String FRAMEWORK_ROUTE;
    private final String FRAMEWORK_INPUT;
    private final String FRAMEWORK_OUTPUT;
    private final String RE_CHARS;
    private final Regex[] PYTHON_ROUTES_CALL_REGEXES;
    private final String[] PYTHON_ROUTES_DECORATORS_REGEXES;
    private final String[] PHP_ROUTES_METHODS_REGEXES;
    private final String HTTP_METHODS_REGEX;
    private final String CHENNAI_CONFIG_FILE;

    public ChennaiTagsPass(Cpg atom) {
        this.atom = atom;
        super(atom, CpgPass$.MODULE$.$lessinit$greater$default$2(), CpgPass$.MODULE$.$lessinit$greater$default$3());
        this.FRAMEWORK_ROUTE = "framework-route";
        this.FRAMEWORK_INPUT = "framework-input";
        this.FRAMEWORK_OUTPUT = "framework-output";
        String EscapedFileSeparator = Pattern.quote(File.separator);
        this.RE_CHARS = "[](){}*+&|?.,\\$";
        this.PYTHON_ROUTES_CALL_REGEXES = new Regex[]{StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("django" + EscapedFileSeparator + "(conf" + EscapedFileSeparator + ")?urls.py:<module>.(path|re_path|url).*")), StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*(route|web\\.|add_resource).*"))};
        this.PYTHON_ROUTES_DECORATORS_REGEXES = new String[]{".*(route|endpoint|_request|require_http_methods|require_GET|require_POST|require_safe|_required|api\\.doc|api\\.response|api\\.errorhandler)\\(.*", ".*def\\s(get|post|put)\\(.*"};
        this.PHP_ROUTES_METHODS_REGEXES = new String[]{".*(router|routes|r|app|map)->(addRoute|add|before|mount|get|post|put|delete|head|option).*", ".*(Router)::(scope|connect|get|post|put|delete|head|option).*"};
        this.HTTP_METHODS_REGEX = ".*(request|session)\\.(args|get|post|put|form).*";
        this.CHENNAI_CONFIG_FILE = "chennai.json";
    }

    private String language() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMetaDataTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).metaData());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)MetaDataTraversalExtGen$.MODULE$.language$extension(iterator));
        return (String)TraversalSugarExt$.MODULE$.headOption$extension(iterator2).getOrElse(ChennaiTagsPass::language$$anonfun$1);
    }

    public void run(BatchedUpdate.DiffGraphBuilder dstGraph) {
        this.tagFrameworkRoutes(dstGraph);
        this.processChennaiConfig(dstGraph);
    }

    private void tagFrameworkRoutes(BatchedUpdate.DiffGraphBuilder dstGraph) {
        String lang;
        String lang2;
        String string;
        block11: {
            block10: {
                String lang3;
                block9: {
                    block8: {
                        String lang4;
                        String string2 = lang4 = (string = this.language());
                        String string3 = "PYTHON";
                        if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block8;
                        String string4 = lang4;
                        String string5 = "PYTHONSRC";
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block9;
                    }
                    this.tagPythonRoutes(dstGraph);
                    return;
                }
                String string6 = lang3 = string;
                String string7 = "NEWC";
                if (!(string6 == null ? string7 != null : !string6.equals(string7))) break block10;
                String string8 = lang3;
                String string9 = "C";
                if (string8 != null ? !string8.equals(string9) : string9 != null) break block11;
            }
            this.tagCRoutes(dstGraph);
            return;
        }
        String string10 = lang2 = string;
        String string11 = "PHP";
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            this.tagPhpRoutes(dstGraph);
            return;
        }
        String string12 = lang = string;
        String string13 = "RUBYSRC";
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            this.tagRubyRoutes(dstGraph);
            return;
        }
    }

    private void tagCRoutes(BatchedUpdate.DiffGraphBuilder dstGraph) {
        Object[] cRoutePatterns = new String[]{"Routes::(Post|Get|Delete|Head|Options|Put).*", "API_CALL", "API_CALL_ASYNC", "ENDPOINT", "ENDPOINT_ASYNC", "ENDPOINT_INTERCEPTOR", "ENDPOINT_INTERCEPTOR_ASYNC", "registerHandler", "PATH_ADD", "ADD_METHOD_TO", "ADD_METHOD_VIA_REGEX", "WS_PATH_ADD", "svr\\.(Post|Get|Delete|Head|Options|Put)"};
        Object object = Predef$.MODULE$.refArrayOps(cRoutePatterns);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)pattern -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator, pattern));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator2));
            NodeSteps$.MODULE$.newTagNode$extension(iterator3, this.FRAMEWORK_INPUT).store(dstGraph);
            Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).call());
            Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator4, (Function1 & Serializable)_$1 -> {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$1);
                return CallTraversalExtGen$.MODULE$.methodFullName$extension(iterator, pattern);
            }))));
            Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)AstNodeTraversal$.MODULE$.isLiteral$extension(iterator5));
            NodeSteps$.MODULE$.newTagNode$extension(iterator6, this.FRAMEWORK_ROUTE).store(dstGraph);
        });
    }

    private void tagPythonRoutes(BatchedUpdate.DiffGraphBuilder dstGraph) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.PYTHON_ROUTES_CALL_REGEXES);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)regex -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).call());
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator, (Function1 & Serializable)_$2 -> {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$2);
                return CallTraversalExtGen$.MODULE$.methodFullName$extension(iterator, regex.toString());
            }))));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)AstNodeTraversal$.MODULE$.isLiteral$extension(iterator2));
            NodeSteps$.MODULE$.newTagNode$extension(iterator3, this.FRAMEWORK_ROUTE).store(dstGraph);
        });
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.PYTHON_ROUTES_DECORATORS_REGEXES);
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)pattern -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).methodRef());
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toStoredNodeTraversalExtGen((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator, (Function1 & Serializable)_$3 -> {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toExpression((IterableOnce)_$3);
                Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)ExpressionTraversal$.MODULE$.inCall$extension(iterator));
                return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator2, pattern)));
            }));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)StoredNodeTraversalExtGen$.MODULE$._refOut$extension(iterator2));
            Iterator decoratedMethods = TraversalSugarExt$.MODULE$.collectAll$extension(iterator3, ClassTag$.MODULE$.apply(Method.class));
            Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toOpAstNodeTrav(MethodTraversal$.MODULE$.call$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToMethodTravCallGraphExt((IterableOnce)decoratedMethods)));
            Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)OpAstNodeTraversal$.MODULE$.assignment$extension(iterator4));
            Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator5, this.HTTP_METHODS_REGEX))));
            Iterator iterator7 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)AstNodeTraversal$.MODULE$.isIdentifier$extension(iterator6));
            NodeSteps$.MODULE$.newTagNode$extension(iterator7, this.FRAMEWORK_INPUT).store(dstGraph);
            Iterator iterator8 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)decoratedMethods);
            NodeSteps$.MODULE$.newTagNode$extension(iterator8, this.FRAMEWORK_INPUT).store(dstGraph);
            Iterator iterator9 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)decoratedMethods);
            Iterator iterator10 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator9));
            NodeSteps$.MODULE$.newTagNode$extension(iterator10, this.FRAMEWORK_INPUT).store(dstGraph);
        });
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).file());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)FileTraversalExtGen$.MODULE$.name$extension(iterator, ".*views.py.*"));
        Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)FileTraversalExtGen$.MODULE$.method$extension(iterator2));
        Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator3));
        Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.name$extension(iterator4, "request"));
        Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.method$extension(iterator5));
        NodeSteps$.MODULE$.newTagNode$extension(iterator6, this.FRAMEWORK_INPUT).store(dstGraph);
        Iterator iterator7 = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).file());
        Iterator iterator8 = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)FileTraversalExtGen$.MODULE$.name$extension(iterator7, ".*controllers.*.py.*"));
        Iterator iterator9 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)FileTraversalExtGen$.MODULE$.method$extension(iterator8));
        Iterator controllerMethods = MethodTraversalExtGen$.MODULE$.name$extension(iterator9, "get|post|put|delete|head|option");
        Iterator iterator10 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)controllerMethods);
        Iterator iterator11 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator10).filterNot((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = "self";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        NodeSteps$.MODULE$.newTagNode$extension(iterator11, this.FRAMEWORK_INPUT).store(dstGraph);
        Iterator iterator12 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)controllerMethods);
        Iterator iterator13 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.methodReturn$extension(iterator12));
        NodeSteps$.MODULE$.newTagNode$extension(iterator13, this.FRAMEWORK_OUTPUT).store(dstGraph);
    }

    private void tagPhpRoutes(BatchedUpdate.DiffGraphBuilder dstGraph) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.PHP_ROUTES_METHODS_REGEXES);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)pattern -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator, pattern));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator2));
            NodeSteps$.MODULE$.newTagNode$extension(iterator3, this.FRAMEWORK_INPUT).store(dstGraph);
            Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).call());
            Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator4, (Function1 & Serializable)_$5 -> {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)_$5);
                return CallTraversalExtGen$.MODULE$.methodFullName$extension(iterator, pattern);
            }))));
            Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)AstNodeTraversal$.MODULE$.isLiteral$extension(iterator5));
            NodeSteps$.MODULE$.newTagNode$extension(iterator6, this.FRAMEWORK_ROUTE).store(dstGraph);
        });
    }

    private void tagRubyRoutes(BatchedUpdate.DiffGraphBuilder dstGraph) {
        String railsRoutePrefix = ".*(get|post|put|delete|head|option|resources|namespace)\\s('|\").*";
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
        Iterator railsRoutes = TraversalLogicExt$.MODULE$.where$extension(iterator, (Function1 & Serializable)_$6 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)_$6);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.filename$extension(iterator, "config/routes.rb"));
            return MethodTraversalExtGen$.MODULE$.code$extension(iterator2, railsRoutePrefix);
        });
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)railsRoutes);
        NodeSteps$.MODULE$.newTagNode$extension(iterator2, this.FRAMEWORK_ROUTE).store(dstGraph);
        Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)railsRoutes);
        Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator3));
        NodeSteps$.MODULE$.newTagNode$extension(iterator4, this.FRAMEWORK_INPUT).store(dstGraph);
        Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
        Iterator railsControllers = MethodTraversalExtGen$.MODULE$.filename$extension(iterator5, ".*controller.rb.*");
        Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)railsControllers);
        Iterator iterator7 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator6));
        NodeSteps$.MODULE$.newTagNode$extension(iterator7, this.FRAMEWORK_INPUT).store(dstGraph);
        Iterator iterator8 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)railsControllers);
        Iterator iterator9 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.methodReturn$extension(iterator8));
        NodeSteps$.MODULE$.newTagNode$extension(iterator9, this.FRAMEWORK_OUTPUT).store(dstGraph);
        String sinatraRoutePrefix = "(app\\.namespace|app\\.)?(get|post|delete|head|options|put)\\s('|\").*";
        Iterator iterator10 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
        Iterator sinatraRoutes = MethodTraversalExtGen$.MODULE$.code$extension(iterator10, sinatraRoutePrefix);
        Iterator iterator11 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)sinatraRoutes);
        NodeSteps$.MODULE$.newTagNode$extension(iterator11, this.FRAMEWORK_ROUTE).store(dstGraph);
        Iterator iterator12 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)sinatraRoutes);
        Iterator iterator13 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator12));
        NodeSteps$.MODULE$.newTagNode$extension(iterator13, this.FRAMEWORK_INPUT).store(dstGraph);
        Iterator iterator14 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)sinatraRoutes);
        Iterator iterator15 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.methodReturn$extension(iterator14));
        NodeSteps$.MODULE$.newTagNode$extension(iterator15, this.FRAMEWORK_OUTPUT).store(dstGraph);
    }

    private void processChennaiConfig(BatchedUpdate.DiffGraphBuilder dstGraph) {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toConfigFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).configFile(this.CHENNAI_CONFIG_FILE));
        ConfigFileTraversalExtGen$.MODULE$.content$extension(iterator).foreach((Function1)(JProcedure1 & Serializable)configData -> {
            Either either = io.circe.parser.package$.MODULE$.parse(configData);
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                Vector tags = (Vector)json.hcursor().downField("tags").focus().flatMap((Function1 & Serializable)_$7 -> _$7.asArray()).getOrElse(ChennaiTagsPass::$anonfun$4);
                tags.foreach((Function1)(JProcedure1 & Serializable)_$8 -> this.processTag((Json)_$8, dstGraph));
                return;
            }
            if (either instanceof Left) {
                ParsingFailure error = (ParsingFailure)((Left)either).value();
                System.err.println("Failed to parse Chennai config: " + error);
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    private void processTag(Json tagJson, BatchedUpdate.DiffGraphBuilder dstGraph) {
        HCursor cursor = tagJson.hcursor();
        String tagName = (String)cursor.downField("name").as(Decoder$.MODULE$.decodeString()).getOrElse(ChennaiTagsPass::$anonfun$5);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(tagName))) {
            this.processTagParameters(cursor, tagName, dstGraph);
            this.processTagMethods(cursor, tagName, dstGraph);
            this.processTagTypes(cursor, tagName, dstGraph);
            this.processTagFiles(cursor, tagName, dstGraph);
            return;
        }
    }

    private void processTagParameters(HCursor cursor, String tagName, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Vector parameters = (Vector)cursor.downField("parameters").focus().flatMap((Function1 & Serializable)_$9 -> _$9.asArray()).getOrElse(ChennaiTagsPass::$anonfun$7);
        parameters.foreach((Function1)(JProcedure1 & Serializable)param -> param.asString().foreach((Function1)(JProcedure1 & Serializable)paramName -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(paramName))) {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator));
                Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.typeFullNameExact$extension(iterator2, paramName));
                NodeSteps$.MODULE$.newTagNode$extension(iterator3, tagName).store(dstGraph);
                if (!this.containsRegex((String)paramName)) {
                    Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                    Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator4));
                    Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.typeFullName$extension(iterator5, ".*" + Pattern.quote(paramName) + ".*"));
                    NodeSteps$.MODULE$.newTagNode$extension(iterator6, tagName).store(dstGraph);
                    return;
                }
                return;
            }
        }));
    }

    private void processTagMethods(HCursor cursor, String tagName, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Vector methods = (Vector)cursor.downField("methods").focus().flatMap((Function1 & Serializable)_$10 -> _$10.asArray()).getOrElse(ChennaiTagsPass::$anonfun$9);
        methods.foreach((Function1)(JProcedure1 & Serializable)method -> method.asString().foreach((Function1)(JProcedure1 & Serializable)methodName -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(methodName))) {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.fullNameExact$extension(iterator, methodName));
                NodeSteps$.MODULE$.newTagNode$extension(iterator2, tagName).store(dstGraph);
                if (!this.containsRegex((String)methodName)) {
                    Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                    Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodTraversalExtGen$.MODULE$.fullName$extension(iterator3, ".*" + Pattern.quote(methodName) + ".*"));
                    NodeSteps$.MODULE$.newTagNode$extension(iterator4, tagName).store(dstGraph);
                    return;
                }
                return;
            }
        }));
    }

    private void processTagTypes(HCursor cursor, String tagName, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Vector types = (Vector)cursor.downField("types").focus().flatMap((Function1 & Serializable)_$11 -> _$11.asArray()).getOrElse(ChennaiTagsPass::$anonfun$11);
        types.foreach((Function1)(JProcedure1 & Serializable)typ -> typ.asString().foreach((Function1)(JProcedure1 & Serializable)typeName -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(typeName))) {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator));
                Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.typeFullNameExact$extension(iterator2, typeName));
                NodeSteps$.MODULE$.newTagNode$extension(iterator3, tagName).store(dstGraph);
                if (!this.containsRegex((String)typeName)) {
                    Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).method());
                    Iterator iterator5 = io.shiftleft.semanticcpg.language.package$.MODULE$.toMethodParameterInTraversalExtGen((IterableOnce)MethodTraversalExtGen$.MODULE$.parameter$extension(iterator4));
                    Iterator iterator6 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)MethodParameterInTraversalExtGen$.MODULE$.typeFullName$extension(iterator5, ".*" + Pattern.quote(typeName) + ".*"));
                    NodeSteps$.MODULE$.newTagNode$extension(iterator6, tagName).store(dstGraph);
                }
                Iterator iterator7 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).call());
                Iterator iterator8 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)CallTraversalExtGen$.MODULE$.typeFullNameExact$extension(iterator7, typeName));
                NodeSteps$.MODULE$.newTagNode$extension(iterator8, tagName).store(dstGraph);
                if (!typeName.contains("[") && !typeName.contains("*")) {
                    Iterator iterator9 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).call());
                    Iterator iterator10 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)CallTraversalExtGen$.MODULE$.typeFullName$extension(iterator9, ".*" + Pattern.quote(typeName) + ".*"));
                    NodeSteps$.MODULE$.newTagNode$extension(iterator10, tagName).store(dstGraph);
                    return;
                }
                return;
            }
        }));
    }

    private void processTagFiles(HCursor cursor, String tagName, BatchedUpdate.DiffGraphBuilder dstGraph) {
        Vector files = (Vector)cursor.downField("files").focus().flatMap((Function1 & Serializable)_$12 -> _$12.asArray()).getOrElse(ChennaiTagsPass::$anonfun$13);
        files.foreach((Function1)(JProcedure1 & Serializable)file -> file.asString().foreach((Function1)(JProcedure1 & Serializable)fileName -> {
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fileName))) {
                Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).file());
                Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)FileTraversalExtGen$.MODULE$.nameExact$extension(iterator, fileName));
                NodeSteps$.MODULE$.newTagNode$extension(iterator2, tagName).store(dstGraph);
                if (!this.containsRegex((String)fileName)) {
                    Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.atom).file());
                    Iterator iterator4 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToNodeSteps((IterableOnce)FileTraversalExtGen$.MODULE$.name$extension(iterator3, ".*" + Pattern.quote(fileName) + ".*"));
                    NodeSteps$.MODULE$.newTagNode$extension(iterator4, tagName).store(dstGraph);
                    return;
                }
                return;
            }
        }));
    }

    private boolean containsRegex(String str) {
        return StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)x$0 -> this.containsRegex$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$0)));
    }

    private static final String language$$anonfun$1() {
        return "";
    }

    private static final Vector $anonfun$4() {
        return package$.MODULE$.Vector().empty();
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final Vector $anonfun$7() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Vector $anonfun$9() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Vector $anonfun$11() {
        return package$.MODULE$.Vector().empty();
    }

    private static final Vector $anonfun$13() {
        return package$.MODULE$.Vector().empty();
    }

    private final /* synthetic */ boolean containsRegex$$anonfun$1(char x$0) {
        return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.RE_CHARS), x$0);
    }
}

