/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.utils;

import io.appthreat.x2cpg.utils.FileUtil;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public final class FileUtil$
implements Serializable {
    public static final FileUtil$ MODULE$ = new FileUtil$();

    private FileUtil$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileUtil$.class);
    }

    public Path newTemporaryFile(String prefix, String suffix, Option<Path> parent) {
        Option<Path> option = parent;
        if (option instanceof Some) {
            Path dir = (Path)((Some)option).value();
            return Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
        }
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    public String newTemporaryFile$default$1() {
        return "";
    }

    public String newTemporaryFile$default$2() {
        return "";
    }

    public Option<Path> newTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <U> void usingTemporaryFile(String prefix, String suffix, Option<Path> parent, Function1<Path, U> f) {
        Path file = this.newTemporaryFile(prefix, suffix, parent);
        try {
            f.apply((Object)file);
        }
        finally {
            this.delete(file, true, this.delete$default$3());
        }
    }

    public <U> String usingTemporaryFile$default$1() {
        return "";
    }

    public <U> String usingTemporaryFile$default$2() {
        return "";
    }

    public <U> Option<Path> usingTemporaryFile$default$3() {
        return None$.MODULE$;
    }

    public <T> T usingTemporaryDirectory(String prefix, Function1<Path, T> f) {
        Object object;
        Path file = Files.createTempDirectory(prefix, new FileAttribute[0]);
        try {
            object = f.apply((Object)file);
        }
        catch (Throwable throwable) {
            try {
                this.delete(file, true, this.delete$default$3());
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object object2 = object;
        try {
            this.delete(file, true, this.delete$default$3());
        }
        catch (Exception exception) {}
        return (T)object2;
    }

    public <T> String usingTemporaryDirectory$default$1() {
        return "";
    }

    public void copyFiles(Path from, Path to) {
        if (Files.isDirectory(to, new LinkOption[0])) {
            this.PathExt(from).copyToDirectory(to);
            return;
        }
        this.PathExt(from).copyTo(to, StandardCopyOption.REPLACE_EXISTING);
    }

    public void deleteOnExit(Path file, boolean swallowIOExceptions, LinkOption linkOptions) {
        block3: {
            try {
                if (Files.isDirectory(file, linkOptions)) {
                    List children = (List)Using$.MODULE$.resource(Files.newDirectoryStream(file), (Function1 & Serializable)dirStream -> CollectionConverters$.MODULE$.IteratorHasAsScala(dirStream.iterator()).asScala().toList(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    children.foreach((Function1)(JProcedure1 & Serializable)x -> MODULE$.deleteOnExit((Path)x, swallowIOExceptions, linkOptions));
                }
                file.toFile().deleteOnExit();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && swallowIOExceptions) break block3;
                throw throwable;
            }
        }
    }

    public boolean deleteOnExit$default$2() {
        return false;
    }

    public LinkOption deleteOnExit$default$3() {
        return LinkOption.NOFOLLOW_LINKS;
    }

    public void delete(Path file, boolean swallowIoExceptions, LinkOption linkOptions) {
        block3: {
            try {
                if (Files.isDirectory(file, linkOptions)) {
                    List children = (List)Using$.MODULE$.resource(Files.newDirectoryStream(file), (Function1 & Serializable)dirStream -> CollectionConverters$.MODULE$.IteratorHasAsScala(dirStream.iterator()).asScala().toList(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    children.foreach((Function1)(JProcedure1 & Serializable)child -> MODULE$.delete((Path)child, swallowIoExceptions, linkOptions));
                }
                Files.deleteIfExists(file);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && swallowIoExceptions) break block3;
                throw throwable;
            }
        }
    }

    public boolean delete$default$2() {
        return false;
    }

    public LinkOption delete$default$3() {
        return LinkOption.NOFOLLOW_LINKS;
    }

    public void writeBytes(Path file, Iterable<Object> content, int bufferSize) {
        Using.Manager$.MODULE$.apply((Function1)(JProcedure1 & Serializable)use -> {
            OutputStream fos = (OutputStream)use.apply((Object)Files.newOutputStream(file, new OpenOption[0]), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            BufferedOutputStream bos = (BufferedOutputStream)use.apply((Object)new BufferedOutputStream(fos), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            content.grouped(bufferSize).foreach((Function1)(JProcedure1 & Serializable)buffer -> bos.write((byte[])buffer.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
            bos.flush();
        });
    }

    public int writeBytes$default$3() {
        return 8192;
    }

    public final FileUtil.PathExt PathExt(Path p) {
        return new FileUtil.PathExt(p);
    }

    public static final Object io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$copyToDirectory$$anonfun$1(Path destination$1) {
        return destination$1 + " must be a directory";
    }

    public static final Object io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$mergeDirectory$$anonfun$1(Path directory$1) {
        return directory$1 + " must be a directory";
    }

    public static final /* synthetic */ boolean io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$mergeDirectory$$anonfun$2(Path _$1) {
        return Files.isRegularFile(_$1, new LinkOption[0]);
    }

    public static final /* synthetic */ boolean io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$unzipTo$default$2$$anonfun$1(ZipEntry _$2) {
        return true;
    }

    public static final /* synthetic */ long io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$size$$anonfun$1(Path f) {
        long l;
        try {
            l = Files.size(f);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException || throwable2 instanceof NoSuchFileException) {
                if (Files.isDirectory(f, new LinkOption[0])) {
                    l = 0L;
                }
            }
            throw throwable;
        }
        return l;
    }
}

