/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.utils;

import io.appthreat.x2cpg.utils.FileUtil$;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Using;

public final class FileUtil {
    public static PathExt PathExt(Path path) {
        return FileUtil$.MODULE$.PathExt(path);
    }

    public static void copyFiles(Path path, Path path2) {
        FileUtil$.MODULE$.copyFiles(path, path2);
    }

    public static void delete(Path path, boolean bl, LinkOption linkOption) {
        FileUtil$.MODULE$.delete(path, bl, linkOption);
    }

    public static void deleteOnExit(Path path, boolean bl, LinkOption linkOption) {
        FileUtil$.MODULE$.deleteOnExit(path, bl, linkOption);
    }

    public static Path newTemporaryFile(String string, String string2, Option<Path> option) {
        return FileUtil$.MODULE$.newTemporaryFile(string, string2, option);
    }

    public static <T> T usingTemporaryDirectory(String string, Function1<Path, T> function1) {
        return FileUtil$.MODULE$.usingTemporaryDirectory(string, function1);
    }

    public static <U> void usingTemporaryFile(String string, String string2, Option<Path> option, Function1<Path, U> function1) {
        FileUtil$.MODULE$.usingTemporaryFile(string, string2, option, function1);
    }

    public static void writeBytes(Path path, Iterable<Object> iterable, int n) {
        FileUtil$.MODULE$.writeBytes(path, iterable, n);
    }

    public static String newTemporaryFile$default$1() {
        return FileUtil$.MODULE$.newTemporaryFile$default$1();
    }

    public static <T> String usingTemporaryDirectory$default$1() {
        return FileUtil$.MODULE$.usingTemporaryDirectory$default$1();
    }

    public static <U> String usingTemporaryFile$default$1() {
        return FileUtil$.MODULE$.usingTemporaryFile$default$1();
    }

    public static boolean delete$default$2() {
        return FileUtil$.MODULE$.delete$default$2();
    }

    public static boolean deleteOnExit$default$2() {
        return FileUtil$.MODULE$.deleteOnExit$default$2();
    }

    public static String newTemporaryFile$default$2() {
        return FileUtil$.MODULE$.newTemporaryFile$default$2();
    }

    public static <U> String usingTemporaryFile$default$2() {
        return FileUtil$.MODULE$.usingTemporaryFile$default$2();
    }

    public static LinkOption delete$default$3() {
        return FileUtil$.MODULE$.delete$default$3();
    }

    public static LinkOption deleteOnExit$default$3() {
        return FileUtil$.MODULE$.deleteOnExit$default$3();
    }

    public static Option<Path> newTemporaryFile$default$3() {
        return FileUtil$.MODULE$.newTemporaryFile$default$3();
    }

    public static <U> Option<Path> usingTemporaryFile$default$3() {
        return FileUtil$.MODULE$.usingTemporaryFile$default$3();
    }

    public static int writeBytes$default$3() {
        return FileUtil$.MODULE$.writeBytes$default$3();
    }

    public static class PathExt {
        public final Path io$appthreat$x2cpg$utils$FileUtil$PathExt$$p;

        public PathExt(Path p) {
            this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p = p;
        }

        public String absolutePathAsString() {
            return this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.toAbsolutePath().toString();
        }

        public Path $div(String child) {
            return this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.resolve(child);
        }

        public void copyToDirectory(Path destination) {
            Predef$.MODULE$.require(Files.isDirectory(destination, new LinkOption[0]), () -> FileUtil$.io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$copyToDirectory$$anonfun$1(destination));
            this.copyTo(FileUtil$.MODULE$.PathExt(destination).$div(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.getFileName().toString()), this.copyTo$default$2());
        }

        public void copyTo(Path destination, StandardCopyOption copyOption) {
            if (Files.isDirectory(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0])) {
                Files.walkFileTree(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(destination, copyOption, this){
                    private final Path destination$2;
                    private final StandardCopyOption copyOption$1;
                    private final /* synthetic */ PathExt $outer;
                    {
                        this.destination$2 = destination$5;
                        this.copyOption$1 = copyOption$2;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public Path newPath(Path subPath) {
                        return this.destination$2.resolve(this.$outer.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.relativize(subPath));
                    }

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        Files.createDirectories(this.newPath(dir), new FileAttribute[0]);
                        return super.preVisitDirectory(dir, attrs);
                    }

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Files.copy(file, this.newPath(file), this.copyOption$1);
                        return super.visitFile(file, attrs);
                    }
                });
                return;
            }
            Files.copy(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, destination, copyOption);
        }

        public StandardCopyOption copyTo$default$2() {
            return StandardCopyOption.COPY_ATTRIBUTES;
        }

        public Path createWithParentsIfNotExists(boolean asDirectory, boolean createParents) {
            if (!Files.exists(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0])) {
                Path path;
                if (asDirectory) {
                    Path path2;
                    try {
                        path2 = Files.createDirectories(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new FileAttribute[0]);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof FileAlreadyExistsException) || !Files.isDirectory(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0])) {
                            throw throwable;
                        }
                        path2 = BoxedUnit.UNIT;
                    }
                    return this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p;
                }
                if (createParents) {
                    Files.createDirectories(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.getParent(), new FileAttribute[0]);
                }
                try {
                    path = Files.createFile(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new FileAttribute[0]);
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!(throwable3 instanceof FileAlreadyExistsException) || !Files.isRegularFile(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0])) {
                        throw throwable;
                    }
                    path = BoxedUnit.UNIT;
                }
                return this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p;
            }
            return this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p;
        }

        public boolean createWithParentsIfNotExists$default$1() {
            return false;
        }

        public boolean createWithParentsIfNotExists$default$2() {
            return false;
        }

        public void mergeDirectory(Path directory, StandardCopyOption copyOptions) {
            Predef$.MODULE$.require(Files.isDirectory(directory, new LinkOption[0]), () -> FileUtil$.io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$mergeDirectory$$anonfun$1(directory));
            FileUtil$.MODULE$.PathExt(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p).walk().filter(FileUtil$::io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$mergeDirectory$$anonfun$2).foreach((Function1 & Serializable)x -> {
                String relativePath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x.toString()), this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.toString() + File.separator);
                Path target = FileUtil$.MODULE$.PathExt(directory).$div(relativePath);
                FileUtil$.MODULE$.PathExt(target.getParent()).createWithParentsIfNotExists(true, true);
                return Files.move(x, target, copyOptions);
            });
        }

        public StandardCopyOption mergeDirectory$default$2() {
            return StandardCopyOption.COPY_ATTRIBUTES;
        }

        public Path unzipTo(Path destination, Function1<ZipEntry, Object> zipFilter, int bufferSize) {
            Using.Manager$.MODULE$.apply((Function1)(JProcedure1 & Serializable)use -> {
                ZipFile zipFile = (ZipFile)use.apply((Object)new ZipFile(FileUtil$.MODULE$.PathExt(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p).absolutePathAsString(), Charset.defaultCharset()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                Iterator entries = CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.entries()).asScala().filter(zipFilter);
                entries.foreach((Function1)(JProcedure1 & Serializable)entry -> {
                    String entryName = entry.getName().replace("\\", "/");
                    Path child = FileUtil$.MODULE$.PathExt(FileUtil$.MODULE$.PathExt(destination).$div(entryName)).createWithParentsIfNotExists(entry.isDirectory(), true);
                    if (!entry.isDirectory()) {
                        InputStream zipStream = (InputStream)use.apply((Object)zipFile.getInputStream((ZipEntry)entry), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                        OutputStream outputStream = (OutputStream)use.apply((Object)Files.newOutputStream(child, new OpenOption[0]), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                        this.pipeTo(zipStream, outputStream, new byte[bufferSize]);
                        return;
                    }
                });
            });
            return destination;
        }

        public Function1<ZipEntry, Object> unzipTo$default$2() {
            return FileUtil$::io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$unzipTo$default$2$$anonfun$1;
        }

        public int unzipTo$default$3() {
            return 8192;
        }

        public long size() {
            return BoxesRunTime.unboxToLong((Object)FileUtil$.MODULE$.PathExt(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p).walk().map(FileUtil$::io$appthreat$x2cpg$utils$FileUtil$PathExt$$_$size$$anonfun$1).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public Iterator<Path> listFiles() {
            return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p).iterator()).asScala();
        }

        public Iterator<Path> walk() {
            return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new FileVisitOption[0]).iterator()).asScala();
        }

        public Option<String> extension() {
            if ((Files.isRegularFile(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0]) || Files.notExists(this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p, new LinkOption[0])) && this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.getFileName().toString().contains(".")) {
                int dotIdx = this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.getFileName().toString().lastIndexOf(".");
                return Some$.MODULE$.apply((Object)this.io$appthreat$x2cpg$utils$FileUtil$PathExt$$p.getFileName().toString().substring(dotIdx).toLowerCase());
            }
            return None$.MODULE$;
        }

        public final OutputStream pipeTo(InputStream in, OutputStream out, byte[] buffer) {
            int n;
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            return out;
        }
    }
}

