/*
 * Decompiled with CFR 0.152.
 */
package io.appthreat.x2cpg.utils;

import java.io.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class StringUtils$
implements Serializable {
    private static final String ELLIPSIS;
    public static final StringUtils$ MODULE$;

    private StringUtils$() {
    }

    static {
        MODULE$ = new StringUtils$();
        ELLIPSIS = "...";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringUtils$.class);
    }

    private String strip(String str) {
        if (str == null) {
            return null;
        }
        return str.strip();
    }

    public String normalizeSpace(String str) {
        String stripped = this.strip(str);
        if (stripped != null && stripped.length() > 2) {
            StringBuilder builder = new StringBuilder(stripped.length());
            boolean lastWasSpace = false;
            for (int i = 0; i < stripped.length(); ++i) {
                char c = stripped.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!lastWasSpace && builder.nonEmpty()) {
                        builder.append(' ');
                    }
                    lastWasSpace = true;
                    continue;
                }
                builder.append(c);
                lastWasSpace = false;
            }
            return builder.toString();
        }
        return stripped;
    }

    public String abbreviate(String str, int maxWidth) {
        return this.abbreviate(str, 0, maxWidth);
    }

    public String abbreviate(String str, int offset, int maxWidth) {
        int actualOffset;
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        int n = actualOffset = offset > str.length() ? str.length() : offset;
        if (str.length() - actualOffset < maxWidth - 3) {
            int adjustedOffset = str.length() - (maxWidth - 3);
            if (adjustedOffset <= 4) {
                return str.substring(0, maxWidth - 3) + ELLIPSIS;
            }
            if (maxWidth < 7) {
                throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
            }
            return ELLIPSIS + this.abbreviate(str.substring(adjustedOffset), maxWidth - 3);
        }
        if (actualOffset <= 4) {
            return str.substring(0, maxWidth - 3) + ELLIPSIS;
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        int availableLength = maxWidth - 3;
        int halfLength = availableLength / 2;
        int startLength = halfLength + availableLength % 2;
        int endLength = halfLength;
        String startPart = str.substring(0, startLength);
        String endPart = str.substring(str.length() - endLength);
        return startPart + ELLIPSIS + endPart;
    }
}

