/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import spray.json.ParserInput$;
import spray.json.ParserInput$Line$;

public interface ParserInput {
    public static ByteArrayBasedParserInput apply(byte[] byArray) {
        return ParserInput$.MODULE$.apply(byArray);
    }

    public static CharArrayBasedParserInput apply(char[] cArray) {
        return ParserInput$.MODULE$.apply(cArray);
    }

    public static StringBasedParserInput apply(String string) {
        return ParserInput$.MODULE$.apply(string);
    }

    public char nextChar();

    public char nextUtf8Char();

    public int cursor();

    public int length();

    public String sliceString(int var1, int var2);

    public char[] sliceCharArray(int var1, int var2);

    public Line getLine(int var1);

    public static class ByteArrayBasedParserInput
    extends IndexedBytesParserInput {
        private final byte[] bytes;

        public ByteArrayBasedParserInput(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte byteAt(int offset) {
            return this.bytes[offset];
        }

        @Override
        public int length() {
            return this.bytes.length;
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.bytes, start, end - start, ParserInput$.spray$json$ParserInput$$$UTF8);
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return ParserInput$.spray$json$ParserInput$$$UTF8.decode(ByteBuffer.wrap(Arrays.copyOfRange(this.bytes, start, end))).array();
        }
    }

    public static class CharArrayBasedParserInput
    extends DefaultParserInput {
        private final char[] chars;

        public CharArrayBasedParserInput(char[] chars) {
            this.chars = chars;
        }

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            return this._cursor() < this.chars.length ? this.chars[this._cursor()] : (char)'\uffff';
        }

        @Override
        public char nextUtf8Char() {
            return this.nextChar();
        }

        @Override
        public int length() {
            return this.chars.length;
        }

        @Override
        public String sliceString(int start, int end) {
            return new String(this.chars, start, end - start);
        }

        @Override
        public char[] sliceCharArray(int start, int end) {
            return Arrays.copyOfRange(this.chars, start, end);
        }
    }

    public static abstract class DefaultParserInput
    implements ParserInput {
        private int _cursor = -1;

        public int _cursor() {
            return this._cursor;
        }

        public void _cursor_$eq(int x$1) {
            this._cursor = x$1;
        }

        @Override
        public int cursor() {
            return this._cursor();
        }

        @Override
        public Line getLine(int index) {
            StringBuilder sb = new StringBuilder();
            int savedCursor = this._cursor();
            this._cursor_$eq(-1);
            Line line = this.rec$1(index, sb, 0, 0, 1);
            this._cursor_$eq(savedCursor);
            return line;
        }

        private final Line rec$1(int index$1, StringBuilder sb$1, int ix, int lineStartIx, int lineNr) {
            int n = lineNr;
            int n2 = lineStartIx;
            int n3 = ix;
            while (true) {
                char c;
                if ('\n' == (c = this.nextUtf8Char()) && index$1 > n3) {
                    sb$1.setLength(0);
                    int n4 = n3 + 1;
                    int n5 = n3 + 1;
                    int n6 = n + 1;
                    n3 = n4;
                    n2 = n5;
                    n = n6;
                    continue;
                }
                if ('\n' == c || '\uffff' == c) break;
                char c2 = c;
                sb$1.append(c2);
                ++n3;
            }
            return ParserInput$Line$.MODULE$.apply(n, index$1 - n2 + 1, sb$1.toString());
        }
    }

    public static abstract class IndexedBytesParserInput
    extends DefaultParserInput {
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        private final CharBuffer charBuffer = CharBuffer.allocate(2);
        private final CharsetDecoder decoder = ParserInput$.spray$json$ParserInput$$$UTF8.newDecoder();

        @Override
        public abstract int length();

        public abstract byte byteAt(int var1);

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            return this._cursor() < this.length() ? (char)(this.byteAt(this._cursor()) & 0xFF) : (char)'\uffff';
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char nextUtf8Char() {
            int n;
            if (this.charBuffer.position() > 0) {
                void var1_1;
                char result = this.charBuffer.get();
                this.charBuffer.clear();
                n = var1_1;
            } else {
                byte by;
                this._cursor_$eq(this._cursor() + 1);
                n = this._cursor() < this.length() ? ((by = this.byteAt(this._cursor())) >= 0 ? (int)by : ((by & 0xE0) == 192 ? this.decode$1(by, 1) : ((by & 0xF0) == 224 ? this.decode$1(by, 2) : ((by & 0xF8) == 240 ? this.decode$1(by, 3) : (int)65533)))) : 65535;
            }
            return (char)n;
        }

        private final char decode$1(byte by, int remainingBytes) {
            int n;
            block3: {
                block2: {
                    int n2 = remainingBytes;
                    byte by2 = by;
                    while (true) {
                        this.byteBuffer.put(by2);
                        if (n2 <= 0) break block2;
                        this._cursor_$eq(this._cursor() + 1);
                        if (this._cursor() >= this.length()) break;
                        byte by3 = this.byteAt(this._cursor());
                        int n3 = n2 - 1;
                        by2 = by3;
                        n2 = n3;
                    }
                    n = 65533;
                    break block3;
                }
                this.byteBuffer.flip();
                CoderResult coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, false);
                this.charBuffer.flip();
                int result = coderResult.isUnderflow() & this.charBuffer.hasRemaining() ? (int)this.charBuffer.get() : 65533;
                this.byteBuffer.clear();
                if (!this.charBuffer.hasRemaining()) {
                    this.charBuffer.clear();
                }
                n = result;
            }
            return (char)n;
        }
    }

    public static class Line
    implements Product,
    Serializable {
        private final int lineNr;
        private final int column;
        private final String text;

        public static Line apply(int n, int n2, String string) {
            return ParserInput$Line$.MODULE$.apply(n, n2, string);
        }

        public static Line fromProduct(Product product) {
            return ParserInput$Line$.MODULE$.fromProduct(product);
        }

        public static Line unapply(Line line) {
            return ParserInput$Line$.MODULE$.unapply(line);
        }

        public Line(int lineNr, int column, String text) {
            this.lineNr = lineNr;
            this.column = column;
            this.text = text;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNr());
            n = Statics.mix((int)n, (int)this.column());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Line)) return false;
            Line line = (Line)object;
            if (this.lineNr() != line.lineNr()) return false;
            if (this.column() != line.column()) return false;
            String string = this.text();
            String string2 = line.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!line.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Line;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Line";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "lineNr";
                    break;
                }
                case 1: {
                    string = "column";
                    break;
                }
                case 2: {
                    string = "text";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int lineNr() {
            return this.lineNr;
        }

        public int column() {
            return this.column;
        }

        public String text() {
            return this.text;
        }

        public Line copy(int lineNr, int column, String text) {
            return new Line(lineNr, column, text);
        }

        public int copy$default$1() {
            return this.lineNr();
        }

        public int copy$default$2() {
            return this.column();
        }

        public String copy$default$3() {
            return this.text();
        }

        public int _1() {
            return this.lineNr();
        }

        public int _2() {
            return this.column();
        }

        public String _3() {
            return this.text();
        }
    }

    public static class StringBasedParserInput
    extends DefaultParserInput {
        private final String string;

        public StringBasedParserInput(String string) {
            this.string = string;
        }

        @Override
        public char nextChar() {
            this._cursor_$eq(this._cursor() + 1);
            return this._cursor() < this.string.length() ? this.string.charAt(this._cursor()) : (char)'\uffff';
        }

        @Override
        public char nextUtf8Char() {
            return this.nextChar();
        }

        @Override
        public int length() {
            return this.string.length();
        }

        @Override
        public String sliceString(int start, int end) {
            return this.string.substring(start, end);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char[] sliceCharArray(int start, int end) {
            void var3_3;
            char[] chars = new char[end - start];
            this.string.getChars(start, end, chars, 0);
            return var3_3;
        }
    }
}

