/*
 * Decompiled with CFR 0.152.
 */
package fj;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.P1;
import fj.Semigroup;
import fj.data.Array;
import fj.data.List;
import fj.data.Natural;
import fj.data.Option;
import fj.data.Set;
import fj.data.Stream;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Monoid<A> {
    private final F<A, F<A, A>> sum;
    private final A zero;
    public static final Monoid<Integer> intAdditionMonoid = Monoid.monoid(Semigroup.intAdditionSemigroup, Integer.valueOf(0));
    public static final Monoid<Integer> intMultiplicationMonoid = Monoid.monoid(Semigroup.intMultiplicationSemigroup, Integer.valueOf(1));
    public static final Monoid<Double> doubleAdditionMonoid = Monoid.monoid(Semigroup.doubleAdditionSemigroup, Double.valueOf(0.0));
    public static final Monoid<Double> doubleMultiplicationMonoid = Monoid.monoid(Semigroup.doubleMultiplicationSemigroup, Double.valueOf(1.0));
    public static final Monoid<BigInteger> bigintAdditionMonoid = Monoid.monoid(Semigroup.bigintAdditionSemigroup, BigInteger.ZERO);
    public static final Monoid<BigInteger> bigintMultiplicationMonoid = Monoid.monoid(Semigroup.bigintMultiplicationSemigroup, BigInteger.ONE);
    public static final Monoid<BigDecimal> bigdecimalAdditionMonoid = Monoid.monoid(Semigroup.bigdecimalAdditionSemigroup, BigDecimal.ZERO);
    public static final Monoid<BigDecimal> bigdecimalMultiplicationMonoid = Monoid.monoid(Semigroup.bigdecimalMultiplicationSemigroup, BigDecimal.ONE);
    public static final Monoid<Natural> naturalAdditionMonoid = Monoid.monoid(Semigroup.naturalAdditionSemigroup, Natural.ZERO);
    public static final Monoid<Natural> naturalMultiplicationMonoid = Monoid.monoid(Semigroup.naturalMultiplicationSemigroup, Natural.ONE);
    public static final Monoid<Long> longAdditionMonoid = Monoid.monoid(Semigroup.longAdditionSemigroup, Long.valueOf(0L));
    public static final Monoid<Long> longMultiplicationMonoid = Monoid.monoid(Semigroup.longMultiplicationSemigroup, Long.valueOf(1L));
    public static final Monoid<Boolean> disjunctionMonoid = Monoid.monoid(Semigroup.disjunctionSemigroup, Boolean.valueOf(false));
    public static final Monoid<Boolean> exclusiveDisjunctionMonoid = Monoid.monoid(Semigroup.exclusiveDisjunctionSemiGroup, Boolean.valueOf(false));
    public static final Monoid<Boolean> conjunctionMonoid = Monoid.monoid(Semigroup.conjunctionSemigroup, Boolean.valueOf(true));
    public static final Monoid<String> stringMonoid = Monoid.monoid(Semigroup.stringSemigroup, "");
    public static final Monoid<StringBuffer> stringBufferMonoid = Monoid.monoid(Semigroup.stringBufferSemigroup, new StringBuffer());
    public static final Monoid<StringBuilder> stringBuilderMonoid = Monoid.monoid(Semigroup.stringBuilderSemigroup, new StringBuilder());

    private Monoid(F<A, F<A, A>> sum, A zero) {
        this.sum = sum;
        this.zero = zero;
    }

    public Semigroup<A> semigroup() {
        return Semigroup.semigroup(this.sum);
    }

    public A sum(A a1, A a2) {
        return this.sum.f(a1).f(a2);
    }

    public F<A, A> sum(A a1) {
        return this.sum.f(a1);
    }

    public F<A, F<A, A>> sum() {
        return this.sum;
    }

    public A zero() {
        return this.zero;
    }

    public A sumRight(List<A> as) {
        return as.foldRight(this.sum, this.zero);
    }

    public A sumRight(Stream<A> as) {
        return as.foldRight(new F2<A, P1<A>, A>(){

            @Override
            public A f(A a, P1<A> ap1) {
                return Monoid.this.sum(a, ap1._1());
            }
        }, this.zero);
    }

    public A sumLeft(List<A> as) {
        return as.foldLeft(this.sum, this.zero);
    }

    public A sumLeft(Stream<A> as) {
        return as.foldLeft(this.sum, this.zero);
    }

    public F<List<A>, A> sumLeft() {
        return new F<List<A>, A>(){

            @Override
            public A f(List<A> as) {
                return Monoid.this.sumLeft(as);
            }
        };
    }

    public F<List<A>, A> sumRight() {
        return new F<List<A>, A>(){

            @Override
            public A f(List<A> as) {
                return Monoid.this.sumRight(as);
            }
        };
    }

    public F<Stream<A>, A> sumLeftS() {
        return new F<Stream<A>, A>(){

            @Override
            public A f(Stream<A> as) {
                return Monoid.this.sumLeft(as);
            }
        };
    }

    public A join(Iterable<A> as, A a) {
        Stream<A> s = Stream.iterableStream(as);
        return s.isEmpty() ? this.zero : s.foldLeft1(Function.compose(this.sum, Function.flip(this.sum).f(a)));
    }

    public static <A> Monoid<A> monoid(F<A, F<A, A>> sum, A zero) {
        return new Monoid<A>(sum, zero);
    }

    public static <A> Monoid<A> monoid(F2<A, A, A> sum, A zero) {
        return new Monoid<A>(Function.curry(sum), zero);
    }

    public static <A> Monoid<A> monoid(Semigroup<A> s, A zero) {
        return new Monoid<A>(s.sum(), zero);
    }

    public static <A, B> Monoid<F<A, B>> functionMonoid(Monoid<B> mb) {
        return Monoid.monoid(Semigroup.functionSemigroup(mb.semigroup()), Function.constant(mb.zero));
    }

    public static <A> Monoid<List<A>> listMonoid() {
        return Monoid.monoid(Semigroup.listSemigroup(), List.nil());
    }

    public static <A> Monoid<Option<A>> optionMonoid() {
        return Monoid.monoid(Semigroup.optionSemigroup(), Option.none());
    }

    public static <A> Monoid<Option<A>> firstOptionMonoid() {
        return Monoid.monoid(Semigroup.firstOptionSemigroup(), Option.none());
    }

    public static <A> Monoid<Option<A>> lastOptionMonoid() {
        return Monoid.monoid(Semigroup.lastOptionSemigroup(), Option.none());
    }

    public static <A> Monoid<Stream<A>> streamMonoid() {
        return Monoid.monoid(Semigroup.streamSemigroup(), Stream.nil());
    }

    public static <A> Monoid<Array<A>> arrayMonoid() {
        return Monoid.monoid(Semigroup.arraySemigroup(), Array.empty());
    }

    public static <A> Monoid<Set<A>> setMonoid(Ord<A> o) {
        return Monoid.monoid(Semigroup.setSemigroup(), Set.empty(o));
    }
}

