/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.app.Activity;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.azerion.bluestack.RequestOptions;
import com.azerion.bluestack.interstitial.InterstitialAd;
import com.azerion.bluestack.interstitial.InterstitialAdListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.reactnativebluestackmodule.common.BluestackAdsCommon;
import com.reactnativebluestackmodule.common.ReactNativeModule;

public class BluestackInterstitialAdManager
extends ReactNativeModule
implements LifecycleEventListener,
InterstitialAdListener {
    private static final String TAG = "InterstitialAd Bridge";
    private static final String REACT_CLASS = "BluestackInterstitialAdManager";
    private static final String EVENT_LOADED_AD = "onAdLoaded";
    private static final String EVENT_DISAPPEAR_AD = "onAdDismissed";
    private static final String EVENT_DID_SHOWN_AD = "onAdDisplayed";
    private static final String EVENT_AD_CLICKED = "onAdClicked";
    private static final String EVENT_AD_ERROR = "onAdFailedError";
    private static final String EVENT_AD_MESSAGE_ERROR_KEY = "errorMessage";
    private static final String EVENT_KEY = "interstitialEvent";
    private static final String EVENT_NAME = "InterstitialAdEvent";
    private InterstitialAd interstitialAd;
    private RequestOptions mRequestOptions;

    public BluestackInterstitialAdManager(ReactApplicationContext reactContext) {
        super(reactContext, TAG);
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    @ReactMethod
    public void loadAd(String placementId, boolean autoDisplay, String jsonPreference) {
        if (this.interstitialAd == null) {
            this.interstitialAd = new InterstitialAd(this.getActivity(), placementId);
        }
        this.interstitialAd.setInterstitialAdListener((InterstitialAdListener)this);
        this.mRequestOptions = BluestackAdsCommon.getRequestOptions(jsonPreference, this.getApplicationContext());
        try {
            Activity currentActivity = this.getActivity();
            if (currentActivity == null) {
                Log.d((String)TAG, (String)"loadInterstitial attempted but the current Activity was null.");
                return;
            }
            currentActivity.runOnUiThread(() -> this.interstitialAd.load(this.mRequestOptions));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("loadInterstitial failed with exception: " + e.toString()));
        }
    }

    @ReactMethod
    public void displayAd() {
        if (this.interstitialAd != null && this.interstitialAd.isReady()) {
            try {
                Activity currentActivity = this.getActivity();
                if (currentActivity == null) {
                    Log.d((String)TAG, (String)"displayInterstitial attempted but the current Activity was null.");
                    return;
                }
                currentActivity.runOnUiThread(() -> this.interstitialAd.show());
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("displayInterstitial failed with exception: " + e.toString()));
            }
        } else {
            WritableMap params = Arguments.createMap();
            params.putString(EVENT_KEY, EVENT_AD_ERROR);
            params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Interstitial Ad is not loaded");
            this.sendEvent(this.getContext(), params);
        }
    }

    public void onAdLoaded() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_LOADED_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdFailedToLoad(Exception e) {
        Log.d((String)TAG, (String)("interstitialDidFail: " + e.getMessage()));
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_ERROR);
        params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Interstitial failed to load: error code= " + e.hashCode() + " message= " + e.getMessage());
        this.sendEvent(this.getContext(), params);
    }

    public void onAdDismissed() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_DISAPPEAR_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdDisplayed() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_DID_SHOWN_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdFailedToDisplay(Exception e) {
        Log.d((String)TAG, (String)("interstitialDidFail: " + e.getMessage()));
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_ERROR);
        params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Interstitial failed to display: error code= " + e.hashCode() + " message= " + e.getMessage());
        this.sendEvent(this.getContext(), params);
    }

    public void onAdClicked() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_CLICKED);
        this.sendEvent(this.getContext(), params);
    }

    @Override
    @NonNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
    }

    private void sendEvent(ReactContext reactContext, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(EVENT_NAME, (Object)params);
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }
}

