/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule.common;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.azerion.bluestack.RequestOptions;
import com.mngads.util.MNGGender;
import org.json.JSONObject;

public class BluestackAdsCommon {
    private static final String TAG = "BluestackAdsCommon";

    public static RequestOptions getRequestOptions(String jsonPreference, Context context) {
        int _adChoicePosition = 0;
        int _age = -1;
        Location _location = null;
        int _consentFlag = 0;
        String _language = null;
        String _keyword = null;
        String _contentUrl = null;
        MNGGender _gender = MNGGender.MNGGenderUnknown;
        RequestOptions requestOptions = null;
        try {
            String keyword;
            String contentUrl;
            String language;
            String gender;
            Log.d((String)TAG, (String)("jsonPreference : " + jsonPreference));
            JSONObject preferencejsonObject = new JSONObject(jsonPreference);
            if (preferencejsonObject.has("age") && !preferencejsonObject.isNull("age")) {
                Integer age = (Integer)preferencejsonObject.get("age");
                Log.d((String)TAG, (String)("preferencejsonObject age: " + age));
                if (age != null) {
                    _age = age;
                }
            }
            if (preferencejsonObject.has("gender") && !preferencejsonObject.isNull("gender") && (gender = (String)preferencejsonObject.get("gender")) != null) {
                switch (gender) {
                    case "Female": {
                        _gender = MNGGender.MNGGenderFemale;
                        break;
                    }
                    case "Male": {
                        _gender = MNGGender.MNGGenderMale;
                        break;
                    }
                    default: {
                        _gender = MNGGender.MNGGenderUnknown;
                    }
                }
            }
            if (preferencejsonObject.has("language") && !preferencejsonObject.isNull("language") && (language = (String)preferencejsonObject.get("language")) != null) {
                _language = language;
            }
            if (preferencejsonObject.has("contentUrl") && !preferencejsonObject.isNull("contentUrl") && (contentUrl = (String)preferencejsonObject.get("contentUrl")) != null) {
                _contentUrl = contentUrl;
            }
            if (preferencejsonObject.has("keyword") && !preferencejsonObject.isNull("keyword") && (keyword = (String)preferencejsonObject.get("keyword")) != null) {
                _keyword = keyword;
            }
            Integer consentFlag = 0;
            if (preferencejsonObject.has("consentFlag") && !preferencejsonObject.isNull("consentFlag")) {
                consentFlag = (Integer)preferencejsonObject.get("consentFlag");
                _consentFlag = consentFlag;
            }
            if (preferencejsonObject.has("location") && !preferencejsonObject.isNull("location")) {
                JSONObject locationJsonObject = preferencejsonObject.getJSONObject("location");
                Location location = new Location(locationJsonObject.get("provider").toString());
                location.setLatitude(((Double)locationJsonObject.get("latitude")).doubleValue());
                location.setLongitude(((Double)locationJsonObject.get("longitude")).doubleValue());
                _location = location;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error saving json to preferencejsonObject: " + e.getMessage()));
            e.printStackTrace();
        }
        if (requestOptions == null) {
            requestOptions = new RequestOptions(context, _adChoicePosition, _age, _consentFlag, _location, _language, _keyword, _contentUrl, _gender);
        }
        BluestackAdsCommon.printRequestOptions(requestOptions);
        return requestOptions;
    }

    public static void printRequestOptions(RequestOptions requestOptions) {
        if (requestOptions != null) {
            System.out.println("RequestOptions:");
            System.out.println("  Age: " + requestOptions.toMNGPreference().getAge());
            System.out.println("  Consent Flag: " + requestOptions.toMNGPreference().getConsentFlag());
            System.out.println("  Location: " + requestOptions.toMNGPreference().getLocation());
            System.out.println("  Language: " + requestOptions.toMNGPreference().getLanguage());
            System.out.println("  Keyword: " + requestOptions.toMNGPreference().getKeyword());
            System.out.println("  Content URL: " + requestOptions.toMNGPreference().getContentUrl());
            System.out.println("  Gender: " + requestOptions.toMNGPreference().getGender());
        } else {
            System.out.println("RequestOptions: Not created yet.");
        }
    }
}

