/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.content.Context;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import android.widget.RelativeLayout;
import com.azerion.bluestack.RequestOptions;
import com.azerion.bluestack.banner.AdSize;
import com.azerion.bluestack.banner.BannerView;
import com.azerion.bluestack.banner.BannerViewListener;
import com.azerion.bluestack.util.Size;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.reactnativebluestackmodule.BluestackModuleViewManager;
import com.reactnativebluestackmodule.common.BluestackAdsCommon;

public class BluestackBannerView
extends RelativeLayout
implements LifecycleEventListener,
BannerViewListener {
    private static final String TAG = "BannerView Bridge";
    private final ReactContext mContext;
    private View myAdView;
    private String mPlacementId;
    private String mPreference;
    private String mAdSize;
    private int mWidthDP = -1;
    private int mHeightDP = -1;
    private boolean mShouldLoadNow;
    private boolean mShouldLoadWhenReady;
    private boolean propsChanged;
    private final RCTEventEmitter mEventEmitter;
    private BannerView bannerView;

    public BluestackBannerView(ThemedReactContext context) {
        super((Context)context);
        this.mContext = context;
        this.mContext.addLifecycleEventListener((LifecycleEventListener)this);
        this.mEventEmitter = (RCTEventEmitter)this.mContext.getJSModule(RCTEventEmitter.class);
    }

    private int getParentId() {
        try {
            return ((View)this.getParent()).getId();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        Log.d((String)TAG, (String)("setPlacementId : " + this.mPlacementId));
    }

    public String getPlacementId() {
        return this.mPlacementId;
    }

    public void setPreference(String preference) {
        this.mPreference = preference;
    }

    public String getPreference() {
        return this.mPreference;
    }

    public void setAdSize(String adSize) {
        Log.d((String)TAG, (String)("setAdSize: " + adSize));
        this.mAdSize = adSize;
    }

    public void setWidth(int widthDP) {
        this.mWidthDP = widthDP;
    }

    public void setHeight(int heightDP) {
        this.mHeightDP = heightDP;
    }

    public void setShouldLoadNow(boolean shouldLoadNow) {
        this.mShouldLoadNow = shouldLoadNow;
    }

    public boolean getShouldLoadNow() {
        return this.mShouldLoadNow;
    }

    public void setShouldLoadWhenReady(boolean shouldLoadWhenReady) {
        this.mShouldLoadWhenReady = shouldLoadWhenReady;
    }

    public boolean getShouldLoadWhenReady() {
        return this.mShouldLoadWhenReady;
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        Log.d((String)TAG, (String)"onHostDestroy");
        this.destroy();
    }

    public void createAdViewIfCan() {
        if (this.bannerView == null && this.mPlacementId != null && this.mPreference != null && this.mWidthDP > -1 && this.mHeightDP > 0) {
            this.loadBannerAd(this.mPreference);
        }
    }

    public void setPropsChanged(boolean propsChanged) {
        this.propsChanged = propsChanged;
    }

    public boolean getPropsChanged() {
        return this.propsChanged;
    }

    public void loadBannerAd(String optionsJSON) {
        this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_AD_LOAD_CALLED.toString(), null);
        this.removeAllViews();
        this.bannerView = new BannerView((Context)this.mContext);
        if (optionsJSON == null || optionsJSON.isEmpty()) {
            optionsJSON = "{}";
        }
        this.bannerView.setPlacementId(this.mPlacementId);
        this.bannerView.startAutoRefresh();
        this.bannerView.setBannerViewListener((BannerViewListener)this);
        this.bannerView.setAdSize(this.getAdSize(this.mAdSize));
        RequestOptions mRequestOptions = BluestackAdsCommon.getRequestOptions(optionsJSON, (Context)this.mContext);
        this.bannerView.load(mRequestOptions);
    }

    public void onAdLoad(int preferredHeightDP) {
        Log.d((String)TAG, (String)("Banner did load preferred Height " + preferredHeightDP + "dp"));
        this.mHeightDP = preferredHeightDP;
        if (this.bannerView != null) {
            this.bannerView.setBackgroundColor(0);
            this.addView((View)this.bannerView);
            this.setupLayout(this);
            WritableMap event = Arguments.createMap();
            event.putInt("size", preferredHeightDP);
            this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_LOAD_BANNER.toString(), event);
        } else {
            Log.e((String)TAG, (String)"BannerView is null");
            Exception exception = new Exception("BannerView is not initialized");
            this.onAdFailToLoad(exception);
        }
    }

    private void setupLayout(final BluestackBannerView view) {
        Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                BluestackBannerView.this.manuallyLayoutChildren(view);
                view.getViewTreeObserver().dispatchOnGlobalLayout();
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            }
        });
    }

    public void manuallyLayoutChildren(BluestackBannerView view) {
        int width = BluestackModuleViewManager.dpToPx(view.getAdWidth(), view.getContext());
        int height = BluestackModuleViewManager.dpToPx(view.getAdHeight(), view.getContext());
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        view.layout(0, 0, width, height);
    }

    public void onAdFailToLoad(Exception e) {
        WritableMap event = Arguments.createMap();
        Log.e((String)TAG, (String)("Banner did fail : " + e.getMessage() + " error code = " + e.hashCode()));
        event.putString("message", e.getMessage());
        event.putInt("code", e.hashCode());
        this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_FAIL_TO_LOAD.toString(), event);
    }

    public void onResize(Size size) {
        Log.d((String)TAG, (String)("Banner did resize to " + size.getHeight() + "x" + size.getWidth()));
        this.mHeightDP = size.getHeight();
        this.mWidthDP = size.getWidth();
    }

    public void onAdRefresh() {
        this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_REFRESHED_BANNER.toString(), null);
    }

    public void onAdFailToRefresh(Exception e) {
        WritableMap event = Arguments.createMap();
        Log.e((String)TAG, (String)("on refresh failed : " + e.getMessage() + " error code = " + e.hashCode()));
        event.putString("message", e.getMessage());
        event.putInt("code", e.hashCode());
        this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_FAIL_TO_REFRESH.toString(), event);
    }

    public void onAdClick() {
        this.mEventEmitter.receiveEvent(this.getParentId(), Events.EVENT_AD_CLICKED.toString(), null);
    }

    public void create(String optionsJSON) {
        if (this.bannerView != null) {
            this.loadBannerAd(optionsJSON);
        }
    }

    public void destroy() {
        Log.d((String)TAG, (String)"destroy banner");
        if (this.bannerView != null) {
            this.removeAllViews();
            this.bannerView.destroy();
            this.bannerView = null;
        }
    }

    public void refresh(boolean enable) {
        if (this.bannerView != null) {
            if (enable) {
                this.bannerView.startAutoRefresh();
            } else {
                this.bannerView.stopAutoRefresh();
            }
        }
    }

    public int getAdWidth() {
        return this.mWidthDP;
    }

    public int getAdHeight() {
        return this.mHeightDP;
    }

    private AdSize getAdSize(String size) {
        switch (size) {
            case "standard": {
                return AdSize.BANNER;
            }
            case "large": {
                return AdSize.LARGE_BANNER;
            }
            case "mediumRectangle": {
                return AdSize.MEDIUM_RECTANGLE;
            }
            case "full": {
                return AdSize.FULL_BANNER;
            }
            case "leaderboard": {
                return AdSize.LEADERBOARD;
            }
            case "dynamic": {
                return AdSize.DYNAMIC_BANNER;
            }
            case "dynamicLeaderboard": {
                return AdSize.DYNAMIC_LEADERBOARD;
            }
        }
        throw new IllegalArgumentException("Invalid size: " + size);
    }

    public static enum Events {
        EVENT_LOAD_BANNER("onAdLoaded"),
        EVENT_FAIL_TO_LOAD("onAdFailedToLoad"),
        EVENT_REFRESHED_BANNER("onAdRefreshed"),
        EVENT_FAIL_TO_REFRESH("onAdFailedToRefresh"),
        EVENT_AD_CLICKED("onAdClicked"),
        EVENT_AD_LOAD_CALLED("onAdLoadCalled");

        private final String mName;

        private Events(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

