/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.azerion.bluestack.BlueStack;
import com.azerion.bluestack.initialization.AdapterStatus;
import com.azerion.bluestack.initialization.InitializationListener;
import com.azerion.bluestack.initialization.InitializationStatus;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.reactnativebluestackmodule.common.ReactNativeModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class BluestackManager
extends ReactNativeModule
implements InitializationListener,
LifecycleEventListener {
    private static final String TAG = "BluestackManager Bridge";
    private static final String CLASS_NAME = "BluestackManager";
    private static final int EVENT_INIT_SUCCESS = 1;
    private static final String EVENT_INIT_FAILED = "SDK_FAILED_TO_INIT";
    private List<Promise> promiseList = new ArrayList<Promise>();
    private boolean isInitInProgress = false;
    BlueStack blueStack = null;

    public BluestackManager(ReactApplicationContext reactContext) {
        super(reactContext, TAG);
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    @Override
    @NonNull
    public String getName() {
        return CLASS_NAME;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @ReactMethod
    public void initializeSDK(String appId, boolean enableDebug, Promise p) {
        this.promiseList.add(p);
        if (!this.isInitInProgress) {
            Log.d((String)TAG, (String)"Native BluestackManager initializeSDK");
            BlueStack.INSTANCE.setDebugModeEnabled(enableDebug);
            BlueStack.INSTANCE.initialize((Context)this.getActivity(), appId, (InitializationListener)this);
            this.isInitInProgress = true;
        }
    }

    public void onInitialized(InitializationStatus initializationStatus) {
        this.isInitInProgress = false;
        if (initializationStatus.getAdapterStatusMap().isEmpty()) {
            this.invokeSdkInitCompleteAction(false, "No Adapters found");
            return;
        }
        try {
            HashMap adapterStatusMap = new HashMap();
            boolean isAnyAdapterReady = false;
            String errorMessage = "Adapters are not initialized";
            for (Map.Entry entry : initializationStatus.getAdapterStatusMap().entrySet()) {
                String adNetworkName = (String)entry.getKey();
                AdapterStatus adapterStatus = (AdapterStatus)entry.getValue();
                String adapterState = adapterStatus.getState().toString();
                String adapterDescription = adapterStatus.getDescription();
                HashMap<String, String> statusMap = new HashMap<String, String>();
                statusMap.put("name", adapterStatus.getName());
                statusMap.put("state", adapterState);
                statusMap.put("description", adapterDescription);
                adapterStatusMap.put(adNetworkName, statusMap);
                if (adapterState == "READY") {
                    isAnyAdapterReady = true;
                    continue;
                }
                if (!"mngPerf".equals(adNetworkName)) continue;
                errorMessage = adapterDescription;
            }
            if (isAnyAdapterReady) {
                this.invokeSdkInitCompleteAction(true, "BlueStack is successfully initialized");
            } else {
                this.invokeSdkInitCompleteAction(false, errorMessage);
            }
            this.logAdaptersStatus(initializationStatus.getAdapterStatusMap());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error parsing initialization status: " + e.getMessage()));
            this.invokeSdkInitCompleteAction(false, e.getMessage());
        }
    }

    private void logAdaptersStatus(Map<String, AdapterStatus> adapterMap) {
        Log.d((String)TAG, (String)"BlueStack Adapters Initialization Status: ");
        adapterMap.forEach((adNetworkName, adapterStatus) -> Log.d((String)TAG, (String)(" Provider: " + adapterStatus.getName() + ", Description: " + adapterStatus.getDescription() + ", State: " + adapterStatus.getState())));
    }

    private void invokeSdkInitCompleteAction(boolean isSuccess, String message) {
        if (isSuccess) {
            Log.d((String)TAG, (String)"SDK Did Finish Initializing");
            for (Promise promise : this.promiseList) {
                promise.resolve((Object)1);
            }
        } else {
            Log.d((String)TAG, (String)"SDK Failed to Initialize");
            for (Promise promise : this.promiseList) {
                promise.reject(EVENT_INIT_FAILED, message);
            }
        }
        this.promiseList.clear();
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        this.promiseList.clear();
    }
}

