/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.reactnativebluestackmodule.BluestackBannerView;
import java.util.Map;

public class BluestackModuleViewManager
extends SimpleViewManager<FrameLayout> {
    private static final String TAG = "BluestackModuleViewManager Bridge";
    private static final String REACT_CLASS = "BluestackModuleView";
    public final int COMMAND_CREATE_ID = 1;
    public final String COMMAND_CREATE_NAME = "create";
    public final int COMMAND_DESTROY_ID = 2;
    public final String COMMAND_DESTROY_NAME = "destroy";
    public final int COMMAND_REFRESH_ID = 3;
    public final String COMMAND_REFRESH_NAME = "refresh";

    private BluestackBannerView getBannerView(FrameLayout view) {
        return (BluestackBannerView)view.getChildAt(0);
    }

    @ReactProp(name="placementId")
    public void setPlacementId(FrameLayout view, String placementId) {
        this.getBannerView(view).setPlacementId(placementId);
        this.getBannerView(view).setPropsChanged(true);
    }

    @ReactProp(name="preference")
    public void setPreference(FrameLayout view, String preference) {
        this.getBannerView(view).setPreference(preference);
        this.getBannerView(view).setPropsChanged(true);
    }

    @ReactProp(name="adSize")
    public void setAdSize(FrameLayout view, String adSize) {
        this.getBannerView(view).setAdSize(adSize);
        this.getBannerView(view).setPropsChanged(true);
    }

    @ReactPropGroup(names={"width", "height"}, customType="Style")
    public void setStyle(FrameLayout view, int index, Integer value) {
        if (index == 0) {
            Log.d((String)TAG, (String)("setStyle Width DP: " + value));
            this.getBannerView(view).setWidth(value);
            this.getBannerView(view).setPropsChanged(true);
        }
        if (index == 1) {
            Log.d((String)TAG, (String)("setStyle Height DP: " + value));
            this.getBannerView(view).setHeight(value);
            this.getBannerView(view).setPropsChanged(true);
        }
    }

    @ReactProp(name="shouldLoadNow")
    public void setShouldLoadNow(FrameLayout view, boolean shouldLoadNow) {
        this.getBannerView(view).setShouldLoadNow(shouldLoadNow);
    }

    @ReactProp(name="shouldLoadWhenReady")
    public void setShouldLoadWhenReady(FrameLayout view, boolean shouldLoadWhenReady) {
        this.getBannerView(view).setShouldLoadWhenReady(shouldLoadWhenReady);
        this.getBannerView(view).setPropsChanged(true);
    }

    @NonNull
    public String getName() {
        return REACT_CLASS;
    }

    @NonNull
    public FrameLayout createViewInstance(@NonNull ThemedReactContext reactContext) {
        FrameLayout bannerContainer = new FrameLayout((Context)reactContext);
        BluestackBannerView bannerView = new BluestackBannerView(reactContext);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        bannerContainer.addView((View)bannerView, (ViewGroup.LayoutParams)layoutParams);
        this.setupLayout(bannerView);
        return bannerContainer;
    }

    private void setupLayout(final BluestackBannerView view) {
        Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                BluestackModuleViewManager.this.manuallyLayoutChildren(view);
                view.getViewTreeObserver().dispatchOnGlobalLayout();
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            }
        });
    }

    public void manuallyLayoutChildren(BluestackBannerView view) {
        int width = BluestackModuleViewManager.dpToPx(view.getAdWidth(), view.getContext());
        int height = BluestackModuleViewManager.dpToPx(view.getAdHeight(), view.getContext());
        view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        view.layout(0, 0, width, height);
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of((Object)BluestackBannerView.Events.EVENT_LOAD_BANNER.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_LOAD_BANNER.toString()), (Object)BluestackBannerView.Events.EVENT_FAIL_TO_LOAD.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_FAIL_TO_LOAD.toString()), (Object)BluestackBannerView.Events.EVENT_REFRESHED_BANNER.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_REFRESHED_BANNER.toString()), (Object)BluestackBannerView.Events.EVENT_FAIL_TO_REFRESH.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_FAIL_TO_REFRESH.toString()), (Object)BluestackBannerView.Events.EVENT_AD_CLICKED.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_AD_CLICKED.toString()), (Object)BluestackBannerView.Events.EVENT_AD_LOAD_CALLED.toString(), (Object)MapBuilder.of((Object)"registrationName", (Object)BluestackBannerView.Events.EVENT_AD_LOAD_CALLED.toString()));
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"create", (Object)1, (Object)"destroy", (Object)2, (Object)"refresh", (Object)3);
    }

    public void receiveCommand(@NonNull FrameLayout root, String commandId, @Nullable ReadableArray args) {
        super.receiveCommand((View)root, commandId, args);
        switch (commandId) {
            case "create": {
                if (args == null) break;
                String pref = args.getString(0);
                this.getBannerView(root).setPreference(pref);
                break;
            }
            case "destroy": {
                this.getBannerView(root).destroy();
                break;
            }
            case "refresh": {
                if (args == null) break;
                boolean state = args.getBoolean(0);
                this.getBannerView(root).refresh(state);
                break;
            }
        }
    }

    public void onAfterUpdateTransaction(@NonNull FrameLayout root) {
        super.onAfterUpdateTransaction((View)root);
        boolean shouldLoadNow = this.getBannerView(root).getShouldLoadNow();
        boolean shouldLoadWhenReady = this.getBannerView(root).getShouldLoadWhenReady();
        boolean propsChanged = this.getBannerView(root).getPropsChanged();
        if (shouldLoadNow) {
            String preference = this.getBannerView(root).getPreference();
            this.getBannerView(root).loadBannerAd(preference);
        } else if (shouldLoadWhenReady && propsChanged) {
            this.getBannerView(root).createAdViewIfCan();
        }
        this.getBannerView(root).setPropsChanged(false);
    }

    public static int dpToPx(float dp, Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

