/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.mngads.util.MNGGender;
import com.mngads.util.MNGPreference;
import org.json.JSONObject;

public class BluestackPreference
extends ReactContextBaseJavaModule {
    private static final String TAG = "BluestackPreference Bridge";
    private static final String REACT_CLASS = "BluestackPreference";
    private MNGPreference preference;
    private MNGGender mGender = MNGGender.MNGGenderUnknown;

    public BluestackPreference(ReactApplicationContext reactContext) {
        super(reactContext);
        if (this.preference == null) {
            this.preference = new MNGPreference();
        }
    }

    @ReactMethod
    public void setAge(Integer age) {
        this.preference.setAge(age.intValue());
    }

    @ReactMethod
    public void setLocation(String location, Integer consentFlag) {
        try {
            JSONObject locationJsonObject = new JSONObject(location);
            Location mLocation = new Location(locationJsonObject.get("provider").toString());
            mLocation.setLatitude((double)((Integer)locationJsonObject.get("latitude")).intValue());
            mLocation.setLongitude((double)((Integer)locationJsonObject.get("longitude")).intValue());
            Log.d((String)TAG, (String)("Preference Location: " + mLocation.getLatitude()));
            ReactApplicationContext reactContext = this.getReactApplicationContext();
            this.preference.setLocation(mLocation, consentFlag.intValue(), (Context)reactContext);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Error converting json to locationJsonObject: " + e.getMessage()));
        }
    }

    @ReactMethod
    public void setLanguage(String language) {
        this.preference.setLanguage(language);
    }

    @ReactMethod
    public void setGender(String gender) {
        switch (gender) {
            case "Female": {
                this.preference.setGender(MNGGender.MNGGenderFemale);
                break;
            }
            case "Male": {
                this.preference.setGender(MNGGender.MNGGenderMale);
                break;
            }
            default: {
                this.preference.setGender(MNGGender.MNGGenderUnknown);
            }
        }
    }

    public void setGender(MNGGender gender) {
        this.mGender = gender;
    }

    @ReactMethod
    public void setKeyword(String keyword) {
        this.preference.setKeyword(keyword);
    }

    @ReactMethod
    public void setContentUrl(String contentUrl) {
        this.preference.setContentUrl(contentUrl);
    }

    @ReactMethod(isBlockingSynchronousMethod=true)
    public String getMNGPreferenceJSONObj() {
        try {
            ReactApplicationContext reactContext = this.getReactApplicationContext();
            JSONObject prefJSONObj = this.preference.getJson((Context)reactContext);
            Log.d((String)TAG, (String)("Converting Preference to json: " + prefJSONObj.toString()));
            return prefJSONObj.toString();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Error converting Preference to json: " + e.getMessage()));
            return "{}";
        }
    }

    @ReactMethod
    public void getMNGPreference(Promise promise) {
        try {
            promise.resolve((Object)this.preference);
        }
        catch (Exception e) {
            promise.reject("Error", (Throwable)e);
        }
    }

    @NonNull
    public String getName() {
        return REACT_CLASS;
    }

    public void onDestroy() {
        if (this.preference != null) {
            this.preference = null;
        }
    }
}

