/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebluestackmodule;

import android.app.Activity;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.azerion.bluestack.RequestOptions;
import com.azerion.bluestack.rewarded.Reward;
import com.azerion.bluestack.rewarded.RewardedAd;
import com.azerion.bluestack.rewarded.RewardedAdListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.reactnativebluestackmodule.common.BluestackAdsCommon;
import com.reactnativebluestackmodule.common.ReactNativeModule;

public class BluestackRewardedAdManager
extends ReactNativeModule
implements LifecycleEventListener,
RewardedAdListener {
    private static final String TAG = "RewardedAd Bridge";
    private static final String REACT_CLASS = "BluestackRewardedAdManager";
    private static final String EVENT_LOADED_AD = "onAdLoaded";
    private static final String EVENT_DISAPPEAR_AD = "onAdDismissed";
    private static final String EVENT_DID_SHOWN_AD = "onAdDisplayed";
    private static final String EVENT_AD_CLICKED = "onAdClicked";
    private static final String EVENT_REWARD_EARNED = "onRewardEarned";
    private static final String EVENT_REWARD_TYPE_KEY = "rewardType";
    private static final String EVENT_REWARD_AMOUNT_KEY = "rewardAmount";
    private static final String EVENT_AD_ERROR = "onAdFailedError";
    private static final String EVENT_AD_MESSAGE_ERROR_KEY = "errorMessage";
    private static final String EVENT_KEY = "rewardedEvent";
    private static final String EVENT_NAME = "RewardedAdEvent";
    private RewardedAd rewardedAd;
    private RequestOptions mRequestOptions;

    public BluestackRewardedAdManager(ReactApplicationContext reactContext) {
        super(reactContext, TAG);
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    @ReactMethod
    public void loadAd(String placementId, boolean autoDisplay, String jsonPreference) {
        if (this.rewardedAd == null) {
            this.rewardedAd = new RewardedAd(this.getActivity(), placementId);
        }
        this.rewardedAd.setRewardedAdListener((RewardedAdListener)this);
        this.mRequestOptions = BluestackAdsCommon.getRequestOptions(jsonPreference, this.getApplicationContext());
        try {
            Activity currentActivity = this.getActivity();
            if (currentActivity == null) {
                Log.d((String)TAG, (String)"Load Rewarded attempted but the current Activity was null.");
                return;
            }
            currentActivity.runOnUiThread(() -> this.rewardedAd.load(this.mRequestOptions));
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Load Rewarded failed with exception: " + e.toString()));
        }
    }

    @ReactMethod
    public void displayAd() {
        if (this.rewardedAd != null && this.rewardedAd.isReady()) {
            try {
                Activity currentActivity = this.getActivity();
                if (currentActivity == null) {
                    Log.d((String)TAG, (String)"display Rewarded attempted but the current Activity was null.");
                    return;
                }
                currentActivity.runOnUiThread(() -> this.rewardedAd.show());
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("display Rewarded failed with exception: " + e.toString()));
            }
        } else {
            WritableMap params = Arguments.createMap();
            params.putString(EVENT_KEY, EVENT_AD_ERROR);
            params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Rewarded Ad is not loaded");
            this.sendEvent(this.getContext(), params);
        }
    }

    public void onAdLoaded() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_LOADED_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdFailedToLoad(Exception e) {
        Log.d((String)TAG, (String)("RewardedVideoError: " + e.getMessage()));
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_ERROR);
        params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Rewarded Ad failed to load: error code = " + e.hashCode() + ", message = " + e.getMessage());
        this.sendEvent(this.getContext(), params);
    }

    public void onAdDismissed() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_DISAPPEAR_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdDisplayed() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_DID_SHOWN_AD);
        this.sendEvent(this.getContext(), params);
    }

    public void onAdFailedToDisplay(Exception e) {
        Log.d((String)TAG, (String)("RewardedVideoError: " + e.getMessage()));
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_ERROR);
        params.putString(EVENT_AD_MESSAGE_ERROR_KEY, "Rewarded Ad failed to display: error code = " + e.hashCode() + ", message = " + e.getMessage());
        this.sendEvent(this.getContext(), params);
    }

    public void onEarnedReward(Reward reward) {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_REWARD_EARNED);
        params.putString(EVENT_REWARD_TYPE_KEY, reward.getType());
        params.putDouble(EVENT_REWARD_AMOUNT_KEY, reward.getAmount());
        this.sendEvent(this.getContext(), params);
    }

    public void onAdClicked() {
        WritableMap params = Arguments.createMap();
        params.putString(EVENT_KEY, EVENT_AD_CLICKED);
        this.sendEvent(this.getContext(), params);
    }

    @Override
    @NonNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
        }
    }

    private void sendEvent(ReactContext reactContext, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(EVENT_NAME, (Object)params);
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }
}

