/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativerecordscreen;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.hardware.display.VirtualDisplay;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.Surface;
import androidx.core.content.ContextCompat;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.BaseActivityEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.reactnativerecordscreen.RecordScreenService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0007J\n\u0010'\u001a\u0004\u0018\u00010#H\u0002J\b\u0010(\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0007J\u0010\u0010/\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/reactnativerecordscreen/RecordScreenModule;", "Lcom/facebook/react/bridge/ReactContextBaseJavaModule;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "REQUEST_CODE", "", "connection", "Landroid/content/ServiceConnection;", "getConnection", "()Landroid/content/ServiceConnection;", "mActivityEventListener", "Lcom/facebook/react/bridge/ActivityEventListener;", "mBound", "", "mService", "Lcom/reactnativerecordscreen/RecordScreenService;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaRecorder", "Landroid/media/MediaRecorder;", "projectManager", "Landroid/media/projection/MediaProjectionManager;", "screenDensity", "screenHeight", "screenWidth", "startPromise", "Lcom/facebook/react/bridge/Promise;", "videoUri", "", "getVideoUri$beapp_react_native_screen_recorder_debug", "()Ljava/lang/String;", "setVideoUri$beapp_react_native_screen_recorder_debug", "(Ljava/lang/String;)V", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "clean", "", "promise", "createVirtualDisplay", "getName", "initRecorder", "setup", "readableMap", "Lcom/facebook/react/bridge/ReadableMap;", "shareScreen", "startRecording", "stopRecording", "MediaProjectionCallback", "beapp_react-native-screen-recorder_debug"})
public final class RecordScreenModule
extends ReactContextBaseJavaModule {
    private final int REQUEST_CODE = 1000;
    private int screenDensity;
    private MediaProjectionManager projectManager;
    private MediaProjection mediaProjection;
    private VirtualDisplay virtualDisplay;
    private MediaRecorder mediaRecorder;
    private RecordScreenService mService;
    private boolean mBound;
    @NotNull
    private String videoUri;
    private int screenWidth;
    private int screenHeight;
    private Promise startPromise;
    @NotNull
    private final ServiceConnection connection;
    private final ActivityEventListener mActivityEventListener;

    @NotNull
    public final String getVideoUri$beapp_react_native_screen_recorder_debug() {
        return this.videoUri;
    }

    public final void setVideoUri$beapp_react_native_screen_recorder_debug(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.videoUri = string;
    }

    @NotNull
    public String getName() {
        return "RecordScreen";
    }

    @NotNull
    public final ServiceConnection getConnection() {
        return this.connection;
    }

    @ReactMethod
    public final void setup(@NotNull ReadableMap readableMap) {
        Intrinsics.checkParameterIsNotNull((Object)readableMap, (String)"readableMap");
        Object object = this.getReactApplicationContext().getSystemService("media_projection");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        }
        this.projectManager = (MediaProjectionManager)object;
        DisplayMetrics metrics = new DisplayMetrics();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)reactApplicationContext, (String)"reactApplicationContext");
        Activity activity = reactApplicationContext.getCurrentActivity();
        if (activity != null && (activity = activity.getWindowManager()) != null && (activity = activity.getDefaultDisplay()) != null) {
            activity.getMetrics(metrics);
        }
        this.screenDensity = metrics.densityDpi;
        this.screenWidth = 720;
        this.screenHeight = 1280;
    }

    private final VirtualDisplay createVirtualDisplay() {
        VirtualDisplay virtualDisplay;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            MediaRecorder mediaRecorder = this.mediaRecorder;
            virtualDisplay = mediaProjection.createVirtualDisplay("ScreenSharing", this.screenWidth, this.screenHeight, this.screenDensity, 16, (Surface)(mediaRecorder != null ? mediaRecorder.getSurface() : null), null, null);
        } else {
            virtualDisplay = null;
        }
        return virtualDisplay;
    }

    private final void shareScreen() {
        block4: {
            if (this.mediaProjection == null) {
                MediaProjectionManager mediaProjectionManager = this.projectManager;
                if (mediaProjectionManager == null) {
                    Intrinsics.throwNpe();
                }
                Intent i = mediaProjectionManager.createScreenCaptureIntent();
                Activity activity = this.getCurrentActivity();
                if (activity == null) {
                    Intrinsics.throwNpe();
                }
                activity.startActivityForResult(i, this.REQUEST_CODE);
                return;
            }
            this.virtualDisplay = this.createVirtualDisplay();
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.start();
            Promise promise = this.startPromise;
            if (promise == null) break block4;
            promise.resolve(null);
        }
    }

    @ReactMethod
    public final void startRecording(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        this.startPromise = promise;
        this.shareScreen();
    }

    private final void initRecorder() {
        try {
            MediaRecorder mediaRecorder = this.mediaRecorder = new MediaRecorder();
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.setAudioSource(1);
            MediaRecorder mediaRecorder2 = this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.setVideoSource(2);
            CamcorderProfile profile = CamcorderProfile.get((int)5);
            MediaRecorder mediaRecorder3 = this.mediaRecorder;
            if (mediaRecorder3 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder3.setOutputFormat(profile.fileFormat);
            MediaRecorder mediaRecorder4 = this.mediaRecorder;
            if (mediaRecorder4 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder4.setVideoFrameRate(profile.videoFrameRate);
            MediaRecorder mediaRecorder5 = this.mediaRecorder;
            if (mediaRecorder5 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder5.setVideoSize(profile.videoFrameHeight, profile.videoFrameWidth);
            MediaRecorder mediaRecorder6 = this.mediaRecorder;
            if (mediaRecorder6 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder6.setVideoEncodingBitRate(profile.videoBitRate);
            MediaRecorder mediaRecorder7 = this.mediaRecorder;
            if (mediaRecorder7 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder7.setVideoEncoder(profile.videoCodec);
            MediaRecorder mediaRecorder8 = this.mediaRecorder;
            if (mediaRecorder8 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder8.setAudioEncodingBitRate(profile.audioBitRate);
            MediaRecorder mediaRecorder9 = this.mediaRecorder;
            if (mediaRecorder9 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder9.setAudioChannels(profile.audioChannels);
            MediaRecorder mediaRecorder10 = this.mediaRecorder;
            if (mediaRecorder10 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder10.setAudioSamplingRate(profile.audioSampleRate);
            MediaRecorder mediaRecorder11 = this.mediaRecorder;
            if (mediaRecorder11 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder11.setAudioEncoder(profile.audioCodec);
            this.videoUri = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).toString() + ("/" + "screen_recording-" + new SimpleDateFormat("dd-MM-yyyy-hh_mm_ss").format(new Date()) + ".mp4");
            MediaRecorder mediaRecorder12 = this.mediaRecorder;
            if (mediaRecorder12 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder12.setOutputFile(this.videoUri);
            MediaRecorder mediaRecorder13 = this.mediaRecorder;
            if (mediaRecorder13 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder13.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public final void stopRecording(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        try {
            String string = "stopping";
            boolean bl = false;
            System.out.println((Object)string);
            if (Build.VERSION.SDK_INT >= 26) {
                RecordScreenService recordScreenService = this.mService;
                if (recordScreenService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mService");
                }
                this.videoUri = recordScreenService.stop();
            } else {
                MediaRecorder mediaRecorder = this.mediaRecorder;
                if (mediaRecorder == null) {
                    Intrinsics.throwNpe();
                }
                mediaRecorder.stop();
                MediaRecorder mediaRecorder2 = this.mediaRecorder;
                if (mediaRecorder2 == null) {
                    Intrinsics.throwNpe();
                }
                mediaRecorder2.release();
            }
            WritableNativeMap response = new WritableNativeMap();
            WritableNativeMap result = new WritableNativeMap();
            result.putString("videoUrl", this.videoUri);
            response.putString("status", "success");
            response.putMap("result", (ReadableMap)result);
            promise.resolve((Object)response);
        }
        catch (RuntimeException err) {
            err.printStackTrace();
            promise.reject((Throwable)err);
        }
    }

    @ReactMethod
    public final void clean(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        String string = "clean";
        boolean bl = false;
        System.out.println((Object)string);
        promise.resolve(null);
    }

    public RecordScreenModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkParameterIsNotNull((Object)reactContext, (String)"reactContext");
        super(reactContext);
        this.REQUEST_CODE = 1000;
        this.videoUri = "";
        this.connection = new ServiceConnection(this){
            final /* synthetic */ RecordScreenModule this$0;

            public void onServiceConnected(@NotNull ComponentName className, @NotNull IBinder service) {
                Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
                Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                RecordScreenService.LocalBinder binder = (RecordScreenService.LocalBinder)service;
                RecordScreenModule.access$setMService$p(this.this$0, binder.getService());
                RecordScreenModule.access$setMBound$p(this.this$0, true);
            }

            public void onServiceDisconnected(@NotNull ComponentName arg0) {
                Intrinsics.checkParameterIsNotNull((Object)arg0, (String)"arg0");
                RecordScreenModule.access$setMBound$p(this.this$0, false);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.mActivityEventListener = (ActivityEventListener)new BaseActivityEventListener(this){
            final /* synthetic */ RecordScreenModule this$0;

            public void onActivityResult(@NotNull Activity activity, int requestCode, int resultCode, @NotNull Intent data) {
                block9: {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                    if (requestCode != RecordScreenModule.access$getREQUEST_CODE$p(this.this$0)) {
                        Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                        if (promise != null) {
                            promise.reject("RECORDING_WRONG_CODE", "Wrong request code.");
                        }
                        return;
                    }
                    if (resultCode != -1) {
                        Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                        if (promise != null) {
                            promise.reject("RECORDING_REJECTED.", "User rejected recording");
                        }
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 26) {
                        Object object = new Intent((Context)RecordScreenModule.access$getReactApplicationContext(this.this$0), RecordScreenService.class);
                        boolean bl = false;
                        boolean bl2 = false;
                        Intent $this$apply = object;
                        boolean bl3 = false;
                        RecordScreenModule.access$getReactApplicationContext(this.this$0).bindService($this$apply, this.this$0.getConnection(), 1);
                        $this$apply.setAction("RecordScreenService:Start");
                        $this$apply.putExtra("RecordScreenService:Extra:ResultData", (Parcelable)data);
                        $this$apply.putExtra("RecordScreenService:Extra:ScreenWidthData", RecordScreenModule.access$getScreenWidth$p(this.this$0));
                        $this$apply.putExtra("RecordScreenService:Extra:ScreenHeightData", RecordScreenModule.access$getScreenHeight$p(this.this$0));
                        $this$apply.putExtra("RecordScreenService:Extra:ScreenDensityData", RecordScreenModule.access$getScreenDensity$p(this.this$0));
                        Intent captureIntent = object;
                        ContextCompat.startForegroundService((Context)((Context)RecordScreenModule.access$getReactApplicationContext(this.this$0)), (Intent)captureIntent);
                        object = "started recording";
                        bl = false;
                        System.out.print(object);
                        Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                        if (promise != null) {
                            promise.resolve(null);
                        }
                        return;
                    }
                    RecordScreenModule.access$initRecorder(this.this$0);
                    MediaProjectionManager mediaProjectionManager = RecordScreenModule.access$getProjectManager$p(this.this$0);
                    if (mediaProjectionManager == null) {
                        Intrinsics.throwNpe();
                    }
                    RecordScreenModule.access$setMediaProjection$p(this.this$0, mediaProjectionManager.getMediaProjection(resultCode, data));
                    MediaProjection mediaProjection = RecordScreenModule.access$getMediaProjection$p(this.this$0);
                    if (mediaProjection == null) {
                        Intrinsics.throwNpe();
                    }
                    mediaProjection.registerCallback((MediaProjection.Callback)this.this$0.new MediaProjectionCallback(), null);
                    RecordScreenModule.access$setVirtualDisplay$p(this.this$0, RecordScreenModule.access$createVirtualDisplay(this.this$0));
                    MediaRecorder mediaRecorder = RecordScreenModule.access$getMediaRecorder$p(this.this$0);
                    if (mediaRecorder != null) {
                        mediaRecorder.start();
                    }
                    Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                    if (promise == null) break block9;
                    promise.resolve(null);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        reactContext.addActivityEventListener(this.mActivityEventListener);
    }

    public static final /* synthetic */ void access$setMediaRecorder$p(RecordScreenModule $this, MediaRecorder mediaRecorder) {
        $this.mediaRecorder = mediaRecorder;
    }

    public static final /* synthetic */ MediaProjection access$getMediaProjection$p(RecordScreenModule $this) {
        return $this.mediaProjection;
    }

    public static final /* synthetic */ RecordScreenService access$getMService$p(RecordScreenModule $this) {
        RecordScreenService recordScreenService = $this.mService;
        if (recordScreenService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mService");
        }
        return recordScreenService;
    }

    public static final /* synthetic */ void access$setMService$p(RecordScreenModule $this, RecordScreenService recordScreenService) {
        $this.mService = recordScreenService;
    }

    public static final /* synthetic */ boolean access$getMBound$p(RecordScreenModule $this) {
        return $this.mBound;
    }

    public static final /* synthetic */ void access$setMBound$p(RecordScreenModule $this, boolean bl) {
        $this.mBound = bl;
    }

    public static final /* synthetic */ int access$getREQUEST_CODE$p(RecordScreenModule $this) {
        return $this.REQUEST_CODE;
    }

    public static final /* synthetic */ Promise access$getStartPromise$p(RecordScreenModule $this) {
        return $this.startPromise;
    }

    public static final /* synthetic */ void access$setStartPromise$p(RecordScreenModule $this, Promise promise) {
        $this.startPromise = promise;
    }

    public static final /* synthetic */ ReactApplicationContext access$getReactApplicationContext(RecordScreenModule $this) {
        return $this.getReactApplicationContext();
    }

    public static final /* synthetic */ int access$getScreenWidth$p(RecordScreenModule $this) {
        return $this.screenWidth;
    }

    public static final /* synthetic */ void access$setScreenWidth$p(RecordScreenModule $this, int n) {
        $this.screenWidth = n;
    }

    public static final /* synthetic */ int access$getScreenHeight$p(RecordScreenModule $this) {
        return $this.screenHeight;
    }

    public static final /* synthetic */ void access$setScreenHeight$p(RecordScreenModule $this, int n) {
        $this.screenHeight = n;
    }

    public static final /* synthetic */ int access$getScreenDensity$p(RecordScreenModule $this) {
        return $this.screenDensity;
    }

    public static final /* synthetic */ void access$setScreenDensity$p(RecordScreenModule $this, int n) {
        $this.screenDensity = n;
    }

    public static final /* synthetic */ void access$initRecorder(RecordScreenModule $this) {
        $this.initRecorder();
    }

    public static final /* synthetic */ MediaProjectionManager access$getProjectManager$p(RecordScreenModule $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ void access$setProjectManager$p(RecordScreenModule $this, MediaProjectionManager mediaProjectionManager) {
        $this.projectManager = mediaProjectionManager;
    }

    public static final /* synthetic */ VirtualDisplay access$getVirtualDisplay$p(RecordScreenModule $this) {
        return $this.virtualDisplay;
    }

    public static final /* synthetic */ void access$setVirtualDisplay$p(RecordScreenModule $this, VirtualDisplay virtualDisplay) {
        $this.virtualDisplay = virtualDisplay;
    }

    public static final /* synthetic */ VirtualDisplay access$createVirtualDisplay(RecordScreenModule $this) {
        return $this.createVirtualDisplay();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/reactnativerecordscreen/RecordScreenModule$MediaProjectionCallback;", "Landroid/media/projection/MediaProjection$Callback;", "(Lcom/reactnativerecordscreen/RecordScreenModule;)V", "onStop", "", "beapp_react-native-screen-recorder_debug"})
    public final class MediaProjectionCallback
    extends MediaProjection.Callback {
        public void onStop() {
            MediaRecorder mediaRecorder = RecordScreenModule.this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.stop();
            MediaRecorder mediaRecorder2 = RecordScreenModule.this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.reset();
            RecordScreenModule.this.mediaProjection = null;
        }
    }
}

