/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativerecordscreen;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.AudioRecord;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcelable;
import android.view.Surface;
import androidx.core.app.NotificationCompat;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016J\"\u0010#\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0006\u0010&\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/reactnativerecordscreen/RecordScreenService;", "Landroid/app/Service;", "()V", "audioCaptureThread", "Ljava/lang/Thread;", "audioRecord", "Landroid/media/AudioRecord;", "binder", "Lcom/reactnativerecordscreen/RecordScreenService$LocalBinder;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "mediaRecorder", "Landroid/media/MediaRecorder;", "videoUri", "", "getVideoUri$beapp_react_native_screen_recorder_debug", "()Ljava/lang/String;", "setVideoUri$beapp_react_native_screen_recorder_debug", "(Ljava/lang/String;)V", "createNotificationChannel", "", "createVirtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "screenWidth", "", "screenHeight", "screenDensity", "initRecorder", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onStartCommand", "flags", "startId", "stop", "Companion", "LocalBinder", "beapp_react-native-screen-recorder_debug"})
public final class RecordScreenService
extends Service {
    private MediaProjectionManager mediaProjectionManager;
    private MediaProjection mediaProjection;
    private MediaRecorder mediaRecorder;
    @NotNull
    private String videoUri = "";
    private final LocalBinder binder = new LocalBinder();
    private Thread audioCaptureThread;
    private AudioRecord audioRecord;
    private static final String LOG_TAG = "AudioCaptureService";
    private static final int SERVICE_ID = 123;
    private static final String NOTIFICATION_CHANNEL_ID = "AudioCapture channel";
    private static final int NUM_SAMPLES_PER_READ = 1024;
    private static final int BYTES_PER_SAMPLE = 2;
    @NotNull
    public static final String ACTION_START = "RecordScreenService:Start";
    @NotNull
    public static final String EXTRA_RESULT_DATA = "RecordScreenService:Extra:ResultData";
    @NotNull
    public static final String SCREEN_WIDTH_DATA = "RecordScreenService:Extra:ScreenWidthData";
    @NotNull
    public static final String SCREEN_HEIGHT_DATA = "RecordScreenService:Extra:ScreenHeightData";
    @NotNull
    public static final String SCREEN_DENSITY_DATA = "RecordScreenService:Extra:ScreenDensityData";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getVideoUri$beapp_react_native_screen_recorder_debug() {
        return this.videoUri;
    }

    public final void setVideoUri$beapp_react_native_screen_recorder_debug(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.videoUri = string;
    }

    public void onCreate() {
        super.onCreate();
        this.createNotificationChannel();
        this.startForeground(123, new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_ID).build());
        Object object = this.getApplicationContext().getSystemService("media_projection");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        }
        this.mediaProjectionManager = (MediaProjectionManager)object;
    }

    @NotNull
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        return (IBinder)this.binder;
    }

    private final void createNotificationChannel() {
        NotificationChannel serviceChannel = new NotificationChannel(NOTIFICATION_CHANNEL_ID, (CharSequence)"Record Screen Service Channel", 3);
        Object object = this.getSystemService(NotificationManager.class);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager manager = (NotificationManager)object;
        manager.createNotificationChannel(serviceChannel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (intent == null) return 2;
        String string = intent.getAction();
        if (string == null) throw (Throwable)new IllegalArgumentException("Unexpected action received: " + intent.getAction());
        String string2 = string;
        switch (string2.hashCode()) {
            case -2041863680: {
                if (!string2.equals(ACTION_START)) throw (Throwable)new IllegalArgumentException("Unexpected action received: " + intent.getAction());
                MediaProjectionManager mediaProjectionManager = this.mediaProjectionManager;
                if (mediaProjectionManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mediaProjectionManager");
                }
                Parcelable parcelable = intent.getParcelableExtra(EXTRA_RESULT_DATA);
                if (parcelable == null) {
                    Intrinsics.throwNpe();
                }
                MediaProjection mediaProjection = mediaProjectionManager.getMediaProjection(-1, (Intent)parcelable);
                if (mediaProjection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjection");
                }
                this.mediaProjection = mediaProjection;
                this.initRecorder();
                this.createVirtualDisplay(intent.getIntExtra(SCREEN_WIDTH_DATA, 0), intent.getIntExtra(SCREEN_HEIGHT_DATA, 0), intent.getIntExtra(SCREEN_DENSITY_DATA, 0));
                MediaRecorder mediaRecorder = this.mediaRecorder;
                if (mediaRecorder == null) {
                    Intrinsics.throwNpe();
                }
                mediaRecorder.start();
                return 1;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unexpected action received: " + intent.getAction());
            }
        }
    }

    private final VirtualDisplay createVirtualDisplay(int screenWidth, int screenHeight, int screenDensity) {
        VirtualDisplay virtualDisplay;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            MediaRecorder mediaRecorder = this.mediaRecorder;
            virtualDisplay = mediaProjection.createVirtualDisplay("ScreenSharing", screenWidth, screenHeight, screenDensity, 16, (Surface)(mediaRecorder != null ? mediaRecorder.getSurface() : null), null, null);
        } else {
            virtualDisplay = null;
        }
        return virtualDisplay;
    }

    private final void initRecorder() {
        try {
            MediaRecorder mediaRecorder = this.mediaRecorder = new MediaRecorder();
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.setAudioSource(1);
            MediaRecorder mediaRecorder2 = this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.setVideoSource(2);
            CamcorderProfile profile = CamcorderProfile.get((int)5);
            MediaRecorder mediaRecorder3 = this.mediaRecorder;
            if (mediaRecorder3 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder3.setOutputFormat(profile.fileFormat);
            MediaRecorder mediaRecorder4 = this.mediaRecorder;
            if (mediaRecorder4 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder4.setVideoFrameRate(profile.videoFrameRate);
            MediaRecorder mediaRecorder5 = this.mediaRecorder;
            if (mediaRecorder5 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder5.setVideoSize(profile.videoFrameHeight, profile.videoFrameWidth);
            MediaRecorder mediaRecorder6 = this.mediaRecorder;
            if (mediaRecorder6 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder6.setVideoEncodingBitRate(profile.videoBitRate);
            MediaRecorder mediaRecorder7 = this.mediaRecorder;
            if (mediaRecorder7 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder7.setVideoEncoder(profile.videoCodec);
            MediaRecorder mediaRecorder8 = this.mediaRecorder;
            if (mediaRecorder8 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder8.setAudioEncodingBitRate(profile.audioBitRate);
            MediaRecorder mediaRecorder9 = this.mediaRecorder;
            if (mediaRecorder9 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder9.setAudioChannels(profile.audioChannels);
            MediaRecorder mediaRecorder10 = this.mediaRecorder;
            if (mediaRecorder10 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder10.setAudioSamplingRate(profile.audioSampleRate);
            MediaRecorder mediaRecorder11 = this.mediaRecorder;
            if (mediaRecorder11 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder11.setAudioEncoder(profile.audioCodec);
            this.videoUri = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).toString() + ("/" + "screen_recording-" + new SimpleDateFormat("dd-MM-yyyy-hh_mm_ss").format(new Date()) + ".mp4");
            MediaRecorder mediaRecorder12 = this.mediaRecorder;
            if (mediaRecorder12 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder12.setOutputFile(this.videoUri);
            MediaRecorder mediaRecorder13 = this.mediaRecorder;
            if (mediaRecorder13 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder13.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final String stop() {
        try {
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.stop();
            MediaRecorder mediaRecorder2 = this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.release();
        }
        catch (RuntimeException err) {
            String string = "neco spatne";
            boolean bl = false;
            System.out.println((Object)string);
            boolean bl2 = false;
            System.out.println(err);
        }
        return this.videoUri;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/reactnativerecordscreen/RecordScreenService$LocalBinder;", "Landroid/os/Binder;", "(Lcom/reactnativerecordscreen/RecordScreenService;)V", "getService", "Lcom/reactnativerecordscreen/RecordScreenService;", "beapp_react-native-screen-recorder_debug"})
    public final class LocalBinder
    extends Binder {
        @NotNull
        public final RecordScreenService getService() {
            return RecordScreenService.this;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/reactnativerecordscreen/RecordScreenService$Companion;", "", "()V", "ACTION_START", "", "BYTES_PER_SAMPLE", "", "EXTRA_RESULT_DATA", "LOG_TAG", "NOTIFICATION_CHANNEL_ID", "NUM_SAMPLES_PER_READ", "SCREEN_DENSITY_DATA", "SCREEN_HEIGHT_DATA", "SCREEN_WIDTH_DATA", "SERVICE_ID", "beapp_react-native-screen-recorder_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

