/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativerecordscreen;

import android.app.Activity;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Environment;
import android.util.DisplayMetrics;
import android.view.Surface;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.BaseActivityEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableNativeMap;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020\u001dH\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/reactnativerecordscreen/RecordScreenModule;", "Lcom/facebook/react/bridge/ReactContextBaseJavaModule;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "REQUEST_CODE", "", "mActivityEventListener", "Lcom/facebook/react/bridge/ActivityEventListener;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaRecorder", "Landroid/media/MediaRecorder;", "projectManager", "Landroid/media/projection/MediaProjectionManager;", "screenDensity", "screenHeight", "screenWidth", "startPromise", "Lcom/facebook/react/bridge/Promise;", "videoUri", "", "getVideoUri$beapp_react_native_screen_recorder_release", "()Ljava/lang/String;", "setVideoUri$beapp_react_native_screen_recorder_release", "(Ljava/lang/String;)V", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "clean", "", "promise", "createVirtualDisplay", "getName", "initRecorder", "setup", "readableMap", "Lcom/facebook/react/bridge/ReadableMap;", "shareScreen", "startRecording", "stopRecording", "MediaProjectionCallback", "beapp_react-native-screen-recorder_release"})
public final class RecordScreenModule
extends ReactContextBaseJavaModule {
    private final int REQUEST_CODE = 1000;
    private int screenDensity;
    private MediaProjectionManager projectManager;
    private MediaProjection mediaProjection;
    private VirtualDisplay virtualDisplay;
    private MediaRecorder mediaRecorder;
    @NotNull
    private String videoUri;
    private int screenWidth;
    private int screenHeight;
    private Promise startPromise;
    private final ActivityEventListener mActivityEventListener;

    @NotNull
    public final String getVideoUri$beapp_react_native_screen_recorder_release() {
        return this.videoUri;
    }

    public final void setVideoUri$beapp_react_native_screen_recorder_release(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.videoUri = string;
    }

    @NotNull
    public String getName() {
        return "RecordScreen";
    }

    @ReactMethod
    public final void setup(@NotNull ReadableMap readableMap) {
        Intrinsics.checkParameterIsNotNull((Object)readableMap, (String)"readableMap");
        Object object = this.getReactApplicationContext().getSystemService("media_projection");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        }
        this.projectManager = (MediaProjectionManager)object;
        DisplayMetrics metrics = new DisplayMetrics();
        ReactApplicationContext reactApplicationContext = this.getReactApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)reactApplicationContext, (String)"reactApplicationContext");
        Activity activity = reactApplicationContext.getCurrentActivity();
        if (activity != null && (activity = activity.getWindowManager()) != null && (activity = activity.getDefaultDisplay()) != null) {
            activity.getMetrics(metrics);
        }
        this.screenDensity = metrics.densityDpi;
        this.screenWidth = 720;
        this.screenHeight = 1280;
    }

    private final VirtualDisplay createVirtualDisplay() {
        VirtualDisplay virtualDisplay;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            MediaRecorder mediaRecorder = this.mediaRecorder;
            virtualDisplay = mediaProjection.createVirtualDisplay("ScreenSharing", this.screenWidth, this.screenHeight, this.screenDensity, 16, (Surface)(mediaRecorder != null ? mediaRecorder.getSurface() : null), null, null);
        } else {
            virtualDisplay = null;
        }
        return virtualDisplay;
    }

    private final void shareScreen() {
        block4: {
            if (this.mediaProjection == null) {
                MediaProjectionManager mediaProjectionManager = this.projectManager;
                if (mediaProjectionManager == null) {
                    Intrinsics.throwNpe();
                }
                Intent i = mediaProjectionManager.createScreenCaptureIntent();
                Activity activity = this.getCurrentActivity();
                if (activity == null) {
                    Intrinsics.throwNpe();
                }
                activity.startActivityForResult(i, this.REQUEST_CODE);
                return;
            }
            this.virtualDisplay = this.createVirtualDisplay();
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.start();
            Promise promise = this.startPromise;
            if (promise == null) break block4;
            promise.resolve(null);
        }
    }

    @ReactMethod
    public final void startRecording(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        this.startPromise = promise;
        this.initRecorder();
        this.shareScreen();
    }

    private final void initRecorder() {
        try {
            MediaRecorder mediaRecorder = this.mediaRecorder = new MediaRecorder();
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.setAudioSource(1);
            MediaRecorder mediaRecorder2 = this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.setVideoSource(2);
            CamcorderProfile profile = CamcorderProfile.get((int)5);
            MediaRecorder mediaRecorder3 = this.mediaRecorder;
            if (mediaRecorder3 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder3.setOutputFormat(profile.fileFormat);
            MediaRecorder mediaRecorder4 = this.mediaRecorder;
            if (mediaRecorder4 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder4.setVideoFrameRate(profile.videoFrameRate);
            MediaRecorder mediaRecorder5 = this.mediaRecorder;
            if (mediaRecorder5 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder5.setVideoSize(profile.videoFrameHeight, profile.videoFrameWidth);
            MediaRecorder mediaRecorder6 = this.mediaRecorder;
            if (mediaRecorder6 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder6.setVideoEncodingBitRate(profile.videoBitRate);
            MediaRecorder mediaRecorder7 = this.mediaRecorder;
            if (mediaRecorder7 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder7.setVideoEncoder(profile.videoCodec);
            MediaRecorder mediaRecorder8 = this.mediaRecorder;
            if (mediaRecorder8 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder8.setAudioEncodingBitRate(profile.audioBitRate);
            MediaRecorder mediaRecorder9 = this.mediaRecorder;
            if (mediaRecorder9 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder9.setAudioChannels(profile.audioChannels);
            MediaRecorder mediaRecorder10 = this.mediaRecorder;
            if (mediaRecorder10 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder10.setAudioSamplingRate(profile.audioSampleRate);
            MediaRecorder mediaRecorder11 = this.mediaRecorder;
            if (mediaRecorder11 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder11.setAudioEncoder(profile.audioCodec);
            this.videoUri = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).toString() + ("/" + "screen_recording-" + new SimpleDateFormat("dd-MM-yyyy-hh_mm_ss").format(new Date()) + ".mp4");
            MediaRecorder mediaRecorder12 = this.mediaRecorder;
            if (mediaRecorder12 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder12.setOutputFile(this.videoUri);
            MediaRecorder mediaRecorder13 = this.mediaRecorder;
            if (mediaRecorder13 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder13.prepare();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public final void stopRecording(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        try {
            WritableNativeMap response = new WritableNativeMap();
            WritableNativeMap result = new WritableNativeMap();
            result.putString("videoUrl", this.videoUri);
            response.putString("status", "success");
            response.putMap("result", (ReadableMap)result);
            MediaRecorder mediaRecorder = this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.stop();
            MediaRecorder mediaRecorder2 = this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.release();
            promise.resolve((Object)response);
        }
        catch (RuntimeException err) {
            err.printStackTrace();
            promise.reject((Throwable)err);
        }
    }

    @ReactMethod
    public final void clean(@NotNull Promise promise) {
        Intrinsics.checkParameterIsNotNull((Object)promise, (String)"promise");
        String string = "clean";
        boolean bl = false;
        System.out.println((Object)string);
        promise.resolve(null);
    }

    public RecordScreenModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkParameterIsNotNull((Object)reactContext, (String)"reactContext");
        super(reactContext);
        this.REQUEST_CODE = 1000;
        this.videoUri = "";
        this.mActivityEventListener = (ActivityEventListener)new BaseActivityEventListener(this){
            final /* synthetic */ RecordScreenModule this$0;

            public void onActivityResult(@NotNull Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
                    if (requestCode != RecordScreenModule.access$getREQUEST_CODE$p(this.this$0)) {
                        Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                        if (promise != null) {
                            promise.reject("RECORDING_WRONG_CODE", "Wrong request code.");
                        }
                        return;
                    }
                    if (resultCode != -1) {
                        Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                        if (promise != null) {
                            promise.reject("RECORDING_REJECTED.", "User rejected recording");
                        }
                        return;
                    }
                    MediaProjectionManager mediaProjectionManager = RecordScreenModule.access$getProjectManager$p(this.this$0);
                    if (mediaProjectionManager == null) {
                        Intrinsics.throwNpe();
                    }
                    RecordScreenModule.access$setMediaProjection$p(this.this$0, mediaProjectionManager.getMediaProjection(resultCode, data));
                    MediaProjection mediaProjection = RecordScreenModule.access$getMediaProjection$p(this.this$0);
                    if (mediaProjection == null) {
                        Intrinsics.throwNpe();
                    }
                    mediaProjection.registerCallback((MediaProjection.Callback)this.this$0.new MediaProjectionCallback(), null);
                    RecordScreenModule.access$setVirtualDisplay$p(this.this$0, RecordScreenModule.access$createVirtualDisplay(this.this$0));
                    MediaRecorder mediaRecorder = RecordScreenModule.access$getMediaRecorder$p(this.this$0);
                    if (mediaRecorder != null) {
                        mediaRecorder.start();
                    }
                    Promise promise = RecordScreenModule.access$getStartPromise$p(this.this$0);
                    if (promise == null) break block7;
                    promise.resolve(null);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        reactContext.addActivityEventListener(this.mActivityEventListener);
    }

    public static final /* synthetic */ void access$setMediaRecorder$p(RecordScreenModule $this, MediaRecorder mediaRecorder) {
        $this.mediaRecorder = mediaRecorder;
    }

    public static final /* synthetic */ MediaProjection access$getMediaProjection$p(RecordScreenModule $this) {
        return $this.mediaProjection;
    }

    public static final /* synthetic */ int access$getREQUEST_CODE$p(RecordScreenModule $this) {
        return $this.REQUEST_CODE;
    }

    public static final /* synthetic */ Promise access$getStartPromise$p(RecordScreenModule $this) {
        return $this.startPromise;
    }

    public static final /* synthetic */ void access$setStartPromise$p(RecordScreenModule $this, Promise promise) {
        $this.startPromise = promise;
    }

    public static final /* synthetic */ MediaProjectionManager access$getProjectManager$p(RecordScreenModule $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ void access$setProjectManager$p(RecordScreenModule $this, MediaProjectionManager mediaProjectionManager) {
        $this.projectManager = mediaProjectionManager;
    }

    public static final /* synthetic */ VirtualDisplay access$getVirtualDisplay$p(RecordScreenModule $this) {
        return $this.virtualDisplay;
    }

    public static final /* synthetic */ void access$setVirtualDisplay$p(RecordScreenModule $this, VirtualDisplay virtualDisplay) {
        $this.virtualDisplay = virtualDisplay;
    }

    public static final /* synthetic */ VirtualDisplay access$createVirtualDisplay(RecordScreenModule $this) {
        return $this.createVirtualDisplay();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/reactnativerecordscreen/RecordScreenModule$MediaProjectionCallback;", "Landroid/media/projection/MediaProjection$Callback;", "(Lcom/reactnativerecordscreen/RecordScreenModule;)V", "onStop", "", "beapp_react-native-screen-recorder_release"})
    public final class MediaProjectionCallback
    extends MediaProjection.Callback {
        public void onStop() {
            MediaRecorder mediaRecorder = RecordScreenModule.this.mediaRecorder;
            if (mediaRecorder == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder.stop();
            MediaRecorder mediaRecorder2 = RecordScreenModule.this.mediaRecorder;
            if (mediaRecorder2 == null) {
                Intrinsics.throwNpe();
            }
            mediaRecorder2.reset();
            RecordScreenModule.this.mediaProjection = null;
        }
    }
}

