/*!
 * @since Last modified: 2026-1-11 15:12:29
 * @name AXUI front-end framework.
 * @version 3.1.34
 * @author AXUI development team <3217728223@qq.com>
 * @description The AXUI front-end framework is built on HTML5, CSS3, and JavaScript standards, with TypeScript used for type management.
 * @see {@link https://www.axui.cn|Official website}
 * @see {@link https://github.com/codady/axui/issues|github issues}
 * @see {@link https://gitee.com/codady/axui/issues|Gitee issues}
 * @see {@link https://www.npmjs.com/package/@codady/axui|NPM}
 * @issue QQ Group No.1:952502085
 * @copyright This software supports the MIT License, allowing free learning and commercial use, but please retain the terms 'ax,' 'axui,' 'AX,' and 'AXUI' within the software.
 * @license MIT license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?module.exports=e():"function"==typeof define&&define.amd?define(e):(t="undefined"!=typeof globalThis?globalThis:t||self).ax=e()}(this,(function(){"use strict";const isNull=t=>[void 0,null,"undefined","null"].includes(t),augment=function(t){if(isNull(t)||!t.name)return;let e;if(t.target&&"ax"!==t.target){for(let s in this)if(this[s].name===t.target){e=this[s];break}if(!e)throw new Error(`Cannot find the ${t.target} property in the ax object!`)}else e=this;"method"===t.type?e[e.prototype?"prototype":"__proto__"][t.name]=t.data:Reflect.set(e,t.name,t.data)},t=getComputedStyle(document.documentElement),_getCssVar=e=>t.getPropertyValue(e).trim(),e=_getCssVar("--PREFIX").trim(),s={frame:0,ajaxStor:[],styles:t,cssVar:_getCssVar,prefix:e,alias:_getCssVar(`--${e}alias`),screen:_getCssVar(`--${e}screen`),fullGap:_getCssVar(`--${e}g-full`),fsRoot:_getCssVar(`--${e}fs-root`),images:{spin:_getCssVar(`--${e}spin`).split('"')[1],spinDk:_getCssVar(`--${e}spin-dk`).split('"')[1],blank:_getCssVar(`--${e}blank`).split('"')[1],avatar:_getCssVar(`--${e}avatar`).split('"')[1],empty:_getCssVar(`--${e}empty`).split('"')[1],none:_getCssVar(`--${e}none`).split('"')[1]},curves:{linear:_getCssVar(`--${e}bez-linear`),ease:_getCssVar(`--${e}bez-ease`),easeOut:_getCssVar(`--${e}bez-eo`),easeIn:_getCssVar(`--${e}bez-ei`),easeInOut:_getCssVar(`--${e}bez-eio`),easeOutIn:_getCssVar(`--${e}bez-eoi`)},isNarrowScr:~~_getCssVar(`--${e}isnarrow`),isTouchScr:"ontouchstart"in document.documentElement,dragNode:null,compSign:"comp",embedSign:"embed",namePfx:"TMP_",messages:[],valids:[],augment:augment,tasks:[],swatches:["#ff6b6b","#e83e8c","#f72585","#e64980","#ff922b","#feca57","#51cf66","#94d82d","#20c997","#0ca678","#4cc9f0","#228be6","#4263eb","#364fc7","#6d5dfc","#7209b7","#3a0ca3","#7950f2","#be4bdb","#343a40","#495057","#6c757d","#adb5bd","#e9ecef","#f8f9fa","#ffffff"],colorStor:"CUSTOM_COLOR"},i=["input","file","textarea","range","number","datetime","upload","select","radio","checkbox","radios","checkboxes","editor"],a={name:"zh-CN",support:{content:"由于AXUI使用了<code>:has</code>的css伪类选择器，而您的浏览器相对陈旧，请更新至<code>Chrome105</code>以上内核的浏览器！",cancel:"下次再提醒我",confirm:"我知道了"},privacy:{content:"我们使用Cookie来确保您在我们的网站上获得最佳体验，并为您提供个性化服务。继续浏览即表示您同意我们的Cookie政策。",cancel:"拒绝",confirm:"接受"},ajax:{abort:`<i class="${s.prefix}c-warn">中止了请求！</i>`,timeout:`<i class="${s.prefix}c-error">请求超时了！</i>`,error:`<i class="${s.prefix}c-error">错误状态：{{this.status}}</i>`,submit:{btn:"正在提交",succ:"恭喜，提交成功！",fail:"对不起，提交失败！"}},more:{unfold:"收起",fold:"折叠"},button:{default:"新按钮",confirm:"确定",cancel:"取消",clear:"清除",close:"关闭",reset:"重置",submit:"提交",now:"现在",prev:"上一个",next:"下一个"},placehold:{note:"请写上备注内容！",fileName:"新文件",downloadName:"下载文件"},form:{placeholder:"请输入...",fileLabel:"请选择文件...",fileMulti:"{{this.data}}个文件：",maxLength:"最多可输入{{this.total}}个字符，已输入{{this.value}}个，还可以输入{{this.remaining}}个。",minLength:"至少输入{{this.min}}个字符，已输入{{this.value}}个，还要输入{{this.remaining}}个。",limitLength:"至少输入{{this.min}}个字符，最多可输入{{this.max}}个字符，已输入{{this.value}}个。",maxNumber:"最大取值{{this.max}}。",minNumber:"最小取值{{this.min}}。",limitNumber:"取值范围{{this.min}}~{{this.max}}。",exceed:"已超限。",range:"取值范围{{this.min}}~{{this.max}}。"},color:{label:{h:"色相 (H)",s:"饱和度 (S)",v:"明度 (V)",l:"亮度 (L)",a:"透明度 (A)",hsv:"HSV模式",hsl:"HSL模式"},btn:{random:"随机位置",change:"切换模式",straw:"吸色",restore:"重置",clear:"清空",save:"保存",copy:"复制",confirm:"确定",add:"从拾色器自定义颜色"},message:{preset:"是否存为所有拾色器实例共用的预设色值？",copy:"复制成功！可Ctrl+V粘贴到文档中。"},regular:"常用颜色",theme:"主题颜色",history:"最近使用的颜色",add:{heading:"添加颜色",content:"是否添加<code>{{this.value}}</code>颜色到调色盘？"}},range:{result:"结果:{{this.multiple?this.range[0]+'-'+this.range[1]:this.value}}"},valid:{regLocal:"一-龥",types:{a:"小写字母",A:"大写字母",d:"数字","~":"特殊字符","@":"中文字符"},message:{wrongRule:"校验规则错误，请修正！",wrongFormat:"值格式错误，应该为文本格式！",noValids:"表单没有任何校验字段！"},strFormat:"值格式错误，应该为文本格式！",arrFormat:"参数格式错误，应该为数组格式！",succ:'{{ this.label || "" }}通过校验！',fail:'{{ this.label || "" }}校验失败！',required:"{{ this.label }}是必填项！",email:"{{ this.label }}请填写正确的邮箱！",cellphone:"{{ this.label }}请填写11位手机号！",landline:"{{ this.label }}请填写正确的座机号码！",ip:"{{ this.label }}请填写正确的IP地址！",id:"{{ this.label }}请填写正确的身份证号！",zip:"{{ this.label }}只能填写6位数字邮编！",url:"{{ this.label }}请填写正确的域名！",plate:"{{ this.label }}请填写正确的车牌号！",locale:"{{ this.label }}只能填写中文！",letter:"{{ this.label }}只能填写大小写英文字母！",string:"{{ this.label }}只能填写大小写英文字母和数字！",password:"{{ this.label }}只能填写大小写英文字母、数字以及特殊字符！",ymdhms:"{{ this.label }}只能填写类似2022-11-13 2:56:12的日期格式！",ymd:"{{ this.label }}只能填写类似2022-11-13的日期格式！",hms:"{{ this.label }}只能填写类似2:56:12的日期格式！",ym:"{{ this.label }}只能填写类似2022-11的日期格式！",y:"{{ this.label }}只能填写4位数字年份！",m:"{{ this.label }}只能填写1~12月份！",d:"{{ this.label }}只能填写1~31日！",date:"{{ this.label }}请填写有效的日期！",integer:"{{ this.label }}只能填写非0开头的正整数！",number:"{{ this.label }}只能填写数字，包括正数、负数、整数、小数！","date=":"{{ this.label }}只能是{{ this.data }}！","date>":"{{ this.label }}需超过{{ this.data }}！","date>=":"{{ this.label }}不可早于{{ this.data }}！","date<":"{{ this.label }}不可超过{{ this.data }}！","date<=":"{{ this.label }}不可晚于{{ this.data }}！","date><":"{{ this.label }}需超过{{ this.data[0] }}，且不可超过{{ this.data[1] }}！","date><=":"{{ this.label }}需超过{{ this.data[0] }}，且不可超过或等于{{ this.data[1] }}！","date>=<":"{{ this.label }}需超过或等于{{ this.data[0] }}，且不可超过{{ this.data[1] }}！","date>=<=":"{{ this.label }}不可早于{{ this.data[0] }}，且不可晚于{{ this.data[1] }}！","than=":"{{ this.label }}需要等于{{ this.data }}！","than>":"{{ this.label }}需要大于{{ this.data }}！","than>=":"{{ this.label }}需要大于或等于{{ this.data }}！","than<":"{{ this.label }}需要小于{{ this.data }}！","than<=":"{{ this.label }}需要小于或等于{{ this.data }}！","than><":"{{ this.label }}需要大于{{ this.data[0] }}，且小于{{ this.data[1] }}！","than><=":"{{ this.label }}需要大于{{ this.data[0] }}个，且小于等于{{ this.data[1] }}！","than>=<":"{{ this.label }}需要大于等于{{ this.data[0] }}个，且小于{{ this.data[1] }}！","than>=<=":"{{ this.label }}需要大于等于{{ this.data[0] }}个，且小于等于{{ this.data[1] }}！","length=":"{{ this.label }}已输入{{ this.value.length }}个字符，只能填写{{ this.data }}个字符！","length>":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量需多于{{ this.data }}个！","length>=":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量不可少于{{ this.data }}个！","length<":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量需少于{{ this.data }}个！","length<=":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量不可多于{{ this.data }}个！","length><":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量需多于{{ this.data[0] }}个，且少于{{ this.data[1] }}个！","length><=":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量需多于{{ this.data[0] }}个，且少于或等于{{ this.data[1] }}个！","length>=<":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量需多于或等于{{ this.data[0] }}个，且少于{{ this.data[1] }}个！","length>=<=":"{{ this.label }}已输入{{ this.value.length }}个字符，字符数量不可少于{{ this.data[0] }}个，且不可多于{{ this.data[1] }}个！","count=":"{{ this.label }}有{{ this.value }}项，必须且只能选择{{ this.data }}项！","count>":"{{ this.label }}有{{ this.value }}项，选择项需要多于{{ this.data }}！","count>=":"{{ this.label }}有{{ this.value }}项，至少选择{{ this.data }}项！","count<":"{{ this.label }}有{{ this.value }}项，选择项需要少于{{ this.data }}！","count<=":"{{ this.label }}有{{ this.value }}项，最多选择{{ this.data }}项！","count><":"{{ this.label }}有{{ this.value }}项，选择项需多于{{ this.data[0] }}，且少于{{ this.data[1] }}！","count><=":"{{ this.label }}有{{ this.value }}项，选择项需多于{{ this.data[0] }}，且少于或等于{{ this.data[1] }}！","count>=<":"{{ this.label }}有{{ this.value }}项，选择项需多于或等于{{ this.data[0] }}，且少于{{ this.data[1] }}！","count>=<=":"{{ this.label }}有{{ this.value }}项，至少选择{{ this.data[0] }}项，且不能多于{{ this.data[1] }}项！",include:'{{ this.label }}的值应该在"{{ this.data }}"之中！',exclude:'{{ this.label }}的值不能在"{{ this.data }}"之中！',same:'{{ this.label }}字段值与"{{ this.data[1] || this.data[0] }}"字段值不一致！',different:'{{ this.label }}字段值不能与"{{ this.data[1] || this.data[0] }}"字段值一致！',strength:"{{ this.label }}的当前强度为{{ this.value}}，要求达到{{ this.data }}！",specific:"{{ this.label }}要求{{ for(let k in this.data){/}}{{k+'至少'+this.data[k]+'个'}}{{ (Object.keys(this.data).slice(-1)[0] !== k)? '，':''}}{{}/}}！",combine:"{{ this.label }}要求{{ this.data.types.join('、') }}至少{{ this.data.total }}种！"},status:{warn:"有警告",succ:"完成了",error:"有报错",issue:"有疑问",info:"有消息",confirm:"已确认",cancel:"已取消",forbid:"已禁用"},message:{heading:{warn:"操作警告！",succ:"操作成功！",error:"操作失败！",issue:"操作疑问！",info:"信息提示！"},content:{warn:"警告！运行过程中可能存在故障，请注意排查！",succ:"恭喜！运行顺利或者操作成功！",error:"失败！运行过程中发生了错误或操作失败！",issue:"有疑问！运行过程中遇到一些问题需要解决！",info:"提示！运行中未出现状况，请继续！"}},toast:{content:{warn:"系统异常！",succ:"操作成功！",error:"操作失败！",issue:"操作存疑？",info:"系统提示！"}},viewer:{close:"关闭查看器",play:"已暂停，点击播放",pause:"播放中，点击暂停",fullscrOn:"非全屏，点击展开",fullscrOff:"全屏中，点击退出",rotatel:"逆时针旋转90°",rotater:"顺时针旋转90°",flipv:"垂直翻转",fliph:"水平翻转",download:"下载媒体文件",thumb:"切换缩略图",zoom:"切换缩放模式",zoomin:"放大",zoomout:"缩小",expand:"侧边栏已收起，点击展开",collapse:"侧边栏已展开，点击收起"},tree:{empty:"没有树形数据",label:"新分支",title:{folder:"新增枝干分支",file:"新增叶子分支",edit:"编辑分支",remove:"删除分支",arrow:"点击折叠或展开"},message:{remove:'确定要删除"{{this.label}}"分支么'},paginated:{more:"查看更多",next:"下一页",first:"返回首页",info:'"{{this.label}}"还剩{{this.rest}}条信息',main:"主分支"},result:`<i ${s.alias}="holder">还未选择...</i>`},accordion:{label:"新板块",content:"新内容",extra:"更多内容",title:{add:"新增板块",edit:"编辑板块",remove:"删除板块",arrow:"点击折叠或展开"},message:{remove:'确定要删除"{{this.label}}"板块么'}},tab:{label:"新标签",content:"新内容",title:{add:"新增页签",edit:"编辑页签",close:"删除页签",move:"移动页签",update:"更新页签"},message:{add:'确定要新增"{{this.label}}"页签么',edit:'确定要编辑"{{this.label}}"页签么',close:'确定要删除"{{this.label}}"页签么',move:'确定要移动"{{this.label}}"页签么',update:'确定要更新"{{this.label}}"页签么'}},flat:{label:"新项目"},spy:{isObserved:"媒体文件{{ this.src }}已经处于监听状态，不需要添加监听操作！",isUnobserved:"媒体文件{{ this.src }}还未被监听，不需要取消监听操作！"},tags:{emptyholder:"还没有创建标签！",placeholder:"请输入...",includePart:"包含了重复的标签!",includeFull:"标签完全重复，添加失败!"},retrieval:{status:"共有<u>{{this.value}}</u>个结果符合<s>{{this.keys}}</s>要求！",nullKeys:"没有检索词且没有检索结果！"},drag:{holderDrag:"转移中...",holderDrop:"释放到这里...",holderEmpty:"可拖入这里"},progress:{complete:"已完成!",tips:"当前进度"},infinite:{finish:"没有更多内容了",error:"请求终止，已停止加载",next:'<ax-btn width="5">查看更多</ax-btn>',preload:"等待加载数据",loading:"正在加载数据",loaded:"单页数据加载完成!"},virtualize:{preload:"等待加载数据"},pagination:{first:"首页",last:"尾页",prev:"上一页",next:"下一页",ellipsis:"...",tips:"{{this.current}}/{{this.pages}}",total:"共有{{this.total}}条数据",locate:"跳到",count:"每页",page:"页",unit:"条"},datetime:{month:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"],week:["一","二","三","四","五","六","日"],weeks:["周日","周一","周二","周三","周四","周五","周六"],year:{prev:"上一页",next:"下一页",placeholder:"输入年份"},range:{hyphen:"至",checkbox:"选择同一天"},unit:{Y:"年",M:"月",D:"日",W:"周",h:"时",m:"分",s:"秒"},bc:"公元前",daytime:{select:"时间选择",start:"开始时间",end:"结束时间"},toolTip:{restore:"还原初始值",reset:"归零",now:"设为当前时间",close:"关闭时间选择器"},empty:`<i class="${s.prefix}c-caption">还未选择日期!</i>`,message:{requireTwoValue:"区间模式至少需要选择两个日期！",requireYearFormat:"请填入正确的年份格式!",requireOneSelected:"请至少选择一个日期!"},noEvent:`<i class="${s.prefix}c-caption">今天没有需要安排的事项!</i>`},rate:{title:{dft:"暂无评星",clear:"评星归零"},template:{result:"{{this.stars}}星",tooltip:"{{this.stars}}星,总分:{{this.value}}"},star:"星"},editor:{defer:"点击加载内容",placeholder:"请输入...",path:"路径:",chars:"文字:",paras:"段落:",fontsizeDft:"默认字号",alignDft:"默认排列",tagsDft:"特殊标签",tips:{bold:"加粗",italic:"斜体",through:"删除线",underline:"下划线",alignDft:"默认对齐",alignLeft:"左对齐",alignRight:"右对齐",alignCenter:"居中对齐",alignJustify:"两端对齐",indentMore:"增加缩进",indentLess:"减少缩进",sub:"下标",sup:"上标",highlight:"高亮(MARK)",em:"强调(EM)",ruby:"拼音(RUBY)",rt:"拼音(RT)",address:"地址(ADDRESS)",time:"时间(TIME)",blockquote:"段落引用(BLOCKQUOTE)",cite:"行内引用(CITE)",codeInline:"行内代码(CODE)",codeBlock:"代码块(PRE+CODE)",source:"源码模式",heading:"设置标题",hr:"插入水平线(HR)",br:"插入换行符(BR)",p:"插入段落符(P)",listOl:"有序列表(OL+LI)",listUl:"无序列表(UL+LI)",listCheck:"任务列表(CHECKBOX)",paragraph:"插入段落(DIV+BR)",fontSet:"文字设置",fontSize:"字号大小",fontColor:"文字颜色",fontBg:"文字背景色",h1:"一号标题",h2:"二号标题",h3:"三号标题",h4:"四号标题",h5:"五号标题",h6:"六号标题",text:"正文"}},select:{empty:"没有可选择的数据",placeholder:"请选择...",title:{close:"清空"},search:{fail:'没有找到符合"{{this.keys}}"的选项',succ:'找到了{{this.value}}项符合"{{this.keys}}"',start:"还没有输入检索关键字",placeholder:"请输入关键字..."},check:{ed:"未勾选,选择全部",ing:"勾选了部分,选择全部",none:"已勾选全部,取消全部"},stats:"已选择了{{this.value}}/{{this.total}}项"},upload:{paste:{before:"点击这里粘贴上传",ing:"请使用ctrl+v组合键",after:"完成了粘贴!"},tips:{suffix:"支持{{this.value}}格式",size:"单文件子节数不超过{{this.value}}MB",min:"至少上传{{this.value}}个文件",max:"最多上传{{this.value}}个文件",free:"上传文件未做限制"},progress:{passed:"文件合格",notPassed:"文件不合格",rendered:"等待上传",uploading:"上传中",uploaded:"已上传",received:"已接收",getAuth:"获取授权中",authorized:"已授权",unauthorized:"未获得授权",failed:"上传失败"},summary:"提交了{{this.total}}个文件,成功上传了{{this.count}}个,共{{this.size}}",message:{single:{passed:"通过校验!",max:"文件数量太多,请删除!",size:"文件体积太大,请删除!",suffix:"文件格式错误,请删除!",success:"上传成功!",failed:"提交地址可能错误,请删除!"},global:{passed:"所有文件通过校验!",min:"请至少上传{{this.value}}个文件!",max:"最多只能上传{{this.value}}个文件,可先删除再添加!"}},button:{choose:"选择文件",upload:"批量上传",clear:"批量删除",gallery:"点击或拖拽上传",picture:"选择文件"},thead:["图示","文件名","文件体积","上传进度","实时消息","上传状态","操作"]},confirm:{heading:""},twilight:{day:"白天",night:"黑夜"}},getDataType=t=>{let e,s=Object.prototype.toString.call(t).slice(8,-1);return e="Function"===s&&/^\s*class\s+/.test(t.toString())?"Class":"Object"===s&&Object.getPrototypeOf(t)!==Object.prototype?"Instance":s,e},isEmpty=t=>{let e,s=getDataType(t);return e=!t||("Object"===s?0===Object.keys(t).length:"Array"===s?""===t.join(""):"Function"===s?"{}"===t.toString().replace(/\s+/g,"").match(/{.*}/g)[0]:"Symbol"===s&&"()"===t.toString().replace(/\s+/g,"").match(/\(.*\)/g)[0]),e},deepClone=t=>{let e,s=getDataType(t);if("Object"===s){let s={},i=Object.getOwnPropertySymbols(t);for(let e in t)s[e]=deepClone(t[e]);if(i.length>0)for(let e of i)s[e]=deepClone(t[e]);e=s}else e="Array"===s?t.map((t=>deepClone(t))):"Date"===s?new Date(t):t;return e},deepMerge=(t,e,s)=>{let i=getDataType(t),a=getDataType(e),l=Object.assign({arrAppend:!1,propAppend:!0,targetClone:!1,override:"partial"},s),n=l.targetClone?deepClone(t):t;if("Object"!==i||"Object"!==a)return n;for(let t in e)if(e.hasOwnProperty(t)&&n.hasOwnProperty(t)){let s=getDataType(n[t]),i=getDataType(e[t]);s!==i?"partial"===l.override&&n.hasOwnProperty(t)&&n[t]?.hasOwnProperty("enable")&&"boolean"==typeof e[t]?n[t]?.hasOwnProperty("enable")&&"boolean"==typeof e[t]?n[t].enable=e[t]:e[t]?.hasOwnProperty("enable")&&"boolean"==typeof n[t]?n=Object.assign({enable:n[t]},e[t]):n[t]=e[t]:n[t]=e[t]:"Object"===i?n[t]=deepMerge(n[t],e[t],l):"Array"===i&&l.arrAppend?n[t].push(...e[t]):n[t]=e[t]}else e.hasOwnProperty(t)&&!n.hasOwnProperty(t)&&l.propAppend&&(n[t]=e[t]);let r=Object.getOwnPropertySymbols(e);if(r.length>0)for(let t of r)n[t]=e[t];return n},l={initial:!0,support:!1,privacy:!1,lang:a,attrs:{ajaxSpin:"spinning",ajaxState:"ajax"},debounce:200,throttle:500,rootStart:-1,idStart:0,floorStart:0,pathHyphen:"~",rangeHyphen:"~",labelHyphen:"/",splitHyphen:",",wordHyphen:" ",actClass:`${s.prefix}opened`,reqProp:"REQRETRY",parser:"new Function",warn:{init:"The initialization process of the instance has been stopped. You will need to manually initialize it using the init() method later!",emptyCont:"Data was not obtained, but execution was not halted!",parse:"Getting data from HTML resulted in an error, an empty array was returned, but execution was not interrupted!"},error:{},message:{},valid:{regChars:"~!@#$%^&*",lengthStr:6},popup:{},alert:{},more:{},menu:{},tree:{},drawer:{}};s.config=l,s.install=(t,e)=>{!isEmpty(e)&&deepMerge(l,e),t.config.globalProperties.$ax=s};const requireTypes=(t,e,s)=>{let i=getDataType(t).toLowerCase(),a="string"==typeof e?[e]:e;if(i.includes("html")&&(i="element"),a=a.map((t=>t.toLowerCase())),s)try{if(!a.includes(i))throw new Error(`Wrong data type,Require types: "${""+a}"!`)}catch(t){s(t)}else if(!a.includes(i))throw new Error(`Wrong data type,Require types: "${""+a}"!`)},renderTpl=(t,e)=>{if(requireTypes(t,"string"),requireTypes(e,["array","object"]),!t||0===Object.keys(e).length)return"";let s,i=new RegExp("\\{\\{([\\s\\S]+?)?\\}\\}","g"),a='"use strict";let str=[];\n',l=0,n="",add=(t,e)=>(a+=e?t.endsWith("/")?t.replace("=&gt;","=>").slice(0,-1)+"\n":"str.push("+t+");\n":""!==t?'str.push("'+t.replace(/"/g,'\\"')+'");\n':"",add);for(;s=i.exec(t);)add(t.slice(l,s.index))(s[1],!0),l=s.index+s[0].length;add(t.slice(l)),a+="return str.join('');";try{n=new Function(a.replace(/[\r\t\n]/g,"")).apply(e)}catch(t){}return n},getComputedVar=t=>getComputedStyle(document.documentElement).getPropertyValue(t).trim(),getScreenSize=()=>getComputedVar(`--${s.prefix}screen`),startUpper=t=>(t=t.trim()).slice(0,1).toUpperCase()+t.slice(1),sliceStrEnd=({str:t="",key:e="#",type:s="afterend",contain:i=!0})=>{t=t.toString();let a="",l=0,n=(e=e.toString()).length,r=t.length,o=0;return t&&e?((t=t.trim()).includes(e)&&("beforebegin"===s?(l=t.indexOf(e),i&&(l+=n),r=l):"afterbegin"===s?(l=t.indexOf(e),!i&&(l+=n),o=l):"beforeend"===s?(l=t.lastIndexOf(e),i&&(l+=n),r=l):"afterend"===s&&(l=t.lastIndexOf(e),!i&&(l+=n),o=l),a=t.substring(o,r)),a):a},delay=function({duration:t=2e3,todo:e,doing:s,done:i,frame:a=0}){return t<0&&Promise.reject(new Error("Invalid duration")),e&&e(a),new Promise(((e,l)=>{try{t||(i&&i(a),e(a));let l=Date.now()+t,listen=()=>{Date.now()>=l?(cancelAnimationFrame(a),i&&i(a),e(a),a=0):(a=requestAnimationFrame(listen),s&&s(a))};listen()}catch(t){l(t)}}))},getPlaces=t=>t.toString().split(".")[1]?.length||0,toNumber=(t,e)=>{let s=0,i=Number(t),a=Object.assign({places:10,mode:"round",zero:!1,epsilon:!0},e);if(!t||!i)return 0;if(a.places<0)return i;{let t=i+(a.epsilon?Number.EPSILON:0),e=Number(`1${"0".repeat(a.places)}`),l=t*e;if(s="floor"===a.mode?Math.floor(l)/e:"ceil"===a.mode?Math.ceil(l)/e:Math.round(l)/e,a.zero){let t=getPlaces(s);a.places>t&&(s=s+(t?"":".")+"0".repeat(a.places-t))}return s}},toPixel=(t,e)=>{let i=0;if(!t)return i;if(e=e||parseInt(s.fsRoot)||10,"string"==typeof t)if((t=t.trim()).endsWith("rem")||t.endsWith("REM"))i=~~(toNumber(t.replace("rem","").replace("REM",""))*e);else if(t.endsWith("px")||t.endsWith("PX"))i=~~toNumber(t.replace("px","").replace("PX",""));else if(t.startsWith("var(")){let e=s.getCssVar(t);i=toPixel(e)}else i=~~t;else"number"==typeof t&&(i=~~t);return i},preventDft=(t,e=!1)=>{t.cancelable&&t.preventDefault(),e&&t.stopPropagation()},n=s.isTouchScr?["touchstart","touchmove","touchend","touchcancel"]:["mousedown","mousemove","mouseup","mouseleave"],r={font:{succ:`<i class="${s.prefix}icon-check-o"></i>`,error:`<i class="${s.prefix}icon-close-o"></i>`,warn:`<i class="${s.prefix}icon-warn-o"></i>`,info:`<i class="${s.prefix}icon-info-o"></i>`,issue:`<i class="${s.prefix}icon-issue-o"></i>`,"succ-t":`<i class="${s.prefix}icon-check-o-t"></i>`,"error-t":`<i class="${s.prefix}icon-close-o-t"></i>`,"warn-t":`<i class="${s.prefix}icon-warn-o-t"></i>`,"info-t":`<i class="${s.prefix}icon-info-o-t"></i>`,"issue-t":`<i class="${s.prefix}icon-issue-o-t"></i>`,"succ-f":`<i class="${s.prefix}icon-check-o-f"></i>`,"error-f":`<i class="${s.prefix}icon-close-o-f"></i>`,"warn-f":`<i class="${s.prefix}icon-warn-o-f"></i>`,"info-f":`<i class="${s.prefix}icon-info-o-f"></i>`,"issue-f":`<i class="${s.prefix}icon-issue-o-f"></i>`},svg:{succ:`<svg class="${s.prefix}svg-succ" xmlns="http://www.w3.org/2000/svg" width="86.6986mm" height="86.6986mm" viewBox="0 0 86.6986 86.6986"><path class="${s.prefix}line ${s.prefix}bg" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}out" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}in-1" d="M26.316,42.859L37.9984,54.5414L60.3826,32.1572"></path></svg>`,error:`<svg class="${s.prefix}svg-error" xmlns="http://www.w3.org/2000/svg" width="86.6986mm" height="86.6986mm" viewBox="0 0 86.6986 86.6986"><path class="${s.prefix}line ${s.prefix}bg" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}out" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}in-1" d="M28.774,57.9246L57.9247,28.7739"></path><path class="${s.prefix}line ${s.prefix}in-2" d="M57.9246,57.9246L28.7739,28.7739"></path></svg>`,warn:`<svg class="${s.prefix}svg-warn" xmlns="http://www.w3.org/2000/svg" width="86.6986mm" height="86.6986mm" viewBox="0 0 86.6986 86.6986"><path class="${s.prefix}line ${s.prefix}bg" d="M43.4611 7.24c2.8081,0.0924 4.39,1.7 5.3045,3.1159l17.4543 29.9414 17.3445 29.7538c0.5448,1.0193 1.596,4.0544 0.1109,6.4168 -1.4849,2.3626 -3.6815,2.9155 -5.3768,2.992l-34.9082 0.0002 -34.6892 -0.0002c-1.1636,-0.0421 -4.3433,-0.6583 -5.6666,-3.1131 -1.3232,-2.4549 -0.7085,-4.6157 0.0723,-6.1078l17.454 -29.9417 17.3449 -29.7537c0.6185,-0.977 2.7471,-3.396 5.5554,-3.3036z"></path><path class="${s.prefix}line ${s.prefix}out" d="M43.4611 7.24c2.8081,0.0924 4.39,1.7 5.3045,3.1159l17.4543 29.9414 17.3445 29.7538c0.5448,1.0193 1.596,4.0544 0.1109,6.4168 -1.4849,2.3626 -3.6815,2.9155 -5.3768,2.992l-34.9082 0.0002 -34.6892 -0.0002c-1.1636,-0.0421 -4.3433,-0.6583 -5.6666,-3.1131 -1.3232,-2.4549 -0.7085,-4.6157 0.0723,-6.1078l17.454 -29.9417 17.3449 -29.7537c0.6185,-0.977 2.7471,-3.396 5.5554,-3.3036z"></path><path class="${s.prefix}line ${s.prefix}in-1" d="M43.3493,27.8713L43.3493,57.2858"></path><circle class="${s.prefix}circle ${s.prefix}in-2" cx="43.3492" cy="64.3337" r="2.1166"></circle></svg>`,info:`<svg class="${s.prefix}svg-info" xmlns="http://www.w3.org/2000/svg" width="86.6986mm" height="86.6986mm" viewBox="0 0 86.6986 86.6986"><path class="${s.prefix}line ${s.prefix}bg" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}out" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}in-1" d="M43.3493,65.0602L43.3493,30.9723"></path><circle class="${s.prefix}circle ${s.prefix}in-2" cx="43.3492" cy="23.5856" r="2.1166"></circle></svg>`,issue:`<svg class="${s.prefix}svg-issue" xmlns="http://www.w3.org/2000/svg" width="86.6986mm" height="86.6986mm" viewBox="0 0 86.6986 86.6986"><path class="${s.prefix}line ${s.prefix}bg" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}out" d="M7.238500000000002,43.3493A36.1108,36.1108 0,1,1 79.4601,43.3493A36.1108,36.1108 0,1,1 7.238500000000002,43.3493"></path><path class="${s.prefix}line ${s.prefix}in-1" d="M32.3757 35.7255c-0.2203,-11.823 12.5789,-14.1087 18.4056,-9.4189 5.4663,4.3995 4.7426,12.804 -3.1088,17.9938 -3.0015,1.9839 -3.0003,3.8403 -3.0003,10.1707"></path><circle class="${s.prefix}circle ${s.prefix}in-2" cx="44.6612" cy="60.5502" r="2.1166"></circle></svg>`}},o={x:{axis:"x",position:"left",start:"insetInlineStart",startAlt:"inset-inline-start",overflow:"overflowX",inner:"clientWidth",outer:"offsetWidth",scroll:"scrollLeft",client:"clientX",size:"width",index:4,offset:"offsetLeft",gap:"marginInlineStart"},y:{axis:"y",position:"top",start:"insetBlockStart",startAlt:"inset-block-start",overflow:"overflowY",inner:"clientHeight",outer:"offsetHeight",scroll:"scrollTop",client:"clientY",size:"height",index:5,offset:"offsetTop",gap:"marginBlockStart"}},getEl=(t,e)=>{let s=getDataType(t),i=getDataType(e).includes("HTML")?e:document.querySelector(e),a=i&&i instanceof HTMLTemplateElement?i.content:i,l=null;if(t)if(s.includes("HTML"))l=t;else if("String"===s)try{l=(a||document).querySelector(t.trim())}catch{l=null}return l},h={data:[],destroyFn:t=>{if(!t)return!1;t.ins.hasOwnProperty("destroyed")&&t.ins.destroyed||!t.ins.__proto__.destroy||(t.ins.destroy(),t.destTime=Date.now())},initFn:t=>{if(!t)return!1;t.ins.hasOwnProperty("destroyed")&&!t.ins.destroyed||!t.ins.__proto__.init||(t.ins.init(),t.initTime=Date.now())},push:function(t,e="",s=""){if(!t)return!1;let i={name:e,ins:t,type:s,pushTime:Date.now()};return this.data.some((e=>e.ins===t))||this.data.push(i),this},find:function(t,e="",s=!1){if(!t)return null;let i;return i=this.data.find((i=>{let a=!e||i.type===e;return i.ins.hasOwnProperty("destroyed")?i.name===t&&i.ins.destroyed===s&&a:i.name===t&&a})),i?i.ins:null},findAll:function(t="",e=!1){let s=[];return s=t?this.data.filter((s=>s.ins.hasOwnProperty("destroyed")?s.type===t&&s.ins.destroyed===e:s.type===t)):this.data.filter((t=>t.ins.destroyed===e)),s.length>0?s.map((t=>t.ins)):[]},destroy:function(t,e){if(!t)return!1;let s=e?this.data.find((s=>s.name===t&&s.type===e)):this.data.find((e=>e.name===t));return s&&this.destroyFn(s),this},destroyAll:function(t){return(t?this.data.filter((e=>e.type===t)):this.data).forEach((t=>{this.destroyFn(t)})),this},clear:function(){return this.data.forEach((t=>{this.destroyFn(t)})),this.data.length=0,this},init:function(t,e){if(!t)return!1;let s=e?this.data.find((s=>s.name===t&&s.type===e)):this.data.find((e=>e.name===t));return s&&this.initFn(s),this},initAll:function(t){return(t?this.data.filter((e=>e.type===t)):this.data).forEach((t=>{this.initFn(t)})),this}},getEls=(t,e)=>{let s=getDataType(t),i=getEl(e),a=i&&i instanceof HTMLTemplateElement?i.content:i||document,l=[];return isEmpty(t)?l:(s.includes("HTML")?l.push(t):"String"===s?l=(t=t.trim()).split(",").map((t=>[...a.querySelectorAll(t)])).flat():"Array"===s&&(l=t.map((t=>getEl(t,i)))),l.filter(Boolean))},createEl=(t,e,s)=>{let i=(t=t||"div").toUpperCase().trim(),a=document.createElement(i),l=getDataType(e);if(e&&"Object"===l)for(let t in e)e.hasOwnProperty(t)&&a.setAttribute(t,"string"==typeof e[t]?e[t]:JSON.stringify(e[t]));return((t,e)=>{if(""===e||null==e)return!1;let s=getDataType(e);if("TEMPLATE"===i)t.innerHTML=e.toString();else if("Array"===s&&e.length>0)for(let s of e){if(getDataType(s).includes("HTML"))t.appendChild(s);else{let e=createEl(s.name,s.attrs,s.content);e&&t.appendChild(e)}}else if(s.includes("HTML"))t.appendChild(e);else if("String"===s&&e.trim().startsWith("#")&&e.trim().length>1){let s=getEl(e);if(!s)return;"TEMPLATE"===s.nodeName?t.appendChild(s.content.cloneNode(!0)):t.insertAdjacentHTML("beforeEnd",s.innerHTML)}else t.insertAdjacentHTML("beforeEnd",e)})(a,s),a},parseStr=({content:t="",type:e="object",method:s=l.parser,catchable:i=!1,error:a})=>{let n="object"===e?{}:"array"===e?[]:null;if(!t)return n;let r=t.trim();try{n="function"==typeof s?s(r):"JSON.parse"===s?JSON.parse(r):new Function(`"use strict"; return ${r}`)()}catch(t){if(a&&a(t),i)throw t}return n},strToJson=(t,e="object")=>{let s="array"===e?[]:{};if("string"!=typeof t)return s;if(!(t=t.trim()))return s;t=t.startsWith("[")&&t.endsWith("]")||t.startsWith("{")&&t.endsWith("}")?t:`{${t}}`;try{return parseStr({content:t,type:e,catchable:!0})}catch{return s}},attrToJson=(t,e)=>{requireTypes(e,"string");let s=getEl(t),i=s.getAttribute(e),a={};return s&&e&&i&&(a=strToJson(i)),a},extend=({target:t={},source:e={},host:s=null,attr:i=""})=>{let a=getDataType(t),l=getEl(s);return"Object"!==a||(e&&deepMerge(t,e),l&&i&&deepMerge(t,attrToJson(l,i))),t},trim=(t,e)=>(requireTypes(t,"string"),"start"===e?t.trimStart():"end"===e?t.trimEnd():"both"===e?t.trim():"global"===e?t.replace(/[\s\r\n]+/g,""):t.trim().replace(/[\s\r\n]+/g," ")),allToEls=(t,e)=>{if(isEmpty(t))return[];let s=[],i=getDataType(t);if(i.includes("HTML"))s.push(t);else if("String"===i){let i=trim(t),a=i.includes(l.splitHyphen)?l.splitHyphen:l.wordHyphen;i.split(a).forEach((t=>{let i=getEl(t,e);i&&s.push(i)}))}else"Array"===i?t.forEach((t=>{let i=getEl(t,e);i&&s.push(i)})):"NodeList"===i&&(s=[...t]);return s},ajax=t=>{if(isEmpty(t))throw new Error("There is no options!");let e={target:"",url:"",type:"post",async:!0,data:null,holdTime:0,stopTime:36e5,contType:"",headers:{},respType:"",catchable:!1,spinStr:"<ax-spin></ax-spin>",spinSel:"",xhrName:"",signal:null,repeat:{index:0,max:0,keyword:""},xhrFields:{},abort:t=>{},timeout:t=>{},opened:t=>{},before:t=>{},downloading:t=>{},uploading:t=>{},complete:t=>{},success:t=>{},error:t=>{},cb:t=>{}};extend({target:e,source:t}),!e.type&&(e.type="post");let i=createEl("span",{[s.alias]:"message"}),a=getEl(e.target);a&&(a.innerHTML="",a.appendChild(i));let n,r=allToEls(e.spinSel),o=window.XMLHttpRequest?new XMLHttpRequest:new ActiveXObject("Microsoft.XMLHTTP");if(!isEmpty(e.data)){let t=getDataType(e.data);"FormData"===t?n=e.data:"Object"===t?e.contType?.includes("json")||e.headers["Content-Type"]?.includes("json")?n=JSON.stringify(e.data):(n=new URLSearchParams(e.data).toString(),e.contType="application/x-www-form-urlencoded"):(e.data=e.data.trim(),n=e.data.startsWith("&")||e.data.startsWith("?")?e.data.slice(1):e.data,e.contType="application/x-www-form-urlencoded")}if(e.contType&&(e.headers["Content-Type"]=e.contType,!e.contType.includes("urlencoded")&&"get"===e.type.toLowerCase()))throw new Error("Please request data with post!");o.timeout=e.stopTime,o.responseType=e.respType;let h,p,d,c={target:a,label:i,xhr:o,spins:r},abortFun=()=>{h&&o.removeEventListener("timeout",h),o.abort(),a&&a.setAttribute(l.attrs.ajaxState,"abort"),isEmpty(e.abort)?a&&(i.innerHTML=l.lang.ajax.abort):e.abort(Object.assign({status:o.status,content:o.response},c))};return new Promise(((t,u)=>{let progress=(t,s)=>{let i=t.loaded,a=t.total,l=0,n=0,r="0%",h=new Date(t.timeStamp).getTime();if(t.lengthComputable){l=i/a,n=Math.round(100*l),r=n+"%";let t=Object.assign({result:r,percent:n,current:i,total:a,ratio:l,time:h,status:o.status,abort:abortFun},c);s&&s(t),n>=100&&e.complete&&e.complete(t)}},g=null;if(e.signal){if(g=()=>{o.abort(),u({...c,status:o.status})},e.signal?.aborted)return u({...c,status:o.status});e.signal.addEventListener("abort",g)}o.upload.onprogress=t=>{progress(t,(t=>{!isEmpty(e.uploading)&&e.uploading(t)}))},o.onprogress=t=>{progress(t,(t=>{!isEmpty(e.downloading)&&e.downloading(t)}))},h=()=>{let t=Object.assign({status:o.status,content:o.response},c);a&&a.setAttribute(l.attrs.ajaxState,"timeout"),isEmpty(e.timeout)?a&&(i.innerHTML=l.lang.ajax.timeout):e.timeout(t),e.catchable&&u(t),e.cb&&e.cb(t)},p=t=>{var s;a&&a.setAttribute(l.attrs.ajaxState,"error"),isEmpty(e.error)?(s=t,a&&(i.innerHTML=renderTpl(l.lang.ajax.error,{status:s.status}))):e.error(t),e.catchable&&u(t),e.cb&&e.cb(t)},d=i=>{if(e.repeat.max&&e.repeat.keyword&&"string"==typeof i.content){if(s.ajaxStor[e.repeat.index]<e.repeat.max&&i.content.includes(e.repeat.keyword))return isNull(s.ajaxStor[e.repeat.index])?(s.ajaxStor.push(0),e.repeat.index=s.ajaxStor.length-1):s.ajaxStor[e.repeat.index]++,void ajax(e);s.ajaxStor[e.repeat.index]=0}if(r.length>0)for(let t of r)t.removeAttribute(l.attrs.ajaxSpin);var n;a&&a.setAttribute(l.attrs.ajaxState,"success"),isEmpty(e.success)?(n=i,a&&(a.innerHTML=n.content)):e.success(i),t(i),e.cb&&e.cb(i)},o.addEventListener("timeout",h),o.onreadystatechange=function(){if(o.readyState<4){let s=Object.assign({status:o.status,content:e.spinStr,abort:abortFun},c);if(1===o.readyState&&(e.xhrName&&(this[e.xhrName]=o),!isEmpty(e.opened)&&e.opened(s)),r.length>0)for(let t of r)t.toggleAttribute(l.attrs.ajaxSpin,!0);a&&a.setAttribute(l.attrs.ajaxState,"before"),isEmpty(e.before)?(t=s,a&&(i.innerHTML=t.content)):e.before(s)}else{e.signal&&e.signal.removeEventListener("abort",g);let t=Object.assign({status:o.status},c);if(o.status>=200&&o.status<300||304===o.status){if(e.respType&&"text"!==o.responseType)t.content=o.response;else{let s=o.responseText.trim(),i="";if(s.startsWith("[")&&s.endsWith("]")||s.startsWith("{")&&s.endsWith("}"))try{i=JSON.parse(s)}catch{i=o.responseText}else if(s.endsWith("</html>")){let t=/(<head\b[^<]*(?:(?!<\/head>)<[^<]*)*<\/head>)|(<\/?html.*?>)|(<\!DOCTYPE.*?html.*?>)|(<\/?body.*?>)/gi,a=sliceStrEnd({str:e.url}),l="string"==typeof e.data?e.data:a;if(l){let e=createEl("div","",s),a=getEl(l,e);i=a?a.innerHTML:s.replace(t,"").trim()}else i=s.replace(t,"").trim()}else i=o.responseText;t.content=i}e.holdTime?delay({duration:e.holdTime,done:()=>{d(t)}}):d(t)}else t.content=o.response,e.holdTime?delay({duration:e.holdTime,done:()=>{p(t)}}):p(t)}var t};let m=[],b=null;"get"===e.type.toLowerCase()?m=["get",e.url+"?now="+Date.now()+"&"+n,e.async]:"post"===e.type.toLowerCase()&&(m=["post",e.url,e.async],b=n);for(let t in e.xhrFields)e.xhrFields.hasOwnProperty(t)&&(o[t]=e.xhrFields[t]);o.open(...m);for(let t in e.headers)e.headers.hasOwnProperty(t)&&o.setRequestHeader(t,e.headers[t]);o.send(b)}))},valToArr=(t,e,s=!0)=>{let i=getDataType(t),a=[];return[void 0,null,"undefined","null",""].includes(t)?a:("Array"===i?a=t.filter((t=>!isNull(t))):"String"===i?(a=t.trim().split(e||l.splitHyphen),a=a.filter((t=>""!==(t=t.trim())&&!isNull(t))),s&&(a=a.map((t=>isNaN(+t)?t:+t)))):a.push(t),[...new Set(a)])},getValsFromAttrs=t=>{let e=getEl(t),s={};if(e){s.label=e.textContent.trim(),[...e.attributes].forEach((t=>{s[t.name]=!!["selected","disabled","readonly","active","checked","expanded","draggable"].includes(t.name)||t.value.trim()})),!s.hasOwnProperty("value")&&(s.value=s.label),s.value&&!s.label&&(s.label=s.value)}return s},select2Tree=t=>{let e=getEl(t),s=[];if(!e)return s;let getJson=t=>{let e={node:t,...getValsFromAttrs(t)};return"OPTGROUP"==t.nodeName&&(e.children=[],[...t.children].forEach((t=>{e.children.push(getJson(t))}))),e};return s=(()=>{let t=[];return[...e.children].forEach((e=>{t.push(getJson(e))})),t})(),s},ul2Tree=(t,e="tree")=>{let i=getEl(t),a=[];if(!i)return a;let getJson=t=>{let i={node:t.firstElementChild},a=i.node.querySelector(`:scope> [${s.alias}="label"]`),l=i.node.querySelector(`:scope> [${s.alias}="badge"]`)||i.node.querySelector(":scope> AX-BADGE"),n=i.node.querySelector(`:scope> [${s.alias}="tips"]`),r=i.node.querySelector(`:scope> [${s.alias}="icon"]`),o=i.node.querySelector(`:scope> [${s.alias}="disk"]`),h=i.node.querySelector(`:scope> [${s.alias}="cube"]`),p=i.node.querySelector(`:scope> [${s.alias}="custom"]`),d=t.querySelector(`:scope> .${s.prefix}${e}-brief`),c=t.querySelector(`:scope> .${s.prefix}${e}-cont`),u=t.querySelector(`:scope> .${s.prefix}${e}-extra`);i.node.classList.contains(`${s.prefix}${e}-head`)&&(i.headEl=i.node),a&&(i.labelEl=a),l&&(i.badgeEl=l),n&&(i.tipsEl=n),p&&(i.customEl=p),r&&(i.iconEl=r),o&&(i.diskEl=o),h&&(i.cubeEl=h),d&&(i.briefEl=d),c&&(i.contEl=c),u&&(i.extraEl=u),Object.assign(i,{...getValsFromAttrs(i.wrapEl),...getValsFromAttrs(i.node),...getValsFromAttrs(i.labelEl)}),i.headEl&&!i.labelEl&&(i.headEl.innerHTML="");let g=t.querySelector(":scope> ul,:scope> ol");return g&&(i.children=[],[...g.children].forEach((t=>{i.children.push(getJson(t))}))),i};return a=(()=>{let t=[];return[...i.children].forEach((e=>{t.push(getJson(e))})),t})(),a},getContent=async function(t){let e,a=getDataType(t.content),getListArr=e=>{let s,i,a=getEl(e,t.parent)||createEl("div",{},e),l=a.nodeName;if(a&&(s=["SELECT","DATALIST","UL","OL"].includes(l)?a:"TEMPLATE"===l?a.content.cloneNode(!0).querySelector("ul,ol,select,datalist"):a.querySelector("ul,ol,select,datalist")),s){let t=s.nodeName;i=["SELECT","DATALIST"].includes(t)?select2Tree(s):["UL","OL"].includes(t)?ul2Tree(s):[]}else i=[];return i},getIframe=e=>{let i={src:e},a=createEl("iframe",Object.assign(i,t.contData)),l=createEl("div",{[s.alias]:"media"},a);return createEl("div",{class:`${s.prefix}box-iframe`},l)},getImage=e=>{let i={src:e},a=createEl("img",Object.assign(i,t.contData)),l=createEl("div",{[s.alias]:"media"},a);return createEl("div",{class:`${s.prefix}box-image`},l)},getVideo=e=>{let i={src:e,controls:"controls"},a=createEl("video",Object.assign(i,t.contData)),l=createEl("div",{[s.alias]:"media"},a);return createEl("div",{class:`${s.prefix}box-video`},l)},getAudio=e=>{let i={src:e,controls:"controls"},a=createEl("audio",Object.assign(i,t.contData)),l=createEl("div",{[s.alias]:"media"},a);return createEl("div",{class:`${s.prefix}box-audio`},l)},getMedias=e=>{let s={iframe:getIframe,audio:getAudio,video:getVideo,image:getImage},i=valToArr(t.content,t.hyphen||l.splitHyphen).map((t=>t.trim())),a=[];for(let t of i)a.push(s[e](t));return a},getAsync=async e=>{let s,i=Object.assign({url:e,data:t.contData,success:t=>{s=t.content},cb:e=>{t.request&&t.request(e)}},t.ajax);return await ajax.call(this,i),s};if("Number"===a)e=t.content+"";else if("String"===a)if(t.content=t.content.trim(),"text"===t.contType)e=t.content;else if("html"===t.contType)e=getEl(t.content,t.parent)?getEl(t.content,t.parent).innerHTML:"";else if("node"===t.contType)e=getEl(t.content,t.parent);else if("list"===t.contType)e=getListArr(t.content);else if("form"===t.contType){let s=getEl(t.content,t.parent),i="TEMPLATE"===s?.nodeName?s.content.cloneNode(!0):s;e=i?.querySelector("form")||""}else if("iframe"===t.contType)e=getIframe(t.content);else if("iframes"===t.contType)e=getMedias("iframe");else if("image"===t.contType)e=getImage(t.content);else if("images"===t.contType)e=getMedias("image");else if("video"===t.contType)e=getVideo(t.content);else if("videos"===t.contType)e=getMedias("video");else if("audio"===t.contType)e=getAudio(t.content);else if("audios"===t.contType)e=getMedias("audio");else if("async"===t.contType)await getAsync(t.content).then((t=>{e=t}));else if("asyncs"===t.contType)await(async()=>{let e=valToArr(t.content,t.hyphen||l.splitHyphen),s=[];for(let t of e)await getAsync(t).then((t=>{s.push(t)}));return s})().then((t=>{e=t}));else if(i.includes(t.contType)){let i="select"===t.contType?{popup:{multiple:!0}}:"datetime"===t.contType?{feature:"flat",full:!0}:"upload"===t.contType?{feature:"gallery"}:["radios","checkboxes","checkbox"].includes(t.contType)?{type:"text"}:{full:!0},a={[["checkboxes","radios","select"].includes(t.contType)?"content":["checkbox","radio"].includes(t.contType)?"label":"upload"===t.contType?"url":"file"===t.contType?"placeholder":"value"]:t.content,...i,...Object.assign({name:s.namePfx+Date.now()},t.contData)};e=createEl(`ax-${t.contType}`,a)}else e=t.content;else"Promise"===a?await t.content.then((t=>{e=t})):"AsyncFunction"===a?await t.content.call(this).then((t=>{e=t})):"Function"===a?e=t.content.call(this):"Object"===a||"Array"===a?"Object"===a&&t.content[l.reqProp]?await getContent(t.content).then((t=>{e=t})):e=deepClone(t.content):e=a.includes("HTML")&&"list"===t.contType?getListArr(t.content):t.content;return t.cb&&t.cb.call(this,e),e},style=(t,e)=>{let s=getEl(t);return s?document.defaultView.getComputedStyle(s,e):{}},getClasses=t=>{let e,s=[];return"Array"===getDataType(t)?s=t.filter((t=>t&&"string"==typeof t)):(e=(t=trim(t)).includes(l.splitHyphen)?l.splitHyphen:l.wordHyphen,s=t.split(e)),s.map((t=>trim(t,"global"))).filter(Boolean)},classes=t=>{let e=getEl(t);return{get:()=>e?getClasses(e.getAttrubute("class")):[],add:function(t,s){let i=getClasses(t);return e&&0!==i.length?(i.forEach((t=>{let i;s?(i=s(t),!0===i?e.classList.add(t):"string"==typeof i&&i&&e.classList.add(i)):e.classList.add(t)})),this):this},remove:function(t,s){let i=getClasses(t);return e&&0!==i.length?(i.forEach((t=>{let i;s?(i=s(t),!0===i?e.classList.remove(t):"string"==typeof i&&i&&e.classList.remove(i)):e.classList.remove(t)})),this):this},replace:function(t,s){return e&&t?(e&&s&&t&&(e.classList.remove(t),e.classList.add(s)),this):this},has:function(t){if(!e||isEmpty(t))return this;let s=getClasses(t);for(let t of s)if(!e.classList.contains(t))return!1;return!0}}},elState=t=>{let e=getEl(t),s=!!e;if(e){if(!e.isConnected)return{isExist:s,isVirtual:!0,isHidden:!0,isVisible:!1,isCalc:!1,isUncalc:!0};if("none"===e.style.display)return{isExist:s,isVirtual:!1,isHidden:!0,isVisible:!1,isCalc:!1,isUncalc:!0};let t=getComputedStyle(e),i=!t.display,a="none"===t.display||"hidden"===t.visibility,l=!(!t.display||"none"===t.display);return{isExist:s,isVirtual:i,isHidden:a,isVisible:!(!l||"visible"!==t.visibility),isCalc:l,isUncalc:i||a}}return{isExist:s,isCalc:!1,isUncalc:!0}},p=[{attr:"ins-name",prop:"insName",value:""},{attr:"stor-name",prop:"storName",value:""},{attr:"stor-keys",prop:"storKeys",value:[]},{attr:"breakpoints",prop:"breakpoints",value:{}},{attr:"rtl",prop:"rtl",value:!1},{attr:"lang",prop:"lang",value:{}},{attr:"b4-init",prop:"b4Init",value:null},{attr:"on-constructed",prop:"onConstructed",value:null},{attr:"on-initiate",prop:"onInitiate",value:null},{attr:"on-initiated",prop:"onInitiated",value:null},{attr:"on-destroyed",prop:"onDestroyed",value:null},{attr:"on-error",prop:"onError",value:null},{attr:"on-reset",prop:"onReset",value:null},{attr:"on-updated",prop:"onUpdated",value:null},{attr:"on-saved",prop:"onSaved",value:null},{attr:"on-clearedcache",prop:"onClearedCache",value:null},{attr:"on-updatedcache",prop:"onUpdatedCache",value:null}];const d=[{attr:"heading",prop:"heading",value:""},{attr:"divider",prop:"divider",value:!1},{attr:"duration",prop:"duration",value:0},{attr:"auto-dur",prop:"autoDur",value:!1},{attr:"asleep",prop:"asleep",value:!1},{attr:"dead-show",prop:"deadShow",value:!1},{attr:"keep-show",prop:"keepShow",value:!1},{attr:"classes",prop:"classes",value:""},{attr:"padding",prop:"padding",value:{enable:!0,body:!0,foot:!0}},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"act-class",prop:"actClass",value:l.actClass},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"z-index",prop:"zIndex",value:0},{attr:"dedicated",prop:"dedicated",value:!1},{attr:"can-click",prop:"canClick",value:null},{attr:"media",prop:"media",value:{title:"",brief:""}},{attr:"auto-fill",prop:"autoFill",value:{enable:!1,inputSel:"",childSel:"",detectable:!1,attr:""}},{attr:"bullet",prop:"bullet",value:{enable:!1,type:"custom",parentNode:"ul",childNode:"li",unpadded:!1,hoverable:!1,divisible:!1,multiline:!1,cols:0,lines:"",action:null}},{attr:"tools",prop:"tools",value:{enable:!0,placement:"inside",children:["close"]}},{attr:"footer",prop:"footer",value:{enable:!0,layout:"plain",note:!1,divider:!1,padding:!1,children:["cancel","confirm"]}},{attr:"b4-show",prop:"b4Show",value:null},{attr:"b4-hide",prop:"b4Hide",value:null},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"b4-confirm",prop:"b4Confirm",value:null},{attr:"b4-cancel",prop:"b4Cancel",value:null},{attr:"on-show",prop:"onShow",value:null},{attr:"on-hide",prop:"onHide",value:null},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-hidden",prop:"onHidden",value:null},{attr:"on-invalidated",prop:"onInvalidated",value:null},{attr:"on-validated",prop:"onValidated",value:null},{attr:"on-sended",prop:"onSended",value:null},{attr:"on-render",prop:"onRender",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-transferred",prop:"onTransferred",value:null},{attr:"on-confirmed",prop:"onConfirmed",value:null},{attr:"on-canceled",prop:"onCanceled",value:null},{attr:"on-closed",prop:"onClosed",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-bulletschecked",prop:"onBulletsChecked",value:null},{attr:"on-bulletsselected",prop:"onBulletsSelected",value:null},{attr:"on-targetset",prop:"onTargetSet",value:null},...p],c=[{attr:"placement",prop:"placement",value:"right"},{attr:"trigger",prop:"trigger",value:"click"},{attr:"offset",prop:"offset",value:"100px"},{attr:"size",prop:"size",value:"sm"},{attr:"multiple",prop:"multiple",value:!0},{attr:"parent",prop:"parent",value:""},{attr:"wing",prop:"wing",value:{selector:"",actClass:""}},{attr:"mask",prop:"mask",value:{enable:!0,closable:!0}},...d],getEvtTarget=t=>{if(t.targetTouches){let e=t.targetTouches[0]||t.changedTouches[0];return document.elementFromPoint(e.clientX,e.clientY)}return t.target},removeStyle=(t,e)=>{let s=getEl(t);s&&e&&(s.style.cssText=s.style.cssText.replace(`${e}:`,""))},addStyle=(t,e,s)=>{let i=getEl(t);if(e=(e+"").toLowerCase(),s+="",!i||!e||!s)return;let a=e.replace(/-([a-z])/g,((t,e)=>e.toUpperCase()));i.style[a]=s},isDateStr=t=>"string"==typeof t&&!isNaN(Date.parse(t)),getUTCTimestamp=t=>{let e,s,i,a=getDataType(t);return e="Date"===a?t:"String"===a?isDateStr(t)?new Date(t):new Date:"Number"===a?new Date(t):new Date,i=e.getTime(),s=6e4*e.getTimezoneOffset(),i+s},getExpiration=(t="d",e=365,s="locale")=>{let i;if(isDateStr(e))i=new Date(e);else switch(i=new Date,t){case"s":i.setSeconds(i.getSeconds()+~~e);break;case"m":i.setMinutes(i.getMinutes()+~~e);break;case"h":i.setHours(i.getHours()+~~e);break;default:i.setDate(i.getDate()+~~e)}return"utc"===s?getUTCTimestamp(i):i.getTime()},u={set:function(t,e,s){if(isEmpty(t)&&"string"!=typeof t)return;let i=Object.assign({unit:"d",expires:0,override:!0,type:"local"},s),a=deepClone(e),l=getDataType(e),n="session"===i.type?window.sessionStorage:window.localStorage,filterProps=t=>(Object.keys(t).forEach((e=>{let s=t[e],i=getDataType(s);["Array","Object"].includes(i)&&filterProps(s),(i.includes("HTML")||i.includes("Function")||["Promise","Symbol","Instance"].includes(i))&&delete t[e]})),t);["Array","Object"].includes(l)&&!isEmpty(a)&&filterProps(a);let r=0!==i.expires?getExpiration(i.unit,i.expires):0,o=this.get(t,i.type),h={data:!i.override&&this.get(t,i.type)?extend({target:o,source:a}):a,expires:r};return("number"==typeof i.expires&&i.expires<0||null===a)&&this.get(t,i.type)?this.remove(t,i.type):n.setItem(t,JSON.stringify(h)),this},get:function(t,e="local"){if(isEmpty(t)||"string"!=typeof t)return!1;let s=Date.now(),i="session"===e?window.sessionStorage:window.localStorage,a=i.getItem(t);if(a){let e=new Function('"use strict";return '+a)();return 0===e.expires||s<=e.expires?e.data:(i.removeItem(t),null)}return null},remove:function(t,e="local"){if(isEmpty(t)||"string"!=typeof t)return!1;return("session"===e?window.sessionStorage:window.localStorage).removeItem(t),this},clear:function(t="local"){return("session"===t?window.sessionStorage:window.localStorage).clear(),this}},g=[{attr:"deep",prop:"deep",value:{enable:!1,include:[],exclude:[]}},{attr:"filter",prop:"filter",value:null},{attr:"tpyes",prop:"tpyes",value:["Object","Array","Function"]},{attr:"accept",prop:"accept",value:!0},{attr:"lenient",prop:"lenient",value:!0},{attr:"once",prop:"once",value:!1},{attr:"methods",prop:"methods",value:["set","delete"]},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-deleted",prop:"onDeleted",value:null},{attr:"on-crud",prop:"onCrud",value:null},{attr:"on-new",prop:"onNew",value:null},{attr:"on-applied",prop:"onApplied",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-completed",prop:"onCompleted",value:null},...p],deepEqual=(t,e)=>{if(t===e)return!0;let s=getDataType(t);if(s===getDataType(e)&&"Object"===s){let getStr=t=>{let e=new Set;return JSON.stringify(t,((t,s)=>{if("object"==typeof s&&null!==s){if(e.has(s))return;e.add(s)}return s}))};return getStr(t)===getStr(e)}return!1},isProxy=t=>!0===t?._isProxy,unique=(t,e)=>{let s;if(isEmpty(t))s=[...t];else if(s=[...new Set(t)],"object"==typeof s[0]&&e){let t=new Map;for(let i of s)!t.has(i[e])&&t.set(i[e],i);s=[...t.values()]}return s},m={handle:(t,e,s)=>{let i=[];if("String"===e?i=(t=trim(t)).includes(",")?t.split(","):t.split(" "):"Array"===e&&(i=t.map((t=>trim(t)))),i.length>0)for(let t of i)s(t)},add:function(t,e,s){let i=getDataType(t);return this.handle(t,i,(t=>(t=>{e.plans.hasOwnProperty(t)||(e.plans[t]=[]);let i=s.toString().replace(/\s/g,"").replace(/\;/g,"").match(/{(\S*)}/),a=e.plans[t].toString().replace(/\s/g,"").replace(/\;/g,"");i&&!a.includes(i[1])&&e.plans[t].push(s)})(t))),this},remove:function(t,e,s){let i=getDataType(t);return this.handle(t,i,(t=>(t=>{if(e.plans.hasOwnProperty(t))if(s){let i=e.plans[t].findIndex((t=>t===s));if(i<0)return;e.plans[t].splice(i,1),0===e.plans[t].length&&delete e.plans[t]}else delete e.plans[t]})(t))),this},do:function(t,e,...s){let i=getDataType(t);return this.handle(t,i,(t=>{return i=t,void(e.plans.hasOwnProperty(i)&&e.plans[i].forEach((t=>{t.call(e,...s)})));var i})),this}},attrJoinVal=(t,e,s)=>{let i=s?s.find((e=>e.attr===t)):null,a=(()=>{let e=t.trim(),s=!!i&&"function"==typeof i?.value;return e.startsWith("on-")||e.startsWith("b4-")||s})()?(t=>{let e=t.trim();return e.startsWith("function")||e.startsWith("(")||e.endsWith("}")?t:`function(){${t}}`})(e):e;try{if(i){if(null===e)return{[i.prop]:i.value};{let t=getDataType(i.value),s=e.trim(),l=["","1","true",!0],n=[null,"null","undefined","0","false","NaN"];return"ignore"===i.type?{[i.prop]:e}:"String"===t?{[i.prop]:e}:"Number"===t?{[i.prop]:parseFloat(e)}:"Boolean"===t&&l.includes(s)?{[i.prop]:!0}:"Boolean"===t&&n.includes(s)?{[i.prop]:!1}:"Object"===t&&i.value.hasOwnProperty("enable")&&l.includes(s)?{[i.prop]:!0}:"Object"===t&&i.value.hasOwnProperty("enable")&&i.value.hasOwnProperty("children")&&s.startsWith("[")&&s.endsWith("]")?{[i.prop]:{enable:!0,children:parseStr({content:`${e}`,type:"array",catchable:!0})}}:"Object"===t&&e.includes(":")?{[i.prop]:strToJson(e)}:parseStr({content:`{"${i.prop}":${a}}`,type:"object",catchable:!0})}}return""===e?{[t]:""}:parseStr({content:`{"${t}":${a}}`,type:"object",catchable:!0})}catch(s){return{[t]:e}}},breakpoints=(t,e)=>{if(isEmpty(t)||isEmpty(e))return;let i=[],a={},l=document.body.clientWidth,validFun=(t,e)=>{let a=~~t;if(0===a){let a=t.split("-")[1];if(t.startsWith("screen")){!!(s.screen===a||"dt"===a&&["lg","xl","xxl","dt"].includes(s.screen)||"hh"===a&&["xxs","xs","sm","md","hh"].includes(s.screen)||"tb"===a&&["xs","sm","md","tb"].includes(s.screen))&&i.push(e)}else t.startsWith("width")?~~a<=l&&i.push(e):t.startsWith("destop")&&JSON.parse(a)!==s.isTouchScr&&i.push(e)}else a<=l&&i.push(e)};for(let t in e)e.hasOwnProperty(t)&&(Reflect.deleteProperty(e[t],"breakpoints"),validFun(t,e[t]));i.length&&(a=Object.assign({},...i),extend({target:t,source:a}))},storeNode=t=>{let e=getEl(t),s=null;return e&&(!e.hasOwnProperty("ax")&&(e.ax={}),s={addModule:t=>{if(t&&(e.ax.hasOwnProperty("modules")||(e.ax.modules={}),!e.ax.modules[t]))return e.ax.modules[t]=!0,e},removeModule:t=>{if(t)return delete e.ax.modules[t],e},addData:(t,s)=>{if(t)return e.ax[t]=s,e},removeData:t=>{if(t)return delete e.ax[t],e}}),s},keyCond=t=>!/^(stor-keys|ins-name|stor-name|storKeys|insName|storName|on-|b4-|on[A-Z]|b4[A-Z])/.test(t),spreadBool=(t,e)=>{let s=t,i=getDataType(t);if("Object"===getDataType(e))if("Boolean"===i)Reflect.deleteProperty(e,"enable"),s={enable:t,...e};else if("Object"===i)if(t.hasOwnProperty("enable"))t=Object.assign({},e,t);else for(let s in e)e.hasOwnProperty(s)&&t.hasOwnProperty(s)&&(t[s]=spreadBool(t[s],e[s]));return s},contains=(t,e)=>{let s=getEl(t),i=!1;if(!s)return i;if(Array.isArray(e))for(let t of e){let e=getEl(t);if(e&&e.contains(s)){i=!0;break}}else{let t=getEl(e);i=!(!t||!t.contains(s))}return i},getRtl=()=>{if(!s.hasOwnProperty(s.rtl)){let t=getComputedVar(`--${s.prefix}dir-coef`);s.rtl="-1"==t}return s.rtl};class ModBase{targetEl;targetData;options;destroyed;timestamp;renderCount;respSource;initialized;moduleName;dftOpts;rawOpts;rawHtml;rawEl;tplStr;tplEng;initCount;handleEls;isRtl;constructor(){this.timestamp=Date.now(),this.respSource=null,this.initialized=!1,this.initCount=0,this.renderCount=0,this.handleEls=[],this.targetEl=null,this.targetData=null,this.rawOpts={},this.dftOpts={},this.options={},this.rawHtml="",this.rawEl=null,this.destroyed=!1,this.moduleName=this.constructor.name.toLowerCase(),this.tplStr="",this.tplEng=null}getOptsFromMap(t){let e={};for(let s of t)e[s.prop]=s.value;return e}isComp(t){return"slot-host"===t.getAttribute(s.alias)}getElOptsMap(t){if(isEmpty(t))return{el:null,attr:{}};{let e=this.isComp(t);return{el:e?t.parentNode:t,attr:e?"initiated":`ax-${this.moduleName}`}}}mergeOpts({source:t={},map:e=[],el:s=null,component:i=!1}){let a=getEl(s),n=this.getElOptsMap(a),r=deepClone(this.getOptsFromMap(e));return this.rawOpts=deepClone(r),!isEmpty(l.lang[this.moduleName])&&(r.lang=extend({target:deepClone(l.lang[this.moduleName]),source:r.lang})),extend({target:r,source:l[this.moduleName]||{}}),extend({target:r,source:t,host:n.el,attr:n.attr}),i&&extend({target:r,source:this.mergeCompAttrs(a,e)}),this.dftOpts=deepClone(r),r}mergeCompAttrs(t,e){let s={};if(this.isComp(t)){let i=t.parentNode,a=i?.attributes;if(!i||i.nodeName.toLowerCase()!==`ax-${this.moduleName}`||!a)return{};for(let t of a){let i=e.find((e=>e.attr===t.name));if(i){let e=attrJoinVal(i.attr,t.value,[i]);Object.assign(s,e)}}}return s}getOptsAttr(t){return t.nodeName===`AX-${this.moduleName.toUpperCase()}`?"options":`ax-${this.moduleName}`}getStrFromContent(t){let e=getEl(t);return e?e.innerHTML:t}revertHtml(t){this.rawHtml&&(t.innerHTML=this.rawHtml),1===t.children.length&&(this.rawEl=t.children[0])}replaceMult(t="",e,i={}){let a=Object.assign({ignore:!0,nodename:"i"},i),l=new RegExp(`(${e.join("|")})`,"g"+(a.ignore?"i":"")),n=`<${a.nodename} ${s.alias}="mark"${a.classes?' class="'+a.classes+'"':""}>$1</${a.nodename}>`;return(t+"").replace(l,n)}parseLayout(t=this.targetEl,e="",i={}){let a=getEl(t),l=createEl("i",{[s.alias]:"holder"}),n=createEl("i",{[s.alias]:"gap"}),condition=t=>"holder"===t?l.cloneNode(!0):"gap"===t?n.cloneNode(!0):i[t],getNodes=t=>t.split("|").map(condition).filter(Boolean);if(a&&e&&!isEmpty(i))if(e.includes("(")&&e.includes(")")){let t=e.indexOf("("),s=e.indexOf(")"),l=e.slice(0,t),n=e.slice(t+1,s),r=e.slice(s+1),o=getNodes(l),h=getNodes(n),p=getNodes(r);o.length&&a.append(...o),i.group&&(a.appendChild(i.group),h.length&&i.group.append(...h)),p.length&&a.append(...p)}else{let t=getNodes(e);a.append(...t)}}updateOpts(t){if(this.optsMergeStorage&&this.optsMergeStorage(),!isEmpty(this.options.breakpoints)&&breakpoints(this.options,this.options.breakpoints),Array.isArray(t)&&t.length>0){let e={};for(let s of t)e[s]=this.rawOpts[s];spreadBool(this.options,e)}}getStorageKeys(){let t=[];return t=Array.isArray(this.options.storKeys)&&this.options.storKeys.length>0?this.options.storKeys:Object.keys(this.options).filter((t=>keyCond(t))),t}single2Els(t,e){let s=[];if(t){let i=getDataType(t);"Array"===i?s=t:i.includes("HTML")?s.push(t):s=getEls(t,e)}return s.filter(Boolean)}useTpl(){let t=getEl(this.options.tplStr);this.tplEng=this.options.tplEng||renderTpl,this.tplStr=t?.innerHTML||this.options.tplStr}getTplcont(t,e=this.tplStr,s=this.tplEng){let i=s||renderTpl;return"template"===i.name?i(this.tplStr)(t):i(e,t)}useHandle(t){return this.handleEls.length&&contains(t,this.handleEls)}ready({type:t="node",options:e={},maps:i=[],host:a,component:l=!1,spread:n=[]}){getDataType(a);let r={};this.propsMap=i,"node"===t?(this.targetEl=getEl(a),this.targetEl&&(storeNode(this.targetEl)?.addModule(this.moduleName),r={el:this.targetEl,component:l},this.rawHtml=this.targetEl.innerHTML,1===this.targetEl.children.length&&(this.rawEl=this.targetEl.children[0]),this.compAttrs=[])):"data"===t&&(this.targetData=a),this.options=this.mergeOpts({source:e,map:this.propsMap,...r}),this.storKeys=this.getStorageKeys(),this.createProxy&&this.createProxy(),this.plans={},h.push(this,this.options.insName,this.moduleName),this.on("initiate",(()=>{this.destroyed=!1,this.updateOpts(n),this.targetEl&&this.targetEl.classList.add(`${s.prefix}initiated`),this.options.hasOwnProperty("tplStr")&&this.useTpl()})),this.on("initiated",(()=>{this.initialized=!0,this.initCount++})),this.on("destroyed",(()=>{this.clearCache&&this.clearCache(),this.destroyed=!0}))}moreExceed({data:t,source:e,sliced:s=!0,min:i=this.options.min,max:a=this.options.max}){return new Promise(((l,n)=>{let r=e.length,o=t.length,h=r+o,p={min:i,max:a,cur:r,val:o};if(a&&h>a){this.listen({name:"tooMany",params:[p]});let e=a-r;e&&s?l(t.slice(0,e)):n()}else h<i?(this.listen({name:"tooFew",params:[p]}),l(null)):l(null)}))}lessExceed({data:t,source:e,sliced:s=!0,min:i=this.options.min,max:a=this.options.max}){return new Promise(((l,n)=>{let r=e.length,o=t.length,h=r-o,p={min:i,max:a,cur:r,val:o};if(a&&h>a)this.listen({name:"tooMany",params:[p]}),l(null);else if(h<i){this.listen({name:"tooFew",params:[p]});let e=r-i;e&&s?l(t.slice(0,e)):n()}else l(null)}))}getDirRtl(){if(this.options.rtl)return void(this.isRtl=!0);if(!this.targetEl)return;"rtl"!==this.targetEl.getAttribute("dir")?this.isRtl=getRtl():this.isRtl=!0}getRtlCoef(){return"x"===this.options.axis&&this.isRtl?-1:1}lock(t){if(!this.destroyed&&this.targetEl)return this.targetEl.toggleAttribute("inert",!0),this.destroyed=!0,this.listen({name:"locked",cb:t}),this}unlock(t){if(this.targetEl)return this.targetEl.toggleAttribute("inert",!1),this.destroyed=!1,this.listen({name:"unlocked",cb:t}),this}async reset(t){return this.options=deepClone(this.dftOpts),this.revertHtml&&this.targetEl&&this.revertHtml(this.targetEl),await this.init(),this.clearCache&&this.clearCache(),this.listen&&this.listen({name:"reset",cb:t}),this}async update(t,e){return this.destroyed||(isEmpty(t)||(this.updateCache&&this.updateCache(t),extend({target:this.options,source:t}),await this.init()),this.listen&&this.listen({name:"updated",cb:e,params:[t]})),this}async updateCont(t,e){return this.destroyed?this:this.options.hasOwnProperty("content")&&!isNull(t)?(this.options.content=t,await this.init(),this.updateCache({content:t}),this.listen({name:"updatedCont",cb:e,params:[t]}),this):void 0}async init(t){}destroy(t){}}class ModBaseListen extends ModBase{plans={};listen({name:t,params:e=[],cb:s}={}){t&&this.plans.hasOwnProperty(t)&&this.emit(t,...e),t&&this.options[`on${startUpper(t)}`]&&this.options[`on${startUpper(t)}`].call(this,...e),s&&s.call(this,...e)}on(t,e){return m.add(t,this,e),this}emit(t,...e){return m.do(t,this,...e),this}off(t,e){return m.remove(t,this,e),this}}class Observe extends ModBaseListen{options={};dataType;completedCount;reactCount;proxys;fullMethods;methods;output;canProxy;hasProp;canDeep;canRun;keys;types;proxy;hostProxy;static hostType="data";static optMaps=g;constructor(t,e={},s=!0){super(),super.ready({type:Observe.hostType,options:e,maps:Observe.optMaps,host:t,spread:["deep"]}),this.proxys=[],this.targetData&&s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}this.completedCount=0,this.reactCount=0,this.canProxy=(t,e)=>this.types.includes(t)&&!isProxy(e),this.hasProp=t=>(isEmpty(this.options.deep.include)||this.options.deep.include.includes(t))&&(isEmpty(this.options.deep.exclude)||!this.options.deep.exclude.includes(t)),this.canDeep=(t,e)=>this.canProxy(t,e)&&this.options.deep.enable,this.canRun=t=>!this.options.filter||this.options.filter(t),this.keys={got:[],set:[],deleted:[]},this.fullMethods={get:(t,e,s)=>{if(!this.canRun(e))return;if("_isProxy"===e)return!0;let i=t[e],a={target:t,key:e,value:i,raw:i,proxy:s};return!this.keys.got.includes(e)&&this.keys.got.push(e),super.listen({name:"got",params:[{...a,type:"got"}]}),super.listen({name:"crud",params:[{...a,type:"got"}]}),super.listen({name:"trigger",params:[{...a,type:"got"}]}),Reflect.get(t,e,s)},set:(t,e,s,i)=>{if(!this.canRun(e))return!0;if(deepEqual(t[e],s)||this.options.lenient&&t[e]===s||!this.options.lenient&&t[e]==s)return!0;let a={target:t,key:e,value:s,raw:t[e],proxy:i},l=void 0===t[e]?"added":"edited";return s=this.deepProxy(s),this.options.accept&&Reflect.set(t,e,s),!this.keys.set.includes(e)&&this.keys.set.push(e),super.listen({name:"crud",params:[{...a,type:"set"}]}),super.listen({name:"set",params:[{...a,type:"set"}]}),super.listen({name:l,params:[{...a,type:l}]}),super.listen({name:"trigger",params:[{...a,type:"set"}]}),this.reactCount++,this.complete(this.reactCount),!0},delete:(t,e)=>{if(!this.canRun(e))return!0;let s=t[e],i={target:t,key:e,value:s,raw:s};return this.options.accept&&Reflect.deleteProperty(t,e),!this.keys.deleted.includes(e)&&this.keys.deleted.push(e),super.listen({name:"deleted",params:[{...i,type:"deleted"}]}),super.listen({name:"crud",params:[{...i,type:"deleted"}]}),super.listen({name:"trigger",params:[{...i,type:"deleted"}]}),this.reactCount++,this.complete(this.reactCount),!0},construct:(t,e,s)=>{let i={target:t,args:e,proxy:s};return super.listen({name:"constructed",params:[{...i,type:"constructed"}]}),super.listen({name:"trigger",params:[{...i,type:"constructed"}]}),this.reactCount++,this.complete(this.reactCount),Reflect.construct(t,e,s)},apply:(t,e,s)=>{let i={target:t,pointer:e,args:s};return super.listen({name:"applied",params:[{...i,type:"applied"}]}),super.listen({name:"trigger",params:[{...i,type:"applied"}]}),this.reactCount++,this.complete(this.reactCount),Reflect.apply(t,e,s)}},this.methods={};for(let t in this.fullMethods){let e="delete"===t?"deleteProperty":t;this.methods[e]=this.fullMethods[t]}return this.types=isEmpty(this.options.types)?["Object","Array","Function","Class"]:this.options.types,this.dataType=getDataType(this.targetData),this.types.includes(this.dataType)?(this.hostProxy=this.options.deep.enable?this.deepProxy(this.targetData):this.addProxy(this.targetData),this.proxy=this.hostProxy):this.proxy=this.targetData,super.listen({name:"initiated",cb:t}),this}deepProxy(t){let e=getDataType(t);if(this.canDeep(e,t)){for(let e in t){if(!this.hasProp(e))continue;let s=t[e],i=getDataType(s);t.hasOwnProperty(e)&&this.canDeep(i,s)&&(t[e]=this.deepProxy(s))}return this.addProxy(t)}return t}addProxy(t){if(t._isProxy)return this.proxys.push(t),t;{let e=Proxy.revocable(t,this.methods);return this.proxys.push(e),e.proxy}}complete(t){setTimeout((()=>{if(t===this.reactCount){if(this.options.once&&0!==this.completedCount)return;for(let t in this.keys)this.keys[t]=unique(this.keys[t].filter((t=>"symbol"!=typeof t)));super.listen({name:"completed",params:[{count:this.completedCount,target:this.targetData,proxy:this.hostProxy,keys:this.keys,type:"completed"}]}),this.completedCount++,this.keys={got:[],set:[],deleted:[]}}}),0)}destroy(){this.proxys.forEach((t=>{t.revoke()}))}}class ModBaseListenCache extends ModBaseListen{storKeys=[];storObs;storTmp;createProxy(){this.storTmp={},this.storObs=new Observe(this.storTmp)}clearCache(t){if(this.options.storName){for(let t in this.storObs.proxy)Reflect.deleteProperty(this.storObs.proxy,t);this.listen&&this.listen({name:"clearedCache",cb:t}),this.save()}return this}updateCache(t,e){if(this.options.storName&&!isEmpty(t)){let s={};for(let e in t)t.hasOwnProperty(e)&&this.storKeys.includes(e)&&(s[e]=t[e]);deepMerge(this.storObs.proxy,s,{}),this.listen&&this.listen({name:"updatedCache",cb:e}),this.save()}return this}optsMergeStorage(){if(this.options.storName){let t=u.get(this.options.storName);isEmpty(t)?this.clearCache():(this.updateCache(t),extend({target:this.options,source:t}))}}save(t){if(this.destroyed||!this.options.storName)return;let e=isEmpty(this.storTmp)?{}:deepClone(this.storTmp);return u.set(this.options.storName,e),this.listen&&this.listen({name:"saved",cb:t,params:[e]}),this}}const b={getIBulletTpl:(t={})=>`\n        {{let   value = this.value?'value="'+ this.value +'"':this.label?'value="'+ this.label +'"':'',\n                custom =this.custom?'<span ${s.alias}="custom">'+this.custom+'</span>':'',\n                badge = this.badge?'<ax-badge>'+this.badge+'</ax-badge>':'',\n                tips =this.tips?'<i ${s.alias}="tips">'+this.tips+'</i>':'',\n                arrow=this.arrow?'<i class="'+this.arrow+'" ${s.alias}="arrow"></i>':'',\n                type = this.type || "${t.type}",\n                check = this.checked && !['checkboxes','radios'].includes(type) ?'checked':'',\n                name = this.name?'name="'+this.name+'"':'name="${s.namePfx}${Date.now()}"',\n                icon = this.icon?'<i ${s.alias}="icon" class="'+this.icon+'"></i>':'',\n                disk = this.disk?'<span ${s.alias}="disk"><img src="'+this.disk+'"></span>':'',\n                cube = this.cube?'<span ${s.alias}="cube"><img src="'+this.cube+'"></span>':'',\n                selected=this.selected?'selected':'',\n                active=this.active?'active':'',\n                disabled=this.disabled?'disabled':''; \n        /}}\n        <${t.childNode}>\n                    <div class="${s.prefix}bullet" ${t.unpadded?"unpadded":""} ${t.hoverable?"hoverable":""}  ${t.multiline?"multiline":""} {{value}} {{selected}} {{active}} {{check}}  {{disabled}}>\n                    {{icon}}\n                    {{disk}}\n                    {{cube}}\n                    <div class="${s.prefix}bullet-body">\n                        {{if(type ==='checkboxes'){/}}\n                            <ax-checkbox {{name}} {{this.checked?'check="ed"':''}} {{value}}>{{this.label}}</ax-checkbox>\n                        {{}else if (type ==='radios'){/}}\n                            <ax-radio {{name}} {{this.checked?'check="ed"':''}} {{value}}>{{this.label}}</ax-radio>\n                        {{}else if(this.href){/}}\n                            <a ${s.alias}="label" href="{{this.href}}" {{this.target?'target="'+ this.target +'"':''}} {{this.rel?'rel="'+ this.rel +'"':''}}>{{this.label}}</a>\n                        {{}else{/}}\n                            <span ${s.alias}="label">{{this.label}}</span>\n                        {{}/}}\n                    </div>\n                    {{custom}}\n                    {{badge}}\n                    {{tips}}\n                    {{arrow}}\n                    </div>\n                    ${t.divisible?"<hr>":""}\n                </${t.childNode}>\n        `,getBulletsTpl:function(t={}){let e="";return t.cols>0&&(e=`${s.prefix}grid  ${s.prefix}avg-${t.cols}`,e+="fence"===t.lines?` ${s.prefix}fence`:"fluid"===t.lines?` ${s.prefix}fluid`:""),`\n        <${t.parentNode} class="${s.prefix}reset ${e}">\n            {{for(let k of this){/}}\n                ${this.getIBulletTpl(t).replaceAll("this.","k.")}\n            {{}/}}\n        </${t.parentNode}>`},getChildNodes:t=>{let e=getEl(t);return isEmpty(e)?[]:getEls(`.${s.prefix}bullet`,e)},getChecked:function(t){let e=[];if(isEmpty(t))return"";if(t.length>0)if(t[0].querySelector("input"))for(let s of t){let t=s.querySelector("input");t.checked&&e.push(t.value)}else for(let s of t)s.hasAttribute("checked")&&e.push(s.getAttribute("value"));return e.filter(Boolean).join(",")},setChecked:function(t,e){let s=getDataType(t),i=[];if("Array"===s?i=t:"String"===s&&(i=t.split(",").filter(Boolean)),0!==e.length)if(0===i.length)for(let t of e){let e=t.querySelector("AX-CHECKBOX,AX-RADIO");e?e.removeAttribute("check"):t.removeAttribute("checked")}else{let t=i.map((t=>e.find((e=>e?.querySelector("input")?.value==t||e.getAttribute("value")==t)))).filter(Boolean);for(let s of e){let e=s.querySelector("AX-CHECKBOX,AX-RADIO");t.includes(s)?e?e.setAttribute("check","ed"):s.toggleAttribute("checked",!0):e?e.removeAttribute("check"):s.removeAttribute("checked")}}},toggleChecked:(t,e,s="select-single")=>{if(!t||!s.includes("select")||isEmpty(e))return;let i=t.hasAttribute("checked");if("select-single"===(s=s||"select-single")){if(i)return;t.toggleAttribute("checked",!0),e.filter((e=>e!==t&&t.hasAttribute("checked"))).forEach((t=>{t.removeAttribute("checked")}))}else i?t.removeAttribute("checked"):t.toggleAttribute("checked",!0)},clearChecked:t=>{if(!isEmpty(t))for(let e of t){let t=e.querySelector("AX-CHECKBOX,AX-RADIO");t?t.removeAttribute("check"):e.removeAttribute("checked")}},toggleSelected(t,e){if(!t||isEmpty(e))return;if(!t.hasAttribute("selected")){t.toggleAttribute("selected",!0);let s=e.find((e=>e!==t&&e.hasAttribute("selected")));s&&s.toggleAttribute("selected",!1)}},setSelected(t,e){if(!t||isEmpty(e))return;let s=e.find((e=>e.getAttribute("value")===t));s&&this.toggleSelected(s,e)},getSelected(t){if(isEmpty(t))return;let e=t.find((t=>t.hasAttribute("selected")));return e&&e.getAttribute("value")||""},clearSelected(t){let e=t.find((t=>t.hasAttribute("selected")));e&&e.removeAttribute("selected")}},createBtns=(t,e,i={},a)=>{let n=getEl(e),r=createEl("div",{class:`${s.prefix}box-btns`}),o={submit:{name:"submit",label:l.lang.button.submit},reset:{name:"reset",label:l.lang.button.reset},prev:{name:"prev",label:l.lang.button.prev},next:{name:"next",label:l.lang.button.next},now:{name:"now",label:l.lang.button.now},close:{name:"close",label:l.lang.button.close},cancel:{name:"cancel",label:l.lang.button.cancel},clear:{name:"clear",label:l.lang.button.clear},confirm:{name:"confirm",label:l.lang.button.confirm}},h=Object.keys(o);if(t.forEach(((e,n)=>{let p=e?.name||e,d=h.includes(p)?extend({target:{...o[p]},source:e.hasOwnProperty("name")?e:{}}):e;(t=>{let e={label:Object.keys(l.lang.button).includes(t.name)&&!t.label?l.lang.button[t.name]:t.label||l.lang.button.default},a=["type","theme","size","width","shape","check","icon","tail","disk","cube","tips","mean","disabled","shaded","grad"];for(let s of a)(n=s)&&!isNull(t[n])&&(e[n]=t[n]);var n;t.name&&(e[s.alias]=t.name),t.hasOwnProperty("badge")&&(e.badge=t.badge),!isNull(t.href)&&(e.href=t.href),t.target&&!isNull(t.href)&&(e.target=t.target),t.rel&&!isNull(t.href)&&(e.rel=t.rel),t.el=createEl("ax-btn",Object.assign({...i},e,t.attrs)),!isEmpty(t.classes)&&classes(t.el).add(t.classes),!isEmpty(t.styles)&&(t.el.style.cssText+=t.styles)})(d),r.appendChild(d.el),d.action&&(a?d.action.call(a,d):d.action(d)),t[n]=d})),n){let t=n.querySelector(`.${s.prefix}box-btns`);t&&t.remove(),n.appendChild(r)}return r},createFooter=({nodeName:t="div",layout:e="center",attrs:i,tips:a=!1,divider:n=!1,padding:r=!1,children:o=[]},h,p)=>{n=spreadBool(n,{}),r=spreadBool(r,{}),a=spreadBool(a,{html:l.lang.placehold.tips});let d,c=getEl(h),u=createEl(t,Object.assign({class:`${s.prefix}bubble-footer`,layout:e},i)),g=n.enable?createEl(n.nodeName||"ax-line",Object.assign({[s.alias]:"divider"},n.attrs)):null,m=r.enable?createEl(r.nodeName||"div",Object.assign({class:`${s.prefix}p`,[s.alias]:"padding"},r.attrs)):null,b=a.enable?createEl(a.nodeName||"div",Object.assign({[s.alias]:"tips"},a.attrs),a.html):null,E=createEl("div",{class:`${s.prefix}bubble-footer-wrap`});if(u.setAttribute("layout",e),g&&u.appendChild(g),m?(u.appendChild(m),d=m):d=u,d.appendChild(E),o.length>0&&createBtns(o,E,"plain"===e?{type:"plain"}:{},p),b&&E.appendChild(b),c){let t=c.querySelector(`.${s.prefix}bubble-footer`);t&&t.remove(),c.appendChild(u)}return u},createTools=(t,e,i)=>{let a,l=getEl(e),n=createEl("span",{class:`${s.prefix}box-tools`}),r={add:{name:"add",icon:`${s.prefix}icon-plus`},close:{name:"close",icon:`${s.prefix}icon-close`},remove:{name:"remove",icon:`${s.prefix}icon-trash`},edit:{name:"edit",icon:`${s.prefix}icon-edit`},copy:{name:"copy",icon:`${s.prefix}icon-copy`},update:{name:"update",icon:`${s.prefix}icon-refresh`},move:{name:"move",icon:`${s.prefix}icon-drag`},file:{name:"file",icon:`${s.prefix}icon-file`},folder:{name:"folder",icon:`${s.prefix}icon-folder`},toggle:{name:"toggle",icon:`${s.prefix}icon-max`,swap:`${s.prefix}icon-min`},enlarge:{name:"enlarge",icon:`${s.prefix}icon-expand`,swap:`${s.prefix}icon-collapse`},widen:{name:"widen",icon:`${s.prefix}icon-expand-h`,swap:`${s.prefix}icon-collapse-h`},heighten:{name:"heighten",icon:`${s.prefix}icon-expand-v`,swap:`${s.prefix}icon-collapse-v`},play:{name:"play",icon:`${s.prefix}icon-play-o`,swap:`${s.prefix}icon-pause-o`},zoomin:{name:"zoomin",icon:`${s.prefix}icon-zoomin`},zoomout:{name:"zoomout",icon:`${s.prefix}icon-zoomout`},zoom:{name:"zoom",icon:`${s.prefix}icon-zoom`},fullscr:{name:"fullscr",icon:`${s.prefix}icon-bigger`,swap:`${s.prefix}icon-smaller`},flipv:{name:"flipv",icon:`${s.prefix}icon-flip-v`},fliph:{name:"fliph",icon:`${s.prefix}icon-flip-h`},rotatel:{name:"rotatel",icon:`${s.prefix}icon-rotate-left`},rotater:{name:"rotater",icon:`${s.prefix}icon-rotate-right`},download:{name:"download",icon:`${s.prefix}icon-download`},share:{name:"share",icon:`${s.prefix}icon-share`},thumb:{name:"thumb",icon:`${s.prefix}icon-thumb`},more:{name:"more",icon:`${s.prefix}icon-plus-s`,swap:`${s.prefix}icon-minus-s`}},o=Object.keys(r);if(t.forEach(((e,a)=>{let l=e?.name||e,h=o.includes(l)?Object.assign(r[l],e.name?e:{}):e;(t=>{let e={},i=t.extendable?`<i ${s.alias}="arrow"></i>`:"",a=(t.icon?`<i class="${t.icon}" ${s.alias}="icon"></i>`:"")+(t.disk?`<i ${s.alias}="disk"><img src="${t.disk}"/></i>`:"")+(t.cube?`<i ${s.alias}="cube"><img src="${t.cube}"/></i>`:"")+(t.image?`<i ${s.alias}="image"><img src="${t.image}"/></i>`:"")+(t.label?`<i ${s.alias}="label">${t.label}</i>`:"")+i;t.name&&(e[s.alias]=t.name),t.title&&(e.title=t.title),t.focusable&&(e.tabindex=1),t.wrapEl=createEl(t.nodeName||"span",Object.assign(e,t.attrs),a),t.iconEl=t.wrapEl.querySelector(`[${s.alias}="icon"]`),t.cubeEl=t.wrapEl.querySelector(`[${s.alias}="cube"]`),t.diskEl=t.wrapEl.querySelector(`[${s.alias}="disk"]`),t.imageEl=t.wrapEl.querySelector(`[${s.alias}="image"]`),t.labelEl=t.wrapEl.querySelector(`[${s.alias}="label"]`),!isEmpty(t.classes)&&classes(t.wrapEl).add(t.classes),!isEmpty(t.styles)&&(t.wrapEl.style.cssText+=t.styles)})(h),n.appendChild(h.wrapEl),h.action&&(i?h.action.call(i,h):h.action(h)),t[a]=h})),l){let t=l.querySelector(`.${s.prefix}box-tools`);t&&t.remove(),l.appendChild(n)}let h=t.find((t=>t.tips));if(h){n.tooltipTgr="pointermove",n.tooltipEvt=function(){let e=t.find((t=>t.wrapEl===this));e&&(a.replaceCont(e.tips),a.transfer(this))},(async()=>{let e=await Promise.resolve().then((function(){return tt}));a=new e.default(h.wrapEl,{content:"",size:"",placement:"top"});for(let e of t)e.tips&&e.wrapEl.addEventListener(n.tooltipTgr,n.tooltipEvt,!1)})()}return n},clampVal=({val:t=0,min:e=0,max:s=100})=>{let i=toNumber(t),a=toNumber(e),l=toNumber(s);return!["",null,void 0].includes(e)&&i<a?a:!["",null,void 0].includes(s)&&i>l?l:i},isCompField=t=>!(!t||"string"!=typeof t)&&i.includes(t.toLowerCase().replace("ax-","")),E={getType:t=>{let e=getEl(t),i="";return e?(i=["TEXTAREA","SELECT","INPUT"].includes(e.nodeName)?"native":isCompField(e.nodeName)&&e[s.compSign]?"comp":"other",i):i},getVals:function({target:t,format:e="",parent:i,separator:a=",",child:l,key:n}){let r,o=getEl(t),h=this.getType(o),p=[],d="array"===e?[]:"string"===e?"":null;try{if(o){let t=o.nodeName,d=o.type,c=[],u=getEl(i)||o.closest("form")||document.body;if("comp"===h)if(["AX-CHECKBOX","AX-RADIO"].includes(t)){c=[...u.querySelectorAll(`[name="${o.name}"]`)].filter((t=>t[s.compSign]));for(let t of c)t.checked&&t.value&&p.push(t.value);r="array"===e?p:p.join(a)}else{let t=o.value;r="array"===e?t.split(a):t}else if("native"===h){if("SELECT"===t)for(let t of[...o.options])t.selected&&p.push(t.value||t.getAttribute("label")||"");else if("file"===d)p=[...o.files];else if(["checkbox","radio"].includes(d)){c=[...u.querySelectorAll(`[name="${o.name}"]`)];for(let t of c)t.checked&&t.value&&p.push(t.value)}else p=o.value?[o.value]:[];r="string"===e?"file"===d?p.map((t=>t.name.trim())).join(a):p.join(a):"array"===e||"SELECT"===t&&o.multiple||"checkbox"===d&&c.length>1||"file"===d&&o.multiple?p:p[0]||""}else{let t=getEl(l,o)||o,s=n?t.getAttribute(n):t.textContent;r="array"===e?s.split(a):s}return r}}catch(t){return d}},setVals:function({target:t,value:e,parent:i,separator:a=",",child:l,key:n=""}){let r=getEl(t),o=isEmpty(e)?[]:valToArr(e,a).map((t=>t+"")),h=getEl(i)||r?.closest("form")||document.body,p=[];if(r){let t=this.getType(r);if("comp"===t){let t=o.join(a);if(["AX-CHECKBOXES","AX-RADIOS"].includes(r.nodeName))r.setAttribute("checked",t);else if(["AX-CHECKBOX","AX-RADIO"].includes(r.nodeName)){let t=[...h.querySelectorAll(`[name="${r.name}"]`)].filter((t=>t[s.compSign]&&t.getAttribute("value")));for(let e of t)o.includes(e.value)?e.setAttribute("check","ed"):e.removeAttribute("check")}else r.setAttribute("value",t)}else if("native"===t){let t=r.nodeName,e=r.type;if("SELECT"===t){let t=[...r.options],e=o.map((t=>t.toString()));t.forEach((t=>{let s=t.value||t.getAttribute("label")||"";t.selected=!!e.includes(s)})),p=[r]}else if(["checkbox","radio"].includes(e)){p=[...h.querySelectorAll(`[name="${r.name}"]`)].filter((t=>t.getAttribute("value")));let t=o.map((t=>t.toString()));p.forEach((e=>{e.checked=!!t.includes(e.value)}))}else r.value="file"===e?"":"number"===e?clampVal({val:o[0]||0,min:r.min,max:r.max}):"range"===e?o[0]||r.min||0:o.filter(Boolean).join()}else{let t=getEl(l,r)||r;n?t.setAttribute(n,e):t.innerHTML=e}}},reset:function({target:t,parent:e,zero:s=!1}){let i=getEl(t);if(!i)return;let a=this.getType(i),l=i.type;if("native"===a)if(l?.includes("select"))[...i?.options].forEach((t=>t.selected=!s&&t.defaultSelected));else if("checkbox"===l||"radio"===l){[...(getEl(e)||i?.closest("form")||document.body).querySelectorAll(`[name="${i?.name}"]`)].forEach((t=>{t.checked=!s&&t.defaultChecked}))}else["number","range"].includes(l)?i.value=s?i?.min||0:i?.defaultValue:i.value=s?"":i?.defaultValue;else"comp"===a?s?i.clear():i.reset():s&&i.clear?i.clear():!s&&i.reset&&i.reset()}},tplToEl=t=>{if(!(t=t.trim().replaceAll("&lt;","<").replaceAll("&gt;",">")))return null;let e="";t.startsWith("<tr")||t.startsWith("<TR")?(e="tr",t=`<table><tbody>${t}</tbody></table>`):(t.startsWith("<td")||t.startsWith("<TD"))&&(e="td",t=`<table><tbody><tr>${t}</tr></tbody></table>`);let s=createEl("TEMPLATE","",t).content.cloneNode(!0);return(e?s.querySelector(e):s.firstElementChild)||null},f=[{attr:"heading",prop:"heading",value:""},{attr:"classes",prop:"classes",value:""},{attr:"placement",prop:"placement",value:"center-top"},{attr:"content",prop:"content",value:""},{attr:"status",prop:"status",value:"info"},{attr:"delay",prop:"delay",value:3e3},{attr:"progress",prop:"progress",value:!0},{attr:"closable",prop:"closable",value:!0},{attr:"manual",prop:"manual",value:!1},{attr:"eager",prop:"eager",value:!1},{attr:"icon-show",prop:"iconShow",value:!1},{attr:"notable",prop:"notable",value:!1},{attr:"z-index",prop:"zIndex",value:0},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-hidden",prop:"onHidden",value:null},...p],getHeights=t=>{let e=getEl(t);if(!e)throw new Error("The target node does not exist!");let s=style(e);return{height:parseInt(s.height),paddingTop:parseInt(s.paddingTop),paddingBottom:parseInt(s.paddingBottom),marginTop:parseInt(s.marginTop),marginBottom:parseInt(s.marginBottom),borderTopWidth:parseInt(s.borderTopWidth),borderBottomWidth:parseInt(s.borderBottomWidth)}},v={linear:t=>t,ease:t=>(1-t)**2*t*3*.3+t**2*(1-t)*3*1+t**3,easeIn:t=>t**2*(1-t)*3*.2+t**3,easeOut:t=>(1-t)**2*t*3*.8+t**2*(1-t)*3*1+t**3,easeInOut:t=>t<.5?Math.sqrt(.5*t):1-Math.sqrt(.5*(1-t)),easeOutIn:t=>t<.5?2*t**2:-2*(t-1)**2+1};let ease=({from:t,to:e,before:i,doing:a,done:l,progress:n,duration:r,curve:o})=>{if(!t||!e)throw new Error("from and to are required!");let h=Date.now(),p={step:0,value:{...t},frame:0,remaining:0},repeat=()=>{let i=r||500,d=Date.now()-h,c=d/i,u=v[o||"easeOut"](c),g={...t},m=i-d,b=requestAnimationFrame(repeat);for(let s in t)t.hasOwnProperty(s)&&t[s]!==e[s]&&(g[s]=t[s]+(e[s]-t[s])*u);p={step:u,frame:b,value:g,remaining:m},s.frame=b,c<1?(n&&n(p),a&&a(p)):(cancelAnimationFrame(b),p.step=1,p.value={...e},p.remaining=0,n&&n(p),l&&l(p))};return i&&i(p),repeat(),p};const getAutoDur=t=>isNull(t)?200:~~(parseFloat(t)/3+250);let slideDown=({el:t,display:e="block",before:s,doing:i,done:a,duration:l,curve:n="easeOut",cut:r=!0})=>{let o=getEl(t);if(!o)throw new Error("The target node does not exist!");let h=elState(o);if(h.isHidden){let t=`${o.style.cssText}display: ${e};`,h=`${t}${r?"overflow:hidden;":""}`;o.style.cssText=h;let{height:p,paddingTop:d,paddingBottom:c,marginTop:u,marginBottom:g}=getHeights(o),m=~~l&&0!==l?~~l:getAutoDur(p);o.style.cssText+="padding-top: 0; padding-bottom: 0;margin-top: 0; margin-bottom: 0;",ease({from:{height:0,paddingTop:0,paddingBottom:0,marginTop:0,marginBottom:0},to:{height:p,paddingTop:d,paddingBottom:c,marginTop:u,marginBottom:g},duration:m,curve:n,before:t=>{s&&s.call(o,{frame:t.frame,value:t.value.height,step:t.step,for:"show"})},doing:t=>{o.style.cssText=`\n                ${h}\n                padding-top: ${t.value.paddingTop}px; \n                padding-bottom: ${t.value.paddingBottom}px;\n                margin-top: ${t.value.marginTop}px; \n                margin-bottom: ${t.value.marginBottom}px; \n                height: ${t.value.height}px\n                `,i&&i.call(o,{frame:t.frame,value:t.value.height,step:t.step,target:o,for:"show"})},done:e=>{o.style.cssText=t,a&&a.call(o,{frame:e.frame,value:e.value.height,step:e.step,target:o,for:"show"})}})}else h.isVirtual&&(o.style.display=e,a&&a.call(o));return o},slideUp=({el:t,display:e="block",before:s,doing:i,done:a,duration:l,curve:n="easeOut",cut:r=!0})=>{let o=getEl(t);if(!o)throw new Error("The target node does not exist!");let h=elState(o);if(h.isCalc){let t=o.style.cssText,{height:h,paddingTop:p,paddingBottom:d,marginTop:c,marginBottom:u}=getHeights(o),g=~~l&&0!==l?~~l:getAutoDur(h),m=`${`${t}display: ${e};`}${r?"overflow:hidden;":""}`;o.style.cssText=`${m}padding-top: 0; padding-bottom: 0;margin-top: 0; margin-bottom: 0;`,ease({from:{height:h,paddingTop:p,paddingBottom:d,marginTop:c,marginBottom:u},to:{height:0,paddingTop:0,paddingBottom:0,marginTop:0,marginBottom:0},duration:g,curve:n,before:t=>{s&&s.call(o,{frame:t.frame,value:t.value.height,step:t.step,for:"hide"})},doing:t=>{o.style.cssText=`\n                ${m}\n                padding-top: ${t.value.paddingTop}px; \n                padding-bottom: ${t.value.paddingBottom}px;\n                margin-top: ${t.value.marginTop}px; \n                margin-bottom: ${t.value.marginBottom}px; \n                height: ${t.value.height}px\n                `,i&&i.call(o,{frame:t.frame,value:t.value.height,step:t.step,for:"hide"})},done:e=>{o.style.cssText=`${t}display: none`,a&&a.call(o,{frame:e.frame,value:e.value.height,step:e.step,for:"hide"})}})}else h.isVirtual&&(o.style.display="none",a&&a.call(o));return o};const setAttr=(t,e,s)=>{let i,a=getEl(t),l=getDataType(s);if(a&&e)return isNull(s)||!1===s?(a.removeAttribute(e),i={key:e,value:!!isNull(s)&&null}):"Boolean"===l&&!0===s?(a.toggleAttribute(e,!0),i={key:e,value:!0}):"String"===l?(a.setAttribute(e,s),i={key:e,value:s}):(a.setAttribute(e,JSON.stringify(s)),i={key:e,value:a.getAttribute(e)}),i},setAttrs=(t,e,s)=>{let i=getEl(t),a=[];if(i&&!isEmpty(e)){if(Array.isArray(e)||e.hasOwnProperty("key")||e.hasOwnProperty("value")){let t=Array.isArray(e)?e:[e];for(let e of t)a.push(setAttr(i,e.key,e.value))}else for(let t in e)a.push(setAttr(i,t,e[t]));s&&s(a.filter(Boolean))}},getAttrBool=t=>"true"===t||""===t,getAttrArr=(t,e="")=>{let s=[];if(null!==t){let i=t.trim();try{if(""===i||"true"===i)e&&(s=e.split(",").filter(Boolean));else{let t=parseStr({content:i,type:"array",catchable:!0});s=Array.isArray(t)?t:[i]}}catch(t){s=i.split(",")}}return s};class CompBase extends HTMLElement{shadowEl;slotEl;propsRaw;properties;propsProxy;propsObs;custAttrs;boolAttrs;reset;clear;wrapEl;plans;connected;set;timestamp;connCount;rawHtml;canListen;sourceEl;ins;constructor(){super(),this.properties={},this.propsRaw={},this[s.compSign]=!0,this.plans={},this.timestamp=Date.now(),this.connCount=0,this.createPropsObs(),this.canListen=!0,this.getRawCont()}connectedCallback(){this.connectedRender()}disconnectedCallback(){this.listen({name:"disconnected"})}adoptedCallback(){this.listen({name:"adopted"})}static lazyAttrs=["stor-name","class"];static baseAttrs=["on-connected","on-disconnected","on-adopted","on-reset","on-set"];static jsonAttrs=["lang"];static boolAttrs=[];createShadow(){this.shadowEl=this.attachShadow({mode:"open"}),this.slotEl=createEl("slot"),this.shadowEl.appendChild(this.slotEl)}saveProps(t,e,s){this.propsProxy[t]=s.boolAttrs.includes(t)?getAttrBool(e):s.jsonAttrs.includes(t)?strToJson(e):e}savePropsToListen(t,e,s,i,a){a&&Object.keys(a).includes(t)?this.propsProxy[t]=a[t]:this.saveProps(t,s,i),this.changedMaps[t]&&this.changedMaps[t].call(this,{name:t,newVal:s,oldVal:e,proxy:this.propsProxy})}getRawProps(t,e){for(let e of[...t.custAttrs,...t.lazyAttrs])this.propsRaw[e]=this.getAttribute(e);for(let e of t.boolAttrs)this.propsRaw[e]=getAttrBool(this.getAttribute(e));for(let e of t.jsonAttrs)this.propsRaw[e]=strToJson(this.getAttribute(e))}getProxyProps(){for(let t in this.propsRaw)this.propsProxy[t]=this.propsRaw[t]}restoreAttrs(){for(let t in this.propsProxy){let e=this.propsProxy[t],s=this.propsRaw[t];e!==s&&(isNull(s)?this.removeAttribute(t):!0===s?this.setAttribute(t,""):!1===s?this.removeAttribute(t):this.setAttribute(t,s))}}getHtmlVal(t="label",e=!0){return(e?this.textContent?.trim():this.innerHTML)||this.getAttribute(t)}connectedRender(t){this.render(t),this.connected=!0,this.listen({name:"connected",params:[this.ins]}),this.connCount++}getConnCont(t="html"){let e=createEl("div",null,this.rawHtml);return"text"===t?e.textContent:this.rawHtml}getRawCont(){if(!this.connCount){let t=this.querySelector(`:scope>[${s.alias}="source"]`);t?this.rawHtml=t.innerHTML:(this.sourceEl=createEl("template",{[s.alias]:"source"}),this.sourceEl.innerHTML=this.rawHtml=this.innerHTML)}}insertSource(){let t=this.sourceEl||this.querySelector(`:scope>[${s.alias}="source"]`);this.innerHTML=t?.outerHTML||""}createPropsObs(){this.propsObs=new Observe(this.properties,{deep:!0}),this.propsProxy=this.propsObs.proxy}updateProxy(t,e,s){let i;if(null===e)this.propsProxy[t]=this.ins.rawOpts[t];else{if("options"===t)i=strToJson(e);else if("async"===t)i=getAttrBool(e);else{if(!s)throw new Error(`Setting ${t} is invalid , Please use a module and set the map for options!`);i=attrJoinVal(t,e,s)}deepMerge(this.propsProxy,i,{})}}getAttrHtmlData(t){let e,getStr=t=>{let e=createEl("div",null,t).querySelector('script[type="content"]');return(e?.innerHTML||t).replace(/\n/g,"").trim()};if(isEmpty(t)){let t=this.getAttribute("content");e=getAttrArr(t||getStr(this.rawHtml))}else e=Array.isArray(t)?t:getAttrArr(getStr(t));return e}changedMaps={}}class CompBaseComm extends CompBase{constructor(){super(),this.reset=function(){this.innerHTML="",this.fillWrap(this.propsRaw),this.restoreAttrs(),this.render(this.propsRaw),this.listen({name:"reset"})},this.clear=(t="value")=>{this.removeAttribute(t),this.listen({name:"cleared",params:[t]})},this.set=t=>{if(isEmpty(t))return;let e="string"==typeof t?strToJson(t):t;setAttrs(this,e,(t=>{this.listen({name:"set",params:[t]})}))},this.on("disconnected",(()=>{this.connCount=0,this.innerHTML=this.rawHtml})),this.on("adopted",(()=>{this.connCount=0,this.innerHTML=this.rawHtml})),this.on("connected",(()=>{this.setAttribute(s.compSign,""),this.setCache()})),this.on("reset",(()=>{this.clearCache()})),this.propsObs.on("set",(t=>{this.connected&&this.updateCache({[t.key]:t.value})}))}completedEvt(t){this.ins.update(this.properties),this.listen({name:"updated",params:[this.properties]})}listen({name:t,params:e=[],cb:s}={}){if(t&&this.plans.hasOwnProperty(t)&&this.emit(t,...e),t&&this.propsProxy[`on-${t.toLowerCase()}`]){let s=this.propsProxy[`on-${t.toLowerCase()}`],addFnShell=t=>{let e=t.trim();return e.startsWith("function")||e.startsWith("(")||e.endsWith("}")?t:`function(){${t}}`},i=parseStr({content:addFnShell(s),type:"other",method:"new Function"});i&&i.call(this,...e)}s&&s.call(this,...e)}on(t,e){return m.add(t,this,e),this}emit(t,...e){return m.do(t,this,...e),this}off(t,e){return m.remove(t,this,e),this}setCache(){let t=this.propsProxy["stor-name"],e=u.get(t);if(!t||!e)return;let s=deepClone(e),i=s.data;s.hasOwnProperty("data")&&(i?setAttr(this,"data",i):this.removeAttribute("data"),Reflect.deleteProperty(s,"data"));for(let t in s)setAttr(this,t,s[t])}updateCache(t){let e=this.propsProxy["stor-name"];if(!e)return;let s=u.get(e)||{};Object.assign(s,t),u.set(e,s)}clearCache(){let t=this.propsProxy["stor-name"];t&&u.clear(t)}}class ResultElem extends CompBaseComm{iconEl;labelEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["to","shape","type",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,ResultElem)}getRawData(){this.getRawProps(ResultElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("span",{[s.alias]:"wrap"}),this.iconEl=createEl("i",{[s.alias]:"icon"},r.svg.info),this.labelEl=createEl("i",{[s.alias]:"label"},t.label||""),this.wrapEl.appendChild(this.iconEl),t.label&&this.wrapEl.appendChild(this.labelEl)}getIcon(t){let e="";if(t.to)if(t.type&&"svg"!==t.type){if("font"===t.type){let s=t.to+("thick"===t.shape?"-t":"fill"===t.shape?"-f":"");e=r.font[s]}}else e=r.svg[t.to];else e=r.svg.info;return e}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel,type:this.changedIcon,to:this.changedIcon,shape:this.changedIcon};changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal||"",elState(this.labelEl).isVirtual&&this.wrapEl.appendChild(this.labelEl)):this.labelEl.remove()}changedIcon(t){let e=this.getIcon(this.propsProxy);e&&(this.iconEl.innerHTML=e)}}const y=[{attr:"type",prop:"type",value:"line"},{attr:"theme",prop:"theme",value:""},{attr:"gradient",prop:"gradient",value:!1},{attr:"linecap",prop:"linecap",value:"round"},{attr:"size",prop:"size",value:""},{attr:"thk",prop:"thk",value:""},{attr:"classes",prop:"classes",value:""},{attr:"range",prop:"range",value:[0,100]},{attr:"value",prop:"value",value:0},{attr:"curve",prop:"curve",value:"easeOut"},{attr:"duration",prop:"duration",value:0},{attr:"rotate",prop:"rotate",value:!1},{attr:"simple",prop:"simple",value:!1},{attr:"control",prop:"control",value:!1},{attr:"steps",prop:"steps",value:[]},{attr:"label",prop:"label",value:{enable:!0,template:"",placement:"",unit:"%",tips:!1}},{attr:"number",prop:"number",value:{type:"percent",trunc:!0,emphatic:!1}},{attr:"b4-set",prop:"b4Set",value:null},{attr:"on-start",prop:"onStart",value:null},{attr:"on-move",prop:"onMove",value:null},{attr:"on-end",prop:"onEnd",value:null},{attr:"on-zero",prop:"onZero",value:null},{attr:"on-completed",prop:"onCompleted",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-pause",prop:"onPause",value:null},{attr:"on-continue",prop:"onContinue",value:null},{attr:"on-restored",prop:"onRestored",value:null},...p],splitNum=t=>{let e=t.toString().split("."),i=`<s>${e[0]}</s>`;return!isNull(e[1])&&(i+=`<u>.${e[1]}</u>`),`<span class="${s.prefix}splitnum">${i}</span>`};class Progress extends ModBaseListenCache{options={};vals;valNow;barNow;range;barSize;steps;completeEl;textEl;controlEl;obsIns;obs;labelTpl;trackEl;wrapEl;barEl;labelEl;numEl;unitEl;tipsEl;animFrame;durRest;initVals;startVals;endVals;toggleCtrl;static hostType="node";static optMaps=y;constructor(t,e={},i=!0){super(),super.ready({options:e,maps:Progress.optMaps,host:t,component:!0,spread:["label"]}),this.vals={},this.valNow=0,this.barNow=0,this.toggleCtrl=()=>{this.controlEl.classList.contains(`${s.prefix}icon-pause`)?this.pause():this.continue()},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.range=[...this.options.range].sort(((t,e)=>t-e)),this.barSize="circle"===this.options.type?251.2:"semicircle"===this.options.type?125.6:"gapcircle"===this.options.type?167.6:this.range[1],this.steps=this.options.steps.length?[...this.options.steps].sort(((t,e)=>e.value-t.value)):[],this.getInitVals(),this.completeEl=createEl("span",{[s.alias]:"complete"},this.options.lang.complete),this.textEl=createEl("div",{[s.alias]:"text"}),this.controlEl=createEl("i",{[s.alias]:"control",class:`${s.prefix}icon-pause`,disabled:""}),this.controlEl.addEventListener("click",this.toggleCtrl,!1),this.setObs(),this.render(),this.setAttrs(),this.watchEnds(),this.watchSteps(),super.listen({name:"initiated",cb:t}),this}setObs(){this.obsIns=new Observe({paused:!1,completed:!1},{onSet:t=>{"paused"===t.key||"completed"===t.key&&(t.value?(this.targetEl.setAttribute("completed",""),this.labelEl&&this.labelEl.appendChild(this.completeEl)):(this.completeEl.remove(),this.targetEl.removeAttribute("completed")))}}),this.obs=this.obsIns.proxy}setControl(t,e){t?classes(this.controlEl).replace(`${s.prefix}icon-pause`,`${s.prefix}icon-play`):classes(this.controlEl).replace(`${s.prefix}icon-play`,`${s.prefix}icon-pause`),e?this.controlEl.setAttribute("disabled",""):this.controlEl.removeAttribute("disabled")}setAttrs(){this.targetEl.classList.add(`${s.prefix}progress`),this.targetEl.setAttribute("linecap",this.options.linecap),this.targetEl.setAttribute("type",this.options.type),this.options.thk?this.targetEl.setAttribute("thk",this.options.thk):this.targetEl.removeAttribute("thk"),this.options.size?this.targetEl.setAttribute("size",this.options.size):this.targetEl.removeAttribute("size"),this.options.theme?this.targetEl.setAttribute("theme",this.options.theme):this.targetEl.removeAttribute("theme"),this.targetEl.toggleAttribute("gradient",this.options.gradient),this.targetEl.toggleAttribute("simple",this.options.simple),this.options.classes&&classes(this.targetEl).add(this.options.classes);let t=[`${s.prefix}rotate360`,`${s.prefix}loop-inf`];this.options.rotate&&"circle"===this.options.type?this.wrapEl.classList.add(...t):this.wrapEl.classList.remove(...t)}getInitVals(){this.vals=this.getVals(),this.valNow=this.vals.val,this.barNow=this.vals.bar,this.initVals={...this.vals},this.startVals={val:this.range[0],bar:this.barSize,ratio:0,percent:0,number:this.getNumber(this.range[0],0)},this.endVals={val:this.range[1],bar:0,ratio:1,percent:100,number:this.getNumber(this.range[1],100)}}getVal(t=this.vals.val){return isNull(t)?this.range[0]:clampVal({val:t,min:this.range[0],max:this.range[1]})}getBarVal(t){let e;if(t==this.range[0])e=this.barSize;else if(t==this.range[1])e=0;else{let s,i,a;isNull(t)?(s=this.vals.val,i=this.vals.ratio):(s=clampVal({val:t,min:this.range[0],max:this.range[1]}),i=this.getRatio(s)),a="line"==this.options.type?s-this.range[0]:this.barSize*(1-i),e=toNumber(a,{mode:"floor"})}return e}getRatio(t=this.vals.val){let e;return e=t==this.range[1]?1:t==this.range[0]?0:toNumber((t-this.range[0])/(this.range[1]-this.range[0]),{places:4,mode:"floor"}),e}getNumber(t,e){let s="value"===this.options.number.type?t:e,i=this.options.number.trunc?~~s:toNumber(s,{places:2,mode:"floor",zero:!0});return this.options.number.emphatic?splitNum(i):i}getVals(t=this.options.value){let e=this.getVal(t),s=this.getRatio(e),i=100*s;return{val:e,bar:this.getBarVal(e),ratio:s,percent:i,number:this.getNumber(e,i)}}render(){if(this.targetEl.innerHTML="",this.labelTpl=this.options.label.template||`<div ${s.alias}=label><div ${s.alias}=result><i ${s.alias}=number></i><i ${s.alias}=unit></i></div></div>`,"line"==this.options.type)this.trackEl=createEl("div",{[s.alias]:"track"}),this.wrapEl=this.trackEl,this.barEl=createEl("div",{[s.alias]:"bar",style:`width:${this.vals.percent}%`}),this.wrapEl.appendChild(this.barEl);else{let t="",e="";this.options.gradient&&("prim"==this.options.theme?t=`\n                <linearGradient id="svgbar-prim" >\n                    <stop offset="0%" style="stop-color:var(--${s.prefix}c-prim);" ></stop>\n                    <stop offset="100%" style="stop-color:var(--${s.prefix}c-prim-aj);" ></stop>\n                </linearGradient>\n              `:"error"==this.options.theme?t=`\n                <linearGradient id="svgbar-error" >\n                    <stop offset="0%" style="stop-color:var(--${s.prefix}c-error);" ></stop>\n                    <stop offset="100%" style="stop-color:var(--${s.prefix}c-error-aj);" ></stop>\n                </linearGradient>\n              `:"succ"==this.options.theme?t=`\n                <linearGradient id="svgbar-succ" >\n                    <stop offset="0%" style="stop-color:var(--${s.prefix}c-succ);" ></stop>\n                    <stop offset="100%" style="stop-color:var(--${s.prefix}c-succ-aj);" ></stop>\n                </linearGradient>\n              `:"warn"==this.options.theme?t=`\n            <linearGradient id="svgbar-warn" >\n                <stop offset="0%" style="stop-color:var(--${s.prefix}c-warn);" ></stop>\n                <stop offset="100%" style="stop-color:var(--${s.prefix}c-warn-aj);" ></stop>\n            </linearGradient>\n          `:"info"==this.options.theme?t=`\n                <linearGradient id="svgbar-info" >\n                    <stop offset="0%" style="stop-color:var(--${s.prefix}c-info);" ></stop>\n                    <stop offset="100%" style="stop-color:var(--${s.prefix}c-info-aj);" ></stop>\n                </linearGradient>\n              `:"issue"==this.options.theme&&(t=`\n                <linearGradient id="svgbar-issue" >\n                    <stop offset="0%" style="stop-color:var(--${s.prefix}c-issue);" ></stop>\n                    <stop offset="100%" style="stop-color:var(--${s.prefix}c-issue-aj);"></stop>\n                </linearGradient>\n              `)),"circle"==this.options.type?e=`<svg viewBox="0 0 100 100">\n                            ${t}\n                            ${this.options.simple?"":`<path d="M 50 50 m -40 0 a 40 40 0 1 1 80 0  a 40 40 0 1 1 -80 0" ${s.alias}="track"></path>`}\n                            <path d="M 50 50 m -40 0 a 40 40 0 1 1 80 0  a 40 40 0 1 1 -80 0" ${s.alias}="bar" stroke-dasharray=${this.barSize} stroke-linecap=${this.options.linecap}  stroke-dashoffset=${this.vals.bar}></path>\n                       </svg>\n                        `:"semicircle"==this.options.type?e=`<svg viewBox="0 0 100 60">\n                            ${t}\n                            ${this.options.simple?"":`<path d="M 50 50 m -40 0 a 40 40 0 1 1 80 0" ${s.alias}="track" stroke-linecap=${this.options.linecap}></path>`}\n                            <path d="M 50 50 m -40 0 a 40 40 0 1 1 80 0" ${s.alias}="bar" stroke-dasharray=${this.barSize} stroke-linecap=${this.options.linecap} stroke-dashoffset=${this.vals.bar}></path>\n                       </svg>\n                        `:"gapcircle"==this.options.type&&(e=`<svg viewBox="0 0 100 80">\n                            ${t}\n                            ${this.options.simple?"":`<path d="M15.367,70.026C11.954,64.137,10,57.296,10,49.999 C10,27.909,27.909,10,50,10c22.092,0,40,17.909,40,39.999c0,7.295-1.952,14.134-5.363,20.022" ${s.alias}="track" stroke-linecap=${this.options.linecap}></path>`}\n                            <path d="M15.367,70.026C11.954,64.137,10,57.296,10,49.999 C10,27.909,27.909,10,50,10c22.092,0,40,17.909,40,39.999c0,7.295-1.952,14.134-5.363,20.022" ${s.alias}="bar" stroke-dasharray=${this.barSize} stroke-linecap=${this.options.linecap} stroke-dashoffset=${this.vals.bar}></path>\n                       </svg>\n                        `),this.wrapEl=tplToEl(e),this.barEl=this.wrapEl.querySelector(`[${s.alias}="bar"]`),this.trackEl=this.wrapEl.querySelector(`[${s.alias}="track"]`)}if(this.targetEl.appendChild(this.wrapEl),this.targetEl.appendChild(this.textEl),this.options.label.enable){if(this.options.label.placement){let t=getEl(this.options.label.placement);t&&(t.insertAdjacentHTML("beforeEnd",this.labelTpl),this.labelEl=t.querySelector(`[${s.alias}="label"]`))}else this.textEl.insertAdjacentHTML("beforeEnd",this.labelTpl),this.labelEl=this.targetEl.querySelector(`[${s.alias}="label"]`);this.numEl=this.labelEl.querySelector(`[${s.alias}="number"]`),this.unitEl=this.labelEl.querySelector(`[${s.alias}="unit"]`),this.numEl&&(this.numEl.innerHTML=this.vals.number),this.unitEl&&(this.unitEl.innerHTML=this.options.label.unit),this.options.label.tips&&(this.labelEl.querySelector(`[${s.alias}="tips"]`)?(this.tipsEl=this.labelEl.querySelector(`[${s.alias}="tips"]`),this.tipsEl.innerHTML=this.options.lang.tips):(this.tipsEl=createEl("span",{[s.alias]:"tips"},this.options.lang.tips),this.labelEl.insertAdjacentElement("afterbegin",this.tipsEl)))}this.options.control&&this.textEl.appendChild(this.controlEl)}setAnim(t=this.vals.val,e){if(this.obs.paused)return!1;if(t===this.valNow)return!1;this.animFrame&&cancelAnimationFrame(this.animFrame);let s=this.vals,i=s.bar-this.barNow,a=e||3*Math.abs(i)+200;this.setControl(!1,!1),ease({from:{val:this.valNow},to:{val:t},duration:a,curve:this.options.curve,before:t=>{super.listen({name:"start",params:[{...s}]})},progress:t=>{s=this.getVals(t.value.val),this.durRest=t.remaining,this.valNow=s.val,this.barNow=s.bar,"line"==this.options.type?this.barEl.style.width=s.percent+"%":this.barEl.setAttribute("stroke-dashoffset",this.barNow),this.numEl&&(this.numEl.innerHTML=s.number),this.animFrame=t.frame,this.watchEnds(),this.watchSteps()},doing:t=>{super.listen({name:"move",params:[{...this.vals,valNow:this.valNow,barNow:this.barNow}]})},done:t=>{this.setControl(!1,!0),super.listen({name:"end",params:[{...this.vals,valNow:this.valNow,barNow:this.barNow}]})}})}watchEnds(){this.valNow>=this.range[1]?(this.obs.completed=!0,super.listen({name:"completed"})):(this.obs.completed=!1,this.valNow<=this.range[0]&&super.listen({name:"zero"}))}watchSteps(t=this.valNow){if(!this.steps.length)return;let e=this.steps.find((e=>e.value<=t));e&&(e.color&&(["prim","succ","error","info","warn","issue","text"].includes(e.color)?this.targetEl.setAttribute("theme",e.color):"line"===this.options.type?this.barEl.style.background=e.color:this.barEl.style.stroke=e.color),e.text&&(this.textEl.innerHTML=e.text),e.action&&e.action.call(this,e.value,this.valNow))}getStepVals(t){let e;if("string"==typeof t)if("zero"===t)e=this.startVals;else if("completed"===t)e=this.endVals;else if(t.includes("/")){let s=t.split("/"),i=~~s[0]/~~s[1],a=(this.range[1]-this.range[0])*i+this.range[0];e=this.getVals(a)}else e=this.getVals();else"number"==typeof t&&(e=this.getVals(t));return e}async animateTo(t,e={duration:this.options.duration}){return this.destroyed?this:(this.barEl.style.transitionDuration=null,this.obs.paused=!1,this.vals="string"==typeof t?this.getStepVals(t):this.getVals(t),this.options.b4Set&&await this.options.b4Set.call(this,this.vals),this.vals.val!==this.valNow&&(this.setAnim(this.vals.val,e?.duration),super.listen({name:"set",cb:e?.cb,params:[{...this.vals,valNow:this.valNow,barNow:this.barNow}]}),this))}async locateTo(t,e){return this.vals="string"==typeof t?this.getStepVals(t):this.getVals(t),this.options.b4Set&&await this.options.b4Set.call(this,this.vals),this.animFrame&&cancelAnimationFrame(this.animFrame),this.obs.paused=!1,this.valNow=this.vals.val,this.barNow=this.vals.bar,this.numEl&&(this.numEl.innerHTML=this.vals.number),this.barEl.style.transitionDuration="0ms","line"===this.options.type?this.barEl.style.width=this.vals.percent+"%":this.barEl.setAttribute("stroke-dashoffset",this.barNow),this.watchEnds(),this.watchSteps(),super.listen({name:"set",cb:e?.cb,params:[{...this.vals,valNow:this.valNow,barNow:this.barNow}]}),this}restore(t){return this.destroyed||(this.locateTo("restore"),super.listen({name:"restored",cb:t})),this}setCompleted(t){return this.destroyed||(this.locateTo("completed"),t&&t.call(this)),this}setZero(t){return this.destroyed||(this.locateTo("zero"),t&&t.call(this)),this}continue(t,e){return this.destroyed||this.valNow===this.vals.val?this:!!this.obs.paused&&(this.obs.paused=!1,this.setControl(!1,!1),this.setAnim(this.vals.val,t||this.durRest),super.listen({name:"continue",cb:e,params:[{...this.vals,valNow:this.valNow,barNow:this.barNow,durRest:t||this.durRest}]}),this)}pause(t){return this.destroyed||this.valNow===this.vals.val||(this.animFrame&&(cancelAnimationFrame(this.animFrame),this.obs.paused=!0,this.setControl(!0,!1)),super.listen({name:"pause",cb:t,params:[{...this.vals,valNow:this.valNow,barNow:this.barNow}]})),this}get(){return{...this.vals,valNow:this.valNow,barNow:this.barNow,completed:this.obs.completed,paused:this.obs.paused,durRest:this.durRest||0}}destroy(t){return this.destroyed||(this.restore(),this.controlEl.removeEventListener("click",this.toggleCtrl),this.obsIns.ins.destroy(),super.listen({name:"destroyed",cb:t})),this}}class ProgressElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...y.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){if(this.canListen)if("value"===t||"duration"===t){if(!this.connected||!this.ins)return;let t=this.getAttribute("duration"),e=this.getVal(s);t&&(this.ins.options.duration=~~t),0==t?this.ins.locateTo(e):t?this.ins.animateTo(e,{duration:t}):this.ins.animateTo(e)}else super.updateProxy(t,s,y)}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new Progress(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}getVal(t){return 0==t?0:0==~~t?t:parseFloat(t)}}class CalloutElem extends CompBaseComm{resultEl;iconEl;diskEl;cubeEl;imageEl;closeEl;linkEl;maskEl;toolsEl;captEl;contEl;bodyEl;progEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-result",comp:ResultElem},{tag:"ax-progress",comp:ProgressElem}];static custAttrs=["theme","label","icon","disk","cube","image","href","target","rel","feature","autoclose","size",...this.baseAttrs];static boolAttrs=["closable","square","opaque","notable","hidden","result"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,CalloutElem)}getRawData(){this.getRawProps(CalloutElem),this.propsRaw.content=this.getAttribute("content")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.resultEl=createEl("ax-result"),this.iconEl=createEl("i",{[s.alias]:"icon"}),this.diskEl=createEl("i",{[s.alias]:"disk"}),this.cubeEl=createEl("i",{[s.alias]:"cube"}),this.imageEl=createEl("i",{[s.alias]:"image"}),this.closeEl=createEl("span",{[s.alias]:"close"},`<i class="${s.prefix}icon-close"></i>`),this.linkEl=createEl("a",{[s.alias]:"link"},`<i class="${s.prefix}icon-right-up"></i>`),this.maskEl=createEl("a",{[s.alias]:"mask"}),this.toolsEl=createEl("span",{[s.alias]:"tools",class:`${s.prefix}box-tools`}),this.captEl=createEl("div",{[s.alias]:"title"}),this.contEl=createEl("div",{[s.alias]:"content"},this.propsProxy.content),this.bodyEl=createEl("div",{[s.alias]:"body"},this.contEl),this.progEl=createEl("ax-progress",{[s.alias]:"prog",linecap:"square",thk:"xs",theme:"warn",value:"100",label:!1}),this.wrapEl.append(this.bodyEl,this.toolsEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.autoclose&&this.progEl.setAttribute("value",0),this.closeEl.onclick=()=>{this.toggleAttribute("hidden",!0)}}changedMaps={theme:this.changedTheme,label:this.changedLabel,content:this.changedCont,icon:this.changedIcon,disk:this.changedDisk,cube:this.changedDisk,image:this.changedDisk,result:this.changedResult,href:this.changedHref,ref:this.changedRel,target:this.changedRel,closable:this.changedClose,feature:this.changedFeature,hidden:this.changedHidden,autoclose:this.changedAuto};changedTheme(t){this.progEl.setAttribute("theme",t.newVal||"warn")}changedHidden(t){this.propsProxy.hidden?slideUp({el:this,done:()=>{this.listen({name:"hidden"})}}):slideDown({el:this,done:()=>{this.listen({name:"shown"})}})}changedLabel(t){t.newVal?(this.captEl.innerHTML=t.newVal,elState(this.captEl).isVirtual&&this.contEl.insertAdjacentElement("beforebegin",this.captEl)):this.captEl.remove()}changedCont(t){this.contEl.innerHTML=t.newVal||""}changedIcon(t){t.newVal?(this.iconEl.setAttribute("class",t.newVal),elState(this.iconEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.iconEl)):this.iconEl.remove()}changedDisk(t){let e=this[t.name+"El"];t.newVal?(e.innerHTML=`<img src="${t.newVal}"/>`,elState(e).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",e)):e.remove()}changedResult(t){this.propsProxy.result?(elState(this.resultEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.resultEl),this.resultEl.setAttribute("to",this.propsProxy.theme||"warn")):this.resultEl.remove()}changedHref(t){t.newVal?(this.maskEl.setAttribute("href",t.newVal),this.linkEl.setAttribute("href",t.newVal),elState(this.maskEl).isVirtual&&this.wrapEl.appendChild(this.maskEl),elState(this.linkEl).isVirtual&&this.toolsEl.insertAdjacentElement("afterbegin",this.linkEl)):(this.maskEl.remove(),this.linkEl.remove())}changedRel(t){t.newVal?(this.maskEl.setAttribute(t.name,t.newVal),this.linkEl.setAttribute(t.name,t.newVal)):(this.maskEl.removeAttribute(t.name),this.linkEl.removeAttribute(t.name))}changedClose(t){this.propsProxy.closable?this.toolsEl.appendChild(this.closeEl):this.closeEl.remove()}changedFeature(t){"alert"===t.newVal?(this.setAttribute("icon",`${s.prefix}icon-warn-o-f`),this.setAttribute("theme","warn"),this.toggleAttribute("notable",!0)):"note"===t.newVal&&(this.setAttribute("icon",`${s.prefix}icon-info-o-f`),this.setAttribute("theme","info"),this.toggleAttribute("notable",!0))}changedAuto(t){null!==t.newVal?(this.progEl.setAttribute("duration",t.newVal||3e3),elState(this.progEl).isVirtual&&this.wrapEl.appendChild(this.progEl),this.progEl?.ins?.on("zero",(()=>{0===this.progEl.ins.vals.val&&this.toggleAttribute("hidden",!0)})).on("updated",(()=>{this.progEl.ins.vals.val=0})),this.onmouseenter=()=>{this.progEl.ins.pause()},this.onmouseleave=()=>{this.progEl.ins.continue()},this.progEl.setAttribute("value",0)):this.progEl.remove()}}class Message extends ModBaseListen{options={};parentEl;template;shown;static hostType="none";static optMaps=f;static dependencies=[CalloutElem];constructor(t,e=!0){super(),super.ready({options:t,type:Message.hostType,maps:Message.optMaps}),this.parentEl=null,super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.createParent(this.options.placement||"center-top"),this.createSection(),this.shown=!1,elState(this.parentEl).isVirtual&&document.body.appendChild(this.parentEl),super.listen({name:"initiated",cb:t}),this.options.eager&&this.show(),this}createParent=t=>{let e=s.messages.find((e=>e.placement===t));e?this.parentEl=e.el:(this.parentEl=createEl("div",{class:`${s.prefix}message`,placement:t}),this.options.classes&&classes(this.parentEl).add(this.options.classes),s.messages.push({placement:t,el:this.parentEl})),this.options.zIndex&&(this.parentEl.style.zIndex=this.options.zIndex)};createSection(){this.template=`\n        <ax-callout \n            size="lg" \n            opaque \n            hidden\n            ${this.options.notable?"notable":""}\n            ${this.options.iconShow?"result":""}\n            ${this.options.closable?"closable":""}\n            ${this.options.status?'theme="'+(this.options.status||"info")+'"':""}\n            ${this.options.heading?'label="'+(!0===this.options.heading?this.options.lang.heading[this.options.status]:this.options.heading)+'"':""}\n            ${this.options.progress?"":"noprogress"}\n        >\n        ${!0===this.options.content||""===this.options.content?this.options.lang.content[this.options.status]:this.options.content}\n        </ax-callout>\n        `,this.targetEl=tplToEl(this.template)}getCloseBtns(){for(let t of getEls(`[${s.alias}="closebubble"]`,this.targetEl))t.onclick=()=>this.hide()}show(t){return this.destroyed||this.shown||(this.parentEl.appendChild(this.targetEl),this.targetEl.toggleAttribute("hidden",!1),this.getCloseBtns(),this.targetEl.on("hidden",(()=>{this.targetEl.remove(),this.shown=!1,super.listen({name:"hidden"})})),this.targetEl.on("shown",(()=>{this.shown=!0,super.listen({name:"shown"})})),!this.options.manual&&this.targetEl.setAttribute("autoclose",this.options.delay)),this}hide(t){return this.destroyed||!this.shown||this.targetEl.toggleAttribute("hidden",!0),this}updateCont(t,e){return this.destroyed||(this.targetEl.setAttribute("content",t),this.getCloseBtns(),super.listen({name:"updatedCont",cb:e,params:[t]})),this}async update(t,e){return this.destroyed||(this.targetEl.remove(),this.options=extend({target:this.options,source:t}),await this.init(),super.listen({name:"updated",cb:e,params:[t]})),this}destroy(t){return this.destroyed||(this.targetEl.remove(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const combineArr=({origin:t,length:e=2,start:s=0,splice:i=[],result:a=[]})=>{let l=t.length;if(s+e>l)return[];for(let n=s;n<l;n++){if(1===e){a.push([...i,t[n]]),n+1<l&&combineArr({origin:t,length:e,start:n+1,splice:i,result:a});break}combineArr({origin:t,length:e-1,start:n+1,splice:[...i,t[n]],result:a})}return a||[]},sliceFrags=({str:t="",start:e="{",end:s="}",contain:i=!0})=>{let a=new RegExp(`\\${e}([^\\${s}]+)\\${s}`,"g"),l=t.match(a)||[];return!i&&l.length>0?l.map((t=>t.replace(e,"").replace(s,""))):l},toLocalTime=t=>{let e,s,i,a;if(t){if(t=t.trim(),s=new Date(t),i=s instanceof Date&&!isNaN(s.getTime()),!i)throw new Error('Date format must be "YYYY-MM-DD" or "YYYY/MM/DD"!');e=t.replace(/-/g,"/"),a=new Date(e).getTime()}else a=Date.now();return a},w={test:(t,e)=>!isEmpty(t)&&!isEmpty(e)&&("string"==typeof e?new RegExp(e):e).test(t),expired:(t,e)=>{let getTime=t=>"string"==typeof t?toLocalTime(t):t.getTime(),s=getTime(t),i=getDataType(e),a=[-2,-2],compare=(t,e)=>t<e?-1:t===e?0:t>e?1:-2;if(isEmpty(t)||isEmpty(e))return a;if("Array"===i&&2===e.length){let t=e.map((t=>getTime(t))).sort();a[0]=compare(s,t[0]),a[1]=compare(s,t[1])}else{let t=getTime(e);a[0]=compare(s,t)}return a},than:(t,e)=>{let s,i=[-2,-2],a=getDataType(e),l=parseFloat(t),compare=(t,e)=>t<e?-1:t===e?0:t>e?1:-2;return"Array"===a?2===e.length&&(s=e.map((t=>parseFloat(t))).sort(),i[0]=compare(l,s[0]),i[1]=compare(l,s[1])):(s=parseFloat(e),i[0]=compare(l,s)),i},getStrength:(t,e)=>{let s=Object.assign({lowerCase:"[a-z]",upperCase:"[A-Z]",digital:"[0-9]",chars:`[${l.valid.regChars}]`,local:`[${l.lang.valid.regLocal}]`,length:l.valid.lengthStr},e),i=0;if(isEmpty(t)||"string"!=typeof t)return i;for(let e in s)"length"===e?t.trim().length>=s[e]&&i++:s.hasOwnProperty(e)&&s[e]&&t.match(new RegExp(s[e]))&&i++;return i},parseLength:(t,e="",s="")=>{let i="",a="",n={value:e,label:""};if(t){let e=t.replace("{","").replace("}","").split(",").map((t=>~~t));2===e.length?(i=e[1]&&e[1]>e[0]?`{${e[0]},${e[1]}}`:e[1]&&e[1]===e[0]?`{${e[0]}}`:`{${e[0]},}`,a=e[1]?0===e[0]?renderTpl(l.lang.valid["length<="],{...n,data:e[1]}):renderTpl(l.lang.valid["length>=<="],{...n,data:e}):renderTpl(l.lang.valid["length>="],{...n,data:e[0]})):(i=`{${e[0]}}`,a=renderTpl(l.lang.valid["length="],{...n,data:e[0]}))}return{regex:i,text:a}},parseSpecific:function(t,e){t=trim(t,"global");let s="",i=t,a="",n="",r={},o=Object.assign({...l.lang.valid.types},e?.types),h=e?.tpl||l.lang.valid.specific,p={};if(t){let d=sliceFrags({str:t});d.length>0&&(a=d[0],i=t.replace(a,"")),s="^",i.split("&").forEach((t=>{let i=t.split("="),a="";a="a"===i[0]?".*?[a-z]":"A"===i[0]?".*?[A-Z]":"d"===i[0]?".*?[0-9]":"~"===i[0]?`.*?[${e?.regChars||l.valid.regChars}]`:"@"===i[0]?`.*?[${e?.regLocal||l.lang.valid.regLocal}]`:"",s+=a?"(?="+Array(1+(i[1]?~~i[1]:1)).join(a)+")":"",r[o[i[0]]]=i[1]||1})),p={label:e?.label||"",name:e?.name||"",value:e?.value||"",data:r},s+=`.${this.parseLength(a,p.value).regex||"{0,}"}$`,n=renderTpl(h,p)+(a?this.parseLength(a,p.value).text:"")}return{regex:s,text:n}},parseCombine:function(t,e){t=trim(t,"global");let s=e?.regChars||l.valid.regChars,i=e?.regLocal||l.lang.valid.regLocal,a="",n=t,r="",o="",h={types:[],total:0},p=Object.assign({...l.lang.valid.types},e?.types),d=e?.tpl||l.lang.valid.combine,c={};if(t){let l=sliceFrags({str:t});l.length>0&&(r=l[0],n=t.replace(r,""));let u=n.split(":"),g=~~u[1]?~~u[1]:2,m=[];u[0].includes("a")&&(m.push("a-z"),h.types.push(p.a)),u[0].includes("A")&&(m.push("A-Z"),h.types.push(p.A)),u[0].includes("d")&&(m.push("0-9"),h.types.push(p.d)),u[0].includes("~")&&(m.push(s),h.types.push(p["~"])),u[0].includes("@")&&(m.push(i),h.types.push(p["@"])),g=Math.min(g,m.length),1===g?a=`^[${m.join("")}]`:(a+="^",combineArr({origin:m,length:g-1}).forEach((t=>{a+=`(?![${t.join("")}]+$)`})),a+=`[${m.join("")}]`),h.total=g,c={label:e?.label||"",name:e?.name||"",value:e?.value||"",data:h},a+=`${this.parseLength(r,c.value).regex||"{0,}"}$`,o=renderTpl(d,c)+(r?this.parseLength(r,c.value).text:"")}return{regex:a,text:o}},validForm:async({el:t,fail:e,succ:i,intvl:a=100})=>{let n=getEl(t)||document.body,r=s.valids.find((t=>t.parent===n)),o=r?.children||[],h=!0,p=[];return 0!==s.valids.length&&r?(await(async()=>{for(let t=0;t<o.length;t++){let e=o[t];await delay({duration:a*t}).then((async()=>{await e.ins.do().then((t=>{!t.passed&&(h=t.passed,p.push(e))}))}))}})().then((()=>{h?i&&i():e&&e(p)})),{passed:h,fails:p}):(new Message({content:l.lang.valid.message.noValids,iconShow:!0,status:"info"}).show(),{passed:!0,fails:[]})},listenSubmit:async function({item:t,fail:e,succ:i,cb:a}){let l=s.valids,n=(()=>{let e=getDataType(t),s=[];if(isEmpty(t))s=l;else if("Array"===e)s=t;else if(e.includes("HTML"))s=[l.find((e=>e.parent===t))];else if("String"===e){let e=getEl(t);e&&(s=[l.find((t=>t.parent===e))])}else s=[t];return s})().filter((t=>"FORM"===t?.parent?.nodeName)),r={passed:!0,fails:[]};if(n.length>0)for(let t of n)t.parent?.ax?.hasSubmitListener||(t.parent.addEventListener("submit",(s=>{preventDft(s),this.validForm({el:t.parent,fail:s=>{e&&e(t,s)},succ:e=>{i?i(t,e):t.parent.submit()}}).then((e=>{r=e,a&&a(t,e)}))}),!1),storeNode(t.parent).addData("hasSubmitListener",!0));return r},factory:async t=>{let e=t?.text?.succ||l.lang.valid.succ,s=t?.text?.fail||l.lang.valid.fail,i={passed:!0,succ:renderTpl(e,{label:t.label,name:t.name}),fail:renderTpl(s,{label:t.label,name:t.name})};if(0===t.rules.length)return i;try{for(let e in t.rules)if(t.rules.hasOwnProperty(e)){let s=t.rules[e],a={value:t.value,name:t.name,label:t.label,type:e,ins:t.ins,data:t.ins.types[e]},l=await s(a);if("Object"!==getDataType(l))throw new Error("Return value is not a standard object : {passed,succ,fail}!");if(Object.assign(i,l?.content?.hasOwnProperty("passed")?l.content:l),!i.passed)break}}catch(t){i.passed=!1,new Message({status:"info",content:l.lang.valid.message.wrongRule}).show()}return t.cb&&t.cb(i),i}},x={getName:t=>{let e=getEl(t);return["file","select-multiple","checkbox"].includes(e.type)&&!e.name.endsWith("[]")?`${e.name}[]`:e.name},getHosts:t=>{let e=getEl(t);return e?unique([...e.querySelectorAll(`${i.map((t=>"ax-"+t)).join()},input:not([type="submit"],[type="reset"]),select,textarea`)].filter((t=>t.name&&!t.name.includes(s.namePfx)&&!t.hasAttribute(s.embedSign))),"name"):[]},reset:function(t,e=!1){let s=getEl(t),i=this.getHosts(s);if(i.length>0)for(let t of i)E.reset({target:t,parent:s,zero:e})},setVals:function(t,e={}){let s=getEl(t),i=this.getHosts(s);if(parent&&0!==i.length){isEmpty(e)&&this.reset(parent,!0);for(let[t,s]of Object.entries(e)){let e=i.find((e=>e.name===t));e&&E.setVals({target:e,value:s,parent:parent})}}},getVals:function(t,e="array"){let s,i=getEl(t),a="string"===e?"":"json"===e?{}:"formdata"===e?new FormData:[],l=[],n=[];try{if(i){if(l=this.getHosts(i),n=l.map((t=>{let e=E.getVals({target:t,parent:i}),s=t.name+(Array.isArray(e)&&!t.name.endsWith("[]")?"[]":"");return{type:t.type,name:t.name,fullName:s,value:e}})),"string"===e)s="",n.forEach(((t,e)=>{let i=0===e?"":"&";if(Array.isArray(t.value))if(t.value.length>0)for(let e of t.value)s+=i+t.fullName+"="+("File"===getDataType(t)?e.name:e);else s+=i+t.fullName+"=";else s+=i+t.name+"="+("File"===getDataType(t.value)?t.value.name:t.value)}));else if("formdata"===e){s=new FormData;for(let t of n)if(Array.isArray(t.value)){if(t.value.length>0)for(let e of t.value)s.append(t.fullName,e)}else s.append(t.name,t.value)}else if("json"===e){s={};for(let t of n)s[t.name]=t.value}else s=n;return s}return a}catch{return a}},submit:async function(t,e){let i=getEl(t);if(!i)throw new Error("The form node is required!");let a=extend({target:{type:"post",delay:0},source:e}),ajaxSubmit=async()=>{if(!a.url)throw new Error("The request url is required!");let t=getEl(a.button?.selector),e=t?t.innerHTML:"",resume=()=>{i?.classList.remove(`${s.prefix}ajax-mask`),t&&(a?.button?.replace?(t.removeAttribute("inert"),t.innerHTML=e):a?.button?.attr&&t.removeAttribute(a.button.attr.key))};i?.classList.contains(`${s.prefix}ajax-mask`)||await ajax({url:a.url,data:this.getVals(i,"get"===a.type?"string":"formdata"),type:a.type,opened:t=>{a.opened&&a.opened(t)},before:e=>{i?.classList.add(`${s.prefix}ajax-mask`),t&&("loading"===a?.button?.replace?(t.innerHTML=e.content,t.toggleAttribute("inert",!0)):"text"===a.button?.replace?(t.innerHTML=l.lang.ajax.submit.btn,t.toggleAttribute("inert",!0)):a?.button?.attr&&t.setAttribute(a.button.attr.key,a.button.attr.value)),a.before&&a.before(e)},success:t=>{setTimeout((()=>{resume(),a.success&&a.success(t)}),a.delay)},error:t=>{resume(),a.error&&a.error(t)}})},submitForm=async()=>{a.url?ajaxSubmit():"FORM"===i?.nodeName&&i.submit()},awaitValid=async()=>{if(a.valid){await a.valid()&&submitForm()}else submitForm()};s.valids.find((t=>t.parent===i))?await w.validForm({el:i,fail:()=>{a.invalid&&a.invalid()},succ:async()=>{await awaitValid()}}):await awaitValid()}},setContent=({content:t,target:e,position:s="override",engine:i,template:a,prevent:l})=>{let n=getDataType(t),r=getEl(e),o="";if(!isNull(t)){if(n.includes("HTML")||"String"===n||"Number"===n)o=t;else if("Array"===n||"Object"===n){let e=getEl(a),s=e?.innerHTML||a,l=i||renderTpl;if(s&&l)try{o="template"===l.name?l(s)(t):l(s,t)}catch(t){}}if(isEmpty(l)){if(!r)return;getDataType(o).includes("HTML")?"override"===s?(r.innerHTML="",r.appendChild(t)):r.insertAdjacentElement(s,t):"override"===s?r.innerHTML=o:r.insertAdjacentHTML(s,o)}else l(o)}},createEvt=({target:t,name:e,cb:s,options:i})=>{let a=getEl(t);if(!a||!e)return;let l=new CustomEvent(e,Object.assign({cancelable:!0,composed:!1,bubbles:!1},i)),fn=function(t){s.call(this,t)};return s&&a.addEventListener(e,fn),{event:l,remove:()=>{s&&a.removeEventListener(e,fn)}}};class CompBaseCommField extends CompBaseComm{name;value;disabled;readOnly;checked;multiple;events;inputEl;zeroEvt;evtsArr;toolsEl;mediaEl;constructor(){super(),this.focus=()=>{this.inputEl.focus()},this.blur=()=>{this.inputEl.blur()},this.zeroEvt=new Event("input"),this.reset=t=>{for(let t in this.propsRaw)null!==this.propsRaw[t]&&!1!==this.propsRaw[t]?this.setAttribute(t,this.propsRaw[t]):this.removeAttribute(t);this.inputEl&&this.inputEl.dispatchEvent(this.zeroEvt),this.listen({name:"reset",cb:t})},this.clear=t=>{this.inputEl&&(this.inputEl.value="",this.inputEl.dispatchEvent(this.zeroEvt)),this.mediaEl&&(this.mediaEl.innerHTML=""),this.listen({name:"cleared",cb:t})},this.on("connected",(()=>{this.setAttribute(s.compSign,""),this.setCache()})),this.on("reset",(()=>{this.clearCache()}))}static evtsArr=[...this.baseAttrs,"on-cleared","on-changed"];connectedCallback(){if(this.inputEl){this.addEvts(["blur","focus"]);for(let t in this.events)this.inputEl.addEventListener(t,(()=>{this.dispatchEvent(this.events[t].event)}))}this.connectedRender()}addEvts(t){if(this.events={},!isEmpty(t))for(let e of t)this.events[e]=createEvt({target:this,name:e})}getToolsEl(t){isEmpty(t)||(this.toolsEl=createTools(t,null,this),this.toolsEl.setAttribute(s.alias,"tools"))}setFieldProps(t){for(let e of t)"name"===e?this.name=this.propsProxy.name||"":"value"===e?this.value=this.propsProxy.value||"":"disabled"===e?this.disabled=this.propsProxy.disabled||!1:"readOnly"===e?this.readOnly=this.propsProxy.readonly||!1:"multiple"===e?this.multiple=this.propsProxy.multiple||!1:"check"===e&&(this.checked="ed"===this.propsProxy.check)}getItemsData(t){let e=super.getAttrHtmlData(t);return this.formatData(e)}formatData(t){return"string"===typeof t[0]?t.map((t=>({label:t,value:t,disabled:!1,checked:!1}))):t}addScrollable(t){let e=t.scrollHeight>t.clientHeight;this.wrapEl.toggleAttribute("scrollable",e)}setValAttr(t,e){isNull(t.value)?isNull(t.value)&&t.label&&(e.value=t.label):e.value=t.value,this.propsProxy.value=this.value=e.value||t.value}changedMultiDisable(t){let e=getAttrArr(t.newVal);for(let t of this.inputs)e.includes(t.propsProxy.value)?t.setAttribute("disabled",""):t.removeAttribute("disabled")}changedMultiDisabled(t){this.toggleAttribute("disabled",this.propsProxy.disabled),this.disabled=this.propsProxy.disabled}changedMultiName(t){for(let e of this.inputs)t.newVal?e.setAttribute(t.name,t.newVal):e.removeAttribute(t.name);"name"===t.name&&(t.newVal?this.name=t.newVal:this.removeAttribute("name"))}changedMultiCont(t){this.updateInputs(t.newVal)}changedSingleDisabled(t){this.inputEl.toggleAttribute("disabled",this.propsProxy.disabled),this.disabled=this.propsProxy.disabled}changedSingleName(t){t.newVal?this.inputEl.name=t.newVal:this.inputEl.removeAttribute("name"),this.name=this.inputEl.name}changedSingleValue(t){null!==t.newVal||this.propsProxy.label?(this.propsProxy.value=this.value=t.newVal,this.inputEl.value=this.value):(this.propsProxy.value=void 0,this.value="",this.inputEl.removeAttribute("value"))}changedSingleLabel(t){this.labelEl.innerHTML=t.newVal,t.newVal&&isNull(this.propsProxy.value)&&(this.propsProxy.value=this.value=t.newVal,this.inputEl.value=this.value)}changedSingleCheck(t){let e="ed"===t.oldVal;this.checked="ed"===t.newVal,this.inputEl.checked=this.checked,this.listen({name:"check",params:[{value:t.newVal,checked:this.checked}]}),e!==this.checked&&this.listen({name:"changed",params:[{newVal:this.checked,oldVal:!this.checked}]})}changedAttrs(t){t.newVal&&(this.inputEl||this.ins?.inputEl)&&setAttrs(this.inputEl,strToJson(t.newVal))}}class RadioElem extends CompBaseCommField{labelEl;legendEl;check;type;constructor(){super(),this.type="radio-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.clear=()=>{this.removeAttribute("check"),this.listen({name:"cleared"})},this.check=t=>{this.setAttribute("check",t)}}static custAttrs=["size","value","name","type","check","attrs",...this.evtsArr];static boolAttrs=["disabled"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,RadioElem)}getRawData(){this.getRawProps(RadioElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps(),this.setFieldProps(["name","value","disabled","check"])}fillWrap(t){this.wrapEl=createEl("label",{[s.alias]:"wrap"}),this.inputEl=createEl("input",{type:"radio",[s.embedSign]:""}),this.setValAttr(t,this.inputEl),t.name&&(this.inputEl.name=t.name||""),this.legendEl=createEl("u"),this.labelEl=createEl("i","",t.label),this.wrapEl.append(this.inputEl,this.legendEl,this.labelEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.inputEl.addEventListener("change",(t=>{this.setAttribute("check","ed"),getEls(`ax-radio[name=${this.propsProxy.name}]`,this.closest("form")).filter((t=>t!==this)).forEach((t=>{t.setAttribute("check","")}))}),!1)}changedMaps={disabled:this.changedSingleDisabled,name:this.changedSingleName,value:this.changedSingleValue,label:this.changedSingleLabel,check:this.changedSingleCheck,attrs:this.changedAttrs}}class CheckboxElem extends CompBaseCommField{labelEl;legendEl;check;type;constructor(){super(),this.type="checkbox-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.clear=()=>{this.removeAttribute("check"),this.listen({name:"cleared"})},this.check=t=>{this.setAttribute("check",t)}}static custAttrs=["size","value","type","name","check","attrs",...this.evtsArr];static boolAttrs=["disabled"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,CheckboxElem)}getRawData(){[...CheckboxElem.custAttrs,...CheckboxElem.lazyAttrs].forEach((t=>{this.propsRaw[t]=this.getAttribute(t)})),CheckboxElem.boolAttrs.forEach((t=>{this.propsRaw[t]=getAttrBool(this.getAttribute(t))})),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps(),this.setFieldProps(["name","value","disabled","check"])}fillWrap(t){this.wrapEl=createEl("label",{[s.alias]:"wrap"}),this.inputEl=createEl("input",{type:"checkbox",[s.embedSign]:""}),this.setValAttr(t,this.inputEl),t.name&&(this.inputEl.name=t.name||""),this.legendEl=createEl("u"),this.labelEl=createEl("i","",t.label),this.wrapEl.append(this.inputEl,this.legendEl,this.labelEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.inputEl.addEventListener("change",(t=>{let e=t.target.checked?"ed":"";this.setAttribute("check",e)}),!1)}changedMaps={disabled:this.changedSingleDisabled,name:this.changedSingleName,value:this.changedSingleValue,label:this.changedSingleLabel,check:this.changedSingleCheck,lang:this.changedLang,attrs:this.changedAttrs};changedLang(t){if("switch"!==this.propsProxy.type)return;let e=getEl(":scope > u",this.wrapEl);this.propsProxy.lang.on?e.setAttribute("on",this.propsProxy.lang.on):e.removeAttribute("on"),this.propsProxy.lang.off?e.setAttribute("off",this.propsProxy.lang.off):e.removeAttribute("off")}}class BadgeElem extends CompBaseComm{constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["theme","type","shape",...this.baseAttrs];static boolAttrs=["glassy"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,BadgeElem)}getRawData(){this.getRawProps(BadgeElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"},t.label)}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel};changedLabel(t){null===t.newVal?this.wrapEl.innerHTML="":this.wrapEl.innerHTML=t.newVal}}class ModBaseListenCacheBubble extends ModBaseListenCache{bubbleType;positionIns;hoverIns;mainEl;state;footEl;data;submitXhr;contEl;template;wrapEl;bodyEl;headEl;maskEl;clickOutHideEvt;triggerClose;contXhr;triggerShow;wings;cssDur;duration;wrapHeight;leaveTrigger;static hostType="node";static dependencies=[RadioElem,CheckboxElem,BadgeElem];formEl=null;canTrigger=!1;lastShowTime=0;bullets={nodes:[],value:""};setEmpty(){"popup"===this.bubbleType&&(this.positionIns&&this.positionIns.destroy(),this.hoverIns&&this.hoverIns.destroy()),this.mainEl&&this.mainEl.remove(),this.state="hidden"}async hide(t){}handleFooter(){if(this.footEl){let t=this.options.bullet.enable&&["checkboxes","radios","select-single","select-multi"].includes(this.options.bullet.type);this.options.footer.children.forEach((e=>{"confirm"===e.name?e.action?e.action.call(this,e):e?.attrs?.href||(e.el.onclick=async s=>{this.options.b4Confirm&&await this.options.b4Confirm.call(this,e);let i,a=getEl(this.options.autoFill.inputSel)||this.targetEl,l=getEl(this.options.autoFill.childSel,a);if(isCompField(this.options.contType)){let t=["checkbox","radio"].includes(this.options.contType)&&!this.data.checked?"":this.data.value;this.options.autoFill.enable&&a&&this.setTargetVals(t,a,l),!this.options.keepShow&&this.hide(),i=t}else if(t)this.targetEl&&(this.bullets.value=this.getBulletsChecked(),this.setTargetVals(this.bullets.value,this.targetEl,l)),!this.options.keepShow&&this.hide(),i=this.bullets.value;else if("submit"===e.event){if(!this.formEl)throw new Error("Form node is required!");x.submit(this.formEl,{url:e.url,invalid:()=>{this.listen({name:"invalidated"})},valid:()=>(this.listen({name:"validated"}),!0)})}else if("async"===e.event){if(!this.formEl||!e.url)throw new Error("The request url and form node are required!");x.submit(this.formEl,{url:e.url,button:{selector:e.el,attr:{key:"check",value:"ing"}},opened:t=>{this.submitXhr=t.xhr},invalid:()=>{this.listen({name:"invalidated"})},valid:()=>(this.listen({name:"validated"}),!0),success:t=>{this.listen({name:"sended",params:[t.content]})}})}else"prevent"===e.event?preventDft(s):!this.options.keepShow&&this.hide();this.listen({name:"confirmed",cb:e.cb,params:[e,i]})}):"cancel"===e.name?e.action?e.action.call(this,e):e?.attrs?.href||(e.el.onclick=async t=>{this.options.b4Cancel&&await this.options.b4Cancel.call(this,e),"zero"===e.event?this.formEl&&x.reset(this.formEl,!0):"reset"===e.event?this.formEl&&x.reset(this.formEl,!1):"prevent"===e.event?preventDft(t):!this.options.keepShow&&this.hide(),this.listen({name:"canceled",cb:e.cb,params:[e]})}):"close"===e.name?(e.action?e.action.call(this,e):e.el.onclick=()=>{this.hide()},this.listen({name:"closed",cb:e.cb,params:[e]})):"clear"===e.name?e.action?e.action.call(this,e):e.el.onclick=()=>{isCompField(this.options.contType)?E.reset({target:this.data,zero:!0}):t&&this.clearBulletsChecked(),this.listen({name:"cleared",cb:e.cb,params:[e]})}:e.action&&e.action.call(this,e)}))}}getBulletsTpl(){return!this.options.tplStr&&this.options.bullet.enable?b.getBulletsTpl(this.options.bullet):""}handleData(t){let e=t;return this.options.bullet.enable?(Array.isArray(t)&&"string"==typeof t[0]?e=t.map((t=>({label:t}))):"string"!=typeof t||t.includes(`${s.prefix}bullet-body`)||(e=t.split(",").filter(Boolean).map((t=>({label:t})))),e):e}async renderContent(t){if(isEmpty(t),this.data=this.handleData(t),this.options.b4Fill){let t=await this.options.b4Fill.call(this,this.data,this.contEl);t&&(this.data=t)}this.listen({name:"render",params:[this.data]});let e=getDataType(this.data),i=getEl(this.options.tplStr),a=i?.innerHTML||this.options.tplStr||this.getBulletsTpl();e.includes("HTML")&&["image","iframe","audio","video"].includes(this.options.contType)&&(this.options.media.title&&this.data.insertAdjacentHTML("afterbegin",`<div ${s.alias}="title">${this.options.media.title}</div>`),this.options.media.brief&&this.data.insertAdjacentHTML("beforeend",`<div ${s.alias}="brief">${this.options.media.brief}</div>`)),setContent({content:this.data,target:this.contEl,engine:this.options.tplEng,template:a}),this.formEl=this.contEl.querySelector("form"),this.listen({name:"rendered",params:[this.data]})}renderBubble(t="popup"){this.template=renderTpl(this.getTpl(t),this.options),this.mainEl=tplToEl(this.template),this.wrapEl=this.mainEl.querySelector(`.${s.prefix}${t}-wrap`),this.contEl=this.mainEl.querySelector(`.${s.prefix}${t}-cont`),this.bodyEl=this.mainEl.querySelector(`.${s.prefix}${t}-body`),this.headEl=this.mainEl.querySelector(`.${s.prefix}${t}-head`),this.footEl=this.mainEl.querySelector(`.${s.prefix}${t}-foot`),this.maskEl=this.mainEl.querySelector(`.${s.prefix}${t}-mask`),this.options.tools.enable&&createTools(this.options.tools.children,this.wrapEl,this),this.footEl&&("plain"!==this.options.footer.layout&&(this.options.footer.children=this.options.footer.children.map((t=>"confirm"===t?{name:"confirm",attrs:{theme:"prim"}}:"confirm"===t?.name?(t.attrs?!t.attrs.theme&&(t.attrs.theme="prim"):t.attrs={theme:"prim"},t):t))),createFooter(this.options.footer,this.footEl,this))}getTpl(t="popup"){return`\n                            {{let noPadding = (this.padding.enable  && !this.bullet.enable) || (this.padding.enable && this.bullet.enable && this.bullet.cols>0 && this.bullet.lines==='fluid');/}}\n                            <div class="${s.prefix}${t}">\n                                {{ if(this?.mask?.enable){ /}}<div class="${s.prefix}${t}-mask"></div>{{ } /}}\n                                <div class="${s.prefix}${t}-wrap">\n                                    {{ if(this.heading){ /}}\n                                        <div class="${s.prefix}${t}-head">{{ this.heading }}</div>\n                                        {{ } /}}\n                                    {{ if(this.divider){ /}}\n                                        <ax-line></ax-line>\n                                        {{ } /}}\n                                    <div class="${s.prefix}${t}-body">\n                                        {{ if(this.padding.enable){ /}}\n                                            <div class="${s.prefix}${t}-padding {{ this.padding.value || '${s.prefix}p' }} "> \n                                        {{ }else if(noPadding){ /}}\n                                            <div class="${s.prefix}${t}-padding"> \n                                        {{ } /}}\n                                                <div class="${s.prefix}${t}-cont"></div>\n                                        {{ if(noPadding || this.padding.enable){ /}}\n                                            </div>\n                                            {{ } /}}\n                                    </div>\n                                    {{ if((!this.bullet.enable && this.footer.enable) || (this.bullet.enable && ['custom','checkboxes','select-multi'].includes(this.bullet.type) && this.footer.enable)){ /}}\n                                    <div class="${s.prefix}${t}-foot {{ this.footer.layout !=='plain'? this.padding.value || '${s.prefix}p':'' }} "></div>\n                                    {{ } /}}\n                                </div>\n                            </div>\n                            `}initBullets(){if(this.on("show",(()=>{this.options.autoFill.enable&&this.options.autoFill.detectable&&this.presetFromTarget()})),!this.options.bullet.enable)return;if(this.targetEl&&(isNull(this.targetEl.readOnly)?this.targetEl.toggleAttribute("readonly",!0):this.targetEl.readOnly=!0),this.bullets.nodes=b.getChildNodes(this.contEl),this.options.autoFill.enable){let t=this.getTargetVals();b.setChecked(t,this.bullets.nodes)}let t=getEl(this.options.autoFill.childSel,this.targetEl),fill2Hide=()=>{this.targetEl&&(this.bullets.value=this.getBulletsChecked(),this.setTargetVals(this.bullets.value,this.targetEl,t)),this.hide()};for(let[t,e]of this.bullets.nodes.entries())this.options.bullet.type.includes("select")?e.onclick=()=>{b.toggleChecked(e,this.bullets.nodes,this.options.bullet.type),"select-single"===this.options.bullet.type&&fill2Hide()}:"radios"===this.options.bullet.type&&(e.onclick=()=>fill2Hide()),this.options.bullet.action&&this.options.bullet.action.call(this,{el:e,data:Array.isArray(this.data)?this.data[t]:null})}presetFromTarget(){if(!this.options.autoFill.enable)return;let t=this.getTargetVals();if(isCompField(this.options.contType)){let e=this.data?.nodeName&&this.data.nodeName.startsWith("AX-"),s=t===this.data.value;e&&!s&&E.setVals({target:this.data,value:t,key:this.options.autoFill.key})}else t!==this.bullets.value&&b.setChecked(t,this.bullets.nodes)}setBulletsChecked(t){this.options.bullet.enable&&(b.setChecked(t,this.bullets.nodes),this.options.autoFill.enable&&["radios","select-single"].includes(this.options.bullet.type)&&this.setTargetVals(this.getBulletsChecked()),this.listen({name:"bulletsChecked",params:[t]}))}getBulletsChecked(){return this.options.bullet.enable?b.getChecked(this.bullets.nodes):""}toggleBulletsChecked(t,e="select-single"){let s=getEl(t);s&&b.toggleChecked(s,this.bullets.nodes,e)}clearBulletsChecked(){b.clearChecked(this.bullets.nodes)}checkedBulletsAll(){if(!["radios","select-single"].includes(this.options.bullet.type))for(let t of this.bullets.nodes){let e=t.querySelector("AX-CHECKBOX");e?!t.hasAttribute("disabled")&&!e.hasAttribute("disabled")&&e.setAttribute("check","ed"):!t.hasAttribute("disabled")&&t.setAttribute("checked","")}}setBulletsSelected(t){b.setSelected(t,this.bullets.nodes),this.listen({name:"bulletsSelected",params:[t]})}getBulletsSelected(){return b.getSelected(this.bullets.nodes)}clearBulletsSelected(){b.clearSelected(this.bullets.nodes)}toggleBulletsSelected(t){let e=getEl(t);e&&b.toggleSelected(e,this.bullets.nodes)}getTargetVals(){return this.targetEl?E.getVals({target:this.targetEl,child:getEl(this.options.autoFill.childSel,this.targetEl),key:this.options.autoFill.key}):""}setTargetVals(t=this.getBulletsChecked(),e=this.targetEl,s=getEl(this.options.autoFill.childSel,this.targetEl)){e&&(E.setVals({target:e,value:t,child:s,key:this.options.autoFill.key}),this.listen({name:"targetSet",params:[t]}))}getDuration(){let t=1e3*parseFloat(style("popup"===this.bubbleType?this.mainEl:this.wrapEl).animationDuration)||0;this.duration=this.options.duration||(this.options.autoDur?getAutoDur(this.wrapHeight):t)}async reset(t){return this.options=deepClone(this.dftOpts),await this.init(),this.clearCache(),this.listen&&this.listen({name:"reset",cb:t}),this}async update(t,e){if(this.destroyed||isEmpty(t))return this;if(!isEmpty(t)&&(this.updateCache(t),extend({target:this.options,source:t}),"ing"!==this.state)){let t=this.state;await this.init().then((e=>{"shown"===t&&e.show()}))}return this.listen({name:"updated",cb:e,params:[t]}),this}async updateCont(t,e){return this.destroyed||t===this.options.content||await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.contEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:s=>{this.data=this.handleData(s),this.renderContent(s),this.updateCache({content:t}),this.listen({name:"updatedCont",cb:e,params:[s]})}}),this}replaceCont(t,e){if(this.destroyed)return this;getDataType(t).includes("HTML")?(this.contEl.innerHTML="",this.contEl.appendChild(t)):this.contEl.innerHTML=t,this.listen({name:"replacedCont",cb:e,params:[t]})}unbindTrigger(t){}bindTrigger(t){}async transfer(t,e){if(this.destroyed)return this;let s=getEl(t);if(s&&s!==this.targetEl){let t=this.initialized;t?(this.unbindTrigger("host"),this.targetEl=s,this.bindTrigger()):(this.targetEl=s,await this.init()),"popup"===this.bubbleType&&t?this.positionIns.transfer(s,(t=>{this.listen({name:"transferred",cb:e,params:[t]})})):this.listen({name:"transferred",cb:e,params:[s]})}return this}addPulseEvt(){}removePulseEvt(){}destroy(t){return this.destroyed||(this.mainEl.remove(),"popup"===this.bubbleType&&(this.positionIns&&this.positionIns.destroy(),this.hoverIns&&this.hoverIns.destroy(),this.clickOutHideEvt&&document.removeEventListener("click",this.clickOutHideEvt)),"click"!==this.options.trigger&&"input"!==this.options.trigger||(this.targetEl.removeEventListener(this.options.trigger,this.triggerShow),this.wings.forEach((t=>{t.removeEventListener(this.options.wing.trigger||this.options.trigger,this.triggerShow)}))),this.maskEl&&this.options.mask.closable&&this.maskEl.removeEventListener("click",this.triggerShow),this.contEl.querySelectorAll(`[${s.alias}="closebubble"]`).forEach((t=>{t.removeEventListener("click",this.triggerClose)})),"dialog"===this.bubbleType&&["confirm","alert"].includes(this.options.feature)&&(this.removePulseEvt(),this.addPulseEvt()),this.canTrigger=!1,this.contXhr&&this.contXhr.abort(),this.submitXhr&&this.submitXhr.abort(),this.leaveTrigger&&this.leaveTrigger.cancel(),this.destroyed=!0,this.listen({name:"destroyed",cb:t})),this}}class Drawer extends ModBaseListenCacheBubble{options={};parentEl;sizeProp;lastSize;lastPlace;bubbleType;timestamp;lastShowTime;confirmEl;cancelEl;closeEl;triggerShow;content;wrapSize;sequenceShow;sequenceHide;sequenceToggle;static optMaps=c;constructor(t,e={},s=!0){super(),super.ready({options:e,host:t,maps:Drawer.optMaps,component:!0,spread:["mask","tools","padding","footer","autoFill","bullet"]}),this.bubbleType="drawer",this.timestamp=Date.now(),this.lastShowTime=0;let i=this;this.triggerShow=function(t){if(this===i.targetEl&&i.options.canClick){let e=getEvtTarget(t);if(!i.options.canClick.call(i,e,t))return}"hidden"===i.state?(i.show(),i.options.wing.actClass&&i.wings.includes(this)&&this.classList.add(i.options.wing.actClass)):"shown"===i.state&&!i.options.keepShow&&i.hide()},this.triggerClose=()=>{!this.options.keepShow&&this.hide()},this.sequenceToggle=()=>{this.mainEl.toggleAttribute("show",!0);for(let t of this.getToggleItems())t.ins.hide()},this.sequenceShow=(t,e)=>{let s=t.style[e]?.6*parseInt(t.style[e])+parseInt(this.options.offset)+"px":this.options.offset;t.style[e]=s},this.sequenceHide=(t,e)=>{t.style[e]==this.options.offset?t.style.cssText=t.style.cssText.replace(e,""):t.style[e]=(parseInt(t.style[e])-parseInt(this.options.offset))/.6+"px"},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.options.placement=this.options.placement||"right",this.parentEl=getEl(this.options.parent)||document.body,this.sizeProp="left"===this.options.placement||"right"===this.options.placement?"width":"height",this.wings=getEls(this.options.wing.selector),this.renderBubble("drawer"),this.setAttrs(),await getContent.call(this,{content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.contEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:t=>{this.renderContent(t)}}),this.lastPlace="",this.handleFooter(),this.handleTools(),this.bindTrigger(),this.contEl.querySelectorAll(`[${s.alias}="closebubble"]`).forEach((t=>{t.removeEventListener("click",this.triggerClose),t.addEventListener("click",this.triggerClose,!1)})),this.initBullets(),super.listen({name:"initiated",cb:t}),this}handleTools(){this.options.tools.enable&&this.options.tools.children.forEach((t=>{"close"===t.name?t.wrapEl.onclick=()=>this.hide():["widen","heighten","enlarge"].includes(t.name)?t.wrapEl.onclick=()=>{"max"===this.lastSize?(classes(t.iconEl).replace(t.icon,t.swap),this.mainEl.setAttribute("size",this.options.size),this.lastSize=this.options.size):(classes(t.iconEl).replace(t.swap,t.icon),this.mainEl.setAttribute("size","max"),this.lastSize="max")}:t.action&&t.action.call(this,t)}))}setAttrs(){if(this.options.classes&&classes(this.mainEl).add(this.options.classes),this.options.size?this.mainEl.setAttribute("size",this.options.size):this.mainEl.removeAttribute("size"),this.options.contType?this.mainEl.setAttribute("conttype",this.options.contType):this.mainEl.removeAttribute("conttype"),this.contEl.toggleAttribute("dedicated",this.options.dedicated),this.options.placement?this.mainEl.setAttribute("placement",this.options.placement):this.mainEl.removeAttribute("placement",this.options.placement),this.options.zIndex?addStyle(this.mainEl,"z-index",this.options.zIndex):removeStyle(this.mainEl,"z-index"),this.parentEl!==document.body){let t=style(this.parentEl);"static"===t.position&&addStyle(this.parentEl,"position","relative"),"hidden"!==t.overflow&&addStyle(this.parentEl,"overflow","hidden"),this.mainEl.toggleAttribute("restrict",!0)}else this.mainEl.removeAttribute("restrict")}getBeforeItems(){return h.data.filter((t=>t.ins!==this&&"drawer"===t.type&&!t.ins.destroyed&&"shown"===t.ins.state&&t.ins.parentEl===this.parentEl&&t.ins.options.placement===this.options.placement&&t.ins.lastShowTime<this.lastShowTime))}getToggleItems(){return h.data.filter((t=>t.ins!==this&&"drawer"===t.type&&!t.ins.destroyed&&"shown"===t.ins.state&&t.ins.parentEl===this.parentEl))}getIngItems(){return h.data.filter((t=>t.ins!==this&&"drawer"===t.type&&!t.ins.destroyed&&"ing"===t.ins.state&&t.ins.parentEl===this.parentEl&&t.ins.options.placement===this.options.placement))}bindTrigger(){"click"===this.options.trigger?(this.targetEl&&!this.canTrigger&&(this.targetEl.removeEventListener("click",this.triggerShow),this.targetEl.addEventListener("click",this.triggerShow,!1)),this.wings.length>0&&!this.canTrigger&&this.wings.forEach((t=>{t.removeEventListener("click",this.triggerShow),t.addEventListener("click",this.triggerShow,!1)}))):"sticky"===this.options.trigger&&this.show(),this.maskEl&&this.options.mask.closable&&(this.maskEl.removeEventListener("click",this.triggerShow),this.maskEl.addEventListener("click",this.triggerShow,!1)),this.canTrigger=!0}unbindTrigger(t="host"){this.canTrigger=!1,"click"===this.options.trigger&&(this.targetEl.removeEventListener("click",this.triggerShow),this.wings.length>0&&"all"===t&&this.wings.forEach((t=>{t.removeEventListener("click",this.triggerShow)}))),this.maskEl&&this.options.mask.closable&&"all"===t&&this.maskEl.removeEventListener("click",this.triggerShow)}async show(t){if(!this.destroyed&&"hidden"===this.state&&!this.options.asleep)return this.options.multiple&&this.getIngItems().length||(this.state="ing",this.options.b4Show&&await this.options.b4Show.call(this),elState(this.mainEl).isVirtual&&this.parentEl.appendChild(this.mainEl),super.listen({name:"show",cb:t}),this.wrapSize=parseInt(style(this.wrapEl)[this.sizeProp]),requestAnimationFrame((async()=>{if(super.getDuration(),this.wrapEl.style.transitionDuration=`${this.duration}ms`,this.targetEl&&this.targetEl.classList.add(this.options.actClass),this.lastShowTime=Date.now(),this.options.multiple)for(let t of this.getBeforeItems())this.sequenceShow(t.ins.wrapEl,this.options.placement);else this.sequenceToggle();this.mainEl.toggleAttribute("show",!0),await delay({duration:this.duration,done:()=>{this.state="shown",super.listen({name:"shown",cb:t})}})}))),this}async hide(t){if(this.destroyed||"shown"!==this.state)return this;if(this.options.multiple&&this.getIngItems().length)return this;if(this.state="ing",!this.options.deadShow){this.options.b4Hide&&await this.options.b4Hide.call(this),super.listen({name:"hide",cb:t}),this.targetEl&&this.targetEl.classList.remove(this.options.actClass),this.options.wing.actClass&&this.wings.map((t=>{t.classList.remove(this.options.wing.actClass)})),this.maskEl&&(this.maskEl.style.opacity=0),this.wrapEl.style[this.options.placement]="-"+style(this.wrapEl)[this.sizeProp];for(let t of this.getBeforeItems())this.sequenceHide(t.ins.wrapEl,this.options.placement);for(let t of getEls("video,audio",this.mainEl))t.pause();await delay({duration:this.duration,done:()=>{this.state="hidden",this.mainEl.removeAttribute("show"),this.maskEl&&this.maskEl.removeAttribute("style"),this.wrapEl.removeAttribute("style"),this.mainEl.remove(),super.listen({name:"hidden",cb:t})}})}return this}}const privacy=({content:t=l.lang.privacy.content,contType:e,contData:s,cb:i})=>{u.get("AXUI_GOT_PRIVACY")||new Drawer(void 0,{content:t,contType:e,contData:s,footer:{children:[{name:"canceled",label:l.lang.privacy.cancel},{name:"confirmed",label:l.lang.privacy.confirm}]},onConfirmed:()=>{u.set("AXUI_GOT_PRIVACY",!0),i&&i()}}).show()},support=(t=!1,e)=>{try{createEl("div").querySelector(":has")}catch(s){return t&&!u.get("AXUI_GOT_SUPPORT")&&new Drawer(void 0,{content:l.lang.support.content,footer:{children:[{name:"canceled",label:l.lang.support.cancel},{name:"confirmed",label:l.lang.support.confirm}]},onConfirmed:()=>{u.set("AXUI_GOT_SUPPORT",!0),e&&e()}}).show(),!1}return!0},getSelectorType=t=>{requireTypes(t,"string"),t=t.trim();let e="";return t&&(e=t.includes(" ")?"nesting":t.startsWith("#")?"id":t.startsWith(".")?"class":t.startsWith("[")&&t.endsWith("]")?"attr":[...t].every((t=>{return(e=t)>="A"&&e<="Z";var e}))?"node":""),e},purifyHtml=t=>trim(t.replace(/<[^>]+>/g,"")),offset=t=>{let e,s,i=document.documentElement.scrollLeft||document.body.scrollLeft,a=document.documentElement.scrollTop||document.body.scrollTop,l=getEl(t);if(!l)throw new Error("The target node does not exist!");return e=l.getBoundingClientRect().left+i,s=l.getBoundingClientRect().top+a,{left:e,top:s}},tplToEls=t=>{if(!(t=t.trim().replaceAll("&lt;","<").replaceAll("&gt;",">")))return[];let e,s=createEl("TEMPLATE","",t),i=s.content.cloneNode(!0),a=i.firstElementChild;if(!a)return[];if("TR"===a.nodeName){let t=[...i.querySelectorAll("TR")],a=s.innerHTML.split("</tr>").map((t=>t.replace(/<\/?tr[^>]*>/g,"")));a.shift(),t.forEach(((t,e)=>{t.innerHTML=a[e]})),e=t}else e=[...i.children];return e},getWidths=t=>{let e=getEl(t);if(!e)throw new Error("The target node does not exist!");let s=style(e);return{width:parseInt(s.width),paddingLeft:parseInt(s.paddingLeft),paddingRight:parseInt(s.paddingRight),marginLeft:parseInt(s.marginLeft),marginRight:parseInt(s.marginRight),borderLeftWidth:parseInt(s.borderLeftWidth),borderRightWidth:parseInt(s.borderRightWidth)}},getElSpace=(t,e="y")=>{let s,i=getEl(t);return i?"x"===e?(s=getWidths(i),i.offsetWidth+s.marginLeft+s.marginRight):(s=getHeights(i),i.offsetHeight+s.marginTop+s.marginBottom):0};let slideToggle=({el:t,display:e="block",before:s,doing:i,done:a,duration:l,curve:n="easeOut",cut:r=!0})=>{let o=getEl(t);if(!o)throw new Error("The target node does not exist!");return elState(o).isHidden?slideDown({el:o,display:e,duration:l,curve:n,cut:r,before:s,doing:i?.down,done:a?.down}):elState(o).isCalc&&slideUp({el:o,display:e,duration:l,curve:n,cut:r,before:s,doing:i?.up,done:a?.up}),o},easeHeight=({el:t,height:e,type:s="down",doing:i,done:a,duration:l,curve:n="easeOut",cut:r=!0,unaware:o=!0})=>{let h=getEl(t);if(!h)throw new Error("The target node does not exist!");if(!o||o&&elState(h).isCalc){let t,o=~~e,p=o&&0!==e?o:t=getHeights(h).height,d=~~l&&0!==l?~~l:getAutoDur(p),c=`${h.style.cssText} ${r?"overflow:hidden;":""};`,u={},g={};h.style.cssText=`${c}`,"to"===s&&o?(u={height:isNull(t)?t:getHeights(h).height},g={height:o}):"up"===s?(u={height:p},g={height:0}):(u={height:0},g={height:p}),ease({from:u,to:g,duration:d,curve:n,doing:t=>{h.style.cssText=`\n                ${c}\n                height: ${t.value.height}px\n                `,i&&i.call(h,{frame:t.frame,value:t.value.height,step:t.step})},done:t=>{a&&a.call(h,{frame:t.frame,value:t.value.height,step:t.step})}})}return h},fadeIn=({el:t,display:e="block",doing:s,done:i,duration:a=200,curve:l="easeOut"})=>{let n=getEl(t);if(!n)throw new Error("The target node does not exist!");let r=elState(n),o=parseFloat(style(n).opacity),h={opacity:0};return 1===o||(r.isHidden?(h.opacity=0,n.style.display=e,n.style.opacity=0):r.isCalc&&1!==o&&(h.opacity=o),ease({from:h,to:{opacity:1},duration:a,curve:l,doing:t=>{n.style.opacity=t.value.opacity,s&&s.call(n,{frame:t.frame,value:t.value.opacity,step:t.step,target:n,for:"show"})},done:t=>{n.style.opacity=1,i&&i.call(n,{frame:t.frame,value:t.value.opacity,step:t.step,target:n,for:"show"})}})),n},fadeOut=({el:t,display:e,doing:s,done:i,duration:a=200,curve:l="easeOut"})=>{let n=getEl(t);if(!n)throw new Error("The target node does not exist!");let r=parseFloat(style(n).opacity);return 0===r||(e&&(n.style.display=e),elState(n).isCalc&&ease({from:{opacity:r},to:{opacity:0},duration:a,curve:l,doing:t=>{n.style.opacity=t.value.opacity,s&&s.call(n,{frame:t.frame,value:t.value.opacity,step:t.step,target:n,for:"hide"})},done:t=>{n.style.opacity=0,i&&i.call(n,{frame:t.frame,value:t.value.opacity,step:t.step,target:n,for:"hide"})}})),n},fadeToggle=({el:t,display:e="block",doing:s,done:i,duration:a=200,curve:l="easeOut"})=>{let n=getEl(t);if(!n)throw new Error("The target node does not exist!");let r=elState(n),o=parseFloat(style(n).opacity);return r.isHidden?fadeIn({el:n,display:e,duration:a,curve:l,doing:s?.in,done:i?.in}):r.isCalc&&(o<=.5?fadeIn({el:n,display:e,duration:a,curve:l,doing:s?.in,done:i?.in}):fadeOut({el:n,display:e,duration:a,curve:l,doing:s?.out,done:i?.out})),n},show=({el:t,display:e="block",done:s})=>{let i=getEl(t);if(!i)throw new Error("The target node does not exist!");return"visible"==e?i.style.visibility="visible":i.style.display=e,s&&s.call(i,{target:i,for:"show"}),i},hide=({el:t,display:e="none",done:s})=>{let i=getEl(t);if(!i)throw new Error("The target node does not exist!");return"hidden"===e?i.style.visibility="hidden":i.style.display="none",s&&s.call(i,{target:i,for:"hide"}),i},toggle=({el:t,display:e={show:"block",hide:"none"},done:s})=>{let i=getEl(t);if(!i)throw new Error("The target node does not exist!");return elState(i).isVisible?hide({el:i,display:e.hide,done:s?.hide}):show({el:i,display:e.show,done:s?.show}),i};const A={email:/^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\.[a-zA-Z0-9_-])+/,ip:/^\d+\.\d+\.\d+\.\d+$/,url:/^(?=^.{3,255}$)(http(s)?:\/\/)?(www\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\d+)*(\/\w+\.\w+)*$/,locale:/^[\u0391-\uFFE5]+$/,letter:/^[a-zA-Z]+$/,string:/^[a-zA-Z0-9]+$/,password:`^[a-zA-Z0-9${s.config.valid.regChars}]+$`,ymdhms:/^(\d{4})(-|\/)(\d{1,2})\2(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})$/,ymd:/^(\d{4})(-|\/)(\d{1,2})\2(\d{1,2})$/,hms:/^((20|21|22|23|[0-1]\d)\:[0-5][0-9])(\:[0-5][0-9])?$/,ym:/^(\d{4})(-|\/)(\d{1,2})$/,y:/^(\d{4})$/,m:/^(0?[1-9]|1[0-2])$/,d:/^((0?[1-9])|((1|2)[0-9])|30|31)$/,integer:/^[1-9]\d*$/,number:/^(-?\d+)\.?(\d*)$/,cellphone:/^[1][3456789][0-9]{9}$/,landline:/^([0-9]{3,4}-)?[0-9]{7,8}$/,plate:{nev:/^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}(([0-9]{5}[DF]$)|([DF][A-HJ-NP-Z0-9][0-9]{4}$))/,oil:/^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9挂学警港澳]{1}$/},id:/^(([1][1-5])|([2][1-3])|([3][1-7])|([4][1-6])|([5][0-4])|([6][1-5])|([7][1])|([8][1-2]))\d{4}(([1][9]\d{2})|([2]\d{3}))(([0][1-9])|([1][0-2]))(([0][1-9])|([1-2][0-9])|([3][0-1]))\d{3}[0-9xX]$/,zip:/^\d{6}$/},replaceFrag=({origin:t,text:e,start:s,stop:i,length:a})=>{"string"!=typeof t&&(t=JSON.stringify(t)),"string"!=typeof e&&(e=JSON.stringify(e));let l="";return l=void 0===s&&void 0===i?e:void 0!==s&&void 0===i?void 0!==a?t.substring(0,s)+e+t.substring(s+a):t.substring(0,s)+e:void 0===s&&void 0!==i?void 0!==a?t.substring(i-a)+e+t.substring(0,s):e+t.substring(i):t.substring(0,s)+e+t.substring(i),l},paramToJson=t=>{let e;if(t){t=t.trim();let s=sliceFrags({str:t}).join("")+sliceFrags({str:t,start:"[",end:"]"}).join(""),i=t.split(",").filter(Boolean).map((t=>t.includes(":")||s.includes(t)?t:`${t}:true`)).join(",");try{e=parseStr({content:`{${i}}`,type:"object",catchable:!0})}catch{e={}}}return e},getLast=t=>{let e=getDataType(t),s=null;return"Array"===e&&t.length>0?s=t.slice(-1)[0]:"Object"===e&&Object.keys(t).length>0&&(s=Object.keys(t).slice(-1)[0]),s},isSubset=(t,e)=>Array.isArray(t)?t.length<=e.length&&t.every((t=>e.includes(t))):e.includes(t),stdParam=(t,e={},s)=>{let i="Object"===getDataType(e)?{...e}:{};return"Object"===getDataType(t)?extend({target:i,source:t}):s&&!isNull(t)&&Reflect.set(i,s,t),i},throttle=(t,e)=>{let s=stdParam(e,{intvl:l.throttle,prevent:!1},"intvl"),i=0,a=null,handler=function(e){let l=Date.now();l-i>s.intvl?(a&&(clearTimeout(a),a=null),t.apply(this,arguments),i=l):s.prevent&&(e.stopPropagation(),e.preventDefault())};return handler.cancel=()=>(clearTimeout(a),a=null,handler),handler},debounce=(t,e)=>{let i=stdParam(e,{delay:l.debounce,prevent:!1,auto:!1},"delay");if(s.isTouchScr&&i.auto)return throttle(t,{intvl:i.delay,prevent:i.prevent});{let e=null,handler=function(s){i.prevent&&(s.stopPropagation(),s.preventDefault()),e&&clearTimeout(e),i.instant&&i.instant(),e=setTimeout((()=>{t.apply(this,arguments)}),i.delay)};return handler.cancel=()=>(e&&clearTimeout(e),handler),handler}},convertByte=({val:t,to:e="",places:s=2,outer:i="span",inner:a="i",units:l=["B","KB","MB","GB","TB","PB"]})=>{let n=["B","KB","MB","GB","TB","PB"],r="",o=0,h=(t=clampVal({val:t,min:0,max:""}))/1024;var p;return o=n.includes(e)?n.findIndex((t=>t===e)):h>=1024**4?5:h>=1024**3?4:h>=1048576?3:h>=1024?2:h>=1?1:0,t=0===(p=o)?t:toNumber(t/1024**p,{places:s}),r=l[o],{val:t,unit:r,str:`<${i}><${a}>${t}</${a}>${r}</${i}>`}},T={download:(t,e)=>{let s=new XMLHttpRequest;s.open("GET",t,!0),s.responseType="blob",s.onload=function(){let t=window.URL.createObjectURL(s.response),i=createEl("a");i.src=t||"javascript:void(0);",i.download=e||l.lang.placeholder.downloadName+Date.now(),i.click()},s.send()},getBase64:(t,e)=>new Promise(((s,i)=>{try{let i=new FileReader;i.readAsDataURL(t),i.onload=t=>{e&&e(t?.target?.result),s(t?.target?.result)}}catch(t){i(t)}})),getSuffix:t=>t.name.includes(".")?t.name.split(".").pop():"",getFileName:t=>{try{return t.split("/").pop()?.trim()||""}catch{return""}},urlToFile:function(t,e="",s){return e=e||this.getFileName(t)||l.lang.placeholder.fileName+Date.now(),new Promise(((i,a)=>{ajax({url:t,respType:"blob",type:"get",error:t=>{a(t.content)},success:t=>{let a=new File([t.content],e,{type:t.content.type});s&&s(a),i(a)}})}))}},increaseId=(t,e=!0)=>{let s=new Set,i=0;if(!t.length)return i;if(e){for(let e of t)s.add(~~e.id);i=Math.max(...s)+1}else i=t.length;return i},findItem=(t,e,s,i)=>{let a=getDataType(t);if(!e)return t;let l,n=e[0],r=n?.id,o=getDataType(r);if(isNull(r)&&"Number"===a)l=e[t];else if(s)l=e.find((e=>e[s]===t));else if(a.includes("HTML")){let hasPrio=e=>!!i?.node&&e[i.node]===t,condition=e=>hasPrio(e)||e.headEl===t||e.wrapEl===t;l=e.find((t=>condition(t)))}else{let s="Number"===a?i?.number||"id":"String"===a?i?.string||("String"===o?"id":"label"):"";l="Object"===a?e.find((e=>e===t)):s?e.find((e=>e[s]===t||e[i?.guard||"value"]===t)):void 0}return l},splice=({host:t=[],source:e,intent:s="end+",index:i=0,cb:a})=>{if(isNull(t)||!Array.isArray(t))return[];let l=void 0!==e?Array.isArray(e)?e:[e]:null,n=Array.isArray(l)?l:[l],r=isNull(i)?0:clampVal({min:0,max:t.length-1,val:i}),o=[];if("clear"===s)o=[...t],t.splice(0);else if("add"===s){if(!l)return t;let e=r>=t.length?t.length-1:r;t.splice(e,0,...n),o=t.slice(e,e+n.length)}else if("remove"===s){let s=void 0!==e?t.indexOf(e):r;if(s<0)return t;o=t.slice(s,s+1),t.splice(s,1)}else if("replace"===s){if(!l)return t;t.splice(r,1,...n),o=t.slice(r,r+n.length)}else if("start-"===s)o=t.slice(0,1),t.shift();else if("end-"===s)o=t.slice(-1),t.pop();else if("start+"===s){if(!l)return t;t.unshift(...n),o=t.slice(0,n.length)}else{if(!l)return t;t.push(...n),o=t.slice(-n.length)}return a&&a(o),t},dl2Tree=t=>{let e=getEl(t),s=[];if(!e)return s;let i=[...e.querySelectorAll("dt")],a=[...e.querySelectorAll("dd")];return i.length!==a.length||0===i.length||(s=i.map(((t,e)=>({content:a[e].innerHTML,...getValsFromAttrs(t)})))),s},attrValBool=t=>![!1,0,null,void 0,"false","0"].includes(t),S={find:function(t,e,s){let i=findItem(t,e,s);if(i)return i;for(let i of t)i.children&&this.find(i.children,e,s);return null},getBoolItems:(t,e,s=!1)=>t.filter((t=>{let i=attrValBool(t[e]);return s?!i:i})),toFlat:function(t){let e=[];return t.forEach((s=>{s.children&&!t.includes(s.children[0])?e=[...e,s,...this.toFlat(s.children)]:e.push(s)})),e},toTree:t=>{if(!t||0===t.length||!t[0].hasOwnProperty("pId"))return t;let e=t[0].pId;return t.forEach((e=>{let s=t.filter((t=>e.id==t.pId));s.length&&(e.children=s)})),t.filter((t=>t.pId==e))},addIdPath:({source:t,rootStart:e=l.rootStart,idStart:s=l.idStart,floorStart:i=l.floorStart,pathHyphen:a=l.pathHyphen,lbl2Val:n=!0})=>{if(!Array.isArray(t)||0===t.length||t[0].hasOwnProperty("path"))return t;let r=!!t[0].hasOwnProperty("id"),o=s,each=(t,s,i=e)=>{t.forEach((t=>{r||(t.id=o,o++),t.floor=s,t.pId=t.pId||0===t.pId?t.pId:e,t.path=i+a+t.id,!t.hasOwnProperty("value")&&t.hasOwnProperty("label")&&n&&(t.value=t.label),t.children&&t.children.length>0&&(t.children.forEach((e=>{e.pId=t.id})),each(t.children,s+1,t.path)),t.path||(t.path=t.pId+a+t.id)}))};return each(t,i),t},fromInput:(t,e=l.splitHyphen)=>{let s=getEl(t);return s&&s.value.trim()?s.value.trim().split(e).map((t=>({label:t,value:t}))):[]},createBranchObj:function({source:t,flatData:e,target:s,isChild:i=!0,isLeaf:a=!0,rootStart:n=l.rootStart,idStart:r=l.idStart,floorStart:o=l.floorStart,pathHyphen:h=l.pathHyphen}){let p={},d=findItem(s,e),c=0===e.length,u=getDataType(t),setIdLabelVal=(t,e)=>{!t.hasOwnProperty("id")&&(t.id=e),!t.hasOwnProperty("value")&&(t.hasOwnProperty("label")?t.value=t.label:t.value=""),!t.hasOwnProperty("label")&&(t.label=l.lang.tree.label+e)},setRootChild=(t,e)=>{let s={pId:n,path:n+h+e,floor:o};setIdLabelVal(t,e),Object.assign(t,s)};if(isNull(e))return p;if("String"===u||"Number"===u?p.value=p.label=t:"Object"===u&&(p={...t}),c)setRootChild(p,r);else{let t=increaseId(e);if(d){!d.hasOwnProperty("children")&&i&&(d.children=[]);let e={};setIdLabelVal(p,t),e=i?{pId:d.id,path:d.path+h+p.id,floor:d.floor+1}:{pId:d.pId,path:d.path.replace(new RegExp("(.*)"+d.id),"$1"+p.id),floor:d.floor},Object.assign(p,e)}else p.hasOwnProperty("id")&&(t=p.id),setRootChild(p,t)}return!a&&(p.children=[]),p},childToParent:(t,e=!0)=>{t.children&&(t.childrenEl||(t.childrenEl=createEl("ul"),t.headEl.insertAdjacentElement("afterEnd",t.childrenEl)),t.arrowEl||(t.arrowEl=createEl("i",{[s.alias]:"arrow"}),t.headEl.insertAdjacentElement(e?"beforeEnd":"afterBegin",t.arrowEl)))},parentToChild:t=>{t.children||(t.target.childrenEl.remove(),t.target.childrenEl=null,t.target.arrowEl.remove(),t.target.arrowEl=null,t.target.expanded=!1)},addBranch:function({source:t,rootEl:e,flatData:s,treeData:i,brother:a,isFront:l=!0,repeat:n=!0,autoFill:r=!0,cb:o}){if(!s||!t)return;let h,p=s.find((e=>e.pId===t.pId&&e.label===t.label)),d=findItem(a,s),c=findItem(t.pId,s);if(n||!p){if(c)if(d&&c.children.includes(d)){let e=s.indexOf(d);l?(splice({host:c.children,source:t,index:e,intent:"add",cb:t=>h=t[0]}),r&&d.wrapEl.insertAdjacentElement("beforeBegin",t.wrapEl)):(splice({host:c.children,source:t,index:e+1,intent:"add",cb:t=>h=t[0]}),r&&d.wrapEl.insertAdjacentElement("afterEnd",t.wrapEl))}else l?(splice({host:c.children,source:t,intent:"start+",cb:t=>h=t[0]}),r&&c.childrenEl.insertAdjacentElement("afterBegin",t.wrapEl)):(splice({host:c.children,source:t,intent:"end+",cb:t=>h=t[0]}),r&&c.childrenEl.insertAdjacentElement("beforeEnd",t.wrapEl));else if(d&&d.pId===t.pId){let e=i.indexOf(d);l?(splice({host:i,source:t,index:e,intent:"add",cb:t=>h=t[0]}),r&&d.wrapEl.insertAdjacentElement("beforeBegin",t.wrapEl)):(splice({host:i,source:t,index:e+1,intent:"add",cb:t=>h=t[0]}),r&&d.wrapEl.insertAdjacentElement("afterEnd",t.wrapEl))}else{if(!e)return;l?(splice({host:i,source:t,intent:"start+",cb:t=>h=t[0]}),r&&e.insertAdjacentElement("afterBegin",t.wrapEl)):(splice({host:i,source:t,intent:"end+",cb:t=>h=t[0]}),r&&e.insertAdjacentElement("beforeEnd",t.wrapEl))}o&&o(h,i)}},removeBranch:function({source:t,flatData:e,treeData:s,cb:i}){if(isNull(t)||!e||0===e.length)return;let a=findItem(t,e),l=s[0].floor;if(a){if(a.floor===l)splice({host:s,source:a,intent:"remove"});else{let t=findItem(a.pId,e);if(!t)return;let s=t.children;splice({host:s,source:a,intent:"remove"}),0===s.length&&this.parentToChild(t)}a?.wrapEl&&a.wrapEl.remove(),i&&i(a)}},getParentsFromPath({path:t,flatData:e,labelHyphen:s=l.labelHyphen,field:i="label",pathHyphen:a=l.pathHyphen,shift:n=!1,pop:r=!1}){let o=t.split(a).map((t=>e.find((e=>e.id.toString()==t)))).filter(Boolean),h="";return n&&o.shift(),r&&o.pop(),h=o.map((t=>t[i])).join(s),{parents:o,text:h}},allToTree:async function({content:t,idStart:e=l.idStart,rootStart:s=l.rootStart,floorStart:i=l.rootStart,pathHyphen:a=l.pathHyphen,splitHyphen:n=l.splitHyphen,contType:r="",contData:o={},ajax:h={},fill:p=!0,ins:d,nodeType:c="tree",cb:u}){if(isEmpty(t))return[];let g=[],m=[],getFromNode=t=>{let e=t.nodeName,s=[];return"SELECT"===e||"DATALIST"===e?s=select2Tree(t):"UL"===e||"OL"===e?s=ul2Tree(t,c):"DL"===e?s=dl2Tree(t):"SCRIPT"===e&&"content"===t.getAttribute("type")?s=this.toTree(parseStr({content:t.textContent,type:"array",error:t=>{}})):"INPUT"===e&&(s=this.fromInput(t,n)),s},getFromArray=t=>{let e=deepClone(t);return this.toTree(e)},strArr2ObjArr=t=>{let e=getDataType(t[0]);return"String"===e||"Number"===e?t.map((t=>({label:t,value:t}))):t};return await getContent.call(d,{content:t,contType:r,contData:o,ajax:h,cb:t=>{let e=getDataType(t);if("Object"===e&&t.hasOwnProperty("data")&&Array.isArray(t.data))g=getFromArray(t.data),t.data=g,m=t;else{if("Array"===e)g=getFromArray(strArr2ObjArr(t));else if(e.includes("HTML"))["UL","OL","DATALIST","DL","SELECT","SCRIPT"].includes(t.nodeName)?g=strArr2ObjArr(getFromNode(t)):t.nodeName.includes("INPUT")&&(g=this.fromInput(t,n));else if("String"===e){let e=createEl("div","",t),s=e.querySelector(":scope > ul,:scope > ol,:scope > datalist,:scope > dl,:scope > select,:scope > script,:scope > input");if(s)g=strArr2ObjArr(getFromNode(s)),e.remove();else{let e=t.trim(),s=e.startsWith("{")&&e.endsWith("}")?"object":e.startsWith("[")&&e.endsWith("]")?"array":"";g=s?this.toTree(strArr2ObjArr(parseStr({content:t,type:s,error:t=>{}}))):strArr2ObjArr(t.split(n).filter(Boolean))}}m=g}}}),p&&this.addIdPath({source:g,rootStart:s,idStart:e,floorStart:i,pathHyphen:a}),u&&u(m),m},getPathHyphen:t=>{let e=t[0],s=e.id,i=e.floor,a=e.pId;return{id:s,floor:i,pId:a,path:e.path,hyphen:e.path.replace(a,"").replace(s,"")}},graftBranch:function({source:t,target:e,flatData:s,treeData:i,rootEl:a,isFront:l=!0,isChild:n=!0,cb:r}){if(isNull(t)||isEmpty(i))return;let o=findItem(t,s),h=findItem(e,s),p=this.getPathHyphen(i),d=p.floor,c=p.pId,u=p.hyphen;if(!o)return;let g=findItem(o.pId,s);if(splice(g?{host:g.children,source:o,intent:"remove"}:{host:i,source:o,intent:"remove"}),h)if(n)!h.hasOwnProperty("children")&&(h.children=[]),l?(h.childrenEl.insertAdjacentElement("afterBegin",o.wrapEl),h.children.unshift(o)):(h.childrenEl.insertAdjacentElement("beforeEnd",o.wrapEl),h.children.push(o)),o.pId=h.id,o.floor=h.floor+1,o.path=h.path+u+o.id;else{if(h.floor===d){let t=i.indexOf(h);splice({host:i,source:o,index:l?t:t+1,intent:"add"})}else{let t=findItem(h.pId,s),e=t.children.indexOf(h),i=l?e:e+1;splice({host:t.children,source:o,index:i,intent:"add"})}o.pId=h.pId,o.floor=h.floor,o.path=h.path.replace(new RegExp("(.*)"+h.id),"$1"+o.id);let t=l?"beforeBegin":"afterEnd";h.wrapEl.insertAdjacentElement(t,o.wrapEl)}else l?(a?.insertAdjacentElement("afterBegin",o.wrapEl),i.unshift(o)):(a?.insertAdjacentElement("beforeEnd",o.wrapEl),i.push(o)),o.pId=c,o.floor=d,o.path=c+u+o.id;r&&r(o,h)}},moveItem=({source:t,target:e,data:s,isFront:i=!0})=>{let a=getDataType(t),l=getDataType(e),n="Number"===a?t:s.indexOf(t),r="Number"===l?e:s.indexOf(e),o="Number"===a?s[t]:t,h=i?0:1;if(isNull(n)||isEmpty(s))throw new Error("Cannot get the index of the moving item!");if(n>s.length||n<0)throw new Error("Exceeded array length!");(r<0||r>s.length)&&(r=i?0:s.length-1),n!==r&&(s.splice(n,1),n<r&&r--,s.splice(r+h,0,o))},findItems=(t,e,s,i)=>{let a=getDataType(t),n=[];return n=("String"===a?t.split(i?.separator||l.splitHyphen):"Array"===a?t:[t]).map((t=>findItem(t,e,s,i))).filter(Boolean),n};let k={set:function(t,e=""){if(isEmpty(t))return;let getHslaArr=t=>{let e=getDataType(t),s=[];if(!isEmpty(t))if("String"===e)if((t=t.trim().toLowerCase()).startsWith("hsl"))s=t.replace(/^(hsl|hsla)\(/,"").replace(/\)$/,"").replace(/\s/g,"").split(",");else{let e=[];t.startsWith("#")?e=(t=>{let e=(t=t.trim()).toLowerCase(),s=[];if(/^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$/.test(e)){if(4===e.length){let t="#";for(let s=1;s<4;s+=1)t+=e.slice(s,s+1).concat(e.slice(s,s+1));e=t}for(let t=1;t<7;t+=2)s.push(parseInt("0x"+e.slice(t,t+2)))}return s})(t):t.startsWith("rgb")&&(e=t.replace(/^(rgb|rgba)\(/,"").replace(/\)$/,"").replace(/\s/g,"").split(",").map(Number)),s=(t=>{let e,s=t[0]/255,i=t[1]/255,a=t[2]/255,l=Math.min(s,i,a),n=Math.max(s,i,a),r=0,o=(l+n)/2,h=n-l;if(n===l)r=0,e=0;else{switch(e=o>.5?h/(2-n-l):h/(n+l),n){case s:r=(i-a)/h+(i<a?6:0);break;case i:r=2+(a-s)/h;break;case a:r=4+(s-i)/h}r=Math.round(60*r)}return e=Math.round(100*e),o=Math.round(100*o),4===t.length?[r,e,o,t[3]]:[r,e,o,1]})(e)}else"Array"===e&&(s=t);return 3===s.length&&s.push(1),s},i={prim:[],text:[],error:[],succ:[],info:[],warn:[],issue:[]};if("Object"===getDataType(t))for(let e in t)t.hasOwnProperty(e)&&t[e].length>2&&(i[e]=getHslaArr(t[e]));else i.prim=getHslaArr(t);isEmpty(u.get("AxThemeRaw"))&&u.set("AxThemeRaw",this.get());let a=document.querySelector(":root");for(let t in i)i.hasOwnProperty(t)&&i[t].length>2&&(a.style.setProperty(`--${s.prefix}h-${t}`,i[t][0]),a.style.setProperty(`--${s.prefix}s-${t}`,"string"==typeof i[t][1]&&i[t][1].includes("%")?i[t][1]:i[t][1]+"%"),a.style.setProperty(`--${s.prefix}l-${t}`,"string"==typeof i[t][2]&&i[t][2].includes("%")?i[t][2]:i[t][2]+"%"),a.style.setProperty(`--${s.prefix}a-${t}`,i[t][3]));e&&u.set(e,i)},get:function(){let getValue=t=>[getComputedVar(`--${s.prefix}h-${t}`),getComputedVar(`--${s.prefix}s-${t}`),getComputedVar(`--${s.prefix}l-${t}`),getComputedVar(`--${s.prefix}a-${t}`)].map((t=>{let e=t.trim();return e.includes("%")?e:Number(e)}));return{prim:getValue("prim"),text:getValue("text"),succ:getValue("succ"),error:getValue("error"),info:getValue("info"),warn:getValue("warn"),issue:getValue("issue")}},reset:function(){let t=u.get("AxThemeRaw");this.set(t)}};const getBetweenEls=({selector:t,start:e,end:s,root:i,exclude:a})=>{let l=getEl(i)||document.body,n=getEl(e,l),r=getEl(s,l),o=getEls(a,l),h=getEls(t,l),p=[];return 0===h.length?p:(n&&!r?p=h.filter((t=>n.compareDocumentPosition(t)&Node.DOCUMENT_POSITION_FOLLOWING)):!n&&r?p=h.filter((t=>r.compareDocumentPosition(t)&Node.DOCUMENT_POSITION_PRECEDING)):n&&r&&(p=h.filter((t=>n.compareDocumentPosition(t)&Node.DOCUMENT_POSITION_FOLLOWING&&r.compareDocumentPosition(t)&Node.DOCUMENT_POSITION_PRECEDING))),o.length?p.filter((t=>!o.find((e=>e.contains(t))))):p)},scrollTo=(t,e)=>{let s=Object.assign({curve:"easeOut",offset:0,duration:0},e),i=getEl(e?.root),a=i||window,l=toPixel(s.offset),n=getEl(t),r=document.documentElement.scrollTop||document.body.scrollTop,o=i?i.scrollTop:r,h=Date.now(),p=0;i&&"static"===style(i).position&&(i.style.position="relative"),p=n?i?n.offsetTop-i.scrollTop:n.getBoundingClientRect().top:"number"==typeof t?t-o:-o;let d=s.duration&&"number"==typeof s.duration?s.duration:Math.abs(p)/4+1e3,repeat=()=>{let t=Date.now()-h,e=t/d,i=o+(p-l)*v[s.curve](e);a.scrollTo(0,i),repeat.timer=requestAnimationFrame(repeat),t>=d&&(a.scrollTo(0,i),cancelAnimationFrame(repeat.timer))};return repeat(),t},getScrollObj=()=>navigator.userAgent.indexOf("Firefox")>0?{event:"DOMMouseScroll",detail:"detail"}:{event:"mousewheel",detail:"wheelDelta"},C={get:(t,e,s=!1)=>{let i=getEl(t),a=style(i),l=i?.style?.transform,n={rotate:0,scale:{x:1,y:1},translate:{x:0,y:0},skew:{x:0,y:0}};if(isEmpty(e)&&(e=["translate","scale","rotate","skew"]),l){let getReg=t=>new RegExp(`${t}\\(([^\\)]+)\\)`),getText=t=>l.match(getReg(t));if(e.includes("translate")&&l.includes("translate")&&getText("translate"))if(getText("translate")[1].includes(",")){let t=getText("translate")[1].split(",").map((t=>parseInt(t)));n.translate={x:t[0],y:t[1]}}else n.translate={x:parseInt(getText("translate")[1]),y:0};if(e.includes("scale")&&l.includes("scale")&&getText("scale"))if(getText("scale")[1].includes(",")){let t=getText("scale")[1].split(",").map((t=>parseFloat(t)));n.scale={x:t[0],y:t[1]}}else n.scale={x:parseFloat(getText("scale")[1]),y:parseFloat(getText("scale")[1])};if(e.includes("rotate")&&l.includes("rotate")&&getText("rotate")&&(n.rotate=parseFloat(getText("rotate")[1])),e.includes("skew")&&l.includes("skew")&&getText("skew"))if(getText("skew")[1].includes(",")){let t=getText("skew")[1].split(",").map((t=>parseFloat(t)));n.skew={x:t[0],y:t[1]}}else n.skew={x:parseFloat(getText("skew")[1]),y:0}}return s&&(n.translate={x:parseInt(a.left),y:parseInt(a.top)}),n},set:function({el:t,data:e,instead:s=!1,cb:i}){let a=getEl(t),l=this.get(a,["translate","scale","rotate","skew"],s),n=a?.style.transform||"",getReg=t=>new RegExp(`${t}\\(([^\\)]+)\\)`,"gmi"),re=(t,e,s)=>isNull(t[s])?l[e][s]:t[s];if(a||!isEmpty(e)){for(let t in e)if(e.hasOwnProperty(t)){let i="";"translate"===t?s?isNaN(e[t])?(a.style.left=`${re(e[t],"translate","x")}px`,a.style.top=`${re(e[t],"translate","y")}px`):a.style.left=`${e[t]}px`:(i=isNaN(e[t])?`${t}(${re(e[t],"translate","x")}px,${re(e[t],"translate","y")}px)`:`${t}(${e[t]}px)`,n.includes(t)?n.startsWith("translate")?n=n.replace(getReg(t),i):(n=n.replace(getReg(t),""),n=`${i} ${n}`):n=`${i} ${n}`):("scale"===t?i=isNaN(e[t])?`${t}(${re(e[t],"scale","x")},${re(e[t],"scale","y")})`:`${t}(${e[t]})`:"rotate"===t?i=`${t}(${e[t]}deg)`:"skew"===t&&(i=isNaN(e[t])?`${t}(${re(e[t],"skew","x")}deg,${re(e[t],"skew","y")}deg)`:`${t}(${e[t]}deg)`),n.includes(t)?n=n.replace(getReg(t),i):n+=` ${i}`)}a.style.transform=n,i&&i(n)}},remove:({el:t,prop:e})=>{let s=getEl(t),i=s?.style?.transform;s&&i&&(s.style.transform=e?i.replace(new RegExp(`${e}\\([^)]+\\)\\s*`,"g"),""):"none")},disable:t=>{let e=getEl(t);e&&(e.style.transitionDuration="0ms")},enable:(t,e=200)=>{let s=getEl(t);s&&(s.style.transitionDuration=`${e}ms`)},clear:t=>{let e=getEl(t);e&&(e.style.transition="none")},matrix:t=>{let e=getEl(t);if(!e)return[];let s=style(e).transform;return"none"===s?[1,0,0,1,0,0]:s.replace(/[^0-9.\-,]/g,"").split(",").map((t=>Number(t)))}},isScrollUp=(t,e=getScrollObj().detail)=>{let s,i=t[e];return s=navigator.userAgent.indexOf("Firefox")>0?i>0:i<0,s},$=s.isTouchScr?["touchstart","touchmove","touchend","touchcancel"]:["mousedown","mousemove","mouseup","mouseleave"],getClientObj=t=>{let e=s.isTouchScr?t.targetTouches[0]:t;return e?{x:e.clientX,y:e.clientY}:null},getNestProp=(t,e)=>e?e.replace(/['"\s]/g,"").split(".").reduce(((t,e)=>{if(t&&void 0!==t[e])return t[e];if(e.endsWith("]")){let s=[];return s=e.startsWith("[")?e.split("]").map((t=>t.replace("[",""))).filter(Boolean):e.split("[").map((t=>t.replace("]",""))),s.reduce(((t,e)=>t&&t[e]),t)}}),t):t,arrSort=(t,e)=>{if(isEmpty(t))return;let s=getDataType(e),i=[];var a;"Object"===s?i=[e]:"Array"===s&&(i=e),t.sort(0===(a=i).length?(t,e)=>(t+"").localeCompare(e+"",l.lang.name):(t,e)=>{for(let s of a){let i="",a=0,n=0;if(i=s.hasOwnProperty("key")?s.key:"label",a=s.hasOwnProperty("dir")?"asc"===s.dir?1:"desc"===s.dir?-1:0:1,n=(getNestProp(t,i)+"").localeCompare(getNestProp(e,i)+"",s.locale||l.lang.name,s.opt||{}),0!==n)return n*a}return 0})},clearRegx=t=>(t+"").replace(/[.*+?^${}()|[\]\\]/g,""),arrSearch=({keys:t,props:e="label",source:s=[],fuzzy:i=!0,limit:a=0,order:n="",ignore:r=!0,hyphen:o=l.splitHyphen})=>{if(isEmpty(t)||isEmpty(e)||isEmpty(s))return[];let h=valToArr(t,o).map((t=>clearRegx(t))).filter(Boolean),p=valToArr(e,o),d=[],c="("+h.join("|")+")",u=new RegExp(c,(r?"i":"")+"g"),lowerSet=t=>[...new Set(t.map((t=>t.toLowerCase())))];for(let t of s){let e=p.map((e=>t[e])).join("■").match(u),s={},a=[];e&&(a=[...new Set(e)],s={source:t,weight:e.length,keys:a},i?d.push(s):r?lowerSet(h).length===lowerSet(a).length&&d.push(s):h.length===a.length&&d.push(s))}if(n){let t,e=getDataType(n);t="String"===e?"desc"===n?{key:"weight",dir:"desc"}:"asc"===n?{key:"weight",dir:"asc"}:"":"Boolean"===e&&!0===n?{key:"weight",dir:"desc"}:n,arrSort(d,t)}return a&&d.length>a&&d.splice(a),d},getIntArr=(t,e=l.splitHyphen)=>t.map((t=>"string"==typeof t?valToArr(t,e):t)).reduce(((t,e)=>t.filter((t=>e.includes(t))))),isOutside=(t,e)=>{let i=getEl(e);if(!i||!t)return!0;let a=s.isTouchScr?{x:t.targetTouches[0].clientX,y:t.targetTouches[0].clientY}:{x:t.clientX,y:t.clientY},l=i.getBoundingClientRect().left,n=i.getBoundingClientRect().top,r=l+i.offsetWidth,o=n+i.offsetHeight;return a.x<l||a.x>r||a.y<n||a.y>o},getEvtClient=(t,e)=>{let s=t.targetTouches&&t.targetTouches[0]?t.targetTouches[0]:t.changedTouches?t.changedTouches[0]:t,i="x"===e?"clientX":"y"===e?"clientY":"";return i?s[i]:{x:s.clientX,y:s.clientY}},getRectPoints=(t,e)=>{let s=getEl(e),i=[];if(!s||!t)return i;let a=getEvtClient(t),l=a.x,n=a.y,r=s.offsetWidth,o=s.offsetHeight,h=s.getBoundingClientRect().left,p=s.getBoundingClientRect().top,d=p+o/3,c=p+o/2,u=p+2*o/3,g=h+r/3,m=h+r/2,b=h+2*r/3;return l>=h&&l<=h+r&&n>=p&&n<=p+o?(i.push("inside"),n<d?i.push("t/3"):n>=d&&n<c?i.push("t/2"):n>=u?i.push("b/3"):n>=c&&i.push("b/2"),l<g?i.push("l/3"):l>=g&&l<m?i.push("l/2"):l>=b?i.push("r/3"):l>=m&&i.push("r/2")):i=["outside"],i},elsSort=(t,e=!1)=>{let s=t.map((t=>getEl(t))).filter(Boolean),i=unique(s);return i.sort(((t,e)=>t.contains(e)?1:e.contains(t)?-1:0)),e?i.reverse():i},getStrFromTpl=function(t,e,s){let i=e||this.tplStr,a=s||this.tplEng;return"template"===a.name?a(i)(t):a(i,t)},setSingleSel=(t,e)=>{let s=(Array.isArray(t)?t:[t]).map((t=>getEls(t))).flat().filter(Boolean),setFn=t=>{if(e.trim().startsWith("#"))t.id=e.slice(1);else if(e.trim().startsWith("."))t.classList.add(e.slice(1));else if(e.trim().startsWith("[")&&e.trim().endsWith("]")){let s=e.slice(1,-1).replace('"',"").replace("'","").split("=");t.setAttribute(s[0],s[1]||"")}};if(0!==s.length&&e&&"string"==typeof e)for(let t of s)setFn(t)},parseUrlArr=(t,e={})=>{if(!t)return[];let s=Object.assign({start:"{",end:"}",max:20},e),i=[],a=new RegExp(`\\${s.start}(\\S*)\\${s.end}`),l=t.match(a);if(!l)return[];let n=l[1],r=n.split("-").map((t=>~~t)),o=n.split(",").map((t=>~~t)),h=r[0],p=r[1]||h+s.max,d=`${s.start}${n}${s.end}`;if(t.includes(","))i=o.map((e=>t.replace(d,e)));else for(let e=h;e<=p;e++)i.push(t.replace(d,e));return i},D={toSlash:t=>t.replaceAll("-","/"),getTimeObj:function(t){let e=t.replaceAll(" ","").split(":"),s={hh:0,mm:0,ss:0};return t&&(e.length<2?s.hh=~~t||0:(s.hh=~~e[0]||0,s.mm=~~e[1]||0,s.ss=~~e[2]||0)),s},int2Date:(t,e="datetime")=>({value:t=~~t,prop:"daytime"===e?"hh":"month"===e?"MM":"YYYY"}),getDate:function(t,e="datetime",s=l.lang.datetime){let i,a=getDataType(t);if(isEmpty(t))i=new Date;else if("Date"===a)i=new Date(t.valueOf());else if("String"===a){let a=t.includes(s.bc);if((t=this.toSlash(trim(t).replace(s.bc,""))).includes(" "))if(i=new Date(t),t.includes("/")){let e,s,l=t.split(" "),n=l[0].split("/"),r=l[1].split(":");n[1]=n[1]?n[1]-1:0,n[2]=n[2]||0,r[1]=r[1]||0,r[2]=r[2]||0,e=[...n,...r].map((t=>~~t)),a&&(e[0]=-1*e[0]),s=new Date(...e),s.setFullYear(e[0]),i=s}else i=new Date;else if(t.includes(":"))i=new Date("1970/1/1 "+t);else if(t.includes("/")){let e=t.split("/").map((t=>~~t));e[1]&&e[1]--,a&&(e[0]=-1*e[0]),i=new Date(...e)}else{i=new Date("1970/1/1 00:00:00");let s=this.int2Date(t,e);"hh"===s.prop?i.setHours(s.value):"MM"===s.prop?i.setMonth(s.value-1):i.setFullYear(a?-1*s.value:s.value)}}else"Object"===a?(i=new Date("1970/1/1 00:00:00"),t.hasOwnProperty("YYYY")&&i.setFullYear(t.YYYY),t.hasOwnProperty("MM")&&i.setMonth(t.MM),t.hasOwnProperty("DD")&&i.setDate(t.DD),t.hasOwnProperty("hh")&&i.setHours(t.hh),t.hasOwnProperty("mm")&&i.setMinutes(t.mm),t.hasOwnProperty("ss")&&i.setSeconds(t.ss)):i=new Date;return["date","year","month"].includes(e)?(i.setHours(0),i.setMinutes(0),i.setSeconds(0),["year","month"].includes(e)&&i.setDate(1),"year"===e&&i.setMonth(0)):"daytime"===e&&(i.setFullYear(1970),i.setMonth(0),i.setDate(1)),i},getDateObj:function(t,e="datetime"){let s,i;return"Object"===getDataType(t)?i={...t}:(s=this.getDate(t,e),i={YYYY:s.getFullYear(),MM:s.getMonth(),DD:s.getDate(),hh:s.getHours(),mm:s.getMinutes(),ss:s.getSeconds()}),["date","year","month"].includes(e)?(Reflect.deleteProperty(i,"hh"),Reflect.deleteProperty(i,"mm"),Reflect.deleteProperty(i,"ss"),["year","month"].includes(e)&&Reflect.deleteProperty(i,"DD"),"year"===e&&Reflect.deleteProperty(i,"MM")):"daytime"===e&&(Reflect.deleteProperty(i,"YYYY"),Reflect.deleteProperty(i,"MM"),Reflect.deleteProperty(i,"DD")),i},getCurDays:function(t){let e=this.getDate(t),s=e.getFullYear(),i=e.getMonth();return new Date(s,i+1,0).getDate()},getOffsetDate:function(t,e={YYYY:0,MM:0,DD:0,hh:0,mm:0,ss:0}){let s=this.getDate(t);return e.hasOwnProperty("ss")&&s.setDate(s.getSeconds()+e.ss),e.hasOwnProperty("mm")&&s.setDate(s.getMinutes()+e.mm),e.hasOwnProperty("hh")&&s.setDate(s.getHours()+e.hh),e.hasOwnProperty("DD")&&s.setDate(s.getDate()+e.DD),e.hasOwnProperty("MM")&&s.setMonth(s.getMonth()+e.MM),e.hasOwnProperty("YYYY")&&s.setFullYear(s.getFullYear()+e.YYYY),s},fillZero:(t,e=2)=>t.toString().padStart(e,"0"),fillFormat:function(t,e,s=l.lang.datetime){let i,a,n,r,o,h,p,d=s.weeks,c=this.getDate(t);if(i=c.getFullYear(),a=c.getMonth()+1,n=c.getDate(),p=c.getDay(),r=c.getHours(),o=c.getMinutes(),h=c.getSeconds(),e.includes("YYYY")){let t=Math.abs(i)+"";i<0?e.includes("BC")?e=e.replace("BC",s.bc):t=s.bc+t:e.includes("BC")&&(e=e.replace("BC","")),e=e.replace("YYYY",t)}return e.includes("MM")&&(e=e.replace("MM",this.fillZero(a))),e.includes("DD")&&(e=e.replace("DD",this.fillZero(n))),e.includes("hh")&&(e=e.replace("hh",this.fillZero(r))),e.includes("mm")&&(e=e.replace("mm",this.fillZero(o))),e.includes("ss")&&(e=e.replace("ss",this.fillZero(h))),e.includes("WW")&&(e=e.replace("WW",d[p])),e},sort:function(t,e="asc"){return t.sort(((t,s)=>"asc"===e?this.getDate(t)-this.getDate(s):this.getDate(s)-this.getDate(t)))},getDateType:t=>RegExp(/^(?=.*YYYY)(?=.*MM)(?=.*DD)(?=.*hh).*$/).test(t)?"datetime":RegExp(/^(?=.*YYYY)(?=.*MM)(?=.*DD).*$/).test(t)?"date":RegExp(/^(?=.*YYYY)(?=.*MM).*$/).test(t)?"month":RegExp(/^(?=.*YYYY).*$/).test(t)?"year":RegExp(/^(?=.*hh).*$/).test(t)?"daytime":"",isSameDay:(t,e)=>t.YYYY==e.YYYY&&t.MM==e.MM&&t.DD==e.DD},repeatStr=(t,e=1,s)=>{let i="";for(let a=1;a<=e;a++)i+=renderTpl(t,{index:a,data:s});return i},createModule=t=>{let e=Object.assign({type:"none",optMaps:[],component:!1,spread:[],methods:{},ready:null,init:null,augment:!1,initial:!0},t),i=e.name||"Module"+Date.now(),a=["node","data"].includes(e.type),n=a?e.type:"none",r=new Function("optMaps","component","spread","constructed","initiated","initial","ModBaseListenCache","config",`"use strict";\n            return class ${i} extends ModBaseListenCache {\n                static hostType = "${n}";\n                static optMaps =  optMaps;\n                constructor(${a?"host,":""}options, eager = initial) {\n                    super();\n                    super.ready({ type:"${n}",${a?"host,":""} options, optMaps:${i}.optMaps,  component, spread });\n                    constructed && constructed.call(this);\n                    super.listen({ name: 'constructed' });\n                    eager && this.init();\n                }\n                async init(cb) {\n                    super.listen({ name: 'initiate' });\n                    try{\n                        this.options.b4Init && await this.options.b4Init.call(this);\n                    }catch{\n                        console.warn(config.warn.init);\n                        return this;\n                    }\n                    initiated && await initiated.call(this);\n                    super.listen({ name: 'initiated', cb });\n                    return this;\n                }\n            }\n        `)(e.optMaps,e.component,e.spread,e.constructed,e.initiated,e.initial,ModBaseListenCache,l);for(let t in e.methods)r.prototype[t]=e.methods[t];return e.augment&&(s[i]=r),r},createComp=t=>{let e=Object.assign({attrs:[],methods:{},excludeAttrs:[],modOpts:{},augment:!1,autoUpdate:!0,autoIns:!0,register:!0},t),i=window.customElements.get(e.tagName);if(i)return i;let a=e.compName||"Comp"+Date.now(),l=e.hostName||"div",n=e.module?e.module.optMaps:[],r=e.module?[...n.map((t=>t.attr)),...e.attrs]:e.attrs,o=`"use strict";\n            return class ${a} extends CompBaseComm {\n                constructor() {\n                    super();\n                    this.createShadow();\n                    this.createPropsObs();\n                    this.optMaps = optMaps;\n                    this.canUpdate = true;\n                    for (let k of [...attrs, 'options']) this.propsRaw[k] = this.getAttribute(k);\n                    this.on('connected',()=>{\n                        connected && connected.call(this);\n                    });\n                    this.reset = () => {\n                        this.restoreAttrs();\n                        this.listen({ name: 'reset' });\n                    }\n                    for (let k in methods) this[k] = methods[k].bind(this);\n                    constructed && constructed.call(this);\n                    this.listen({ name: 'constructed'});\n                }\n                static get observedAttributes() {\n                    return [...attrs, 'options'];\n                }\n                attributeChangedCallback(name, oldVal, newVal) {\n                    if (!this.canListen) return;\n                    !excludeAttrs.includes(name) && this.updateProxy(name, newVal,this.optMaps);\n                    changed && changed.call(this,{name, oldVal, newVal});\n                    this.listen({ name: 'changed', params: [{name, oldVal, newVal}] });\n                }\n                render() {\n                    this.insertSource();\n                    this.wrapEl = createEl('${l}',{${s.alias}:'slot-host'}, this.rawHtml);\n                    this.appendChild(this.wrapEl);\n                    autoIns && module && (this.ins = new module(this.wrapEl,modOpts));\n                    this.propsObs.on('completed', (data) => {\n                        if(this.connCount > 1){\n                            autoUpdate && this?.ins?.update && this.ins.update(this.properties);\n                            updated && updated.call(this,data);\n                            this.listen({ name: 'updated',params:[data]});\n                        }\n                        this.listen({ name: 'completed',params:[data]});\n                    });\n                }\n            }\n        `,h=new Function("constructed","connected","changed","updated","autoUpdate","autoIns","excludeAttrs","module","modOpts","CompBaseComm","createEl","attrs","optMaps","methods",o)(e.constructed,e.connected,e.changed,e.updated,e.autoUpdate,e.autoIns,e.excludeAttrs,e.module,e.modOpts,CompBaseComm,createEl,r,n,e.methods);return e.register&&window.customElements.define(e.tagName,h),e.augment&&(s[a]=h),h},getArrMap=(t,e)=>{if(!Array.isArray(t)||!t.length)return null;let s=new Map;for(let i of t){let t=e?i[e]:i;!s.has(i[t])&&s.set(t,i)}return s},includes=(t,e)=>{if(!Array.isArray(t)||!t.length)return!1;let s=new Set(t),i=s.has(e);return s.clear(),i},capStart=t=>{let e=t.search(/[a-zA-Z]/);if(e>-1){let s=t.charAt(e);return t.replace(s,s.toUpperCase())}return t},removeItem=(t,e)=>{if(Array.isArray(t)&&t.length&&e)for(let s=0;s<t.length;s++)if(t[s]===e){t.splice(s,1);break}},appendEls=({parent:t,nodes:e,reverse:s=!1,target:i,prepend:a=!1})=>{let l,n=document.createDocumentFragment(),r=(Array.isArray(e)?e:[e]).filter((t=>t&&t.nodeType&&t.nodeType===t.ELEMENT_NODE)),o=getEl(t),h=getEl(i,o);if(o&&r.length){for(let t of r)s?n.prepend(t):n.appendChild(t);l=h?a?h:h.nextElementSibling:a?o.firstElementChild:null,o.insertBefore(n,l)}},decompTask=({tasks:t,run:e,count:s=4,doing:i,done:a,type:l="idle",delay:n=0})=>{if(!Array.isArray(t)||!t.length)return;if("function"!=typeof e)throw new Error("run must be a function!");let r=[...t],o=0,h=!1,next=()=>{h||("timeout"===l?setTimeout(handler,n):"idle"===l?requestIdleCallback(handler):requestAnimationFrame(handler))},handler=()=>{if(h)return;let t=Math.min(o+s,r.length);for(;o<t;o++){let t=r[o],s=r.length<=1?1:o/(r.length-1);try{e&&e(t)}catch(t){}i?.(t,s)}o>=r.length?a?.():next()};return next(),{abort:()=>{h=!0},add:t=>{if(!t)return;let e=Array.isArray(t)?t:[t];r.push(...e),o>=r.length-e.length&&!h&&next()}}},filterPrims=t=>{let filter=t=>Object.entries(t).reduce(((t,[e,s])=>(["number","string","boolean","undefined","bigint","symbol"].includes(typeof s)&&(t[e]=s),t)),{});if(Array.isArray(t))return t.map((t=>"Object"===getDataType(t)?filter(t):t));return"Object"===getDataType(t)?filter(t):t},I=[{attr:"placement",prop:"placement",value:"center"},{attr:"trigger",prop:"trigger",value:"click"},{attr:"size",prop:"size",value:"md"},{attr:"in",prop:"in",value:"fadeIn"},{attr:"out",prop:"out",value:"fadeOut"},{attr:"multiple",prop:"multiple",value:!0},{attr:"draggable",prop:"draggable",value:!0},{attr:"feature",prop:"feature",value:""},{attr:"height",prop:"height",value:""},{attr:"adaptive",prop:"adaptive",value:!0},{attr:"draggable",prop:"draggable",value:!0},{attr:"gesture",prop:"gesture",value:{}},{attr:"parent",prop:"parent",value:""},{attr:"wing",prop:"wing",value:{selector:"",actClass:""}},{attr:"mask",prop:"mask",value:{enable:!0,closable:!0}},...d],L=[{attr:"parent",prop:"parent",value:""},{attr:"viewport",prop:"viewport",value:{enable:!1,selector:"",dmpRatio:.8,bouncy:!0,duration:0}},{attr:"jitter-click",prop:"jitterClick",value:10},{attr:"jitter-trans",prop:"jitterTrans",value:1},{attr:"origin",prop:"origin",value:null},{attr:"unbound",prop:"unbound",value:"[unbound]"},{attr:"spy",prop:"spy",value:{enable:!1}},{attr:"click",prop:"click",value:{timeThr:200,delay:200,dblclickable:!0,holdDelay:1e3,hold2Menu:!1}},{attr:"step",prop:"step",value:{mode:"translate",axis:"y",value:0,duration:500,intvl:200,linkage:!0,reverse:!1,curve:"easeOut"}},{attr:"wheel",prop:"wheel",value:!1},{attr:"keyboard",prop:"keyboard",value:{enable:!1,prev:"ArrowUp",next:"ArrowDown",intvl:200,target:null}},{attr:"translate",prop:"translate",value:{enable:!0,max:1e7,min:-1e7,instead:!1,target:""}},{attr:"drift",prop:"drift",value:{enable:!1,timeThr:300,distThr:20,coef:.5,duration:500,curve:"easeOut",auto:!0}},{attr:"swipe",prop:"swipe",value:{enable:!1,timeThr:100,distThr:20,coef:.5,duration:500,curve:"easeOut",auto:!0}},{attr:"scale",prop:"scale",value:{enable:!1,centered:!0,max:100,min:0}},{attr:"rotate",prop:"rotate",value:{enable:!1,max:3600,min:-3600}},{attr:"initial-val",prop:"initialVal",value:null},{attr:"b4-trigger",prop:"b4Trigger",value:null},{attr:"on-start",prop:"onStart",value:null},{attr:"on-move",prop:"onMove",value:null},{attr:"on-enter",prop:"onEnter",value:null},{attr:"on-leave",prop:"onLeave",value:null},{attr:"on-end",prop:"onEnd",value:null},{attr:"on-click",prop:"onClick",value:null},{attr:"on-dblclick",prop:"onDblclick",value:null},{attr:"on-hold",prop:"onHold",value:null},{attr:"on-scale",prop:"onScale",value:null},{attr:"on-scaling",prop:"onScaling",value:null},{attr:"on-scaled",prop:"onScaled",value:null},{attr:"on-rotate",prop:"onRotate",value:null},{attr:"on-rotating",prop:"onRotating",value:null},{attr:"on-rotated",prop:"onRotated",value:null},{attr:"on-translate",prop:"onTranslate",value:null},{attr:"on-translating",prop:"onTranslating",value:null},{attr:"on-translated",prop:"onTranslated",value:null},{attr:"on-drift",prop:"onDrift",value:null},{attr:"on-drifting",prop:"onDrifting",value:null},{attr:"on-drifted",prop:"onDrifted",value:null},{attr:"on-canceled",prop:"onCanceled",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-finished",prop:"onFinished",value:null},...p],P=[{attr:"margin",prop:"margin",value:"0px"},{attr:"threshold",prop:"threshold",value:[0,1]},{attr:"root",prop:"root",value:null},{attr:"spy-sel",prop:"spySel",value:""},{attr:"nav-sel",prop:"navSel",value:""},{attr:"sub-sel",prop:"subSel",value:""},{attr:"intvl",prop:"intvl",value:500},{attr:"repeat",prop:"repeat",value:!0},{attr:"active",prop:"active",value:""},{attr:"in",prop:"in",value:""},{attr:"out",prop:"out",value:""},{attr:"visible",prop:"visible",value:!0},{attr:"manual",prop:"manual",value:!1},{attr:"classes",prop:"classes",value:""},{attr:"wing",prop:"wing",value:{selector:"",offset:0,duration:0}},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"on-show",prop:"onShow",value:null},{attr:"on-showing",prop:"onShowing",value:null},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-in",prop:"onIn",value:null},{attr:"on-out",prop:"onOut",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-removed",prop:"onRemoved",value:null},...p];class Spy extends ModBaseListen{options={};storObs;storTmp;navEl;subEls;items;interactIns;rootEl;actIsAttr;active;hide2Debounce;static hostType="node";static optMaps=P;constructor(t,e={}){super(),super.ready({options:e,maps:Spy.optMaps,host:t,component:!1}),this.navEl=this.options.navSel?getEl(this.options.navSel):null,this.subEls=this.navEl&&this.options.subSel?this.navEl.querySelectorAll(this.options.subSel):[],this.hide2Debounce=debounce((t=>{"hidden"===t.ax.spy.state&&(t.ax.spy?.out&&classes(t).add(t.ax.spy?.out),t.ax.spy?.in&&(classes(t).remove(t.ax.spy?.in),!this.options.visible&&classes(t).add(`${s.prefix}o`)),this.active&&t.ax.spy.wing.forEach((t=>{this.actIsAttr?t.removeAttribute(this.active[0]):classes(t).remove(this.active)})))}),this.options.intvl),this.rootEl=getEl(this.options.root),this.getActive(),super.listen({name:"constructed"}),this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}if(this.items=[],this.interactIns&&this.interactIns.disconnect(),this.interactIns=new IntersectionObserver((t=>{t.forEach((t=>{let e={target:t.target,ratio:t.intersectionRatio,ins:this.interactIns,entry:t};t.isIntersecting?(e.intersecting=!0,0===t.intersectionRatio?(t.target.ax.spy.state="show",super.listen({name:"shown",params:[e]})):1===t.intersectionRatio?(t.target.ax.spy.state="shown",super.listen({name:"shown",params:[e]}),this.setActiveOnly(t.target)):(t.target.ax.spy.state="showing",super.listen({name:"showing",params:[e]})),t.target.ax.spy.ratio<t.intersectionRatio&&(super.listen({name:"in",params:[e]}),!this.options.visible&&classes(t.target).remove(`${s.prefix}o`),(t.target.ax.spy.state="showing")&&t.target.ax.spy?.in&&classes(t.target).add(t.target.ax.spy?.in,(e=>!t.target.classList.contains(e))),!this.options.repeat&&this.interactIns.unobserve(t.target)),t.target.ax.spy.ratio=t.intersectionRatio):(e.intersecting=!1,t.target.ax.spy.state="hidden",this.options.repeat&&this.hide2Debounce.cancel()(t.target),super.listen({name:"out",params:[e]}),t.target.ax.spy.ratio=0)}))}),{root:this.rootEl,rootMargin:this.options.margin,threshold:this.options.threshold}),this.options.spySel?this.items=[...this.targetEl.querySelectorAll(this.options.spySel)]:this.targetEl&&this.items.push(this.targetEl),this.options.b4Add){let t=await this.options.b4Add.call(this,this.items);t&&(this.items=t)}return!this.options.manual&&this.items.length&&this.items.forEach((t=>{this.setSpyAttr(t),this.interactIns.observe(t)})),super.listen({name:"initiated",cb:t}),this}getActive(){let t=this.options.active.trim();t.startsWith("[")&&t.endsWith("]")?(this.actIsAttr=!0,this.active=t.replace("[","").replace("]","").replace(" ","").split("=")):(this.actIsAttr=!1,this.active=this.options.active)}setActiveOnly(t){if(!isEmpty(this.active)){t.ax.spy.wing.forEach((t=>{this.actIsAttr?this.active.length>0&&t.setAttribute(this.active[0],this.active[1]||""):classes(t).add(this.active,(e=>!t.classList.contains(e)))})),this.items.filter((e=>e!==t&&e.ax.spy)).map((t=>t.ax.spy.wing)).flat(1/0).forEach((t=>{this.actIsAttr?t.removeAttribute(this.active[0]):classes(t).remove(this.active)}))}}setSpyAttr(t){if(!getDataType(t).includes("HTML"))return;let e=attrToJson(t,"spy"),i={observed:!0,wing:this.getWings(t),in:e.in||this.options.in,out:e.out||this.options.out,ratio:0};t.ax?t.ax.spy=i:t.ax={spy:i},this.options.classes&&classes(t).add(this.options.classes),!this.options.visible&&classes(t).add(`${s.prefix}o`)}getWings(t){let e=[],s=[],i=[],a=[];if(t.id)if(this.subEls.length>0&&this.subEls[0].hasAttribute("href")){let t=this.subEls.find((t=>t.getAttribute("href")===`#${t.id}`));t&&e.push(t)}else e=[...document.querySelectorAll(`[href='#${t.id}']`)];else{let s=this.items.findIndex((e=>e==t));-1!==s&&this.subEls[s]&&e.push(this.subEls[s])}if(t.hasAttribute("spy")){let e=attrToJson(t,"spy");e.wing&&(s=allToEls(e.wing))}return this.options.wing.selector&&(i=allToEls(this.options.wing.selector)),a=[...e,...s,...i].filter(Boolean),a.forEach((e=>{e.onclick=e=>{preventDft(e),scrollTo(t,{root:this.rootEl,duration:this.options.wing.duration,offset:this.options.wing.offset})}})),a}getEls(t){let e=getDataType(t),s=[];return"Array"===e?s=t.map((t=>getEl(t))).filter(Boolean):"String"===e&&(s=allToEls(t).filter(Boolean)),s}async add(t,e){if(this.destroyed)return;let s=this.getEls(t);if(!s.length)return this;if(this.options.b4Add){let t=await this.options.b4Add.call(this,s);t&&(s=t)}return s.forEach((t=>{t?.ax?.spy?new Message({content:renderTpl(this.options.lang.isObserved,{src:t.dataset.src||t.src}),iconShow:!0,status:"info"}).show():(this.setSpyAttr(t),this.interactIns.observe(t),!this.items.includes(t)&&this.items.push(t))})),super.listen({name:"add",cb:e,params:[s]}),this}async remove(t,e){if(this.destroyed)return;let s=this.getEls(t);return this.options.b4Remove&&await this.options.b4Remove.call(this,s),s.forEach((t=>{this.items.includes(t)&&(t.ax.spy?(Reflect.deleteProperty(t,"spy"),this.interactIns.unobserve(t)):new Message({content:renderTpl(this.options.lang.isUnobserved,{src:t.dataset.src||t.src}),iconShow:!0,status:"info"}).show())})),super.listen({name:"remove",cb:e,params:[s]}),this}destroy(t){if(!this.destroyed)return this.interactIns.disconnect(),this.items.forEach((t=>{t.ax.spy.wing.forEach((t=>{t.onclick=null}))})),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const getHypotenuse=(t=0,e=0)=>Math.sqrt(t*t+e*e);class Gesture extends ModBaseListen{options={};started;eventState;scrollObj;evtTarget;startTime;diffTime;jitterClick;jitterTrans;clickCount;preventEase;holdHandler;canTrans;transType;stepVal;moveVals;diffVals;startCoord;triangleVals;moveCount;touchesMoveCount;paramsFormat;params;endParams;driftListen;sizes;viewRange;viewportEl;parentEl;initialVals;spyIns;lastVals;nowVals;startVals;totalTrans;startFn;moveFn;endFn;stepFn;wheelFn;keyboardFn;cancelFn;menuFn;triggerFn;transitionendFn;preventDft;lastTarget;finishFn;static hostType="node";static optMaps=L;constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Gesture.optMaps,spread:["translate","drift","scale","swipe","rotate","viewport","keyboard","spy"]});let a=this;this.started=!1,this.eventState="end",this.scrollObj=getScrollObj(),this.evtTarget=null,this.startTime=0,this.diffTime=0,this.nowVals={translate:{x:0,y:0},scale:{x:1,y:1},rotate:0},this.jitterClick=a.options.jitterClick+(s.isTouchScr?10:0),this.jitterTrans=a.options.jitterTrans+(s.isTouchScr?4:0),this.clickCount=0,this.preventEase=!1,this.holdHandler=null,this.handleEls=getEls(this.options.translate.target);for(let t of this.handleEls)t.setAttribute("handle","");this.canTrans=!0,this.transType="translate",this.getStepVal(),this.moveVals={h:0,x:0,y:0,c:{id:0,x:0,y:0},d:{x:"",y:""}},this.diffVals={scale:0,rotate:0,translate:{x:0,y:0,h:0}},this.startCoord={x:0,y:0},this.triangleVals={start:{x:0,y:0,h:0},last:{x:0,y:0,h:0},now:{x:0,y:0,h:0}},this.moveCount=0,this.touchesMoveCount=0,this.paramsFormat={orgEvt:null,pointer:s.isTouchScr?"finger":"mouse",scale:{direction:0,diff:0,value:{x:1,y:1},translate:{x:0,y:0}},rotate:{direction:0,diff:0,value:0},translate:{direction:{x:0,y:0},diff:{x:0,y:0,h:0},value:{x:0,y:0},canDrift:!1,canSwipe:!1},drift:{duration:0,direction:{x:0,y:0},diff:{x:0,y:0,h:0},value:{x:0,y:0}},swipe:{duration:0,direction:{x:0,y:0},diff:{x:0,y:0,h:0},value:{x:0,y:0}},step:{direction:{x:0,y:0}},coord:{x:0,y:0},target:this.targetEl,name:"",moveStart:!1,touchesStart:!1,moveEnd:!1,moveTime:0},this.params=null,this.endParams={moveStart:!1,touchesStart:!1,moveEnd:!0},this.startFn=function(t){if(a.evtTarget=getEvtTarget(t),a.prevEvtDft(t),a.params={...deepClone(a.paramsFormat),evtTarget:a.evtTarget,relatedTarget:null},a.params.orgEvt=t,s.isTouchScr&&t.targetTouches.length>2&&0===t.changedTouches.length||!contains(a.evtTarget,a.targetEl))return void(a.started=!1);a.lastTarget=null,a.getStartVals(),a.targetEl.setAttribute("gesture","start");let e=a.getTouchCoords(t,"targetTouches"),i=a.getTouchCoords(t,"targetTouches"),l={...a.params},n={...a.params},r={...a.params},o={...a.params},h={...a.params};a.startCoord=a.getCenterCoord(e),a.startTime=Date.now(),s.isTouchScr&&1!==t.targetTouches.length?a.holdHandler&&clearTimeout(a.holdHandler):a.holdHandler=setTimeout((()=>{l.coord={...a.startCoord},l.name="hold",a.listen({name:"hold",params:[l]}),clearTimeout(a.holdHandler)}),a.options.click.holdDelay),s.isTouchScr&&t.targetTouches.length>1&&(a.options.scale.enable&&(a.startCoord=a.getCenterCoord(i),r.coord={...a.startCoord},r.scale.value=a.lastVals.scale,r.name="scale",a.listen({name:"scale",params:[r]})),a.options.rotate.enable&&(o.coord={...a.startCoord},o.rotate.value=a.lastVals.rotate,o.name="rotate",a.listen({name:"rotate",params:[o]}))),a.options.translate.enable&&(n.coord={...a.startCoord},n.translate.value={...a.lastVals.translate},n.name="translate",0===a.handleEls.length||a.useHandle(a.evtTarget)?a.listen({name:"translate",params:[n]}):a.canTrans=!1),h.coord={...a.startCoord},h.scale.value=a.lastVals.scale,h.rotate.value=a.lastVals.rotate,h.translate.value={...a.lastVals.translate},h.totalTrans=a.totalTrans,h.name="start",a.listen({name:"start",params:[h]}),a.getViewportSizeDiff(a.lastVals.translate),a.started=!0,a.eventState="start"},this.moveFn=function(t){if(a.evtTarget=getEvtTarget(t),!a.started)return;a.prevEvtDft(t),a.driftListen&&cancelAnimationFrame(a.driftListen.frame),a.diffTime=Date.now()-a.startTime,a.moveCount++,a.params.orgEvt=t;let e=a.getTouchCoords(t,"targetTouches"),i=1===a.moveCount;if(a.moveVals=a.getMoveVals(e,a.startCoord),a.moveVals.h<=a.jitterTrans)return;a.targetEl.style.transitionDuration="0ms";let l={...a.params,coord:a.moveVals.c,moveStart:i,evtTarget:a.evtTarget,relatedTarget:null},n={...l},r={...l},o={...l},h={...l};a.options.translate.enable&&(a.diffVals.translate={x:~~a.moveVals.x,y:~~a.moveVals.y,h:~~a.moveVals.h},a.updateNowTrans(),a.options.viewport.enable&&(a.nowVals.translate=a.getBounceVals(a.nowVals.translate)),a.moveVals.h>a.jitterClick&&a.holdHandler&&clearTimeout(a.holdHandler),n=extend({target:l,source:{translate:{diff:{...a.diffVals.translate},value:{...a.nowVals.translate},direction:a.moveVals.d},name:"translating"}}),a.totalTrans=a.nowVals.translate,a.parentEl&&isOutside(t,a.parentEl)&&(a.canTrans=!1),a.canTrans&&(a.options.swipe.enable&&a.diffTime<a.options.swipe.timeThr&&a.diffVals.translate.h>a.options.swipe.distThr?a.transType="swipe":(a.transType="translate",a.targetEl.setAttribute("gesture","move"),a.listen({name:"translating",params:[n]})))),s.isTouchScr&&t.targetTouches.length>1&&(a.touchesMoveCount++,a.triangleVals.now=a.getTriangleVals(e[0],e[1]),1===a.touchesMoveCount?(a.triangleVals.start={...a.triangleVals.now},a.diffVals.scale=0,a.diffVals.rotate=0,l.touchesStart=!0):(a.diffVals.scale=a.triangleVals.now.h/a.triangleVals.last.h-1,a.diffVals.rotate=a.triangleVals.now.a-a.triangleVals.last.a,a.correctDiffRotate()),a.correctRangeScale(),a.correctRangeRotate(),a.options.scale.enable&&(r=extend({target:l,source:{scale:{diff:toNumber(a.diffVals.scale),value:{x:toNumber(a.nowVals.scale.x),y:toNumber(a.nowVals.scale.y)},direction:a.diffVals.scale>0?1:a.diffVals.scale<0?-1:0},name:"scaling"}}),a.options.scale.centered||(r.scale.translate=a.getScaleTrans({coord:r.coord,diff:r.scale.diff}),a.totalTrans=a.getScaleTrans({initVal:a.totalTrans,coord:r.coord,diff:r.scale.diff})),a.listen({name:"scaling",params:[r]})),a.options.rotate.enable&&(o=extend({target:l,source:{rotate:{diff:toNumber(a.diffVals.rotate),value:toNumber(a.nowVals.rotate),direction:a.diffVals.rotate>0?1:a.diffVals.rotate<0?-1:0},name:"rotating"}}),a.listen({name:"rotating",params:[o]}))),h=extend({target:l,source:{rotate:o.rotate,scale:r.scale,translate:n.translate,totalTrans:a.totalTrans,name:"move"}}),a.listen({name:"move",params:[h]}),a.triangleVals.last={...a.triangleVals.now},a.eventState="move",a.lastTarget!==a.evtTarget&&(a.lastTarget&&a.listen({name:"leave",params:[{...h,evtTarget:a.lastTarget,relatedTarget:a.evtTarget}]}),a.evtTarget&&a.listen({name:"enter",params:[h]}),a.lastTarget=a.evtTarget)},this.endFn=function(t){if(!a.started)return;a.prevEvtDft(t),a.moveCount=a.touchesMoveCount=0,a.params.orgEvt=t,a.params.evtTarget=a.evtTarget,a.params.relatedTarget=null,a.params.moveTime=a.diffTime=Date.now()-a.startTime,a.holdHandler&&clearTimeout(a.holdHandler);let e={...a.params,coord:{...a.moveVals.c},translate:{diff:{...a.diffVals.translate},value:{...a.nowVals.translate},direction:{...a.moveVals.d}},...a.endParams},i={...a.params,...a.endParams},l={...i},n={...i},r={...i};if(a.diffVals.translate.h<a.jitterClick&&a.diffTime<a.options.click.timeThr&&(!s.isTouchScr&&0===t.button||s.isTouchScr)){let e=a.getTouchCoords(t,"changedTouches"),s=a.getCenterCoord(e);i.coord=s,i.name="click",a.options.click.dblclickable?(a.clickCount++,1===a.clickCount&&setTimeout((()=>{1===a.clickCount?a.listen({name:"click",params:[i]}):a.clickCount>1&&(i.name="dblclick",a.listen({name:"dblclick",params:[i]})),a.clickCount=0}),a.options.click.delay)):a.listen({name:"click",params:[i]})}if(a.canTrans&&a.options.translate.enable){let t=a.diffVals.translate.h>a.options.drift.distThr*(s.isTouchScr?2:1)&&a.diffTime<a.options.drift.timeThr/(s.isTouchScr?2:1);e.translate.canSwipe="swipe"===a.transType,e.translate.canDrift=!e.translate.canSwipe&&t,e.name="translated",a.listen({name:"translated",params:[e]}),a.preventEase||("swipe"===a.transType?a.updateEaseParamsListen(e,"swipe"):a.options.drift.enable&&t&&a.updateEaseParamsListen(e)),a.options.viewport.enable&&a.moveVals.h>1&&a.rebound()}s.isTouchScr&&(a.options.scale.enable&&(l.scale.diff=toNumber(a.diffVals.scale),l.scale.value={x:toNumber(a.nowVals.scale.x),y:toNumber(a.nowVals.scale.y)},l.name="scaled",a.listen({name:"scaled",params:[l]})),a.options.rotate.enable&&(n.rotate.diff=toNumber(a.diffVals.rotate),n.rotate.value=toNumber(a.nowVals.rotate),n.name="rotated",a.listen({name:"rotated",params:[n]})),a.moveVals.h>1&&a.getViewportSizeDiff(),a.lastVals.rotate=a.nowVals.rotate,a.lastVals.scale={...a.nowVals.scale}),r.translate=e.translate,r.drift=e.drift,r.scale=l.scale,r.rotate=n.rotate,r.totalTrans=a.totalTrans,r.name="end",a.listen({name:"end",params:[r]}),a.lastVals.translate={...a.nowVals.translate},a.setCompleted(),a.removeSecondEvents()},this.stepFn=(t,e,i="wheel")=>{if(!a.options.scale.enable&&!a.options.rotate.enable&&!a.options.translate.enable)return;a.getViewportSizeDiff(),a.getStartVals(),a.options.step.duration&&(a.targetEl.style.transitionDuration=`${a.options.step.duration}ms`),a.targetEl.style.transitionTimingFunction=s.curves[a.options.step.curve],a.params={...deepClone(a.paramsFormat),relatedTarget:null,evtTarget:"keyboard"===i?this.targetEl:getEvtTarget(t)},a.params=extend({target:a.params,source:{pointer:i,orgEvt:t,coord:"keyboard"===i?{x:0,y:0}:{x:t.clientX,y:t.clientY},step:{direction:{x:e,y:e}},translate:{value:{...a.nowVals.translate}},scale:{value:{...a.nowVals.scale},direction:e},rotate:{value:a.nowVals.rotate,direction:e},moveTime:1e3*parseFloat(style(a.targetEl).transitionDuration)}}),a.listen({name:"step",params:[{...a.params,name:"step"}]});let l={...a.params};if("scale"===a.options.step.mode){if(!a.options.scale.enable)return;a.diffVals.scale=1===e?a.stepVal:-a.stepVal,a.correctRangeScale(),l.scale.diff=toNumber(a.diffVals.scale),l.scale.value={x:toNumber(a.nowVals.scale.x),y:toNumber(a.nowVals.scale.y)},a.options.scale.centered||(l.scale.translate=a.getScaleTrans({coord:l.coord,diff:l.scale.diff}),a.totalTrans=a.getScaleTrans({initVal:a.totalTrans,coord:l.coord,diff:l.scale.diff})),a.options.step.linkage&&a.listen({name:"scaling",params:[{...l,name:"scaling"}]})}else if("rotate"===a.options.step.mode){if(!a.options.rotate.enable)return;a.diffVals.rotate=1===e?a.stepVal:-a.stepVal,a.correctRangeRotate(),l.rotate.diff=toNumber(a.diffVals.rotate),l.rotate.value=toNumber(a.nowVals.rotate),a.options.step.linkage&&a.listen({name:"rotating",params:[{...l,name:"rotating"}]})}else if("translate"===a.options.step.mode){if(!a.options.translate.enable)return;let t="y"===a.options.step.axis?{x:0,y:-e}:{x:-e,y:0},s=-e*a.stepVal,i="y"===a.options.step.axis?0:s,n="x"===a.options.step.axis?0:s;a.diffVals.translate={x:i,y:n,h:a.stepVal},a.updateNowTrans(),a.options.viewport.enable&&(a.nowVals.translate=a.getViewLimitVals(a.nowVals.translate)),l.translate.diff=a.diffVals.translate,l.translate.value=a.nowVals.translate,l.translate.direction=t,a.options.step.linkage&&a.listen({name:"translating",params:[{...l,name:"translating"}]})}a.listen({name:"stepped",params:[{...l,name:"stepped"}]}),a.listen({name:"move",params:[{...l,totalTrans:a.totalTrans,name:"move"}]}),a.lastVals[a.options.step.mode]={...a.nowVals[a.options.step.mode]}},this.wheelFn=throttle((function(t){t.stopPropagation(),t.preventDefault();let e=a.correctWheelDirection(isScrollUp(t,a.scrollObj.detail))?1:-1;a.stepFn(t,e,"wheel")}),{intvl:a.options.step.intvl,prevent:!0}),this.keyboardFn=throttle((t=>{t.stopPropagation(),t.preventDefault();let e=t.code===this.options.keyboard.prev?-1:t.code===this.options.keyboard.next?1:0;e&&a.stepFn(t,e,"keyboard")}),{intvl:a.options.step.intvl,prevent:!0}),this.cancelFn=function(t){a.setCompleted(),a.removeSecondEvents();let e=Object.assign(deepClone(a.paramsFormat),{orgEvt:t,relatedTarget:null,evtTarget:getEvtTarget(t),coord:{x:t.clientX,y:t.clientY},...a.endParams,name:"canceled"});a.listen({name:"canceled",params:[e]})},this.menuFn=function(t){if(a.isUnbound(t.target))return;t.stopPropagation(),t.preventDefault();let e=Object.assign(deepClone(a.paramsFormat),{orgEvt:t,relatedTarget:null,evtTarget:getEvtTarget(t),coord:{x:t.clientX,y:t.clientY},...a.endParams,name:"hold"});a.listen({name:"hold",params:[e]})},this.triggerFn=async t=>{if(!this.isUnbound(getEvtTarget(t))){t.stopPropagation();try{this.options.b4Trigger&&await this.options.b4Trigger.call(this,t)}catch{return}this.addSecondEvents(),super.listen({name:"trigger",params:[t]})}},this.finishFn=t=>{this.removeSecondEvents(),super.listen({name:"finished",params:[t]})},this.transitionendFn=debounce((t=>{"transform"===t.propertyName&&(t.stopPropagation(),this.options.viewport.enable&&this.nowVals&&(this.getViewportSizeDiff(this.nowVals.translate),this.rebound(this.nowVals.translate)))})),this.preventDft=t=>{t?.preventDefault()},super.listen({name:"constructed"}),i&&this.init()}getStartVals(){this.startVals=C.get(this.targetEl,["translate","scale","rotate"],this.options.translate.instead),this.totalTrans={...this.startVals.translate},this.nowVals={translate:{...this.startVals.translate,h:~~getHypotenuse(this.startVals.translate.x,this.startVals.translate.y)},scale:{...this.startVals.scale},rotate:this.startVals.rotate},this.lastVals=deepClone(this.nowVals)}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}if(this.setEmpty(),this.parentEl=getEl(this.options.parent),this.viewportEl=getEl(this.options.viewport.selector),this.options.initialVal&&C.set({el:this.targetEl,data:this.options.initialVal,instead:this.options.translate.instead}),this.initialVals=this.options.translate.instead?C.get(this.targetEl,["translate","scale","rotate","skew"],this.options.translate.instead):this.targetEl.style.transform,this.addPrimEvents(),s.isTouchScr)if(this.handleEls.length)for(let t of this.handleEls)t.addEventListener("touchstart",this.preventDft,{passive:!1});else this.targetEl.addEventListener("touchstart",this.preventDft,{passive:!1});return this.targetEl.addEventListener("transitionend",this.transitionendFn,{passive:!1}),s.isTouchScr||(this.options.wheel&&(this.targetEl.removeEventListener(this.scrollObj.event,this.wheelFn),this.targetEl.addEventListener(this.scrollObj.event,this.wheelFn,{passive:!1})),this.options.click.hold2Menu&&(this.targetEl.removeEventListener("contextmenu",this.menuFn),this.targetEl.addEventListener("contextmenu",this.menuFn))),this.setSpy(),this.setCompleted(),super.listen({name:"initiated",cb:t}),this}setEmpty(){}prevEvtDft(t,e=this.evtTarget){s.isTouchScr&&(this.options.scale.enable||this.options.rotate.enable)?contains(e,this.targetEl)&&preventDft(t,!0):(this.useHandle(e)||!this.handleEls.length&&contains(e,this.targetEl))&&preventDft(t,!0)}setSpy(){if(!this.options.spy.enable)return;let t=extend({target:{onIn:()=>{super.listen({name:"showing"})},onOut:()=>{this.options.keyboard.enable&&!s.isTouchScr&&window.removeEventListener("keydown",this.keyboardFn),super.listen({name:"hidden"})},onShown:()=>{this.options.keyboard.enable&&!s.isTouchScr&&window.addEventListener("keydown",this.keyboardFn,{passive:!1}),super.listen({name:"shown"})}},source:this.options.spy});this.spyIns=new Spy(getEl(this.options.keyboard.target)||this.targetEl,t)}isUnbound(t){return getEls(this.options.unbound,this.targetEl).find((e=>contains(t,e)))}updateEaseParamsListen(t,e="drift"){let i=~~((this.options[e].timeThr-this.diffTime)*this.options[e].coef)*("swipe"===e?s.isTouchScr?8:12:1),a=~~(i*(this.diffVals.translate.x/this.diffVals.translate.h)),l=~~(i*(this.diffVals.translate.y/this.diffVals.translate.h)),n=this.clampVals("translate",t.translate.value.x+a),r=this.clampVals("translate",t.translate.value.y+l);t[e].direction=t.translate.direction,t[e].diff={x:a,y:l,h:i},t[e].duration=this.options[e].duration,t[e].value=this.options.viewport.enable?this.getViewLimitVals({x:n,y:r}):{x:n,y:r},t.name=e,this.listen({name:e,params:[t]}),this.options[e].auto&&(this.targetEl.style.transitionDuration="0ms",this.driftListen=ease({from:t.translate.value,to:t[e].value,curve:this.options[e].curve,duration:this.options[e].duration,doing:s=>{t.translate.value={x:Math.floor(s.value.x),y:Math.floor(s.value.y)},this.listen({name:"swipe"===e?"swiping":"drifting",params:[t]})},done:()=>{let s=C.get(this.targetEl,["translate"],this.options.translate.instead).translate;t[e].value.x===s.x&&t[e].value.y===s.y&&this.listen({name:"swipe"===e?"swiped":"drifted",params:[t]})}}))}updateNowTrans(){let t=this.lastVals.translate.x+this.diffVals.translate.x,e=this.lastVals.translate.y+this.diffVals.translate.y;this.nowVals.translate={x:~~t,y:~~e},this.correctRangeTrans()}getMoveVals(t,e){let s=this.getCenterCoord(t),i=this.getTriangleVals(s,e),a=~~i.h,l=~~i.x,n=~~i.y;return{c:s,h:a,x:l,y:n,d:{x:l>0?1:l<0?-1:0,y:n>0?1:n<0?-1:0}}}addPrimEvents(){this.targetEl.addEventListener("pointerdown",this.triggerFn,{passive:!1}),this.targetEl.removeEventListener("pointerup",this.triggerFn,{passive:!1})}removePrimEvents(){this.targetEl.removeEventListener("pointerdown",this.triggerFn),this.targetEl.removeEventListener("pointerup",this.finishFn)}removeSecondEvents(){document.removeEventListener($[0],this.startFn),document.removeEventListener($[1],this.moveFn),document.removeEventListener($[2],this.endFn),document.removeEventListener($[3],this.cancelFn)}addSecondEvents(){document.addEventListener($[0],this.startFn,{passive:!1}),document.addEventListener($[1],this.moveFn,{passive:!1}),document.addEventListener($[2],this.endFn,{passive:!1}),document.addEventListener($[3],this.cancelFn,{passive:!1})}setCompleted(){this.started=!1,this.moveCount=this.touchesMoveCount=0,this.diffVals={scale:0,rotate:0,translate:{x:0,y:0,h:0}},this.holdHandler&&clearTimeout(this.holdHandler),this.canTrans=!0,this.preventEase=!1,this.targetEl.style.cssText=this.targetEl.style.cssText.replace("transition-duration: 0ms",""),this.targetEl.removeAttribute("gesture")}getOrign(t,e){let s=t.x-e.left,i=t.y-e.top;return s<0?s=0:s>e.width&&(s=e.width),i<0?i=0:i>e.height&&(i=e.height),{x:s,y:i}}getScaleTrans(t){let e=style(this.targetEl),s=parseInt(e.width),i=parseInt(e.height),a=this.options.origin||{x:s/2,y:i/2},l=this.targetEl.getBoundingClientRect(),n=this.getOrign(t.coord,l),r=C.get(this.targetEl,["translate"],this.options.translate.instead),orginDiff=e=>(a[e]-("x"===e?s:i)*(t=>{let e=n[t]/l["x"===t?"width":"height"];return e<0?e=0:e>1&&(e=1),e})(e))*t.diff,o=t.initVal||{x:r.translate.x,y:r.translate.y};return{x:~~(o.x+orginDiff("x")),y:~~(o.y+orginDiff("y"))}}getTouchCoords(t,e="targetTouches"){let i=[];if(s.isTouchScr)for(let s of t[e])i.push({x:~~s.clientX,y:~~s.clientY});else i.push({x:~~t.clientX,y:~~t.clientY});return i}getCenterCoord(t){let e,avg=(e,s)=>{let i=0;for(let a=0;a<e;a++)i+=t[a][s];return i/e};return e=t.length>1?{x:~~avg(2,"x"),y:~~avg(2,"y")}:1===t.length?t[0]:{x:0,y:0},e}getTriangleVals(t,e){let s=t.x-e.x,i=t.y-e.y;return{x:s,y:i,h:getHypotenuse(s,i),a:180*Math.atan2(i,s)/Math.PI}}correctRangeTrans(){let t,e,s,i,a,l=this.clampVals("translate",this.nowVals.translate.x),n=this.clampVals("translate",this.nowVals.translate.y);l!==this.nowVals.translate.x?(t=l,s=l-this.lastVals.translate.x):(t=this.nowVals.translate.x,s=this.diffVals.translate.x),n!==this.nowVals.translate.y?(e=n,i=n-this.lastVals.translate.y):(e=this.nowVals.translate.y,i=this.diffVals.translate.y),a=getHypotenuse(s,i),this.diffVals.translate={x:s,y:i,h:a},this.nowVals.translate={x:t,y:e}}correctRangeRotate(){this.nowVals.rotate=this.clampVals("rotate",this.nowVals.rotate);let t=this.nowVals.rotate+this.diffVals.rotate;t>=this.options.rotate.max?this.diffVals.rotate=this.options.rotate.max-this.nowVals.rotate:t<=this.options.rotate.min&&(this.diffVals.rotate=this.options.rotate.min-this.nowVals.rotate),this.nowVals.rotate+=this.diffVals.rotate}correctDiffRotate(){this.triangleVals.now.a>0&&this.triangleVals.last.a<0?this.triangleVals.now.a>90&&this.triangleVals.last.a<-90?this.diffVals.rotate=360-this.diffVals.rotate:this.triangleVals.now.a<90&&this.triangleVals.last.a>-90&&(this.diffVals.rotate=-this.diffVals.rotate):this.triangleVals.now.a<0&&this.triangleVals.last.a>0&&(this.triangleVals.now.a>-90&&this.triangleVals.last.a<90?this.diffVals.rotate=-this.diffVals.rotate:this.triangleVals.now.a<-90&&this.triangleVals.last.a>90&&(this.diffVals.rotate=-(360+this.diffVals.rotate)))}correctRangeScale(){let t=this.clampVals("scale",Math.abs(this.nowVals.scale.x)),e=this.clampVals("scale",Math.abs(this.nowVals.scale.y)),s=t+this.diffVals.scale,i=e+this.diffVals.scale;s>=this.options.scale.max||i>=this.options.scale.max?this.diffVals.scale=Math.min(this.options.scale.max-t,this.options.scale.max-e):(s<=this.options.scale.min||i<=this.options.scale.min)&&(this.diffVals.scale=Math.min(this.options.scale.min-t,this.options.scale.min-e)),this.nowVals.scale.x+=this.diffVals.scale*(this.nowVals.scale.x<0?-1:1),this.nowVals.scale.y+=this.diffVals.scale*(this.nowVals.scale.y<0?-1:1)}clampVals(t,e){return clampVal({val:e,min:this.options[t].min,max:this.options[t].max})}correctWheelDirection(t){return this.options.step.reverse?!t:t}getStepVal(){this.options.step.value?this.stepVal=this.options.step.value:this.stepVal="translate"===this.options.step.mode?60:"scale"===this.options.step.mode?.5:"rotate"===this.options.step.mode?10:0}getViewportSizeDiff(t){if(!this.options.viewport.enable)return;let e;if(this.sizes={viewport:{width:0,height:0,left:0,right:0,top:0,bottom:0},target:{width:0,height:0,left:0,right:0,top:0,bottom:0},diff:{x:0,y:0},offset:{left:0,right:0,top:0,bottom:0}},this.viewportEl&&this.viewportEl!==document.body&&this.viewportEl!==document.documentElement){let t=this.viewportEl.getBoundingClientRect();e={width:t.width,height:t.height,left:t.left,top:t.top,right:t.right,bottom:t.bottom}}else e={width:document.documentElement.clientWidth,height:document.documentElement.clientHeight,left:0,top:0,right:document.documentElement.clientWidth,bottom:document.documentElement.clientHeight};this.sizes.viewport={...e};let{width:s,height:i,left:a,top:l,right:n,bottom:r}=this.targetEl.getBoundingClientRect();this.sizes.target={width:s,height:i,left:a,top:l,right:n,bottom:r},this.sizes.diff={x:this.sizes.viewport.width-this.sizes.target.width,y:this.sizes.viewport.height-this.sizes.target.height},this.sizes.offset={left:this.sizes.viewport.left-this.sizes.target.left,right:this.sizes.viewport.right-this.sizes.target.right,top:this.sizes.viewport.top-this.sizes.target.top,bottom:this.sizes.viewport.bottom-this.sizes.target.bottom},this.getViewRange(t)}getViewRange(t){let e=t||C.get(this.targetEl,["translate"]).translate;this.viewRange={x:[e.x+this.sizes.offset.left,e.x+this.sizes.offset.right].sort(),y:[e.y+this.sizes.offset.top,e.y+this.sizes.offset.bottom].sort()}}getDmpVals(t){let e=this.options.viewport.dmpRatio**2;return this.options.viewport.bouncy?t*e:t}getBounceVals(t){let e=t.x,s=t.y;return e<this.viewRange.x[0]?e+=this.getDmpVals(this.viewRange.x[0]-e):e>this.viewRange.x[1]&&(e+=this.getDmpVals(this.viewRange.x[1]-e)),s<this.viewRange.y[0]?s+=this.getDmpVals(this.viewRange.y[0]-s):s>this.viewRange.y[1]&&(s+=this.getDmpVals(this.viewRange.y[1]-s)),{x:~~e,y:~~s}}getViewLimitVals(t){return{x:clampVal({val:t.x,min:this.viewRange.x[0],max:this.viewRange.x[1]}),y:clampVal({val:t.y,min:this.viewRange.y[0],max:this.viewRange.y[1]})}}getAutoDur(t,e){return Math.abs(t-e)/3+200}rebound(t){let e,s=t||this.nowVals.translate,i=!1;s.x<this.viewRange.x[0]?(e=this.getAutoDur(this.viewRange.x[0],s.x),s.x=this.viewRange.x[0],i=!0):s.x>this.viewRange.x[1]&&(e=this.getAutoDur(this.viewRange.x[1],s.x),s.x=this.viewRange.x[1],i=!0),s.y<this.viewRange.y[0]?(e=this.getAutoDur(this.viewRange.y[0],s.y),s.y=this.viewRange.y[0],i=!0):s.y>this.viewRange.y[1]&&(e=this.getAutoDur(this.viewRange.y[1],s.y),s.y=this.viewRange.y[1],i=!0),i&&(this.targetEl.style.transitionDuration=`${this.options.viewport.duration||e}ms`,C.set({el:this.targetEl,data:{translate:{x:s.x,y:s.y}}}))}reset(t){return this.targetEl.style.transform=this.initialVals,super.listen({name:"reset",cb:t}),this}destroy(t){if(this.destroyed)return this;if(this.setCompleted(),this.targetEl.removeEventListener("pointerdown",this.triggerFn),this.targetEl.removeEventListener("transitionend",this.transitionendFn),s.isTouchScr)if(this.handleEls.length)for(let t of this.handleEls)t.removeEventListener("touchstart",this.preventDft);else this.targetEl.removeEventListener("touchstart",this.preventDft);return this.removeSecondEvents(),s.isTouchScr||(this.options.wheel&&this.targetEl.removeEventListener(this.scrollObj.event,this.wheelFn),this.options.keyboard.enable&&window.removeEventListener("keydown",this.keyboardFn),this.options.click.hold2Menu&&this.targetEl.removeEventListener("contextmenu",this.menuFn),this.spyIns&&this.spyIns.destroy()),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}class Dialog extends ModBaseListenCacheBubble{options={};timestamp;bubbleType;parentEl;lastPlace;lastSize;lastPlacement;gestureIns;wrapSize;confirmEl;cancelEl;closeEl;triggerShow;content;aniIn;aniOut;addPulseAnim;removePulseAnim;static optMaps=I;constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Dialog.optMaps,component:!0,spread:["mask","tools","padding","footer","autoFill","bullet"]}),this.bubbleType="dialog",this.timestamp=Date.now();let a=this;this.triggerShow=function(t){if(this===a.targetEl&&a.options.canClick){let e=getEvtTarget(t);if(!a.options.canClick.call(a,e,t))return}"hidden"===a.state?(a.show(),a.options.wing.actClass&&a.wings.includes(this)&&this.classList.add(a.options.wing.actClass)):"shown"===a.state&&!a.options.keepShow&&a.hide()},this.triggerClose=()=>{!this.options.keepShow&&this.hide()},this.addPulseAnim=()=>{this.mainEl.classList.add(`${s.prefix}pulseShow`)},this.removePulseAnim=()=>{this.mainEl.classList.remove(`${s.prefix}pulseShow`)},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.parentEl=getEl(this.options.parent)||document.body,this.options.placement=this.options.placement||"center",this.setFeature(),this.wings=getEls(this.options.wing.selector),this.renderBubble("dialog"),this.setAttrs(),this.fixAni(this.options.placement),await getContent.call(this,{content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.contEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:t=>{this.renderContent(t)}}),this.lastPlace="",this.handleFooter(),this.handleTools(),this.bindTrigger(),this.setDraggable(),this.contEl.querySelectorAll(`[${s.alias}="closebubble"]`).forEach((t=>{t.removeEventListener("click",this.triggerClose),t.addEventListener("click",this.triggerClose,!1)})),["confirm","alert"].includes(this.options.feature)&&(this.removePulseEvt(),this.addPulseEvt()),this.initBullets(),super.listen({name:"initiated",cb:t}),this}setFeature(){if(this.options.feature){if(["alert","prompt","notice"].includes(this.options.feature)&&(this.options.footer.layout="right"),["prompt","notice"].includes(this.options.feature)&&(this.options.mask.enable=!1),["confirm","alert","prompt"].includes(this.options.feature)){this.options.mask.closable=!1,this.options.placement="center-top",this.options.padding.value=`${s.prefix}p-md`,this.options.in="fadeInDown",this.options.out="fadeOutDown",this.options.tools.enable=!1;let t=Dialog.optMaps.find((t=>"footer"===t.prop)).value.children.toString()==this.options.footer.children.toString();"alert"===this.options.feature?t&&(this.options.footer.children=["confirm"]):"prompt"===this.options.feature&&t&&(this.options.footer.children=["close","clear","confirm"])}"notice"===this.options.feature&&(this.options.placement="left-bottom")}}addPulseEvt(){this.maskEl.addEventListener("click",this.addPulseAnim,!1),this.mainEl.addEventListener("animationend",this.removePulseAnim,!1)}removePulseEvt(){this.maskEl.removeEventListener("click",this.addPulseAnim),this.mainEl.removeEventListener("animationend",this.removePulseAnim)}fixAni(t){this.aniIn="max"===t&&"slideDown"===this.options.in?"fadeIn":this.options.in,this.aniOut="max"===t&&"slideUp"===this.options.out?"fadeOut":this.options.out}handleTools(){this.options.tools.enable&&this.options.tools.children.forEach((t=>{t.wrapEl.querySelector(`[${s.alias}="icon"]`),"close"===t.name?t.wrapEl.onclick=()=>{this.hide()}:"widen"===t.name?t.wrapEl.onclick=()=>{"max"===this.lastSize?(classes(t.iconEl).replace(t.icon,t.swap),this.mainEl.setAttribute("size",this.options.size),this.lastSize=this.options.size):(classes(t.iconEl).replace(t.swap,t.icon),this.mainEl.setAttribute("size","max"),this.lastSize="max")}:"enlarge"===t.name?t.wrapEl.onclick=()=>{"center-max"===this.lastPlacement?(classes(t.iconEl).replace(t.icon,t.swap),this.mainEl.setAttribute("placement",this.options.placement),this.lastPlacement=this.options.placement):(classes(t.iconEl).replace(t.swap,t.icon),this.mainEl.setAttribute("placement","center-max"),this.lastPlacement="center-max")}:t.action&&t.action.call(this,t)}))}setAttrs(){if(this.options.classes&&classes(this.mainEl).add(this.options.classes),this.options.size?this.mainEl.setAttribute("size",this.options.size):this.mainEl.removeAttribute("size"),this.options.contType?this.mainEl.setAttribute("conttype",this.options.contType):this.mainEl.removeAttribute("conttype"),this.contEl.toggleAttribute("dedicated",this.options.dedicated),this.options.placement?this.mainEl.setAttribute("placement",this.options.placement):this.mainEl.removeAttribute("placement",this.options.placement),this.options.zIndex?addStyle(this.mainEl,"z-index",this.options.zIndex):removeStyle(this.mainEl,"z-index"),this.options.tools.enable?this.mainEl.setAttribute("toolsplace",this.options.tools.placement):this.mainEl.removeAttribute("toolsplace"),this.options.feature?this.mainEl.setAttribute("feature",this.options.feature):this.mainEl.removeAttribute("feature"),this.parentEl!==document.body){let t=style(this.parentEl);"static"===t.position&&addStyle(this.parentEl,"position","relative"),"hidden"!==t.overflow&&addStyle(this.parentEl,"overflow","hidden"),this.mainEl.toggleAttribute("restrict",!0)}else this.mainEl.removeAttribute("restrict")}setDraggable(){this.headEl&&this.options.draggable&&(this.gestureIns=new Gesture(this.wrapEl,extend({target:{viewport:{enable:!0,selector:this.parentEl},translate:{target:this.headEl},onTranslate:()=>{this.wrapEl.style.animationName="none"},onTranslating:t=>{C.set({el:this.wrapEl,data:{translate:t.translate.value}})}},source:this.options.gesture})))}bindTrigger(){"click"===this.options.trigger?(this.targetEl&&!this.canTrigger&&(this.targetEl.removeEventListener("click",this.triggerShow),this.targetEl.addEventListener("click",this.triggerShow,!1)),this.wings.length>0&&!this.canTrigger&&this.wings.forEach((t=>{t.removeEventListener("click",this.triggerShow),t.addEventListener("click",this.triggerShow,!1)}))):"sticky"===this.options.trigger&&this.show(),this.maskEl&&this.options.mask.closable&&(this.maskEl.removeEventListener("click",this.triggerShow),this.maskEl.addEventListener("click",this.triggerShow,!1)),this.canTrigger=!0}unbindTrigger(t="host"){this.canTrigger=!1,"click"===this.options.trigger&&(this.targetEl.removeEventListener("click",this.triggerShow),this.wings.length>0&&"all"===t&&this.wings.forEach((t=>{t.removeEventListener("click",this.triggerShow)}))),this.maskEl&&this.options.mask.closable&&"all"===t&&this.maskEl.removeEventListener("click",this.triggerShow)}toggleHide(){let t=h.data.filter((t=>t.ins!==this&&"dialog"===t.type&&!t.ins.destroyed&&"shown"===t.ins.state&&t.ins.parentEl===this.parentEl));for(let e of t)e.ins.hide()}async show(t){return this.destroyed||"hidden"!==this.state||this.options.asleep||(this.state="ing",this.options.b4Show&&await this.options.b4Show.call(this),elState(this.mainEl).isVirtual&&this.parentEl.appendChild(this.mainEl),super.listen({name:"show",cb:t}),this.wrapHeight=parseInt(style(this.wrapEl).height),requestAnimationFrame((async()=>{super.getDuration(),this.wrapEl.style.transitionDuration=`${this.duration}ms`,this.targetEl&&this.targetEl.classList.add(this.options.actClass),"slideDown"===this.aniIn?easeHeight({el:this.wrapEl,height:this.wrapHeight,type:"down",duration:this.duration,unaware:!1}):(this.options.duration&&(this.wrapEl.style.animationDuration=`${this.options.duration}ms`),this.aniIn&&(this.wrapEl.style.animationName=s.prefix+this.aniIn)),!this.options.multiple&&this.toggleHide(),this.lastShowTime=Date.now(),this.mainEl.toggleAttribute("show",!0),await delay({duration:this.duration,done:()=>{this.state="shown",super.listen({name:"shown",cb:t})}})}))),this}async hide(t){if(this.destroyed||"shown"!==this.state)return this;if(this.state="ing",!this.options.deadShow){this.options.b4Hide&&await this.options.b4Hide.call(this),super.listen({name:"hide",cb:t}),this.targetEl&&this.targetEl.classList.remove(this.options.actClass),this.options.wing.actClass&&this.wings.map((t=>{t.classList.remove(this.options.wing.actClass)})),this.maskEl&&(this.maskEl.style.opacity=0),"slideUp"===this.aniOut?easeHeight({el:this.wrapEl,height:this.wrapHeight,type:"up",duration:this.duration,unaware:!1}):this.aniOut&&(this.wrapEl.style.animationName=s.prefix+this.aniOut);for(let t of getEls("video,audio",this.mainEl))t.pause();await delay({duration:this.duration,done:()=>{this.state="hidden",this.mainEl.removeAttribute("show"),this.maskEl&&this.maskEl.removeAttribute("style"),this.wrapEl.style.height=null,this.wrapEl.style.animationName=null,this.mainEl.remove(),super.listen({name:"hidden",cb:t}),this.options.heading&&!["fadeIn","slideDown"].includes(this.aniIn)&&this.options.heading&&C.remove({el:this.wrapEl,prop:"translate"})}})}return this}}const confirm=({content:t,contType:e,contData:s,tplStr:i,tplEng:a,heading:l,init:n,yes:r,no:o,dialog:h={}})=>{if(!isEmpty(t))return new Promise((p=>{new Dialog(null,deepMerge({content:t,contType:e,contData:s,heading:l,tplStr:i,tplEng:a,feature:"confirm",onInitiated:function(){n&&n(this)},onConfirmed:function(){r&&r(this),p(!0)},onCanceled:function(){o&&o(this),p(!1)}},h)).show()}))},alert=({content:t,contType:e,contData:s,heading:i,tplStr:a,tplEng:l,init:n,yes:r,dialog:o={}})=>{if(!isEmpty(t))return new Promise((h=>{new Dialog(null,deepMerge({content:t,contType:e,contData:s,heading:i,tplStr:a,tplEng:l,feature:"alert",onInitiated:function(){n&&n(this)},onConfirmed:function(){r&&r(this),h(!0)}},o)).show()}))},notice=({content:t,contType:e="",contData:s={},heading:i="",label:a="",tplStr:l,tplEng:n,init:r,yes:o,dialog:h={}})=>{if(!isEmpty(t))return new Promise((p=>{new Dialog(null,deepMerge({content:t,contType:e,contData:s,heading:i,tplStr:l,tplEng:n,feature:"notice",footer:{children:[{name:"confirm",label:a}]},onInitiated:function(){r&&r(this)},onConfirmed:function(){o&&o(this),p(!0)}},h)).show()}))},prompt=t=>{let e=Object.assign({fields:[{type:"input"}]},t),i=Array.isArray(e.fields)?e.fields:[e.fields],a=document.createDocumentFragment(),l=e.insName?h.find(e.insName,"dialog"):null,getParams=t=>{let e=t.map((t=>({type:t.type,label:t.label,value:t.field.value})));return{value:e.map((t=>t.value)),fields:e}};if(l)return new Promise((t=>{l.off("confirmed"),l.on("confirmed",(()=>{let e=getParams(l.promptData);t(e)})),l.show()}));for(let t of i){let e=t.label?`<div class="${s.prefix}field-label">${t.label}</div>`:"",i=t.note?`<div  class="${s.prefix}field-note">${t.note}</div>`:"",l=Object.assign("upload"===t.type?{feature:"gallery"}:"datetime"===t.type?{display:"inline",footer:!1,"auto-fill":!0}:{},t.attrs),n=createEl(`ax-${t.type||"input"}`,{...l}),r=`\n            <section class="${s.prefix}field ${s.prefix}field-apart">\n                ${e}\n                <div class="${s.prefix}field-cont">\n                    <div class="${s.prefix}field-input"></div>\n                    ${i}\n                </div>\n            </section>\n        `,o=tplToEl(r);o.querySelector(`.${s.prefix}field-input`).appendChild(n),a.appendChild(o),t.field=n}return new Promise((t=>{l=new Dialog(null,deepMerge({insName:e.insName,heading:e.heading,size:"lg",feature:"prompt",onInitiated:function(){this.contEl.appendChild(a),this.promptData=i},onConfirmed:function(){let s=getParams(this.promptData);e.yes&&e.yes(s),t(s),!e.insName&&(l=null)},onCleared:()=>{for(let t of i)t.field.clear()},onClosed:()=>{!e.insName&&(l=null)}},e.dialog)).show()}))},removeStyles=(t,e)=>{let s=getEl(t);if(s&&!isEmpty(e))for(let t of e)removeStyle(s,t)},addStyles=(t,e)=>{let s=getEl(t);if(s&&!isEmpty(e))for(let t of Array.isArray(e)?e:[e])addStyle(s,t.key,t.value)},regComp=t=>{if(!t||"Class"!==getDataType(t))return;let reg=t=>window.customElements.define(`ax-${t.name.replace("Elem","").toLowerCase()}`,t);if(t.dependencies&&t.dependencies?.length)for(let e of t.dependencies)try{reg(e.comp)}catch{}try{reg(t)}catch{}},promiseRaf=t=>isEmpty(t)?Promise.resolve():new Promise((e=>{requestAnimationFrame((()=>{t(),e()}))})),setRtl=(t=!0)=>{let e=document.documentElement;t?(e.setAttribute("dir","rtl"),s.rtl=!0):(e.removeAttribute("dir"),Reflect.deleteProperty(s,"rtl"))},isChildVisible=(t,e)=>{let s=getEl(t),i=getEl(e,s);if(!s||!i)return!1;let a=s.getBoundingClientRect(),l=i.getBoundingClientRect();return!(l.right<a.left||l.left>a.right||l.bottom<a.top||l.top>a.bottom)};let drawColor=({el:t,hue:e=0,mode:s="hsv",width:i,height:a})=>{let l=getEl(t);if(!l)return;let n,r=i,o=a;r&&o||(n=style(l)),i=toPixel(r||n.width),a=toPixel(o||n.height),r&&l.setAttribute("width",i),o&&l.setAttribute("height",a),e=360===e?0:e;let h=l.getContext("2d"),p=h.createImageData(i,a),d=p.data;for(let t=0;t<a;t++)for(let l=0;l<i;l++){let n,r,o,h=l/i,p=1-t/a;if("hsv"===s){let t=p*h,s=e/60,i=t*(1-Math.abs(s%2-1)),a=[0,0,0],l=p-t;s>=0&&s<1?a=[t,i,0]:s>=1&&s<2?a=[i,t,0]:s>=2&&s<3?a=[0,t,i]:s>=3&&s<4?a=[0,i,t]:s>=4&&s<5?a=[i,0,t]:s>=5&&s<6&&(a=[t,0,i]),n=Math.round(255*(a[0]+l)),r=Math.round(255*(a[1]+l)),o=Math.round(255*(a[2]+l))}else{let t=(1-Math.abs(2*p-1))*h,s=e/60,i=t*(1-Math.abs(s%2-1)),a=[0,0,0],l=p-t/2;s>=0&&s<1?a=[t,i,0]:s>=1&&s<2?a=[i,t,0]:s>=2&&s<3?a=[0,t,i]:s>=3&&s<4?a=[0,i,t]:s>=4&&s<5?a=[i,0,t]:s>=5&&s<6&&(a=[t,0,i]),n=Math.round(255*(a[0]+l)),r=Math.round(255*(a[1]+l)),o=Math.round(255*(a[2]+l))}let c=4*(t*i+l);d[c]=n,d[c+1]=r,d[c+2]=o,d[c+3]=255}return h.putImageData(p,0,0),h};const alpha2Hex=(t=0)=>"string"==typeof t?t:Math.round(255*t).toString(16).padStart(2,"0"),hex2Alpha=(t=0)=>"number"==typeof t?Math.max(0,Math.min(1,t)):(t=t.replace(/^#|0x/gi,"").trim())?(1===t.length&&(t+=t),Math.max(0,Math.min(1,parseInt(t,16)/255))):0,parseRgb=(t,e=!0)=>{let s={r:0,g:0,b:0};if(!(t=t.trim()).startsWith("rgb")&&!t.startsWith("RGB"))return s;let i=t.match(/(\d+\.?\d*)/g);return s.r=parseInt(i[0]),s.g=parseInt(i[1]),s.b=parseInt(i[2]),e&&(s.a=i[3]?parseFloat(i[3]):1),s},rgb2Hex=(t,e=!0)=>{let s="string"==typeof t?parseRgb(t):t,i=Math.max(0,Math.min(255,s.r)),a=Math.max(0,Math.min(255,s.g)),l=Math.max(0,Math.min(255,s.b)),n=void 0!==s.a?Math.max(0,Math.min(1,s.a)):1,r=alpha2Hex(n),o=`#${((1<<24)+(i<<16)+(a<<8)+l).toString(16).slice(1)}`;return e&&(o+=r),o},rgb2Hsl=(t,e=!0)=>{let s="string"==typeof t?parseRgb(t):t,i=s.r/255,a=s.g/255,l=s.b/255,n=Math.max(i,a,l),r=Math.min(i,a,l),o=0,h=0,p=(n+r)/2;if(n===r)o=h=0;else{const t=n-r;switch(h=p>.5?t/(2-n-r):t/(n+r),n){case i:o=(a-l)/t+(a<l?6:0);break;case a:o=(l-i)/t+2;break;case l:o=(i-a)/t+4}o/=6}let d={h:Math.round(360*o),s:Math.round(100*h),l:Math.round(100*p)};return e&&(d.a=s.a),d},rgb2Hwb=(t,e=!0)=>{let s="string"==typeof t?parseRgb(t):t,i=s.r/255,a=s.g/255,l=s.b/255,n=Math.max(i,a,l),r=Math.min(i,a,l),o=n-r,h=0;if(n===r)h=0;else{switch(n){case i:h=(a-l)/o+(a<l?6:0);break;case a:h=(l-i)/o+2;break;case l:h=(i-a)/o+4}h/=6}let p=r,d=1-n,c={h:Math.round(360*h),w:Math.round(100*p),b:Math.round(100*d)};return e&&(c.a=s.a),c},hwb2Rgb=(t,e=!0)=>{let s={};if("string"==typeof t){let e=t.match(/(\d+\.?\d*)/g);s.h=parseInt(e[0]),s.w=parseInt(e[1]),s.b=parseInt(e[2]),s.a=e[3]?parseFloat(e[3]):1}else s=t;let i=s.h,a=s.w/100,l=s.b/100,n=1-l-a,r=i/60,o=n*(1-Math.abs(r%2-1)),h=[0,0,0];if(n<=0){const t=1-l;h=[t,t,t]}else r>=0&&r<1?h=[n,o,0]:r>=1&&r<2?h=[o,n,0]:r>=2&&r<3?h=[0,n,o]:r>=3&&r<4?h=[0,o,n]:r>=4&&r<5?h=[o,0,n]:r>=5&&r<6&&(h=[n,0,o]),h[0]+=a,h[1]+=a,h[2]+=a;let p={r:Math.round(255*h[0]),g:Math.round(255*h[1]),b:Math.round(255*h[2])};return p.r=Math.max(0,Math.min(255,p.r)),p.g=Math.max(0,Math.min(255,p.g)),p.b=Math.max(0,Math.min(255,p.b)),e&&(p.a=s.a),p},hsl2Rgb=(t,e=!0)=>{let s={};if("string"==typeof t){let e=t.match(/(\d+\.?\d*)/g);s.h=parseInt(e[0]),s.s=parseInt(e[1]),s.l=parseInt(e[2]),s.a=e[3]?parseFloat(e[3]):1}else s=t;let i=s.h,a=s.s/100,l=s.l/100,n=(1-Math.abs(2*l-1))*a,r=i/60,o=n*(1-Math.abs(r%2-1)),h=[0,0,0],p=l-n/2;r>=0&&r<1?h=[n,o,0]:r>=1&&r<2?h=[o,n,0]:r>=2&&r<3?h=[0,n,o]:r>=3&&r<4?h=[0,o,n]:r>=4&&r<5?h=[o,0,n]:r>=5&&r<6&&(h=[n,0,o]);let d={r:Math.round(255*(h[0]+p)),g:Math.round(255*(h[1]+p)),b:Math.round(255*(h[2]+p))};return e&&(d.a=s.a),d},hex2Rgb=(t,e=!0)=>{let s,i={r:0,g:0,b:0};if(t?.hasOwnProperty("hex")?s=(t=t.hex).a:t=t.trim(),"string"!=typeof t||!t.startsWith("#")||t.length>9)return i;let a=t.substring(1);3!==a.length&&4!==a.length||(a=a.split("").map((t=>t+t)).join("")),i.r=parseInt(a.substring(0,2),16),i.g=parseInt(a.substring(2,4),16),i.b=parseInt(a.substring(4,6),16);let l=t?.hasOwnProperty("hex")?s:a.substring(6,8);return e&&(i.a=l?hex2Alpha(l):1),i},hwb2Hsl=(t,e=!0)=>{let s={h:0,w:0,b:0,a:1};if("string"==typeof t){let e=t.match(/(\d+\.?\d*)/g);s.h=parseFloat(e[0]),s.w=parseFloat(e[1]),s.b=parseFloat(e[2]),s.a=e[3]?parseFloat(e[3]):1}else s=t;let i=s.h,a=s.w/100,l=s.b/100,n=1-a-l,r=i/60,o=n*(1-Math.abs(r%2-1)),h=[0,0,0],p=1-l;n<=0?h=[p,p,p]:(r>=0&&r<1?h=[n,o,0]:r>=1&&r<2?h=[o,n,0]:r>=2&&r<3?h=[0,n,o]:r>=3&&r<4?h=[0,o,n]:r>=4&&r<5?h=[o,0,n]:r>=5&&r<6&&(h=[n,0,o]),h[0]+=a,h[1]+=a,h[2]+=a);let d=h[0],c=h[1],u=h[2],g=Math.max(d,c,u),m=Math.min(d,c,u),b=(g+m)/2,E=g-m,f=0;0!==E&&(f=E/(1-Math.abs(2*b-1)));let v={h:i,s:~~(100*f),l:~~(100*b)};return e&&(v.a=s.a),v},hsl2Hwb=(t,e=!0)=>{let s={h:0,s:0,l:0,a:1};if("string"==typeof t){let e=t.match(/(\d+\.?\d*)/g);s.h=parseFloat(e[0]),s.s=parseFloat(e[1]),s.l=parseFloat(e[2]),s.a=e[3]?parseFloat(e[3]):1}else s=t;let i=s.h,a=s.s/100,l=s.l/100,n=(1-Math.abs(2*l-1))*a,r=i/60,o=n*(1-Math.abs(r%2-1)),h=[0,0,0];r>=0&&r<1?h=[n,o,0]:r>=1&&r<2?h=[o,n,0]:r>=2&&r<3?h=[0,n,o]:r>=3&&r<4?h=[0,o,n]:r>=4&&r<5?h=[o,0,n]:r>=5&&r<6&&(h=[n,0,o]);let p=l-n/2,d=h[0]+p,c=h[1]+p,u=h[2]+p,g={h:i,w:~~(100*Math.min(d,c,u)),b:~~(100*(1-Math.max(d,c,u)))};return e&&(g.a=s.a),g};class ModBaseListenCacheNest extends ModBaseListenCache{flatData;treeData;treeInputEl;check(t,e){}updateArrowEl(t){}eachCollapse(t){}eachExpand(t){}initCheckeds(){if(!this.options.check.enable)return;let t=valToArr(this.options.check.value).map((t=>findItem(t,this.flatData))).filter(Boolean),e=this.flatData.filter((t=>attrValBool(t.checked)));for(let t of e)t.checked=!1;this.check([...e,...t])}initReadonlys(){this.readonly(valToArr(this.options.readonly))}initDisableds(){this.disable(valToArr(this.options.disable))}getReadonlys(){return(this.flatData||this.treeData).filter((t=>attrValBool(t.readonly)))}getDisableds(){return(this.flatData||this.treeData).filter((t=>attrValBool(t.disabled)))}getExpandeds(){return(this.flatData||this.treeData).filter((t=>attrValBool(t.expanded)))}getCheckeds(){return(this.flatData||this.treeData).filter((t=>attrValBool(t.checked)))}getUncheckeds(){return(this.flatData||this.treeData).filter((t=>!attrValBool(t.checked)))}getArrowEl(t){this.options.arrow.enable&&(t.arrowEl=createEl("i",{[s.alias]:"arrow"}),this.updateArrowEl(t))}toggleArrow(t,e){let s=attrValBool(t),i=s?{new:"show",old:"hide",action:"add"}:{new:"hide",old:"show",action:"remove"};e.headEl.toggleAttribute("expanded",s),"image"===this.options.arrow.type?e.arrowEl.style.backgroundImage=`url("${this.options.arrow[i.new]}")`:this.options.arrow.show===this.options.arrow.hide?e.arrowEl.classList[i.action](this.options.arrow.anim):classes(e.arrowEl).replace(this.options.arrow[i.old],this.options.arrow[i.new])}async collapse(t,e){if(this.destroyed)return;let s=Array.isArray(t)?t:[t];for(let t of s)await this.eachCollapse(t);return e&&e.call(this,this.getExpandeds()),this}async expand(t,e){if(this.destroyed)return;let s=Array.isArray(t)?t:[t];for(let t of s)await this.eachExpand(t);return e&&e.call(this,this.getExpandeds()),this}collapseAll(t){if(!this.destroyed){for(let t of this.getExpandeds())this.eachCollapse(t);return this.listen({name:"collapsedAll",cb:t}),this}}expandAll(t){if(!this.destroyed){for(let t of this.flatData)!attrValBool(t.expanded)&&this.eachExpand(t);return this.listen({name:"expandedAll",cb:t}),this}}lock(t){if(!this.destroyed&&this.targetEl)return this.targetEl.toggleAttribute("inert",!0),this.destroyed=!0,this.treeInputEl.disabled=!0,this.listen({name:"locked",cb:t}),this}unlock(t){if(this.targetEl)return this.targetEl.toggleAttribute("inert",!1),this.destroyed=!1,this.treeInputEl.disabled=!1,this.listen({name:"unlocked",cb:t}),this}readonly(t,e){if(this.destroyed)return;let s=(isNull(t)?this.flatData:Array.isArray(t)?t:[t]).map((t=>findItem(t,this.flatData))).filter(Boolean);for(let t of s)t.readonly=!0;return this.listen({name:"readonly",cb:e,params:[s]}),this}readonlyAll(t){if(!this.destroyed){for(let t of this.flatData)t.readonly=!0;return this.listen({name:"readonlyAll",cb:t}),this}}disable(t,e){if(this.destroyed)return;let s=(isNull(t)?this.flatData:Array.isArray(t)?t:[t]).map((t=>findItem(t,this.flatData))).filter(Boolean);for(let t of s)t.disabled=!0;return this.listen({name:"disabled",cb:e,params:[s]}),this}disableAll(t){if(!this.destroyed){for(let t of this.flatData)t.disabled=!0;return this.listen({name:"disabledAll",cb:t}),this}}enable(t,e){if(this.destroyed)return;let s=(isNull(t)?this.flatData:Array.isArray(t)?t:[t]).map((t=>findItem(t,this.flatData))).filter((t=>t&&(attrValBool(t.disabled)||attrValBool(t.readonly))));for(let t of s)t.hasOwnProperty("disabled")&&(t.disabled=!1),t.hasOwnProperty("readonly")&&(t.readonly=!1);return this.listen({name:"enabled",cb:e,params:[s]}),this}enableAll(t){if(!this.destroyed)return this.enable(this.flatData),this.listen({name:"enabledAll",cb:t}),this}toggleCheck(t){attrValBool(t.checked)?this.check(t,!1):this.check(t,!0)}uncheckAll(t){if(!this.destroyed&&this.options.check.enable){for(let t of this.flatData)t.checked=!1;return this.listen({name:"uncheckedAll",cb:t}),this}}getSiblings(t){return this.flatData.filter((e=>e.pId==t.pId&&e!==t))}updateElCont(t,e,s="brief"){let i="content"===s?"cont":s,a=isNull(e)?t[s]:e;getDataType(a).includes("HTML")?(t[i+"El"].innerHTML="",t[i+"El"].appendChild(a)):t[i+"El"].innerHTML=a}async getElCont({target:t,data:e={},prop:s="brief",cb:i}){let a="content"===s?"contEl":`${s}El`;await getContent.call(this,{content:e?.content||t[s],contType:e?.contType||"text",contData:e?.contData||{...t},ajax:{xhrName:"contXhr",target:t[a],...e?.ajax||{}},request:t=>{this.listen({name:"request",params:[t]})},cb:async a=>{let l=["Array","Object"].includes(getDataType(a))?{...t,[s]:a}:a;setContent({content:l,template:e?.tplStr||this.tplStr,engine:e?.tplEng||this.tplEng,prevent:e=>{i&&i(e,t)}})}})}async setElCont({item:t,data:e={},prop:s="brief",cb:i}){let a=findItem(t,this.flatData);a&&(elState(a.bodyEl).isVirtual&&a.headEl.insertAdjacentElement("afterend",a.bodyEl),await this.getElCont({target:a,data:e,cb:t=>{a[s]===t?this.updateElCont(a,t,s):(a[s]=t,!isProxy(a)&&this.updateElCont(a,t,s)),i&&i(t,a)}}))}}const M=[{attr:"stor-keys",prop:"storKeys",value:["content","length","folded"]},{attr:"content",prop:"content",value:""},{attr:"length",prop:"length",value:60},{attr:"folded",prop:"folded",value:!0},{attr:"text-fold",prop:"textFold",value:l.lang.more.fold},{attr:"text-unfold",prop:"textUnfold",value:l.lang.more.unfold},{attr:"class-fold",prop:"classFold",value:`${s.prefix}c-prim`},{attr:"class-unfold",prop:"classUnfold",value:`${s.prefix}c-prim`},{attr:"on-fold",prop:"onFold",value:null},{attr:"on-unfold",prop:"onUnfold",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},...p];class More extends ModBaseListenCache{options={};intercepted;button;content;folded;handlers;html;pureHtml;event;text;ell;static hostType="node";static optMaps=M;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:More.optMaps,host:t,component:!0}),this.content="",super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.folded=this.options.folded,this.getPureContent(),this.targetEl.innerHTML=this.content,this.setAttrs(),this.content.length>this.options.length&&(this.intercepted=this.content.substring(0,this.options.length)+"...",this.button=createEl("i"),this.targetEl.appendChild(this.button),this.toggle(this.folded?"fold":"unfold"),this.button.onclick=()=>{this.folded?this.toggle("unfold"):this.toggle("fold")}),super.listen({name:"initiated",cb:t}),this}setAttrs(){}toggle(t){"unfold"===t?(this.targetEl.removeChild(this.button.previousSibling),this.button.innerHTML=this.options.textUnfold,this.button.setAttribute("class",this.options.classUnfold),this.button.insertAdjacentHTML("beforeBegin",this.content),super.listen({name:"unfold"}),this.folded=!1):"fold"===t&&(this.targetEl.removeChild(this.button.previousSibling),this.button.innerHTML=this.options.textFold,this.button.setAttribute("class",this.options.classFold),this.button.insertAdjacentHTML("beforeBegin",this.intercepted),super.listen({name:"fold"}),this.folded=!0),super.updateCache({folded:this.folded})}getPureContent(){this.options.content&&"string"==typeof this.options.content?this.content=super.getStrFromContent(this.options.content):this.content=this.rawHtml?this.rawHtml:this.targetEl.innerHTML,this.content=purifyHtml(this.content)}destroy(t){return this.destroyed||(this.button.onclick=null,this.clearCache(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}async updateCont(t,e){return this.destroyed||(this.options.content=t,await this.init(),super.updateCache({content:this.content}),super.listen({name:"updatedCont",cb:e,params:[this.content]})),this}}const V=[{attr:"enable",prop:"enable",value:!0},{attr:"placement",prop:"placement",value:"top-center"},{attr:"arrow",prop:"arrow",value:{enable:!0,size:"0.5rem",offset:"2.8rem",gap:".8rem"}},{attr:"parent-mutation",prop:"parentMutation",value:{enable:!0,selector:"",options:{attributes:!0,characterData:!0,childList:!0,subtree:!0}}},{attr:"target-obs",prop:"targetObs",value:{enable:!0,attrs:["class"],size:!0}},{attr:"bubble-obs",prop:"bubbleObs",value:{enable:!0,attrs:["class"],size:!0}},{attr:"delay",prop:"delay",value:20},{attr:"on-transferred",prop:"onTransferred",value:null},{attr:"on-reposition",prop:"onReposition",value:null},...p];class Position extends ModBaseListen{options={};bubbleEl;arrowEl;gap;parent;placement;observerCount;completeCount;trigger;targetAttrsObs;targetSizeObs;bubbleAttrsObs;bubbleSizeObs;parentObs;bubbleData;browserData;bodyData;regularPlaces;specialPlaces;places;timer;fullGap;static hostType="none";static optMaps=V;constructor(t,e,s={},i=l.initial){if(super(),super.ready({type:Position.hostType,options:s,host:t,maps:Position.optMaps,spread:["arrow","parentMutation","targetObs","bubbleObs"]}),this.targetEl=getEl(t),this.bubbleEl=getEl(e),!this.targetEl||!this.bubbleEl)throw new Error("The host element and guest element must be exist!");this.gap=toPixel(this.options.arrow.gap);let a=getEl(this.options.parentMutation.selector);this.parent=this.options.parentMutation.enable&&a?a:null,this.regularPlaces=["left-start","left-center","left-end","right-start","right-center","right-end","top-start","top-center","top-end","bottom-start","bottom-center","bottom-end"],this.specialPlaces=["left-max","right-max","top-max","bottom-max","center","center-max"],this.places=[...this.regularPlaces,...this.specialPlaces],this.trigger=debounce((()=>{let t=elState(this.bubbleEl);if(t.isVirtual||!t.isVisible||t.isUncalc)return;let e=elState(this.targetEl);e.isVirtual||!e.isVisible||e.isUncalc||this.resetPlacement()}),this.options.delay),this.targetAttrsObs=new MutationObserver((t=>{for(let e of t)this.options.targetObs.attrs.includes(e.attributeName)&&this.trigger()})),this.targetSizeObs=new ResizeObserver((()=>{this.trigger()})),this.bubbleAttrsObs=new MutationObserver((t=>{for(let e of t)this.options.bubbleObs.attrs.includes(e.attributeName)&&this.trigger()})),this.bubbleSizeObs=new ResizeObserver((()=>{this.trigger()})),this.parentObs=new MutationObserver((()=>{!this.unsettable("target")&&this.targetData&&(offset(this.targetEl).left===this.targetData.left&&offset(this.targetEl).top===this.targetData.top||this.trigger())})),super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.placement=this.correctPlace(this.options.placement),this.places.includes(this.placement)?(this.options.placement=this.placement,!["center","center-max"].includes(this.placement)&&this.createArrow(),this.setAttrs(),this.resetPlacement(),this.options.enable&&this.setObs(),super.listen({name:"initiated",cb:t}),this):this}setObs(){window.addEventListener("resize",this.trigger),window.addEventListener("scroll",this.trigger),this.options.targetObs.enable&&(this.options.targetObs.attrs.length>0&&this.targetAttrsObs.observe(this.targetEl,{attributes:!0}),this.options.targetObs.size&&this.targetSizeObs.observe(this.targetEl)),this.options.bubbleObs.enable&&(this.options.bubbleObs.attrs.length>0&&this.bubbleAttrsObs.observe(this.bubbleEl,{attributes:!0}),this.options.bubbleObs.size&&this.bubbleSizeObs.observe(this.bubbleEl)),this.parent&&this.parentObs.observe(this.parent,this.options.parentMutation.options)}removeObs(){this.options.targetObs.enable&&(this.options.targetObs.attrs.length>0&&this.targetAttrsObs.disconnect(),this.options.targetObs.size&&this.targetSizeObs.disconnect()),this.options.bubbleObs.enable&&(this.options.bubbleObs.attrs.length>0&&this.bubbleAttrsObs.disconnect(),this.options.bubbleObs.size&&this.bubbleSizeObs.disconnect()),this.parent&&this.parentObs.disconnect(),window.removeEventListener("resize",this.trigger),window.removeEventListener("scorll",this.trigger)}correctPlace(t){return"left"===t?"left-center":"right"===t?"right-center":"top"===t?"top-center":"bottom"===t?"bottom-center":"max"===t?"center-max":t}setAttrs(){this.bubbleEl.style.position=["center","center-max"].includes(this.placement)?"fixed":"absolute",this.setPlacementAttr()}setPlacementAttr(){this.bubbleEl.setAttribute("placement",this.placement)}createArrow(){this.options.arrow.enable&&(this.arrowEl=createEl("i",{style:"position:absolute",[s.alias]:"arrow"}),this.bubbleEl.appendChild(this.arrowEl))}setArrow(t){let[e,s,i,a]=["auto","auto","auto","auto"],l=this.targetData.width>this.bubbleData.width/2,n=this.targetData.height>this.bubbleData.height/2,r=toPixel(getComputedStyle(this.arrowEl).width)/2,o=toPixel(this.options.arrow.offset),h="";if(t.includes("top")||t.includes("bottom"))if(t.includes("max")){let t=this.targetData.offsetLeft+this.targetData.width/2,s=t<this.bubbleData.offsetLeft+o-r;e=t>this.bubbleData.offsetRight-o+r||s?"-10000px":this.targetData.offsetLeft-this.bubbleData.offsetLeft+this.targetData.width/2-r+"px"}else t.includes("start")?e=l?this.options.arrow.offset:Math.floor(this.targetData.width/2-r)+"px":t.includes("end")?s=l?this.options.arrow.offset:Math.floor(this.targetData.width/2-r)+"px":e=this.bubbleData.width/2-1-r+"px";else if(t.includes("left")||t.includes("right"))if(t.includes("max")){let t=this.targetData.offsetTop+this.targetData.height/2,e=t<this.bubbleData.offsetTop+o-r;i=t>this.bubbleData.offsetBottom-o+r||e?"-10000px":this.targetData.offsetTop-this.bubbleData.offsetTop+this.targetData.height/2-r+"px"}else t.includes("start")?i=n?this.options.arrow.offset:Math.floor(this.targetData.height/2-r)+"px":t.includes("end")?a=n?this.options.arrow.offset:Math.floor(this.targetData.height/2-r)+"px":i=this.bubbleData.height/2-1-r+"px";else e="-10000px",i="-10000px";t.includes("top")?(a="-"+this.options.arrow.size,h="45"):t.includes("bottom")?(i="-"+this.options.arrow.size,h="-135"):t.includes("left")?(s="-"+this.options.arrow.size,h="-45"):t.includes("right")&&(e="-"+this.options.arrow.size,h="135");let p=`left:${e};right:${s};top:${i};bottom:${a};transform:rotate(${h}deg);`;this.arrowEl.style.cssText+=p}getRectsData(){this.bodyData={width:document.body.offsetWidth,height:document.body.offsetHeight},this.browserData={width:document.documentElement.clientWidth,height:document.documentElement.clientHeight,scrollTop:document.documentElement.scrollTop||document.body.scrollTop,scrollLeft:document.documentElement.scrollLeft||document.body.scrollLeft};let t=this.targetEl.getBoundingClientRect();this.targetData={width:t.width,height:t.height,offsetLeft:t.left,offsetRight:t.right,offsetTop:t.top,offsetBottom:t.bottom,gapRight:this.browserData.width-t.right,gapBottom:this.browserData.height-t.bottom,...offset(this.targetEl)},this.getBubbleData()}getBubbleData(){let t=this.bubbleEl.getBoundingClientRect();this.bubbleData={width:t.width,height:t.height,offsetLeft:t.left,offsetRight:t.right,offsetTop:t.top,offsetBottom:t.bottom,gapRight:this.browserData.width-t.right,gapBottom:this.browserData.height-t.bottom}}setPlacement(t){let[e,i,a,l]=["auto","auto","auto","auto"],n="";t.includes("bottom")||t.includes("top")?t.includes("bottom")?(e="bottom"===t||"bottom-center"===t?this.targetData.left-(this.bubbleData.width-this.targetData.width)/2:"bottom-start"===t?this.targetData.left:"bottom-end"===t?this.targetData.left+this.targetData.width-this.bubbleData.width:0,a=`${toNumber(this.targetData.top+this.targetData.height+this.gap,{mode:"ceil"})}px`,e=`${toNumber(e,{mode:"ceil"})}px`):t.includes("top")&&(e="top"===t||"top-center"===t?this.targetData.left-(this.bubbleData.width-this.targetData.width)/2:"top-start"===t?this.targetData.left:"top-end"===t?this.targetData.left+this.targetData.width-this.bubbleData.width:0,l=`${toNumber(this.bodyData.height-this.targetData.top+this.gap,{mode:"ceil"})}px`,e=`${toNumber(e,{mode:"ceil"})}px`):(t.includes("left")||t.includes("right"))&&(t.includes("left")?("left"===t||"left-center"===t?a=`${toNumber(this.targetData.top-(this.bubbleData.height-this.targetData.height)/2,{mode:"ceil"})}px`:"left-start"===t?a=`${toNumber(this.targetData.top,{mode:"ceil"})}px`:"left-end"===t&&(l=`${toNumber(this.bodyData.height-this.targetData.top-this.targetData.height,{mode:"ceil"})}px`),i=`${toNumber(this.browserData.width-this.targetData.left+this.gap,{mode:"ceil"})}px`):t.includes("right")&&("right"===t||"right-center"===t?a=`${toNumber(this.targetData.top-(this.bubbleData.height-this.targetData.height)/2,{mode:"ceil"})}px`:"right-start"===t?a=`${toNumber(this.targetData.top,{mode:"ceil"})}px`:"right-end"===t&&(l=`${toNumber(this.bodyData.height-this.targetData.top-this.targetData.height,{mode:"ceil"})}px`),e=`${toNumber(this.targetData.left+this.targetData.width+this.gap,{mode:"ceil"})}px`)),"center-max"===this.placement?(n=`width:calc(100vw - ${s.fullGap}*2);height:calc(100vh - ${s.fullGap}*2);`,e=s.fullGap,a=s.fullGap):"center"===this.placement?(n=`margin-left:-${toNumber(this.bubbleEl.getBoundingClientRect().width/2,{mode:"ceil"})}px;margin-top:-${toNumber(this.bubbleEl.getBoundingClientRect().height/2,{mode:"ceil"})}px;`,e="50%",a="50%"):"top-max"===this.placement||"bottom-max"===this.placement?(e=`${toNumber(this.browserData.scrollLeft+toPixel(s.fullGap),{mode:"ceil"})}px`,n=`width:calc(100vw - ${s.fullGap}*2);`):"left-max"!==this.placement&&"right-max"!==this.placement||(a=`${toNumber(this.browserData.scrollTop+toPixel(s.fullGap),{mode:"ceil"})}px`,n=`height:calc(100vh - ${s.fullGap}*2);`),this.bubbleEl.style.cssText+=n+`left:${e};right:${i};top:${a};bottom:${l};`,this.getBubbleData(),this.arrowEl&&this.setArrow(t)}resetBubbleAttrs(){let t=this.bubbleEl.style.cssText.replace("margin-left:","").replace("margin-top:","").replace("width:","").replace("height:","")+";left:auto;right:auto;top:auto;bottom:auto;";this.bubbleEl.style.cssText=t,this.getBubbleData()}getSurroundGap(){let t=this.targetData.offsetLeft-this.bubbleData.width-this.gap,e=this.targetData.offsetTop-this.bubbleData.height-this.gap,s=this.browserData.width-this.targetData.offsetRight-this.bubbleData.width-this.gap,i=this.browserData.height-this.targetData.offsetBottom-this.bubbleData.height-this.gap,a=this.targetData.offsetTop,l=this.browserData.height-(a+this.bubbleData.height),n=this.targetData.offsetTop-(this.bubbleData.height-this.targetData.height)/2,r=this.browserData.height-(n+this.bubbleData.height),o=this.targetData.offsetBottom-this.bubbleData.height,h=this.browserData.height-this.targetData.offsetBottom,p=this.targetData.offsetLeft,d=this.browserData.width-(p+this.bubbleData.width),c=this.targetData.offsetLeft-(this.bubbleData.width-this.targetData.width)/2;return{left:t,right:s,top:e,bottom:i,start:{left:p,right:d,top:a,bottom:l},center:{left:c,right:this.browserData.width-(c+this.bubbleData.width),top:n,bottom:r},end:{left:this.targetData.offsetRight-this.bubbleData.width,right:this.browserData.width-this.targetData.offsetRight,top:o,bottom:h}}}fixPlacement(){if(this.targetData.gapRight>this.browserData.width||this.targetData.offsetLeft>this.browserData.width||["center","center-max"].includes(this.placement))return;let t=this.getSurroundGap();this.placement.includes("top")&&t.top<0&&t.bottom>=0?this.placement=this.placement.replace("top","bottom"):this.placement.includes("bottom")&&t.bottom<0&&t.top>=0?this.placement=this.placement.replace("bottom","top"):this.placement.includes("left")&&t.left<0&&t.right>=0?this.placement=this.placement.replace("left","right"):this.placement.includes("right")&&t.right<0&&t.left>=0&&(this.placement=this.placement.replace("right","left")),["left-max","right-max","top-max","bottom-max"].includes(this.placement)||((this.placement.includes("top")||this.placement.includes("bottom"))&&this.bubbleData.width<this.browserData.width&&(this.bubbleData.width>this.targetData.width?this.targetData.offsetLeft<0&&this.targetData.gapRight<this.browserData.width?this.placement=this.placement.replace("end","start").replace("center","start"):this.targetData.gapRight<0&&this.targetData.offsetLeft<this.browserData.width?this.placement=this.placement.replace("start","end").replace("center","end"):(t.end.left<0&&t.center.left<0?this.placement=this.placement.replace("end","start").replace("center","start"):t.end.left<0&&this.placement.includes("end")?this.placement=this.placement.replace("end","center"):t.end.left<0&&t.center.left>0&&this.placement.includes("start")&&(this.options.placement.includes("end")||this.options.placement.includes("center"))?this.placement=this.placement.replace("start","center"):t.end.left>0&&this.placement.includes("center")&&this.options.placement.includes("end")&&(this.placement=this.placement.replace("center","end")),t.start.right<0&&t.center.right<0?this.placement=this.placement.replace("start","end").replace("center","end"):t.start.right<0&&this.placement.includes("start")?this.placement=this.placement.replace("start","center"):t.start.right<0&&t.center.right>0&&this.placement.includes("end")&&(this.options.placement.includes("start")||this.options.placement.includes("center"))?this.placement=this.placement.replace("end","center"):t.start.right>0&&this.placement.includes("center")&&this.options.placement.includes("start")&&(this.placement=this.placement.replace("center","start"))):(t.start.left<0&&t.center.left<0?this.placement=this.placement.replace("start","end").replace("center","end"):t.start.left<0&&this.placement.includes("start")?this.placement=this.placement.replace("start","center"):t.start.left<0&&t.center.left>0&&this.placement.includes("end")&&(this.options.placement.includes("start")||this.options.placement.includes("center"))?this.placement=this.placement.replace("end","center"):t.start.left>0&&this.placement.includes("center")&&this.options.placement.includes("start")&&(this.placement=this.placement.replace("center","start")),t.end.right<0&&t.center.right<0?this.placement=this.placement.replace("end","start").replace("center","start"):t.end.right<0&&this.placement.includes("end")?this.placement=this.placement.replace("end","center"):t.end.right<0&&t.center.right>0&&this.placement.includes("start")&&(this.options.placement.includes("end")||this.options.placement.includes("center"))?this.placement=this.placement.replace("start","center"):t.end.right>0&&this.placement.includes("center")&&this.options.placement.includes("end")&&(this.placement=this.placement.replace("center","end")))),(this.placement.includes("left")||this.placement.includes("right"))&&this.bubbleData.height<this.browserData.height&&(this.bubbleData.height>this.targetData.height?this.targetData.offsetTop<0&&this.targetData.gapBottom<this.browserData.height?this.placement=this.placement.replace("end","start").replace("center","start"):this.targetData.gapBottom<0&&this.targetData.offsetTop<this.browserData.height?this.placement=this.placement.replace("start","end").replace("center","end"):(t.end.top<0&&t.center.top<0?this.placement=this.placement.replace("end","start").replace("center","start"):t.end.top<0&&this.placement.includes("end")?this.placement=this.placement.replace("end","center"):t.end.top<0&&t.center.top>0&&this.placement.includes("start")&&(this.options.placement.includes("end")||this.options.placement.includes("center"))?this.placement=this.placement.replace("start","center"):t.end.top>0&&this.placement.includes("center")&&this.options.placement.includes("end")&&(this.placement=this.placement.replace("center","end")),t.start.bottom<0&&t.center.bottom<0?this.placement=this.placement.replace("start","end").replace("center","end"):t.start.bottom<0&&this.placement.includes("start")?this.placement=this.placement.replace("start","center"):t.start.bottom<0&&t.center.bottom>0&&this.placement.includes("end")&&(this.options.placement.includes("start")||this.options.placement.includes("center"))?this.placement=this.placement.replace("end","center"):t.start.bottom>0&&this.placement.includes("center")&&this.options.placement.includes("start")&&(this.placement=this.placement.replace("center","start"))):(t.start.top<0&&t.center.top<0?this.placement=this.placement.replace("start","end").replace("center","end"):t.start.top<0&&this.placement.includes("start")?this.placement=this.placement.replace("start","center"):t.start.top<0&&t.center.top>0&&this.placement.includes("end")&&(this.options.placement.includes("start")||this.options.placement.includes("center"))?this.placement=this.placement.replace("end","center"):t.start.top>0&&this.placement.includes("center")&&this.options.placement.includes("start")&&(this.placement=this.placement.replace("center","start")),t.end.bottom<0&&t.center.bottom<0?this.placement=this.placement.replace("end","start").replace("center","start"):t.end.bottom<0&&this.placement.includes("end")?this.placement=this.placement.replace("end","center"):t.end.bottom<0&&t.center.bottom>0&&this.placement.includes("start")&&(this.options.placement.includes("end")||this.options.placement.includes("center"))?this.placement=this.placement.replace("start","center"):t.end.bottom>0&&this.placement.includes("center")&&this.options.placement.includes("end")&&(this.placement=this.placement.replace("center","end"))))),this.fullyExpose(t),this.setPlacementAttr()}fullyExpose(t){if(this.options.placement===this.placement||this.placement.includes("max"))return;let e=this.placement.split("-"),s=e[0],i=e[1];s=this.options.placement.includes("top")&&t.top>=0?"top":this.options.placement.includes("bottom")&&t.bottom>=0?"bottom":this.options.placement.includes("left")&&t.left>=0?"left":this.options.placement.includes("right")&&t.right>=0?"right":e[0],this.options.placement.includes("top")||this.options.placement.includes("bottom")?this.options.placement.includes("start")&&t.start[this.bubbleData.width>this.targetData.width?"right":"left"]>=0?i="start":this.options.placement.includes("end")&&t.end[this.bubbleData.width>this.targetData.width?"left":"right"]>=0?i="end":this.options.placement.includes("center")&&t.center.left>=0&&t.center.right>=0&&(i="center"):(this.options.placement.includes("left")||this.options.placement.includes("right"))&&(this.options.placement.includes("start")&&t.start[this.bubbleData.height>this.targetData.height?"bottom":"top"]>=0?i="start":this.options.placement.includes("end")&&t.end[this.bubbleData.height>this.targetData.height?"top":"bottom"]>=0?i="end":this.options.placement.includes("center")&&t.center.top>=0&&t.center.bottom>=0&&(i="center")),this.placement=`${s}-${i}`}unsettable(t){let e="target"===t?this.targetEl:this.bubbleEl;return elState(e).isUncalc}resetPlacement(t){if(this.destroyed||!this.places.includes(this.placement)||this.unsettable())return this;this.getRectsData(),this.resetBubbleAttrs(),this.fixPlacement(),this.setPlacement(this.placement),super.listen({name:"changed",cb:t,params:[this.placement]})}change(t,e){return this.destroyed?this:(t&&(this.placement=this.correctPlace(t)),this.places.includes(this.placement)?(this.options.placement=this.placement,this.setAttrs(),this.getRectsData(),this.resetBubbleAttrs(),this.setPlacement(this.placement),super.listen({name:"changed",cb:e,params:[this.placement]}),this):this)}transfer(t,e){if(!this.destroyed&&t)return this.targetEl=getEl(t),this.targetEl&&(this.resetPlacement(e),super.listen({name:"transferred",cb:e,params:[this.targetEl]})),this}destroy(t){if(!this.destroyed)return this.removeObs(),this.trigger.cancel(),this.destroyed=!0,super.listen({name:"destroyed",cb:t,params:[this.placement]}),this}}const R=[{attr:"timeout",prop:"timeout",value:50},{attr:"intvl",prop:"intvl",value:50},{attr:"throttle",prop:"throttle",value:200},{attr:"threshold",prop:"threshold",value:7},{attr:"hold",prop:"hold",value:""},{attr:"on-move",prop:"onMove",value:null},{attr:"on-enter",prop:"onEnter",value:null},{attr:"on-leave",prop:"onLeave",value:null},...p];class Hover extends ModBaseListen{options={};curX;curY;preX;preY;isActive;enterTimer;leaveTimer;eventToggle;holdEl;enterCompare;globalEvent;moveEvent;enterEvent;leaveEvent;enterHold;leaveHold;static hostType="node";static optMaps=R;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Hover.optMaps,host:t}),this.curX,this.curY,this.preX,this.preY,this.enterTimer,this.leaveTimer,this.isActive=!1,this.holdEl=getEl(this.options.hold),this.eventToggle=(t,e,s)=>{let i={event:s,target:e};"enter"===t?(this.isActive=!0,super.listen({name:"enter",params:[{...i,inside:!0,name:"enter"}]})):"leave"===t&&(this.isActive=!1,super.listen({name:"leave",params:[{...i,inside:!1,name:"leave"}]}))},this.enterCompare=(t,e)=>{let s=this.preX-this.curX,i=this.preY-this.curY;Math.sqrt(s**2+i**2)<this.options.threshold?this.isActive||this.eventToggle("enter",t,e):(this.preX=this.curX,this.preY=this.curY,this.enterTimer=setTimeout((()=>{this.enterCompare(t,e)}),this.options.intvl))},this.globalEvent=throttle((t=>{let e=contains(t.target,this.targetEl),s=!this.holdEl||contains(t.target,this.holdEl),i=e&&s;super.listen({name:"move",params:[{inside:i,event:t,name:"move",target:t.target}]})}),this.options.throttle),this.moveEvent=t=>{this.curX=t.pageX,this.curY=t.pageY},this.enterEvent=t=>{clearTimeout(this.leaveTimer),this.preX=t.pageX,this.preY=t.pageY,this.enterTimer=setTimeout((()=>{this.enterCompare(t.target,t)}),this.options.intvl)},this.leaveEvent=t=>{clearTimeout(this.enterTimer),this.leaveTimer=setTimeout((()=>{this.eventToggle("leave",t.target,t)}),this.options.timeout)},this.enterHold=()=>{clearTimeout(this.leaveTimer)},this.leaveHold=t=>{clearTimeout(this.enterTimer),this.leaveTimer=setTimeout((()=>{this.eventToggle("leave",this.targetEl,t)}),this.options.timeout)},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}document.body.removeEventListener("mousemove",this.globalEvent),this.targetEl.removeEventListener("mousemove",this.moveEvent),this.targetEl.removeEventListener("mouseenter",this.enterEvent),this.targetEl.removeEventListener("mouseleave",this.leaveEvent),document.body.addEventListener("mousemove",this.globalEvent),this.targetEl.addEventListener("mousemove",this.moveEvent),this.targetEl.addEventListener("mouseenter",this.enterEvent),this.targetEl.addEventListener("mouseleave",this.leaveEvent),this.holdEl&&(this.holdEl.removeEventListener("mouseenter",this.enterHold),this.holdEl.removeEventListener("mouseleave",this.leaveHold),this.holdEl.addEventListener("mouseenter",this.enterHold),this.holdEl.addEventListener("mouseleave",this.leaveHold)),super.listen({name:"initiated",cb:t})}destroy(t){return this.destroyed||(document.body.removeEventListener("mousemove",this.globalEvent),this.targetEl.removeEventListener("mousemove",this.moveEvent),this.targetEl.removeEventListener("mouseenter",this.enterEvent),this.targetEl.removeEventListener("mouseleave",this.leaveEvent),this.holdEl&&(this.holdEl.removeEventListener("mouseenter",this.enterHold),this.holdEl.removeEventListener("mouseleave",this.leaveHold)),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const O=[{attr:"theme",prop:"theme",value:""},{attr:"placement",prop:"placement",value:"top"},{attr:"trigger",prop:"trigger",value:"hover"},{attr:"page-close",prop:"pageClose",value:!0},{attr:"can-close",prop:"canClose",value:null},{attr:"size",prop:"size",value:"md"},{attr:"in",prop:"in",value:"fadeIn"},{attr:"out",prop:"out",value:"fadeOut"},{attr:"multiple",prop:"multiple",value:!1},{attr:"height",prop:"height",value:""},{attr:"adaptive",prop:"adaptive",value:!0},{attr:"position",prop:"position",value:{}},{attr:"arrow",prop:"arrow",value:{enable:!0,size:"0.5rem",offset:"2.8rem",gap:".8rem"}},{attr:"wing",prop:"wing",value:{selector:"",trigger:"click",actClass:""}},{attr:"on-reposition",prop:"onReposition",value:null},...d];class Popup extends ModBaseListenCacheBubble{options={};confirmEl;cancelEl;closeEl;triggerShow;clickOutHideEvt;content;bubbleType;aniIn;aniOut;initialPlace;isCompField;static optMaps=O;constructor(t,e={},s=l.initial){super(),super.ready({options:e,host:t,maps:Popup.optMaps,component:!1,spread:["arrow","tools","padding","footer","autoFill","bullet"]}),this.bubbleType="popup";let i=this;this.triggerShow=function(t){if(t.preventDefault(),"click"===(!!i.wings.includes(this)&&i.options.wing.trigger||i.options.trigger)){if(this===i.targetEl&&i.options.canClick){let e=getEvtTarget(t);if(!i.options.canClick.call(i,e,t))return}if("hidden"===i.state)if(i.show(),i.options.multiple)i.options.wing.actClass&&i.wings.includes(this)&&this.classList.add(i.options.wing.actClass);else{let t=h.data.filter((t=>t.type===i.constructor.name.toLowerCase()&&t.ins!==i&&"shown"===t.ins.state));for(let e of t)e.ins.hide()}else"shown"===i.state&&!i.options.keepShow&&i.hide()}else"input"===i.options.trigger&&(i.targetEl?.value?(i.show(),i.options.wing.actClass&&i.wings.includes(this)&&this.classList.add(i.options.wing.actClass)):!i.options.keepShow&&i.hide())},this.clickOutHideEvt=t=>{if(this.options.canClose){let e=getEvtTarget(t);if(!this.options.canClose.call(this,e,t))return}!contains(t.target,[this.mainEl,this.targetEl,...this.wings])&&"shown"===this.state&&!this.options.keepShow&&elState(t.target).isVisible&&this.hide()},this.triggerClose=()=>{!this.options.keepShow&&this.hide()},this.leaveTrigger=debounce((()=>{!this.options.keepShow&&this.hide()})),super.listen({name:"constructed"}),s&&this.targetEl&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.options.placement=this.options.placement||"top",this.options.trigger="hover"===this.options.trigger&&s.isTouchScr?"click":this.options.trigger,this.isCompField=i.includes(this.options.contType.toLowerCase()),this.isCompField&&(this.options.tools.placement="outside"),this.wings=getEls(this.options.wing.selector),this.renderBubble("popup"),this.setAttrs(),this.fixAni(this.options.placement),await getContent.call(this,{content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.contEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:t=>{this.renderContent(t)}}),this.createPosition(),this.handleFooter(),this.handleTools(),this.bindTrigger(),this.contEl.querySelectorAll(`[${s.alias}="closebubble"]`).forEach((t=>{t.removeEventListener("click",this.triggerClose),t.addEventListener("click",this.triggerClose,!1)})),this.initBullets(),super.listen({name:"initiated",cb:t}),this}fixAni(t){this.aniIn=t.includes("max")&&"slideDown"===this.options.in?"fadeIn":this.options.in,this.aniOut=t.includes("max")&&"slideUp"===this.options.out?"fadeOut":this.options.out,this.fixEaseAni(t)}handleTools(){this.options.tools.enable&&this.options.tools.children.forEach((t=>{"close"===t.name?t.wrapEl.onclick=()=>this.hide():"enlarge"===t.name?("center-max"===this.positionIns.placement?(classes(t.iconEl).replace(t.icon,t.swap),this.initialPlace=this.rawOpts.placement):this.initialPlace=this.positionIns.placement,t.wrapEl.onclick=()=>{"center-max"===this.positionIns.placement?(classes(t.iconEl).replace(t.swap,t.icon),this.reposition(this.initialPlace)):(classes(t.iconEl).replace(t.icon,t.swap),this.reposition("center-max"))}):"widen"===t.name?("top-max"===this.positionIns.placement||"bottom-max"===this.positionIns.placement?(classes(t.iconEl).replace(t.icon,t.swap),this.initialPlace=this.positionIns.placement.split("-")[0]):this.initialPlace=this.positionIns.placement,t.wrapEl.onclick=()=>{if(this.positionIns.placement.includes("top")||this.positionIns.placement.includes("bottom"))if(["left-max","right-max","top-max","bottom-max"].includes(this.positionIns.placement))classes(t.iconEl).replace(t.swap,t.icon),this.reposition(this.initialPlace);else{let e=this.positionIns.placement.split("-")[0];classes(t.iconEl).replace(t.icon,t.swap),this.reposition(e+"-max")}}):"heighten"===t.name?("left-max"===this.positionIns.placement||"right-max"===this.positionIns.placement?(classes(t.iconEl).replace(t.icon,t.swap),this.initialPlace=this.positionIns.placement.split("-")[0]):this.initialPlace=this.positionIns.placement,t.wrapEl.onclick=()=>{if(this.positionIns.placement.includes("left")||this.positionIns.placement.includes("right"))if(["left-max","right-max","top-max","bottom-max"].includes(this.positionIns.placement))classes(t.iconEl).replace(t.swap,t.icon),this.reposition(this.initialPlace);else{let e=this.positionIns.placement.split("-")[0];classes(t.iconEl).replace(t.icon,t.swap),this.reposition(e+"-max")}}):t.action&&t.action.call(this,t)}))}setAttrs(){this.options.classes&&classes(this.mainEl).add(this.options.classes),this.options.size?this.mainEl.setAttribute("size",this.options.size):this.mainEl.removeAttribute("size"),this.options.contType?this.mainEl.setAttribute("conttype",this.options.contType):this.mainEl.removeAttribute("conttype"),this.options.placement?this.mainEl.setAttribute("placement",this.options.placement):this.mainEl.removeAttribute("placement",this.options.placement),this.contEl.toggleAttribute("dedicated",this.options.dedicated),this.options.height?addStyle(this.contEl,"height",this.options.height):removeStyle(this.contEl,"height"),this.options.zIndex?addStyle(this.mainEl,"z-index",this.options.zIndex):removeStyle(this.mainEl,"z-index"),this.options.tools.enable?this.mainEl.setAttribute("toolsplace",this.options.tools.placement):this.mainEl.removeAttribute("toolsplace"),this.options.theme?this.mainEl.setAttribute("theme",this.options.theme):this.mainEl.removeAttribute("theme")}createPosition(){let t=this.options.placement.split("-"),e=this.options.placement;this.options.adaptive&&"xxs"===s.screen&&("left"===t[0]?e="top-max":"right"===t[0]?e="bottom-max":!t.includes("max")&&["top","bottom"].includes(t[0])&&(e=t[0]+"-max")),this.positionIns=new Position(this.targetEl,this.mainEl,extend({target:{placement:e,arrow:this.options.arrow,targetObs:{attrs:[]},bubbleObs:{attrs:[]},delay:0},source:this.options.position}))}bindTrigger(){"click"===this.options.trigger||"input"===this.options.trigger?(this.canTrigger||(this.targetEl.removeEventListener(this.options.trigger,this.triggerShow),this.targetEl.addEventListener(this.options.trigger,this.triggerShow,!1)),this.wings.length>0&&!this.canTrigger&&this.wings.forEach((t=>{let e=this.options.wing.trigger||this.options.trigger;t.removeEventListener(e,this.triggerShow),t.addEventListener(e,this.triggerShow,!1)}))):"hover"===this.options.trigger?this.hoverIns=new Hover(this.targetEl,{onEnter:()=>{this.show()},onLeave:this.leaveTrigger,hold:this.mainEl}):"sticky"===this.options.trigger&&(this.options.multiple=!0,this.show()),this.options.pageClose&&!this.options.multiple&&!this.canTrigger&&document.addEventListener("click",this.clickOutHideEvt,!1),this.canTrigger=!0}unbindTrigger(t="host"){this.canTrigger=!1,"click"===this.options.trigger||"input"===this.options.trigger?(this.targetEl.removeEventListener(this.options.trigger,this.triggerShow),this.wings.length>0&&"all"===t&&this.wings.forEach((t=>{let e=this.options.wing.trigger||this.options.trigger;t.removeEventListener(e,this.triggerShow)}))):"hover"===this.options.trigger&&this.hoverIns.destroy(),this.options.pageClose&&!this.options.multiple&&"all"===t&&document.removeEventListener("click",this.clickOutHideEvt,!1)}fixEaseAni(t){"easeIn"===this.aniIn&&(this.aniIn=t.includes("left")?"easeInStart":t.includes("right")?"easeInEnd":t.includes("top")?"easeInTop":t.includes("bottom")?"easeInBtm":"easeIn"),"easeOut"===this.aniOut&&(this.aniOut=t.includes("left")?"easeOutStart":t.includes("right")?"easeOutEnd":t.includes("top")?"easeOutTop":t.includes("bottom")?"easeOutBtm":"easeOut")}reposition(t,e){return this.destroyed||!t||this.positionIns.change(t,(t=>{this.fixAni(t),this.updateCache({placement:t}),super.listen({name:"reposition",cb:e,params:[t]})})),this}async show(t){return this.destroyed||this.options.asleep?this:"hidden"!==this.state?("shown"===this.state&&this.leaveTrigger.cancel(),this):(this.state="ing",this.options.b4Show&&await this.options.b4Show.call(this),elState(this.mainEl).isVirtual&&document.body.appendChild(this.mainEl),super.listen({name:"show",cb:t}),this.targetEl&&this.targetEl.classList.add(this.options.actClass),this.lastShowTime=Date.now(),this.hoverIns&&(this.hoverIns.isActive=!0),requestAnimationFrame((async()=>{this.positionIns.change(),this.wrapHeight=this.positionIns.bubbleData.height,super.getDuration(),this.mainEl.style.visibility="visible","slideDown"===this.aniIn?easeHeight({el:this.wrapEl,height:this.wrapHeight,type:"down",duration:this.duration,unaware:!1}):(this.options.duration&&(this.mainEl.style.animationDuration=`${this.options.duration}ms`),this.aniIn&&(this.mainEl.style.animationName=s.prefix+this.aniIn)),await delay({duration:this.duration,done:()=>{this.state="shown",super.listen({name:"shown",cb:t})}})})),this)}async hide(t){return this.destroyed?this:"shown"!==this.state?("ing"===this.state&&(this.mainEl.style.visibility=null),this):(this.state="ing",this.options.deadShow||(this.options.b4Hide&&await this.options.b4Hide.call(this),super.listen({name:"hide",cb:t}),this.targetEl&&this.targetEl.classList.remove(this.options.actClass),this.options.wing.actClass&&this.wings.map((t=>{t.classList.remove(this.options.wing.actClass)})),"slideUp"===this.aniOut?easeHeight({el:this.wrapEl,height:this.wrapHeight,type:"up",duration:this.duration,unaware:!1}):this.aniOut&&(this.mainEl.style.animationName=s.prefix+this.aniOut),this.mainEl.querySelectorAll("video,audio").forEach((t=>{t.pause()})),this.hoverIns&&(this.hoverIns.isActive=!1),await delay({duration:this.duration,done:()=>{this.state="hidden",this.mainEl.style.visibility=null,this.mainEl.remove(),super.listen({name:"hidden",cb:t}),"slideUp"===this.aniOut&&(this.wrapEl.style.height="auto")}})),this)}}const z=[{attr:"placeholder",prop:"placeholder",value:""},{attr:"on-setted",prop:"onSetted",value:null},{attr:"on-canceled",prop:"onCanceled",value:null},...p];class Dodge extends ModBaseListenCache{options={};inputEl;labelEl;isFocus;toggle;timestamp;placeholder;static hostType="node";static optMaps=z;constructor(t,e={},s=!0){if(super(),super.ready({options:e,host:t,maps:Dodge.optMaps}),this.timestamp=Date.now(),this.inputEl=this.targetEl.querySelector("input,textarea"),!this.inputEl)throw new Error("Form field node not found!");this.labelEl=null,this.isFocus=!1,this.toggle={focus:()=>{this.inputEl.focus(),this.inputEl.removeAttribute("readonly"),this.targetEl.setAttribute("dodged",""),this.isFocus=!0},blur:t=>{this.inputEl.blur(),this.inputEl.setAttribute("readonly",""),this.inputEl.value?this.targetEl.setAttribute("dodged",""):this.targetEl.removeAttribute("dodged"),this.isFocus=!1}},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.placeholder=this.getPlaceholder(),this.setAttrs(),this.render(),this.inputEl.addEventListener("focus",this.toggle.focus,!1),this.inputEl.addEventListener("blur",this.toggle.blur,!1),this.labelEl.onclick=()=>{this.toggle.focus()},this.inputEl.value&&this.toggle.focus(),super.listen({name:"initiated",cb:t}),this}getPlaceholder(){let t=this.inputEl.getAttribute("placeholder");return this.options.placeholder?this.options.placeholder:t||l.lang.form.placeholder}render(){this.labelEl||(this.labelEl=createEl("label","",this.placeholder),this.inputEl.removeAttribute("placeholder"),this.inputEl.insertAdjacentElement("afterend",this.labelEl))}setAttrs(){this.targetEl.classList.add(`${s.prefix}dodge`),this.inputEl.toggleAttribute("readonly",!0),this.inputEl.classList.contains("ax-lg")&&this.targetEl.classList.add("ax-lg")}set(t,e){return this.destroyed||(t?(this.inputEl.value=t,this.toggle.focus()):this.inputEl.focus(),super.listen({name:"set",cb:e,params:[t]})),this}cancel(t){return this.destroyed||(this.inputEl.value="",this.inputEl.blur(),this.toggle.blur(),super.listen({name:"canceled",cb:t})),this}destroy(t){return this.destroyed||(this.labelEl.onclick=null,this.inputEl.removeEventListener("focus",this.toggle.focus),this.inputEl.removeEventListener("blur",this.toggle.blur),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const H=[{attr:"label",prop:"label",value:""},{attr:"placement",prop:"placement",value:""},{attr:"icon-show",prop:"iconShow",value:!0},{attr:"type",prop:"type",value:"required"},{attr:"extend",prop:"extend",value:{}},{attr:"parent",prop:"parent",value:""},{attr:"classes",prop:"classes",value:""},{attr:"ajax",prop:"ajax",value:{}},{attr:"fail",prop:"fail",value:""},{attr:"succ",prop:"succ",value:""},{attr:"separator",prop:"separator",value:","},{attr:"style-host",prop:"styleHost",value:!1},{attr:"succ-show",prop:"succShow",value:!0},{attr:"node-name",prop:"nodeName",value:"div"},{attr:"message",prop:"message",value:{}},{attr:"popup",prop:"popup",value:{}},{attr:"reg-local",prop:"regLocal",value:""},{attr:"reg-chars",prop:"regChars",value:""},{attr:"length-str",prop:"lengthStr",value:6},{attr:"trigger",prop:"trigger",value:"blur"},{attr:"ajax",prop:"ajax",value:{}},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-changed",prop:"onChanged",value:null},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-hidden",prop:"onHidden",value:null},...p];class Valid extends ModBaseListenCache{options={};useRules;dftRules;inputEl;timestamp;name;label;parentEl;valid;hostValid;msgEl;otherBox;checkFun;types;userRules;result;output;msgIcon;msgText;popupIns;msgIns;obsProps;observer;static hostType="node";static optMaps=H;constructor(t,e={},s=l.initial){if(super(),super.ready({options:e,host:t,maps:Valid.optMaps}),this.timestamp=Date.now(),!this.targetEl.getAttribute("name"))throw new Error("The element to be verified must have name attribute!");this.name=this.targetEl.getAttribute("name"),this.label=this.options.label||this.name,this.parentEl=getEl(this.options.parent)||this.targetEl.closest("form")||document.body,this.valid={target:this.targetEl,name:this.name,ins:this},this.hostValid=null,this.pushValids(),this.createMsgEl(),this.otherBox=getEl(this.options.placement),this.createObs(),this.checkFun=debounce((()=>{this.do()})),this.dftRules={required:t=>{let e=renderTpl(this.options.lang.required,{label:t.label});return isEmpty(t.value)?{passed:!1,fail:e,type:"required"}:{passed:!0}},...this.loopTestRules(["email","cellphone","landline","ip","id","zip","url","locale","password","letter","string","ymdhms","ymd","hms","ym","y","m","d","integer","number"]),plate:t=>{let e=8===t.value.length?A.plate.nev:A.plate.oil;return this.testRegex({regex:e,value:t.value,name:"plate"})},date:t=>{let e=isDateStr(t.value),s=renderTpl(this.options.lang.date,{label:t.label,value:t.value});return e?{passed:!0}:{passed:!1,fail:s,type:"date"}},...this.loopDateRules(["date=","date<","date<=","date>","date>=","date><","date><=","date>=<","date>=<="]),...this.loopThanRules(["than=","than>","than>=","than<","than<=","than><","than><=","than>=<","than>=<="]),...this.loopLengthRules(["length=","length>","length>=","length<","length<=","length><","length><=","length>=<","length>=<="]),...this.loopIncludeRules(["include","exclude"]),...this.loopValuesRules(["count=","count>","count>=","count<","count<=","count><","count><=","count>=<","count>=<="]),...this.loopSameRules(["same","different"]),strength:t=>{if("string"!=typeof t.value)return{passed:!1,fail:this.options.lang.strFormat};let e=this.getStrength(t.value),s=renderTpl(this.options.lang.strength,{label:t.label,name:t.name,value:e,data:this.types.strength});return e>=this.types.strength?{passed:!0}:{passed:!1,fail:s,type:"strength"}},specific:t=>{if("string"!=typeof t.value)return{passed:!1,fail:this.options.lang.strFormat};let e=w.parseSpecific(this.types.specific,{label:t.label,name:t.name,value:t.value,tpl:this.options.lang.specific}),s=e.regex,i=e.text;return w.test(t.value,s)?{passed:!0}:{passed:!1,fail:i,type:"specific"}},combine:t=>{if("string"!=typeof t.value)return{passed:!1,fail:this.options.lang.strFormat};let e=w.parseCombine(this.types.combine,{label:t.label,name:t.name,ins:this,value:t.value,tpl:this.options.lang.combine}),s=e.regex,i=e.text;return w.test(t.value,s)?{passed:!0}:{passed:!1,fail:i,type:"combine"}},async:t=>ajax.call(this,Object.assign({url:this.types.async,data:{label:t.label,name:t.name,value:t.value,strength:this.getStrength(t.value)}},this.options.ajax)),...this.options.extend},!this.parentEl?.ax?.hasSubmitListener&&w.listenSubmit({item:this.parentEl}),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.types="string"==typeof this.options.type?paramToJson(this.options.type):this.options.type,this.getUserRules(),["change","blur","input"].includes(this.options.trigger)?(this.targetEl.removeEventListener(this.options.trigger,this.checkFun),this.targetEl.addEventListener(this.options.trigger,this.checkFun,!1)):"load"===this.options.trigger&&this.checkFun(),super.listen({name:"initiated",cb:t}),this}setEmpty(){this.msgEl&&(this.msgEl.innerHTML=""),this.popupIns&&this.popupIns.destroy,this.msgIns&&this.msgIns.destroy}loopTestRules(t){let e={};return t.forEach((t=>{A.hasOwnProperty(t)&&(e[t]=e=>Array.isArray(e.value)?{passed:!1,fail:this.options.lang.strFormat,id:"strFormat"}:this.testRegex({regex:A[t],value:e.value,name:t}))})),e}loopIncludeRules(t){let e={};return t.forEach((t=>{e[t]=e=>{if(!Array.isArray(e.data))return{passed:!1,fail:this.options.lang.arrFormat};let s=Array.isArray(e.value)?e.value:e.value.split(this.options.separator),i=isSubset(s,e.data),a=renderTpl(this.options.lang[t],{label:e.label,name:e.name,value:e.value,data:e.data});return"exclude"===t&&(i=!i),i?{passed:!0}:{passed:!1,fail:a,type:t}}})),e}loopSameRules(t){let e={};return t.forEach((t=>{e[t]=e=>{if(!Array.isArray(e.data))return{passed:!1,fail:this.options.lang.arrFormat};let s=this.parentEl.querySelector(`[name="${this.types[t][0]}"]`),i=this.getVals(s,"string"),a=this.getVals(this.targetEl,"string"),l=renderTpl(this.options.lang[t],{label:e.label,name:e.name,value:a,data:e.data});return("same"===t?i===a:i!==a)?{passed:!0}:{passed:!1,fail:l,type:t}}})),e}loopDateRules(t){let e={};return t.forEach((t=>{e[t]=e=>{if(Array.isArray(e.value))return{passed:!1,fail:this.options.lang.strFormat};let s=w.expired(e.value,e.data).join(""),i=renderTpl(this.options.lang[t],{label:e.label,value:e.value,data:e.data});return("date="===t?"0-2"===s:"date<"===t?"-1-2"===s:"date<="===t?"0-2"===s||"-1-2"===s:"date>"===t?"1-2"===s:"date>="===t?"1-2"===s||"0-2"===s:"date><"===t?"1-1"===s:"date><="===t?"1-1"===s||"10"===s:"date>=<"===t?"1-1"===s||"0-1"===s:"date>=<="!==t||["1-1","10","0-1","00"].includes(s))?{passed:!0}:{passed:!1,fail:i,type:t}}})),e}loopThanRules(t){let e={};return t.forEach((t=>{e[t]=e=>{if(Array.isArray(e.value))return{passed:!1,fail:this.options.lang.strFormat};let s=w.than(e.value,e.data).join(""),i=renderTpl(this.options.lang[t],{label:e.label,value:e.value,data:e.data});return("than>"===t?"1-2"===s:"than>="===t?"1-2"===s||"0-2"===s:"than<"===t?"-1-2"===s:"than<="===t?"0-2"===s||"-1-2"===s:"than="===t?"0-2"===s:"than><"===t?"1-1"===s:"than><="===t?"1-1"===s||"10"===s:"than>=<"===t?"1-1"===s||"0-1"===s:"than>=<="!==t||["1-1","10","0-1","00"].includes(s))?{passed:!0}:{passed:!1,fail:i,type:t}}})),e}loopLengthRules(t){let e={};return t.forEach((t=>{e[t]=e=>{if(Array.isArray(e.value))return{passed:!1,fail:this.options.lang.strFormat,id:"strFormat"};let s="length="===t?this.types[t]:"length>"===t?`${this.types[t]+1},`:"length>="===t?`${this.types[t]},`:"length<"===t?"0,"+(this.types[t]-1):"length<="===t?`0,${this.types[t]}`:"length><"===t?`${this.types[t][0]+1},${this.types[t][1]-1}`:"length><="===t?`${this.types[t][0]+1},${this.types[t][1]}`:"length>=<"===t?`${this.types[t][0]},${this.types[t][1]-1}`:"length>=<="===t?`${this.types[t][0]},${this.types[t][1]}`:"",i=new RegExp(`^.{${s}}$`);return this.testRegex({regex:i,value:e.value,name:t})}})),e}loopValuesRules(t){let e={};for(let s of t)e[s]=t=>{let e=Array.isArray(t.value)?t.value:t.value.split(this.options.separator).filter(Boolean),i=renderTpl(this.options.lang[s],{label:t.label,name:t.name,value:e.length,data:t.data}),a="count>=<="===s?e.length>=this.types[s][0]&&e.length<=this.types[s][1]:"count><="===s?e.length>this.types[s][0]&&e.length<=this.types[s][1]:"count>=<"===s?e.length>=this.types[s][0]&&e.length<this.types[s][1]:"count><"===s?e.length>this.types[s][0]&&e.length<this.types[s][1]:"count="===s?`${e.length} === ${this.types[s]}`:`${e.length} ${s.replace("count","")} ${this.types[s]}`;return new Function(`"use strict";return ${a}`)()?{passed:!0}:{passed:!1,fail:i,type:s}};return e}testRegex({regex:t,value:e,name:s}){let i=w.test(e,t),a=renderTpl(this.options.lang[s],{label:this.label,value:e,data:this.types[s]});return("length<"===s||"length<="===s)&&!e&&(i=!0),i?{passed:!0}:{passed:!1,fail:a,type:s}}extendRules(t){Object.assign(this.dftRules,t)}getUserRules(){this.userRules={};for(let t in this.types)this.types.hasOwnProperty(t)&&this.dftRules.hasOwnProperty(t)&&(this.userRules[t]=this.dftRules[t],this.userRules[t].data=this.types[t])}getVals(t=this.targetEl,e=""){return E.getVals({target:t,parent:this.parentEl,format:e})}getStrength(t=this.getVals(this.targetEl)){return w.getStrength(t,{chars:`[${this.options.regChars}]`,local:`[${this.options.regLocal}]`,length:this.options.lengthStr})}do(){if(this.destroyed)return this;let t=this.getVals(this.targetEl)||"";return w.factory({value:t,name:this.name,label:this.label,ins:this,rules:this.userRules,text:{succ:this.options.succ,fail:this.options.fail},cb:e=>{this.result=e,this.output={...e,name:this.name,label:this.label,value:t,ins:this,strength:this.getStrength(t)},super.listen({name:"trigger",params:[this.output]}),Object.assign(this.observer.proxy,e)}})}toggleStyle(t){t?(this.msgEl.classList.remove(`${s.prefix}c-error`),this.msgEl.classList.add(`${s.prefix}c-succ`),this.targetEl.setAttribute("validate","passed"),this.options.styleHost&&(this.targetEl.classList.remove(`${s.prefix}c-error`),this.targetEl.classList.add(`${s.prefix}c-succ`))):(this.msgEl.classList.remove(`${s.prefix}c-succ`),this.msgEl.classList.add(`${s.prefix}c-error`),this.targetEl.setAttribute("validate","failed"),this.options.styleHost&&(this.targetEl.classList.remove(`${s.prefix}c-succ`),this.targetEl.classList.add(`${s.prefix}c-error`)))}render(t){if(this.toggleStyle(t.passed),t.passed?(this.msgIcon=this.options.iconShow?r.font["succ-f"]:"",this.msgText=t.succ):(this.msgIcon=this.options.iconShow?r.font["error-f"]:"",this.msgText=t.fail),this.msgEl.innerHTML=this.msgIcon+this.msgText,this.otherBox)elState(this.msgEl).isVirtual&&this.otherBox.appendChild(this.msgEl);else{if("string"!=typeof this.options.placement)return this;if(this.options.placement=this.options.placement.trim(),"down"===this.options.placement){let t=this.targetEl.closest(`.${s.prefix}box-input`)?.querySelector(`[${s.alias}="input"]`);t&&t.insertAdjacentElement("afterEnd",this.msgEl)}else if("right"===this.options.placement){let t=this.targetEl.closest(`.${s.prefix}box-input`)?.querySelector(`[${s.alias}="help"]`);t&&t.appendChild(this.msgEl)}else"popup"===this.options.placement?this.popupIns||(this.popupIns=new Popup(this.targetEl,{content:this.msgEl,placement:"bottom-start",keepShow:!0,footer:!1,tools:!1,padding:!1,arrow:{enable:!1,gap:0},classes:`${s.prefix}plain`,trigger:"sticky"})):"message"===this.options.placement?this.msgIns?this.msgIns.update({content:this.msgText,status:t.passed?"succ":"error"}).then((()=>this.msgIns.show())):this.msgIns=new Message({content:this.msgText,iconShow:!0,status:t.passed?"succ":"error"}).show():elState(this.msgEl).isVirtual&&this.targetEl.insertAdjacentElement("afterend",this.msgEl)}}createMsgEl(){this.msgEl=this.hostValid?this.hostValid.ins.msgEl:createEl(this.options.nodeName,{class:`${s.prefix}valid`})}createObs(){this.obsProps=this.hostValid?this.hostValid.ins.obsProps:{},this.observer=new Observe(this.obsProps),this.observer.on("completed",(()=>{this.render(this.result),super.listen({name:"changed",params:[this.output]})}))}pushValids(){if(0===s.valids.length)s.valids.push({parent:this.parentEl,children:[this.valid]});else{let t=s.valids.findIndex((t=>t.parent===this.parentEl));if(t>-1){let e=s.valids[t].children,i=e.find((t=>t.name===this.name));i?this.hostValid=i:e.push(this.valid)}else s.valids.push({parent:this.parentEl,children:[this.valid]})}}hide(t){return this.destroyed||("message"===this.options.placement||("popup"===this.options.placement?this.popupIns.hide():this.msgEl.remove()),super.listen({name:"hidden",cb:t})),this}show(t){return this.destroyed||(this.otherBox?elState(this.msgEl).isVirtual&&this.otherBox.appendChild(this.msgEl):"message"===this.options.placement?this.msgIns.show():"popup"===this.options.placement?this.popupIns.show():elState(this.msgEl).isVirtual&&this.targetEl.insertAdjacentElement("afterend",this.msgEl),super.listen({name:"shown",cb:t})),this}destroy(t){return this.destroyed||(["change","blur","input"].includes(this.options.trigger)&&this.targetEl.removeEventListener(this.options.trigger,this.checkFun),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const B=[{attr:"theme",prop:"theme",value:"light"},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"passive",prop:"passive",value:!1},{attr:"expose",prop:"expose",value:!1},{attr:"active",prop:"active",value:""},{attr:"disable",prop:"disable",value:""},{attr:"multiple",prop:"multiple",value:!1},{attr:"expand-all",prop:"expandAll",value:!1},{attr:"z-index",prop:"zIndex",value:0},{attr:"trigger",prop:"trigger",value:"click"},{attr:"root-start",prop:"rootStart",value:l.rootStart},{attr:"id-start",prop:"idStart",value:l.idStart},{attr:"floor-start",prop:"floorStart",value:l.floorStart},{attr:"path-hyphen",prop:"pathHyphen",value:l.pathHyphen},{attr:"duration",prop:"duration",value:0},{attr:"page-close",prop:"pageClose",value:!1},{attr:"arrow",prop:"arrow",value:{enable:!0,icon:""}},{attr:"classes",prop:"classes",value:""},{attr:"linkage",prop:"linkage",value:!0},{attr:"unpadded",prop:"unpadded",value:!1},{attr:"lamp",prop:"lamp",value:""},{attr:"full",prop:"full",value:!1},{attr:"spill",prop:"spill",value:!1},{attr:"layout",prop:"layout",value:"indent|legend|icon|disk|cube|image|label|custom|tips||badge|arrow"},{attr:"tree",prop:"tree",value:{}},{attr:"drawer",prop:"drawer",value:{host:"",placement:"left",footer:!1}},{attr:"nav",prop:"nav",value:{enable:!1,headWidth:"",bodyWidth:"",marginLeft:"",marginRight:"",align:"left"}},{attr:"on-activated",prop:"onActivated",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},...p];let F=l.labelHyphen,N=l.splitHyphen,j=l.rootStart,q=l.idStart,W=l.floorStart,Y=l.pathHyphen;const U=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:""},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"passive",prop:"passive",value:!1},{attr:"disable",prop:"disable",value:""},{attr:"readonly",prop:"readonly",value:""},{attr:"min",prop:"min",value:0},{attr:"max",prop:"max",value:0},{attr:"sliced",prop:"sliced",value:!0},{attr:"expand",prop:"expand",value:{value:"",all:!1,only:!0,linkage:!1}},{attr:"select",prop:"select",value:{enable:!0,only:!0,value:"",linkage:!1,span:"tree",addSelected:!1}},{attr:"arrow",prop:"arrow",value:{enable:!0,show:`${s.prefix}icon-right`,hide:`${s.prefix}icon-right`,anim:`${s.prefix}rotate90`,type:"icon",trigger:"click"}},{attr:"legend",prop:"legend",value:{enable:!1,parent:[`${s.prefix}icon-folder`,`${s.prefix}icon-folder-open`],child:`${s.prefix}icon-file-text`,type:"icon"}},{attr:"check",prop:"check",value:{enable:!1,type:"checkbox",value:"",min:0,max:0,sliced:!0,linkage:!0,only:!1,span:"tree"}},{attr:"tools",prop:"tools",value:{enable:!1,trigger:"hover",children:["folder","file","edit","remove"]}},{attr:"output",prop:"output",value:{enable:!0,target:"",connector:F,separator:N,type:"",from:"selected",field:"label",instant:!0,autosort:!1}},{attr:"sql-data",prop:"sqlData",value:{deep:0,start:0,count:0,order:"id asc",where:""}},{attr:"paginated",prop:"paginated",value:{enable:!1,count:10,override:!1,exception:!1}},{attr:"delay",prop:"delay",value:100},{attr:"deferred",prop:"deferred",value:!1},{attr:"shortcut",prop:"shortcut",value:{enable:!1,span:"blank",mean:"selected"}},{attr:"search",prop:"search",value:{target:"",trigger:"input",delay:500,value:"",limit:0,fuzzy:!0,ignore:!0}},{attr:"drag",prop:"drag",value:{enable:!1,exclude:""}},{attr:"drop",prop:"drop",value:{attr:"dropnode",global:!1}},{attr:"chain",prop:"chain",value:!1},{attr:"auto-fill",prop:"autoFill",value:!0},{attr:"root-start",prop:"rootStart",value:j},{attr:"id-start",prop:"idStart",value:q},{attr:"floor-start",prop:"floorStart",value:W},{attr:"path-hyphen",prop:"pathHyphen",value:Y},{attr:"duration",prop:"duration",value:0},{attr:"bubble",prop:"bubble",value:{enable:!1,type:"popup"}},{attr:"classes",prop:"classes",value:""},{attr:"display",prop:"display",value:"inline"},{attr:"layout",prop:"layout",value:"indent|arrow|check|legend|icon|disk|cube|image|label|badge|tips|custom|tools"},{attr:"feature",prop:"feature",value:{type:"",expand:{all:!0,only:!1},check:{linkage:!0,only:!1,span:"tree"},layout:{dropdown:"indent|arrow|icon|disk|cube|image|label|holder|tips|badge",select:"indent|arrow|icon|disk|cube|image|label|holder|tips|badge",check:"indent|arrow|check|icon|disk|cube|image|label|holder|tips|badge",button:"icon|arrow|disk|cube|image|label|tips|badge",list:"indent|arrow|icon|disk|cube|image(label|badge|tips|custom)"}}},{attr:"b4-expand",prop:"b4Expand",value:null},{attr:"b4-collapse",prop:"b4Collapse",value:null},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-edit",prop:"b4Edit",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-graft",prop:"b4Graft",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-insertitem",prop:"onInsertItem",value:null},{attr:"on-insertitems",prop:"onInsertItems",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-disabledall",prop:"onDisabledAll",value:null},{attr:"on-enabledall",prop:"onEnabledAll",value:null},{attr:"on-readonly",prop:"onReadonly",value:null},{attr:"on-readonlyall",prop:"onReadonlyAll",value:null},{attr:"on-expand",prop:"onExpand",value:null},{attr:"on-expanded",prop:"onExpanded",value:null},{attr:"on-collapse",prop:"onCollapse",value:null},{attr:"on-collapsed",prop:"onCollapsed",value:null},{attr:"on-expandall",prop:"onExpandAll",value:null},{attr:"on-expandedAll",prop:"onExpandedAll",value:null},{attr:"on-collapsedall",prop:"onCollapsedAll",value:null},{attr:"on-selected",prop:"onSelected",value:null},{attr:"on-deselected",prop:"onDeselected",value:null},{attr:"on-selectedall",prop:"onSelectedAll",value:null},{attr:"on-checked",prop:"onChecked",value:null},{attr:"on-unchecked",prop:"onUnchecked",value:null},{attr:"on-checkedall",prop:"onCheckedAll",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-turned",prop:"onTurned",value:null},{attr:"on-got",prop:"onGot",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-grafted",prop:"onGrafted",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-toofew",prop:"onTooFew",value:null},{attr:"on-toomany",prop:"onTooMany",value:null},{attr:"on-locked",prop:"onLocked",value:null},{attr:"on-unlocked",prop:"onUnlocked",value:null},{attr:"on-output",prop:"onOutput",value:null},...p],X=[{attr:"original",prop:"original",value:!0},{attr:"group",prop:"group",value:""},{attr:"drags",prop:"drags",value:""},{attr:"drops",prop:"drops",value:""},{attr:"parent",prop:"parent",value:""},{attr:"wraps",prop:"wraps",value:""},{attr:"showEmpty",prop:"showEmpty",value:!0},{attr:"handle",prop:"handle",value:""},{attr:"method",prop:"method",value:"hover"},{attr:"purpose",prop:"purpose",value:"auto"},{attr:"embed",prop:"embed",value:{position:"after",selector:""}},{attr:"pushable",prop:"pushable",value:{enable:!0,intent:"cut"}},{attr:"pullable",prop:"pullable",value:!0},{attr:"point",prop:"point",value:{before:["t/3","t/2"],after:["b/3","b/2"]}},{attr:"holder",prop:"holder",value:{enable:!1,style:[]}},{attr:"arrow",prop:"arrow",value:{enable:!1,icon:"._icon-right",placement:"left",selector:""}},{attr:"gesture",prop:"gesture",value:{}},{attr:"flip",prop:"flip",value:{enable:!0,fluct:-100}},{attr:"throttle",prop:"throttle",value:100},{attr:"duration",prop:"duration",value:200},{attr:"ignore",prop:"ignore",value:""},{attr:"b4-drop",prop:"b4Drop",value:null},{attr:"b4-trigger",prop:"b4Trigger",value:null},{attr:"on-dragstart",prop:"onDragStart",value:null},{attr:"on-dragenter",prop:"onDragEnter",value:null},{attr:"on-dragleave",prop:"onDragLeave",value:null},{attr:"on-dragmove",prop:"onDragMove",value:null},{attr:"on-dropped",prop:"onDropped",value:null},{attr:"on-dragend",prop:"onDragEnd",value:null},{attr:"on-dragcancel",prop:"onDragCancel",value:null},{attr:"on-transferred",prop:"onTransferred",value:null},{attr:"on-swapped",prop:"onSwapped",value:null},{attr:"on-embeded",prop:"onEmbeded",value:null},{attr:"on-sorted",prop:"onSorted",value:null},{attr:"on-cloned",prop:"onCloned",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-finished",prop:"onFinished",value:null},{attr:"on-dragout",prop:"onDragOut",value:null},{attr:"on-dropout",prop:"onDropOut",value:null},...p],G=[{attr:"parent",prop:"parent",value:""},{attr:"children",prop:"children",value:""},{attr:"other",prop:"other",value:""},{attr:"fluct",prop:"fluct",value:0},{attr:"easing",prop:"easing",value:"ease-out"},{attr:"prevent",prop:"prevent",value:!1},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-play",prop:"b4Play",value:null},{attr:"b4-play",prop:"b4Play",value:null},{attr:"b4-playall",prop:"b4PlayAll",value:null},{attr:"on-played",prop:"onPlayed",value:null},{attr:"on-playedall",prop:"onPlayedAll",value:null},...p];class Flip extends ModBaseListen{options={};parentEl;flipEls;flipData;childrenObs;canPlay;playedEls;srcNode;allPlayed;parentH;static hostType="none";static optMaps=G;constructor(t={},e=!0){super(),super.ready({options:t,maps:Flip.optMaps}),super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.parentEl=getEl(this.options.parent),this.allPlayed=!0,this.playedEls=[],this.canPlay=!this.options.prevent,this.updateFlipEls(),super.listen({name:"initiated",cb:t}),this}async play(t){if(this.destroyed||!t?.ax?.flip||elState(t).isUncalc)return;if(this.options.b4Play){let e=await this.options.b4Play.call(this,t);e&&(t=e)}let e=t.ax.flip.anim?t.ax.flip.anim.effect.getTiming().duration-t.ax.flip.anim.currentTime:0;t.ax.flip.anim?.cancel();let s=this.getTranslate(t),i=this.getRect(t),a={x:t.ax.flip.now.x-i.x,y:t.ax.flip.now.y-i.y},l=t.ax.flip.last.x===i.x&&t.ax.flip.last.y===i.y;if(!a.x&&!a.y)return new Promise((t=>{t(null)}));t.ax.flip.last=i;let n=t.animate([{transform:`translate(${a.x+s.x}px,${a.y+s.y}px)`},{transform:`translate(${s.x}px,${s.y}px)`}],{duration:l?e:this.getDuration(a),easing:this.options.easing,fill:"forwards"});return t.ax.flip.anim=n,await new Promise((t=>requestAnimationFrame(t))),new Promise((e=>{n.onfinish=()=>{n.cancel(),this.setFirstRect(t),this.playedEls.push(t),super.listen({name:"played",params:[t]}),e(null)}}))}getDuration(t){return Math.max(0,getAutoDur(getHypotenuse(t.x,t.y))+this.options.fluct)}getTranslate(t){let e=new DOMMatrix(style(t).transform);return{x:e.m41,y:e.m42}}getRect(t){let e=t.getBoundingClientRect();return{x:e.left,y:e.top}}setFirstRect(t){t.ax?t.ax.flip={}:t.ax={flip:{}},t.ax.flip.last=this.getRect(t),t.ax.flip.now={...t.ax.flip.last}}setNowRects(){for(let t of this.flipEls)t.ax.flip.now=this.getRect(t)}updateFlipEls(){if(this.options.children?this.flipEls=getEls(this.options.children,this.parentEl):this.flipEls=this.parentEl?[...this.parentEl.children]:[],this.options.other){let t=getEls(this.options.other);t.length&&(this.flipEls=unique([...this.flipEls,...t]))}for(let t of this.flipEls)this.setFirstRect(t)}async add(t,e){let s=getEls(t);if(!s.length)return this;if(this.options.b4Add){let t=await this.options.b4Add.call(this,s);t&&(s=t)}for(let t of s)this.flipEls.push(t),this.setFirstRect(t);return super.listen({name:"added",cb:e,params:[s]}),this}async remove(t,e){let s=getEls(t);if(!s.length)return this;if(this.options.b4Remove){let t=await this.options.b4Remove.call(this,s);t&&(s=t)}this.flipEls=this.flipEls.filter((t=>!s.includes(t)));for(let t of s)Reflect.deleteProperty(t,"flip");return super.listen({name:"removed",cb:e,params:[s]}),this}async playAll(t){if(this.flipEls.length<2||!this.canPlay||this.destroyed)return this;if(this.options.b4PlayAll){let t=await this.options.b4PlayAll.call(this,this.flipEls);t&&(this.flipEls=t)}let e=[...this.flipEls].map((t=>this.play(t)));return this.allPlayed=!1,await Promise.all(e),this.allPlayed=!0,super.listen({name:"playedAll",cb:t,params:[unique(this.playedEls)]}),this.playedEls=[],this}destroy(t){if(this.destroyed)return this;for(let t of this.flipEls)t.ax.flip?.anim?.cancel(),Reflect.deleteProperty(t.ax,"flip");return this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}class Drag extends ModBaseListen{targetEl;options={};curX;curY;preX;preY;isActive;enterTimer;leaveTimer;eventToggle;holdEl;enterCompare;globalEvent;moveEvent;enterEvent;leaveEvent;enterHold;leaveHold;holderDrag;holderDrop;holderEmpty;dropArrow;orgHolder;selfEls;dragEls;dropEls;lastDrop;lastPoint;dftParams;dropOver;dropEnd;dragstartEvt;dragendEvt;dragenterEvt;dragoverEvt;dragdropEvt;dragleaveEvt;mousedownEvt;mouseupEvt;targetPoints;targetTag;holderAttr;orgVal;nowVal;orgStyle;parentEl;wrapEls;ignoreEls;sourceNode;flipIns;gestureIns;hoverCount;cloned;ghostEl;otherGroupIns;triggered;lastTarget;isTransferred;childObs;childObsOpts;commTrigger;commDragStart;commDragEnter;commDragLeave;commDragOver;commDragDrop;commDragEnd;commDragThrot;commFinished;static hostType="node";constructor(t,e={},i=!0){if(super(),super.ready({options:e,maps:X,host:t,component:!1,spread:["arrow","pushable","holder","flip"]}),!this.targetEl)throw new Error("The target node for drag start is missing!");this.holderEmpty=createEl("div",{class:`${s.prefix}holder-empty`},this.options.lang.holderEmpty),this.holderDrop=createEl("div",{class:`${s.prefix}holder-drop ${s.prefix}d-none`},this.options.lang.holderDrop),this.dropArrow=createEl("i",{class:`${s.prefix}drop-arrow ${this.options.arrow.icon}`,placement:this.options.arrow.placement,point:"inside"}),this.lastPoint="",this.targetPoints=[],this.dragstartEvt=t=>{t.dataTransfer.effectAllowed="copyMove",this.commDragStart(t)},this.dragenterEvt=t=>{t.preventDefault(),this.commDragEnter(t.target,t)},this.dragleaveEvt=t=>{this.commDragLeave(t.target,t.relatedTarget,t)},this.dragoverEvt=t=>{t.preventDefault(),t.dataTransfer.dropEffect=t.ctrlKey?"copy":"move",!1===this.commDragOver(t.target,t)&&super.listen({name:"dragOut",params:[t]})},this.dragdropEvt=async t=>{t.preventDefault(),!1===await this.commDragDrop(t.target,t)&&super.listen({name:"dropOut",params:[t]})},this.dragendEvt=t=>{this.commDragEnd(t.target,t)},this.commTrigger=async t=>{try{this.options.b4Trigger&&await this.options.b4Trigger.call(this,t)}catch{return!1}this.updateDragsDrops(),this.removeDroppeds(),this.flipIns&&(this.flipIns.options.children=this.getFlipChldren(),this.flipIns.updateFlipEls());let e=this.dragEls.find((e=>e.contains(t.target)));if(!e)return!1;(0===this.handleEls.length||this.useHandle(t.target))&&(t.stopPropagation(),e.setAttribute("draggable","true"),this.sourceNode=e,s.dragNode=this.sourceNode,this.addDestopEvents(),super.listen({name:"trigger",params:[{target:e,event:t}]}),this.triggered=!0)},this.commDragStart=t=>{if(document.body.toggleAttribute("dragbody",!0),this.isTransferred=!1,this.cloned=!1,this.otherGroupIns.length)for(let t of this.otherGroupIns)t.isTransferred=!1,t.cloned=!1;this.setHolderAttrs(),requestAnimationFrame((()=>{this.sourceNode.classList.add(`${s.prefix}drag-wait`)})),super.listen({name:"dragStart",params:[{target:null,source:this.sourceNode,point:"outside",event:t,type:""}]})},this.commDragEnter=(t,e)=>{let s=this.dropEls.find((e=>e===t))||this.wrapEls.find((e=>e===t));if(!s)return!1;this.toggleDropping(t,!0),this.hoverCount=0,super.listen({name:"dragEnter",params:[{target:s,source:this.sourceNode,point:this.lastPoint,event:e,type:this.getTransferType()}]})},this.commDragLeave=(t,e,s)=>{let i=this.dropEls.find((e=>e===t))||this.wrapEls.find((e=>e===t)),a=this.dropEls.includes(e);return!(!i||i===e||!a&&i.contains(e))&&(this.toggleDropping(i,!1),this.removeArrow(),super.listen({name:"dragLeave",params:[{target:i,source:this.sourceNode,relatedTarget:e,point:this.lastPoint,event:s,type:this.getTransferType()}]}),!0)},this.commDragOver=(t,e)=>!!this.options.pushable.enable&&(!(!this.options.pullable&&!contains(this.sourceNode,this.selfEls))&&(t!==this.sourceNode&&(t!==this.holderDrop&&void this.commDragThrot(t,e)))),this.commDragDrop=async(t,e)=>{if(this.removeDroppings(),this.removeArrow(),!this.options.pushable.enable||"drop"!==this.options.method)return!1;if(!this.options.pullable&&!contains(this.sourceNode,this.selfEls))return!1;let s=t,i={target:s,source:this.sourceNode,point:this.lastPoint,event:e,type:this.getTransferType()};if(this.wrapEls.includes(t)){try{this.options.b4Drop&&await this.options.b4Drop.call(this,i)}catch{return!1}this.flipIns&&this.flipIns.setNowRects(),this.insertEl(s,this.sourceNode,e,"beforeend"),this.options.holder.enable&&this.hideHolder(),this.flipIns&&this.flipIns.playAll(),i.target=s,super.listen({name:"transferred",params:[i]}),this.isTransferred=!0}else{let a=this.canClone(t);if(s=this.dropEls.find((e=>e.contains(t))),!s)return!1;if(!this.insertable(s,this.sourceNode))return!1;try{this.options.b4Drop&&await this.options.b4Drop.call(this,i)}catch{return!1}if(this.flipIns){if("running"===s?.flip?.anim?.playState||s===this.sourceNode)return!1;let t=this.cloneStart(a);this.flipIns.setNowRects(),t&&this.cloneEnd({target:s,source:this.sourceNode,relatedTarget:t,event:e}),"swap"===this.options.purpose?this.swapNodes(s,this.sourceNode):this.insertEl(s,this.sourceNode,e),this.options.holder.enable&&this.hideHolder(),this.flipIns.playAll()}else{let t=this.cloneStart(a);t&&this.cloneEnd({target:s,source:this.sourceNode,relatedTarget:t,event:e}),"swap"===this.options.purpose?this.swapNodes(s,this.sourceNode):this.insertEl(s,this.sourceNode,e),this.options.holder.enable&&this.hideHolder()}i.target=s,super.listen({name:"transferred",params:[i]}),this.isTransferred=!0}this.toggleDropped(this.sourceNode,!0),super.listen({name:"dropped",params:[i]})},this.commDragEnd=(t,e)=>{let s={target:t,source:this.sourceNode,point:this.lastPoint,event:e};this.revert(),super.listen({name:"dragEnd",params:[s]})},this.commFinished=t=>{this.revert(),super.listen({name:"finished",params:[t]})},this.commDragThrot=throttle(((t,e)=>{this.hoverCount++;let i,a={source:this.sourceNode,event:e};if(this.wrapEls.includes(t)){if(i=t,!(!i.children.length||getEl(`:scope > .${s.prefix}holder-empty`,i)))return;this.flipIns&&this.flipIns.setNowRects(),"hover"===this.options.method?this.insertEl(i,this.sourceNode,e,"beforeend"):(this.options.holder.enable&&this.insertEl(i,this.holderDrop,e,"beforeend"),a.source=this.holderDrop),this.flipIns&&this.flipIns.playAll(),a.target=i,a.point="inside",a.type="embed",super.listen({name:"transferred",params:[a]}),this.isTransferred=!0,super.listen({name:"dragMove",params:[a]})}else{let s,l="hover"===this.options.method&&this.canClone(t),n=this.dropEls,r="hover"===this.options.method||"drop"===this.options.method&&this.options.holder.enable,o="drop"===this.options.method&&this.options.holder.enable?this.holderDrop:this.sourceNode;if(i=n.find((e=>e.contains(t))),!i)return;if(a.target=i,this.flipIns){if("running"===i?.flip?.anim?.playState)return;if(this.updatePoints(e,i),this.insertUpdateArrow(i),super.listen({name:"dragMove",params:[a]}),!r||!this.insertable(i,this.sourceNode))return;s=this.cloneStart(l),this.flipIns.setNowRects(),s&&this.cloneEnd({target:i,source:this.sourceNode,relatedTarget:s,event:e},(t=>{o=t,this.sourceNode=t})),"swap"===this.options.purpose?this.swapNodes(i,this.sourceNode):this.insertEl(i,o,e),this.flipIns.playAll(),a.point=this.lastPoint,a.type=this.getTransferType(),super.listen({name:"transferred",params:[a]}),this.isTransferred=!0}else{if(this.updatePoints(e,i),this.insertUpdateArrow(i),super.listen({name:"dragMove",params:[a]}),"drop"===this.options.method||!this.insertable(i,this.sourceNode))return;s=this.cloneStart(l),s&&this.cloneEnd({target:i,source:this.sourceNode,relatedTarget:s,event:e},(t=>{o=t,this.sourceNode=t})),this.insertEl(i,o,e),a.point=this.lastPoint,a.type=this.getTransferType(),super.listen({name:"transferred",params:[a]}),this.isTransferred=!0}}}),this.options.throttle),this.mousedownEvt=async t=>{await this.commTrigger(t)},this.mouseupEvt=t=>{this.commFinished(t)},this.setMutationObs(),super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}this.triggered=!1,this.parentEl=getEl(this.options.parent),this.selfEls=[],this.dragEls=[],this.dropEls=[],this.hoverCount=0,this.cloned=!1,this.updateWrapEls(),this.updateHandleEls(),this.setWrapsObs(),this.updateIgnoreEls(),this.sourceNode=null,this.setAttrs(),this.holderAttr=["left","right"].includes(this.options.arrow.placement)?"height":["top","bottom"].includes(this.options.arrow.placement)?"width":"",this.setFlip(),this.options.original?s.isTouchScr?this.setCommDrag():this.setDestopDrag():this.setCommDrag(),this.handleEmpty(),super.listen({name:"initiated",cb:t})}setCommDrag(){this.gestureIns=new Gesture(this.targetEl,{rotate:!1,scale:!1,drift:!1,wheel:!1,translate:{target:this.options.handle},b4Trigger:t=>new Promise((async(e,s)=>{!1===await this.commTrigger(t)?s():e(null)})),onStart:t=>{this.commDragStart(t),this.ghostEl=this.getGhostNode(this.sourceNode),this.sourceNode.parentNode.appendChild(this.ghostEl)},onEnter:t=>{this.commDragEnter(t.evtTarget,t)},onLeave:t=>{this.commDragLeave(t.evtTarget,t.relatedTarget,t)},onMove:t=>{this.setGhostPos(t.translate.value),!1===this.commDragOver(t.evtTarget,t)&&super.listen({name:"dragOut",params:[t]})},onEnd:async t=>{!1===await this.commDragDrop(t.evtTarget,t)&&super.listen({name:"dropOut",params:[t]}),this.commDragEnd(t.evtTarget,t)},onFinished:t=>{this.revert(),super.listen({name:"finished",params:[t]})},onCanceled:t=>{this.revert(),super.listen({name:"dragCancel",params:[{...t}]})}})}canClone(t){let e=this.options.original&&!s.isTouchScr?!this.selfEls.includes(s.dragNode):this.otherGroupIns.find((e=>e.targetEl.contains(t)));return"clone"===this.options.pushable.intent&&e}cloneStart(t=!0){if(!t||this.cloned)return;let e=this.getCopyNode(this.sourceNode);return this.flipIns&&this.flipIns.add(e),this.sourceNode.style.position="absolute",this.sourceNode.insertAdjacentElement("afterend",e),e}cloneEnd(t,e){t.relatedTarget&&(super.listen({name:"cloned",params:[t]}),this.sourceNode.style.position="",this.cloned=!0,e?e(t.relatedTarget):this.sourceNode=t.relatedTarget)}getTransferType(){return"auto"===this.options.purpose?"inside"===this.lastPoint?"embed":"sort":this.options.purpose}getFlipChldren(){return this.options.drags?[...this.dragEls,...this.dropEls]:this.dropEls}getCopyNode(t){let e=t.cloneNode(!0);return e.removeAttribute("draggable"),e.classList.remove(`${s.prefix}drag-wait`),e.toggleAttribute("cloned",!0),e}getGhostNode(t){let e=t.cloneNode(!0),i=style(t),a=t.getBoundingClientRect(),l=a.left-parseFloat(i.marginLeft),n=a.top-parseFloat(i.marginTop);return e.removeAttribute("draggable"),e.classList.remove(`${s.prefix}drag-wait`),e.classList.add(`${s.prefix}drag-ghost`),e.style.width=`min(${i.width},100%)`,e.style.height=i.height,e.style.left=l+"px",e.style.top=n+"px",e.initVal={left:l,top:n},e}setGhostPos(t){this.ghostEl.style.left=this.ghostEl.initVal.left+t.x+"px",this.ghostEl.style.top=this.ghostEl.initVal.top+t.y+"px"}hideGhost(){if(!this.ghostEl||elState(this.ghostEl).isVirtual)return;if(this.isTransferred)return void this.ghostEl.remove();let t=this.sourceNode.getBoundingClientRect(),e=style(this.ghostEl),s=t.left-parseFloat(e.marginLeft),i=t.top-parseFloat(e.marginTop);this.ghostEl.animate([{opacity:e.opacity,left:e.left,top:e.top},{opacity:0,left:s+"px",top:i+"px"}],{duration:this.options.duration,easing:this.flipIns?this.flipIns.options.easing:"ease-out",fill:"forwards"}).addEventListener("finish",(()=>{this.ghostEl.remove()}))}updateHandleEls(){if(this.handleEls.length)for(let t of this.handleEls)t.removeAttribute("handle");this.handleEls=getEls(this.options.handle,this.parentEl);for(let t of this.handleEls)t.setAttribute("handle","")}updateIgnoreEls(){this.ignoreEls=getEls(this.options.ignore,this.targetEl)}updateWrapEls(){this.wrapEls=this.options.wraps?getEls(this.options.wraps,this.targetEl):[this.targetEl]}setMutationObs(){this.childObs=new MutationObserver((t=>{this.options.showEmpty&&this.handleEmpty()})),this.childObsOpts={childList:!0,subtree:!1}}setWrapsObs(){if(this.options.showEmpty)for(let t of this.wrapEls)this.childObs.observe(t,this.childObsOpts)}hideHolder(){this.holderDrop.toggleAttribute("dropping",!1),elState(this.holderDrop).isVisible&&(this.holderDrop.classList.add(`${s.prefix}d-none`),this.holderDrop.remove())}replaceNodes(t,e){let s=t.parentNode,i=e.parentNode,a=t.nextElementSibling,l=e.nextElementSibling;s.insertBefore(e,a),i.insertBefore(t,l)}swapNodes(t,e){this.replaceNodes(t,e),super.listen({name:"swapped",params:[{target:t,source:e}]})}getEmbedEl(t){return getEl(this.options.embed.selector,t)||t}insertable(t,e){let s=this.getEmbedPoint(),i=this.getEmbedEl(t),a=t.nextElementSibling===e&&"after"===this.lastPoint,l=t.previousElementSibling===e&&"before"===this.lastPoint,n="swap"===this.options.purpose,r=e.parentNode===i,o="afterbegin"===s&&t.firstChildElement===e,h="beforeend"===s&&t.lastChildElement===e,p="embed"===this.options.purpose?r:"inside"===this.lastPoint&&"auto"===this.options.purpose?o||h:a||l;return!!n||!p}getEmbedPoint(){return"after"===this.options.embed.position?"beforeend":"before"===this.options.embed.position||this.targetPoints.includes("t/2")||this.targetPoints.includes("l/2")?"afterbegin":"beforeend"}insertEl(t,e,s,i){if(i)t.insertAdjacentElement(i,e),super.listen({name:"embeded",params:[{target:t,source:e,position:i,event:s}]});else if(t===this.holderDrop)t.insertAdjacentElement("beforebegin",e);else if("embed"===this.options.purpose||"inside"===this.lastPoint&&"auto"===this.options.purpose){let i=this.getEmbedEl(t),a=this.getEmbedPoint();if("embed"===this.options.purpose&&e.parentNode===i)return;i.insertAdjacentElement(a,e),super.listen({name:"embeded",params:[{target:i,source:e,position:a,event:s}]})}else{if(t.nextElementSibling===e&&"after"===this.lastPoint||t.previousElementSibling===e&&"before"===this.lastPoint)return;t.insertAdjacentElement("before"===this.lastPoint?"beforebegin":"afterend",e),super.listen({name:"sorted",params:[{target:t,source:e,position:this.lastPoint,event:s}]})}}updatePoints(t,e){this.targetPoints=getRectPoints(t.orgEvt||t,e);let s=this.targetPoints.find((t=>this.options.point.before.includes(t))),i=this.targetPoints.find((t=>this.options.point.after.includes(t)));this.lastPoint=this.targetPoints.includes("outside")?"":s?"before":i?"after":"inside"}insertUpdateArrow(t){if(this.options.arrow.enable)if(this.lastPoint){if(this.dropArrow.setAttribute("point",this.lastPoint),elState(this.dropArrow).isVirtual){(getEl(this.options.arrow.selector,t)||t).appendChild(this.dropArrow)}}else this.dropArrow.remove()}removeArrow(){this.options.arrow.enable&&!elState(this.dropArrow).isVirtual&&this.dropArrow.remove()}setHolderAttrs(){if(!this.options.holder.enable)return;let t=style(this.sourceNode);if(this.holderDrop.style.setProperty(`--${s.prefix}holder-w`,`min(${t.width},100%)`),this.holderDrop.style.setProperty(`--${s.prefix}holder-h`,t.height),this.holderDrop.style.setProperty(`--${s.prefix}holder-r`,t.borderRadius),this.holderDrop.style.setProperty(`--${s.prefix}holder-m`,t.margin),this.options.holder.style.length)for(let e of this.options.holder.style)this.holderDrop.style.setProperty(e,t[e])}toggleDropped(t,e=!0){t&&t.toggleAttribute("dropped",e)}removeDroppeds(){for(let t of[...this.dragEls])t.toggleAttribute("dropped",!1)}toggleDropping(t,e=!0){(this.dropEls.includes(t)||this.wrapEls.includes(t))&&t.toggleAttribute("dropping",e)}removeDroppings(){for(let t of[...this.dropEls,...this.wrapEls])t.toggleAttribute("dropping",!1)}removeDraggables(){for(let t of[...this.dragEls])t.removeAttribute("draggable")}setFlip(){if(!this.options.flip.enable)return;let t=extend({target:{children:this.getFlipChldren(),b4Play:t=>new Promise((e=>{t!==this.holderDrop||t===this.holderDrop&&!this.holderDrop.classList.contains(`${s.prefix}d-none`)?e(null):t===this.holderDrop&&this.holderDrop.classList.contains(`${s.prefix}d-none`)&&t.classList.remove(`${s.prefix}d-none`)})),onPlayedAll:()=>{this.commDragThrot.cancel()}},source:this.options.flip});this.flipIns=new Flip(t)}setDestopDrag(){!s.isTouchScr&&this.options.original&&(this.removeMouseEvents(),this.addMouseEvents())}addMouseEvents(){!s.isTouchScr&&this.options.original&&(document.addEventListener("mousedown",this.mousedownEvt,{passive:!1}),document.addEventListener("mouseup",this.mouseupEvt,{passive:!1}))}removeMouseEvents(){!s.isTouchScr&&this.options.original&&(document.removeEventListener("mousedown",this.mousedownEvt),document.removeEventListener("mouseup",this.mouseupEvt))}addDestopEvents(){!s.isTouchScr&&this.options.original&&(this.targetEl.addEventListener("dragstart",this.dragstartEvt,{passive:!1}),this.targetEl.addEventListener("dragenter",this.dragenterEvt,{passive:!1}),this.targetEl.addEventListener("dragover",this.dragoverEvt,{passive:!1}),this.targetEl.addEventListener("dragleave",this.dragleaveEvt,{passive:!1}),this.targetEl.addEventListener("drop",this.dragdropEvt,{passive:!1}),this.targetEl.addEventListener("dragend",this.dragendEvt,{passive:!1}))}removeDestopEvents(){!s.isTouchScr&&this.options.original&&(this.targetEl.removeEventListener("dragstart",this.dragstartEvt),this.targetEl.removeEventListener("dragenter",this.dragenterEvt),this.targetEl.removeEventListener("dragover",this.dragoverEvt),this.targetEl.removeEventListener("dragleave",this.dragleaveEvt),this.targetEl.removeEventListener("drop",this.dragdropEvt),this.targetEl.removeEventListener("dragend",this.dragendEvt))}setAttrs(){}getGoupDrags(){return this.otherGroupIns=h.findAll("drag").filter((t=>t!==this&&this.options.group&&t.options.group===this.options.group)),this.otherGroupIns.length?this.otherGroupIns.map((t=>t.options.drags?t.getSelfDragEls():t.getSelfDropEls())).flat():[]}getSelfDropEls(t=this.options.drops){let e=getEls(t,this.parentEl),s=e.length?e:getEls("[dropnode]",this.parentEl||this.targetEl),i=s.length?elsSort(s):[...this.targetEl.children],a=[];return a=this.ignoreEls.length?i.filter((t=>!this.ignoreEls.includes(t)&&"false"!==t.getAttribute("draggable"))):i.filter((t=>"false"!==t.getAttribute("draggable"))),a}getSelfDragEls(t=this.options.drags){let e=getEls(t,this.targetEl),s=e.length?e:getEls("[dragnode]",this.targetEl),i=[];return i=this.ignoreEls.length?s.filter((t=>!this.ignoreEls.includes(t)&&"false"!==t.getAttribute("draggable"))):s.filter((t=>"false"!==t.getAttribute("draggable"))),i}updateDragsDrops(){this.options.drags?(this.selfEls=this.getSelfDragEls(this.options.drags),this.dragEls=[...this.selfEls,...this.getGoupDrags()],this.dropEls=[this.holderDrop,...this.getSelfDropEls(this.options.drops).filter((t=>!this.dragEls.includes(t)))]):(this.selfEls=this.getSelfDropEls(this.options.drops),this.dragEls=[...this.selfEls,...this.getGoupDrags()],this.dropEls=[this.holderDrop,...this.dragEls])}handleEmpty(t){if(!this.options.showEmpty)return;let fn=t=>{let e=t.children.length,i=getEl(`:scope > .${s.prefix}holder-empty`,t);e?e>1&&i&&i&&i.remove():t.appendChild(this.holderEmpty.cloneNode(!0))};if(t)fn(t);else for(let t of this.wrapEls)fn(t)}updateList(t,e){return this.destroyed||(Object.assign(this.options,t),super.listen({name:"updatedList",cb:e,params:[t]})),this}revert(){this.triggered&&(this.hideGhost(),this.targetPoints=[],this.lastPoint="",this.hideHolder(),this.sourceNode.classList.remove(`${s.prefix}drag-wait`),this.removeDroppings(),this.removeDraggables(),this.removeArrow(),this.removeDestopEvents(),this.gestureIns&&this.gestureIns.removeSecondEvents(),this.hoverCount=0,this.cloned=!1,document.body.toggleAttribute("dragbody",!1),this.isTransferred=!1,this.triggered=!1)}destroy(t){if(!this.destroyed)return this.revert(),this.gestureIns&&this.gestureIns.destroy(),this.removeMouseEvents(),this.removeDestopEvents(),this.options.showEmpty&&this.childObs.disconnect(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}let _=`<i class="${s.prefix}c-ignore">${l.lang.tags.emptyholder}</i>`,Z=l.lang.tags.placeholder,K=l.splitHyphen;const J=[{attr:"ajax",prop:"ajax",value:{}},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"theme",prop:"theme",value:""},{attr:"size",prop:"size",value:"md"},{attr:"field",prop:"field",value:"label"},{attr:"type",prop:"type",value:""},{attr:"compact",prop:"compact",value:!1},{attr:"shape",prop:"shape",value:""},{attr:"max",prop:"max",value:0},{attr:"min",prop:"min",value:0},{attr:"sliced",prop:"sliced",value:!0},{attr:"classes",prop:"classes",value:""},{attr:"unique",prop:"unique",value:{enable:!1,refer:"id",template:`{{this.field}}<i class="${s.prefix}c-brief">({{this.key}}:{{this.value}})</i>`}},{attr:"empty",prop:"empty",value:{enable:!0,content:_}},{attr:"editor",prop:"editor",value:{enable:!1,addable:!0,deletable:!0,selector:"",placeholder:Z}},{attr:"removable",prop:"removable",value:!1},{attr:"separator",prop:"separator",value:K},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-edit",prop:"b4Edit",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-duplicated",prop:"onDuplicated",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-output",prop:"onOutput",value:null},...p];class Tags extends ModBaseListenCache{options={};emptyEl;content;editEvent;toggleSelected;output;maxIndex;dataOrig;dataObs;data;editEl;last;labelEl;imgNone;static hostType="node";static optMaps=J;constructor(t,e={},i=l.initial){super(),super.ready({options:e,maps:Tags.optMaps,host:t,component:!0,spread:["edit","unique","empty"]}),this.emptyEl=createEl("span",{[s.alias]:"empty"},this.options.empty.content),this.content="";let a=this;this.editEvent=async t=>{let e=this.editEl.value.trim(),s=this.data.find((t=>t.selected));if(e)this.editEl.style.width=e.length+"em",this.options.editor.addable&&"Enter"===t.code&&this.add(e,(()=>{this.editEl.value="",this.editEl.focus()})),s&&(s.selected=!1);else if(this.editEl.style.cssText=this.editEl.style.cssText.replace("width:",""),this.options.editor.deletable&&"Backspace"===t.code&&this.data.length>0){let t=this.data.slice(-1)[0];t.selected?this.remove(t):t.selected=!0}else s&&(s.selected=!1)},this.toggleSelected=function(t){if("remove"!==t.target.getAttribute(s.alias)){let t=a.data.find((t=>t.wrapEl===this));t.selected=!0,a.data.filter((e=>e!==t)).forEach((t=>{t.selected=!1}))}},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.output={value:"",raw:"",items:[]},this.maxIndex=0,this.initContent(),this.setEmpty(),this.createEditor(),await getContent.call(this,{content:this.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.targetEl,...this.options.ajax},cb:async t=>{await this.renderContent(t)}}),this.setAttrs(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}initContent(){this.options.content?this.content=this.options.content:this.content=this.rawHtml||this.targetEl.innerHTML}setDataObs(){this.dataOrig=[],this.dataObs=new Observe(this.dataOrig,{deep:!0,onSet:t=>{t.key===this.options.field||"label"===t.key?t.target.labelEl.innerHTML=t.value:["selected","disabled"].includes(t.key)?t.target.wrapEl.toggleAttribute(t.key,t.value):"theme"===t.key?t.target.wrapEl.setAttribute(t.key,t.value):"icon"===t.key&&t.proxy.iconEl?classes(t.proxy.iconEl).replace(t.raw,t.value):"cube"===t.key&&t.proxy.cubeEl?t.proxy.cubeEl.src=t.value:"disk"===t.key&&t.proxy.diskEl?t.proxy.diskEl.src=t.value:"image"===t.key&&t.proxy.imageEl?t.proxy.imageEl.src=t.value:["href","target","rel","download"].includes(t.key)&&"A"===this.labelEl.nodeName&&(t.target.labelEl[t.key]=t.value)},onCompleted:t=>{if(this.toggleEmpty(),this.options.storName){let t={content:isEmpty(this.options.content)?"":deepClone(this.dataOrig)};super.updateCache(t)}}}),this.data=this.dataObs.proxy}setOutput(){this.output.value=this.getStrVals(),this.output.items=[...this.data],super.listen({name:"output",params:[this.output]})}async renderContent(t){try{if(this.options.b4Fill){let e=await this.options.b4Fill.call(this,t,this.targetEl);e&&(t=e)}}catch(t){return this}this.setDataObs();let e=this.getSource(t);try{let t=await this.moreExceed({data:e,source:this.data});t&&(e=t)}catch{return}this.render(e),this.data.push(...e)}getStrVals(){return this.data.map((t=>t[this.options.field])).join(this.options.separator)}getSource(t){let e=[];if(!isEmpty(t))if(Array.isArray(t))e="string"==typeof t[0]?t.map((t=>({[this.options.field]:t,theme:""}))):t;else if("object"==typeof t)e=[t];else if("string"==typeof t){let s=[...createEl("div",{},t).children];if(s.length)if("SELECT"===s[0].nodeName)e=select2Tree(s[0]);else if("INPUT"===s[0].nodeName)e=S.fromInput(s[0],this.options.separator);else for(let t of s){let s={};t.hasAttribute("label")&&(s.label=t.getAttribute("label")),t.hasAttribute("value")&&(s.value=t.getAttribute("value")),t.hasAttribute("icon")&&(s.icon=t.getAttribute("icon")),t.hasAttribute("disk")&&(s.disk=t.getAttribute("disk")),t.hasAttribute("cube")&&(s.cube=t.getAttribute("cube")),t.hasAttribute("image")&&(s.image=t.getAttribute("image")),t.hasAttribute("disabled")&&(s.disabled=!0),t.hasAttribute("theme")&&(s.theme=t.getAttribute("theme")),s[this.options.field]=t.hasAttribute(this.options.field)?t.getAttribute(this.options.field):t.textContent,"A"===t.nodeName&&(s={...s,href:t.getAttribute("href"),target:t.target,rel:t.rel,download:t.download}),e.push(s)}else{e=t.trim().split(this.options.separator).map((t=>({[this.options.field]:t,theme:""})))}}return e=e.filter((t=>t&&!this.data.includes(t))),e.forEach(((t,e)=>{!t.hasOwnProperty("id")&&(t.id=this.maxIndex+e)})),this.maxIndex+=e.length,e}render(t){if(!isEmpty(t)){let e=document.createDocumentFragment();for(let s of t)s.wrapEl=this.createTag(s),e.appendChild(s.wrapEl);this.targetEl.appendChild(e)}this.options.editor.enable&&!this.options.editor.selector&&this.targetEl.appendChild(this.editEl)}setAttrs(){this.targetEl.classList.add(`${s.prefix}tags`),classes(this.targetEl).add(this.options.classes),this.options.theme?this.targetEl.setAttribute("theme",this.options.theme):this.targetEl.removeAttribute("theme"),this.options.type?this.targetEl.setAttribute("type",this.options.type):this.targetEl.removeAttribute("type"),this.targetEl.toggleAttribute("compact",this.options.compact),this.options.shape?this.targetEl.setAttribute("shape",this.options.shape):this.targetEl.removeAttribute("shape"),this.options.size?this.targetEl.setAttribute("size",this.options.size):this.targetEl.removeAttribute("size")}setEmpty(){this.targetEl.innerHTML=""}useLegend(t){t.hasOwnProperty("icon")&&(t.iconEl=createEl("i",{[s.alias]:"icon",class:`${t.icon}`}),t.labelEl.insertAdjacentElement("beforebegin",t.iconEl)),t.hasOwnProperty("disk")&&(t.diskEl=createEl("img",{[s.alias]:"disk",src:`${t.disk||s.images.none}`}),t.labelEl.insertAdjacentElement("beforebegin",t.diskEl)),t.hasOwnProperty("cube")&&(t.cubeEl=createEl("img",{[s.alias]:"cube",src:`${t.cube||s.images.none}`}),t.labelEl.insertAdjacentElement("beforebegin",t.cubeEl)),t.hasOwnProperty("image")&&(t.imageEl=createEl("img",{[s.alias]:"image",src:`${t.image||s.images.none}`}),t.labelEl.insertAdjacentElement("beforebegin",t.imageEl))}createTag(t){let e={[s.alias]:"label"},i=this.data.find((e=>e!==t&&e[this.options.field]===t[this.options.field]))?renderTpl(this.options.unique.template,{field:t[this.options.field],value:t[this.options.unique.refer],key:this.options.unique.refer}):t[this.options.field];return t.hasOwnProperty("href")&&(e.href=t.href),t.hasOwnProperty("href")&&t.target&&(e.target=t.target),t.hasOwnProperty("href")&&t.rel&&(e.rel=t.rel),t.hasOwnProperty("href")&&t.download&&(e.download=t.download),t.labelEl=createEl(e.hasOwnProperty("href")?"a":"i",e,i),t.wrapEl=createEl("span",{class:`${s.prefix}tag`},t.labelEl),t.removeEl=createEl("i",{[s.alias]:"remove"}),this.options.removable&&t.wrapEl.appendChild(t.removeEl),this.useLegend(t),!this.options.theme&&t.theme&&t.wrapEl.setAttribute("theme",t.theme),t.disabled&&t.wrapEl.setAttribute("disabled",""),t.selected&&t.wrapEl.setAttribute("selected",""),t.wrapEl}createEditor(){if(!this.options.editor.enable||this.destroyed)return;let t=getEl(this.options.editor.selector);t?(this.editEl=t,!this.editEl.hasAttribute("placeholder")&&this.editEl.setAttribute("placeholder",this.options.editor.placeholder)):this.editEl=createEl("input",{type:"text",placeholder:this.options.editor.placeholder}),this.editEl.removeEventListener("keyup",this.editEvent),this.editEl.addEventListener("keyup",this.editEvent)}toggleEmpty(){this.options.empty.enable&&(this.data.length?this.emptyEl.remove():(this.targetEl.insertAdjacentElement("afterbegin",this.emptyEl),this.maxIndex=0))}renderFinish(){this.toggleEmpty();for(let t of this.data)t.wrapEl.addEventListener("click",this.toggleSelected,!1),t.removeEl.onclick=()=>{this.remove(t)};this.last=this.dataOrig[this.data.length-1]}getVals(t){if(this.destroyed)return this;let e={value:this.getStrVals(),items:[...this.data]};return super.listen({name:"got",cb:t,params:[e]}),e}async updateCont(t,e){return this.destroyed||(this.setEmpty(),await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.targetEl,...this.options.ajax},cb:async s=>{this.saveRaw(),await this.renderContent(s),this.renderFinish(),super.updateCache({content:t}),super.listen({name:"updatedCont",cb:e,params:[this.dataOrig]}),this.setOutput()}})),this}saveRaw(){this.output.raw=this.getStrVals()}async add(t,e){if(isEmpty(t)||this.destroyed)return this;let s=this.getSource(t),i=[],a=0,l=this.data.map((t=>t[this.options.field]));if(this.options.unique.enable&&(s=unique(s,this.options.field),a=s.length,s=s.map((t=>{let e;return l.includes(t[this.options.field])?i.push(t):e=t,e})).filter(Boolean),a!==s.length&&(new Message({content:0===s.length?this.options.lang.includeFull:this.options.lang.includePart,status:"warn",iconShow:!0}).show(),super.listen({name:"duplicated",params:[i]}))),0===s.length)return this;try{let t=await super.moreExceed({data:s,source:this.data});t&&(s=t)}catch{return}try{if(this.options.b4Add){let t=await this.options.b4Add.call(this,s);t&&(s=t)}}catch(t){return this}return Array.isArray(s)&&s.length?(this.saveRaw(),this.render(s),this.data.push(...s),this.renderFinish(),this.setOutput(),super.listen({name:"added",cb:e,params:[s]}),this):this}async remove(t,e){if(isEmpty(t)||this.destroyed||!this.data.length)return this;let s=findItems(t,this.data,"",{node:"wrapEl",string:this.options.field,separator:this.options.separator});try{if(this.options.b4Remove){let t=await this.options.b4Remove.call(this,s);t&&(s=t)}}catch(t){return this}try{let t=await this.lessExceed({data:s,source:this.data});t&&(s=t)}catch{return}if(!Array.isArray(s)||!s.length)return this;this.saveRaw();for(let t=0;t<this.data.length;t++){let e=this.data[t];s.includes(e)&&(this.data.splice(t--,1),e.wrapEl.remove())}return this.setOutput(),super.listen({name:"removed",cb:e,params:[s]}),this}async edit(t,e,s){if(isEmpty(t)||this.destroyed||!this.data.length)return this;let i=findItem(t,this.data,"",{node:"wrapEl",string:this.options.field});if(!i)return this;try{if(this.options.b4Edit){let t=await this.options.b4Edit.call(this,i);t&&(i=t)}}catch(t){return this}return i?(Object.assign(i,e),super.listen({name:"edited",cb:s,params:[i]}),this):this}async clear(t){return this.destroyed||!this.data.length||(this.options.b4Clear&&await this.options.b4Clear.call(this),this.saveRaw(),this.data.splice(0),this.maxIndex=0,this.targetEl.innerHTML="",this.options.editor.enable&&this.targetEl.appendChild(this.editEl),this.setOutput(),super.listen({name:"cleared",cb:t})),this}destroy(t){return this.data.forEach((t=>{t.wrapEl.removeEventListener("click",this.toggleSelected),t.removeEl.onclick=null})),this.options.editor.enable&&this.editEl.removeEventListener("keyup",this.editEvent),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}class Tree extends ModBaseListenCacheNest{options={};treeDataOrig;searchs;ignores;editorEl;lastExpanded;dropTag;pagination;searchEl;resultIns;resultEl;inputEl;output;value;expandEvt;selectEvt;searchEvgt;lineEvt;bubbleIns;receiver;hoverIns;contXhr;floorMax;chainChecking;seqItems;maxIndex;excludeDrags;rawData;observeIns;static hostType="node";static optMaps=U;static dependencies=[BadgeElem];constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Tree.optMaps,component:!0,spread:["output","arrow","check","legend","select","shortcut","tools","drag","paginated","bubble"]});let a=this;this.expandEvt=debounce((function(){let t="arrow"===this.getAttribute(s.alias)?"arrowEl":"legend"===this.getAttribute(s.alias)?"legendEl":"headEl",e=findItem(this,a.flatData,t);a.toggleExpanded(e)}),this.options.delay),this.selectEvt=debounce((function(){let t=findItem(this,a.flatData,"labelEl");a.toggleSelected(t),t&&t.toolsEl&&"click"===a.options.tools.trigger&&(attrValBool(t.selected)?show({el:t.toolsEl}):hide({el:t.toolsEl}))}),this.options.delay),this.searchEvgt=debounce((function(){a.search(this.value)}),this.options.search.delay),this.lineEvt=debounce((function(t){if(!a.options.shortcut.enable)return;let e=findItem(this,a.flatData,"headEl"),i=!1;e&&(("blank"!==a.options.shortcut.span||t.target!==e.headEl&&!["holder","group","gap"].includes(t.target.getAttribute(s.alias)))&&contains(t.target,[e.arrowEl,e.checkEl,e.toolsEl,a.options.select.enable&&!e.headEl.hasAttribute("unselectable")||"A"===e.labelEl.nodeName&&e.labelEl.hasAttribute("href")?e.labelEl:null])||(i=!0),i&&("selected"===a.options.shortcut.mean?a.toggleSelected(e):"checked"===a.options.shortcut.mean?!e.checkEl.hasAttribute("disabled")&&a.toggleCheck(e):"expanded"===a.options.shortcut.mean?a.toggleExpanded(e):"auto"===a.options.shortcut.mean&&(e.children?a.toggleExpanded(e):a.options.check.enable&&!e.checkEl.hasAttribute("disabled")?a.toggleCheck(e):a.toggleSelected(e))))}),this.options.delay),this.editorEl=createEl("input",{type:"text"}),this.lastExpanded=-1,this.dropTag=this.options.drop.attr||"dropnode",this.treeDataOrig=[],this.pagination={label:this.options.lang.paginated.main,id:this.options.rootStart,children:[],wrapEl:this.targetEl},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}if(this.output={value:"",raw:"",items:[]},this.correctOpts(),super.useTpl(),this.searchs=[],this.floorMax=0,this.chainChecking=!1,this.seqItems=[],this.setFeature(),this.maxIndex=this.options.idStart,this.options.bubble.enable){let t=this.targetEl;this.receiver=getEl(this.options.output.target)||this.targetEl,(this.receiver.nodeName.includes("INPUT")||this.receiver.nodeName.includes("TEXTAREA"))&&this.receiver.toggleAttribute("readonly",!0),this.targetEl=createEl("div");let e=!(!this.options.output.enable||this.options.output.instant)&&{enable:!0,children:["close",{name:"clear",action:t=>{t.el.onclick=()=>{this.clearVals()}}},{name:"confirm",action:t=>{t.el.onclick=()=>{this.setVals(),this.bubbleIns.hide()}}}]};this.bubbleIns=new Function("host","module","options",'"use strict";return new module(host,options)')(t,s[capStart(this.options.bubble.type.trim())],Object.assign({trigger:"click",content:this.targetEl,contType:"node",placement:"popup"===this.options.bubble.type?"bottom-start":"",footer:e},this.options.bubble))}else this.receiver=getEl(this.options.output.target);return await this.getDataToRender(),this.excludeDrags=isEmpty(this.options.drag.exclude)?[]:findItems(this.options.drag.exclude,this.flatData),this.setAttrs(),this.setResult(),this.renderFinish(),super.initCheckeds(),this.initExpandeds(),this.initSelecteds(),super.initDisableds(),super.initReadonlys(),this.updateResult(this.getVals().value),this.setSearch(),super.listen({name:"initiated",cb:t}),this}correctOpts(){isEmpty(this.options.value)||("checked"===this.options.output.from?this.options.check.value=this.options.value:this.options.select.value=this.options.value)}setFeature(){this.options.feature.type&&extend({target:this.options,source:{shortcut:{enable:!0,mean:"checked",span:"whole"},expand:{...this.options.feature.expand},check:{enable:!0,...this.options.feature.check},select:{enable:!1},arrow:{enable:!(this.options.feature.expand.all&&!this.options.feature.expand.only)},output:{from:"checked"},layout:this.options.feature.layout[this.options.feature.type]}})}async sqlToAdd(t){if(!this.options.content)return;let e=S.allToTree({content:this.options.content,contType:this.options.contType,contData:{pId:t.id,pLabel:t.label,pValue:t.value,...this.options.sqlData},ajax:{spinSel:t.arrowEl,xhrName:"contXhr"},ins:this,fill:!1});await e.then((async e=>{let s=e.hasOwnProperty("data")&&Array.isArray(e.data)?e.data:e;await this.add({data:s,target:t,isFront:!1,autoFill:!this.options.paginated.enable}),this.options.paginated.enable&&this.turnFirstPage(t)}))}async getDataToRender(){let t,e={rootStart:this.options.rootStart,idStart:this.options.idStart,floorStart:this.options.floorStart};return t=this.options.content?S.allToTree({content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{spinSel:this.targetEl,xhrName:"contXhr"},ins:this,...e}):S.allToTree({content:this.targetEl.innerHTML,...e}),await t.then((t=>{this.treeDataOrig=t.data&&Array.isArray(t.data)?t.data:t,this.rawData=t})),this.targetEl.innerHTML="",await this.renderData(this.treeDataOrig),this.getTreeFlat(),super.listen({name:"rendered",params:[this.treeData,this.flatData]}),this}getTreeFlat(){this.treeData=this.getObserver(this.treeDataOrig).proxy,this.pagination.children=this.treeData,this.flatData=S.toFlat(this.treeData)}getObserver(t){return this.observeIns=new Observe(t,{deep:{enable:!0,exclude:["tools"]},onSet:t=>{if("icon"===t.key&&t.proxy.iconEl)classes(t.proxy.iconEl).replace(t.raw,t.value);else if("cube"===t.key&&t.proxy.cubeEl)t.proxy.cubeEl.src=t.value;else if("disk"===t.key&&t.proxy.diskEl)t.proxy.diskEl.src=t.value;else if("image"===t.key&&t.proxy.imageEl)t.proxy.imageEl.src=t.value;else if("label"===t.key)t.proxy.labelEl.innerHTML=t.value;else if("tips"===t.key&&t.proxy.tipsEl)t.proxy.tipsEl.innerHTML=t.value;else if("brief"===t.key&&t.proxy.briefEl)super.updateElCont(t.proxy,t.value);else if("custom"===t.key&&t.proxy.customEl)super.updateElCont(t.proxy,t.value,"custom");else if("badge"===t.key&&t.proxy.badgeEl)t.proxy.badgeEl.setAttribute("label",t.value);else if("href"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.href=t.value;else if("rel"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.rel=t.value;else if("target"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.target=t.value;else if("onclilck"===t.key)t.proxy.labelEl.setAttribute(t.key,t.value);else if("floor"===t.key)t.proxy.indentHeadEl.innerHTML=t.proxy.indentBodyEl.innerHTML=t.proxy.indentFootEl.innerHTML=this.getIndentHtml(t.value),this.updateChildrenFloor(t.proxy);else if("atEnd"===t.key);else if("expanded"===t.key&&t.proxy.children)t.proxy.arrowEl&&super.toggleArrow(attrValBool(t.value),t.proxy),this.toggleParentLegend(t.proxy);else if("selected"===t.key)t.proxy.headEl.toggleAttribute("selected",attrValBool(t.value)),this.updateSeqItems(t,"selected");else if("disabled"===t.key)t.proxy.headEl.toggleAttribute("disabled",attrValBool(t.value));else if("readonly"===t.key)t.proxy.headEl.toggleAttribute("readonly",attrValBool(t.value));else if("checked"===t.key){let e=attrValBool(t.value);t.proxy.headEl.toggleAttribute("checked",e),t.proxy.checkEl&&t.proxy.checkEl.setAttribute("check",e?"ed":""),this.updateSeqItems(t,"checked")}else"children"===t.key&&(!t.raw&&t.value?this.child2Parent(t.proxy):t.raw&&!t.value&&this.parent2Child(t.proxy))},onDeleted:t=>{"children"===t.key&&S.parentToChild(t.proxy)},onCompleted:t=>{if((t.keys.set.includes("selected")&&"selected"===this.options.output.from||t.keys.set.includes("checked")&&"checked"===this.options.output.from)&&this.updateVals(),this.options.check.enable&&this.options.check.max){let t=super.getCheckeds(),e=super.getUncheckeds(),setDisabled=t=>{for(let e of t)!attrValBool(e.disabled)&&e.checkEl.toggleAttribute("disabled",!0),e.headEl.toggleAttribute("exceeded",!0)};if(t.length>=this.options.check.max)setDisabled(e),super.listen({name:"stopChecked",params:[e]});else if(t.length<=this.options.check.min)setDisabled(t),super.listen({name:"stopUnchecked",params:[t]});else{for(let t of this.flatData)t.checkEl.removeAttribute("disabled"),t.headEl.toggleAttribute("exceeded",!1);super.listen({name:"rechecked"})}}if(this.options.storName){let t={select:{value:S.getBoolItems(this.flatData,"selected").map((t=>t.id))},check:{value:S.getBoolItems(this.flatData,"checked").map((t=>t.id))},expand:S.getBoolItems(this.flatData,"expanded").map((t=>t.id)),disable:S.getBoolItems(this.flatData,"disabled").map((t=>t.id)),readonly:S.getBoolItems(this.flatData,"readonly").map((t=>t.id)),content:isEmpty(this.options.content)?"":deepClone(this.treeDataOrig)};super.updateCache(t)}}}),this.observeIns}updateSeqItems(t,e="selected"){this.options.output.from===e&&splice({host:this.seqItems,source:t.proxy,intent:t.value?"end+":"remove"}),this.seqItems.length&&("checked"===e&&"radio"===this.options.check.type||"selected"===e&&this.options.select.only)&&(this.seqItems=this.seqItems.slice(-1))}initExpandeds(){let t=valToArr(this.options.expand.value).map((t=>findItem(t,this.flatData))).filter(Boolean),e=this.flatData.filter((t=>attrValBool(t.expanded)&&t.children)),s=[...e,...t];for(let t of e)t.expanded=!1;if(this.options.expand.all)if(this.options.expand.only){let t=this.getParentsGroupBy(this.flatData);for(let e in t)t[e][0]&&super.expand(t[e][0])}else super.expandAll();else if(this.options.expand.only){let t=this.getParentsGroupBy(s);for(let e in t)t[e][0]&&super.expand(t[e][0])}else super.expand(s)}initSelecteds(){if(!this.options.select.enable)return;let t=valToArr(this.options.select.value).map((t=>findItem(t,this.flatData))).filter(Boolean),e=this.flatData.filter((t=>attrValBool(t.selected))),s=[...e,...t];for(let t of e)t.selected=!1;this.select(this.options.select.only?s[0]:s)}getSelecteds(){return this.flatData.filter((t=>attrValBool(t.selected)))}getParentsGroupBy(t,e="pId"){return isEmpty(t)?[]:t.reduce(((t,s)=>{let i=s[e];return t[i]||(t[i]=[]),s.children&&t[i].push(s),t}),{})}getIndentHtml(t){return"<i></i>".repeat(t)}updateChildrenFloor(t){if(t.children)for(let e of t.children)e.floor=t.floor+1,this.updateChildrenFloor(e)}async renderData(t){if(!t.length)return void(this.targetEl.innerHTML=`<div class="${s.prefix}tree-empty">${this.options.lang.empty}</div>`);let e=createEl("ul"),plantTree=async(t,e)=>{let i=createEl("ul",{class:`${s.prefix}reset ${s.prefix}tree-children`});for(let s of e)this.createHeadEl(s,t),await this.createBodyEl(s),s.hasOwnProperty("children")&&(s.childrenEl=await plantTree(s,s.children)),(!this.options.deferred&&!this.options.paginated.enable||this.options.deferred&&!this.options.paginated.enable&&s.floor===this.options.floorStart||this.options.paginated.enable&&s.floor===this.options.floorStart&&this.options.paginated.exception)&&i.appendChild(s.wrapEl);return(t.wrapEl||t).appendChild(i),t.wrapEl&&this.createFootEl(t),i};await plantTree(e,t),this.resultEl=createEl("div",{class:`${s.prefix}tree-result`}),this.options.output.enable&&!this.options.output.instant&&this.targetEl.appendChild(this.resultEl),this.options.name&&(this.inputEl=createEl("input",{type:"hidden",name:this.options.name}),this.targetEl.appendChild(this.inputEl)),this.pagination.childrenEl=e.childNodes[0],super.listen({name:"insertItems",params:[t]}),this.targetEl.appendChild(this.pagination.childrenEl),this.options.paginated.enable&&!this.options.paginated.exception&&this.createFootEl(this.pagination)}updateArrowEl(t){this.options.arrow.enable&&(t.hasOwnProperty("children")?(t.arrowEl.setAttribute("type",this.options.arrow.type),this.options.lang.title.arrow&&t.arrowEl.setAttribute("title",this.options.lang.title.arrow),"image"===this.options.arrow.type?this.options.arrow.hide&&(t.arrowEl.style.backgroundImage=`url("${this.options.arrow.hide}")`):(t.arrowEl.classList.remove(`${s.prefix}none`),this.options.arrow.hide&&t.arrowEl.classList.add(this.options.arrow.hide))):(t.arrowEl.removeAttribute("type"),t.arrowEl.removeAttribute("title"),"image"===this.options.arrow.type?t.arrowEl.removeAttribute("style"):classes(t.arrowEl).remove([this.options.arrow.show,this.options.arrow.hide]).add(`${s.prefix}none`)))}async setBrief(t,e={},s){if(this.destroyed)return;let i=findItem(t,this.flatData);return await this.createBodyEl(i,!1),await super.setElCont({item:i,data:e,cb:(t,e)=>{super.listen({name:"filled",cb:s,params:[t,e]})}}),this}setLegendVal(t,e,s="icon"){"image"===s?(t.removeAttribute("class"),t.style.backgroundImage=`url("${e}")`):(t.removeAttribute("style"),t.setAttribute("class",e))}toggleParentLegend(t){this.options.legend.enable&&!t.legend&&Array.isArray(this.options.legend.parent)&&this.options.legend.parent[1]&&this.setLegendVal(t.legendEl,this.options.legend.parent[attrValBool(t.expanded)?1:0],this.options.legend.type)}updateLegendEl(t){this.options.legend.enable&&(t.legend?this.setLegendVal(t.legendEl,t.legend,this.options.legend.type):t.hasOwnProperty("children")?this.setLegendVal(t.legendEl,this.options.legend.parent[attrValBool(t.expanded)?1:0],this.options.legend.type):this.setLegendVal(t.legendEl,this.options.legend.child,this.options.legend.type))}getLegendEl(t){t.legendEl=createEl("i",{[s.alias]:"legend"}),this.updateLegendEl(t)}createHeadEl(t,e){if(!t.wrapEl){if(t.wrapEl=createEl("li",{class:`${s.prefix}tree-wrap`}),t.groupEl=createEl("div",{[s.alias]:"group"}),t.headEl?t.labelEl||(t.labelEl=createEl(t.hasOwnProperty("href")?"a":"i",{[s.alias]:"label"},t.label),t.headEl.appendChild(t.labelEl)):(t.headEl=createEl("div",{class:`${s.prefix}tree-head`}),!t.labelEl&&(t.labelEl=createEl(t.hasOwnProperty("href")?"a":"i",{[s.alias]:"label"},t.label)),t.headEl.appendChild(t.labelEl)),t.wrapEl.appendChild(t.headEl),t.href&&(t.labelEl.href=t.href),t.target&&(t.labelEl.target=t.target),t.indentHeadEl=createEl("span",{[s.alias]:"indent"}),t.indentBodyEl=createEl("span",{[s.alias]:"indent"}),t.indentFootEl=createEl("span",{[s.alias]:"indent"}),t.indentHeadEl.innerHTML=t.indentBodyEl.innerHTML=t.indentFootEl.innerHTML=this.getIndentHtml(t.floor),t.onclick&&t.labelEl.setAttribute("onclick",t.onclick),this.options.arrow.enable&&super.getArrowEl(t),t.iconEl||(t.iconEl=t.hasOwnProperty("icon")?createEl("i",{[s.alias]:"icon",class:t.icon}):null),t.diskEl||(t.diskEl=t.hasOwnProperty("disk")?createEl("img",{[s.alias]:"disk",src:t.disk||s.images.none}):null),t.cubeEl||(t.cubeEl=t.hasOwnProperty("cube")?createEl("img",{[s.alias]:"cube",src:t.cube||s.images.none}):null),t.imageEl||(t.imageEl=t.hasOwnProperty("image")?createEl("img",{[s.alias]:"image",src:t.image||s.images.none}):null),t.badgeEl||(t.badgeEl=t.badge?createEl("ax-badge",{[s.alias]:"badge",label:t.badge.toString().trim()}):null),t.tipsEl||(t.tipsEl=t.tips?createEl("i",{[s.alias]:"tips"},t.tips):null),t.customEl||(t.customEl=t.custom?createEl("div",{[s.alias]:"custom"},t.custom):null),attrValBool(t.expanded)&&t.headEl.toggleAttribute("expanded",!0),attrValBool(t.selected)&&t.headEl.toggleAttribute("selected",!0),attrValBool(t.disabled)&&t.headEl.toggleAttribute("disabled",!0),attrValBool(t.readonly)&&t.headEl.toggleAttribute("readonly",!0),attrValBool(t.checked)&&t.headEl.toggleAttribute("checked",!0),this.options.drag.enable&&t.headEl.toggleAttribute([this.dropTag],!0),this.options.check.enable&&(t.checkType=this.getCheckType(e),t.checkEl=createEl(`ax-${t.checkType}`,{[s.alias]:"check"})),this.options.legend.enable&&this.getLegendEl(t),this.options.tools.enable){t.toolsEl=createTools(this.options.tools.children,t.headEl),t.toolsEl.setAttribute(s.alias,"tools"),t.tools=deepClone(this.options.tools.children);for(let e of t.tools)this.options.lang.title[e.name]&&e.wrapEl.setAttribute("title",this.options.lang.title[e.name]),"file"===e.name?t.addfileEl=e.wrapEl:"folder"===e.name?t.addfolderEl=e.wrapEl:"remove"===e.name?t.removeEl=e.wrapEl:"edit"===e.name&&(t.editEl=e.wrapEl)}super.parseLayout(t.headEl,this.options.layout,{indent:t.indentHeadEl,arrow:t.arrowEl,label:t.labelEl,check:t.checkEl,legend:t.legendEl,icon:t.iconEl,disk:t.diskEl,cube:t.cubeEl,image:t.imageEl,badge:t.badgeEl,tips:t.tipsEl,custom:t.customEl,tools:t.toolsEl,group:t.groupEl})}}async createBodyEl(t,e=this.options.autoFill){t.bodyEl||(t.bodyEl=createEl("div",{class:`${s.prefix}tree-body`}),t.bodyEl.appendChild(t.indentBodyEl),t.indentBodyEl.insertAdjacentHTML("afterend",`<i  class="${s.prefix}none"></i>`),t.briefEl||(t.briefEl=createEl("div",{class:`${s.prefix}tree-brief`}),e&&await super.getElCont({target:t,data:t.brief,cb:e=>{t.brief=e,super.updateElCont(t)}})),t.bodyEl.appendChild(t.briefEl),t.headEl.insertAdjacentElement("afterend",t.bodyEl))}createFootEl(t){this.options.paginated.enable&&!t.pageEl&&(t.moreEl=createEl("i",{[s.alias]:"more"},this.options.lang.paginated.more),t.nextEl=createEl("i",{[s.alias]:"next"},this.options.lang.paginated.next),t.firstEl=createEl("i",{[s.alias]:"first"},this.options.lang.paginated.first),t.infoEl=createEl("i",{[s.alias]:"info"}),t.pageEl=createEl("div",{class:`${s.prefix}tree-page`},t.infoEl),this.options.paginated.override?t.pageEl.append(t.nextEl,t.firstEl):t.pageEl.appendChild(t.moreEl),t.footEl=createEl("div",{class:`${s.prefix}tree-foot`}),t!==this.pagination&&(t.footEl.appendChild(t.indentFootEl),t.indentFootEl.insertAdjacentHTML("afterend",`<i  class="${s.prefix}none"></i>`)),t.footEl.appendChild(t.pageEl),t.children&&t.wrapEl.appendChild(t.footEl))}togglePgnDisabled(t){this.options.paginated.enable&&(t.moreEl.toggleAttribute("disabled",t.atEnd),t.nextEl.toggleAttribute("disabled",t.atEnd),t.firstEl.toggleAttribute("disabled",1==t.current))}turnNextPage(t,e){if(this.destroyed)return;let s=t===this.pagination?this.pagination:findItem(t,this.flatData);if(!s)return;if(!this.options.paginated.enable||!s.children)return;let i=Math.ceil(s.children.length/this.options.paginated.count);if(this.options.paginated.override){if(s.current>=i)return;s.current=s.current||1;let t=s.children.slice(s.current*this.options.paginated.count,(s.current+1)*this.options.paginated.count);s.childrenEl.innerHTML="",s.childrenEl.append(...t.map((t=>t.wrapEl))),s.current++}else{if(s.childrenEl.children.length>=s.children.length)return;let t=s.childrenEl.children.length,e=s.children.slice(t,t+this.options.paginated.count);s.childrenEl.append(...e.map((t=>t.wrapEl))),s.current=Math.ceil(s.childrenEl.children.length/this.options.paginated.count)}return s.atEnd=i===s.current,this.togglePgnDisabled(s),this.updateInfoEl(s),super.listen({name:"turned",cb:e,params:[s]}),this}turnFirstPage(t,e){if(this.destroyed)return;let s=t===this.pagination?this.pagination:findItem(t,this.flatData);if(!s)return;if(!this.options.paginated.enable||!s.children)return;let i=s.children.slice(0,this.options.paginated.count);return this.options.paginated.override&&(s.childrenEl.innerHTML=""),s.childrenEl.append(...i.map((t=>t.wrapEl))),s.current=1,s.atEnd=s.childrenEl.children.length===s.children.length,this.togglePgnDisabled(s),this.updateInfoEl(s),super.listen({name:"turned",cb:e,params:[s]}),this}updateInfoEl(t){if(!this.options.paginated.enable)return;let e=t.children.length,s=Math.ceil(e/this.options.paginated.count),i=t.current,a={total:e,current:i,pages:s,rest:Math.max(e-i*this.options.paginated.count,0),count:this.options.paginated.count,label:t.label,id:t.id};t.infoEl.innerHTML=renderTpl(this.options.lang.paginated.info,a)}createChildrenEl(t){if(t.childrenEl)return;t.childrenEl=createEl("ul",{class:`${s.prefix}reset ${s.prefix}tree-children`}),(t.hasOwnProperty("brief")?t.bodyEl:t.headEl).insertAdjacentElement("afterEnd",t.childrenEl)}child2Parent(t){this.createChildrenEl(t),this.updateArrowEl(t),this.updateLegendEl(t),this.updateEvt(t)}parent2Child(t){t.childrenEl.remove(),this.updateArrowEl(t),this.updateLegendEl(t),this.updateEvt(t)}setAttrs(){this.targetEl.classList.add(`${s.prefix}tree`),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.toggleAttribute("inert",this.options.passive),this.targetEl.setAttribute("tools-trigger",this.options.tools.trigger),this.targetEl.toggleAttribute("chain",this.options.chain),this.options.feature.type&&this.targetEl.setAttribute("feature",this.options.feature.type),this.options.check.enable?this.targetEl.setAttribute("check",this.options.check.span):this.targetEl.removeAttribute("check"),this.options.select.enable?this.targetEl.setAttribute("select",this.options.select.span):this.targetEl.removeAttribute("select")}setDragDrop(t){!this.options.drag.enable||attrValBool(t.disabled)||this.excludeDrags.includes(t)||(t.dragIns=new Drag(t.wrapEl,extend({target:{drops:`[${this.dropTag}]`,handle:t.headEl,purpose:"auto",parent:this.options.drop.global?null:this.targetEl,gesture:{unbound:[t.toolsEl]},onDropped:t=>{"before"===t.point?this.graft({source:t.from,target:t.to,isFront:!0,isChild:!1}):"after"===t.point?this.graft({source:t.from,target:t.to,isFront:!1,isChild:!1}):"inside"===t.point&&this.graft({source:t.from,target:t.to,isFront:!0,isChild:!0})}},source:this.options.drag})))}updateExpandEvt(t){t.children?(t.arrowEl&&("click"===this.options.arrow.trigger?(t.arrowEl.removeEventListener("click",this.expandEvt),t.arrowEl.addEventListener("click",this.expandEvt,!1)):"hover"===this.options.arrow.trigger&&(t.hoverIns&&t.hoverIns.destroy(),t.hoverIns=new Hover(t.arrowEl,{onMove:e=>{!e&&this.options.expand.only&&super.collapse(t)},onEnter:()=>{super.expand(t)},onLeave:()=>{super.collapse(t)}}))),t.legendEl&&(t.legendEl.removeEventListener("click",this.expandEvt),t.legendEl.addEventListener("click",this.expandEvt,!1))):("click"===this.options.arrow.trigger?t.arrowEl&&t.arrowEl.removeEventListener("click",this.expandEvt):"hover"===this.options.arrow.trigger&&t.hoverIns&&t.hoverIns.destroy(),t.legendEl&&t.legendEl.removeEventListener("click",this.expandEvt))}updateEvt(t){if(this.options.paginated.enable&&t.children&&(this.turnFirstPage(t),t.moreEl.onclick=()=>this.turnNextPage(t),t.nextEl.onclick=t.moreEl.onclick,t.firstEl.onclick=()=>this.turnFirstPage(t)),this.updateExpandEvt(t),t.labelEl.removeEventListener("click",this.selectEvt),t.labelEl.addEventListener("click",this.selectEvt,!1),t.toolsEl){let e=attrValBool(t.readonly);t.removeEl&&(t.removeEl.onclick=()=>{e||this.remove(t)}),t.editEl&&(t.editEl.onclick=()=>{e||this.inputLabel(t)}),t.addfileEl&&(t.addfileEl.onclick=()=>{e||this.add({target:t,isChild:!0,expand:!0})}),t.addfolderEl&&(t.addfolderEl.onclick=()=>{e||this.add({target:t,isChild:!0,isLeaf:!1,expand:!0})});for(let[e,s]of this.options.tools.children.entries()){let i=t.tools[e],a={ins:this,item:t};s.action&&s.action.call(a,i),i.action&&i.action.call(a,i)}}this.options.shortcut.enable&&(t.headEl.removeEventListener("click",this.lineEvt),t.headEl.addEventListener("click",this.lineEvt,!1)),attrValBool(t.disabled)&&t.headEl.toggleAttribute("disabled",!0),attrValBool(t.readonly)&&t.headEl.toggleAttribute("readonly",!0),this.options.check.enable&&t.checkEl.on("check",(async e=>{let s=attrValBool(e.checked);!this.chainChecking&&s!==attrValBool(t.checked)&&await this.check(t,s)})),this.options.drag.enable&&!t.dragIns&&this.setDragDrop(t),this.options.check.enable&&("leaf"===this.options.check.span?t.children&&(t.checkEl.toggleAttribute("disabled",!0),t.headEl.toggleAttribute("uncheckable",!0)):"branch"===this.options.check.span&&!t.children&&(t.checkEl.toggleAttribute("disabled",!0),t.headEl.toggleAttribute("uncheckable",!0))),this.options.select.enable&&("leaf"===this.options.select.span?t.children&&t.headEl.toggleAttribute("unselectable",!0):"branch"===this.options.select.span&&!t.children&&t.headEl.toggleAttribute("unselectable",!0)),t.action&&t.action.call(this,t)}renderFinish(){for(let t of this.flatData)this.updateEvt(t);this.options.paginated.enable&&!this.options.paginated.exception&&(this.turnFirstPage(this.pagination),this.pagination.moreEl.onclick=()=>this.turnNextPage(this.pagination),this.pagination.nextEl.onclick=this.pagination.moreEl.onclick,this.pagination.firstEl.onclick=()=>this.turnFirstPage(this.pagination))}getDrops(){return isEmpty(this.options.drag.drops)?this.flatData.map((t=>attrValBool(t.disabled)?null:t.headEl)).filter(Boolean):this.options.drag.value.map((t=>findItem(t,this.flatData))).filter((t=>t&&!attrValBool(t.disabled))).map((t=>t.headEl))}getReadonly(){return this.flatData.find((t=>attrValBool(t.readonly)))}getTriggerEl(t){return t.href&&t.arrowEl?t.arrowEl:t.headEl}addTrigger(t,e){if(t.children){if(!attrValBool(t.disabled)){let s=e||this.getTriggerEl(t);"click"===this.options.arrow.trigger?(s.removeEventListener("click",this.expandEvt),s.addEventListener("click",this.expandEvt,!1)):"hover"===this.options.arrow.trigger&&(this.hoverIns&&this.hoverIns.destroy(),this.hoverIns=new Hover(t.wrapEl,{onEnter:()=>{super.expand(t),super.listen({name:"trigger",params:[t]})},onLeave:()=>{super.collapse(t)}}))}}else attrValBool(t.disabled)||(t.headEl.removeEventListener("click",this.selectEvt),t.headEl.addEventListener("click",this.selectEvt,!1))}removeTrigger(t,e){if(t.children){if(!attrValBool(t.disabled)){let s=e||this.getTriggerEl(t);"click"===this.options.arrow.trigger?s.removeEventListener("click",this.expandEvt):"hover"===this.options.arrow.trigger&&this.hoverIns&&this.hoverIns.destroy()}}else attrValBool(t.disabled)||t.headEl.removeEventListener("click",this.selectEvt)}toggleExpanded(t){if(this.destroyed)return;let e=findItem(t,this.flatData);e&&e.children&&(attrValBool(e.expanded)?super.collapse(e):super.expand(e),super.listen({name:"trigger",params:[e]}))}toggleSelected(t){let e=findItem(t,this.flatData);if(!e||e.headEl.hasAttribute("editing")||!this.options.select.enable)return;let s=attrValBool(e.selected);s?this.deselect(e):(this.select(e),this.options.select.only&&this.deselect(this.flatData.filter((t=>t!==e&&s))))}async eachCollapse(t,e){if(isNull(t))return;try{if(this.options.b4Collapse){let e=await this.options.b4Collapse.call(this,t);e&&(t=e)}}catch(t){return}let s=findItem(t,this.flatData);s&&s.children&&elState(s.childrenEl).isVisible&&!s.childrenEl.style.height&&(super.listen({name:"collapse",cb:e,params:[s]}),s.expanded=!1,slideUp({el:s.childrenEl,duration:this.options.duration,done:()=>{super.listen({name:"collapsed",cb:e,params:[s]})}}))}async eachExpand(t,e){if(isNull(t))return;let s=findItem(t,this.flatData);if(s&&s.children&&!elState(s.childrenEl).isVisible){try{if(this.options.b4Expand){let e=await this.options.b4Expand.call(this,t);e&&(t=e)}}catch(t){return}if(super.listen({name:"expand",cb:e,params:[s]}),s.children.length||isEmpty(this.options.contData)||"async"!==this.options.contType?this.options.deferred&&!s.childrenEl.firstElementChild&&(s.arrowEl&&s.arrowEl.toggleAttribute("spinning",!0),this.options.paginated.enable?this.turnFirstPage(s):s.childrenEl.append(...s.children.map((t=>t.wrapEl))),s.arrowEl&&s.arrowEl.removeAttribute("spinning")):await this.sqlToAdd(s),s.expanded=!0,this.options.expand.linkage&&this.expandParents(s),this.lastExpanded=s.id,slideDown({el:s.childrenEl,duration:this.options.duration,done:()=>{super.listen({name:"expanded",cb:e,params:[s]})}}),this.options.expand.only){let t=this.flatData.filter((t=>t!==s&&attrValBool(t.expanded)&&t.floor===s.floor&&t.children));for(let e of t)super.collapse(e)}}}floatDown(t){if(!t.hasOwnProperty("children")||!Array.isArray(t.children))return;let e=t.children.filter((t=>!attrValBool(t.disabled))),s=this.getCheckType(t);for(let i of e)attrValBool(t.checked)?"checkbox"===s&&(i.checked=!0):i.checked=!1,i.hasOwnProperty("children")&&this.floatDown(i)}floatUp(t){if(t.floor===this.options.floorStart)return;let e=S.getParentsFromPath({path:t.path,flatData:this.flatData,pathHyphen:this.options.pathHyphen,pop:!0}).parents.reverse(),setCheck=(t,e,s)=>{"checkbox"===s?e.every((t=>!attrValBool(t.checked)))?(t.checked=!1,t.checkEl.setAttribute("check","")):e.every((t=>attrValBool(t.checked)))?(t.checked=!0,"radio"===t.checkType&&this.uncheckSibings(t)):(t.checked=!1,t.checkEl.setAttribute("check","ing")):"radio"===s&&(e.some((t=>attrValBool(t.checked)))?(t.checked=!0,"radio"===t.checkType&&this.uncheckSibings(t)):(t.checked=!1,t.checkEl.setAttribute("check",t.children.some((t=>"ing"===t.checkEl.properties.check))?"ing":"")))};for(let t of e){let e=t.children.filter((t=>!attrValBool(t.disabled)));setCheck(t,e,this.getCheckType(t))}}eachCheck(t){this.chainChecking=!0,this.floatDown(t),this.floatUp(t),this.chainChecking=!1}getCheckType(t){return t?.childType||(["checkbox","radio"].includes(this.options.check.type)?this.options.check.type:"checkbox")}uncheckSibings(t){this.chainChecking=!0;let e=super.getSiblings(t).filter((t=>attrValBool(t.checked)));for(let t of e)t.checked=!1,this.options.check.linkage&&this.floatDown(t);this.chainChecking=!1}expandParents(t,e){let s=findItems(t,this.flatData).map((t=>findItem(t,this.flatData))).filter(Boolean),i=[];if(s.length){let t=[];for(let e of s){let s=S.getParentsFromPath({path:e.path,flatData:this.flatData,field:"id",pathHyphen:this.options.pathHyphen}).parents;s.pop(),t.push(...s)}i=unique(t);for(let t of i)super.expand(t)}e&&e(i)}select(t,e=!0,s){if(this.destroyed||!this.options.select.enable||isNull(t))return;let i=findItems(t,this.flatData).map((t=>findItem(t,this.flatData))).filter((t=>!attrValBool(t.selected)===e&&("leaf"===this.options.select.span?!t.children:"branch"!==this.options.select.span||t.children))),a=i,fn=t=>{t.headEl.hasAttribute("editing")||t.headEl.hasAttribute("unselectable")||attrValBool(t.selected)||(t.selected=!0)};if(i.length){if(e){if(this.options.select.only){let t=i[0];t&&(fn(t),this.deselect(this.flatData.filter((e=>e!==t&&attrValBool(e.selected))))),a=[t]}else{this.saveRaw();for(let t of i)fn(t)}this.options.select.linkage&&this.expandParents(a)}else this.deselect(i);return super.listen({name:e?"selected":"deselected",cb:s,params:[a]}),this}}selectAll(t){if(!this.destroyed&&this.options.select.enable&&!this.options.select.only)return this.select(this.flatData),super.listen({name:"selectedAll",cb:t}),this}deselectAll(t){if(!this.destroyed&&this.options.select.enable)return this.select(this.flatData,!1),super.listen({name:"deselectedAll",cb:t}),this}deselect(t){if(isNull(t))return;let e=Array.isArray(t)?t:[t];this.saveRaw();for(let t of e)attrValBool((s=t).selected)&&(s.selected=!1);var s}checkOnlyone(t){this.saveRaw(),t.checked=!0,this.chainChecking=!0;let e=this.flatData.filter((e=>e!==t));for(let t of e)t.checked=!1,t.checkEl&&t.checkEl.removeAttribute("check");this.chainChecking=!1}async check(t,e=!0,s){if(this.destroyed)return;let i=findItems(t,this.flatData).filter((t=>!(!attrValBool(t.checked)!==e||e&&("leaf"===this.options.check.span?t.children:"branch"===this.options.check.span&&!t.children)))),fn=t=>{t.checked=e,e&&"radio"===t.checkType&&this.uncheckSibings(t),this.options.check.linkage&&this.eachCheck(t)};if(i.length){if(this.options.check.max)try{let t={data:i,source:this.getCheckeds(),min:this.options.check.min,max:this.options.check.max,sliced:this.options.check.sliced},s=await(e?this.moreExceed(t):this.lessExceed(t));s&&(i=s)}catch{return}if(e&&this.options.check.only)this.checkOnlyone(i[0]);else{this.saveRaw();for(let t of i)fn(t)}return super.listen({name:e?"checked":"unchecked",cb:s,params:[i]}),this}}checkAll(t){if(!this.destroyed&&this.options.check.enable&&"checkbox"===this.options.check.type&&!this.options.check.only){this.saveRaw();for(let t of this.flatData)t.checked=!0;return super.listen({name:"checkedAll",cb:t}),this}}async add(t){if(this.destroyed)return;let e=Object.assign({isChild:!0,isFront:!0,repeat:!0,isLeaf:!0,autoFill:!0,expand:!0},t),s=getDataType(e.data),i=findItem(e.target,this.flatData),a=findItem(e.brother,this.flatData),l=[],n=[],appendFun=async t=>{let s=S.createBranchObj({source:t,flatData:this.flatData,target:i,isLeaf:e.isLeaf,isChild:e.isChild});this.createHeadEl(s),await this.createBodyEl(s),this.createFootEl(s),this.createChildrenEl(s),super.listen({name:"insertItem",params:[s]}),S.addBranch({source:s,rootEl:this.targetEl,flatData:this.flatData,treeData:this.treeData,brother:i&&!e.isChild?i:a,isFront:e.isFront,repeat:e.repeat,autoFill:e.autoFill,cb:t=>{n.push(t),this.updateEvt(t)}})};l=isNull(e.data)?[null]:"Array"===s&&e.data.length>0?e.data:[e.data];try{let t=await super.moreExceed({data:l,source:this.flatData});t&&(l=t)}catch{return}for(let t of l){try{if(this.options.b4Add){let e=await this.options.b4Add.call(this,t);e&&(t=e)}}catch(t){continue}await appendFun(t)}if(n.length>0&&(this.flatData=S.toFlat(this.treeData),e.isChild&&e.expand&&i&&this.eachExpand(i),this.options.select.enable&&this.options.select.addSelected))if(this.options.select.only)this.select(n.at(-1));else for(let t of n)this.select(t);return super.listen({name:"added",cb:e.cb,params:[n,i]}),this}async remove(t,e){if(this.destroyed||isNull(t)||!this.flatData.length)return;if(0===this.flatData.length)return;let s=[],i=[],removeItem=t=>{S.removeBranch({source:t,flatData:this.flatData,treeData:this.treeData,remove:!1,cb:t=>{i.push(t),setTimeout((()=>{let e=this.flatData.find((e=>e.id===t.pId));e&&!e.children.length&&super.collapse(e)}),0)}})};s=findItems(t,this.flatData);try{let t=await super.lessExceed({data:s,source:this.flatData});t&&(s=t)}catch{return}for(let t of s){try{if(this.options.b4Remove){let e=await this.options.b4Remove.call(this,t);e&&(t=e)}}catch(t){continue}removeItem(t)}return this.flatData=S.toFlat(this.treeData),super.listen({name:"removed",cb:e,params:[i]}),this}search(t,e={},i){if(this.destroyed||!this.flatData.length)return;let a=l.splitHyphen;if("string"==typeof t){let e=t.trim();a=e.includes("，")?"，":e.includes(",")?",":e.includes(" ")?" ":l.splitHyphen}let n=valToArr(t,a,!1).map((t=>clearRegx(t))).filter(Boolean);if(n.length){let t=this.searchs;this.searchs=arrSearch(Object.assign({keys:n,props:"label",source:this.flatData},{fuzzy:this.options.search.fuzzy,ignore:this.options.search.ignore},e)).map((t=>t.source));for(let t of this.searchs)t.labelEl.innerHTML=super.replaceMult(t.label,n);if(!isEmpty(t))for(let e of t)this.searchs.includes(e)||(e.labelEl.innerHTML=e.label);this.expandParents(this.searchs,(t=>{let e=unique([...t,...this.searchs]);this.ignores=this.flatData.filter((t=>!e.includes(t)));for(let t of this.ignores)t.wrapEl.classList.add(`${s.prefix}d-none`);for(let t of e)t.wrapEl.classList.remove(`${s.prefix}d-none`)}))}else{for(let t of this.searchs)t.labelEl.innerHTML=t.label;if(!isEmpty(this.ignores))for(let t of this.ignores)t.wrapEl.classList.remove(`${s.prefix}d-none`);this.searchs=[],this.ignores=[]}return super.updateCache({search:{value:n}}),super.listen({name:"searched",cb:i,params:[this.searchs,n]}),this}inputLabel(t){let e=t.headEl,s=t.labelEl;e.hasAttribute("editing")||(e.toggleAttribute("editing",!0),s.innerHTML="",s.appendChild(this.editorEl),this.editorEl.focus(),this.editorEl.value=t.label,this.editorEl.onblur=async()=>{let s=this.editorEl.value;try{if(this.options.b4Edit){let e=await this.options.b4Edit.call(this,{key:"label",value:s},t);e&&(s=e)}t.label=s,e.removeAttribute("editing")}catch(s){return t.labelEl.innerHTML=t.label,void e.removeAttribute("editing")}super.listen({name:"edited",params:[t]})},this.editorEl.onkeyup=t=>{"Enter"===t.code&&this.editorEl.blur()})}async edit(t,e,s){if(this.destroyed||isNull(t)||isEmpty(e)||!this.flatData.length)return this;let i=findItem(t,this.flatData);if(!i)return this;for(let t in e){let s=e[t];try{if(this.options.b4Edit){let e=await this.options.b4Edit.call(this,{key:t,value:s},i);e&&(s=e)}"action"===t?i[t]=s.call({ins:this,item:t},i):["icon","disk","cube","onclick","href","target","rel","label","brief","tips","badge"].includes(t)&&(i[t]=s)}catch(t){return this}}return super.listen({name:"edited",cb:s,params:[i]}),this}async graft({source:t,target:e,isFront:s=!0,isChild:i=!0,cb:a}){if(this.destroyed||isNull(t))return;try{if(this.options.b4Graft){let s=await this.options.b4Graft.call(this,t,e);s&&s.source&&(t=s.source),s&&s.target&&(t=s.target)}}catch(t){return this}let l=findItem(t,this.flatData,"",{node:"wrapEl"}),n=findItem(e,this.flatData);return l?(S.graftBranch({source:l,target:n,isFront:s,isChild:i,flatData:this.flatData,treeData:this.treeData,rootEl:this.targetEl,cb:(t,e)=>(e&&e.children&&i&&this.eachExpand(e),this.flatData=S.toFlat(this.treeData),super.listen({name:"grafted",cb:a,params:[t,e]}),this)}),this):void 0}setSearch(){!isEmpty(this.options.search.value)&&this.search(this.options.search.value),this.searchEl=getEl(this.options.search.target),this.searchEl&&(this.searchEl[s.compSign]?this.searchEl.on(this.options.search.trigger,this.searchEvgt):this.searchEl.addEventListener(this.options.search.trigger,this.searchEvgt,!1))}setResult(){this.options.output.enable&&!this.options.output.instant&&(this.resultIns=this.resultIns||new Tags(this.resultEl,{content:"",size:"sm",type:"plain",removable:!0,empty:{enable:!0,content:this.options.lang.result}}),this.resultIns.on("removed",(async t=>{for(let e of t){let t=e.label.split(this.options.output.connector);for(let e of t)"checked"===this.options.output.form?await this.check(e,!1):this.select(e,!1)}})))}updateVals(){if(!this.options.output.enable)return;let{value:t,items:e}=this.getVals();this.updateResult(t),this.options.name&&(this.inputEl.value=t),this.output.value=t,this.output.items=e,super.listen({name:"output",params:[this.output]}),this.options.output.instant&&this.setVals()}saveRaw(){this.output.raw=this.getVals().value}updateResult(t){this.resultIns&&(t?this.resultIns.updateCont(t.split(this.options.output.separator)):this.resultIns.clear())}clearResult(){this.resultIns&&this.resultIns.clear()}setVals(t=this.receiver,e){if(this.destroyed)return;let s=getEl(t),i=this.getVals().value;return E.setVals({target:s,value:i}),super.listen({name:"set",cb:e,params:[i]}),this}clearVals(t=!1,e){return this.destroyed||!this.flatData.length||(t?(super.uncheckAll(),this.deselectAll()):"checked"===this.options.output.from?super.uncheckAll():this.deselectAll(),this.value="",this.clearResult(),super.listen({name:"cleared",cb:e})),this}getVals(t={},e){if(this.destroyed)return this;let s=Object.assign({...this.options.output,isStr:!0},t),i=this.getValItems(s.from),a=[];if("chain"===s.type)a=i.map((t=>{let e=S.getParentsFromPath({path:t.path,flatData:this.flatData,pathHyphen:this.options.pathHyphen,labelHyphen:s.connector,field:s.field}).parents.map((t=>t[s.field]));return s.isStr?e.join(s.connector):e}));else{a=("leaf"===s.type?i.filter((t=>!t.children)):"branch"===s.type?i.filter((t=>t.children)):i).map((t=>t[s.field]))}let l=s.isStr?a.join(s.separator):a;return super.listen({name:"got",cb:e,params:[l]}),{value:l,items:i}}getValItems(t="selected"){return this.options.output.autosort?"checked"===t?super.getCheckeds():this.getSelecteds():this.seqItems}async updateCont(t,e){return this.destroyed||await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:async s=>{Array.isArray(s)&&(this.treeDataOrig=deepClone(s),S.addIdPath({source:this.treeDataOrig}),this.targetEl.innerHTML="",await this.renderData(this.treeDataOrig),this.getTreeFlat(),this.renderFinish(),super.updateCache({content:t}),super.listen({name:"updatedCont",cb:e,params:[this.treeDataOrig]}))}}),this}destroy(t){if(this.destroyed)return this;for(let t of this.flatData){if(t.children){if("click"===this.options.arrow.trigger){(t.hasOwnProperty("href")&&t.arrowEl?t.arrowEl:t.headEl).removeEventListener("click",this.expandEvt)}else"hover"===this.options.arrow.trigger&&this.hoverIns.destroy();t.legendEl&&t.legendEl.removeEventListener("click",this.expandEvt)}!t.children&&t.headEl.removeEventListener("click",this.selectEvt),this.options.shortcut.enable&&t.headEl.removeEventListener("click",this.lineEvt),this.options.drag.enable&&t.dragIns.destroy(),this.options.paginated.enable&&!this.options.deferred&&(t.moreEl.onclick=null,t.nextEl.onclick=null,t.firstEl.onclick=null)}return this.resultIns&&this.resultIns.destroy(),this.searchEl&&(this.searchEl[s.compSign]?this.searchEl.off(this.options.search.trigger,this.searchEvgt):this.searchEl.removeEventListener(this.options.search.trigger,this.searchEvgt)),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}class Menu extends ModBaseListenCache{options={};flatData;treeData;expandEvt;selectEvt;pageEvt;lastExpanded;treeDataOrig;drawerHost;drawerIns;treeIns;hoverIns;contXhr;observeIns;static hostType="node";static optMaps=B;constructor(t,e={},s=!0){super(),super.ready({options:e,host:t,maps:Menu.optMaps,component:!0,spread:["arrow","nav"]});let i=this;this.pageEvt=function(t){contains(t.target,i.targetEl)||i.treeIns.collapseAll()},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setAttrs(),this.getTree(),await this.treeIns.init(),this.drawerHost=getEl(this.options.drawer.host),this.drawerHost&&(this.drawerIns=new Drawer(this.drawerHost,Object.assign({content:this.targetEl,contType:"node"},this.options.drawer))),super.listen({name:"initiated",cb:t}),this}getTree(){let t=this,e={storName:this.options.storName?this.options.storName+"_tree":"",content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:this.options.ajax,passive:this.options.passive,layout:this.options.layout,disable:this.options.disable,duration:this.options.duration,select:{value:this.options.active,linkage:this.options.linkage,span:"leaf"},expand:{value:this.options.active,all:!(!this.options.expose&&!this.options.expandAll),only:!this.options.multiple&&!this.options.expose,linkage:this.options.linkage},shortcut:{enable:!this.options.expose,span:"blank",mean:"hover"===this.options.trigger?"selected":"auto"},arrow:{enable:this.options.arrow.enable,show:this.options.arrow.icon||`${s.prefix}icon-${this.options.nav.enable?"down":"right"}`,hide:this.options.arrow.icon||`${s.prefix}icon-${this.options.nav.enable?"down":"right"}`,anim:`${s.prefix}rotate${this.options.nav.enable||this.options.spill?"180":"90"}`,type:"icon",trigger:this.options.trigger},onInitiated:function(){"click"===t.options.trigger&&t.options.pageClose&&(document.body.removeEventListener("click",t.pageEvt),document.body.addEventListener("click",t.pageEvt,!1))},onAdded:(t,e)=>{this.setHover(e)},onGrafted:(t,e)=>{this.setHover(e)},onInsertItem:t=>{this.options.nav.enable&&this.addNavAttr(t,t.floor===this.options.floorStart)},onInsertItems:t=>{let e=S.toFlat(t);for(let t of e)this.options.nav.enable&&this.addNavAttr(t,t.floor===this.options.floorStart),t?.children&&this.setHover(t)}},i=extend({target:e,source:this.options.tree});this.treeIns&&this.treeIns.initiated&&this.treeIns.destroy(),this.treeIns=new Tree(this.targetEl,i,!1)}setHover(t){"hover"===this.options.trigger&&t?.children&&(t.triggerIns&&t.triggerIns.destroy(),t.triggerIns=new Hover(t.wrapEl,{onEnter:()=>{this.treeIns.expand(t.id)},onLeave:()=>{this.treeIns.collapse(t.id)}}))}addNavAttr(t,e=!1){this.options.nav.bodyWidth&&(t.childrenEl?addStyle(t.childrenEl,"width",this.options.nav.bodyWidth):removeStyle(t.childrenEl,"width")),e&&(this.options.nav.headWidth?addStyle(t.wrapEl,"width",this.options.nav.headWidth):removeStyle(t.wrapEl,"width"),this.options.nav.marginLeft?addStyle(t.wrapEl,"margin-left",this.options.nav.marginLeft):removeStyle(t.wrapEl,"margin-left"),this.options.nav.marginRight?addStyle(t.wrapEl,"margin-right",this.options.nav.marginRight):removeStyle(t.wrapEl,"margin-right"))}setAttrs(){this.targetEl.classList.add(`${s.prefix}menu`),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.setAttribute("theme",this.options.theme),this.targetEl.toggleAttribute("inert",this.options.passive),this.targetEl.toggleAttribute("expose",this.options.expose),this.targetEl.setAttribute("trigger",this.options.trigger),this.targetEl.toggleAttribute("spill",this.options.spill&&!this.options.nav.enable),this.targetEl.toggleAttribute("unpadded",this.options.unpadded),this.options.lamp?this.targetEl.setAttribute("lamp",this.options.lamp):this.targetEl.removeAttribute("lamp"),this.targetEl.toggleAttribute("full",this.options.full&&!this.options.nav.enable),this.options.zIndex?addStyle(this.targetEl,"z-index",this.options.zIndex):removeStyle(this.targetEl,"z-index"),this.targetEl.toggleAttribute("nav",this.options.nav.enable),this.options.nav.align?this.targetEl.setAttribute("align",this.options.nav.align):this.targetEl.removeAttribute("align")}activate(t,e){if(this.destroyed)return;let s=findItems(t,this.treeIns.flatData),i=s.filter((t=>t.children)),a=s.filter((t=>!t.children));return a.length?this.treeIns.select(a,!0,(()=>{this.treeIns.expand(i)})):this.treeIns.expand(i),super.listen({name:"activated",cb:e,params:[s]}),this}async updateCont(t,e){return this.destroyed||await this.treeIns.updateCont(t,(t=>{super.listen({name:"updatedCont",cb:e,params:[t]})})),this}destroy(t){return this.destroyed||(this.treeIns.destroy(),document.body.removeEventListener("click",this.pageEvt),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const Q=[{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"passive",prop:"passive",value:!1},{attr:"active",prop:"active",value:""},{attr:"disable",prop:"disable",value:""},{attr:"trigger",prop:"trigger",value:"click"},{attr:"duration",prop:"duration",value:0},{attr:"max",prop:"max",value:0},{attr:"embed",prop:"embed",value:!1},{attr:"slider",prop:"slider",value:{enable:!1,arrowShow:!1,options:{slides:"auto",scroll:{drift:{mode:"free",coef:1}}}}},{attr:"menu",prop:"menu",value:{enable:!1,options:{columns:4,size:"lg"}}},{attr:"col",prop:"col",value:{enable:!1,position:"left"}},{attr:"attrs",prop:"attrs",value:{target:{},head:{},body:{}}},{attr:"classes",prop:"classes",value:{target:"",head:"",body:""}},{attr:"divider",prop:"divider",value:{enable:!1,size:""}},{attr:"add-active",prop:"addActive",value:!0},{attr:"tools",prop:"tools",value:{enable:!1,children:["close"]}},{attr:"layout",prop:"layout",value:"lamp"},{attr:"selector",prop:"selector",value:{head:"",body:""}},{attr:"sticky",prop:"sticky",value:0},{attr:"b4-activate",prop:"b4Activate",value:null},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-edit",prop:"b4Edit",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-graft",prop:"b4Graft",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-insertitem",prop:"onInsertItem",value:null},{attr:"on-insertitems",prop:"onInsertItems",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-grafted",prop:"onGrafted",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-disabledAll",prop:"onDisabledAll",value:null},{attr:"on-enabledAll",prop:"onEnabledAll",value:null},{attr:"on-activated",prop:"onActivated",value:null},{attr:"on-updatedItemcont",prop:"onUpdatedItemCont",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},...p];class Tab extends ModBaseListenCacheNest{options={};actEvt;trigger;treeDataOrig;observeIns;headsEl;bodiesEl;dividerEl;rawData;headLayout;contXhr;static hostType="node";static optMaps=Q;static dependencies=[BadgeElem];constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Tab.optMaps,component:!1,spread:["slider","col","menu","tools","divider"]});let a=this;this.actEvt=function(t){if(this.hasAttribute("selected")||this.hasAttribute("disabled"))return;let e=this.querySelector(`:scope > [${s.alias}="tools"]`);if(e&&e.contains(t.target))return;let i=a.treeData.find((t=>t.headEl===this));a.activate(i)},this.trigger="hover"===this.options.trigger?"mouseenter":"click",this.treeDataOrig=[],super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return super.useTpl(),await this.getDataToRender(),this.setAttrs(),super.initDisableds(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}initActive(){let t=this.treeData.findIndex((t=>attrValBool(t.selected)));0===this.options.active||this.options.active?this.activate(this.options.active):t<0&&this.activate(0)}async getDataToRender(){let t,e={nodeType:"tab"};return this.options.content?t=S.allToTree({content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{spinSel:this.targetEl,xhrName:"contXhr"},ins:this,...e}):this.targetEl.querySelector(`.${s.prefix}tab-head`)&&this.targetEl.querySelector(`.${s.prefix}tab-body`)?(this.treeDataOrig=this.htmlToArr(),S.addIdPath({source:this.treeDataOrig}),this.rawData=this.treeDataOrig,this.updateHeadBodyAttrs()):t=S.allToTree({content:this.targetEl.innerHTML,...e}),t&&(await t.then((t=>{this.treeDataOrig=t.data&&Array.isArray(t.data)?t.data:t,this.rawData=t})),this.targetEl.innerHTML="",this.renderData(this.treeDataOrig)),this.getTreeFlat(),super.listen({name:"rendered",params:[this.treeData]}),this}getTreeFlat(){this.treeData=this.getObserver(this.treeDataOrig).proxy}getObserver(t){return this.observeIns&&this.observeIns.destroy(),this.observeIns=new Observe(t,{deep:{enable:!0,exclude:["tools"]},onSet:t=>{"icon"===t.key&&t.target.iconEl?t.target.iconEl.className=t.value:"cube"===t.key&&t.target.cubeEl?t.target.cubeEl.src=t.value:"disk"===t.key&&t.target.diskEl?t.target.diskEl.src=t.value:"image"===t.key&&t.target.imageEl?t.target.imageEl.src=t.value:"label"===t.key?t.target.labelEl.innerHTML=t.value:"tips"===t.key&&t.target.tipsEl?t.target.tipsEl.innerHTML=t.value:"badge"===t.key&&t.target.badgeEl?t.target.badgeEl.setAttribute("label",t.value):"selected"===t.key?attrValBool(t.value)?(t.target.headEl.setAttribute("selected",""),t.target.bodyEl.setAttribute("selected",""),!t.target.bodyEl.innerHTML&&this.fillContent(t.target)):(t.target.headEl.removeAttribute("selected"),t.target.bodyEl.removeAttribute("selected")):"disabled"===t.key?t.target.headEl.toggleAttribute("disabled",attrValBool(t.value)):"content"===t.key&&this.fillContent(t.target)},onCompleted:()=>{let t=this.getSelected(),e={active:t?t.hasOwnProperty("id")?t.id:this.treeData.indexOf(t):0,disabled:super.getDisableds().map(((t,e)=>t.hasOwnProperty("id")?t.id:e)),content:isEmpty(this.options.content)?[]:deepClone(this.treeDataOrig)};super.updateCache(e)}}),this.observeIns}htmlToArr(){let t=[];if(this.headsEl=this.targetEl.querySelector(`.${s.prefix}tab-head`),this.bodiesEl=this.targetEl.querySelector(`.${s.prefix}tab-body`),!this.headsEl||!this.bodiesEl)return t;let e=getEls(this.options.selector.head,this.headsEl),i=getEls(this.options.selector.body,this.bodiesEl),a=e.length?e:[...this.headsEl.children],l=i.length?i:[...this.bodiesEl.children];if(a.length!==l.length)return t;let getPropsFromHead=t=>{let e={},i=t.querySelector(`[${s.alias}="label"]`);return e.headEl=t,e.labelEl=i||t,e.label=e.labelEl.textContent.trim(),e.tipsEl=t.querySelector(`[${s.alias}="tips"]`),e.tips=e.tipsEl?e.tipsEl.textContent.trim():"",e.iconEl=t.querySelector(`[${s.alias}="icon"]`),e.icon=e.iconEl?e.iconEl.getAttribute("class"):"",e.cubeEl=t.querySelector(`[${s.alias}="cube"]`),e.cube=e.cubeEl?e.cubeEl.src:"",e.diskEl=t.querySelector(`[${s.alias}="disk"]`),e.disk=e.diskEl?e.diskEl.src:"",e.badgeEl=t.querySelector(`[${s.alias}="badge"],ax-badge`),e.badge=e.badgeEl?e.badgeEl.getAttribute("label")||e.badgeEl.textContent.trim():"",((t,e)=>{let loop=e=>{let s=t.headEl.hasAttribute(e);s&&"false"!==s&&"0"!==s?(t[e]=!0,t.headEl.setAttribute(e,"")):t[e]=!1};Array.isArray(e)?e.forEach((t=>{loop(t)})):loop(e)})(e,["selected","disabled"]),e};return t=a.map(((t,e)=>{let s=getPropsFromHead(t),i=l[e];return i.toggleAttribute("selected",attrValBool(s.selected)),this.options.tools.enable&&this.getTools(s),{...s,bodyEl:i,content:i.innerHTML}})),t}renderData(t){this.dividerEl=createEl("ax-br"),this.options.divider.size&&this.dividerEl.setAttribute("size",this.options.divider.size),this.headsEl=createEl("ul",{class:`${s.prefix}tab-head`}),this.bodiesEl=createEl("ul",{class:`${s.prefix}tab-body`}),this.updateHeadBodyAttrs();for(let e of t)e.hasOwnProperty("label")&&e.hasOwnProperty("content")&&(this.createItemEl(e),this.headsEl.appendChild(e.headEl),this.bodiesEl.appendChild(e.bodyEl));super.listen({name:"insertItems",params:[t]}),this.targetEl.append(this.headsEl,this.options.divider.enable?this.dividerEl:"",this.bodiesEl)}createItemEl(t){t.labelEl=createEl("i",{[s.alias]:"label"},t.label),t.iconEl=t.icon?createEl("i",{[s.alias]:"icon",class:t.icon}):null,t.diskEl=t.disk?createEl("img",{[s.alias]:"disk",src:t.disk}):null,t.cubeEl=t.cube?createEl("img",{[s.alias]:"cube",src:t.cube}):null,t.imageEl=t.image?createEl("img",{[s.alias]:"image",src:t.image}):null,t.headEl=createEl("li"),t.bodyEl=createEl("li"),t.badgeEl=t.badge?createEl("ax-badge",{[s.alias]:"badge"},t?.badge?.trim()):null,t.tipsEl=t.tips?createEl("i",{[s.alias]:"tips"},t.tips):null,attrValBool(t.selected)&&(t.headEl.toggleAttribute("selected",!0),t.bodyEl.toggleAttribute("selected",!0)),attrValBool(t.disabled)&&t.headEl.toggleAttribute("disabled",!0),t.headEl.append(...[t.iconEl,t.diskEl,t.cubeEl,t.imageEl,t.labelEl,t.tipsEl,t.badgeEl].filter(Boolean)),this.options.tools.enable&&this.getTools(t)}getTools(t){if(this.options.tools.enable){t.toolsEl=createTools(this.options.tools.children,t.headEl),t.toolsEl.setAttribute(s.alias,"tools"),t.tools=deepClone(this.options.tools.children);for(let e of t.tools)this.options.lang.title[e.name]&&e.wrapEl.setAttribute("title",this.options.lang.title[e.name]),"add"===e.name?t.addEl=e.wrapEl:"edit"===e.name?t.editEl=e.wrapEl:"close"===e.name?t.closeEl=e.wrapEl:"update"===e.name?t.updateEl=e.wrapEl:"move"===e.name&&(t.moveEl=e.wrapEl)}}async fillContent(t,e){await getContent.call(this,{content:t.content,contType:t.contType,contData:t.contData,ajax:{ajaxType:t.ajaxType||this.options.ajaxType,xhrName:"contXhr",spinSel:t.bodyEl},cb:s=>{setContent({content:s,target:t.bodyEl,engine:t.engine||this.tplStr,template:t.template||this.tplEng}),e&&e(s)}})}updateHeadBodyAttrs(){this.options.classes?.head&&classes(this.headsEl).add(this.options.classes.head),this.options.classes?.body&&classes(this.bodiesEl).add(this.options.classes.body),!isEmpty(this.options.attrs?.head)&&setAttrs(this.headsEl,this.options.attrs.head),!isEmpty(this.options.attrs?.body)&&setAttrs(this.bodiesEl,this.options.attrs.body),this.options.layout?this.headsEl.getAttribute("class")?.includes(`${s.prefix}group-`)||(this.headLayout=`${s.prefix}group-${this.options.layout}`,this.headsEl.classList.add(this.headLayout)):this.headLayout&&this.headsEl.classList.remove(this.headLayout)}setAttrs(){this.targetEl.classList.add(`${s.prefix}tab`),this.options.classes?.target&&classes(this.targetEl).add(this.options.classes.target),!isEmpty(this.options.attrs?.target)&&setAttrs(this.targetEl,this.options.attrs.target),this.targetEl.toggleAttribute("inert",this.options.passive),this.targetEl.toggleAttribute("embed",this.options.embed),this.options.col.enable?this.targetEl.setAttribute("col",this.options.col.position):this.targetEl.removeAttribute("col")}updateEvt(t){this.addTrigger(t);let e=attrValBool(t.disabled);if(t.toolsEl){t.closeEl&&(t.closeEl.onclick=()=>{t.readonly||this.remove(t)}),t.editEl&&(t.editEl.onclick=debounce((()=>{}))),t.addEl&&(t.addEl.onclick=debounce((()=>{e||this.add({data:{},isFront:!1,target:t})}))),t.updateEl&&(t.updateEl.onclick=debounce((()=>{e||this.updateItemCont({content:t.content,target:t})})));for(let[e,s]of this.options.tools.children.entries()){let i=t.tools[e],a={ins:this,item:t};s.action&&s.action.call(a,i),i.action&&i.action.call(a,i)}}e&&t.headEl.toggleAttribute("disabled",!0),t.action&&t.action.call(this,t)}renderFinish(){this.initActive();for(let t of this.treeData)this.updateEvt(t)}getSelected(){return this.treeData.find((t=>attrValBool(t.selected)))}addTrigger(t){attrValBool(t.disabled)||(t.headEl.removeEventListener(this.trigger,this.actEvt),t.headEl.addEventListener(this.trigger,this.actEvt,!1))}removeTrigger(t){attrValBool(t.disabled)&&t.headEl.removeEventListener(this.trigger,this.actEvt)}toggleDisabled(t,e="disable"){"enable"===e?(t.disabled=!1,this.addTrigger(t)):"disable"===e&&(t.disabled=!0,this.removeTrigger(t))}disable(t,e){if(this.destroyed||0!==t&&isEmpty(t))return this;let s=(Array.isArray(t)?t:[t]).map((t=>findItem(t,this.treeData))).filter(Boolean),fun=t=>this.toggleDisabled(t,"disable");return s.forEach((t=>fun(t))),super.listen({name:"disabled",cb:e,params:[s]}),this}disableAll(t){return this.destroyed||(this.disable(this.treeData),super.listen({name:"disabledAll",cb:t})),this}enable(t,e){if(this.destroyed||0!==t&&isEmpty(t))return this;let s=(Array.isArray(t)?t:[t]).map((t=>findItem(t,this.treeData))).filter(Boolean),fun=t=>this.toggleDisabled(t,"enable");return s.forEach((t=>fun(t))),super.listen({name:"enabled",cb:e,params:[s]}),this}enableAll(t){return this.destroyed||(this.enable(this.treeData),super.listen({name:"enabledAll",cb:t})),this}async activate(t,e){if(this.destroyed||isNull(t))return;let s=findItem(t,this.treeData),i=this.treeData.find((t=>t!==s&&attrValBool(t.selected)));if(s){if(attrValBool(s.selected))!s.bodyEl.innerHTML&&this.fillContent(s);else{try{if(this.options.b4Activate){let t=await this.options.b4Add.call(this,s);t&&(s=t)}}catch(t){}i&&(i.selected=!1),s.selected=!0,s.disabled=!1,super.listen({name:"activated",cb:e,params:[s]})}return this}}async add(t){if(this.destroyed)return this;if(this.treeData.length>=this.options.max&&this.options.max>0)throw new Error("The number of children exceeds the maximum!");let e=Object.assign({repeat:!0,autoFill:!0,isFront:!1},t),s=getDataType(e.data),i=findItem(e.target,this.treeData),a="Array"===s?e.data:"Object"===s?[e.data]:[{}];if(!e.repeat){let t=this.treeData.map((t=>t.label));a=a.filter((e=>!t.includes(e.label)))}if(0===a.length)return this;for(let t of a){try{if(this.options.b4Add){let e=await this.options.b4Add.call(this,t);e&&(t=e)}}catch(t){continue}!t.hasOwnProperty("id")&&(t.id=increaseId(this.treeData)),!t.hasOwnProperty("label")&&(t.label=`${this.options.lang.label}${t.id}`),!t.hasOwnProperty("content")&&(t.content=`${this.options.lang.content}${t.id}`),this.createItemEl(t)}if(i){let t=this.treeData.indexOf(i),s=e.isFront?t:t+1;splice({host:this.treeData,intent:"add",source:a,index:s})}else splice({host:this.treeData,intent:e.isFront?"start+":"end+",source:a});let l=a.map((t=>t.headEl)),n=a.map((t=>t.bodyEl));appendEls({parent:this.headsEl,nodes:l,target:i?.headEl,prepend:!!e.isFront}),appendEls({parent:this.bodiesEl,nodes:n,target:i?.bodyEl,prepend:!!e.isFront}),this.options.addActive&&this.activate(a[a.length-1]);let r=a.map((t=>{let e=this.treeData.find((e=>e.id===t.id));return this.updateEvt(e),e}));return super.listen({name:"added",cb:e.cb,params:[r]}),this}async remove(t,e){if(this.destroyed||isNull(t))return this;if(0===this.treeData.length)return this;let s=(Array.isArray(t)?t:[t]).map((t=>findItem(t,this.treeData))).filter(Boolean),removeItem=t=>{let e=this.treeData.indexOf(t);this.treeData.splice(e,1),t.headEl.remove(),t.bodyEl.remove()};for(let t of s){try{if(this.options.b4Remove){let e=await this.options.b4Remove.call(this,t);e&&(t=e)}}catch(t){continue}removeItem(t)}return super.listen({name:"removed",cb:e,params:[s]}),this}async edit({source:t,target:e,cb:s}){if(this.destroyed||isEmpty(t)||isNull(e))return this;let i=findItem(e,this.treeData);if(!i)return this;for(let e in t){let s=t[e];try{if(this.options.b4Edit){let t=await this.options.b4Edit.call(this,{key:e,value:s},i);t&&(s=t)}"action"===e?i[e]=s.call({ins:this,item:e},i):["icon","disk","cube","image","label","tips","badge","disabled","content","contType","contData","ajaxType"].includes(e)?i[e]="disabled"===e?attrValBool(s):s:"selected"===e&&(attrValBool(s)?this.activate(i):i[e]=s)}catch(t){return this}}return super.listen({name:"edited",cb:s,params:[i]}),this}async graft({source:t,target:e,isFront:s=!0,cb:i}){if(this.destroyed||isNull(t))return this;let a=findItem(t,this.treeData),l=findItem(e,this.treeData);if(!a)return this;try{if(this.options.b4Graft){let t=await this.options.b4Graft.call(this,a,l);t&&t.source&&(a=t.source),t&&t.target&&(l=t.target)}}catch(t){return this}let n="";return l?(n=s?"beforeBegin":"afterEnd",l.headEl.insertAdjacentElement(n,a.headEl),l.bodyEl.insertAdjacentElement(n,a.bodyEl)):(n=s?"afterBegin":"beforeEnd",this.headsEl.insertAdjacentElement(n,a.headEl),this.bodiesEl.insertAdjacentElement("beforeEnd",a.bodyEl)),moveItem({source:a,target:l,data:this.treeData,isFront:s}),super.listen({name:"grafted",cb:i,params:[a,l]}),this}updateItemCont({target:t,content:e,contType:s,contData:i,ajaxType:a,cb:l}){if(this.destroyed)return this;let n=findItem(t,this.treeData);return isEmpty(e)||!n||e==n.content||(s?n.contType=s:"text"!==this.options.contType&&(n.contType=this.options.contType),i&&(n.contData=i),a&&(n.ajaxType=a),n.content=e,super.listen({name:"updatedItemCont",cb:l,params:[n]})),this}async updateCont(t,e){return this.destroyed||await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{ajaxType:this.options.ajaxType,xhrName:"contXhr"},cb:s=>{Array.isArray(s)&&(this.treeDataOrig=deepClone(s),S.addIdPath({source:this.treeDataOrig}),this.targetEl.innerHTML="",this.renderData(this.treeDataOrig),this.getTreeFlat(),this.renderFinish(),super.updateCache({content:t}),super.listen({name:"updatedCont",cb:e,params:[this.treeDataOrig]}))}}),this}destroy(t){return this.destroyed||(this.treeData.forEach((t=>{this.removeTrigger(t)})),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}class Tooltip extends Popup{constructor(t,e={},i=l.initial){isNull(e.size)&&(e.size="sm"),!0===e?.tools?e.tools={enable:!0,placement:"outside"}:!e?.tools&&(e.tools={enable:!1,placement:"outside"}),!e?.placement&&(e.placement="top"),!e?.footer&&(e.footer=!1),!e?.padding&&(e.padding=!1),!e?.theme&&(e.theme="text"),super(t,e,i),this.on("initiated",(()=>{this.mainEl.classList.add(`${s.prefix}tooltip`)}))}}var tt=Object.freeze({__proto__:null,default:Tooltip});const et=[{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"placement",prop:"placement",value:"bottom-start"},{attr:"list-type",prop:"listType",value:""},{attr:"unpadded",prop:"unpadded",value:!1},{attr:"hoverable",prop:"hoverable",value:!1},{attr:"divisible",prop:"divisible",value:!1},{attr:"multiline",prop:"multiline",value:!1},{attr:"cols",prop:"cols",value:0},{attr:"lines",prop:"lines",value:""},{attr:"detectable",prop:"detectable",value:!1},{attr:"child-sel",prop:"childSel",value:`[${s.alias}="label"]`},{attr:"val-key",prop:"valKey",value:""},{attr:"feature",prop:"feature",value:""},{attr:"popup",prop:"popup",value:{}},...p];class Dropdown extends ModBaseListenCache{popupIns;static hostType="node";static optMaps=et;constructor(t,e={},s=l.initial){super(),super.ready({options:e,host:t,maps:Dropdown.optMaps,component:!0,spread:[]}),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}this.popupIns&&this.popupIns.destroy();let e=this,i={content:this.options.content,contType:this.options.contType,contData:this.options.contData,tools:!1,trigger:"click",placement:"bottom-start",classes:`${s.prefix}dropdown`,autoFill:{enable:!0,childSel:this.options.childSel,detectable:this.options.detectable,key:this.options.valKey},bullet:{enable:!!this.options.listType,type:this.options.listType,unpadded:this.options.unpadded,hoverable:this.options.hoverable,divisible:this.options.divisible,multiline:this.options.multiline,cols:this.options.cols,lines:this.options.lines,action:this.options.action?this.options.action.bind(this):null},padding:!this.options.divisible&&"fence"!==this.options.lines,onInitiated:function(){e.options.feature&&this.mainEl.setAttribute("feature",e.options.feature)}},a=extend({target:i,source:this.options.popup});return this.setFeature(a),this.popupIns=new Popup(this.targetEl,a),this.setAttrs(),super.listen({name:"initiated",cb:t}),this}setAttrs(){}setFeature(t){"button"===this.options.feature?(t.footer=t.padding=t.autoFill.enable=!1,t.bullet.enable=t.bullet.divisible=!0,t.bullet.type=t.bullet.type||"custom",t.placement="bottom-center",t.size=""):"tooltip"===this.options.feature?(t.footer=t.bullet.enable=!1,t.placement="top-center",t.size=""):"select"===this.options.feature&&(t.footer=t.padding=!1,t.bullet.enable=t.autoFill.enable=t.bullet.divisible=!0,t.bullet.type="select-single",t.placement="bottom-center",t.size="sm")}destroy(){return this.destroyed||this.popupIns.destroy(),this}}const st=[{attr:"keys",prop:"keys",value:""},{attr:"props",prop:"props",value:"label"},{attr:"fuzzy",prop:"fuzzy",value:!0},{attr:"order",prop:"order",value:""},{attr:"limit",prop:"limit",value:0},{attr:"ignore",prop:"ignore",value:!0},{attr:"hyphen",prop:"hyphen",value:l.splitHyphen},{attr:"null-handle",prop:"nullHandle",value:"reset"},{attr:"highlight",prop:"highlight",value:{enable:!1,props:"label",node:"i",classes:`${s.prefix}c-issue`}},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"target",prop:"target",value:""},{attr:"editor",prop:"editor",value:""},{attr:"trigger",prop:"trigger",value:"input"},{attr:"delay",prop:"delay",value:200},{attr:"status",prop:"status",value:{enable:!1,placement:"list-top"}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"classes",prop:"classes",value:""},{attr:"bullet",prop:"bullet",value:{type:"custom",childNode:"div",unpadded:!1,hoverable:!1,divisible:!1,multiline:!1}},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-searched",prop:"onSearched",value:null},{attr:'on-processed"',prop:'onProcessed"',value:null},{attr:"on-updatedkeys",prop:"onUpdatedKeys",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},...p];class BtnElem extends CompBaseComm{labelEl;iconEl;tailEl;diskEl;cubeEl;imageEl;badgeEl;meanEl;tipsIns;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-badge",comp:BadgeElem}];static custAttrs=["type","theme","href","tab","target","rel","download","shape","size","width","check","icon","tail","disk","cube","image","tips","badge","mean",...this.baseAttrs];static boolAttrs=["disabled","shaded","grad"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,BtnElem)}getRawData(){this.getRawProps(BtnElem),this.initLabel(),this.getProxyProps()}initLabel(){if(this.innerHTML){let t=this.firstElementChild;t&&"A"===t.nodeName?(this.propsRaw.href=t.href,t.hasAttribute("target")&&(this.propsRaw.target=t.target),t.hasAttribute("rel")&&(this.propsRaw.rel=t.rel),t.hasAttribute("download")&&(this.propsRaw.download=t.download),this.propsRaw.label=t.innerHTML):this.propsRaw.label=this.innerHTML}else this.propsRaw.label=this.getAttribute("label")}getWrap(t){let e={[s.alias]:"wrap"},i="";isNull(t.href)?i="span":(i="a",e.href=t.href,t.target&&(e.target=t.target),t.rel&&(e.rel=t.rel)),this.wrapEl=createEl(i,e,this.labelEl)}insertIcon(t){this.iconEl=createEl("i",{class:t,[s.alias]:"icon"}),this.labelEl.insertAdjacentElement("beforeBegin",this.iconEl)}insertTail(t){this.tailEl=createEl("i",{class:t,[s.alias]:"tail"}),this.labelEl.insertAdjacentElement("afterEnd",this.tailEl)}insertMean(t){this.meanEl=createEl("i",{[s.alias]:t}),this.wrapEl.appendChild(this.meanEl)}insertBadge(t){isNull(t)||"0"===t||(this.badgeEl=createEl("ax-badge",{[s.alias]:"badge"},t?.trim()),this.wrapEl.appendChild(this.badgeEl))}insertDisk(t){t&&(this.diskEl=createEl("img",{[s.alias]:"disk",src:t}),this.labelEl.insertAdjacentElement("beforeBegin",this.diskEl))}insertCube(t){t&&(this.cubeEl=createEl("img",{[s.alias]:"cube",src:t}),this.labelEl.insertAdjacentElement("beforeBegin",this.cubeEl))}insertImage(t){t&&(this.imageEl=createEl("img",{[s.alias]:"image",src:t}),this.labelEl.insertAdjacentElement("beforeBegin",this.imageEl))}insertTips(t){t&&(this.tipsIns=new Tooltip(this,{content:t,trigger:"sticky",deadShow:!0}))}fillWrap(t){this.labelEl=createEl("i",{[s.alias]:"label"},t.label),this.getWrap(t),t.icon&&this.insertIcon(t.icon),t.tail&&this.insertTail(t.tail),t.mean&&this.insertMean(t.mean),t.cube&&this.insertCube(t.cube),t.image&&this.insertImage(t.image),t.disk&&this.insertDisk(t.disk),t.hasOwnProperty("badge")&&this.insertBadge(t.badge)}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel,href:this.changedHref,target:this.changedTarget,rel:this.changedTarget,download:this.changedTarget,tab:this.changedTab,icon:this.changedIcon,disk:this.changedDisk,cube:this.changedCube,image:this.changedImage,tips:this.changedTips,tail:this.changedTail,mean:this.changedMean,badge:this.changedBadge};changedLabel(t){this.labelEl.innerHTML=t.newVal||""}changedHref(t){null===t.newVal||null===t.oldVal?(this.innerHTML="",this.fillWrap(this.propsProxy),this.render()):this.wrapEl.href=t.newVal}changedTarget(t){t.newVal?this.wrapEl.setAttribute(t.name,t.newVal):this.wrapEl.removeAttribute(t.name)}changedTab(t){t.newVal?this.wrapEl.tabIndex=t.newVal:this.wrapEl.removeAttribute("tabindex")}changedIcon(t){this.iconEl?this.iconEl.setAttribute("class",t.newVal):this.insertIcon(t.newVal)}changedTail(t){this.tailEl?this.tailEl.setAttribute("class",t.newVal):this.insertTail(t.newVal)}changedDisk(t){this.diskEl?this.diskEl.setAttribute("src",t.newVal):this.insertDisk(t.newVal)}changedCube(t){this.cubeEl?this.cubeEl.setAttribute("src",t.newVal):this.insertCube(t.newVal)}changedImage(t){this.imageEl?this.imageEl.setAttribute("src",t.newVal):this.insertImage(t.newVal)}changedMean(t){this.meanEl?this.meanEl.setAttribute(s.alias,t.newVal):this.insertMean(t.newVal)}changedBadge(t){this.badgeEl?isNull(t.newVal)||"0"===t.newVal?this.badgeEl.remove():this.badgeEl.setAttribute("label",t.newVal):this.insertBadge(t.newVal)}changedTips(t){this.tipsIns?(this.tipsIns.updateCont(t.newVal),t.newVal?"shown"!==this.tipsIns.popupIns.state&&this.tipsIns.popupIns.show():this.tipsIns.popupIns.hide()):t.newVal&&this.insertTips(this.propsProxy.tips)}}class Retrieval extends ModBaseListenCache{options={};mainEl;inputEl;statusEl;inputEvt;keys;data;output;contXhr;editorEl;static hostType="none";static optMaps=st;static dependencies=[RadioElem,CheckboxElem,BadgeElem,BtnElem];constructor(t={},e=!0){super(),super.ready({options:t,type:Retrieval.hostType,maps:Retrieval.optMaps,component:!1,spread:["status","highlight"]}),this.targetEl=getEl(this.options.target),this.inputEl=getEl(this.options.editor),this.statusEl=createEl("div",{class:`${s.prefix}retrieval-status`}),this.inputEvt=debounce((()=>{let t=this.getInputVals();this.updateKeys(t)}),this.options.delay),super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}if(this.setEmpty(),this.keys=this.options.keys||this.getInputVals(),this.useTpl(),await getContent.call(this,{content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.targetEl,...this.options.ajax},cb:t=>{if(isEmpty(t))return this;this.data=this.getStdData(t),super.listen({name:"processed",params:[this.data]}),this.searchData(),this.render()}}),elState(this.statusEl).isVirtual&&this.options.status.enable)if("list-top"===this.options.status.placement)this.targetEl.insertAdjacentElement("beforebegin",this.statusEl);else if("list-btm"===this.options.status.placement)this.targetEl.insertAdjacentElement("afterend",this.statusEl);else if("editor-top"===this.options.status.placement)this.editorEl&&this.editorEl.insertAdjacentElement("beforebegin",this.statusEl);else if("editor-btm"===this.options.status.placement)this.editorEl&&this.editorEl.insertAdjacentElement("afterend",this.statusEl);else{let t=getEl(this.options.status.placement);t&&t.appendChild(this.statusEl)}return this.input2Render(),super.listen({name:"initiated",cb:t}),this}setEmpty(){this.targetEl&&(this.targetEl.innerHTML="")}setAttrs(){this.targetEl&&(this.targetEl.classList.add(`${s.prefix}retrieval`),this.options.classes&&classes(this.targetEl).add(this.options.classes))}getStdData(t){let e=getDataType(t),s=[];if("String"===e){s=valToArr(t,this.options.hyphen,!1).filter(Boolean).map((t=>({label:t,value:t})))}else if("Array"===e){if(0===t.length)return[];let e=getDataType(t[0]);s=["String","Number"].includes(e)?t.filter(Boolean).map((t=>({label:t+"",value:t+""}))):"Object"===e&&t[0].hasOwnProperty("label")?t.filter(Boolean).map((t=>(!t.hasOwnProperty("value")&&(t.value=t.label),t))):[]}else s=[];return s}searchData(t=this.keys,e=this.data){if(this.destroyed)return this;isEmpty(t)&&"reset"===this.options.nullHandle?this.output=e.map((t=>({source:t,weight:0,keys:[]}))):this.output=arrSearch({keys:t,props:this.options.props,source:e,hyphen:this.options.hyphen,fuzzy:this.options.fuzzy,ignore:this.options.ignore,order:this.options.order,limit:this.options.limit});for(let t of this.output)t.source.el=this.createItemEl(t),t.source.action&&t.source.action.call(this,t);this.updateStatus(),super.listen({name:"searched",params:[this.output]})}useTpl(){let t=getEl(this.options.tplStr);this.tplEng=this.options.tplEng||renderTpl,this.tplStr=t?.innerHTML||this.options.tplStr||b.getIBulletTpl(this.options.bullet)}createItemEl(t){let e=this.options.highlight.enable?this.getHighlightData(t):t.source,s=super.getTplcont(e);return tplToEl(s)}getHighlightData(t){if(!this.options.highlight.enable)return t;let e=getIntArr([valToArr(this.options.highlight.props,this.options.hyphen,!1),valToArr(this.options.props,this.options.hyphen,!1)]),s={...t.source},i=t.keys.map((t=>clearRegx(t))).filter(Boolean);for(let t in s)e.includes(t)&&0!==i.length&&(s[t]=super.replaceMult(s[t],i,{ignore:this.options.ignore,nodename:this.options.highlight.node,classes:this.options.highlight.classes}));return s}async render(t=this.output){if(this.destroyed)return this;if(isEmpty(t),this.options.b4Fill){let e=await this.options.b4Fill.call(this,t,this.targetEl);e&&(t=e)}this.targetEl&&(this.targetEl.innerHTML="",t.length>0&&this.targetEl.append(...t.map((t=>t.source.el))),super.listen({name:"rendered",params:[t,this.targetEl]})),this.renderCount++}updateKeys(t=this.getInputVals()){if(this.destroyed||t.toString()==this.keys.toString())return this;this.keys=t,this.searchData(),this.render(),super.listen({name:"updatedKeys",params:[t]})}input2Render(){if(!this.inputEl||this.destroyed)return this;this.inputEl.removeEventListener(this.options.trigger,this.inputEvt),this.inputEl.addEventListener(this.options.trigger,this.inputEvt,!1)}getInputVals(){return["radio","checkbox","radio-comp","checkbox-comp"].includes(this.inputEl.type)?this.inputEl.checked?this.inputEl.value:"":this.inputEl?.value||""}resetList(){if(this.destroyed)return this;this.output=this.data.map((t=>({source:t,weight:0,keys:[]})));for(let t of this.output)t.source.el=this.createItemEl(t),t.source.action&&t.source.action.call(this,t);this.render()}clearList(){if(this.destroyed)return this;this.inputEl&&(this.inputEl?.clear?this.inputEl.clear():this.inputEl.value=""),this.keys="",this.output=[],this.render()}updateStatus(){let t={value:this.output.length,keys:this.keys};this.statusEl.innerHTML=isEmpty(t.keys)?this.options.lang.nullKeys:renderTpl(this.options.lang.status,t)}async updateCont(t,e){return this.destroyed||await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.targetEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:s=>{if(isEmpty(s))return this;this.data=this.getStdData(s),super.listen({name:"processed",params:[this.data]}),this.searchData(),this.render(),this.updateCache({content:t}),this.listen({name:"updatedCont",cb:e,params:[s]})}}),this}destroy(t){return this.inputEl&&this.inputEl.removeEventListener(this.options.trigger,this.inputEvt),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const it=[{attr:"field",prop:"field",value:"value"},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"popup",prop:"popup",value:{}},{attr:"retrieval",prop:"retrieval",value:{}},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-hidden",prop:"onHidden",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-reset2show",prop:"onReset2Show",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},...p];class Autocomplete extends ModBaseListenCache{options={};mainEl;rendered;popupIns;retrievalIns;contXhr;static hostType="node";static optMaps=it;constructor(t,e={},s=l.initial){super(),super.ready({options:e,host:t,maps:Autocomplete.optMaps,component:!1,spread:[]}),this.rendered=!1,super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.targetEl?(super.getDirRtl(),this.createPopup(),this.createRetrieval(),this.setAttrs(),super.listen({name:"initiated",cb:t}),this):this}setVals(t){let e=this.targetEl.nodeName;["AX-INPUT","AX-TEXTAREA"].includes(e)?this.targetEl.setAttribute("value",t):["INPUT","TEXTAREA"].includes(e)&&(this.targetEl.value=t)}setEmpty(){this.popupIns&&this.popupIns.destroy(),this.popupIns?.contEl&&(this.popupIns.contEl.innerHTML=""),this.retrievalIns&&this.retrievalIns.destroy()}setAttrs(){this.popupIns.mainEl.classList.add(`${s.prefix}autocomplete`)}createPopup(){this.popupIns=new Popup(this.targetEl,extend({target:{placement:this.isRtl?"bottom-end":"bottom-start",tools:{enable:!0,placement:"outside"},pageClose:!1,footer:!1,trigger:"input",content:"",padding:!1,b4Show:()=>new Promise((t=>{this.rendered?t():this.popupIns.state="hidden"})),onHidden:()=>{this.rendered=!1}},source:this.options.popup}))}createRetrieval(){this.retrievalIns=new Retrieval(extend({target:{target:this.popupIns.contEl,editor:this.targetEl,content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:this.options.ajax,tplStr:this.options.tplStr,tplEng:this.options.tplEng,status:!0,highlight:!0,nullHandle:"clear",bubble:{divisible:!0,hoverable:!0}},source:this.options.retrieval})),this.retrievalIns.on("rendered",(t=>{for(let e of t)e.source.el.onclick=async()=>{let t=e.source[this.options.field];if(this.options.b4Fill){let s=await this.options.b4Fill.call(this,e,this.targetEl);s&&(t=s)}this.setVals(t),this.hide()};this.retrievalIns.renderCount>0&&(this.rendered=!0,this.retrievalIns.getInputVals().trim()&&this.popupIns.show(),this.rendered=!1)}))}reset2Show(t){return this.destroyed||(this.retrievalIns.resetList(),this.show(),super.listen({name:"reset2Show",cb:t})),this}clear(t){return this.destroyed||(this.retrievalIns.clearList(),this.hide(),super.listen({name:"cleared",cb:t})),this}show(t){return this.destroyed||(this.rendered=!0,this.popupIns.show(),super.listen({name:"shown",cb:t})),this}hide(t){return this.destroyed||(this.popupIns.hide(),super.listen({name:"hidden",cb:t})),this}updateCont(t,e){return this.destroyed||this.retrievalIns.updateCont(t,(s=>{this.updateCache({content:t}),this.listen({name:"updatedCont",cb:e,params:[s]})})),this}destroy(t){return this.retrievalIns.destroy(),this.popupIns.destroy(),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const at=[{attr:"wrapper",prop:"wrapper",value:""},{attr:"flow",prop:"flow",value:"v"},{attr:"bounce",prop:"bounce",value:!0},{attr:"delay",prop:"delay",value:200},{attr:"gridded",prop:"gridded",value:!1},{attr:"snap",prop:"snap",value:{enable:!1,mode:"auto",force:!1,offset:0,selector:""}},{attr:"drift",prop:"drift",value:{enable:!1,mode:"auto",value:0,coef:2}},{attr:"swipe",prop:"swipe",value:{enable:!1,mode:"auto",value:0,coef:2}},{attr:"bar",prop:"bar",value:{enable:!1,sticky:!1,triggerable:!0}},{attr:"dmp-ratio",prop:"dmpRatio",value:.5},{attr:"initial",prop:"initial",value:{value:null,mode:"scroll"}},{attr:"child",prop:"child",value:{size:null,gap:0,settable:!1}},{attr:"toinit-mode",prop:"toInitMode",value:"scroll"},{attr:"duration",prop:"duration",value:300},{attr:"resize-thr",prop:"resizeThr",value:1},{attr:"rtl",prop:"rtl",value:!1},{attr:"wheel",prop:"wheel",value:{mode:"const",value:0,reverse:!1}},{attr:"keyboard",prop:"keyboard",value:!1},{attr:"completed-thr",prop:"completedThr",value:50},{attr:"padding-start",prop:"paddingStart",value:0},{attr:"padding-end",prop:"paddingEnd",value:0},{attr:"insertable",prop:"insertable",value:!0},{attr:"gesture",prop:"gesture",value:{}},{attr:"b4-tostart",prop:"b4ToStart",value:null},{attr:"b4-toend",prop:"b4ToEnd",value:null},{attr:"on-completed",prop:"onCompleted",value:null},{attr:"on-exceeded",prop:"onExceed",value:null},{attr:"on-start",prop:"onStart",value:null},{attr:"on-move",prop:"onMove",value:null},{attr:"on-end",prop:"onEnd",value:null},{attr:"on-getsnappeds",prop:"onGetSnappeds",value:null},{attr:"on-refactored",prop:"onRefactored",value:null},{attr:"on-snap",prop:"onSnap",value:null},{attr:"on-snapped",prop:"onSnapped",value:null},{attr:"on-resized",prop:"onResized",value:null},{attr:"on-scroll",prop:"onScroll",value:null},{attr:"on-scrolled",prop:"onScrolled",value:null},{attr:"on-locate",prop:"onLocate",value:null},{attr:"on-located",prop:"onLocated",value:null},...p];class Scroll extends ModBaseListenCache{options={};forwardMap;reverseMap;wrapEl;snappeds;unsnappeds;snapped;started;scrolled;cross;childAvgSize;resizeCount;mutateCount;canResize;canMutate;initialResize;key2Trans;resizeListener;mutationListener;targetSize;reverseSize;wrapSize;paddingStart;paddingEnd;rangeEnd;rangeStart;activeSize;baseSize;isBaby;transNow;transLast;gap;barSize;progress;trackEl;thumbEl;barIns;gestureIns;wrapStyleObs;sizeObs;lastSnapped;respThrot;axis;tmpTarget;static hostType="node";static optMaps=at;constructor(t,e={},s=l.initial){if(super(),super.ready({options:e,host:t,maps:Scroll.optMaps,component:!1,spread:["snap","drift","swipe","bar","keyboard"]}),this.axis="v"===this.options.flow?"y":"x",this.forwardMap=o[this.axis],this.reverseMap=o["x"===this.axis?"y":"x"],this.wrapEl=this.options.wrapper?getEl(this.options.wrapper):this.targetEl.firstElementChild,!this.wrapEl)return this;this.snappeds=[],this.unsnappeds=[],this.snapped=null,this.started=!1,this.scrolled=!0,this.cross="",this.childAvgSize=null,this.resizeCount=0,this.mutateCount=0,this.canResize=!0,this.canMutate=!0,this.initialResize=!1,this.resizeListener=debounce((t=>{this.resizeCount++;for(let e of t){if(!e.contentRect.width&&!e.contentRect.height)return;this.response()}super.listen({name:"resized",params:[t]}),(this.resizeCount===this.options.resizeThr||!this.wrapEl.firstElementChild&&this.resizeCount===this.options.resizeThr-1)&&(this.setTransInit(),this.initialResize=!0,super.listen({name:"prepared",params:[t]}))}),this.options.delay),this.mutationListener=debounce((t=>{this.mutateCount++;for(let e of t)"attributes"===e.type&&(this.updateProg(),this.options.bar.enable&&this.updateBarProg()),"childList"===e.type&&(this.options.snap.enable&&this.getSnappeds(),this.response());super.listen({name:"refactored",params:[t]})}),this.options.delay),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setEmpty(),this.setAttrs(),this.transNow=this.transLast=0,this.gap=toPixel(this.options.child.gap),this.createBar(),this.updateDiff(),this.initSnapArgs(),this.getSnappeds(),await promiseRaf((()=>{this.getGestureIns(),this.setObserver()})),super.listen({name:"initiated",cb:t}),this}initSnapArgs(){if(!this.options.snap.enable)return this;"auto"===this.options.snap.mode?!this.options.snap.selector&&(this.options.snap.selector="[unalignable]"):(!this.options.snap.selector&&(this.options.snap.selector="[alignable]"),!this.options.snap.offset&&(this.options.snap.offset=50))}setEmpty(){}setAttrs(){this.targetEl.classList.add(`${s.prefix}scroll`),this.wrapEl.classList.add(`${s.prefix}scroll-wrap`),this.targetEl.setAttribute("flow",this.options.flow),this.targetEl.toggleAttribute("gridded",this.options.gridded),this.options.rtl?this.targetEl.setAttribute("dir","rtl"):this.targetEl.removeAttribute("dir")}getGestureIns(){this.gestureIns=new Gesture(this.wrapEl,extend({target:{wheel:!0,keyboard:{enable:this.options.keyboard,prev:"h"===this.options.flow?this.isRtl?"ArrowRight":"ArrowLeft":"ArrowUp",next:"h"===this.options.flow?this.isRtl?"ArrowLeft":"ArrowRight":"ArrowDown",target:this.targetEl},spy:this.options.keyboard,step:{mode:"translate",axis:this.axis,value:this.options.wheel.value,linkage:!1,duration:this.options.duration},drift:{enable:this.options.drift.enable,coef:this.options.drift.coef,auto:!1},swipe:{enable:this.options.swipe.enable,coef:1,auto:!1},initialVal:{[this.axis]:this.transNow},onStep:t=>{this.getStepVal(t.step.direction[this.axis])},onStepped:t=>{this.scrollTo({target:t.translate.value[this.axis],duration:this.options.duration,snap:!0})},onTranslate:t=>{super.listen({name:"start",params:[t.translate]})},onTranslating:t=>{if(t.translate.diff.h>2){if(this.transNow=t.translate.value[this.axis],this.cross=this.crossLinkage(),this.cross.includes("baby")){if("wheel"===t.pointer)return this;"baby-start"===this.cross?this.transNow=this.getDmpVals("start+"):"baby-start-reverse"===this.cross&&(this.transNow=this.getDmpVals("start-"))}else if("teen-start"===this.cross){if("wheel"===t.pointer)return this.toStart(),this;this.transNow=this.getDmpVals("start+")}else if("teen-end"===this.cross){if("wheel"===t.pointer)return this.toEnd(),this;this.transNow=this.getDmpVals("end+")}else if("adult-start"===this.cross){if("wheel"===t.pointer)return this.toStart(),this;this.transNow=this.getDmpVals("start+")}else if("adult-end"===this.cross){if("wheel"===t.pointer)return this.toEnd(),this;this.transNow=this.getDmpVals("end+")}C.set({el:this.wrapEl,data:{translate:{[this.axis]:this.transNow}}}),this.handleExceedLimit({linkage:this.cross}),super.listen({name:"move",params:[t.translate]})}},onTranslated:t=>{this.transLast=this.transNow,this.handleExceedLimit({start:async t=>{this.options.b4ToStart&&await this.options.b4ToStart.call(this,t),this.toStart(),this.gestureIns.preventEase=!0},end:async t=>{this.options.b4ToEnd&&await this.options.b4ToEnd.call(this,t),this.toEnd(void 0,!1),this.gestureIns.preventEase=!0},normal:()=>{this.options.snap.enable&&!t.translate.canDrfit&&this.setSnapped()}}),super.listen({name:"end",params:[t.translate]})},onSwipe:t=>{this.setEaseTo(t,"swipe")},onDrift:t=>{this.setEaseTo(t)}},source:this.options.gesture}))}getRtlRange(){let rtlHandler=()=>{let t=this.rangeStart;this.rangeStart=-1*this.rangeEnd,this.rangeEnd=-1*t};if("rtl"===this.targetEl.getAttribute("dir"))return rtlHandler(),void(this.isRtl=!0);getRtl()&&(this.isRtl=!0,rtlHandler())}setTransInit(){let t={target:isNull(this.options.initial.value)?this.isRtl?this.rangeStart:this.rangeEnd:this.options.initial.value,snap:!0};"localte"===this.options.initial.mode?this.locateTo(t):this.scrollTo(t)}createBar(){if(this.options.bar.enable&&(this.trackEl||(this.thumbEl=createEl("span"),this.trackEl=createEl("div",{class:`${s.prefix}scroll-bar`},this.thumbEl),this.options.bar.sticky&&this.trackEl.setAttribute("shown",""),this.targetEl.appendChild(this.trackEl)),this.options.bar.triggerable&&!s.isTouchScr)){let t=0;this.barIns=new Gesture(this.trackEl,{onTranslate:()=>{t=this.progress,this.trackEl.setAttribute("scrolling","")},onTranslating:e=>{this.locateTo({target:t+e.translate.value[this.axis]/this.barSize.diff,isRatio:!0})},onTranslated:()=>{this.trackEl.removeAttribute("scrolling")}})}}setObserver(){this.wrapStyleObs=new MutationObserver((t=>{this.canMutate&&this.mutationListener(t)})),this.wrapStyleObs.observe(this.wrapEl,{childList:!0,attributes:!0,attributeFilter:["style"]}),this.sizeObs=new ResizeObserver((t=>{this.canResize&&this.resizeListener(t)})),this.sizeObs.observe(this.targetEl),this.sizeObs.observe(this.wrapEl)}response(){this.updateDiff(),this.isBaby||this.wrapEl[this.forwardMap.offset]>this.paddingStart?this.toStart():this.transNow<this.rangeStart?this.toEnd(void 0,!1):this.options.snap.enable&&this.setSnapped()}getDmpVals(t){let e=0,s=this.options.dmpRatio**2;if("start+"===t)e=this.options.bounce?this.paddingStart*super.getRtlCoef()+(this.transNow-this.paddingStart*super.getRtlCoef())*s:this.paddingStart;else if("end+"===t){let t=this.isRtl?this.rangeEnd:this.rangeStart;e=this.options.bounce?t+(this.transNow-t)*s:t}else"start-"===t&&(e=this.options.bounce?this.paddingStart*super.getRtlCoef()-(this.paddingStart*super.getRtlCoef()-this.transNow)*s:this.paddingStart);return e}getTruePadding(t){let e;if("center"===t){let t=~~style(this.wrapEl.firstElementChild)[this.forwardMap.size].replace("px",""),s=isNull(this.childAvgSize)?t:this.childAvgSize;e=(this.targetSize-s)/2}else"number"==typeof t?e=t<=0?0:t<1?this.targetSize*t:t:"string"==typeof t&&(e=toPixel(t));return e}setChildSize(){let getVal=t=>{let e=typeof t;if("string"===e){if(t.includes("/")){let e=~~t.split("/")[1].trim();return e<=1?this.targetSize:(this.targetSize-(e-1)*this.gap)/e}return toPixel(t)}return"number"===e?t<0?0:t<=1&&t>=0?this.targetSize*t:t:null};if(!isEmpty(this.options.child.size)){let t=[...this.wrapEl.children];if(Array.isArray(this.options.child.size)){if(this.options.child.settable){let e=this.options.child.size.map((t=>getVal(t)));t.forEach(((t,s)=>{!isNull(e[s])&&(t.style[this.forwardMap.size]=e[s]+"px")}))}}else{let e=getVal(this.options.child.size);if(this.childAvgSize=e,!isNull(e)&&this.options.child.settable)for(let s of t)s.style[this.forwardMap.size]=e+"px"}}}updateDiff(){let t=style(this.targetEl),e=style(this.wrapEl),s=parseInt(t.height),i=parseInt(e.height),a=parseInt(t.width),l=parseInt(e.width),n=0,r=0,o=0;"x"===this.axis?(n=a,r=s,o=l):"y"===this.axis&&(n=s,r=a,o=i),this.targetSize=n,this.reverseSize=r,this.wrapSize=o,this.setChildSize(),this.paddingStart=this.getTruePadding(this.options.paddingStart),this.paddingEnd=this.getTruePadding(this.options.paddingEnd),this.paddingStart+this.paddingEnd>=n&&(this.paddingStart=this.paddingEnd=0),this.rangeEnd=this.paddingStart,this.rangeStart=n-o-this.paddingEnd,this.isBaby=n-o-this.paddingEnd-this.paddingStart>0,this.getRtlRange(),this.activeSize=this.isBaby?0:this.rangeEnd-this.rangeStart,this.baseSize=this.targetSize-this.paddingStart-this.paddingEnd,this.updateProg(),this.getBarSize(),this.updateBarProg()}getNowTargetDist(t){if(!t)return 0;let e=getDataType(t);return"Number"===e?Math.abs(t-this.transNow):e.includes("HTML")?this.isRtl?Math.abs(this.getChildParentOffset(t)+this.transNow+this.rangeStart):Math.abs(this.getChildParentOffset(t)+this.transNow-this.rangeEnd):0}setEaseTo(t,e="drift"){t[e].value[this.axis]=this.getEaseDist(t.translate.direction[this.axis],this.getEdgeValue(t[e].value[this.axis]),e);let s=this.options.snap.enable&&"auto"===this.options.snap.mode?this.getNearestSnap(t[e].value[this.axis]).nearest:t[e].value[this.axis];this.scrollTo({target:s,snap:!0})}getEaseDist(t,e,s="drift"){let i=e;if("ratio"===this.options[s].mode){let e=this.options[s].value||1;i=this.transNow+this.baseSize*e*t}else if("const"===this.options[s].mode)this.options[s].value&&(i=this.transNow+this.options[s].value*t);else if("snap"===this.options[s].mode&&this.options.snap.enable&&"auto"===this.options.snap.mode){let e=this.getEaseNextTrans(t,s);!isNull(e)&&(i=e)}else if("slide"===this.options[s].mode){let e=this.getEaseNextTrans(t,s,"slide");!isNull(e)&&(i=e)}return i}getEaseNextTrans(t,e="drift",s="snap"){let i=null,a="slide"===s?[...this.wrapEl.children]:this.snappeds,l="slide"===s?this.getNearestSlide():this.snapped,n=a.findIndex((t=>t===l));if(n>-1){let s=[0,1].includes(this.options[e].value)?1:this.options[e].value,l=1===t?this.getNowTargetDist(a[n-s]):-1===t?-1*this.getNowTargetDist(a[n+s]):0;i=this.transNow+l}return i}getStepVal(t){if("ratio"===this.options.wheel.mode){let t=this.options.wheel.value||.25,e=this.baseSize*t;this.gestureIns.stepVal=e}else"const"===this.options.wheel.mode?this.options.wheel.value&&(this.gestureIns.stepVal=this.options.wheel.value):"snap"===this.options.wheel.mode&&this.options.snap.enable&&"auto"===this.options.snap.mode?this.getWheelNextTrans(t):"slide"===this.options.wheel.mode&&this.getWheelNextTrans(t,"slide");this.gestureIns.stepVal=this.gestureIns.stepVal*super.getRtlCoef()}getWheelNextTrans(t,e="snap"){let s="slide"===e?[...this.wrapEl.children]:this.snappeds,i="slide"===e?this.getNearestSlide():this.snapped,a=s.findIndex((t=>t===i));if(a>-1){let e=[0,1].includes(this.options.wheel.value)?1:this.options.wheel.value;this.gestureIns.stepVal=1===t?this.getNowTargetDist(s[a+e]):-1===t?this.getNowTargetDist(s[a-e]):0}}getEdgeValue(t,e=!1){let s=this.isRtl?this.rangeStart:this.rangeEnd;if(this.isBaby)return s;let i=getDataType(t);if(i.includes("HTML")||"String"===i){let e=getEl(t,this.targetEl);e&&(s-=this.getChildParentOffset(e))}else if(e){let e=clampVal({min:0,max:1,val:t});s=this.rangeEnd-this.activeSize*e}else s=t;return(s||0===s)&&(s>=this.rangeEnd?s=this.rangeEnd:s<=this.rangeStart&&(s=this.rangeStart)),s}updateProg(t=this.transNow){this.activeSize<=0?this.progress=1:this.progress=(this.isRtl?t-this.rangeStart:this.rangeEnd-t)/this.activeSize}getBarSize(){if(this.options.bar.enable){let t=parseInt(style(this.trackEl)[this.forwardMap.size]),e=t*Math.min(this.baseSize/this.wrapSize,1);this.barSize={track:t,thumb:e,diff:t-e}}}updateBarProg(){if(this.options.bar.enable){let t=this.progress<0?Math.abs(this.progress):this.progress>1?this.progress-1:0,e=this.progress>=0||this.progress<=1?this.progress:1,s=this.barSize.thumb*(1-t**2),i=(this.barSize.track-s)*e;this.thumbEl.style[this.forwardMap.size]=s+"px",this.thumbEl.style[this.forwardMap.start]=i+"px"}}exceedListen(t,e){this.listen({name:"exceeded",params:[t,e]}),t>=1&&this.listen({name:"completed",params:[t,e]})}handleExceedLimit({start:t,end:e,normal:s,linkage:i}){let a=0,l=i||this.crossLinkage();l.includes("start")?(a=Math.abs(this.transNow/this.options.completedThr),t&&t(a.toFixed(2)),i&&this.exceedListen(toNumber(a,{places:2}),"start")):l.includes("end")?(a=Math.abs(this.transNow*super.getRtlCoef()-this.rangeStart)/this.options.completedThr,e&&e(a.toFixed(2)),i&&this.exceedListen(toNumber(a,{places:2}),"end")):s&&s()}crossLinkage(t=this.transNow){let e="regular";return t*=super.getRtlCoef(),(this.isRtl?-this.rangeEnd:this.rangeStart)>0?this.isBaby?e=t>this.paddingStart?"baby-start":"baby-start-reverse":t>this.paddingStart?e="teen-start":(t<this.isRtl?-this.rangeEnd:this.rangeStart)&&(e="teen-end"):t>this.paddingStart?e="adult-start":t<(this.isRtl?-this.rangeEnd:this.rangeStart)&&(e="adult-end"),e}toStart(t,e=!0){if(this.destroyed||this.transNow===this.rangeEnd)return this;this.scrollTo({target:this.paddingStart*super.getRtlCoef(),snap:e,duration:t||this.options.duration,after:()=>{super.listen({name:"toStart"})}})}toEnd(t,e=!0){if(this.destroyed||this.transNow===this.rangeStart)return this;this.scrollTo({target:this.isRtl?this.rangeEnd:this.rangeStart,snap:e,duration:t||this.options.duration,after:()=>{super.listen({name:"toEnd"})}})}toPrev(){if(this.destroyed||this.transNow===this.rangeEnd)return this}toNext(){if(this.destroyed||this.transNow===this.rangeStart)return this}getSnappeds(){this.options.snap.enable&&("auto"===this.options.snap.mode?(this.unsnappeds=super.single2Els(this.options.snap.selector,this.wrapEl),this.snappeds=[...this.wrapEl.children].filter((t=>!this.unsnappeds.includes(t)))):this.snappeds=super.single2Els(this.options.snap.selector,this.wrapEl),super.listen({name:"getSnappeds",params:[this.snappeds]}))}getChildParentOffset(t,e=this.wrapEl){let s=this.isRtl&&"left"===this.forwardMap.position?"right":this.forwardMap.position;return t.getBoundingClientRect()[s]-e.getBoundingClientRect()[s]}sortEls(t,e=this.transNow){let s=t.map((t=>({el:t,offset:Math.abs(e-this.paddingStart*super.getRtlCoef()+this.getChildParentOffset(t))})));return s.sort(((t,e)=>t.offset-e.offset)),s}getNearestSnap(t=this.transNow){let e=this.sortEls(this.snappeds,t),s=null;if("auto"===this.options.snap.mode)if(this.options.snap.offset){let t=e.find((t=>t.offset<=this.options.snap.offset));s=t?t.el:null}else s=e[0].el;else s=e[0].offset<=this.options.snap.offset?e[0].el:null;return{nearest:s,snappeds:e}}getNearestSlide(t=this.transNow){let e=this.sortEls([...this.wrapEl.children],t);return e[0]?.el}setSnapped(t={}){if(this.destroyed||0===this.wrapEl.children.length||!this.options.snap.enable)return this;this.scrolled=!1;let e=Object.assign({force:this.options.snap.force},t),s=this.getNearestSnap(),i=s.snappeds,a=s.nearest,l=e.target?getEl(e.target,this.wrapEl):null,n=this.tmpTarget||l||a;if(!a||!n)return this;(n!==this.snapped||e.force)&&(this.toggleSnappedAttr(n,i),super.listen({name:"snap",cb:e.before,params:[n]}),this.tmpTarget=null),this.scrollTo({target:n,duration:e.duration||this.options.duration,after:()=>{n===this.snapped&&super.listen({name:"snapped",cb:e.after,params:[n]})}})}toggleSnappedAttr(t,e=this.getNearestSnap().snappeds){let s,i=getEl(t,this.wrapEl);i&&(i.setAttribute("snapped",""),s=e.find((t=>t.el!==i&&t.el.hasAttribute("snapped"))),s&&s.el.removeAttribute("snapped"),this.snapped=i)}scrollTo({target:t=this.transNow,duration:e,before:s,after:i,snap:a=!1,isRatio:l=!1}){if(this.destroyed)return this;this.scrolled=!1;let n=this.getEdgeValue(this.tmpTarget||t,l);if(this.transNow===n)return;let r=this.transNow,o=Math.abs(this.transNow-n)/this.targetSize,h=e||0==e?e:Math.trunc(this.options.duration*o);this.wrapEl.style.transitionDuration=clampVal({val:h,min:200,max:2e3})+"ms",C.set({el:this.wrapEl,data:{translate:{[this.axis]:n}}}),super.listen({name:"scroll",cb:s,params:[n,r]}),this.transLast=this.transNow=n,delay({duration:h,done:()=>{this.options.snap.enable&&(a?this.setSnapped():this.getNearestSnap()),super.listen({name:"scrolled",cb:i,params:[n,r]}),this.scrolled=!0,this.tmpTarget=null}})}locateTo({target:t=this.transNow,before:e,after:s,snap:i=!1,isRatio:a=!1}){if(this.destroyed)return this;let l=this.getEdgeValue(this.tmpTarget||t,a);if(this.transNow===l)return;let n=this.transNow;this.wrapEl.style.transitionDuration="0ms",C.set({el:this.wrapEl,data:{translate:{[this.axis]:l}}}),super.listen({name:"locate",cb:e,params:[l,n]}),this.transLast=this.transNow=l,this.options.snap.enable&&(i?this.setSnapped():this.getNearestSnap()),this.tmpTarget=null,super.listen({name:"located",cb:s,params:[l,n]})}destroy(t){return this.destroyed||(this.sizeObs.disconnect(),this.wrapStyleObs.disconnect(),this.options.bar.enable&&this.options.bar.triggerable&&!s.isTouchScr&&this.barIns.destroy(),this.gestureIns.destroy(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const lt=[{attr:"gap",prop:"gap",value:0},{attr:"cols",prop:"cols",value:0},{attr:"classes",prop:"classes",value:""},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"media",prop:"media",value:{title:"",brief:""}},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},...p];class Masonry extends ModBaseListenCache{options={};itemsTmp;itemsObs;items;itemSizeObs;gap;canListen;static hostType="node";static optMaps=lt;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Masonry.optMaps,host:t,component:!1}),this.itemsTmp=[],this.itemsObs=new Observe(this.itemsTmp,{onSet:t=>{getDataType(t.value).includes("HTML")&&(this.targetEl.appendChild(t.value),this.itemSizeObs.observe(t.value))},onDeleted:t=>{},onCompleted:()=>{}}),this.items=this.itemsObs.proxy,this.itemSizeObs=new ResizeObserver((t=>{for(let e of t)this.updateItemStyle(e.target)})),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setAttrs(),this.gap=this.getGap(),this.targetEl.style.columnGap=`${this.gap}px`,Array.isArray(this.options.content)&&this.options.content.length>0?this.items.push(...this.options.content):this.targetEl.innerHTML.trim()&&this.items.push(...this.targetEl.children),super.listen({name:"initiated",cb:t}),this}getGap(){return Math.ceil(toPixel(this.options.gap||style(this.targetEl).columnGap))}setAttrs(){this.targetEl.classList.add(`${s.prefix}masonry`),classes(this.targetEl).add(this.options.classes),this.options.cols?addStyle(this.targetEl,"grid-template-columns",`repeat(${this.options.cols}, 1fr)`):removeStyle(this.targetEl,"grid-template-columns")}updateItemStyle(t){let e=t.offsetHeight;t.style.gridRow=`span ${Math.ceil(e+this.gap)}`}setItem(t){this.itemSizeObs.observe(t)}async add(t,e){if(this.destroyed)return this;let s=Array.isArray(t)?t:[t];return this.options.b4Add&&await this.options.b4Add.call(this,s),this.items.push(...s),super.listen({name:"add",cb:e,params:[s]}),this}async remove(t,e){if(this.destroyed)return this;let s=Array.isArray(t)?t:[t];this.options.b4Remove&&await this.options.b4Remove.call(this,s);for(let t=0;t<s.length;t++){let e=s[t],i=this.items.findIndex((t=>t===e));i>-1&&(this.items.splice(i,1),this.items[i].remove())}return super.listen({name:"remove",cb:e,params:[s]}),this}async clear(t){return this.destroyed||(this.options.b4Clear&&await this.options.b4Clear.call(this),this.items.splice(0),this.targetEl.innerHTML="",super.listen({name:"cleared",cb:t})),this}destroy(t){return this.destroyed||(this.clearCache(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const nt=[{attr:"flow",prop:"flow",value:"h"},{attr:"keyboard",prop:"keyboard",value:!1},{attr:"active",prop:"active",value:0},{attr:"duration",prop:"duration",value:500},{attr:"throttle",prop:"throttle",value:0},{attr:"slides",prop:"slides",value:1},{attr:"divide",prop:"divide",value:1},{attr:"group",prop:"group",value:0},{attr:"loop",prop:"loop",value:!1},{attr:"autoHeight",prop:"autoHeight",value:!1},{attr:"countdown",prop:"countdown",value:{}},{attr:"gap",prop:"gap",value:0},{attr:"unalign",prop:"unalign",value:"[unalignable]"},{attr:"centered",prop:"centered",value:{enable:!1,fill:!1}},{attr:"active",prop:"active",value:0},{attr:"keyboard",prop:"keyboard",value:!1},{attr:"resize-reset",prop:"resizeReset",value:!0},{attr:"drift",prop:"drift",value:1},{attr:"wheel",prop:"wheel",value:1},{attr:"scroll",prop:"scroll",value:{}},{attr:"height",prop:"height",value:0},{attr:"width",prop:"width",value:0},{attr:"tools",prop:"tools",value:{enable:!1,placement:"right-top",children:[]}},{attr:"total",prop:"total",value:{enable:!1,placement:"right-top",format:"<i></i><s>/</s><u></u>",selector:""}},{attr:"pgn",prop:"pgn",value:{enable:!1,classes:"",type:"lamp",selector:"",data:[],before:null,after:null}},{attr:"nav",prop:"nav",value:{enable:!0,classes:"",fill:!1,intvl:500,prev:{selector:"",classes:"",text:""},next:{selector:"",classes:"",text:""}}},{attr:"thumb",prop:"thumb",value:{content:null,type:"swipe",attribute:"selected",mode:"scroll"}},{attr:"zoom",prop:"zoom",value:{enable:!1,step:.5,min:0,max:10,value:2,selector:""}},{attr:"autoplay",prop:"autoplay",value:{enable:!1,delay:4e3,countdown:!1}},{attr:"integrated",prop:"integrated",value:!1},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"hyphen",prop:"hyphen",value:l.splitHyphen},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"lazy",prop:"lazy",value:!1},{attr:"media",prop:"media",value:{title:"",brief:""}},{attr:"classes",prop:"classes",value:""},{attr:"on-prepared",prop:"onPrepared",value:null},{attr:"on-changed",prop:"onChanged",value:null},{attr:"on-paused",prop:"onPaused",value:null},{attr:"on-played",prop:"onPlayed",value:null},...p],getSlidersData=async function(t){let e=getEl(t.wrap),s=getEl(t.parent),i=[];isEmpty(t.content)?i=e&&e.innerHTML.trim()?[...e.children]:[]:await getContent.call(this,{content:t.content,contType:t.contType,contData:t.contData,hyphen:t.hyphen,ajax:{xhrName:"contXhr",spinSel:s,...t.ajax||{}},cb:t=>{i=t}});let fillSlider=async(e,s)=>{let i=getDataType(s);"String"===i||"Number"===i?e.innerHTML=s:"Object"===i?s.hasOwnProperty("content")?await getContent.call(this,{content:s.content,contType:s.contType,contData:s.contData,hyphen:s.hyphen||t.hyphen,ajax:{xhrName:"contXhr",spinSel:e,...s.ajax||{}},cb:t=>{let i=getDataType(t);["String","Number"].includes(i)?e.innerHTML=t:i.includes("HTML")?e.appendChild(t):["Object","Array"].includes(i)&&(e.innerHTML=getStrFromTpl.call(this,t,s.tplStr,s.tplEng))}}):e.innerHTML=getStrFromTpl.call(this,s):"Array"===i&&(e.innerHTML=getStrFromTpl.call(this,s))},a=getDataType(i),l=[];if(a.includes("HTML"))l=[{source:i,slider:i}];else if("String"===a){let t=createEl("div","",i);l=[...(t.querySelector("ul,ol")||t).children].map((t=>({source:t,slider:t})))}else if("Array"===a||"Object"===a){let n="Object"===a?[i]:i.filter((t=>!isNull(t)));if(0===n.length)return;l=n.map((i=>{let a;return getDataType(i).includes("HTML")?a=i:(a=createEl("li"),t.lazy?i.spy=new Spy(a,{root:s||e,repeat:!1,onIn:()=>{fillSlider(a,i)}}):fillSlider(a,i)),{source:i,slider:a}}))}return t.cb&&t.cb(l),l};class Swipe extends ModBaseListenCache{options={};intercepted;button;content;folded;handlers;html;pureHtml;event;text;ell;countdownEl;intervalEvt;startClone;endClone;sliderTpl;prepareListen;resetListener;setBulletActive;spyIns;slidersTmp;bulletsTmp;paused;scrollOpt;scrollIns;wrapEl;navEl;pgnEl;pgnIns;prevEl;nextEl;totalEl;numEl;denEl;bullets;bulletSeq;interval;countdownIns;toolsEl;keyToSwipe;sliders;group;actIdx;slidersObs;bulletsObs;slideSize;slideSizeDivide;slides;totalClone;thumbIns;thumbs;setSnapEvt;zoomIns;canZoom;snapSlider;prepared;static hostType="node";static optMaps=nt;constructor(t,e={},i=!0){super(),super.ready({options:e,maps:Swipe.optMaps,host:t,component:!0,spread:["autoplay","total","tools","pgn","nav","centered","zoom"]}),this.countdownEl=createEl("div"),this.intervalEvt=()=>{this.toNextBullet(),this.startCountdown()},this.startClone=[],this.endClone=[],this.sliderTpl={label:"",content:"",thumb:"",brief:"",slider:null,cb:null},this.snapSlider={},this.prepareListen=throttle((()=>{this.fillWedgets(),this.setBulletActive(this.bullets.find((t=>this.actIdx===t.index))||0),this.toggleNavDisabled(),this.targetEl.classList.remove(`${s.prefix}initiating`),this.setAutoPlay(),this.prepared=!0,super.listen({name:"prepared"})})),this.resetListener=throttle((()=>{this.getSingleSize(),this.setSlideSize(),this.group>this.sliders.length&&(this.group=this.sliders.length),super.listen({name:"resized"})})),this.setBulletActive=t=>{let e=this.findBullet(t);if(!e||e.active)return;e.active=!0;let s=this.bullets.find((t=>t!==e&&t.active));s&&Reflect.deleteProperty(s,"active")};let a=this;this.setSnapEvt=function(){let t=a.thumbs.findIndex((t=>t===this));a["locate"===a.options.thumb.mode?"toLocate":"toSnap"](t)},super.listen({name:"constructed"}),i&&(this.options.lazy?this.spyIns=new Spy(this.targetEl,{repeat:!1,onIn:()=>{this.init()}}):this.init())}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.slidersTmp=[],this.bulletsTmp=[],this.paused=!0,this.setAttrs(),this.createWrap(),await this.getSliders(this.options.content,(t=>{this.slidersTmp=t})),this.setSlidesObs(),this.setBulletsObs(),this.actIdx=this.getIdxFromActive(this.options.active),this.appendSliders(),this.group=clampVal({val:this.options.group,min:0,max:this.sliders.length}),this.setScroll(),this.getThumbSlides(),super.listen({name:"initiated",cb:t}),this}setAttrs(){classes(this.targetEl).add(`${s.prefix}swipe,${s.prefix}initiating`),this.options.width&&(this.targetEl.style.width=isNaN(this.options.width)?this.options.width:this.options.width+"px"),this.options.height&&(this.targetEl.style.height=isNaN(this.options.height)?this.options.height:this.options.height+"px")}getDriftParams(){if(this.group)return{enable:!0,mode:"snap",value:1};let t={mode:"auto",coef:6};return"number"==typeof this.options.drift&&this.options.drift>0?t={mode:"snap",value:this.options.divide*this.options.drift}:"viewport"===this.options.drift&&this.options.slides>0&&(t={mode:"snap",value:this.options.slides*this.options.divide}),{enable:!0,...t}}getWheelVal(){return this.options.divide*(this.group?1:this.options.wheel)}getZoomEl(t){let e=getEl(this.options.zoom.selector,t.slider);return this.options.zoom.selector?e:t.slider.firstElementChild}setZoomVal(t,e=this.options.zoom.value){t.zoomEl&&(t.zoomEl.style.transitionDuration=`var(--${s.prefix}dur-3)`,t.zoomEl.style.transitionTimingFunction=`var(--${s.prefix}bez-eo)`,t.zoomIns.nowVals.translate={...t.rawTrans.translate},C.set({el:t.zoomEl,data:{scale:e,translate:t.zoomIns.nowVals.translate}}))}enableZoom(){this.options.zoom.enable&&this.scrollIns.gestureIns.on("dblclick",(t=>{let e=this.sliders.find((e=>e.slider.contains(t.evtTarget)));this.getZoomEl(e)&&(this.enable2Init(e),this.setZoomVal(e,this.options.zoom.value))}))}enable2Init(t,e){this.options.zoom.enable&&(t.zoomIns?t.zoomIns.destroyed&&t.zoomIns.init():(t.zoomEl=e||this.getZoomEl(t),this.setZoomIns(t)))}toggleZoom(t=this.snapSlider,e=!0){let s=C.get(t.zoomEl,["scale"]).scale.x,i=s<t.rawTrans.scale.x||s===this.options.zoom.value?t.rawTrans.scale.x:this.options.zoom.value;e&&this.setZoomVal(t,i),i===t.rawTrans.scale.x&&t.zoomIns.destroy()}setZoomIns(t){t.rawTrans=C.get(t.zoomEl,["translate","scale","rotate"]),t.zoomIns=new Gesture(t.zoomEl,{step:{mode:"scale",value:this.options.zoom.step},wheel:!0,scale:{enable:!0,min:this.options.zoom.min||t.rawTrans.scale.x,max:this.options.zoom.max},viewport:{enable:!0,selector:t.slider},onDblclick:e=>{this.toggleZoom(t)},onScaling:t=>{C.set({el:t.target,data:{scale:t.scale.value}})},onTranslating:t=>{C.set({el:t.target,data:{translate:t.translate.value}})}})}setScroll(){this.scrollOpt=extend({target:{wrapper:this.wrapEl,gridded:this.options.divide>1,flow:this.options.flow,keyboard:this.options.keyboard,snap:{enable:!0,selector:this.options.unalign},wheel:{mode:"snap",value:this.getWheelVal()},drift:this.getDriftParams(),initial:{value:this.getInitSlider()},duration:this.options.duration,resizeThr:this.options.slides>0?2:1,paddingStart:this.options.centered.enable?"center":0,paddingEnd:this.options.centered.enable?"center":0,child:{size:this.options.slides>0?`1 / ${this.options.slides}`:null,gap:this.options.gap},onGetSnappeds:function(){},onPrepared:this.prepareListen,onRefactored:this.resetListener,onResized:this.resetListener,onInitiated:()=>{this.enableZoom()},onSnap:t=>{if(this.actIdx=Math.max(this.sliders.findIndex((e=>e.slider===t)),0),this.scrollIns.initialResize&&this.setBulletActive(t),this.options.autoHeight&&"h"===this.options.flow&&(this.targetEl.style.height=style(t).height),this.thumbs.length){this.thumbIns&&!isChildVisible(this.thumbIns.targetEl,this.thumbIns.sliders[this.actIdx].slider)&&this.thumbIns.toSnap(this.actIdx);for(let[t,e]of this.thumbs.entries())e.toggleAttribute(this.options.thumb.attribute,this.actIdx===t)}for(let e of this.sliders)if(e.slider!==t){e.zoomIns&&(1!==C.get(e.zoomEl,["scale"]).scale.x&&this.setZoomVal(e,1),e.zoomIns.destroy());for(let t of getEls("video,audio",e.slider))t.pause()}this.snapSlider=this.sliders[this.actIdx],super.listen({name:"changed",params:[this.snapSlider,this.actIdx]})},onSnapped:t=>{},onMove:()=>{this.autoPause(!0)}},source:this.options.scroll}),this.group&&this.options.slides,this.options.slides,this.scrollIns=new Scroll(this.targetEl,this.scrollOpt)}async getSliders(t=this.options.content,e){let s=[];return await getSlidersData.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:this.options.ajax,hyphen:this.options.hyphen,parent:this.targetEl,wrap:this.wrapEl,lazy:this.options.lazy,tplStr:this.options.tplStr,tplEng:this.options.tplEng,cb:t=>{s=[...t]}}),e&&e(s),s}findSlider(t){let e,s=getDataType(t);return e="Number"===s?this.sliders[t]?.slider:"Object"===s?t?.slider:getEl(t,this.wrapEl),e}appendSliders(t=this.sliders,e="end"){let s,i=t.map((t=>t.slider));if("start"===e){i.reverse();for(let t of i)this.wrapEl.insertAdjacentElement("afterbegin",t)}else if("end"===e)this.wrapEl.append(...i);else if(s=this.findSlider(e),s){i.reverse();for(let t of i)s.insertAdjacentElement("afterend",t)}}createWrap(){let t=this.targetEl.firstElementChild;t?(t.classList.add(`${s.prefix}swipe-wrap`),this.wrapEl=t):(this.wrapEl=createEl("ul",{class:`${s.prefix}swipe-wrap ${s.prefix}reset`},""),this.targetEl.appendChild(this.wrapEl)),this.targetEl.querySelector(`.${s.prefix}swipe-nav`)?this.navEl=this.targetEl.querySelector(`.${s.prefix}swipe-nav`):this.options.integrated&&(this.navEl=createEl("div",{class:`${s.prefix}swipe-nav`},""),this.targetEl.appendChild(this.navEl))}fillWedgets(){this.getBullets(),this.fillNav(),this.fillPgn(),this.fillTotal()}updateWedgets(){this.getBullets(),this.updatePgn(),this.updateTotal()}setSlidesObs(){this.slidersObs=new Observe(this.slidersTmp,{onCompleted:()=>{this.updateGap(),this.updateWedgets(),this.scrollIns.setSnapped({force:!0})}}),this.sliders=this.slidersObs.proxy}setBulletsObs(){this.bulletsObs=new Observe(this.bulletsTmp,{deep:!0,onSet:t=>{"active"===t.key&&!0===t.value&&(t.proxy.el.setAttribute("active",""),this.bulletSeq=this.findPrevNextBullet(t.proxy),this.toBullet(t.proxy),this.toggleNavDisabled(t.proxy),this.numEl&&(this.numEl.innerHTML=this.bullets.findIndex((e=>e===t.proxy))+1))},onDeleted:t=>{"active"===t.key&&t.target.el.removeAttribute("active")},onCompleted:()=>{}}),this.bullets=this.bulletsObs.proxy}getThumbSlides(t=this.options.thumb.content){if(this.thumbs=[],"dom"===this.options.thumb.type){let t=getEl(this.options.thumb.content);t&&(this.thumbs=[...t.children])}else if("dom"===this.options.thumb.type){if(Array.isArray(this.options.thumb.content))this.thumbs=this.options.thumb.content;else{let t=getEls(this.options.thumb.content);this.thumbs=t}}else if(["step","pill"].includes(this.options.thumb.type)){let t=getEl(this.options.thumb.content);t&&(this.thumbs=t.content.map((t=>t.wrapEl)))}else if("swipe"===this.options.thumb.type){let e=getDataType(t),getInsFromDom=t=>{let e=h.data.find((e=>e.type=e.ins.targetEl===t));return e?e.ins:null};if(e.includes("HTML"))this.thumbs=getEls("li",t),this.thumbIns=getInsFromDom(t);else if("Instance"===e)this.thumbIns=t,this.thumbs=t.sliders.map((t=>t.slider));else if("String"===e){let e=getEl(t);e?(this.thumbIns=getInsFromDom(e),this.thumbs=getEls("li",t)):(this.thumbIns=h.find(t,"swipe"),this.thumbIns&&(this.thumbs=t.sliders.map((t=>t.slider))))}}if(this.thumbs=this.thumbs.filter((t=>t&&getDataType(t).includes("HTML"))),this.thumbs.length)if(this.thumbIns)this.thumbIns.on("prepared",(()=>{this.thumbIns.scrollIns.gestureIns.on("click",(t=>{let e=this.thumbs.find((e=>e.contains(t.evtTarget)));e&&this.setSnapEvt.call(e)}))}));else for(let t of this.thumbs)t.removeEventListener("click",this.setSnapEvt),t.addEventListener("click",this.setSnapEvt,!1)}findPrevNextBullet(t){let e=this.findBullet(t);if(!e)return{prev:null,next:null};let s=this.bullets.findIndex((t=>t===e)),i=this.bullets[s-1],a=this.bullets[s+1];return i||this.options.loop||this.options.autoplay.enable&&(i=this.bullets.at(-1)),a||this.options.loop||this.options.autoplay.enable&&(a=this.bullets[0]),{prev:i,next:a,current:e}}toggleNavDisabled(t){if(!this.options.loop&&this.options.nav.enable)if(this.bullets.length<2)this.prevEl.setAttribute("disabled",""),this.nextEl.setAttribute("disabled","");else{let e=this.findBullet(t);if(!e)return;e===this.bullets[0]?(this.prevEl.setAttribute("disabled",""),this.nextEl.removeAttribute("disabled")):e===this.bullets.at(-1)?(this.nextEl.setAttribute("disabled",""),this.prevEl.removeAttribute("disabled")):(this.prevEl.removeAttribute("disabled"),this.nextEl.removeAttribute("disabled"))}}setSlideSize(){this.options.slides>0&&this.sliders.forEach((t=>{this.setSingleSize(t)})),this.updateGap()}updateGap(){this.options.divide>1?this.sliders.forEach(((t,e)=>{this.setSingleGap(t,e)})):this.options.gap>0&&this.sliders.forEach((t=>{this.setSingleGap(t)}))}getIdxFromActive(t){let e=this.getActiveIdex(t);return clampVal({val:e,min:0,max:this.sliders.length-1})}getActiveIdex(t){let e=-1;if("number"==typeof t)e=t;else{let s=getEl(t,this.targetEl);s&&(e=this.sliders.findeIndex((t=>t.slider===s)))}return e>=this.sliders.length&&(e=-1),e}getInitSlider(){return 0===this.sliders.length||-1===this.actIdx?null:(this.options.centered.enable&&this.options.centered.fill&&this.options.slides>1&&this.actIdx<~~(this.options.slides/2)&&(this.actIdx=~~(this.options.slides/2)),this.sliders[this.actIdx].slider)}getAccuracy(t,e=!0){return(t.toString().split(".")[1]?t.toString().split(".")[1].length:0)>3?toNumber(t+(e?.1:0),{mode:e?"ceil":"floor",places:1}):t}getSingleSize(){if(this.options.slides>0&&(this.slideSize=this.getAccuracy(this.scrollIns.childAvgSize,!(this.scrollIns.gap>0))),this.options.divide>1){let t=(this.scrollIns.reverseSize-this.scrollIns.gap*(this.options.divide-1))/this.options.divide;this.slideSizeDivide=this.getAccuracy(t,!(this.scrollIns.gap>0))}}setSingleSize(t){this.options.slides>0&&(t.slider.style[this.scrollIns.forwardMap.size]=this.slideSize+"px")}setSingleGap(t,e){let s=isNull(e)?this.sliders.findIndex((e=>e===t)):e;this.options.divide>1?(t.slider.style[this.scrollIns.reverseMap.size]=this.getAccuracy(this.slideSizeDivide,!1)+"px",s%this.options.divide!=0&&this.scrollIns.gap&&(t.slider.style[this.scrollIns.reverseMap.gap]=this.scrollIns.gap+"px"),s>=this.options.divide&&(t.slider.style[this.scrollIns.forwardMap.gap]=this.scrollIns.gap+"px")):0!==s&&(t.slider.style[this.scrollIns.forwardMap.gap]=this.scrollIns.gap+"px")}getBullets(){this.bullets.length=0;let t=[],e=this.sliders.length;if(this.options.slides>0)this.sliders.forEach(((s,i)=>{let a={target:s,el:createEl("li"),index:i};if(this.options.centered.enable)this.bullets.push(a);else{if(this.options.loop)this.group&&this.options.slides>1?i%(this.options.slides*this.options.divide)==0?this.bullets.push(a):s.slider.setAttribute(this.options.unalign,""):this.bullets.push(a);else{let l=this.options.divide*(this.group||this.options.slides);i%l==0&&this.sliders.length-i>=l||i===e-l?this.bullets.push(a):this.group&&(t.push(s.slider),setSingleSel(s.slider,this.options.unalign))}this.updateUnsnappeds(t)}}));else if(this.scrollIns.isBaby)this.bullets.push({target:this.sliders[0],el:createEl("li"),index:0});else{let t=this.getSplits(),e=this.getSanpOffsetArr();for(let s of e)for(let e of t)s.offsetStart<=e&&s.offsetEnd>e&&this.bullets.push({target:s.target,el:createEl("li"),index:s.index})}}updateUnsnappeds(t){this.scrollIns.unsnappeds=unique([...this.scrollIns.unsnappeds,...t]),this.scrollIns.snappeds=[...this.wrapEl.children].filter((t=>!this.scrollIns.unsnappeds.includes(t)))}getSplits(){let t=((t,e)=>{let s=[];for(let i=0;i<t;i++)s.push(i*e);return s})(Math.floor(this.scrollIns.wrapSize/this.scrollIns.baseSize),this.scrollIns.baseSize);return t.push(this.scrollIns.wrapSize-this.scrollIns.baseSize),t}getSanpOffsetArr(){let t=[];return this.sliders.forEach(((e,s)=>{if(this.scrollIns.snappeds.includes(e.slider)){let i=this.scrollIns.snappeds.findIndex((t=>t===e.slider)),a=this.scrollIns.snappeds[i+1],l=e.slider[this.scrollIns.forwardMap.offset],n=a?this.scrollIns.snappeds[i+1][this.scrollIns.forwardMap.offset]:l+e.slider[this.scrollIns.forwardMap.outer];t.push({offsetStart:l,offsetEnd:n,target:e,index:s})}})),t}updateTotal(t=this.getTotal()){if(!this.options.total.enable)return!1;t.bullets?(this.numEl.innerHTML=t.curBullet+1,this.denEl.innerHTML=t.bullets):this.numEl.innerHTML=this.denEl.innerHTML=0}fillTotal(){if(!this.options.total.enable)return!1;let t=this.getTotal();this.totalEl=createEl("span",{class:`${s.prefix}swipe-total`},this.options.total.format),this.numEl=this.totalEl.querySelector("i"),this.denEl=this.totalEl.querySelector("u"),this.updateTotal(t),this.options.total.placement&&this.totalEl.setAttribute("placement",this.options.total.placement),(getEl(this.options.total.selector)||this.targetEl).appendChild(this.totalEl)}getTotal(){return{curSlider:this.actIdx,sliders:this.sliders.length,curBullet:this.bullets.findIndex((t=>t.active)),bullets:this.bullets.length}}fillNav(){if(!this.options.nav.enable)return!1;let addNav=t=>{let e=null,i="prev"===t?"h"===this.options.flow?`${s.prefix}icon-left`:`${s.prefix}icon-up`:"next"===t?"h"===this.options.flow?`${s.prefix}icon-right`:`${s.prefix}icon-down`:"",a=`${s.prefix}swipe-${t}`,l=getEl(`.${a}`,this.targetEl);return l?(e=l,e.classList.add(`${i}`)):this.options.nav[t].selector?(e=getEl(this.options.nav[t].selector),e&&e.classList.contains(`${s.prefix}swipe-${t}`)&&e.classList.add(`${i}`)):(e=createEl("i",{class:`${a} ${i}`}),this.navEl?this.navEl.appendChild(e):this.targetEl.appendChild(e)),e&&(this.options.nav[t].classes&&classes(e).add(this.options.nav[t].classes),this.options.nav.classes&&classes(e).add(this.options.nav.classes),this.options.nav.fill&&e.setAttribute("filled","")),e};this.options.nav.enable&&(this.prevEl=addNav("prev"),this.nextEl=addNav("next"),this.prevEl&&(this.prevEl.onclick=throttle((()=>{this.toPrevBullet()}),{intvl:this.options.nav.intvl,prevent:!0})),this.nextEl&&(this.nextEl.onclick=throttle((()=>{this.toNextBullet()}),{intvl:this.options.nav.intvl,prevent:!0})))}fillPgn(){if(!this.options.pgn.enable)return!1;this.pgnIns=null;let t=`${s.prefix}swipe-pgn`,e=[...this.targetEl.children].find((e=>e.classList.contains(t)));if(e)this.pgnEl=e;else if(this.options.pgn.selector){let t=getDataType(this.options.pgn.selector);t.includes("HTML")?this.pgnEl=this.options.pgn.selector:"String"===t?getSelectorType(this.options.pgn.selector)?this.pgnEl=getEl(this.options.pgn.selector):(this.pgnIns=h.find(this.options.pgn.selector,"swipe"),this.pgnIns&&(this.pgnEl=this.pgnIns.wrapEl)):"Object"===t&&(this.pgnIns=this.options.pgn.selector,this.pgnEl=this.pgnIns.wrapEl)}else this.pgnEl=createEl("ul",{class:`${t} ${s.prefix}reset`},""),this.navEl&&this.prevEl?this.prevEl.insertAdjacentElement("afterend",this.pgnEl):this.targetEl.appendChild(this.pgnEl);this.pgnEl&&(this.options.pgn.type&&this.pgnEl.setAttribute("type",this.options.pgn.type),this.options.pgn.classes&&classes(this.pgnEl).add(this.options.pgn.classes),this.pgnEl.children.length?(this.bullets.forEach(((t,e)=>{this.pgnEl.children[e]&&(t.el=this.pgnEl.children[e],e===this.actIdx&&this.setBulletActive(t))})),this.setBulletAction()):this.updatePgn())}setBulletAction(){this.bullets.forEach((t=>{t.el.onclick=()=>{this.setBulletActive(t),this.scrollIns.scrollTo({target:t.target.slider,snap:!0})}}))}updatePgn(){if(!this.options.pgn.enable)return;this.pgnEl.innerHTML="";let t=this.bullets.length,e=document.createDocumentFragment();this.bullets.forEach(((s,i)=>{let a;switch(i===this.actIdx&&this.setBulletActive(s),this.options.pgn.type){case"text":a=s.target.source.label||this.options.pgn.data[i];break;case"thumb":a=`<img src="${s.target.source.thumb||this.options.pgn.data[i]}"/>`;break;case"index":a=i+1;break;default:a=""}this.options.pgn.before?this.options.pgn.before.call(this,{index:i,total:t,html:a,bullet:s,parent:this.pgnEl}):s.el.innerHTML=a,e.appendChild(s.el)})),this.pgnEl.appendChild(e),this.options.pgn.after&&this.options.pgn.after.call(this,{total:t,parent:this.pgnEl}),this.setBulletAction()}findNavSnap(t="next"){let e=this.scrollIns.snappeds.findIndex((t=>t===this.scrollIns.snapped)),s=null;return e<0||("next"===t?this.options.loop&&e===this.scrollIns.snappeds.length-1?s=this.scrollIns.snappeds[0]:e!==this.scrollIns.snappeds.length-1&&(s=this.scrollIns.snappeds[e+1]):"prev"===t?this.options.loop&&0===e?s=this.scrollIns.snappeds.at(-1):0!==e&&(s=this.scrollIns.snappeds[e-1]):"start"===t?s=this.scrollIns.snappeds[0]:"end"===t&&(s=this.scrollIns.snappeds.at(-1))),s}findSnap(t){let e,s=getDataType(t);if("Number"===s){let s=this.sliders[t];e=s&&this.scrollIns.snappeds.includes(s.slider)?s.slider:null}else if(s.includes("HTML")||"String"===s){let s=getEl(t,this.wrapEl);e=s&&this.scrollIns.snappeds.includes(s)?s:null}else"Object"===s&&t.hasOwnProperty("slider")&&(e=this.scrollIns.snappeds.includes(t.slider)?t.slider:null);return e}findBullet(t){let e,s=getDataType(t);return"Number"===s?e=this.bullets[t]:s.includes("HTML")||"String"===s?e=this.bullets.find((e=>e.target.slider===getEl(t,this.wrapEl))):"Object"===s&&t.hasOwnProperty("el")&&(e=t),e}toBullet(t,e={}){if(this.destroyed)return;let s=this.findBullet(t);s&&this.bulletSeq.current!==s&&this.scrollIns.scrollTo({target:s.target.slider,snap:!0,before:()=>{this.setBulletActive(s),e.before&&e.before.call(this,s)},after:()=>{e.after&&e.after.call(this,s)}})}toPrevBullet(t){this.destroyed||this.bulletSeq.prev&&this.toBullet(this.bulletSeq.prev,{after:()=>{t&&t.call(this,this.bulletSeq.prev)}})}toNextBullet(t){this.destroyed||this.bulletSeq.next&&this.toBullet(this.bulletSeq.next,{after:()=>{t&&t.call(this,this.bulletSeq.next)}})}toSnap(t,e={}){if(this.destroyed)return;let s=this.findSnap(t);s&&this.scrollIns.snapped!==s&&this.scrollIns.scrollTo({target:s,snap:!0,before:()=>{e.before&&e.before.call(this,s)},after:()=>{e.after&&e.after.call(this,s)}})}toLocate(t,e={}){if(this.destroyed)return;let s=this.findSnap(t);s&&this.scrollIns.snapped!==s&&this.scrollIns.locateTo({target:s,snap:!0,before:()=>{e.before&&e.before.call(this,s)},after:()=>{e.after&&e.after.call(this,s)}})}toPrevSnap(t){if(this.destroyed)return;let e=this.findNavSnap("prev");e&&this.scrollIns.scrollTo({target:e,snap:!0,after:()=>{t&&t.call(this,e)}})}toNextSnap(t){if(this.destroyed)return;if(this.destroyed)return;let e=this.findNavSnap("next");e&&this.scrollIns.scrollTo({target:e,snap:!0,after:()=>{t&&t.call(this,e)}})}toStart(t){if(this.destroyed)return;let e=this.bullets[0];e.active||this.toBullet(e,{after:e=>{t&&t.call(this,e)}})}toEnd(t){if(this.destroyed)return;let e=this.bullets.at(-1);e.active||this.toBullet(e,{after:e=>{t&&t.call(this,e)}})}setLoopPlay(){if(!1===this.options.loop)return!1;"auto"===this.options.slides?(this.startClone=this.slides.map((t=>t.dom.cloneNode(!0))),this.endClone=this.slides.map((t=>t.dom.cloneNode(!0))),this.totalClone=this.slides.length):(this.startClone=this.slides.slice(0,this.options.slides).map((t=>t.dom.cloneNode(!0))),this.endClone=this.slides.slice(this.slides.length-this.options.slides).map((t=>t.dom.cloneNode(!0))),this.totalClone=this.options.slides),this.scrollIns.add(this.endClone,{placement:"start"}),this.scrollIns.add(this.startClone,{placement:"end"})}startCountdown(){this.countdownIns&&(this.countdownIns.setCompleted(),this.countdownIns.animateTo(0,{duration:this.options.autoplay.delay}))}setAutoPlay(){this.options.autoplay.enable&&(this.options.autoplay.countdown&&(this.countdownIns?this.countdownIns.init():this.countdownIns=new Progress(this.countdownEl,extend({target:{label:!1,type:"circle",curve:"linear",width:"xxs",control:!0,duration:this.options.autoplay.delay,onPause:()=>{this.autoPause()},onContinue:t=>{this.continue(t.durRest)}},source:this.options.countdown})),this.targetEl.appendChild(this.countdownEl)),this.autoPlay())}continue(t){delay({duration:t,done:()=>{this.toNextBullet((()=>{this.autoPlay()}))}})}play(t,e){if(!this.destroyed&&this.paused)return this.interval&&clearInterval(this.interval),this.interval=setInterval(this.intervalEvt,t||this.options.autoplay.delay),this.paused=!1,super.listen({name:"played",cb:e}),this}pause(t){if(!this.destroyed&&!this.paused)return clearInterval(this.interval),this.paused=!0,super.listen({name:"paused",cb:t}),this}autoPlay(t,e){if(!this.destroyed&&this.paused&&this.options.autoplay.enable)return this.play(t,e),this.startCountdown(),this}autoPause(t=!1,e){if(!this.destroyed&&!this.paused&&this.options.autoplay.enable)return this.pause(e),t&&this.countdownIns&&(this.countdownEl.remove(),this.countdownIns.destroy()),this}async add(t,e){if(this.destroyed||isEmpty(t))return;let s,i=Object.assign({placement:"end"},e);return await this.getSliders(t,(t=>{s=t,this.sliders.push(...s)})),this.appendSliders(s,i.placement),super.listen({name:"add",cb:i.cb,params:[s]}),{ins:this,data:s}}remove(t="end",e){if(this.destroyed||isEmpty(t))return;let s;return s="start"===t?this.sliders[0]?.slider:"end"===t?this.sliders.at(-1)?.slider:this.findSlider(t),s?(s.remove(),super.listen({name:"remove",cb:e,params:[this.sliders.find((t=>t.slider===s))]}),this):void 0}destroy(t){if(this.destroyed)return this;for(let t of this.sliders)t.spy&&t.spy.destroy();this.scrollIns.destroy(),this.spyIns&&this.spyIns.destroy(),this.countdownIns&&this.countdownIns.destroy(),window.removeEventListener("keydown",this.keyToSwipe),this.bullets.forEach((t=>{t.el.onclick=null})),this.prevEl&&(this.prevEl.onclick=null),this.nextEl&&(this.nextEl.onclick=null),this.toolsEl&&this.options.tools.children.forEach((t=>{t.el.onclick=null}));for(let t of this.thumbs)t.removeEventListener("click",this.setSnapEvt);return this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}updateCont(t,e){return this.destroyed||(this.options.content=t,this.init(),super.updateCache({content:this.content}),super.listen({name:"updatedCont",cb:e,params:[this.content]})),this}}const rt=[{attr:"root",prop:"root",value:null},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"hyphen",prop:"hyphen",value:l.splitHyphen},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"type",prop:"type",value:"src"},{attr:"trigger",prop:"trigger",value:"ing"},{attr:"spy",prop:"spy",value:{}},{attr:"on-showing",prop:"onShowing",value:null},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},...p];class Lazy extends ModBaseListenCache{nodeName;resType;spyIns;removeAttrFn;options={};static hostType="node";static optMaps=rt;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Lazy.optMaps,host:t}),this.nodeName=this.targetEl.nodeName,this.removeAttrFn=()=>{this.targetEl.removeAttribute("lazy-src"),super.listen({name:"shown",params:[this.targetEl]})},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.resType=this.options.type||(this.targetEl.hasAttribute("src")?"src":"async"),"src"===this.resType&&(this.targetEl.src=s.images.blank,!this.targetEl.hasAttribute("lazy-src")&&this.targetEl.setAttribute("lazy-src","")),this.spyIns=new Spy(this.targetEl,extend({target:{root:this.options.root,repeat:!1},source:this.options.spy})),this.spyIns.on("ed"===this.options.trigger?"shown":"in",(async()=>{super.listen({name:"showing",params:[this.targetEl]}),"src"===this.resType?(this.targetEl.src=this.options.content,["VIDEO","AUDIO"].includes(this.nodeName)?this.targetEl.onloadeddata=this.removeAttrFn:["IMG","IFRAME"].includes(this.nodeName)?this.targetEl.onload=this.removeAttrFn:this.removeAttrFn()):"async"===this.resType&&await getContent.call(this,{content:this.options.content,contType:this.options.contType||"async",contData:this.options.contData,ajax:Object.assign({target:this.targetEl},this.options.ajax),hyphen:this.options.hyphen,cb:t=>{setContent({target:this.targetEl,content:t,template:this.options.tplStr,engine:this.options.tplEng}),this.targetEl.removeAttribute("lazy-async"),this.targetEl.removeAttribute("lazy-type"),this.targetEl.removeAttribute("lazy-data"),this.targetEl.removeAttribute("lazy-tpl"),super.listen({name:"shown",params:[this.targetEl]})}}),super.listen({name:"trigger",params:[this.targetEl]})})),super.listen({name:"initiated",cb:t}),this}destroy(t){return this.destroyed||(this.spyIns.destroy(),super.listen({name:"destroyed",cb:t})),this}}const ot=[{attr:"trigger",prop:"trigger",value:"scroll"},{attr:"spy",prop:"spy",value:{enable:!0}},{attr:"classes",prop:"classes",value:""},{attr:"spin",prop:"spin",value:"<ax-spin></ax-spin>"},{attr:"max",prop:"max",value:20},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"media",prop:"media",value:{title:"",brief:""}},{attr:"b4-append",prop:"b4Append",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"on-append",prop:"onAppend",value:null},{attr:"on-finish",prop:"onFinish",value:null},{attr:"on-error",prop:"onError",value:null},...p];class Infinite extends ModBaseListenCache{options={};content;index;contReq;contXhr;statusEl;spinEl;nextEl;nextBtn;tipsEl;listSpyIns;statusSpyIns;static hostType="node";static optMaps=ot;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Infinite.optMaps,host:t,component:!1,spread:["spy"]}),this.content=[],this.index=0,this.contReq={contType:this.options.contType,contData:this.options.contData,ajax:{error:t=>{this.finish(!0),super.listen({name:"error",params:[t]})},xhrName:"contXhr",...this.options.ajax}},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setAttrs(),this.useTpl(),this.getStatusEl(),this.targetEl.appendChild(this.statusEl),await this.getInitContent(),this.options.spy.enable&&this.getListSpyIns(),"scroll"===this.options.trigger?this.getStatusSpyIns():"click"===this.options.trigger?this.nextBtn.onclick=()=>{this.getStatusSpyIns()}:"clicks"===this.options.trigger&&(this.nextBtn.onclick=()=>{this.renderList(this.index)}),super.listen({name:"initiated",cb:t}),this}setAttrs(){this.targetEl.classList.add(`${s.prefix}infinite`),classes(this.targetEl).add(this.options.classes),this.targetEl.setAttribute("trigger",this.options.trigger)}finish(t=!1){this.statusEl.setAttribute("status","finish"),this.tipsEl.innerHTML=t?this.options.lang.error:this.options.lang.finish,this.statusSpyIns&&this.statusSpyIns.destroy(),super.listen({name:"finish"})}getListSpyIns(){this.listSpyIns=new Spy(null,extend({target:{repeat:!1,visible:!1,in:`${s.prefix}fadeIn`},source:this.options.spy}))}getStatusSpyIns(){this.statusSpyIns=new Spy(this.statusEl,{root:this.targetEl,onIn:debounce((()=>{this.renderList(this.index)}))})}async renderList(t){this.destroyed||t>=this.content.length||(this.statusEl.setAttribute("status","loading"),this.tipsEl.innerHTML=this.options.lang.loading,await this.getPageData(this.content[t],(async t=>{this.options.b4Append&&await this.options.b4Append.call(this,t),this.statusEl.setAttribute("status","loaded"),this.tipsEl.innerHTML=this.options.lang.loaded;let e=document.createDocumentFragment();for(let i of t)i.classList.add(`${s.prefix}infinite-item`),e.appendChild(i);this.targetEl.insertBefore(e,this.statusEl),this.listSpyIns&&this.listSpyIns.add(t),super.listen({name:"append",params:[t]}),this.index++,this.index>=this.content.length&&this.finish()})))}getStatusEl(){this.statusEl=this.targetEl.querySelector(`.${s.prefix}infinite-status`)||createEl("div",{class:`${s.prefix}infinite-status`,status:"preload"}),this.spinEl=createEl("div",{[s.alias]:"spin"},this.options.spin),this.statusEl.appendChild(this.spinEl);let t=this.targetEl.querySelector(`[${s.alias}="next"]`);t?this.nextEl=t:(this.nextEl=createEl("div",{[s.alias]:"next"},this.options.lang.next),["click","clicks"].includes(this.options.trigger)&&this.statusEl.appendChild(this.nextEl)),this.nextBtn=this.nextEl.firstElementChild;let e=this.targetEl.querySelector(`[${s.alias}="tips"]`);e?this.tipsEl=e:(this.tipsEl=createEl("div",{[s.alias]:"tips"},this.options.lang.preload),this.statusEl.appendChild(this.tipsEl))}async getInitContent(){let t=[];if(this.options.content){let e=getDataType(this.options.content);if("String"===e)t=parseUrlArr(this.options.content,{max:this.options.max});else if("Array"===e&&this.options.content.length){let e=getDataType(this.options.content[0]);if("Object"===e)for(let e of this.options.content){let s=extend({target:deepClone(this.contReq),source:e});t.push(await getContent.call(this,s))}else if("Array"===e)for(let e of this.options.content){if(!e.length)continue;let s=getDataType(e[0]);if(s.includes("HTML"))t=[...this.options.content];else if("Object"===s){let s=e.map((t=>tplToEl(super.getTplcont(t))));t.push(s)}}else t=this.options.content}}else{t=getEls(`[${s.alias}="page"]`,this.statusEl).map((t=>t.href)).filter(Boolean)}this.content=t.filter((t=>!isEmpty(t)))}async getPageData(t,e){if(this.destroyed)return;let s=getDataType(t),i=[],a=deepClone(this.contReq);if("String"===s&&(i="text"===this.options.contType?tplToEls(t):await getContent.call(this,{content:t,...a})),s.includes("HTML"))i=[...t.children];else if("Object"===s){let e,s=extend({target:a,source:t});e=await getContent.call(this,s),isEmpty(e)&&("string"==typeof e?i=tplToEls(t):Array.isArray(e)&&getDataType(e[0].include("HTML"))&&(i=e))}else"Array"===s&&(i=this.arr2Nodes(t));let l=getDataType(i);return"String"===l?i=tplToEls(i):"Array"===l&&(i=this.arr2Nodes(i)),i=i.filter(Boolean),e&&e(i),i}arr2Nodes(t){let e=[];if(!t.length)return e;let s=getDataType(t[0]);return s.includes("HTML")?e=t:"Object"===s&&(e=t.map((t=>tplToEl(super.getTplcont(t))))),e}destroy(t){return this.destroyed||(this.nextBtn&&(this.nextBtn.onclick=null),this.listSpyIns&&this.listSpyIns.destroy(),this.statusSpyIns&&this.statusSpyIns.destroy(),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const ht=[{attr:"axis",prop:"axis",value:"y"},{attr:"classes",prop:"classes",value:""},{attr:"size",prop:"size",value:0},{attr:"spill",prop:"spill",value:2},{attr:"names",prop:"names",value:{wrap:"div",list:"div",cont:"div",item:"section"}},{attr:"index",prop:"index",value:0},{attr:"dynamic",prop:"dynamic",value:!0},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"b4-append",prop:"b4Append",value:null},{attr:"b4-updateitem",prop:"b4UpdateItem",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"on-append",prop:"onAppend",value:null},{attr:"on-getcont",prop:"onGetCont",value:null},{attr:"on-exhausted",prop:"onExhausted",value:null},{attr:"on-tostart",prop:"onToStart",value:null},{attr:"on-toend",prop:"onToEnd",value:null},{attr:"on-updateItem",prop:"onUpdatedItem",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-error",prop:"onError",value:null},...p];class Virtualize extends ModBaseListenCache{options={};propsMap;contReq;autoRenderEvt;obsRenderEvt;avgSize;targetSize;wrapEl;contEl;listEl;startSpaceEl;endSpaceEl;sizesObs;itemSizes;startSpyIns;endSpyIns;itemObs;targetObs;listSize;paddingStart;startIdx;endIdx;offsetVal;scrollVal;nodes;paddingEnd;wrapSize;contXhr;content;static hostType="node";static optMaps=ht;constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Virtualize.optMaps,host:t,component:!1,spread:[]}),this.propsMap=o[this.options.axis],this.contReq={content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{spinSel:this.targetEl,error:t=>{super.listen({name:"error",params:[t]})},xhrName:"contXhr",...this.options.ajax}},this.autoRenderEvt=()=>{this.renderFromStart()},this.obsRenderEvt=debounce((()=>{this.initialized&&this.renderFromStart()})),this.avgSize=Math.max(parseInt(style(document.body).lineHeight),toPixel(this.options.size)),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setAttrs(),this.getDirRtl(),this.targetSize=this.targetEl[this.propsMap.inner],this.useTpl(),this.getNodesTree(),await this.getInitData(),this.setSizesObs(),this.setSpy(),this.targetEl.addEventListener("scroll",this.autoRenderEvt,!1),this.itemObs=new MutationObserver(this.obsRenderEvt),this.targetObs=new ResizeObserver(this.obsRenderEvt),this.targetObs.observe(this.targetEl),this.renderFromStart(this.options.index),super.listen({name:"initiated",cb:t}),this}setAttrs(){this.targetEl.classList.add(`${s.prefix}virt`),this.targetEl.setAttribute("axis",this.options.axis),classes(this.targetEl).add(this.options.classes)}getAvgArr(t){return Array(t).fill(null).map((()=>({size:this.avgSize,rendered:!1})))}setSizesObs(){this.sizesObs=new Observe(this.getAvgArr(this.content.length),{deep:!0,onCompleted:()=>{this.itemSizes.findIndex((t=>!t.rendered))<0&&super.listen({name:"exhausted",params:[this.content]})}}),this.itemSizes=this.sizesObs.proxy}setSpy(){this.startSpyIns=new Spy(this.startSpaceEl,{onIn:()=>{super.listen({name:"toStart"})}}),this.endSpyIns=new Spy(this.endSpaceEl,{onIn:()=>{super.listen({name:"toEnd"})}})}setNodeMutation(t){this.itemObs.observe(t,{childList:!0,subtree:!0,attributes:!0})}getNodesTree(){let t=this.targetEl.querySelector(`.${s.prefix}virt-wrap`);t?this.wrapEl=t:(this.wrapEl=createEl(this.options.names.wrap,{class:`${s.prefix}virt-wrap`}),this.targetEl.appendChild(this.wrapEl)),this.wrapEl.querySelector(`.${s.prefix}virt-cont`)?this.contEl=t:(this.contEl=createEl(this.options.names.cont,{class:`${s.prefix}virt-cont`}),this.wrapEl.appendChild(this.contEl));let e=this.contEl.querySelector(`.${s.prefix}virt-list`);e?this.wrapEl=e:(this.listEl=createEl(this.options.names.list,{class:`${s.prefix}virt-list`}),this.contEl.appendChild(this.listEl)),this.startSpaceEl=createEl("div",{class:`${s.prefix}virt-space`},`${this.options.lang.preload}`),this.endSpaceEl=createEl("div",{class:`${s.prefix}virt-space`},`${this.options.lang.preload}`),this.contEl.insertAdjacentElement("afterbegin",this.startSpaceEl),this.contEl.appendChild(this.endSpaceEl)}getWrapSize(){return this.options.dynamic?this.itemSizes.reduce(((t,e)=>t+e.size),0):this.avgSize*this.itemSizes.length}get2SetWrapSize(){this.wrapSize=this.getWrapSize(),this.wrapEl.style[this.propsMap.size]=this.wrapSize+"px"}async getInitData(){let t=await this.getData();this.content=t.content}async getData(t,e){let s=await getContent.call(this,t?Object.assign(this.contReq,t):this.contReq),i=getDataType(s),a={content:[],source:s};return this.respSource=s,"Array"===i?a.content=s:"Object"===i&&s.hasOwnProperty("data")?a.content=Array.isArray(s.data)?s.data:s?.data?.list||[]:"String"===i&&(a.content=tplToEls(s)),super.listen({name:"getCont",cb:e,params:[a]}),a}getItemNode(t){let e,s=getDataType(t);return s.includes("HTML")?e=t:(e=createEl(this.options.names.item,{}),e.innerHTML="Object"===s?super.getTplcont(t):t.toString()),this.setNodeMutation(e),e}getDirScrollVal(){if("x"!==this.options.axis)return this.targetEl[this.propsMap.scroll];{let t=this.targetEl[this.propsMap.scroll];return this.targetEl.getAttribute("dir"),t*super.getRtlCoef()}}setDirScrollVal(t=0){"x"!==this.options.axis?this.targetEl[this.propsMap.scroll]=t:this.targetEl[this.propsMap.scroll]=t*super.getRtlCoef()}renderFromStart(t){if(this.destroyed)return;if(this.listEl.innerHTML="",this.listSize=0,this.paddingStart=0,this.startIdx=0,this.endIdx=this.itemSizes.length-1,this.offsetVal=0,this.scrollVal=this.getDirScrollVal(),this.nodes=[],t)this.startIdx=t-1;else if(this.scrollVal)for(let t=0;t<this.itemSizes.length;t++){if(this.paddingStart+=this.itemSizes[t].size,this.paddingStart>this.scrollVal){this.startIdx=t;break}if(t===this.itemSizes.length-1&&this.paddingStart<=this.scrollVal)return}this.paddingEnd=0;for(let t=this.startIdx;t<this.itemSizes.length;t++)if(this.paddingEnd+=this.itemSizes[t].size,this.paddingEnd>this.targetSize){this.endIdx=t;break}this.compensate();for(let t=this.startIdx;t<=this.endIdx;t++)this.appendUpdateSize(t,"beforeend",(t=>{this.listSize+=t}));let e={};this.fillBlank(this.listSize,(t=>{e=t})),this.get2SetWrapSize(),t?this.updateScrollVal(t+(e?.indexDiff||0)):e?.padding&&(this.paddingStart-=e.padding),this.get2SetContOffset(),super.listen({name:"rendered",params:[{startIdx:this.startIdx,endIdx:this.endIdx,nodes:this.nodes,scrollVal:this.scrollVal,offsetVal:this.offsetVal,wrapSize:this.wrapSize,listSize:this.listSize}]})}fillBlank(t=this.listSize,e){let s={startIdx:0,indexDiff:0,padding:0};if(t<this.targetSize){for(let e=1;e<this.content.length;e++){let i=this.startIdx-e;if(i<0)break;if(this.appendUpdateSize(i,"afterbegin",(e=>{t+=e,s.padding+=e})),t>=this.targetSize){s.startIdx=i,s.indexDiff=i-this.startIdx,this.startIdx=i,this.listSize=t;break}}e&&e(s)}}appendUpdateSize(t,e="afterbegin",s){if(t<0||t>=this.content.length)return;let i=this.getItemNode(this.content[t]);this.nodes.push({el:i,index:t}),this.listEl.insertAdjacentElement(e,i),this.options.dynamic&&(this.itemSizes[t].size=getElSpace(i,this.options.axis)),this.itemSizes[t].rendered=!0,s&&s(this.itemSizes[t].size)}updateSizeOnly(t){let e=this.getItemNode(this.content[t]);this.listEl.insertAdjacentElement("beforeend",e),this.options.dynamic&&(this.itemSizes[t].size=getElSpace(e,this.options.axis))}renderFromEnd(){this.listSize=0,this.listEl.innerHTML="",this.nodes=[],this.endIdx=this.content.length-1;for(let t=this.endIdx;t>=0;t--)if(this.appendUpdateSize(t,"afterbegin",(t=>{this.listSize+=t})),this.listSize>this.targetSize){for(let e=1;e<=this.options.spill;e++)this.appendUpdateSize(t-e,"afterbegin",(t=>{this.listSize+=t}));this.startIdx=t-this.options.spill;break}this.get2SetWrapSize(),this.offsetVal=this.wrapSize-this.listSize,this.setContOffset(),this.setScrollVal(this.wrapSize),super.listen({name:"rendered",params:[{startIdx:this.startIdx,endIdx:this.endIdx,nodes:this.nodes,scrollVal:this.scrollVal,offsetVal:this.offsetVal,wrapSize:this.wrapSize}]})}getPadStartFromIdx(t){if(this.options.dynamic){let e=0;for(let s=0;s<t;s++)e+=this.itemSizes[s].size;return e}return this.avgSize*t}setScrollVal(t=this.paddingStart){this.targetEl.removeEventListener("scroll",this.autoRenderEvt),this.setDirScrollVal(t),this.scrollVal=t,setTimeout((()=>{this.targetEl.addEventListener("scroll",this.autoRenderEvt,!1)}),0)}updateScrollVal(t){this.paddingStart=this.getPadStartFromIdx(t),this.setScrollVal()}compensate(){this.endIdx=clampVal({val:this.endIdx+this.options.spill,min:0,max:this.itemSizes.length-1}),this.startIdx=clampVal({val:this.startIdx-this.options.spill,min:0,max:this.itemSizes.length-1})}get2SetContOffset(){if(this.startIdx)if(this.offsetVal=this.paddingStart,this.options.dynamic)for(let t=0;t<=this.options.spill;t++)this.offsetVal-=this.itemSizes[this.startIdx+t].size;else this.offsetVal-=this.avgSize*(this.options.spill+1);else this.offsetVal=0;this.setContOffset()}getContOffset(t){return this.isRtl&&"x"===this.options.axis?{x:Math.min(0,-1*t)}:{[this.options.axis]:Math.max(0,t)}}setContOffset(t=this.offsetVal){C.set({el:this.contEl,data:{translate:this.getContOffset(t)}})}scrollTo(t=0,e){t?this.renderFromStart(t):this.setDirScrollVal(),e&&e.call(this,t)}toStart(){this.scrollTo()}toEnd(){this.renderFromEnd()}async append(t,e){if(this.destroyed)return;let s=await this.getData(t);if(s.content.length){if(this.options.b4Append){let t=await this.options.b4Append.call(this,s.content);t&&(s.content=t)}this.content.push(...s.content),this.itemSizes.push(...this.getAvgArr(s.content.length)),this.renderFromStart(),super.listen({name:"append",cb:e,params:[s]})}return this}async updateItem(t={index:0,override:!0}){if(this.destroyed)return;let e=this.content[t.index],s=getDataType(e),i=getDataType(t.content);if(s.includes("HTML")?(t.override&&(e.innerHTML=""),i.includes("HTML")?e.appendChild(t.content):e.insertAdjacentHTML("beforeend",t.content.toString())):["String","Number"].includes(s)&&["String","Number"].includes(i)?(t.override&&(this.content[t.index]=""),this.content[t.index]+=t.content+""):"Object"===s&&"Object"===i&&(t.override&&(this.content[t.index]={}),Object.assign(this.content[t.index],t.content)),this.options.b4UpdateItem){let e=await this.options.b4UpdateItem.call(this,this.content[t.index]);e&&(this.content[t.index]=e)}if(s.includes("HTML")&&!isEmpty(t.attrs))for(let s in t.attrs)e.setAttribute(s,t.attrs[s]);this.updateSizeOnly(t.index),this.obsRenderEvt.cancel(),this.obsRenderEvt(),super.listen({name:"updateItem",cb:t.cb,params:[this.content[t.index]]})}async clear(t){if(!this.destroyed)return this.options.b4Clear&&await this.options.b4Clear.call(this),this.content=[],this.itemSizes=[],this.renderFromStart(),super.listen({name:"cleared",cb:t}),this}destroy(t){if(!this.destroyed)return this.targetEl.removeEventListener("scroll",this.autoRenderEvt),this.startSpyIns.destroy(),this.endSpyIns.destroy(),this.itemObs.disconnect(),this.targetObs.unobserve(this.targetEl),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const pt=[{attr:"list-sel",prop:"listSel",value:""},{attr:"count",prop:"count",value:10},{attr:"counts",prop:"counts",value:""},{attr:"dropdown",prop:"dropdown",value:{}},{attr:"current",prop:"current",value:1},{attr:"size",prop:"size",value:"md"},{attr:"expanded",prop:"expanded",value:!1},{attr:"visible",prop:"visible",value:{edge:2,center:2}},{attr:"align",prop:"align",value:""},{attr:"type",prop:"type",value:""},{attr:"flexible",prop:"flexible",value:!1},{attr:"layout",prop:"layout",value:"first|prev|pages|next|last"},{attr:"classes",prop:"classes",value:""},{attr:"delay",prop:"delay",value:100},{attr:"names",prop:"names",value:{main:"div",total:"span",count:"span",locate:"span",pages:"span",tips:"span",ellipsis:"span",prev:"a",next:"a",first:"a",last:"a",item:"a",section:"section"}},{attr:"content",prop:"content",value:1e3,type:"ignore"},{attr:"cont-type",prop:"contType",value:""},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"b4-locate",prop:"b4Locate",value:null},{attr:"b4-renderlist",prop:"b4RenderList",value:null},{attr:"on-located",prop:"onLocated",value:null},{attr:"on-gotcont",prop:"onGotCont",value:null},{attr:"on-tofirst",prop:"onToFirst",value:null},{attr:"on-tolast",prop:"onToLast",value:null},{attr:"on-exceeded",prop:"onExceeded",value:null},{attr:"on-renderedlist",prop:"onRenderedList",value:null},{attr:"on-renderedpages",prop:"onRenderedPages",value:null},...p];class InputElem extends CompBaseCommField{unitEl;customEl;imageEl;labelEl;limitEl;diskEl;cubeEl;iconEl;btnEl;meanEl;type;select;btnEvt;constructor(){super(),this.type="text-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.select=()=>this.inputEl.select(),this.btnEvt=t=>{"Enter"===t.code&&elState(this.btnEl).isVisible&&this.btnEl.click&&!this.propsProxy.blocked&&(preventDft(t),this.btnEl.click())},this.addEventListener("click",(t=>{getEvtTarget(t)===this.wrapEl&&this.inputEl.focus()}),!1),this.inputEl.addEventListener("input",(t=>{let e=this.propsProxy.value;this.propsProxy.value=this.value=this.inputEl.value,this.updateLimit();let s={oldVal:e,newVal:this.inputEl.value};this.listen({name:"input",params:[s]}),e!==this.inputEl.value&&this.listen({name:"changed",params:[s]})}),!1)}static custAttrs=["name","placeholder","type","size","limit","tools","icon","cube","disk","image","btn","action","label","unit","custom","mean","task","attrs",...this.evtsArr];static boolAttrs=["disabled","readonly","blocked","full"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,InputElem,{tools:getAttrArr(s,"close")})}getRawData(){this.getRawProps(InputElem),this.propsRaw.value=this.getAttribute("value")||this.rawHtml,this.getProxyProps(),this.propsProxy.tools=getAttrArr(this.getAttribute("tools"),"close"),this.setFieldProps(["name","value","disabled","readOnly"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.inputEl=createEl("input",{type:t.type||"text",placeholder:t.placeholder||l.lang.form.placeholder,[s.embedSign]:""}),t.value&&(this.inputEl.value=t.value||""),t.name&&(this.inputEl.name=t.name||""),this.wrapEl.appendChild(this.inputEl),super.getToolsEl(t.tools),this.limitEl=createEl("div",{[s.alias]:"limit"}),this.labelEl=createEl("span",{[s.alias]:"label"}),this.unitEl=createEl("span",{[s.alias]:"unit"}),this.diskEl=createEl("img",{[s.alias]:"disk"}),this.cubeEl=createEl("img",{[s.alias]:"cube"}),this.imageEl=createEl("img",{[s.alias]:"image"}),this.iconEl=createEl("i",{[s.alias]:"icon"}),this.btnEl=createEl("span",{[s.alias]:"btn"}),this.customEl=createEl("span",{[s.alias]:"custom"}),this.meanEl=createEl("i",{[s.alias]:"mean"})}updateLimit(){let t=~~this.propsProxy.limit,e=this.propsProxy.value,s=e.length,i=t-s,a=i<=0?0:i;if(!t)return this;this.limitEl.innerHTML=renderTpl(this.propsProxy.lang?.max||l.lang.form.maxLength,{total:t,value:s,remaining:a}),i<=0?(i<0&&(this.inputEl.value=e.slice(0,t),this.inputEl.dispatchEvent(this.zeroEvt)),this.setAttribute("exceeded","")):this.removeAttribute("exceeded"),elState(this.limitEl).isVirtual&&this.appendChild(this.limitEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),~~this.propsProxy.limit&&this.appendChild(this.limitEl)}changedMaps={disabled:this.changedBool,readonly:this.changedBool,blocked:this.changedBool,full:this.changedBool,name:this.changedName,type:this.changedName,placeholder:this.changedName,value:this.changedValue,icon:this.changedIcon,disk:this.changedImage,cube:this.changedImage,image:this.changedImage,task:this.changedTask,label:this.changedLabel,unit:this.changedUnit,custom:this.changedCustom,action:this.changedAction,btn:this.changedBtn,mean:this.changedMean,limit:this.changedLimit,tools:this.changedTools,attrs:this.changedAttrs};changedBool(t){"blocked"===t.name?this.propsProxy.blocked?this.btnEl.setAttribute("disabled",""):this.btnEl.removeAttribute("disabled"):(this.inputEl["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name],this["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name])}changedTools(t){this.toolsEl&&this.toolsEl.remove(),this.propsProxy.tools.length>0&&(super.getToolsEl(this.propsProxy.tools),this.propsProxy.tools.forEach((t=>{"close"===t.name?t.wrapEl.onclick=()=>this.clear():t.action&&t.action.bind(this)})),this.inputEl.insertAdjacentElement("afterend",this.toolsEl))}changedValue(t){this.value=t.newVal||"";let e=this.inputEl.value;this.inputEl.value=t.newVal,e!==this.value&&this.listen({name:"changed",params:[{oldVal:e,newVal:this.value}]})}changedLimit(t){this.updateLimit()}changedName(t){("type"!==t.name||["text","number","search","email","url","tel","password","time","week","datetime","datetime-local","month"].includes(t.newVal))&&(isNull(t.newVal)?this.inputEl.removeAttribute(t.name):this.inputEl.setAttribute(t.name,t.newVal),"name"===t.name&&(this.name=t.newVal||""))}changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.labelEl)):this.labelEl.remove()}changedUnit(t){t.newVal?(this.unitEl.innerHTML=t.newVal,elState(this.unitEl).isVirtual&&this.wrapEl.appendChild(this.unitEl)):this.unitEl.remove()}changedCustom(t){t.newVal?(this.customEl.innerHTML=t.newVal,elState(this.customEl).isVirtual&&(elState(this.unitEl).isVisible?this.unitEl.insertAdjacentElement("beforebegin",this.customEl):this.wrapEl.appendChild(this.customEl))):this.customEl.remove()}changedBtn(t){t.newVal?(this.btnEl.innerHTML=t.newVal,elState(this.btnEl).isVirtual&&(elState(this.unitEl).isVisible?this.unitEl.insertAdjacentElement("beforebegin",this.btnEl):this.wrapEl.appendChild(this.btnEl)),this.inputEl.addEventListener("keydown",this.btnEvt,!1)):(this.btnEl.remove(),this.inputEl.removeEventListener("keydown",this.btnEvt))}changedAction(t){t.newVal?this.btnEl.onclick=()=>{new Function('"use strict";return '+t.newVal)().call(this,{btn:this.btnEl,el:this})}:this.btnEl.onclick=null}changedIcon(t){t.newVal?(this.iconEl.classList.add(t.newVal),elState(this.iconEl).isVirtual&&this.inputEl.insertAdjacentElement("beforebegin",this.iconEl)):this.iconEl.remove()}changedImage(t){t.newVal?(this[`${t.name}El`].src=t.newVal,elState(this[`${t.name}El`]).isVirtual&&this.inputEl.insertAdjacentElement("beforebegin",this[`${t.name}El`])):this[`${t.name}El`].remove()}changedMean(t){t.newVal?(this.meanEl.classList.add(t.newVal),elState(this.meanEl).isVirtual&&(elState(this.unitEl).isVisible?this.unitEl.insertAdjacentElement("beforebegin",this.meanEl):this.wrapEl.appendChild(this.meanEl))):this.meanEl.remove()}changedTask(t){t.newVal?this.meanEl.onclick=()=>{new Function('"use strict";return '+t.newVal)().call(this,{btn:this.meanEl,el:this})}:this.meanEl.onclick=null}}class Pagination extends ModBaseListenCache{options={};listEl;mainEl;pagesEl;firstEl;lastEl;prevEl;nextEl;totalEl;tipsEl;locateEl;countEl;ellEl;locateInput;locateBtn;countInput;countBtn;items;outputObs;output;content;data;nodes;spyIns;dropdwonIns;altIns;static hostType="node";static optMaps=pt;static dependencies=[InputElem];constructor(t,e={},s=!0){super(),super.ready({options:e,maps:Pagination.optMaps,host:t,component:!0}),super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.setOutputObs(),this.listEl=getEl(this.options.listSel),this.setAttrs(),this.useTpl(),this.getNodesTree(),await this.getInitData(),this.renderLocateEl(),this.renderCountEl(),this.altIns&&this.altIns.on("located",(t=>{this.locate(t.current)})),super.listen({name:"initiated",cb:t}),this}setOutputObs(){this.outputObs=new Observe({current:-1,count:this.options.count,total:0,pages:-1},{lenient:!1,onSet:t=>{["total","count"].includes(t.key)?("total"===t.key?t.proxy.pages=Math.ceil(t.value/(t.proxy.count||1))||1:"count"===t.key&&(t.proxy.pages=Math.ceil(t.proxy.total/(t.value||1))||1),t.proxy.current=Math.min(t.proxy.current,t.proxy.pages)):"current"===t.key&&(t.proxy.current=clampVal({val:t.value,min:1,max:t.proxy.pages})),this.renderTotalEl(),this.renderTipsEl()},onCompleted:t=>{(t.keys.set.includes("pages")||t.keys.set.includes("current"))&&(isEmpty(this.items)||t.keys.set.includes("pages")?(this.renderPagesEl(),this.rerenderListEl()):t.keys.set.includes("current")&&(this.hasEll()?(this.renderPagesEl(),this.rerenderListEl()):this.toggleSelected()),t.proxy.pages<=1?this.setDisabled():t.proxy.current<=1?(this.setDisabled("start"),this.setEnabled("end")):t.proxy.current>=t.proxy.pages?(this.setDisabled("end"),this.setEnabled("start")):this.setEnabled(),this.altIns&&this.altIns.locate(t.proxy.current))}}),this.output=this.outputObs.proxy}setAttrs(){this.targetEl.classList.add(`${s.prefix}pagination`),this.options.align?this.targetEl.setAttribute("align",this.options.align):this.targetEl.removeAttribute("align"),this.options.type?this.targetEl.setAttribute("type",this.options.type):this.targetEl.removeAttribute("type"),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.toggleAttribute("flexible",this.options.flexible),this.options.size?this.targetEl.setAttribute("size",this.options.size):this.targetEl.removeAttribute("size")}getNodesTree(){this.targetEl.innerHTML="",this.mainEl=createEl(this.options.names.main,{[s.alias]:"main"},this.pagesEl),this.pagesEl=createEl(this.options.names.pages,{[s.alias]:"pages"}),this.firstEl=createEl(this.options.names.first,{[s.alias]:"first"},this.options.lang?.first),this.lastEl=createEl(this.options.names.last,{[s.alias]:"last"},this.options.lang?.last),this.prevEl=createEl(this.options.names.prev,{[s.alias]:"prev"},this.options.lang?.prev),this.nextEl=createEl(this.options.names.next,{[s.alias]:"next"},this.options.lang?.next),this.totalEl=createEl(this.options.names.total,{[s.alias]:"total"}),this.tipsEl=createEl(this.options.names.tips,{[s.alias]:"tips"}),this.locateEl=createEl(this.options.names.lacate,{[s.alias]:"locate"}),this.countEl=createEl(this.options.names.count,{[s.alias]:"count"}),this.ellEl=createEl(this.options.names.ellipsis,{[s.alias]:"ell"},this.options.lang?.ellipsis),super.parseLayout(this.targetEl,this.options.layout,{prev:this.prevEl,next:this.nextEl,first:this.firstEl,last:this.lastEl,total:this.totalEl,count:this.countEl,tips:this.tipsEl,locate:this.locateEl,pages:this.pagesEl,group:this.mainEl}),this.prevEl.onclick=()=>{this.prev()},this.nextEl.onclick=()=>{this.next()},this.firstEl.onclick=()=>{this.first()},this.lastEl.onclick=()=>{this.last()}}async getInitData(){if("number"==typeof this.options.content||"total"===this.options.contType)this.respSource=Array(~~this.options.content).fill(null).map(((t,e)=>({index:e}))),this.content=this.respSource,this.output.total=this.options.content;else if("pagination"===this.options.content.moduleName)this.altIns=this.options.content,this.content=[...this.altIns.content],this.output.total=this.content.length;else if("string"==typeof this.options.content&&"ins"===this.options.contType)this.altIns=h.find(this.options.content,"pagination"),this.content=this.altIns?[...this.altIns.content]:[],this.output.total=this.content.length;else{let t=await this.getData();this.content=t.content}(this.options.current<1||this.options.current>this.output.pages)&&super.listen({name:"exceeded",params:[{val:this.options.current,min:1,max:this.output.pages}]}),this.updateCur(this.options.current),this.isSqlReq()?this.data=this.content:this.data=this.sliceData(this.content),1===this.output.current?super.listen({name:"toFirst"}):this.output.current===this.output.pages&&super.listen({name:"toLast"}),super.listen({name:"located",params:[{current:this.output.current,data:this.data}]})}async getData(t,e){let s={content:[],source:null},i={content:this.options.content,contType:this.options.contType,contData:Object.assign({current:this.options.current,count:this.options.count},this.options.contData),ajax:{spinSel:this.listEl,error:t=>{super.listen({name:"error",params:[t]})},xhrName:"contXhr",...this.options.ajax}},a=await getContent.call(this,t?extend({target:i,source:t}):i),l=getDataType(a);return s.source=a,"Array"===l?(s.content=a,this.output.total=s.content.length):"Object"===l&&a.hasOwnProperty("data")?Array.isArray(a.data)?(s.content=a.data,this.output.total=s.content.length):(s.content=a?.data?.list||[],this.output.total=a?.data?.total||s.content.length):"String"===l&&(s.content=tplToEls(a),this.output.total=s.content.length),this.respSource=s.source,super.listen({name:"gotCont",cb:e,params:[s]}),s}isSqlReq(t=this.respSource){return t?.data?.hasOwnProperty("list")&&t?.data?.hasOwnProperty("total")}sliceData(t=this.content,e=this.output.current){let s=(e-1)*this.output.count;return t.slice(s,s+this.output.count)}async getCurCont(t=this.output.current){let e;if(t=this.correctCur(t),this.isSqlReq()){let s=await this.getData({contData:{current:t,count:this.output.count}});this.content=s.content,e=s.content}else e=this.sliceData(this.content,t);return e}getItemNode(t){let e,s=getDataType(t);return s.includes("HTML")?e=t:(e=createEl(this.options.names.section,{}),e.innerHTML="Object"===s?super.getTplcont(t):t.toString()),e}renderTotalEl(){this.totalEl.innerHTML=renderTpl(this.options.lang?.total,this.output)}renderTipsEl(){this.tipsEl.innerHTML=renderTpl(this.options.lang?.tips,this.output)}renderLocateEl(){let t={size:"sm",feature:"plain",label:this.options.lang?.locate,unit:this.options.lang?.page,value:this.output.current,btn:"<i class='_icon-arrow-right'></i>"};this.locateInput=createEl("ax-input",t),this.locateInput.on("connected",(()=>{this.locateInput.btnEl.onclick=debounce((()=>{let t=~~this.locateInput.value;t<1||this.output.pages,t=this.correctCur(t),this.locateInput.value=t,this.locate(t)}),this.options.delay),this.locateInput.onkeyup=t=>"Enter"===t.code&&this.locateInput.btnEl.click()})),this.locateEl.appendChild(this.locateInput)}renderCountEl(){let t={size:"sm",feature:"plain",label:this.options.lang?.count,unit:this.options.lang?.unit,value:this.output.count,btn:"<i class='_icon-arrow-right'></i>"};this.countInput=createEl("ax-input",t),this.countInput.on("connected",(()=>{this.countInput.btnEl.onclick=debounce((()=>{this.output.count=~~this.countInput.value}),this.options.delay),this.countInput.onkeyup=t=>"Enter"===t.code&&this.countInput.btnEl.click(),this.options.counts&&(this.dropdwonIns=new s.Dropdown(this.countInput,{content:this.options.counts,feature:"select",popup:{canClick:t=>this.countInput.inputEl.contains(t),onTargetSet:t=>{this.countInput.btnEl.click()}}}))})),this.countEl.appendChild(this.countInput)}renderPagesEl(t=this.output.current){this.pagesEl.innerHTML="",this.items=[];for(let e=1;e<=this.output.pages;e++)if(this.options.expanded)this.items.push(this.createItem(e));else{let i=e>this.options.visible?.edge&&e<t-this.options.visible?.center,a=e>t+this.options.visible?.center&&e<=this.output.pages-this.options.visible?.edge;if(i||a){if(this.items.at(-1)&&"ell"===this.items.at(-1).getAttribute(s.alias))continue;{let t=this.ellEl.cloneNode(!1);t.innerHTML=renderTpl(this.options.lang?.ellipsis,this.output),this.items.push(t)}}else this.items.push(this.createItem(e))}this.pagesEl.append(...this.items),super.listen({name:"renderedPages",params:[{nodes:this.items,...this.output}]})}createItem(t){let e=createEl(this.options.names.item,{[s.alias]:"page",page:t},t);return this.output.current==t&&e.setAttribute("selected",""),e.onclick=debounce((()=>{this.locate(t)}),this.options.delay),e}hasEll(){return this.items.find((t=>t.getAttribute(s.alias,"ell")))}correctCur(t){return clampVal({val:t,min:1,max:this.output.pages})}updateCur(t=this.output.current){this.output.current=~~t}async rerenderListEl(){if(!this.destroyed&&this.listEl){if(this.options.b4RenderList){let t=await this.options.b4RenderList.call(this,this.data);t&&(this.data=t)}this.nodes=[];for(let t of this.data){let e=this.getItemNode(t);e&&this.nodes.push(e)}this.listEl.innerHTML="",this.listEl.append(...this.nodes),super.listen({name:"renderedList",params:[{nodes:this.nodes,data:this.data,wrap:this.listEl,...this.output}]})}}toggleSelected(t=this.output.current){let e=this.items.find((e=>e.getAttribute("page")==t));if(e){e.setAttribute("selected","");let t=this.items.find((t=>t!==e&&t.hasAttribute("selected")));t&&t.removeAttribute("selected")}}render({content:t=[],tplStr:e=this.tplStr,tplEng:s=this.tplEng,nodeName:i=this.options.names.section,wrapSel:a}){if(this.destroyed)return;if(isEmpty(t))return;this.nodes=[];let l=getEl(a);for(let a of t){let t=super.getTplcont(a,e,s),l=createEl(i,{},t);this.nodes.push(l)}l&&(l.innerHTML="",l.append(...this.nodes)),super.listen({name:"renderedList",params:[{nodes:this.nodes,data:t,wrap:l,...this.output}]})}async locate(t,e){if(!this.destroyed){if(t=~~t,this.options.b4Locate){let e=await this.options.b4Locate.call(this,{to:t,...this.output});isNull(e)||(t="number"==typeof e?e:~~e)}(t<1||t>this.output.pages)&&super.listen({name:"exceeded",params:[{val:t,min:1,max:this.output.pages}]}),t=this.correctCur(t),this.data=await this.getCurCont(t),this.updateCur(t),1===this.output.current?super.listen({name:"toFirst"}):this.output.current===this.output.pages&&super.listen({name:"toLast"}),super.listen({name:"located",cb:e,params:[{current:t,data:this.data}]})}}prev(){this.locate(this.output.current-1)}next(){this.locate(this.output.current+1)}first(){this.locate(1)}last(){this.locate(this.output.pages)}setDisabled(t="both"){"start"===t?(this.prevEl.setAttribute("disabled",""),this.firstEl.setAttribute("disabled","")):"end"===t?(this.nextEl.setAttribute("disabled",""),this.lastEl.setAttribute("disabled","")):(this.prevEl.setAttribute("disabled",""),this.firstEl.setAttribute("disabled",""),this.nextEl.setAttribute("disabled",""),this.lastEl.setAttribute("disabled",""))}setEnabled(t="both"){"start"===t?(this.prevEl.removeAttribute("disabled"),this.firstEl.removeAttribute("disabled")):"end"===t?(this.nextEl.removeAttribute("disabled"),this.lastEl.removeAttribute("disabled")):(this.prevEl.removeAttribute("disabled"),this.firstEl.removeAttribute("disabled"),this.nextEl.removeAttribute("disabled"),this.lastEl.removeAttribute("disabled"))}destroy(t){return this.destroyed||(this.spyIns.destroy(),super.listen({name:"destroyed",cb:t})),this}}let dt=l.rangeHyphen,ct=l.rangeHyphen;const ut=[{attr:"name",prop:"name",value:""},{attr:"step",prop:"step",value:1},{attr:"max",prop:"max",value:100},{attr:"min",prop:"min",value:0},{attr:"value",prop:"value",value:0},{attr:"multiple",prop:"multiple",value:!1},{attr:"full",prop:"full",value:!1},{attr:"rtl",prop:"rtl",value:!1},{attr:"locked",prop:"locked",value:!1},{attr:"limit-show",prop:"limitShow",value:!0},{attr:"tip-show",prop:"tipShow",value:!0},{attr:"size",prop:"size",value:"md"},{attr:"fence",prop:"fence",value:{enable:!1,min:0,max:100}},{attr:"button",prop:"button",value:{enable:!1,decrease:`<i class="${s.prefix}icon-minus-o-f"></i>`,increase:`<i class="${s.prefix}icon-plus-o-f"></i>`}},{attr:"ruler",prop:"ruler",value:{enable:!1,majorEqual:4,minorEqual:"auto",labels:[]}},{attr:"result",prop:"result",value:{enable:!1,target:null}},{attr:"classes",prop:"classes",value:""},{attr:"keyboard",prop:"keyboard",value:!1},{attr:"separator",prop:"separator",value:dt},{attr:"hyphen",prop:"hyphen",value:ct},{attr:"flow",prop:"flow",value:"h"},{attr:"disabled",prop:"disabled",value:!1},{attr:"on-set",prop:"onSet",value:null},{attr:"on-tostart",prop:"onToStart",value:null},{attr:"on-toend",prop:"onToEnd",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-restored",prop:"onRestored",value:null},...p];class Range extends ModBaseListenCache{options={};inputEl;axisCoef;resizeObs;sizes;keyEvt;focusEvt;focusHandle;handles;gestures;fence;resultParent;initVal;rawVal;places;output;decrEl;incrEl;resultEl;wrapEl;mainEl;trackEl;thumbEl;baseEl;bubbleEl;bubbles;handleEl;rulerEl;tickEl;tmpRatios;offset;ceilValue;ticks;fenceEl;propsMap;static hostType="node";static optMaps=ut;constructor(t,e={},i=!0){super();let a,l=getEl(t);if(!l)return this;"INPUT"===l.nodeName?(this.inputEl=l,this.inputEl.type="hidden",a=createEl("div",{class:`${s.prefix}range`}),l.insertAdjacentElement("beforebegin",a),a.appendChild(l)):(a=l,a.classList.add(`${s.prefix}range`),this.inputEl=createEl("input",{type:"hidden",value:l.textContent.trim()}),l.innerHTML="",a.appendChild(this.inputEl)),super.ready({options:e,maps:Range.optMaps,host:a,component:!0,spread:["button","ruler","result","fence"]}),"h"===this.options.flow?this.propsMap=o.x:(this.propsMap=o.y,this.propsMap.position="bottom",this.propsMap.start="insetBlockEnd",this.propsMap.startAlt="inset-block-end"),this.axisCoef="v"===this.options.flow?-1:1,this.resizeObs=new ResizeObserver(debounce((()=>{this.updateSizes()}))),this.sizes={handle:0,track:0,ruler:0,thumb:0,bubble:{min:0,max:0,from:0,to:0,single:0},ratio:{radius:0,min:0,max:0,full:0},offset:{from:{min:0,max:0},to:{min:0,max:0},single:{min:0,max:0}}};let n=this;this.keyEvt=function(t){["ArrowLeft","ArrowDown","ArrowRight","ArrowUp"].includes(t.code)&&(preventDft(t,!0),n.focusHandle=this,[n.isRtl?"ArrowRight":"ArrowLeft","ArrowDown"].includes(t.code)?n.decrease():n.increase())},this.focusEvt=function(){this.focus()},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}if(this.handles={from:null,to:null,single:null},this.gestures={from:null,to:null,single:null,thumb:null},this.correctOpts(),this.resultParent=getEl(this.options.result.target),this.getInitVal(),this.rawVal=Array.isArray(this.options.value)?[...this.initVal]:this.initVal,this.getPlaces(),this.output={multiple:this.options.multiple,raw:"",value:"",range:[0,0],ratio:[0,0]},this.initRender(),this.getDirRtl(),this.setAttrs(),this.resizeObs.observe(this.trackEl),this.updateSizes(),this.setVals(this.initVal),this.ticks=[],this.setTicks(),this.setFence(),!this.options.disabled&&(this.options.button.enable&&(this.decrEl.onclick=()=>this.decrease(),this.incrEl.onclick=()=>this.increase()),this.options.multiple?(this.setHandleIns("from"),this.setHandleIns("to"),this.tmpRatios=[...this.output.ratio],this.gestures.thumb=new Gesture(this.thumbEl,{onTranslating:t=>{this.slideSet(this.thumbEl,t.translate.diff[this.propsMap.axis]*this.axisCoef)},onTranslated:()=>{this.tmpRatios=[...this.output.ratio]}})):this.setHandleIns("single"),this.baseEl.onclick=t=>{let e,s=getClientObj(t);if(!s)return!1;if(e=(s[this.propsMap.axis]-this.baseEl.getBoundingClientRect()[this.propsMap.position])*this.axisCoef,this.options.multiple){let t=this.output.ratio[0]*this.sizes.track,s=this.output.ratio[1]*this.sizes.track;e>s?this.slideSet(this.thumbEl,e-s-this.sizes.handle/2):e<s&&this.slideSet(this.thumbEl,e-t-this.sizes.handle/2),this.tmpRatios=[...this.output.ratio]}else this.slideSet(this.handles.single,e-this.sizes.handle/2)},this.options.multiple||(this.thumbEl.onclick=t=>{let e,s=getClientObj(t);s&&(e=(s[this.propsMap.axis]-this.baseEl.getBoundingClientRect()[this.propsMap.position])*this.axisCoef,this.slideSet(this.handles.single,e-this.sizes.handle/2))}),this.bubbles.min&&(this.bubbles.min.onclick=()=>{this.toStart()}),this.bubbles.max&&(this.bubbles.max.onclick=()=>{this.toEnd()}),this.options.keyboard))for(let t in this.handles){let e=this.handles[t];e&&(e.removeEventListener("keydown",this.keyEvt),e.addEventListener("keydown",this.keyEvt,!1),e.removeEventListener("pointerup",this.focusEvt),e.addEventListener("pointerup",this.focusEvt,!1))}return super.listen({name:"initiated",cb:t}),this}correctOpts(){this.options.max=parseFloat(this.options.max),this.options.min=parseFloat(this.options.min),this.options.step=parseFloat(this.options.step),this.options.fence.enable?this.fence={min:clampVal({val:this.options.fence.min,min:this.options.min,max:this.options.max}),max:clampVal({val:this.options.fence.max,min:this.options.min,max:this.options.max})}:this.fence={min:this.options.min,max:this.options.max}}updateSizes(){let t=(this.handles.single||this.handles.from).getBoundingClientRect()[this.propsMap.size],e=this.trackEl.getBoundingClientRect()[this.propsMap.size],s=this.bubbles.min?this.bubbles.min.getBoundingClientRect()[this.propsMap.size]:0,i=this.bubbles.max?this.bubbles.max.getBoundingClientRect()[this.propsMap.size]:0,a=this.bubbles.from?this.bubbles.from.getBoundingClientRect()[this.propsMap.size]:0,l=this.bubbles.to?this.bubbles.to.getBoundingClientRect()[this.propsMap.size]:0,n=this.bubbles.single?this.bubbles.single.getBoundingClientRect()[this.propsMap.size]:0,r=(e-t)/e,o=t/2/e,h=(this.fence.min-this.options.min)/(this.options.max-this.options.min)*r,p=(this.fence.max-this.options.min)/(this.options.max-this.options.min)*r;extend({target:this.sizes,source:{handle:t,track:e,bubble:{min:s,max:i,from:a,to:l,single:n},ratio:{radius:o,min:h,max:p,full:r}}})}setHandleIns(t){this.gestures[t]=new Gesture(this.handles[t],{onTranslate:()=>{this.offset=style(this.handles[t])[this.propsMap.start]},onTranslating:e=>{let s=e.translate.diff[this.propsMap.axis]*this.axisCoef*super.getRtlCoef(),i=parseFloat(this.offset)+s;this.slideSet(this.handles[t],i)},onTranslated:()=>{"single"!==t&&(this.tmpRatios=[...this.output.ratio])}})}setHandleActive(t){t.setAttribute("active","");for(let e in this.handles)this.handles[e]!==t&&this.handles[e].removeAttribute("active")}getRatioFromVal(t){return(t-this.options.min)/(this.options.max-this.options.min)*this.sizes.ratio.full}getValFromRatio(t){return t*(this.options.max-this.options.min)/this.sizes.ratio.full+this.options.min}decrease(t=this.options.step){let e=this.handles.to&&this.focusHandle===this.handles.to,s=e?this.output.range[0]:this.fence.min,i=this.output.range[e?1:0]-t,a=this.output.range[1]-this.output.range[0];this.options.multiple?(i<s&&(i=s),this.options.locked?this.setVals([i,i+a]):this.setVals(e?[this.output.range[0],i]:[i,this.output.range[1]])):this.setVals(this.output.range[0]-t),this.options.multiple&&(this.tmpRatios=[...this.output.ratio])}increase(t=this.options.step){let e=this.handles.from&&this.focusHandle===this.handles.from,s=e?this.output.range[1]:this.fence.max,i=this.output.range[e?0:1]+t,a=this.output.range[1]-this.output.range[0];this.options.multiple?(i>s&&(i=s),this.options.locked?this.setVals([i-a,i]):this.setVals(e?[i,this.output.range[1]]:[this.output.range[0],i])):this.setVals(this.output.range[0]+t),this.options.multiple&&(this.tmpRatios=[...this.output.ratio])}setAttrs(){this.targetEl.setAttribute("flow",this.options.flow),classes(this.targetEl).add(this.options.classes),this.targetEl.toggleAttribute("multiple",this.options.multiple),this.targetEl.toggleAttribute("full",this.options.full),this.targetEl.toggleAttribute("inert",this.options.disabled),this.targetEl.setAttribute("size",this.options.size),this.options.rtl?this.targetEl.setAttribute("dir","rtl"):this.targetEl.removeAttribute("dir")}getInitVal(){if(this.inputEl.value)this.inputEl.value.includes(this.options.separator)?(this.options.multiple=!0,this.initVal=this.inputEl.value.split(this.options.separator).map((t=>parseFloat(t))).sort(((t,e)=>t-e))):this.initVal=this.options.multiple?[parseFloat(this.inputEl.value),this.options.max]:parseFloat(this.inputEl.value);else if(this.options.multiple&&!Array.isArray(this.options.value)){let t="number"==typeof this.options.value?[this.options.value]:this.options.value.split(this.options.separator).slice(0,2).map((t=>parseFloat(t))).sort(((t,e)=>t-e));this.initVal=[isNull(t[0])?this.options.min:t[0],isNull(t[1])?this.options.max:t[1]]}else!this.options.multiple&&Array.isArray(this.options.value)?this.initVal=this.options.value[0]:"string"==typeof this.options.value&&this.options.value.includes(this.options.separator)?(this.options.multiple=!0,this.initVal=this.options.value.split(this.options.separator).map((t=>parseFloat(t))).sort(((t,e)=>t-e))):this.initVal=Array.isArray(this.options.value)?[...this.options.value].sort(((t,e)=>t-e)):this.options.value}getPlaces(){let t=this.options.step.toString().split(".")[1]?this.options.step.toString().split(".")[1].length:0,e=Math.max(getPlaces(this.options.min),getPlaces(this.options.max));this.places=t>0?t:e}correctVal(t){let e={min:this.fence.min,max:this.fence.max};if(Array.isArray(t)){let s=t.map((t=>toNumber(clampVal({val:t,...e}),{places:this.places})));return this.options.multiple&&s.sort(((t,e)=>t-e)),s}if(""===t||isNull(t))return[this.fence.min,this.fence.max];{let s;return s="string"==typeof t&&t.includes(this.options.separator)?t.split(this.options.separator).map((t=>parseFloat(t))).sort(((t,e)=>t-e)):[toNumber(clampVal({val:t,...e}),{places:this.places}),this.output.range[1]],this.options.multiple?s.sort(((t,e)=>t-e)):s}}initRender(){this.wrapEl?(this.wrapEl.innerHTML="",this.options.name&&(this.inputEl.name=this.options.name),this.inputEl.value=""):(this.wrapEl=createEl("div",{class:`${s.prefix}range-wrap`}),this.targetEl.appendChild(this.wrapEl),!this.inputEl.name&&(this.inputEl.name=this.options.name)),this.bubbles={},this.wrapEl.innerHTML=`\n        <div class="${s.prefix}range-main">\n            <div class="${s.prefix}range-track">\n                <div ${s.alias}="base"></div>\n                <div ${s.alias}="thumb"></div>\n            </div>\n            <div class="${s.prefix}range-bubble">\n                ${this.options.limitShow?"<span "+s.alias+'="min">'+this.options.min+"</span><span "+s.alias+'="max">'+this.options.max+"</span>":""}\n            </div>\n            <div class="${s.prefix}range-handle"></div>\n            <div class="${s.prefix}range-ruler"><ul></ul></div>\n        </div>\n        `,this.mainEl=this.wrapEl.querySelector(`.${s.prefix}range-main`),this.trackEl=this.wrapEl.querySelector(`.${s.prefix}range-track`),this.thumbEl=this.wrapEl.querySelector(`[${s.alias}="thumb"]`),this.baseEl=this.wrapEl.querySelector(`[${s.alias}="base"]`),this.bubbleEl=this.wrapEl.querySelector(`.${s.prefix}range-bubble`),this.bubbles.min=this.bubbleEl.querySelector(`[${s.alias}="min"]`),this.bubbles.max=this.bubbleEl.querySelector(`[${s.alias}="max"]`),this.handleEl=this.wrapEl.querySelector(`.${s.prefix}range-handle`),this.rulerEl=this.wrapEl.querySelector(`.${s.prefix}range-ruler`),this.tickEl=this.rulerEl.querySelector("ul"),this.decrEl=createEl("span",{class:`${s.prefix}range-btn`,[s.alias]:"decrease"},this.options.button.decrease),this.incrEl=createEl("span",{class:`${s.prefix}range-btn`,[s.alias]:"increase"},this.options.button.increase),this.options.button.enable&&(this.mainEl.insertAdjacentElement("beforebegin",this.decrEl),this.mainEl.insertAdjacentElement("afterend",this.incrEl)),this.resultEl=createEl("span",{class:`${s.prefix}range-result`}),this.options.result.enable&&(this.resultParent?this.resultParent.appendChild(this.resultEl):this.wrapEl.appendChild(this.resultEl)),this.options.multiple?(this.handles.from=createEl("span",{[s.alias]:"from",tabindex:0}),this.handles.to=createEl("span",{[s.alias]:"to",tabindex:0}),this.handleEl.append(this.handles.from,this.handles.to),this.options.tipShow&&(this.bubbles.from=createEl("span",{[s.alias]:"from"}),this.bubbles.to=createEl("span",{[s.alias]:"to"}),this.bubbles.merge=createEl("span",{[s.alias]:"merge"}),this.bubbleEl.append(this.bubbles.from,this.bubbles.to,this.bubbles.merge))):(this.handles.single=createEl("span",{[s.alias]:"single",tabindex:0}),this.handleEl.append(this.handles.single),this.options.tipShow&&(this.bubbles.single=createEl("span",{[s.alias]:"single"}),this.bubbleEl.append(this.bubbles.single)))}setVals(t,e){if(this.destroyed)return;this.output.range=this.correctVal(t);let s=100*this.sizes.ratio.radius,getTipHTML=t=>toNumber(t,{places:this.places});if(this.options.multiple){this.output.ratio=[this.getRatioFromVal(this.output.range[0]),this.getRatioFromVal(this.output.range[1])];let t=100*this.output.ratio[0],e=100*this.output.ratio[1];this.handles.from.style[this.propsMap.start]=`${t}%`,this.handles.to.style[this.propsMap.start]=`${e}%`,this.sizes.ratio.center=this.output.ratio[1],this.thumbEl.style[this.propsMap.size]=e-t+"%",this.thumbEl.style[this.propsMap.start]=`${t+s}%`,this.sizes.thumb=this.thumbEl.getBoundingClientRect()[this.propsMap.size],this.options.tipShow&&(this.bubbles.from.style[this.propsMap.start]=`${t}%`,this.bubbles.from.innerHTML=getTipHTML(this.output.range[0]),this.bubbles.to.style[this.propsMap.start]=`${e}%`,this.bubbles.to.innerHTML=getTipHTML(this.output.range[1]),this.bubbles.merge.style[this.propsMap.start]=`${t+(e-t)/2}%`,this.bubbles.merge.innerHTML=`${getTipHTML(this.output.range[0])}<i>${this.options.hyphen}</i>${getTipHTML(this.output.range[1])}`,this.sizes.bubble.from=this.bubbles.from.getBoundingClientRect()[this.propsMap.size],this.sizes.bubble.to=this.bubbles.to.getBoundingClientRect()[this.propsMap.size],this.mergeTips())}else{this.output.ratio[0]=this.getRatioFromVal(this.output.range[0]);let t=100*this.output.ratio[0];this.handles.single.style[this.propsMap.start]=`${t}%`,this.thumbEl.style[this.propsMap.size]=`${t+s}%`,this.sizes.thumb=this.thumbEl.getBoundingClientRect()[this.propsMap.size],this.options.tipShow&&(this.bubbles.single.style[this.propsMap.start]=`${t}%`,this.bubbles.single.innerHTML=getTipHTML(this.output.range[0]),this.sizes.bubble.single=this.bubbles.single.getBoundingClientRect()[this.propsMap.size])}return this.output.value=(this.options.multiple?this.output.range.join(this.options.separator):this.output.range[0]).toString(),this.output.raw=this.inputEl.value,this.options.limitShow&&this.hideEnds(),this.inputEl.value=this.output.value,this.options.result.enable&&(this.resultEl.innerHTML=renderTpl(this.options.lang.result,this.output)),super.listen({name:"output",params:[this.output]}),super.listen({name:"set",cb:e,params:[this.output]}),this.endsListen(e),this}endsListen(t){this.options.multiple?(this.output.range[0]<=this.fence.min?(this.decrEl.toggleAttribute("inert",!0),super.listen({name:"toStart",cb:t,params:[this.fence]})):this.decrEl.removeAttribute("inert"),this.output.range[1]>=this.fence.max?(this.incrEl.toggleAttribute("inert",!0),super.listen({name:"toEnd",cb:t,params:[this.fence]})):this.incrEl.removeAttribute("inert")):this.output.range[0]<=this.fence.min?(this.decrEl.toggleAttribute("inert",!0),super.listen({name:"toStart",cb:t,params:[this.fence]})):this.output.range[0]>=this.fence.max?(this.incrEl.toggleAttribute("inert",!0),super.listen({name:"toEnd",cb:t,params:[this.fence]})):(this.decrEl.removeAttribute("inert"),this.incrEl.removeAttribute("inert"))}getVals(){return this.output}toEnd(t){if(this.destroyed)return;let e,s;return this.options.multiple?(s=this.fence.max-this.output.range[1],e=[this.output.range[0]+s,this.output.range[1]+s]):e=this.fence.max,this.setVals(e),t&&t.call(this,e),this}toStart(t){if(this.destroyed)return;let e,s;return this.options.multiple?(s=this.fence.min-this.output.range[0],e=[this.output.range[0]+s,this.output.range[1]+s]):e=this.fence.min,this.setVals(e),t&&t.call(this,e),this}slideSet(t,e){if(this.destroyed)return;let s;if(t===this.thumbEl&&this.options.multiple){let t=this.tmpRatios[0]+e/this.sizes.track,i=t+(this.tmpRatios[1]-this.tmpRatios[0]),a=this.getValFromRatio(t),l=this.getValFromRatio(i),n=this.getValFromRatio(i)-this.getValFromRatio(t);s=this.options.locked?a<this.fence.min?[this.fence.min,this.fence.min+n]:l>this.fence.max?[this.fence.max-n,this.fence.max]:[a,l]:[a,l]}else{let i=e/this.sizes.track;t===this.handles.from?(i>this.output.ratio[1]?i=this.output.ratio[1]:i<this.sizes.ratio.min&&(i=this.sizes.ratio.min),s=[this.getValFromRatio(i),this.output.range[1]]):t===this.handles.to?(i>this.sizes.ratio.max?i=this.sizes.ratio.max:i<this.output.ratio[0]&&(i=this.output.ratio[0]),s=[this.output.range[0],this.getValFromRatio(i)]):t===this.handles.single&&(i>this.sizes.ratio.max?i=this.sizes.ratio.max:i<this.sizes.ratio.min&&(i=this.sizes.ratio.min),s=this.getValFromRatio(i))}this.setVals(s)}mergeTips(){this.sizes.thumb<(this.sizes.bubble.from+this.sizes.bubble.to)/2?this.targetEl.setAttribute("merged",""):this.targetEl.removeAttribute("merged")}hideEnds(){if(this.options.multiple){let t=this.output.ratio[0]*this.sizes.track,e=this.output.ratio[1]*this.sizes.track;t<this.sizes.bubble.min+this.sizes.bubble.from/2-this.sizes.handle/2?this.targetEl.setAttribute("hidemin",""):this.targetEl.removeAttribute("hidemin"),this.sizes.track-e<this.sizes.bubble.max+this.sizes.bubble.from/2+this.sizes.handle/2?this.targetEl.setAttribute("hidemax",""):this.targetEl.removeAttribute("hidemax")}else{let t=this.output.ratio[0]*this.sizes.track;t<this.sizes.bubble.min+this.sizes.bubble.single/2-this.sizes.handle/2?this.targetEl.setAttribute("hidemin",""):this.targetEl.removeAttribute("hidemin"),this.sizes.track-t<this.sizes.bubble.max+this.sizes.bubble.single/2+this.sizes.handle/2?this.targetEl.setAttribute("hidemax",""):this.targetEl.removeAttribute("hidemax")}}setTicks(){if(this.options.ruler.enable){this.ceilValue=(this.options.max-this.options.min)/this.options.ruler.majorEqual,this.sizes.ruler=this.rulerEl.getBoundingClientRect()[this.propsMap.size];for(let t=0;t<=this.options.ruler.majorEqual;t++){let e=toNumber(this.options.min+this.ceilValue*t,{places:this.places}),s=this.options.ruler.labels.length>0?this.options.ruler.labels[t]:e,i=t/this.options.ruler.majorEqual,a=createEl("li",{style:`${this.propsMap.startAlt}:${100*i}%`,"data-content":s});this.tickEl.appendChild(a),a.onclick=()=>{this.setVals(e)},this.ticks.push({index:t,dom:a,ratio:i,content:s,value:e}),t!==this.options.ruler.majorEqual&&this.setMinorTicks(i)}}}setFence(){if(!this.options.fence.enable)return;let t=this.options.max-this.options.min,e=(this.fence.max-this.fence.min)/t,i=(this.fence.min-this.options.min)/t;this.fenceEl=createEl("div",{[s.alias]:"fence",style:`${this.propsMap.size}:${100*e}%;${this.propsMap.startAlt}:${100*i}%`}),this.rulerEl.appendChild(this.fenceEl)}setMinorTicks(t){let e=0,s=0,i=this.sizes.ruler/this.options.ruler.majorEqual;"auto"===this.options.ruler.minorEqual?e=i<40?5:i>=40&&i<80?6:i>=80&&i<160?7:i>=160&&i<320?8:i>=320&&i>=640?9:10:this.options.ruler.minorEqual>0&&(e=this.options.ruler.minorEqual),s=1/(e*this.options.ruler.majorEqual);for(let i=0;i<e;i++)this.tickEl.insertAdjacentHTML("beforeend",`<li style="${this.propsMap.startAlt}:${100*(t+s*i)}%"></li>`)}disable(t){return this.targetEl.toggleAttribute("inert",!0),this.inputEl.disabled=!0,super.listen({name:"disabled",cb:t}),this}enable(t){return this.targetEl.removeAttribute("inert"),this.inputEl.disabled=!1,super.listen({name:"enabled",cb:t}),this}clear(t){return this.destroyed||(this.options.multiple?this.setVals([this.fence.min,this.fence.max]):this.setVals(this.fence.min),super.listen({name:"cleared",cb:t})),this}restore(t){return this.destroyed||(this.setVals(this.rawVal),super.listen({name:"restored",cb:t,params:[this.rawVal]})),this}destroy(t){if(this.destroyed)return this;this.resizeObs.disconnect();for(let t in this.gestures)this.gestures[t]?.destroy();if(this.options.keyboard)for(let t in this.handles){let e=this.handles[t];e&&(e.removeEventListener("keydown",this.keyEvt),e.removeEventListener("pointerup",this.focusEvt))}return super.listen({name:"destroyed",cb:t}),this}}const gt=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:""},{attr:"disabled",prop:"disabled",value:!1},{attr:"size",prop:"size",value:""},{attr:"format",prop:"format",value:""},{attr:"classes",prop:"classes",value:""},{attr:"mode",prop:"mode",value:"single"},{attr:"feature",prop:"feature",value:"single"},{attr:"multiline",prop:"multiline",value:!1},{attr:"placeholder",prop:"placeholder",value:l.lang.form.placeholder},{attr:"label",prop:"label",value:""},{attr:"tools",prop:"tools",value:{enable:!1,children:["close"]}},{attr:"max-selection",prop:"maxSelection",value:100},{attr:"rows",prop:"rows",value:1},{attr:"cols",prop:"cols",value:1},{attr:"datespan",prop:"datespan",value:[]},{attr:"timespan",prop:"timespan",value:[]},{attr:"full",prop:"full",value:!1},{attr:"footer",prop:"footer",value:{enable:!0,layout:"plain",children:["clear","confirm"]}},{attr:"now-hide",prop:"nowHide",value:!1},{attr:"now-show",prop:"nowShow",value:!1},{attr:"clear-show",prop:"clearShow",value:!0},{attr:"close-show",prop:"closeShow",value:!0},{attr:"cancel-show",prop:"cancelShow",value:!1},{attr:"result-Show",prop:"resultShow",value:!1},{attr:"confirm-hide",prop:"confirmHide",value:!0},{attr:"auto-fill",prop:"autoFill",value:!1},{attr:"manual",prop:"manual",value:!1},{attr:"auto-correct",prop:"autoCorrect",value:!0},{attr:"required",prop:"required",value:!1},{attr:"week-start",prop:"weekStart",value:"monday"},{attr:"separator",prop:"separator",value:","},{attr:"btn-sel",prop:"btnSel",value:""},{attr:"pos-sel",prop:"posSel",value:""},{attr:"input-sel",prop:"inputSel",value:""},{attr:"child-sel",prop:"childSel",value:""},{attr:"display",prop:"display",value:"popup"},{attr:"toDrawer",prop:"toDrawer",value:!0},{attr:"bubble",prop:"bubble",value:{}},{attr:"fill-now",prop:"fillNow",value:!1},{attr:"next",prop:"next",value:""},{attr:"lunar",prop:"lunar",value:{enable:!1,handler:"",map:{},tplStr:"<div>农历：{{this.animal}}年 {{this.month}}{{this.date}}</div>\n                    <div>干支：{{this.gzYear}}年 {{this.gzMonth}}月 {{this.gzDate}}日</div>\n                    <div>节日/节气：{{this.term}} {{this.lunarFestival}} {{this.solarFestival}}</div>\n                    ",tplEng:null,arrange:["solarFestival","lunarFestival","term","date"],tags:[]}},{attr:"events",prop:"events",value:{enable:!1,display:"popup",tplStr:`<div ${s.alias}="label">{{this.label}}</div><div ${s.alias}="content">{{this.content}}</div>`,tplEng:null,heading:"YYYY年MM月DD日 WW",list:[]}},{attr:"menu",prop:"menu",value:[]},{attr:"b4-fill",prop:"b4fill",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-set",prop:"b4Set",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"b4-cancel",prop:"b4Cancel",value:null},{attr:"b4-confirm",prop:"b4Confirm",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-setrange",prop:"onSetRange",value:null},{attr:"on-createdpanels",prop:"onCreatedPanels",value:null},{attr:"on-canceled",prop:"onCanceled",value:null},{attr:"on-confirmed",prop:"onConfirmed",value:null},{attr:"on-cleareded",prop:"onCleared",value:null},{attr:"on-opened",prop:"onOpened",value:null},{attr:"on-closed",prop:"onClosed",value:null},{attr:"on-transferred",prop:"onTransferred",value:null},{attr:"on-updatedtime",prop:"onUpdatedTime",value:null},...p];class TextareaElem extends CompBaseCommField{labelEl;limitEl;type;select;headEl;meanEl;constructor(){super(),this.type="textarea-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.select=()=>this.inputEl.select(),this.addEventListener("click",(t=>{getEvtTarget(t)===this.wrapEl&&this.inputEl.focus()}),!1),this.inputEl.addEventListener("input",(t=>{let e=this.propsProxy.value;this.propsProxy.value=this.inputEl.value,this.value=this.inputEl.value,this.updateLimit(),this.addScrollable(this.inputEl);let s={oldVal:e,newVal:this.inputEl.value};this.listen({name:"input",params:[s]}),e!==this.inputEl.value&&this.listen({name:"changed",params:[s]})}),!1)}static custAttrs=["name","placeholder","size","tools","limit","label","mean","task","attrs",...this.evtsArr];static boolAttrs=["disabled","readonly","single","full"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,TextareaElem,{tools:getAttrArr(s,"close")})}getRawData(){this.getRawProps(TextareaElem),this.propsRaw.value=this.getAttribute("value")||this.rawHtml,this.getProxyProps(),this.propsProxy.tools=getAttrArr(this.getAttribute("tools"),"close"),this.setFieldProps(["name","value","disabled","readOnly"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.inputEl=createEl("textarea",{placeholder:t.placeholder||l.lang.form.placeholder,[s.embedSign]:""}),t.value&&(this.inputEl.value=t.value||""),t.name&&(this.inputEl.name=t.name||""),this.wrapEl.appendChild(this.inputEl),this.getToolsEl(t.tools),this.limitEl=createEl("div",{[s.alias]:"limit"}),this.labelEl=createEl("span",{[s.alias]:"label"}),this.headEl=createEl("div",{[s.alias]:"head"},this.labelEl),this.meanEl=createEl("i",{[s.alias]:"mean"})}updateLimit(){let t=~~this.propsProxy.limit,e=this.propsProxy.value,s=e.length,i=t-s,a=i<=0?0:i;if(!t)return this;this.limitEl.innerHTML=renderTpl(this.propsProxy.lang?.max||l.lang.form.maxLength,{total:t,value:s,remaining:a}),i<=0?(i<0&&(this.inputEl.value=e.slice(0,t),this.inputEl.dispatchEvent(this.zeroEvt)),this.setAttribute("exceeded","")):this.removeAttribute("exceeded"),elState(this.limitEl).isVirtual&&this.appendChild(this.limitEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),~~this.propsProxy.limit&&this.appendChild(this.limitEl)}changedMaps={disabled:this.changedBool,readonly:this.changedBool,full:this.changedBool,name:this.changedName,placeholder:this.changedName,value:this.changedValue,tools:this.changedTools,label:this.changedLabel,mean:this.changedMean,single:this.changedSingle,task:this.changedTask,attrs:this.changedAttrs};changedBool(t){this.inputEl["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name],this["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name]}changedName(t){isNull(t.newVal)?this.inputEl.removeAttribute(t.name):this.inputEl.setAttribute(t.name,t.newVal),"name"===t.name&&(this.name=t.newVal||"")}changedTools(t){this.toolsEl&&this.toolsEl.remove(),this.propsProxy.tools.length>0&&(this.getToolsEl(this.propsProxy.tools),this.propsProxy.tools.forEach((t=>{"close"===t.name?t.wrapEl.onclick=()=>this.clear():t.action&&t.action.bind(this)})),!this.propsProxy.single&&this.propsProxy.label?this.headEl.appendChild(this.toolsEl):this.inputEl.insertAdjacentElement("afterend",this.toolsEl))}changedValue(t){this.value=t.newVal||"";let e=this.inputEl.value;this.inputEl.value=this.value,e!==this.value&&this.listen({name:"changed",params:[{oldVal:e,newVal:this.value}]})}changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal,elState(this.headEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.headEl),!this.propsProxy.single&&this.propsProxy.tools.length>0&&this.headEl.appendChild(this.toolsEl),this.propsProxy.mean&&this.headEl.insertAdjacentElement("afterbegin",this.meanEl)):(this.headEl.remove(),this.propsProxy.tools.length>0&&this.wrapEl.appendChild(this.toolsEl),this.propsProxy.mean&&this.propsProxy.single&&this.wrapEl.appendChild(this.meanEl))}changedSingle(t){this.propsProxy.single?(this.propsProxy.tools.length>0&&this.wrapEl.appendChild(this.toolsEl),this.propsProxy.mean&&this.wrapEl.appendChild(this.meanEl)):this.propsProxy.label?(this.propsProxy.mean&&this.headEl.insertAdjacentElement("afterbegin",this.meanEl),this.propsProxy.tools.length>0&&this.headEl.appendChild(this.toolsEl)):(this.propsProxy.tools.length>0&&this.wrapEl.appendChild(this.toolsEl),this.meanEl.remove())}changedMean(t){t.newVal?(this.meanEl.classList.add(t.newVal),elState(this.meanEl).isVirtual&&(this.propsProxy.single?this.wrapEl.appendChild(this.meanEl):this.headEl.insertAdjacentElement("afterbegin",this.meanEl))):this.meanEl.remove()}changedTask(t){t.newVal?this.meanEl.onclick=()=>{new Function('"use strict";return '+t.newVal)().call(this,{btn:this.meanEl,el:this})}:this.meanEl.onclick=null}}class Datetime extends ModBaseListenCache{options={};value;raw;client;output;data;format;spreadFooter;separator;selectedsProxy;selecteds;resultIns;bubbleEl;bubbleIns;canClick;inputEl;positionEl;childEl;monthStr;panelIdx;datespan;timespan;wrapEl;menuEl;resultEl;outerEl;prevEl;nextEl;mainEl;panelsEl;footEl;bubbleFootEl;footBtnsEl;footTipsEl;confirmEl;clearEl;closeEl;cancelEl;nowEl;daytimeBtnEl;yearSearchEl;rangeChkEl;detailEl;headingEl;eventEl;lunarEl;detailIns;timePanelsEl;prevYearEl;prevMonthEl;nextYearEl;nextMonthEl;static hostType="node";static optMaps=gt;static dependencies=[InputElem,TextareaElem,BtnElem,CheckboxElem];constructor(t,e={},i=!0){super(),super.ready({options:e,maps:Datetime.optMaps,host:t,component:!0,spread:["lunar","events","footer","manual","tools"]}),this.value=[],this.raw=[],this.monthStr=repeatStr(`<li><span ${s.alias}="content"><i ${s.alias}="label">{{this.data[this.index-1]}}</i></span></li>`,12,this.options.lang.month),super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return super.getDirRtl(),this.output={value:"",raw:"",items:[]},this.data={startDate:"",selecteds:[],type:"",panels:[],menu:[],year:{panelEl:"",listEl:"",list:[]},month:{panelEl:"",listEl:"",list:[]},daytime:[]},this.setFeature(),this.format=trim(this.options.format||"YYYY/MM/DD"),this.data.type=D.getDateType(this.format),this.getDateTimeSpan(),"range"===this.options.mode&&1===this.options.cols&&(this.options.cols=2),"xxs"===s.screen?("inline"!==this.options.display&&this.options.toDrawer&&(this.options.display="drawer"),this.options.lunar.enable?(this.options.cols=1,this.options.rows=1):this.options.cols>1&&(this.options.cols=1,this.options.rows=2),this.spreadFooter=!1):this.spreadFooter="daytime"!==this.data.type&&this.options.cols>1||"daytime"===this.data.type&&"range"===this.options.mode,this.separator="range"===this.options.mode&&this.options.lang.range.hyphen||this.options.separator,this.getTargets(),this.selectedsProxy=new Observe(this.data.selecteds,{deep:!0}),this.selecteds=this.selectedsProxy.proxy,this.selectedsProxy.on("completed",(t=>{if(this.resultEl){let e=t.proxy.map((t=>({label:D.fillFormat(t,this.format,this.options.lang),source:t})));this.resultIns.update({content:e})}this.options.autoFill&&this.confirm(!1)})),"daytime"!==this.data.type&&this.handleDayCont(),this.createSkeleton(),"daytime"!==this.data.type?this.createPanels():this.handleTimeCont(),"inline"===this.options.display?this.targetEl&&(this.targetEl.insertAdjacentElement(this.targetEl.classList.contains(`${s.prefix}datetime-wrap`)?"beforeend":"afterend",this.bubbleEl),this.bubbleEl.insertAdjacentHTML("beforebegin",`<div class="${s.prefix}datetime-br"></div>`),this.bubbleEl.insertAdjacentHTML("afterend",`<div class="${s.prefix}datetime-br"></div>`)):"dialog"===this.options.display?this.bubbleIns=this.bubbleIns||new Dialog(this.targetEl,extend({target:{content:this.bubbleEl,size:"",padding:!1,tools:!0,multiple:!1,footer:{enable:!1},wing:{selector:this.options.btnSel},canClick:this.canClick},source:this.options.bubble})):"drawer"===this.options.display?(this.options.full=!0,this.bubbleIns=this.bubbleIns||new Drawer(this.targetEl,extend({target:{content:this.bubbleEl,size:"",padding:!1,tools:!0,multiple:!1,footer:{enable:!1},placement:"bottom",wing:{selector:this.options.btnSel},canClick:this.canClick},source:this.options.bubble}))):this.bubbleIns=this.bubbleIns||new Popup(this.positionEl,extend({target:{content:this.bubbleEl,trigger:"click",tools:{enable:!0,placement:"outside"},size:"",padding:!1,placement:this.isRtl?"bottom-end":"bottom-start",footer:{enable:!1},wing:{selector:this.options.btnSel},canClick:this.canClick},source:this.options.bubble})),this.bubbleIns&&(this.bubbleIns.on("show",(()=>{this.options.autoCorrect&&this.checkB4Show()})),this.bubbleIns.on("shown",(()=>{super.listen({name:"shown"})}))),this.setAttrs(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}setFeature(){"static"===this.options.feature?this.options.footer=!1:"flat"===this.options.feature&&(this.options.footer=!1,this.options.autoFill=!0,this.options.display="inline")}getTargets(){this.targetEl&&this.targetEl.classList.contains(`${s.prefix}datetime-wrap`)?(this.targetEl.innerHTML="",this.inputEl=createEl("ax-textarea",{mean:`${s.prefix}icon-calendar`,placeholder:this.options.placeholder||l.lang.form.placeholder}),this.options.name&&this.inputEl.setAttribute("name",this.options.name),this.options.label&&this.inputEl.setAttribute("label",this.options.label),this.options.tools.enable&&!isEmpty(this.options.tools.children)&&(this.inputEl.propsProxy.tools=this.options.tools.children,this.inputEl.changedTools(),this.canClick=t=>!(this.inputEl.toolsEl&&this.inputEl.toolsEl.contains(t)||this.inputEl.labelEl&&this.inputEl.labelEl.contains(t))),this.inputEl.toggleAttribute("single",!this.options.multiline),this.rawHtml.trim()&&this.inputEl.setAttribute("value",this.rawHtml.trim()),this.options.size?this.inputEl.setAttribute("size",this.options.size):this.inputEl.removeAttribute("size"),this.targetEl.appendChild(this.inputEl),this.positionEl=this.targetEl):(this.positionEl=getEl(this.options.posSel)||this.targetEl,this.inputEl=getEl(this.options.inputSel)||this.targetEl,this.inputEl&&this.inputEl.classList.add(`${s.prefix}bind-datetime`),this.childEl=getEl(this.options.childSel,this.inputEl))}setAttrs(){this.options.classes&&this.targetEl&&classes(this.targetEl).add(this.options.classes),this.bubbleEl.setAttribute("mode",this.options.mode),this.data.type?this.bubbleEl.setAttribute("type",this.data.type):this.bubbleEl.removeAttribute("type"),this.bubbleEl.setAttribute("display",this.options.display),this.options.feature?this.bubbleEl.setAttribute("feature",this.options.feature):this.bubbleEl.removeAttribute("feature"),this.inputEl&&(this.inputEl.toggleAttribute("readonly",!0),this.inputEl.toggleAttribute("disabled",this.options.disabled)),this.bubbleEl.toggleAttribute("disabled",this.options.disabled),this.bubbleEl.toggleAttribute("full",this.options.full),this.bubbleEl.setAttribute("footer",this.options.footer.enable),this.bubbleEl.toggleAttribute("lunar",this.options.lunar.enable)}createPanel(t,e){let i=D.getDate(e,this.data.type,this.options.lang),a={},getWeek=()=>{let t="monday"===this.options.weekStart?"<li>{{this.data[this.index-1]}}</li>":"<li>{{this.data[this.index===1?6:this.index-2]}}</li>";return repeatStr(t,7,this.options.lang.week)};this.data.type.includes("date")?(i.setMonth(i.getMonth()+t),a.month=i.getMonth(),a.year=i.getFullYear(),a.panelEl=tplToEl(`\n                        <li panel='${this.options.lunar.enable?"lunar":"date"}'>\n                            <div ${s.alias}="head">\n                                <span ${s.alias}="year"><i>${a.year}</i>${this.options.lang.unit.Y}</span><span ${s.alias}="month"><i>${a.month+1}</i>${this.options.lang.unit.M}</span>\n                            </div>\n                            <div ${s.alias}="body" days>\n                                <ul ${s.alias}="column" class="${s.prefix}reset  ${s.prefix}grid ${s.prefix}avg-7">\n                                    ${getWeek()}\n                                </ul>\n                                <ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-7"></ul>\n                            </div>\n                        </li>\n                        `),a.type="date",a.headEl=a.panelEl.querySelector(`[${s.alias}="head"]`),a.yearEl=a.headEl.querySelector(`[${s.alias}="year"]`),a.monthEl=a.headEl.querySelector(`[${s.alias}="month"]`),a.listEl=a.panelEl.querySelector(`[${s.alias}="list"]`),a.list=this.createPanelDayList(a.listEl,i)):"month"===this.data.type?(i.setFullYear(i.getFullYear()+t),a.year=i.getFullYear(),a.panelEl=tplToEl(`\n                    <li panel='month'>\n                        <div ${s.alias}="head">\n                            <span ${s.alias}="year"><i>${a.year}</i>${this.options.lang.unit.Y}</span>\n                        </div>\n                        <div body>\n                            <ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3">${this.monthStr}</ul>\n                        </div>\n                    </li>\n                    `),a.type="month",a.headEl=a.panelEl.querySelector(`[${s.alias}="head"]`),a.yearEl=a.headEl.querySelector(`[${s.alias}="year"]`),a.listEl=a.panelEl.querySelector(`[${s.alias}="list"]`),a.list=this.createPanelMonthList(a.listEl,i)):"year"===this.data.type&&(i.setFullYear(i.getFullYear()+18*t-7),a.year=i.getFullYear(),a.panelEl=tplToEl(`\n                <li panel='year'>\n                    <div ${s.alias}="head">\n                        <span ${s.alias}="year"><i>${a.year}</i>${this.options.lang.unit.Y}~<i>${a.year+17}</i>${this.options.lang.unit.Y}</span>\n                    </div>\n                    <div ${s.alias}="body">\n                        <ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3"></ul>\n                    </div>\n                </li>\n                `),a.type="year",a.headEl=a.panelEl.querySelector(`[${s.alias}="head"]`),a.listEl=a.panelEl.querySelector(`[${s.alias}="list"]`),a.list=this.createPanelYearList(a.listEl,i)),a.bodyEl=a.panelEl.querySelector(`[${s.alias}="body"]`),this.data.panels.push(a),this.panelsEl.appendChild(a.panelEl)}createPanels(t,e=!1,s){if(this.destroyed)return;let i=this.options.rows*this.options.cols,a=D.getDate(t||this.data.startDate,this.data.type,this.options.lang);if(!e&&this.inCurPanels(a))return;this.data.panels=[],this.panelsEl.innerHTML="";for(let t=0;t<i;t++)this.createPanel(t,a);this.data.startDate=a;let l=this.getCurGrids();l.forEach((t=>{this.inSelectedDate(t)&&!t.selected&&this.selectedAttrToggle(t,!0)})),"range"===this.options.mode&&this.setRangeAttr(l);let n=D.getDateObj(new Date,this.data.type),r=l.find((t=>JSON.stringify(t.value)==JSON.stringify(n)));return r&&r.wrapEl.setAttribute("now",""),this.afterCreatePanels(),super.listen({name:"createPanels",cb:s}),this}inSelectedDate(t){let e=this.getDateVal(t,this.data.type);return this.selecteds.some((t=>{let{hh:s,mm:i,ss:a,...l}=t;return JSON.stringify(l)==JSON.stringify(e)}))}showEvent(t){if(this.headingEl.innerHTML=D.fillFormat(t.value,this.options.events.heading,this.options.lang),this.options.lunar.enable&&this.options.lunar.handler){let e={...this.options.lunar.map},s=this.options.lunar.handler(t.value.YYYY,t.value.MM+1,t.value.DD);for(let t in e)e.hasOwnProperty(t)&&(e[t]=s[e[t]]);this.lunarEl.innerHTML=super.getTplcont(e,this.options.lunar.tplStr,this.options.lunar.tplEng)}let e=this.options.events.list.find((e=>D.isSameDay(D.getDateObj(e.date,"date"),D.getDateObj(t.value,"date"))));this.eventEl.innerHTML=e&&e.content?super.getTplcont(e,this.options.events.tplStr,this.options.events.tplEng):this.options.lang.noEvent}inCurPanels(t,e){let s,i="datetime"===this.data.type?"date":this.data.type,a="Object"===getDataType(t)?{...t}:t,l=D.getDateObj(a,i);return s=(e||this.getCurGrids()).some((t=>JSON.stringify(t.value)==JSON.stringify(l))),s}inputVal2Dates(t=!0){let e=this.getValFromTgt();return this.str2Dates(e,t)}str2Dates(t,e=!0){return t?t.split(this.separator).map((t=>e?D.getDate(t,this.data.type,this.options.lang):t)):[]}getValFromTgt(){return this.inputEl?("value"in this.inputEl?this.inputEl.value:this.childEl?this.childEl.textContent:this.inputEl.textContent).trim():""}setValFromTgt(t){t=t||"",["INPUT","TEXTAREA"].includes(this.inputEl.nodeName)?this.inputEl.value=t:["AX-INPUT","AX-TEXTAREA"].includes(this.inputEl.nodeName)?this.inputEl.setAttribute("value",t):this.childEl?this.childEl.innerHTML=t:this.inputEl.innerHTML=t}vals2Arr(){let t=getDataType(this.options.value),e=[];if(isEmpty(this.options.value))if(this.options.autoCorrect){e=this.getValFromTgt()?this.inputVal2Dates():this.options.fillNow?[D.getDate(new Date,this.data.type,this.options.lang)]:[]}else e=[];else e="Array"===t?this.options.value.map((t=>D.getDate(t,this.data.type,this.options.lang))):"String"===t?this.str2Dates(this.options.value,!0):[D.getDate(this.options.value,this.data.type,this.options.lang)];return e}handleDayCont(){this.value=this.vals2Arr(),this.value.length>1&&"range"===this.options.mode&&(D.sort(this.value),this.value.length>2&&(this.value=this.value.slice(0,2))),this.data.startDate=0===this.value.length?D.getDate(new Date,this.data.type,this.options.lang):this.value[0];let t=this.dates2Objs(this.value);if(this.selecteds.splice(0,this.data.selecteds.length,...t),this.raw=[...t],this.inputEl){let t=this.selecteds.map((t=>D.fillFormat(t,this.format,this.options.lang))).join(this.separator);this.handleVal(t)}}stdTimeStr(t,e="object"){let s=[],dataFn=t=>D.getDateObj(t,"daytime");if(Array.isArray(t))for(let e of t)s.push(dataFn(e));else s.push(dataFn(t));return"string"===e?s.map((t=>`${D.fillZero(t.hh)}:${D.fillZero(t.mm)}:${D.fillZero(t.ss)}`)):s}handleTimeCont(){if(this.value=this.stdTimeStr(this.vals2Arr()),"range"===this.options.mode?0===this.value.length?this.setDaytime([{hh:0,mm:0,ss:0},{hh:0,mm:0,ss:0}]):1===this.value.length?this.setDaytime([this.value[0],{hh:0,mm:0,ss:0}]):this.setDaytime(this.value):0===this.value.length?this.setDaytime({hh:0,mm:0,ss:0}):this.setDaytime(this.value[0]),this.raw=[...this.value],this.inputEl&&!isEmpty(this.options.value)){let t=this.stdTimeStr(this.value,"string").join(this.separator);this.fillVals(t)}}dates2Objs(t){let e=[];return"year"===this.data.type?e=t.map((t=>({YYYY:t.getFullYear()}))):"month"===this.data.type?e=t.map((t=>({YYYY:t.getFullYear(),MM:t.getMonth()}))):"daytime"===this.data.type?e=t.map((t=>({hh:t.getHours(),mm:t.getMinutes(),ss:t.getSeconds()}))):"date"===this.data.type?e=t.map((t=>({YYYY:t.getFullYear(),MM:t.getMonth(),DD:t.getDate()}))):"datetime"===this.data.type&&(e=t.map((t=>({YYYY:t.getFullYear(),MM:t.getMonth(),DD:t.getDate(),hh:t.getHours(),mm:t.getMinutes(),ss:t.getSeconds()})))),e}checkB4Show(){if("daytime"!==this.data.type){let t=this.inputVal2Dates(),e=this.dates2Objs(t);JSON.stringify(e)==JSON.stringify(this.data.selecteds)||(this.data.startDate=t.length>0?t[0]:D.getDate(this.data.selecteds[0],this.data.type,this.options.lang),this.createPanels(),this.clear(),this.setVals(e))}else{let t=this.stdTimeStr(this.inputVal2Dates());this.setDaytime(t)}}createSkeleton(){let t="",e="";if("daytime"!==this.data.type&&(t=`\n            <div ${s.alias}="outer">\n                        <div ${s.alias}="prev"></div>\n                            <div ${s.alias}="next"></div>\n                            <ul ${s.alias}="panels" class="${s.prefix}reset ${s.prefix}grid ${"xxs"===s.screen?s.prefix+"avg-1":this.spreadFooter?s.prefix+"fence "+s.prefix+"avg-"+this.options.cols:s.prefix+"avg-1"}" ></ul>\n                        </div>`),this.options.footer.enable&&(e=`<div ${s.alias}="foot"></div>`),this.bubbleEl=tplToEl(`\n                <div class="${s.prefix}datetime">\n                    <div ${s.alias}="wrap">\n                        ${this.options.menu.length>0?"<ul "+s.alias+'="menu"  class="'+s.prefix+'reset"></ul>':""}\n                        <div ${s.alias}="main">\n                            ${this.options.resultShow&&"daytime"!==this.data.type?"<div "+s.alias+'="result"></div>':""}\n                            ${t}\n                            ${e}\n                        </div>\n                    </div>\n                </div>\n            `),this.wrapEl=this.bubbleEl.querySelector(`[${s.alias}="wrap"]`),this.menuEl=this.bubbleEl.querySelector(`[${s.alias}="menu"]`),this.resultEl=this.bubbleEl.querySelector(`[${s.alias}="result"]`),this.outerEl=this.bubbleEl.querySelector(`[${s.alias}="outer"]`),this.prevEl=this.bubbleEl.querySelector(`[${s.alias}="prev"]`),this.nextEl=this.bubbleEl.querySelector(`[${s.alias}="next"]`),this.mainEl=this.bubbleEl.querySelector(`[${s.alias}="main"]`),this.panelsEl=this.mainEl.querySelector(`[${s.alias}="panels"]`),this.options.footer.enable){if(this.footEl=this.bubbleEl.querySelector(`[${s.alias}="foot"]`),this.spreadFooter){this.bubbleFootEl=createFooter(Object.assign(this.options.footer,{layout:"right"}),this.footEl,this),this.footBtnsEl=this.bubbleFootEl.querySelector(`.${s.prefix}box-btns`);let t=this.bubbleFootEl.querySelector(`[${s.alias}="tips"]`);t?this.footTipsEl=t:(this.footTipsEl=createEl("div",{[s.alias]:"tips"}),this.footBtnsEl.insertAdjacentElement("afterend",this.footTipsEl))}else this.bubbleFootEl=createFooter(Object.assign(this.options.footer,{layout:"plain"}),this.footEl,this),this.footBtnsEl=this.bubbleFootEl.querySelector(`.${s.prefix}box-btns`),this.footTipsEl=this.footBtnsEl;this.confirmEl=this.bubbleFootEl.querySelector(`[${s.alias}="confirm"]`),this.clearEl=this.bubbleFootEl.querySelector(`[${s.alias}="clear"]`),this.closeEl=this.bubbleFootEl.querySelector(`[${s.alias}="close"]`),this.cancelEl=this.bubbleFootEl.querySelector(`[${s.alias}="cancel"]`),this.nowEl=this.bubbleFootEl.querySelector(`[${s.alias}="now"]`),this.daytimeBtnEl=this.data.type.includes("time")?createEl("ax-btn",{type:"plain",[s.alias]:"daytime",label:this.options.lang.daytime.select}):null,this.yearSearchEl="year"===this.data.type?createEl("ax-input",{[s.alias]:"search",placeholder:this.options.lang.year.placeholder,btn:`<i class="${s.prefix}icon-arrow-right"></i>`}):null,this.rangeChkEl="range"===this.options.mode&&"datetime"===this.data.type?createEl("ax-checkbox",{disabled:"",[s.alias]:"checkbox",label:this.options.lang.range.checkbox}):null,this.daytimeBtnEl&&this.footTipsEl.insertAdjacentElement("afterbegin",this.daytimeBtnEl),this.yearSearchEl&&this.footTipsEl.insertAdjacentElement("afterbegin",this.yearSearchEl),this.rangeChkEl&&(this.footTipsEl.insertAdjacentElement("afterbegin",this.rangeChkEl),this.rangeChkEl.on("check",(t=>{if(t.checked)1===this.selecteds.length&&(this.selecteds.push({...this.selecteds[0]}),this.setRange(this.selecteds));else if(2===this.selecteds.length&&D.isSameDay(this.selecteds[0],this.selecteds[1])){let t={...this.selecteds[0]};this.clear(!1),this.select(t)}})))}this.options.events.enable&&(this.detailEl=createEl("div",{[s.alias]:"detail"}),this.headingEl=createEl("div",{[s.alias]:"heading"}),this.eventEl=createEl("div",{[s.alias]:"event"},this.options.lang.noEvent),this.detailEl.appendChild(this.headingEl),this.detailEl.appendChild(this.eventEl),this.options.lunar.enable&&this.options.lunar.handler&&(this.lunarEl=createEl("div",{[s.alias]:"lunar"}),this.headingEl.insertAdjacentElement("afterend",this.lunarEl)),"inline"===this.options.events.display?this.wrapEl.appendChild(this.detailEl):"popup"===this.options.events.display&&(this.detailIns=this.detailIns||new Popup(this.panelsEl,{content:this.detailEl,trigger:"click",placement:"bottom",size:"md",footer:!1}))),this.data.type.includes("time")&&this.options.footer.enable&&this.createTimeSelectPanel(),this.createMenu(),"daytime"!==this.data.type&&(this.resultEl&&(this.resultIns=this.resultIns||new Tags(this.resultEl,{content:"",removable:!0,empty:{enable:!0,content:this.options.lang.empty}})),"year"===this.data.type||"month"===this.data.type?(this.prevEl.innerHTML=`<i ${s.alias}="prevYear" class= "${s.prefix}icon-left-double"></i> `,this.nextEl.innerHTML=`<i ${s.alias}="nextYear" class= "${s.prefix}icon-right-double"></i> `):this.data.type.includes("date")&&(this.prevEl.innerHTML=`<i ${s.alias}="prevYear" class= "${s.prefix}icon-left-double"></i> <i ${s.alias}="prevMonth" class="${s.prefix}icon-left"></i>`,this.nextEl.innerHTML=`<i ${s.alias}="nextYear" class= "${s.prefix}icon-right-double"></i> <i ${s.alias}="nextMonth" class="${s.prefix}icon-right"></i>`),this.prevYearEl=this.prevEl.querySelector(`[${s.alias}="prevYear"]`),this.prevMonthEl=this.prevEl.querySelector(`[${s.alias}="prevMonth"]`),this.nextYearEl=this.mainEl.querySelector(`[${s.alias}="nextYear"]`),this.nextMonthEl=this.mainEl.querySelector(`[${s.alias}="nextMonth"]`),("month"===this.data.type||this.data.type.includes("date"))&&this.createYearPanel(),this.data.type.includes("date")&&this.createMonthPanel())}createMenu(){if(this.options.menu.length>0){this.data.menu=this.options.menu;let t=document.createDocumentFragment();this.data.menu.forEach((e=>{e.el=createEl("li","",e.label),t.appendChild(e.el)})),this.menuEl.appendChild(t),this.data.menu.forEach((t=>{t.el.onclick=()=>{t.action&&t.action.call(this,t),t.el.setAttribute("selected",""),t.selected=!0,this.data.menu.filter((e=>e!==t)).forEach((t=>{Reflect.deleteProperty(t,"selected"),t.el.removeAttribute("selected")}))}}))}}createMonthPanel(t){this.data.month.panelEl=createEl("div",{panel:"month"},`<div ${s.alias}="body"><ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3">${this.monthStr}</ul></div>`),this.data.month.listEl=this.data.month.panelEl.querySelector(`[${s.alias}="list"]`),[...this.data.month.listEl.children].forEach(((t,e)=>{let i={wrapEl:t,contEl:t.querySelector(`[${s.alias}="content"]`),value:e};this.data.month.list.push(i)})),this.panelsEl.insertAdjacentElement("afterend",this.data.month.panelEl),t&&t()}createYearPanel(t){this.data.year.panelEl=createEl("div",{panel:"year"},`\n            <div ${s.alias}="body">\n                                <ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3"></ul>\n                                <ul ${s.alias}="pages"  class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3">\n                                    <li><i ${s.alias}="prev">${this.options.lang.year.prev}</i></li>\n                                    <li><ax-input placeholder="${this.options.lang.year.placeholder}" size="sm" btn="<i class='${s.prefix}icon-arrow-right'></i>"></ax-input></li>\n                                    <li><i ${s.alias}="next">${this.options.lang.year.next}</i></li>\n                                </ul>\n                            </div>\n            `),this.data.year.listEl=this.data.year.panelEl.querySelector(`[${s.alias}="list"]`),this.data.year.prevEl=this.data.year.panelEl.querySelector(`[${s.alias}="prev"]`),this.data.year.nextEl=this.data.year.panelEl.querySelector(`[${s.alias}="next"]`),this.data.year.searchEl=this.data.year.panelEl.querySelector("ax-input"),this.data.year.inputEl=this.data.year.searchEl.inputEl,this.data.year.btnEl=this.data.year.searchEl.btnEl,this.panelsEl.insertAdjacentElement("afterend",this.data.year.panelEl),t&&t()}createYearList(t,e,i){if(t){this.data.year.listEl.innerHTML="",this.data.year.list=[],this.panelIdx=i||0;for(let i=0;i<15;i++){let a=e||0===e?e+i:t.year-7+i,l={wrapEl:createEl("li","",`<span ${s.alias}="content"> <i ${s.alias}="label">${a}${this.options.lang.unit.Y}</i></span> `),value:a};l.contEl=l.wrapEl.querySelector(`[${s.alias}="content"]`),l.labelEl=l.wrapEl.querySelector(`[${s.alias}="label"]`),this.data.year.listEl.appendChild(l.wrapEl),this.data.year.list.push(l)}this.data.year.list.forEach((e=>{t.year===e.value?this.selectedAttrToggle(e,!0):this.selectedAttrToggle(e,!1),e.contEl.onclick=()=>{if(!e.disabled&&t.year!==e.value){let t=e.value;"month"===this.data.type?t=e.value-this.panelIdx:this.data.type.includes("date")&&(t=e.value-(this.data.panels[this.panelIdx].year-this.data.panels[0].year)),this.data.startDate.setFullYear(t),this.createPanels(null,!0),hide({el:this.data.year.panelEl})}}}))}}goto(t,e=!1,s){if(this.destroyed)return;let i=D.getDate(t,this.data.type,this.options.lang);e?this.setVals(i):this.createPanels(i),s&&s.call(this)}offset(t,e){if(!this.destroyed){if(this.data.selecteds.length>0){let e=this.data.selecteds.map((e=>D.getDateObj(D.getOffsetDate(e,t),this.data.type)));this.setVals(e)}else this.data.startDate=D.getOffsetDate(D.getDateObj(new Date,this.data.type),t),this.setVals(this.data.startDate);e&&e.call(this)}}selectedAttrToggle(t,e){e?t.selected||(Reflect.set(t,"selected",!0),t.wrapEl.setAttribute("selected","")):t.selected&&(Reflect.deleteProperty(t,"selected"),t.wrapEl.removeAttribute("selected"))}select(t,e,s){let i=this.findFromPanels(t,e,s),a=i.list,l=i.target,fillTime=t=>{let e={};return e="range"===this.options.mode?this.data.type.includes("time")?{...t,...this.data.daytime[1===this.selecteds.length?1:0].value}:t:this.data.daytime.length>0&&this.data.type.includes("time")?{...t,...this.data.daytime[0].value}:t,e};a.includes(t)||l||(this.createPanels(t.hasOwnProperty("value")?t.value:t),l=this.findFromPanels(t).target),l.disabled||(!l?.selected&&(e=>{if(e.disabled)return;let s;if(s=this.data.type.includes("time")?t.hasOwnProperty("hh")&&t.hasOwnProperty("mm")&&t.hasOwnProperty("ss")?t:fillTime(e.value):t.value||t,"range"===this.options.mode){let t=this.selecteds.length;if(t<2)if(this.selecteds.push(s),1===t){let t={...this.data.selecteds[0]},e={...this.data.selecteds[1]};D.getDate(t,this.data.type,this.options.lang)>D.getDate(e,this.data.type,this.options.lang)&&(this.selecteds.sort(((t,e)=>D.getDate(t,this.data.type,this.options.lang)-D.getDate(e,this.data.type,this.options.lang))),this.assignDaytime()),this.rangeChkEl&&this.rangeChkEl.setAttribute("disabled",""),this.rangeChkEl&&this.rangeChkEl.setAttribute("check",""),this.setRange(this.selecteds)}else this.rangeChkEl&&this.rangeChkEl.removeAttribute("disabled");else this.clear(!1),this.selecteds.splice(0,this.selecteds.length,s),this.rangeChkEl&&this.rangeChkEl.removeAttribute("disabled"),this.rangeChkEl&&this.rangeChkEl.setAttribute("check","")}else if("multiple"===this.options.mode)!this.inSelectedDate(s)&&this.selecteds.push(s);else{if(this.inSelectedDate(s))return;this.clear(!1),this.selecteds.splice(0,this.selecteds.length,s)}this.selectedAttrToggle(e,!0)})(l),this.options.events.enable&&l&&this.showEvent(l))}deselect(t,e,s){if(isEmpty(t))return;let i=s||this.getCurGrids(),a=this.findFromPanels(t,e,i).target,l=[];a&&this.selectedAttrToggle(a,!1),l=this.data.selecteds.filter((e=>!D.isSameDay(e,t.hasOwnProperty("value")?t.value:t))),this.selecteds.splice(0,this.data.selecteds.length,...l),"range"===this.options.mode&&this.data.selecteds.length<2&&i.forEach((t=>{this.removeRangeAttr(t)}))}setRangeAttr(t){if(2!==this.data.selecteds.length)return;let e=t||this.getCurGrids(),s="datetime"===this.data.type?"date":this.data.type;e.forEach((t=>{this.removeRangeAttr(t),this.selectedAttrToggle(t,!1),D.getDate(t.value,s,this.options.lang)>D.getDate(this.data.selecteds[0],s,this.options.lang)&&D.getDate(t.value,s,this.options.lang)<D.getDate(this.data.selecteds[1],s,this.options.lang)&&t.wrapEl.setAttribute("contain","")}));let i=this.findFromPanels(this.data.selecteds[0],null,e).target,a=this.findFromPanels(this.data.selecteds[1],null,e).target;i&&(i.wrapEl.setAttribute("start",""),this.selectedAttrToggle(i,!0)),a&&(a.wrapEl.setAttribute("end",""),this.selectedAttrToggle(a,!0))}removeRangeAttr(t){t.wrapEl.hasAttribute("start")&&t.wrapEl.removeAttribute("start"),t.wrapEl.hasAttribute("end")&&t.wrapEl.removeAttribute("end"),t.wrapEl.hasAttribute("contain")&&t.wrapEl.removeAttribute("contain")}getDatespan(){if(this.datespan=[],isEmpty(this.options.datespan))return;let t=getDataType(this.options.datespan),getVal=t=>{let e={};return"Object"!==getDataType(t)||(t.hasOwnProperty("min")&&(e.min={Date:D.getDate(t.min,this.data.type,this.options.lang),Object:D.getDateObj(t.min,this.data.type,this.options.lang)}),t.hasOwnProperty("min")&&(e.min=D.getDate(t.min,this.data.type,this.options.lang)),t.hasOwnProperty("max")&&(e.max=D.getDate(t.max,this.data.type,this.options.lang)),t.hasOwnProperty("max")&&(e.max={Date:D.getDate(t.max,this.data.type,this.options.lang),Object:D.getDateObj(t.max,this.data.type,this.options.lang)})),e};"Object"===t?this.datespan.push(getVal(this.options.datespan)):"Array"===t&&(this.datespan=this.options.datespan.map((t=>getVal(t))).filter((t=>!isEmpty(t))))}getTimespan(){if(this.timespan=[],isEmpty(this.options.timespan))return;let t=getDataType(this.options.timespan),getVal=t=>{let e={};return"Object"!==getDataType(t)||(t.hasOwnProperty("min")&&(e.min=D.getDateObj(t.min,this.data.type,this.options.lang)),t.hasOwnProperty("max")&&(e.max=D.getDateObj(t.max,this.data.type,this.options.lang))),e};"Object"===t?this.timespan.push(getVal(this.options.timespan)):"Array"===t&&(this.timespan=this.options.timespan.map((t=>getVal(t))).filter((t=>!isEmpty(t))))}getDateTimeSpan(){let hander=(t="timespan")=>{if(isEmpty(this.options[t]))return[];let e=getDataType(this.options[t]),s="datespan"===t?"getDate":"getDateObj",getVal=t=>{let e={};return"Object"!==getDataType(t)||(t.hasOwnProperty("min")&&(e.min=D[s](t.min,this.data.type,this.options.lang)),t.hasOwnProperty("max")&&(e.max=D[s](t.max,this.data.type,this.options.lang))),e};return"Object"===e?[getVal(this.options[t])]:"Array"===e?this.options[t].map((t=>getVal(t))).filter((t=>!isEmpty(t))):void 0};this.datespan=hander("datespan"),this.timespan=hander("timespan")}setWrapDisabled(t){t.disabled=!0,t.wrapEl.setAttribute("disabled","")}compareVal(t,e,s){let i,a=e.hasOwnProperty("min")?s?e.min[s]:e.min:null,l=e.hasOwnProperty("max")?s?e.max[s]:e.max:null;return i=(!isNull(a)||!isNull(l))&&(isNull(a)?t<=l:isNull(l)?t>=a:t>=a&&t<=l),i}setDatespanDisabled(t){if(!this.datespan.length||t.disabled)return;let e,s=D.getDate(t.value,this.data.type,this.options.lang);e=!this.datespan.find((t=>this.compareVal(s,t))),e&&this.setWrapDisabled(t)}setTimespanDisabled(t,e){if(!this.timespan.length||t.disabled)return;let s;s=!this.timespan.find((s=>this.compareVal(t.value,s,e))),s&&this.setWrapDisabled(t)}getDateVal(t,e){let s,i=getDataType(t),a={};return"String"===i||"Date"===i?s=D.getDateObj(t,"date"):("Object"===i?a=t.hasOwnProperty("value")?t.value:t:"Number"===i&&(a=this.data.selecteds[t]),s=D.getDateObj(a,"date")),"year"===e?(Reflect.deleteProperty(s,"DD"),Reflect.deleteProperty(s,"MM")):"month"===e&&Reflect.deleteProperty(s,"DD"),s}getCurGrids(){return this.data.panels.map((t=>t.list)).flat(1/0).filter((t=>!t.exceed))}findFromPanels(t,e,s){let i=this.getDateVal(t,this.data.type),a=s||this.getCurGrids();return{target:e||a.find((t=>JSON.stringify(t.value)==JSON.stringify(i))),list:a}}afterCreatePanels(){if("daytime"!==this.data.type){let t=this.getCurGrids();this.data.panels.forEach((e=>{e.list.forEach((e=>{e.contEl.onclick=()=>{if(e.disabled)return;if(this.data.selecteds.length>this.options.maxSelection)return;let s=t.find((t=>JSON.stringify(t.value)==JSON.stringify(e.value)));"multiple"===this.options.mode&&s&&s.selected?this.deselect(e,s,t):this.select(e,s,t),super.listen({name:"set",params:[e]})},this.detailIns&&(e.contEl.onmouseenter=()=>{this.showEvent(e),this.detailIns.transfer(e.contEl,(()=>{this.detailIns.show()}))})}))})),this.data.panels.forEach(((t,e)=>{t.yearEl&&(t.yearEl.onclick=()=>{this.data.year.panelEl.style.top=t.panelEl.offsetTop+t.headEl.clientHeight+"px",this.data.year.panelEl.style.left=t.panelEl.offsetLeft+"px",this.data.month.panelEl&&elState(this.data.month.panelEl).isVisible&&hide({el:this.data.month.panelEl}),this.createYearList(t,null,e),toggle({el:this.data.year.panelEl,done:{show:()=>{t.yearEl.classList.add(`${s.prefix}opened`)},hide:()=>{t.yearEl.classList.remove(`${s.prefix}opened`)}}})},this.data.year.prevEl.onclick=()=>{this.createYearList(t,this.data.year.list[0].value-15,e)},this.data.year.nextEl.onclick=()=>{this.createYearList(t,this.data.year.list[14].value+1,e)},this.data.year.btnEl.onclick=()=>{this.searchYear2Update(this.data.year.inputEl)},this.data.year.inputEl.onkeyup=t=>{"Enter"===t.code&&this.searchYear2Update(this.data.year.inputEl)}),t.monthEl&&(t.monthEl.onclick=()=>{this.data.month.panelEl.style.top=t.panelEl.offsetTop+t.headEl.clientHeight+"px",this.data.month.panelEl.style.left=t.panelEl.offsetLeft+"px",elState(this.data.year.panelEl).isVisible&&hide({el:this.data.year.panelEl}),this.data.month.list.forEach((s=>{t.month===s.value?this.selectedAttrToggle(s,!0):this.selectedAttrToggle(s,!1),s.contEl.onclick=()=>{t.month!==s.value&&(this.data.startDate.setMonth(s.value-e),this.createPanels("",!0),hide({el:this.data.month.panelEl}))}})),toggle({el:this.data.month.panelEl,done:{show:()=>{t.monthEl.classList.add(`${s.prefix}opened`)},hide:()=>{t.monthEl.classList.remove(`${s.prefix}opened`)}}})})})),this.data.selecteds.forEach(((e,s)=>{let i=this.findFromPanels(e,null,t).target;i&&(this.selectedAttrToggle(i,!0),0===s&&this.options.events.enable&&this.showEvent(i))}))}}renderFinish(){if("daytime"!==this.data.type&&(this.resultIns&&(this.resultIns.on("removed",(t=>{for(let e of t)this.deselect(e.source)})),this.resultIns.on("updated",(()=>{this.resultIns.data.forEach((t=>{t.wrapEl.onclick=e=>{"remove"!==e.target.getAttribute(s.alias)&&!this.findFromPanels(t.label).target&&this.createPanels(t.label)}}))}))),this.prevYearEl&&(this.prevYearEl.onclick=()=>{let t="year"===this.data.type?-18*this.options.cols*this.options.rows:"month"===this.data.type?-this.options.cols*this.options.rows:-1;this.createPanels(D.getOffsetDate(this.data.startDate,{YYYY:t}),!0),this.data.year.panelEl&&this.createYearList(this.data.panels[this.panelIdx],null,this.panelIdx)}),this.nextYearEl&&(this.nextYearEl.onclick=()=>{let t="year"===this.data.type?18*this.options.cols*this.options.rows:"month"===this.data.type?this.options.cols*this.options.rows:1;this.createPanels(D.getOffsetDate(this.data.startDate,{YYYY:t}),!0),this.data.year.panelEl&&this.createYearList(this.data.panels[this.panelIdx],null,this.panelIdx)}),this.data.type.includes("date")&&(this.prevMonthEl.onclick=()=>{this.createPanels(D.getOffsetDate(this.data.startDate,{MM:-1}),!0)},this.nextMonthEl.onclick=()=>{this.createPanels(D.getOffsetDate(this.data.startDate,{MM:1}),!0)}),this.yearSearchEl&&(this.yearSearchEl.btnEl.onclick=()=>{this.searchYear2Update(this.yearSearchEl.inputEl,!1)},this.yearSearchEl.inputEl.onkeyup=t=>{"Enter"===t.code&&this.searchYear2Update(this.yearSearchEl.inputEl,!1)}),this.timePanelsEl&&("range"===this.options.mode?0===this.data.selecteds.length?this.setDaytime([{hh:0,mm:0,ss:0},{hh:0,mm:0,ss:0}]):1===this.data.selecteds.length?this.setDaytime([this.data.selecteds[0],{hh:0,mm:0,ss:0}]):this.setDaytime(this.data.selecteds):0===this.data.selecteds.length?this.setDaytime({hh:0,mm:0,ss:0}):this.setDaytime(this.data.selecteds[0]),this.daytimeBtnEl&&(this.daytimeBtnEl.onclick=()=>{slideToggle({el:this.timePanelsEl,display:"grid",before:t=>{"show"===t.for&&this.openTime2Scroll()}})}))),this.options.footer.enable&&(this.confirmEl&&(this.confirmEl.onclick=()=>this.confirm()),this.nowEl&&(this.nowEl.onclick=()=>this.setNow()),this.clearEl&&(this.clearEl.onclick=()=>this.clear(!0)),this.cancelEl&&(this.cancelEl.onclick=()=>this.cancel()),this.closeEl&&(this.closeEl.onclick=()=>this.hide())),this.data.type.includes("time")&&this.data.daytime.length>0){let t=this.data.daytime.map((t=>t.colsEl)).flat(1/0);"inline"===this.options.display?this.openTime2Scroll(t):this.bubbleIns&&this.bubbleIns.on("show",(()=>{this.openTime2Scroll(t)}))}this.bubbleIns?this.bubbleIns.on("show",(()=>{this.setResultWidth()})):this.setResultWidth()}setResultWidth(){this.resultEl&&(this.resultEl.style.maxWidth=this.panelsEl.getBoundingClientRect().width+"px")}openTime2Scroll(t){(t||this.data.daytime.map((t=>t.colsEl)).flat(1/0)).forEach((t=>{this.showForemost(t)}))}searchYear2Update(t,e=!0){let s=t.value;s&&!isNaN(s)?(this.data.startDate.setFullYear(~~s),this.createPanels(),e&&hide({el:this.data.year.panelEl}),"year"===this.data.type&&this.select({YYYY:~~s})):new Message({status:"error",iconShow:!0,content:this.options.lang.message.requireYearFormat}).show()}createPanelDayList(t,e){t.innerHTML="";let i=D.getDate(e,this.data.type,this.options.lang);i.setDate(1);let a,l=[],n=i.getMonth(),r=i.getFullYear(),o=D.getCurDays(i),h=D.getOffsetDate(i,{MM:-1}),p=h.getMonth(),d=h.getFullYear(),c=D.getOffsetDate(i,{MM:1}),u=c.getMonth(),g=c.getFullYear(),m=document.createDocumentFragment();a="monday"===this.options.weekStart?0===i.getDay()?7:i.getDay():0===i.getDay()?1:i.getDay()+1;let b=1;for(let t=1;t<=42;){let e,i={wrapEl:createEl("li"),contEl:createEl("span",{[s.alias]:"content"}),labelEl:createEl("i",{[s.alias]:"label"})};if(i.wrapEl.appendChild(i.contEl),i.contEl.appendChild(i.labelEl),t<a?(e=D.getCurDays({YYYY:d,MM:p})-a+t+1,i.value={YYYY:d,MM:p,DD:e},i.exceed=!0,i.wrapEl.setAttribute("exceed","")):t>=a+o?(e=t-a-o+1,i.value={YYYY:g,MM:u,DD:e},i.exceed=!0,i.wrapEl.setAttribute("exceed","")):(e=b,i.value={YYYY:r,MM:n,DD:e},b++),i.label=e,i.labelEl.textContent=e,this.setDatespanDisabled(i),this.options.lunar&&this.options.lunar.handler){let t=this.options.lunar.handler(i.value.YYYY,i.value.MM+1,i.value.DD);if(t&&-1!=t){let e="",a="";for(let s of this.options.lunar.arrange)if(this.options.lunar.map.hasOwnProperty(s)&&t[this.options.lunar.map[s]]){e=t[this.options.lunar.map[s]],s.includes("Festival")?a="festival":"term"===s&&(a=s);break}i.lunarEl=createEl("u","",e),a&&i.lunarEl.setAttribute(s.alias,a),i.labelEl.insertAdjacentElement("afterend",i.lunarEl)}if(this.options.lunar.tags.length>0)for(let t of this.options.lunar.tags){let e=D.getDateObj(t.date,this.data.type),a=createEl("s",t.attr?{[s.alias]:t.attr}:{},t.content);if(D.isSameDay(e,i.value)){i.contEl.appendChild(a);break}}}if(this.options.events.enable)for(let t of this.options.events.list){let e=D.getDateObj(t.date,this.data.type);if(D.isSameDay(e,i.value)){i.busy=!0,i.wrapEl.setAttribute("busy","");break}}t++,m.appendChild(i.wrapEl),l.push(i)}return t.appendChild(m),l}createPanelMonthList(t,e){let i=[];return[...t.children].forEach(((t,a)=>{let l={wrapEl:t,contEl:t.querySelector(`[${s.alias}="content"]`),value:{YYYY:e.getFullYear(),MM:a}};this.setDatespanDisabled(l),i.push(l)})),i}createPanelYearList(t,e){let i=[],a=document.createDocumentFragment();for(let t=0;t<18;t++){let l=e.getFullYear()+t,n=createEl("li","",`<span ${s.alias}="content"><i ${s.alias}="label">${l}${this.options.lang.unit.Y}</i></span>`),r={wrapEl:n,value:{YYYY:l}};r.contEl=r.wrapEl.querySelector(`[${s.alias}="content"]`),this.setDatespanDisabled(r),i.push(r),a.appendChild(n)}return t.appendChild(a),i}createLoopStr(t){let e="<li>";for(let i=0;i<t;i++)e+=`<div> <span ${s.alias}="content"><i ${s.alias}="label">${D.fillZero(i)}</i></span></div> `;return e+="</li>",e}createTimeList(t){return`\n        <li panel="daytime">\n                            <span ${s.alias}="tools"><i ${s.alias}="restore" title='${this.options.lang.toolTip.restore}'></i><i ${s.alias}="reset" title='${this.options.lang.toolTip.reset}'></i><i ${s.alias}="now" title='${this.options.lang.toolTip.now}'></i><i ${s.alias}="close" title='${this.options.lang.toolTip.close}'></i></span>\n                            <div ${s.alias}="head">\n                                <span ${s.alias}="time">${t}</span>\n                            </div>\n                            <div ${s.alias}="body">\n                                <ul ${s.alias}="column" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3">\n                                    <li>${this.options.lang.unit.h}</li>\n                                    <li>${this.options.lang.unit.m}</li>\n                                    <li>${this.options.lang.unit.s}</li>\n                                </ul>\n                                <ul ${s.alias}="list" class="${s.prefix}reset ${s.prefix}grid ${s.prefix}avg-3">\n                                ${this.createLoopStr(24)}\n                                ${this.createLoopStr(60)}\n                                ${this.createLoopStr(60)}\n                                </ul>\n                            </div>\n                        </li>\n        `}toggleTimeList(t,e){this.selectedAttrToggle(t,!0);let s=e.find((e=>e!=t&&e.selected));s&&this.selectedAttrToggle(s,!1)}getTimeListArr(t,e){let i=t.children,a=[];return[...i].forEach(((t,i)=>{let l={wrapEl:t,contEl:t.querySelector(`[${s.alias}="content"]`),value:i};this.format.includes(e)?this.setTimespanDisabled(l,e):(l.disabled=!0,l.wrapEl.setAttribute("disabled","")),a.push(l)})),a}showForemost(t){let fun=t=>{let e=t.querySelector("[selected]"),s=e.getBoundingClientRect().height*Math.floor(~~e.textContent/2);e&&(t.scrollTop=s)};Array.isArray(t)?t.forEach((t=>{fun(t)})):fun(t)}createTimeSelectPanel(){this.timePanelsEl=createEl("UL",{class:`${s.prefix}reset ${s.prefix}grid ${s.prefix}fence ${"xxs"===s.screen?s.prefix+"avg-1":s.prefix+"avg-"+this.options.cols}`,panels:"hms"}),"range"===this.options.mode?this.timePanelsEl.innerHTML=this.createTimeList(this.options.lang.daytime.start)+this.createTimeList(this.options.lang.daytime.end):this.timePanelsEl.innerHTML=this.createTimeList(this.options.lang.daytime.select),[...this.timePanelsEl.querySelectorAll("[panel]")].forEach((t=>{let e=[...t.querySelectorAll(`[${s.alias}="list"] li`)],i={panelEl:t,colsEl:e,restoreEl:t.querySelector(`[${s.alias}="restore"]`),resetEl:t.querySelector(`[${s.alias}="reset"]`),nowEl:t.querySelector(`[${s.alias}="now"]`),closeEl:t.querySelector(`[${s.alias}="close"]`),value:{},hh:this.getTimeListArr(e[0],"hh"),mm:this.getTimeListArr(e[1],"mm"),ss:this.getTimeListArr(e[2],"ss")};this.data.daytime.push(i)})),this.footEl.insertAdjacentElement("beforebegin",this.timePanelsEl),this.data.daytime.forEach(((t,e)=>{t.closeEl.onclick=()=>{slideUp({el:this.timePanelsEl,display:"inline-grid"})},t.restoreEl.onclick=()=>{this.raw[e]&&this.setDaytime(this.raw[e],e,!0)},t.resetEl.onclick=()=>{this.setDaytime({hh:0,mm:0,ss:0},e,!0)},t.nowEl.onclick=()=>{let t=D.getDateObj(new Date,this.data.type);this.setDaytime({hh:t.hh,mm:t.mm,ss:t.ss},e,!0)},t.hh.forEach((s=>{s.contEl.onclick=()=>{s.selected||s.disabled||(this.toggleTimeList(s,t.hh),t.value.hh=s.value,this.timeToUpdate(t,e,!0),super.listen({name:"updatedTime",params:[s]}))}})),t.mm.forEach((s=>{s.contEl.onclick=()=>{s.selected||s.disabled||(this.toggleTimeList(s,t.mm),t.value.mm=s.value,this.timeToUpdate(t,e,!0),super.listen({name:"updatedTime",params:[s]}))}})),t.ss.forEach((s=>{s.contEl.onclick=()=>{s.selected||s.disabled||(this.toggleTimeList(s,t.ss),t.value.ss=s.value,this.timeToUpdate(t,e,!0),super.listen({name:"updatedTime",params:[s]}))}}))}))}timeToUpdate(t,e=0,s=!1){s&&this.setTimeBtnHTML(),"daytime"===this.data.type||"single"!==this.options.mode&&"range"!==this.options.mode||this.data.selecteds.length>=e+1&&Object.assign(this.selecteds[e],t.value),"daytime"===this.data.type&&this.options.autoFill&&this.confirm(!1)}setTimeBtnHTML(){if(!this.data.type.includes("time")||!this.daytimeBtnEl)return;let t=this.data.daytime.map((t=>isEmpty(t.value)?this.options.lang.daytime.select:`${D.fillZero(t.value.hh)}:${D.fillZero(t.value.mm)}:${D.fillZero(t.value.ss)}`));this.daytimeBtnEl.setAttribute("label",t.join("~"))}setDaytime(t,e=0,s=!1,i){if(isEmpty(t)||!this.data.type.includes("time")||this.destroyed)return;let a=getDataType(t),setFun=(e,i)=>{let a="string"==typeof e?D.getTimeObj(t):e;this.data.daytime[i].value.hh=a.hh,this.toggleTimeList(this.data.daytime[i].hh[a.hh],this.data.daytime[i].hh),this.data.daytime[i].value.mm=a.mm,this.toggleTimeList(this.data.daytime[i].mm[a.mm],this.data.daytime[i].mm),this.data.daytime[i].value.ss=a.ss,this.toggleTimeList(this.data.daytime[i].ss[a.ss],this.data.daytime[i].ss),s&&"datetime"===this.data.type&&this.timeToUpdate(this.data.daytime[i],i)};"Array"===a?t.forEach(((t,e)=>{this.data.daytime.length>e&&setFun(t,e)})):setFun(t,e),this.setTimeBtnHTML(),super.listen({name:"updatedTime",cb:i,params:[t]})}assignDaytime(){this.selecteds.forEach(((t,e)=>{this.data.daytime[e]&&Object.assign(t,this.data.daytime[e].value)}))}async cancel(t){this.options.b4Cancel&&await this.options.b4Cancel.call(this),this.hide(),this.clear(!0),this.handleVal(""),super.listen({name:"canceled",cb:t})}hide(t){this.bubbleIns&&this.bubbleIns.hide((()=>{super.listen({name:"hidden",cb:t})}))}show(t){this.bubbleIns&&this.bubbleIns.show((()=>{super.listen({name:"shown",cb:t})}))}async confirm(t=this.options.confirmHide,e){if(this.destroyed)return;this.options.b4Confirm&&await this.options.b4Confirm.call(this);let s="";if("daytime"!==this.data.type){if("range"===this.options.mode)if(0===this.data.selecteds.length)s="";else{if(2!==this.data.selecteds.length)return new Message({status:"error",iconShow:!0,content:this.options.lang.message.requireTwoValue}).show(),!1;{let t=D.fillFormat(this.data.selecteds[0],this.format,this.options.lang),e=D.fillFormat(this.data.selecteds[1],this.format,this.options.lang);s=`${t}${this.options.lang.range.hyphen}${e} `}}else if(s=this.data.selecteds.map((t=>D.fillFormat(t,this.format,this.options.lang))).join(this.options.separator),this.options.required&&!s)return new Message({status:"error",iconShow:!0,content:this.options.lang.message.requireOneSelected}).show(),!1}else s=this.data.daytime.map((t=>D.fillFormat(t.value,this.format,this.options.lang))).join(this.separator);if(await this.handleVal(s),t&&this.bubbleIns){this.hide();let t=this.options.next&&h.find(this.options.next,"datetime");t?.bubbleIns&&t.show()}super.listen({name:"confirmed",cb:e,params:[s]})}fillVals(t){if(!this.inputEl||"static"===this.options.feature)return;let e=this.inputEl.value;this.setValFromTgt(t),super.listen({name:"filled",params:[t]}),this.output={value:t,raw:e,items:this.data.selecteds},super.listen({name:"output",params:[this.output]}),super.updateCache({content:t})}async handleVal(t){if(this.options.b4Fill){let e=await this.options.b4Fill.call(this,t,this.separator);e&&(t=e)}this.value=t,!this.options.manual&&this.fillVals(t)}setNow(t=this.options.nowHide){if(this.destroyed)return;let e=D.getDateObj(new Date,this.data.type);"daytime"===this.data.type?this.setDaytime(e):(this.timePanelsEl&&"range"!==this.options.mode&&this.setDaytime(e),this.select(e)),t&&(this.confirm(),this.hide())}removeIns(){this.bubbleEl.remove(),this.bubbleIns&&(this.bubbleIns.destroy(),this.bubbleIns=null),this.detailIns&&(this.detailIns.destroy(),this.detailIns=null),this.resultIns&&(this.resultIns.destroy(),this.resultIns=null)}async update(t,e){if(!this.destroyed)return this.removeIns(),isEmpty(t)||(this.updateCache&&this.updateCache(t),extend({target:this.options,source:t}),await this.init()),super.listen({name:"updated",cb:e,params:[this.options]}),this}setVals2Objs(t){let e=getDataType(t),s=[];if("Array"===e&&(s=t),"Date"===e)s=[t];else if("Object"===e)s=[t];else if("String"===e){let e;e=t.includes(this.options.separator)?this.options.separator:this.separator,s=t.split(e)}return 0===s.length?[]:s.map((t=>D.getDateObj(t,this.data.type)))}getVals(){return{value:this.value,separator:this.separator}}async setVals(t,e){if(isEmpty(t)||this.destroyed)return;let s=this.setVals2Objs(t);if(0!==s.length){if(this.options.b4Set){let t=await this.options.b4Set.call(this,s);!isEmpty(t)&&(s=t)}return super.listen({name:"set",cb:e,params:[s]}),"range"===this.options.mode?(s.length>=2?(s.splice(2,s.length-2),this.setRange(s)):this.select(s[0]),this.setDaytime(s,0,!0)):"single"===this.options.mode?(this.select(s[0]),this.setDaytime(s[0],0,!0)):"multiple"===this.options.mode&&s.forEach((t=>{this.select(t)})),super.listen({name:"set",cb:e,params:[s]}),this}}setRange(t,e){if(isEmpty(t)||2!==t.length||this.destroyed)return;let s=t.map((t=>D.getDateObj(t,this.data.type))),i=this.getCurGrids();return D.sort(s),this.selecteds.splice(0,this.selecteds.length,...s),this.inCurPanels(s[0],i)||this.inCurPanels(s[1],i)?this.setDaytime(s):this.createPanels(s[0]),this.setRangeAttr(),super.listen({name:"ranged",cb:e,params:[s]}),this}async removeVals(t,e){if(isEmpty(t)||this.destroyed)return;let s=this.setVals2Objs(t);return 0!==s.length?(this.options.b4Remove&&await this.options.b4Remove.call(this,s),s.forEach((t=>{this.deselect(t)})),super.listen({name:"removed",cb:e,params:[s]}),this):void 0}async clear(t=!0,e){if(!this.destroyed){if(this.options.b4Clear&&await this.options.b4Clear.call(this),"daytime"!==this.data.type){this.selecteds.splice(0),this.resultIns&&this.resultIns.clear(),this.getCurGrids().forEach((t=>{t.selected&&this.selectedAttrToggle(t,!1),this.removeRangeAttr(t)}))}if(t&&this.timePanelsEl)for(let t in this.data.daytime)this.setDaytime({hh:0,mm:0,ss:0},t);return super.listen({name:"cleared",cb:e}),this}}async transfer(t,e,s){if(this.destroyed)return;let i=getEl(e),a=getEl(t);"popup"===this.options.display&&i&&(this.positionEl=i,await this.bubbleIns.transfer(e)),a&&(this.inputEl=a,this.inputEl.readOnly=!0,this.options.autoCorrect&&this.checkB4Show()),super.listen({name:"transferred",cb:s,params:[a,i]})}disable(){this.destroyed||(this.inputEl&&this.inputEl.toggleAttribute("inert",!0),this.bubbleEl.toggleAttribute("inert",!0),super.listen({name:"disabled"}))}enable(){this.destroyed||(this.inputEl&&this.inputEl.removeAttribute("inert"),this.bubbleEl.removeAttribute("inert"),super.listen({name:"enabled"}))}destroy(t){if(!this.destroyed)return this.removeIns(),this.confirmEl&&(this.confirmEl.onclick=null),this.nowEl&&(this.nowEl.onclick=null),this.clearEl&&(this.clearEl.onclick=null),this.cancelEl&&(this.cancelEl.onclick=null),this.closeEl&&(this.closeEl.onclick=null),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const mt=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:0},{attr:"fill",prop:"fill",value:"value"},{attr:"heading",prop:"heading",value:""},{attr:"half",prop:"half",value:!1},{attr:"count",prop:"count",value:5},{attr:"increment",prop:"increment",value:1},{attr:"tooltip",prop:"tooltip",value:{enable:!1,format:l.lang.rate.template.tooltip}},{attr:"result",prop:"result",value:{enable:!1,format:l.lang.rate.template.result}},{attr:"label",prop:"label",value:{enable:!1,format:""}},{attr:"clearable",prop:"clearable",value:!1},{attr:"size",prop:"size",value:"md"},{attr:"star",prop:"star",value:`${s.prefix}icon-star-f`},{attr:"type",prop:"type",value:"icon"},{attr:"map",prop:"map",value:[]},{attr:"highlight",prop:"highlight",value:!1},{attr:"omitted",prop:"omitted",value:!1},{attr:"classes",prop:"classes",value:""},{attr:"disabled",prop:"disabled",value:!1},{attr:"readonly",prop:"readonly",value:!1},{attr:"on-set",prop:"onSet",value:null},{attr:"on-changed",prop:"onChanged",value:null},{attr:"on-restored",prop:"onRestored",value:null},{attr:"on-cleared",prop:"onCleared",value:null},...p];class Rate extends ModBaseListenCache{options={};inputEl;current;evtMap;useMap;outputIns;output;rawVal;wrapEl;tooltipIns;tooltipEl;clearEl;items;legends;headEl;resultEl;static hostType="node";static optMaps=mt;constructor(t,e={},i=!0){super();let a,l=getEl(t);if(!l)return this;"INPUT"===l.nodeName?(this.inputEl=l,this.inputEl.type="range",a=createEl("div",{class:`${s.prefix}rate`}),l.insertAdjacentElement("beforebegin",a)):(a=l,a.classList.add(`${s.prefix}rate`),this.inputEl=createEl("input",{type:"range"})),super.ready({options:e,maps:Rate.optMaps,host:a,component:!0,spread:["tooltip","result","lable"]}),this.current={place:"full",legend:null,value:0,stars:0},this.evtMap=s.isTouchScr?{move:"ontouchmove",end:"ontouchend"}:{move:"onmousemove",end:"onmouseleave"},super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.useMap=!isEmpty(this.options.map)&&Array.isArray(this.options.map),this.options.count=this.useMap?this.options.map.length:~~this.options.count,this.createOutputIns(),this.legends=[],this.renderMain(),this.renderFormat(),this.getDirRtl(),this.setAttrs(),this.options.value=parseFloat(this.options.value||this.rawHtml||this.inputEl.value),this.rawVal=this.options.value,this.setVals(this.options.value),this.createTooltip(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}createOutputIns(){this.outputIns=new Observe({stars:0,value:0,title:this.options.lang.title.dft,count:this.options.count,total:this.options.count*this.options.increment},{onSet:t=>{if("value"===t.key){let t=parseFloat(this.inputEl.value),e=this.output[this.options.fill||"value"];this.inputEl.value=e,t!==e&&super.listen({name:"changed",params:[e,t]})}},onCompleted:()=>{this.renderFormat()}}),this.output=this.outputIns.proxy}renderFinish(){this.options.readonly||this.options.disabled||(this.wrapEl[this.evtMap.move]=t=>{let e=this.findLegend(t);if(!e)return;let s=this.getStarPoint(t,e),{stars:i,value:a}=this.updateStarsState({legend:e,place:s});this.tooltipIns&&(this.tooltipIns.transfer(e,(()=>this.tooltipIns.show())),this.renderFormat("tooltip",{...this.output,stars:i,value:a})),this.current={place:s,legend:e,stars:i,value:a}},this.wrapEl.onclick=t=>{let e=this.findLegend(t);e&&this.setVals({legend:e,place:this.getStarPoint(t,e)})},this.wrapEl[this.evtMap.end]=t=>{this.tooltipIns&&this.tooltipIns.hide(),s.isTouchScr?this.setVals(this.current):this.updateStarsState(this.output.value)},this.clearEl.onclick=()=>{this.clear()})}renderFormat(t,e={...this.output}){let s="result"===t?this.resultEl:"tooltip"===t?this.tooltipEl:null;s?this.options[t].enable&&(s.innerHTML=renderTpl(this.options[t].format,e)):(this.options.result.enable&&(this.resultEl.innerHTML=renderTpl(this.options.result.format,e)),this.options.tooltip.enable&&(this.tooltipEl.innerHTML=renderTpl(this.options.tooltip.format,e)))}findLegend(t){return this.legends.find((e=>contains(getEvtTarget(t),e)))}getStarPoint(t,e){if(!this.options.half)return"full";let s=getRectPoints(t,e),i=this.isRtl?"r":"l";return s.length<=1?"":s.includes(`${i}/3`)||s.includes(`${i}/2`)?"half":"full"}createTooltip(){this.options.tooltip.enable&&(this.tooltipIns=new Tooltip(this.wrapEl,extend({target:{content:this.tooltipEl,size:"",theme:"text-lt",keepShow:!0},source:this.options.tooltip})))}getStarsHtml(){let t,getStar=t=>"image"===this.options.type?`<i><img src="${t}"/></i>`:`<i class="${t}"></i>`,e="",i="",getHtml=t=>this.options.label.enable?`<span ${s.alias}="label">${t}</span>`:"";if(this.useMap)for(let[a,l]of this.options.map.entries())t={id:a+1,title:l.title,count:this.options.map.length},i=this.options.label.format?renderTpl(this.options.label.format,t):t.title,e+=`<li ${l.title?'title="'+l.title+'"':""}>\n                <span ${s.alias}="legend">${getStar(l.on)}${getStar(l.off||l.on)}</span>\n                ${getHtml(i)}\n                </li>`;else for(let a=0;a<this.options.count;a++)t={id:a+1,title:"",count:this.options.count},i=this.options.label.format?renderTpl(this.options.label.format,t):t.id+this.options.lang.star,e+=`<li>\n                <span ${s.alias}="legend">${getStar(this.options.star).repeat(2)}</span>\n                ${getHtml(i)}\n                </li>`;return e}renderMain(){this.targetEl.innerHTML="";let t=document.createDocumentFragment();t.appendChild(this.inputEl),this.wrapEl=createEl("ul",{class:`${s.prefix}reset`},this.getStarsHtml()),this.resultEl=createEl("div",{[s.alias]:"result"}),this.tooltipEl=createEl("div",{[s.alias]:"tooltip"}),this.clearEl=createEl("i",{class:`${s.prefix}icon-close-o-f`,[s.alias]:"clear",title:this.options.lang.title.clear}),this.items=[...this.wrapEl.children],this.legends=this.items.map((t=>getEl(`[${s.alias}="legend"]`,t))),this.headEl=createEl("i",{[s.alias]:"head"},this.options.heading),this.options.heading&&t.appendChild(this.headEl),this.options.clearable&&t.appendChild(this.clearEl),t.appendChild(this.wrapEl),this.options.result.enable&&t.appendChild(this.resultEl),this.targetEl.appendChild(t),super.listen({name:"rendered",params:[{targetEl:this.targetEl,headEl:this.headEl,wrapEl:this.wrapEl,resultEl:this.resultEl,clearEl:this.clearEl,items:this.items,legends:this.legends}]})}setAttrs(){this.options.size?this.targetEl.setAttribute("size",this.options.size):this.targetEl.removeAttribute("size"),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.setAttribute("type",this.options.type),this.targetEl.toggleAttribute("disabled",this.options.disabled),this.targetEl.toggleAttribute("readonly",this.options.readonly),this.targetEl.toggleAttribute("omitted",this.options.omitted),this.inputEl.step=(this.options.half?.5:1)*("value"===this.options.fill?this.options.increment:1),this.inputEl.max=this.options.count*("value"===this.options.fill?this.options.increment:1),this.inputEl.min=0,this.inputEl.disabled=!0,this.inputEl.name=this.options.name,!this.inputEl.hasAttribute("value")&&(this.inputEl.value=0),this.options.rtl?this.targetEl.setAttribute("dir","rtl"):this.targetEl.removeAttribute("dir")}getVals(){return{...this.output}}correctVal(t){let e=0;if("Object"===getDataType(t)){let s=this.legends.findIndex((e=>e===t.legend));if(-1===s)e=0;else{e=(s+("half"===t.place?.5:"full"===t.place?1:0))*this.options.increment}}else{let s=clampVal({min:0,max:this.options.increment*this.options.count,val:parseFloat(t)})/this.options.increment,i=Math.floor(s),a=s-i;e=(i+this.getFloatStar(a))*this.options.increment}return e}getFloatStar(t){return this.options.half?t?t>0&&t<=.5?.5:1:0:t?1:0}toggleSelected(t){let e=[...this.wrapEl.children].find((e=>e!==t&&e.hasAttribute("selected")));e&&e.toggleAttribute("selected",!1),t.toggleAttribute("selected",!0)}updateStarsState(t=0){let e,i=this.correctVal(t),a=i/this.options.increment,l=Math.floor(a),n=a-l,r=[`${s.prefix}half`,`${s.prefix}full`];n=this.getFloatStar(n);for(let t=0;t<this.legends.length;t++){let s=this.legends[t].firstElementChild,a=s.closest("li");i?t<l?this.options.highlight?n||t!==l-1?classes(s).remove(r.join()):(classes(s).replace(...r),this.toggleSelected(a),e=a):(classes(s).replace(...r),n||t!==l-1||(this.toggleSelected(a),e=a)):t===l?0===n?classes(s).remove(r.join()):(.5===n?classes(s).replace(...[...r].reverse()):classes(s).replace(...r),this.toggleSelected(a),e=a):classes(s).remove(r.join()):classes(s).remove(r.join())}return{stars:l+n,value:i,item:e}}setVals(t,e){let{stars:s,value:i,item:a}=this.updateStarsState(t);i!==this.output.value&&(this.output.stars=s,this.output.value=i,this.output.item=a,this.useMap&&(this.output.title=this.options.map[Math.ceil(s)-1].title),super.updateCache({value:i}),super.listen({name:"set",cb:e,params:[{...this.output}]}))}restore(t){return this.destroyed||(this.setVals(this.rawVal),super.listen({name:"restored",cb:t,params:[this.rawVal]})),this}clear(t){return this.destroyed||(this.setVals(0),super.listen({name:"cleared",cb:t})),this}destroy(t){return this.destroyed||(this.wrapEl[this.evtMap.move]=null,this.wrapEl.onclick=null,this.wrapEl[this.evtMap.end]=null,this.clearEl.onclick=null,this.tooltipIns&&this.tooltipIns.destroy(),super.listen({name:"destroyed",cb:t})),this}}let bt=l.splitHyphen;const Et=[{attr:"name",prop:"name",value:""},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"passive",prop:"passive",value:!1},{attr:"disable",prop:"disable",value:""},{attr:"readonly",prop:"readonly",value:""},{attr:"expand",prop:"expand",value:{value:"",all:!1,only:!0,linkage:!1}},{attr:"arrow",prop:"arrow",value:{enable:!0,show:`${s.prefix}icon-down`,hide:`${s.prefix}icon-down`,anim:`${s.prefix}rotate180`,type:"icon",trigger:"click"}},{attr:"check",prop:"check",value:{enable:!1,type:"checkbox",value:""}},{attr:"tools",prop:"tools",value:{enable:!1,trigger:"hover",children:["add","edit","remove"]}},{attr:"output",prop:"output",value:{enable:!0,target:"",separator:bt,prop:"label"}},{attr:"click-line",prop:"clickLine",value:"none"},{attr:"deferred",prop:"deferred",value:!1},{attr:"delay",prop:"delay",value:100},{attr:"drag",prop:"drag",value:{enable:!1,exclude:""}},{attr:"drop",prop:"drop",value:{attr:"dropnode",global:!1}},{attr:"lamp",prop:"lamp",value:{enable:!1,placement:"bottom"}},{attr:"duration",prop:"duration",value:0},{attr:"classes",prop:"classes",value:""},{attr:"layout",prop:"layout",value:"check(icon|disk|cube|label|tips)custom|tools|badge|arrow"},{attr:"appear",prop:"appear",value:{rounded:!0,bordered:!0,divided:!0,gapped:!1}},{attr:"b4-expand",prop:"b4Expand",value:null},{attr:"b4-collapse",prop:"b4Collapse",value:null},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-edit",prop:"b4Edit",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-graft",prop:"b4Graft",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-disabledall",prop:"onDisabledAll",value:null},{attr:"on-enabledall",prop:"onEnabledAll",value:null},{attr:"on-readonly",prop:"onReadonly",value:null},{attr:"on-readonlyall",prop:"onReadonlyAll",value:null},{attr:"on-expand",prop:"onExpand",value:null},{attr:"on-expanded",prop:"onExpanded",value:null},{attr:"on-collapse",prop:"onCollapse",value:null},{attr:"on-collapsed",prop:"onCollapsed",value:null},{attr:"on-expandall",prop:"onExpandAll",value:null},{attr:"on-expandedAll",prop:"onExpandedAll",value:null},{attr:"on-collapsedall",prop:"onCollapsedAll",value:null},{attr:"on-selected",prop:"onSelected",value:null},{attr:"on-deselected",prop:"onDeselected",value:null},{attr:"on-selectedall",prop:"onSelectedAll",value:null},{attr:"on-checked",prop:"onChecked",value:null},{attr:"on-unchecked",prop:"onUnchecked",value:null},{attr:"on-checkedall",prop:"onCheckedAll",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-turned",prop:"onTurned",value:null},{attr:"on-got",prop:"onGot",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-grafted",prop:"onGrafted",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-toofew",prop:"onTooFew",value:null},{attr:"on-toomany",prop:"onTooMany",value:null},{attr:"on-locked",prop:"onLocked",value:null},{attr:"on-unlocked",prop:"onUnlocked",value:null},...p];class Accordion extends ModBaseListenCacheNest{expandEvt;lineEvt;treeDataOrig;receiver;rawData;observeIns;chainChecking;hoverIns;inputEl;value;contXhr;static hostType="node";static optMaps=Et;static dependencies=[BadgeElem];constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Accordion.optMaps,component:!0,spread:["output","arrow","check","lamp","tools","drag"]});let a=this;this.expandEvt=debounce((function(){let t="arrow"===this.getAttribute(s.alias)?"arrowEl":"headEl",e=findItem(this,a.flatData,t);a.toggleExpanded(e)}),this.options.delay),this.lineEvt=debounce((function(t){let e=findItem(this,a.flatData,"headEl");e&&(["group","gap","holder"].includes(t.target.getAttribute(s.alias))||t.target===e.headEl)&&("expanded"===a.options.clickLine?a.toggleExpanded(e):"checked"===a.options.clickLine&&a.toggleCheck(e))}),this.options.delay),this.treeDataOrig=[],super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.receiver=getEl(this.options.output.target),super.useTpl(),await this.getDataToRender(),this.setAttrs(),this.renderFinish(),super.initCheckeds(),this.initExpandeds(),super.initDisableds(),super.initReadonlys(),super.listen({name:"initiated",cb:t}),this}async getDataToRender(){let t,e={nodeType:"accordion"};return t=this.options.content?S.allToTree({content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{spinSel:this.targetEl,xhrName:"contXhr"},ins:this,...e}):S.allToTree({content:this.targetEl.innerHTML,...e}),await t.then((t=>{this.treeDataOrig=t.data&&Array.isArray(t.data)?t.data:t,this.rawData=t})),this.targetEl.innerHTML="",this.renderData(this.treeDataOrig),this.getTreeFlat(),super.listen({name:"rendered",params:[this.treeData,this.flatData]}),this}getTreeFlat(){this.treeData=this.getObserver(this.treeDataOrig).proxy,this.flatData=this.treeData}getObserver(t){return this.observeIns=new Observe(t,{deep:{enable:!0,exclude:["tools"]},onSet:t=>{if("icon"===t.key&&t.proxy.iconEl)classes(t.proxy.iconEl).replace(t.raw,t.value);else if("cube"===t.key&&t.proxy.cubeEl)t.proxy.cubeEl.src=t.value;else if("disk"===t.key&&t.proxy.diskEl)t.proxy.diskEl.src=t.value;else if("label"===t.key)t.proxy.labelEl.innerHTML=t.value;else if("tips"===t.key&&t.proxy.tipsEl)t.proxy.tipsEl.innerHTML=t.value;else if("content"===t.key)super.updateElCont(t.proxy,t.value,"content");else if("extra"===t.key)super.updateElCont(t.proxy,t.value,"extra");else if("custom"===t.key&&t.proxy.customEl)super.updateElCont(t.proxy,t.value,"custom");else if("badge"===t.key&&t.proxy.badgeEl)t.proxy.badgeEl.setAttribute("label",t.value);else if("href"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.href=t.value;else if("rel"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.rel=t.value;else if("target"===t.key&&"A"===t.proxy.labelEl.nodeName)t.proxy.labelEl.target=t.value;else if("expanded"===t.key)super.toggleArrow(attrValBool(t.value),t.proxy);else if("disabled"===t.key)t.proxy.wrapEl.toggleAttribute("disabled",attrValBool(t.value));else if("readonly"===t.key)t.proxy.headEl.toggleAttribute("readonly",attrValBool(t.value));else if("checked"===t.key){let e=attrValBool(t.value);t.proxy.headEl.toggleAttribute("checked",e),t.proxy.checkEl.setAttribute("check",e?"ed":"")}else"children"===t.key&&(!t.raw&&t.value||t.raw&&t.value)},onDeleted:t=>{"children"===t.key&&S.parentToChild(t.proxy)},onCompleted:t=>{if(t.keys.set.includes("checked")&&this.updateVals(),this.options.storName){let t={check:{value:S.getBoolItems(this.flatData,"checked").map((t=>t.id))},expand:S.getBoolItems(this.flatData,"expanded").map((t=>t.id)),disable:S.getBoolItems(this.flatData,"disabled").map((t=>t.id)),readonly:S.getBoolItems(this.flatData,"readonly").map((t=>t.id)),content:isEmpty(this.options.content)?"":deepClone(this.treeDataOrig)};super.updateCache(t)}}}),this.observeIns}initExpandeds(){let t=valToArr(this.options.expand.value).map((t=>findItem(t,this.flatData))).filter(Boolean),e=this.flatData.filter((t=>attrValBool(t.expanded))),s=[...e,...t];for(let t of e)t.expanded=!1;this.options.expand.all?super.expandAll():super.expand(s)}renderData(t){for(let e of t)this.createHeadEl(e),this.createBodyEl(e),e.wrapEl.append(e.headEl,e.bodyEl),this.targetEl.appendChild(e.wrapEl);this.inputEl=createEl("input",{type:"hidden",name:this.options.name}),this.options.name&&this.targetEl.insertAdjacentElement("afterbegin",this.inputEl)}updateArrowEl(t){t.arrowEl&&(t.arrowEl.setAttribute("type",this.options.arrow.type),this.options.lang.title.arrow&&t.arrowEl.setAttribute("title",this.options.lang.title.arrow),"image"===this.options.arrow.type?this.options.arrow.hide&&(t.arrowEl.style.backgroundImage=`url("${this.options.arrow.hide}")`):(t.arrowEl.classList.remove(`${s.prefix}none`),this.options.arrow.hide&&t.arrowEl.classList.add(this.options.arrow.hide)))}createHeadEl(t){if(!t.wrapEl){if(t.wrapEl=createEl("section",{class:`${s.prefix}accordion-wrap`}),t.headEl?t.labelEl||(t.labelEl=createEl(t.hasOwnProperty("href")?"a":"i",{[s.alias]:"label"},t.label),t.headEl.appendChild(t.labelEl)):(t.headEl=createEl("div",{class:`${s.prefix}accordion-head`}),!t.labelEl&&(t.labelEl=createEl(t.hasOwnProperty("href")?"a":"i",{[s.alias]:"label"},t.label)),t.headEl.appendChild(t.labelEl)),t.wrapEl.appendChild(t.headEl),t.href&&(t.labelEl.href=t.href),t.target&&(t.labelEl.target=t.target),t.groupEl=createEl("div",{[s.alias]:"group"}),super.getArrowEl(t),t.iconEl||(t.iconEl=t.hasOwnProperty("icon")?createEl("i",{[s.alias]:"icon",class:t.icon}):null),t.diskEl||(t.diskEl=t.hasOwnProperty("disk")?createEl("img",{[s.alias]:"disk",src:t.disk||s.images.none}):null),t.cubeEl||(t.cubeEl=t.hasOwnProperty("cube")?createEl("img",{[s.alias]:"cube",src:t.cube||s.images.none}):null),t.imageEl||(t.imageEl=t.hasOwnProperty("image")?createEl("img",{[s.alias]:"image",src:t.image||s.images.none}):null),t.badgeEl||(t.badgeEl=t.badge?createEl("ax-badge",{[s.alias]:"badge",label:t.badge.toString().trim()}):null),t.tipsEl||(t.tipsEl=t.tips?createEl("i",{[s.alias]:"tips"},t.tips):null),t.customEl||(t.customEl=t.custom?createEl("div",{[s.alias]:"custom"},t.custom):null),attrValBool(t.expanded)&&t.headEl.toggleAttribute("expanded",!0),attrValBool(t.disabled)&&t.headEl.toggleAttribute("disabled",!0),attrValBool(t.readonly)&&t.headEl.toggleAttribute("readonly",!0),attrValBool(t.checked)&&t.headEl.toggleAttribute("checked",!0),this.options.check.enable&&(t.checkEl=createEl(`ax-${this.options.check.type}`,{[s.alias]:"check"})),this.options.tools.enable){t.toolsEl=createTools(this.options.tools.children,t.headEl),t.toolsEl.setAttribute(s.alias,"tools"),t.tools=deepClone(this.options.tools.children);for(let e of t.tools)this.options.lang.title[e.name]&&e.wrapEl.setAttribute("title",this.options.lang.title[e.name]),"add"===e.name?t.addEl=e.wrapEl:"remove"===e.name?t.removeEl=e.wrapEl:"edit"===e.name&&(t.editEl=e.wrapEl)}super.parseLayout(t.headEl,this.options.layout,{arrow:t.arrowEl,label:t.labelEl,check:t.checkEl,icon:t.iconEl,disk:t.diskEl,cube:t.cubeEl,badge:t.badgeEl,tips:t.tipsEl,custom:t.customEl,tools:t.toolsEl,group:t.groupEl})}}createBodyEl(t){t.bodyEl=createEl("div",{class:`${s.prefix}accordion-body`}),!t.contEl&&(t.contEl=createEl("div",{class:`${s.prefix}accordion-cont`})),t.bodyEl.appendChild(t.contEl),!t.extraEl&&t.hasOwnProperty("extra")&&(t.extraEl=createEl("div",{class:`${s.prefix}accordion-extra`})),t.extraEl&&t.bodyEl.appendChild(t.extraEl),!this.options.deferred&&this.setContExtra(t,!0),t.headEl.insertAdjacentElement("afterend",t.bodyEl)}setAttrs(){this.targetEl.classList.add(`${s.prefix}accordion`),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.toggleAttribute("inert",this.options.passive),this.targetEl.setAttribute("tools-trigger",this.options.tools.trigger),this.options.lamp.enable?this.targetEl.setAttribute("lamp",this.options.lamp.placement):this.targetEl.removeAttribute("lamp");for(let t in this.options.appear){let e=this.options.appear[t];this.targetEl.toggleAttribute(t,e)}}updateExpandEvt(t){this.options.arrow.enable&&("click"===this.options.arrow.trigger?(t.arrowEl.removeEventListener("click",this.expandEvt),t.arrowEl.addEventListener("click",this.expandEvt,!1)):"hover"===this.options.arrow.trigger&&(t.hoverIns&&t.hoverIns.destroy(),t.hoverIns=new Hover(t.arrowEl,{onMove:e=>{!e&&this.options.expand.only&&super.collapse(t)},onEnter:()=>{super.expand(t)},onLeave:()=>{super.collapse(t)}})))}updateEvt(t){if(this.updateExpandEvt(t),t.toolsEl){t.removeEl&&(t.removeEl.onclick=()=>{attrValBool(t.readonly)||this.remove(t)}),t.editEl&&(t.editEl.onclick=()=>{attrValBool(t.readonly)||this.inputLabelCont(t)}),t.addEl&&(t.addEl.onclick=()=>{attrValBool(t.readonly)||this.add({target:t})});for(let[e,s]of this.options.tools.children.entries()){let i=t.tools[e],a={ins:this,item:t};s.action&&s.action.call(a,i),i.action&&i.action.call(a,i)}}["expanded","checked"].includes(this.options.clickLine)&&(t.headEl.removeEventListener("click",this.lineEvt),t.headEl.addEventListener("click",this.lineEvt,!1)),attrValBool(t.disabled)&&t.headEl.toggleAttribute("disabled",!0),attrValBool(t.readonly)&&t.headEl.toggleAttribute("readonly",!0),this.options.check.enable&&t.checkEl.on("check",(e=>{let s=attrValBool(e.checked);!this.chainChecking&&s!==attrValBool(t.checked)&&this.check(t,s)})),this.options.drag.enable,t.action&&t.action.call(this,t)}renderFinish(){for(let t of this.flatData)this.updateEvt(t)}getTriggerEl(t){return t.href&&t.arrowEl?t.arrowEl:t.headEl}addTrigger(t,e){if(attrValBool(t.disabled))return;let s=e||this.getTriggerEl(t);"click"===this.options.arrow.trigger?(s.removeEventListener("click",this.expandEvt),s.addEventListener("click",this.expandEvt,!1)):"hover"===this.options.arrow.trigger&&(this.hoverIns&&this.hoverIns.destroy(),this.hoverIns=new Hover(t.wrapEl,{onEnter:()=>{super.expand(t),super.listen({name:"trigger",params:[t]})},onLeave:()=>{super.collapse(t)}}))}removeTrigger(t,e){if(attrValBool(t.disabled))return;let s=e||this.getTriggerEl(t);"click"===this.options.arrow.trigger?s.removeEventListener("click",this.expandEvt):"hover"===this.options.arrow.trigger&&this.hoverIns&&this.hoverIns.destroy()}toggleExpanded(t){if(this.destroyed)return;let e=findItem(t,this.flatData);e&&(attrValBool(e.expanded)?super.collapse(e):super.expand(e),super.listen({name:"trigger",params:[e]}))}async setContExtra(t,e=!1){await super.getElCont({target:t,data:t.content,prop:"content",cb:s=>{s!==t.content?(t.content=s,e&&super.updateElCont(t,s,"content")):super.updateElCont(t,s,"content")}}),t.extraEl&&await super.getElCont({target:t,data:t.extra,prop:"extra",cb:s=>{s!==t.extra?(t.extra=s,e&&super.updateElCont(t,s,"extra")):super.updateElCont(t,s,"extra")}})}async eachCollapse(t,e){if(isNull(t))return;try{if(this.options.b4Collapse){let e=await this.options.b4Collapse.call(this,t);e&&(t=e)}}catch(t){return}let s=findItem(t,this.flatData);s&&(super.listen({name:"collapse",cb:e,params:[s]}),s.expanded=!1,slideUp({el:s.bodyEl,duration:this.options.duration,done:()=>{super.listen({name:"collapsed",cb:e,params:[s]})}}))}async eachExpand(t,e){if(isNull(t))return;try{if(this.options.b4Expand){let e=await this.options.b4Expand.call(this,t);e&&(t=e)}}catch(t){return}let s=findItem(t,this.flatData);if(s&&(super.listen({name:"expand",cb:e,params:[s]}),this.options.deferred&&!s.contEl.innerHTML&&(s.arrowEl&&s.arrowEl.toggleAttribute("spinning",!0),await this.setContExtra(s),s.arrowEl&&s.arrowEl.removeAttribute("spinning")),s.expanded=!0,slideDown({el:s.bodyEl,duration:this.options.duration,done:()=>{super.listen({name:"expanded",cb:e,params:[s]})}}),this.options.expand.only)){let t=this.flatData.filter((t=>t!==s&&attrValBool(t.expanded)));for(let e of t)super.collapse(e)}}uncheckSibings(t){this.chainChecking=!0;let e=super.getSiblings(t).filter((t=>attrValBool(t.checked)));for(let t of e)t.checked=!1;this.chainChecking=!1}check(t,e=!0,s){if(this.destroyed)return;let i=(Array.isArray(t)?t:[t]).map((t=>findItem(t,this.flatData))).filter((t=>t&&!attrValBool(t.checked)===e)),fn=t=>{t.checked=e,e&&"radio"===this.options.check.type&&this.uncheckSibings(t)};if(i.length){for(let t of i)fn(t);return super.listen({name:e?"checked":"unchecked",cb:s,params:[i]}),this}}checkAll(t){if(!this.destroyed&&this.options.check.enable&&"checkbox"===this.options.check.type){if("checkbox"===this.options.check.type)this.check(this.flatData,!0);else{!this.flatData.find((t=>attrValBool(t.checked)))&&this.check(this.flatData[0],!0)}return super.listen({name:"checkedAll",cb:t}),this}}async add(t){if(this.destroyed)return;let e=Object.assign({repeat:!0,autoFill:!0,isFront:!1},t),s=getDataType(e.data),i=findItem(e.target,this.flatData),a=[],l=[],appendFun=t=>{let s=S.createBranchObj({source:t,flatData:this.flatData,target:i,isLeaf:!0,isChild:!1});this.createHeadEl(s),this.createBodyEl(s),S.addBranch({source:s,rootEl:this.targetEl,flatData:this.flatData,treeData:this.treeData,brother:i,isFront:e.isFront,repeat:e.repeat,autoFill:e.autoFill,cb:t=>{l.push(t),this.updateEvt(t)}})};a=isNull(e.data)?[null]:"Array"===s&&e.data.length>0?e.data:[e.data];for(let t of a){try{if(this.options.b4Add){let e=await this.options.b4Add.call(this,t);e&&(t=e)}}catch(t){continue}appendFun(t)}return super.listen({name:"added",cb:e.cb,params:[l]}),this}async remove(t,e){if(this.destroyed||isNull(t))return;if(0===this.flatData.length)return;let s=[],i=[],removeItem=t=>{S.removeBranch({source:t,flatData:this.flatData,treeData:this.treeData,remove:!1,cb:t=>{i.push(t)}})};s=Array.isArray(t)?t:[t];for(let t of s){try{if(this.options.b4Remove){let e=await this.options.b4Remove.call(this,t);e&&(t=e)}}catch(t){continue}removeItem(t)}return super.listen({name:"removed",cb:e,params:[i]}),this}inputLabelCont(t){}async edit(t,e,s){if(this.destroyed||isNull(t)||isEmpty(e))return this;let i=findItem(t,this.flatData);if(!i)return this;for(let t in e){let s=e[t];try{if(this.options.b4Edit){let e=await this.options.b4Edit.call(this,{key:t,value:s},i);e&&(s=e)}"action"===t?i[t]=s.call({ins:this,item:t},i):["icon","disk","cube","href","target","rel","label","content","tips","badge"].includes(t)&&(i[t]=s)}catch(t){return this}}return super.listen({name:"edited",cb:s,params:[i]}),this}async graft({source:t,target:e,isFront:s=!0,isChild:i=!0,cb:a}){if(this.destroyed||isNull(t))return;try{if(this.options.b4Graft){let s=await this.options.b4Graft.call(this,t,e);s&&s.source&&(t=s.source),s&&s.target&&(t=s.target)}}catch(t){return this}let l=findItem(t,this.flatData,"",{node:"wrapEl"}),n=findItem(e,this.flatData);return l?(S.graftBranch({source:l,target:n,isFront:s,isChild:i,flatData:this.flatData,treeData:this.treeData,rootEl:this.targetEl,cb:t=>(super.listen({name:"grafted",cb:a,params:[t]}),this)}),this):void 0}updateVals(){if(!this.options.output.enable)return;let t=this.getVals();this.options.name&&(this.inputEl.value=t),E.setVals({target:this.receiver,value:t})}setVals(t=this.receiver,e){if(this.destroyed)return;let s=getEl(t),i=this.getVals();return E.setVals({target:s,value:i}),super.listen({name:"set",cb:e,params:[i]}),this}clearVals(t){return this.destroyed||(super.uncheckAll(),this.value="",E.setVals({target:this.receiver,value:""}),this.options.name&&(this.inputEl.value=""),super.listen({name:"cleared",cb:t})),this}getVals(t={},e){if(this.destroyed)return this;let s=Object.assign({...this.options.output,isStr:!0},t),i=super.getCheckeds().map((t=>t[s.prop])),a=s.isStr?i.join(s.separator):i;return super.listen({name:"got",cb:e,params:[a]}),a}async setContent(t,e={},s){if(!this.destroyed)return await super.setElCont({item:t,data:e,prop:"content",cb:(t,e)=>{super.listen({name:"filled",cb:s,params:[t,e]})}}),this}async updateCont(t,e){return this.destroyed||await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})},cb:s=>{Array.isArray(s)&&(this.treeDataOrig=deepClone(s),S.addIdPath({source:this.treeDataOrig}),this.targetEl.innerHTML="",this.renderData(this.treeDataOrig),this.getTreeFlat(),this.renderFinish(),super.updateCache({content:t}),super.listen({name:"updatedCont",cb:e,params:[this.treeDataOrig]}))}}),this}destroy(t){if(this.destroyed)return this;for(let t of this.flatData){if("click"===this.options.arrow.trigger){(t.hasOwnProperty("href")&&t.arrowEl?t.arrowEl:t.headEl).removeEventListener("click",this.expandEvt)}else"hover"===this.options.arrow.trigger&&this.hoverIns.destroy();["expanded","checked"].includes(this.options.clickLine)&&t.headEl.removeEventListener("click",this.lineEvt),this.options.drag.enable&&t.dragIns.destroy()}return this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const ft=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:""},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"disabled",prop:"disabled",value:!1},{attr:"readonly",prop:"readonly",value:!1},{attr:"deferred",prop:"deferred",value:!1},{attr:"delay",prop:"delay",value:200},{attr:"classes",prop:"classes",value:""},{attr:"appear",prop:"appear",value:{rounded:!0,bordered:!0}},{attr:"mode",prop:"mode",value:"editor"},{attr:"header",prop:"header",value:{enable:!0,children:[]}},{attr:"footer",prop:"footer",value:{enable:!0}},{attr:"min-height",prop:"minHeight",value:""},{attr:"max-height",prop:"maxHeight",value:""},{attr:"feature",prop:"feature",value:"simple"},{attr:"b4-paste",prop:"b4Paste",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-readonly",prop:"onReadonly",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-output",prop:"onOutput",value:null},...p];class Editor extends ModBaseListenCache{options={};flatData;treeData;inputEl;headEl;bodyEl;contEl;footEl;pathEl;stateEl;maskEl;toolsEl;output;tmpRaw;contXhr;keyupEvt;pointerEvt;inputEvt;pasteEvt;readonlyEvt;tools;static hostType="node";static optMaps=ft;constructor(t,e={},i=!0){super();let a,l=getEl(t);if(!l)return this;["TEXTAREA"].includes(l.nodeName)?(this.inputEl=l,this.inputEl.classList.add(`${s.prefix}editor-source`),a=createEl("div",{class:`${s.prefix}editor`}),l.insertAdjacentElement("afterend",a)):(a=l,a.classList.add(`${s.prefix}editor`),this.inputEl=createEl("textarea",{class:`${s.prefix}editor-source`})),super.ready({options:e,host:a,maps:Editor.optMaps,component:!0,spread:["header","footer"]}),this.rawHtml=this.inputEl.value||this.targetEl.innerHTML,this.contEl=createEl("div",{class:`${s.prefix}editor-cont`,placeholder:this.options.lang.placeholder,contenteditable:!0});let n=this;this.keyupEvt=debounce((t=>{"Backspace"===t.key&&(["<br>","<p><br></p>","<div><br></div>"].includes(trim(this.contEl.innerHTML,"global"))&&(this.contEl.innerHTML=""),this.updateInputVal())}),this.options.delay),this.pointerEvt=()=>{this.setPathInfo()},this.inputEvt=debounce((function(t){this===n.contEl?n.inputEl.value=n.contEl.innerHTML:this===n.inputEl&&(n.contEl.innerHTML=n.inputEl.value),n.output.value=n.inputEl.value,n.updateInfo()}),{delay:this.options.delay}),this.pasteEvt=async function(t){let e="";if(n.options.b4Paste){if(t.preventDefault(),e=await n.options.b4Paste.call(n,await navigator.clipboard.readText()),e){let t=window.getSelection();if(t.rangeCount>0){let s=t.getRangeAt(0),i=document.createTextNode(e);s.insertNode(i),s.setStartAfter(i),s.collapse(!0),t.removeAllRanges(),t.addRange(s)}}}else e=await navigator.clipboard.readText();n.listen({name:"pasted",params:[e]}),this===n.contEl?n.inputEl.value=n.contEl.innerHTML:this===n.inputEl&&(n.contEl.innerHTML=n.inputEl.value),n.output.value=n.inputEl.value,n.updateInfo()},this.readonlyEvt=t=>{t.preventDefault()},this.tools=[...this.createToggleItems([{name:"bold",icon:`${s.prefix}icon-bold`,key:"fontWeight",value:"bold",tips:this.options.lang.tips.bold},{name:"italic",icon:`${s.prefix}icon-italic`,key:"fontStyle",value:"italic",tips:this.options.lang.tips.italic},{name:"underline",icon:`${s.prefix}icon-underline`,key:"textDecorationLine",value:"underline",tips:this.options.lang.tips.underline},{name:"through",icon:`${s.prefix}icon-through`,key:"textDecorationLine",value:"line-through",tips:this.options.lang.tips.through}]),...this.createFontsizeItems([{name:"fontsize-dft",label:this.options.lang.fontsizeDft,value:""},{name:"1.2rem",label:"12px/1.2rem",value:"1.2rem"},{name:"1.4rem",label:"14px/1.4rem",value:"1.4rem"},{name:"1.6rem",label:"16px/1.6rem",value:"1.6rem"},{name:"1.8rem",label:"18px/1.8rem",value:"1.8rem"},{name:"2.2rem",label:"22px/2.2rem",value:"2.2rem"},{name:"2.8rem",label:"2.8px/2.8rem",value:"2.8rem"},{name:"3.2rem",label:"32px/3.2rem",value:"3.2rem"},{name:"3.8rem",label:"38px/3.8rem",value:"3.8rem"},{name:"4.2rem",label:"42px/4.2rem",value:"4.2rem"},{name:"4.8rem",label:"48px/4.8rem",value:"4.8rem"}]),...this.createAlignItems([{name:"align-dft",label:this.options.lang.alignDft,value:""},{name:"align-left",icon:`${s.prefix}icon-align-left`,value:"left",tips:this.options.lang.tips.alignLeft},{name:"align-center",icon:`${s.prefix}icon-align-center`,value:"center",tips:this.options.lang.tips.alignCenter},{name:"align-right",icon:`${s.prefix}icon-align-right`,value:"right",tips:this.options.lang.tips.alignRight},{name:"align-justify",icon:`${s.prefix}icon-align-justify`,value:"justify",tips:this.options.lang.tips.alignJustify}]),...this.createSpanTags([{name:"sup",icon:`${s.prefix}icon-superscript`,value:"sup",tips:this.options.lang.tips.sup},{name:"sub",icon:`${s.prefix}icon-subscript`,value:"sub",tips:this.options.lang.tips.sub},{name:"highlight",icon:`${s.prefix}icon-highlight`,value:"mark",tips:this.options.lang.tips.highlight},{name:"cite",icon:`${s.prefix}icon-quote-left`,value:"cite",tips:this.options.lang.tips.cite},{name:"code-inline",icon:`${s.prefix}icon-code-inline`,value:"code",tips:this.options.lang.tips.codeInline},{name:"em",label:this.options.lang.tips.em,value:"em"},{name:"address",label:this.options.lang.tips.address,value:"address"},{name:"time",label:this.options.lang.tips.time,value:"time"},{name:"ruby",label:this.options.lang.tips.ruby,value:"ruby"},{name:"rt",label:this.options.lang.tips.rt,value:"rt"}]),...this.createLineTags([{name:"p",icon:`${s.prefix}icon-article`,value:"p",tips:this.options.lang.tips.text},{name:"h1",icon:`${s.prefix}icon-heading-1`,value:"h1",tips:this.options.lang.tips.h1},{name:"h2",icon:`${s.prefix}icon-heading-2`,value:"h2",tips:this.options.lang.tips.h2},{name:"h3",icon:`${s.prefix}icon-heading-3`,value:"h3",tips:this.options.lang.tips.h3},{name:"h4",icon:`${s.prefix}icon-heading-4`,value:"h4",tips:this.options.lang.tips.h4},{name:"h5",icon:`${s.prefix}icon-heading-5`,value:"h5",tips:this.options.lang.tips.h5},{name:"h6",icon:`${s.prefix}icon-heading-6`,value:"h6",tips:this.options.lang.tips.h6},{name:"blockquote",icon:`${s.prefix}icon-quote-left-f`,value:"blockquote",tips:this.options.lang.tips.blockquote}]),...this.createCloseTags([{name:"hr",icon:`${s.prefix}icon-line-h`,value:"hr",tips:this.options.lang.tips.hr},{name:"br",icon:`${s.prefix}icon-br`,value:"br",tips:this.options.lang.tips.br}]),...this.createNestTags([{name:"code-block",icon:`${s.prefix}icon-code-block`,value:["pre","code"],tips:this.options.lang.tips.codeBlock},{name:"list-ul",icon:`${s.prefix}icon-list-ul`,value:["ul","li","br"],tips:this.options.lang.tips.listUl},{name:"list-ol",icon:`${s.prefix}icon-list-ol`,value:["ol","li","br"],tips:this.options.lang.tips.listOl},{name:"paragraph",icon:`${s.prefix}icon-paragraph`,value:["div","br"],tips:this.options.lang.tips.paragraph,isRoot:!0}]),{name:"indent-more",icon:`${s.prefix}icon-indent-more`,tips:this.options.lang.tips.indentMore,action:t=>{t.wrapEl.onpointerdown=t=>{t.preventDefault(),this.setLineStyles("","",(t=>{let e=style(t).textIndent;t.style.textIndent=`${toPixel(e)+toPixel("2.8rem")}px`}))}}},{name:"indent-less",icon:`${s.prefix}icon-indent-less`,tips:this.options.lang.tips.indentLess,action:t=>{t.wrapEl.onpointerdown=t=>{t.preventDefault(),this.setLineStyles("","",(t=>{let e=style(t).textIndent,s=Math.max(0,toPixel(e)-toPixel("2.8rem"));t.style.textIndent=`${s}px`}))}}},{name:"dropdown-fontsize",label:this.options.lang.fontsizeDft,extendable:!0,action:t=>{let e=[{label:this.options.lang.fontsizeDft,value:""},{label:"12px/1.2rem",value:"1.2rem"},{label:"14px/1.4rem",value:"1.4rem"},{label:"16px/1.6rem",value:"1.6rem"},{label:"18px1.8rem",value:"1.8rem"},{label:"22px/2.2rem",value:"2.2rem"},{label:"28px/2.8rem",value:"2.8rem"},{label:"32px/3.2rem",value:"3.2rem"},{label:"38px/3.8rem",value:"3.8rem"},{label:"42px/4.2rem",value:"4.2rem"},{label:"48px/4.8rem",value:"4.8rem"}];new Dropdown(t.wrapEl,{content:e.map((t=>t.label)),feature:"select",popup:{onTargetSet:t=>{this.setStyles("fontSize",e.find((e=>e.label===t)).value)}}})}},{name:"dropdown-align",label:this.options.lang.alignDft,extendable:!0,action:t=>{let e=[{label:this.options.lang.alignDft,value:""},{label:this.options.lang.tips.alignLeft,icon:`${s.prefix}icon-align-left`,value:"left"},{label:this.options.lang.tips.alignCenter,icon:`${s.prefix}icon-align-center`,value:"center"},{label:this.options.lang.tips.alignRight,icon:`${s.prefix}icon-align-right`,value:"right"},{label:this.options.lang.tips.alignJustify,icon:`${s.prefix}icon-align-justify`,value:"justify"}];new Dropdown(t.wrapEl,{content:e.map((t=>t.label)),feature:"select",popup:{onTargetSet:t=>{this.setLineStyles("textAlign",e.find((e=>e.label===t)).value)}}})}},{name:"dropdown-heading",label:this.options.lang.tips.text,extendable:!0,action:t=>{let e=[{label:this.options.lang.tips.text,value:"p"},{label:this.options.lang.tips.h1,icon:`${s.prefix}icon-heading-1`,value:"h1"},{label:this.options.lang.tips.h2,icon:`${s.prefix}icon-heading-2`,value:"h2"},{label:this.options.lang.tips.h3,icon:`${s.prefix}icon-heading-3`,value:"h3"},{label:this.options.lang.tips.h4,icon:`${s.prefix}icon-heading-1`,value:"h4"},{label:this.options.lang.tips.h5,icon:`${s.prefix}icon-heading-5`,value:"h5"},{label:this.options.lang.tips.h6,icon:`${s.prefix}icon-heading-6`,value:"h6"}];new Dropdown(t.wrapEl,{content:e.map((t=>t.label)),feature:"select",popup:{onTargetSet:t=>{this.replaceLineTag(e.find((e=>e.label===t)).value)}}})}},{name:"dropdown-tags",label:this.options.lang.tagsDft,extendable:!0,action:t=>{let e=[{label:this.options.lang.tips.em,value:"em"},{label:this.options.lang.tips.address,value:"address"},{label:this.options.lang.tips.time,value:"time"},{label:this.options.lang.tips.ruby,value:"ruby"},{label:this.options.lang.tips.rt,value:"rt"}];new Dropdown(t.wrapEl,{content:e.map((t=>t.label)),feature:"button",popup:{trigger:"hover"},action:t=>{t.el.onclick=s=>{s.preventDefault(),this.addWraps(e.find((e=>e.label===t.data.label)).value)}}})}},{name:"source",icon:`${s.prefix}icon-code-box`,swap:`${s.prefix}icon-html-box`,tips:this.options.lang.tips.source,action:t=>{t.wrapEl.onpointerdown=e=>{e.preventDefault(),"source"===this.targetEl.getAttribute("mode")?(this.targetEl.setAttribute("mode","editor"),t.wrapEl.toggleAttribute("focused",!1),classes(t.iconEl).replace(t.icon,t.swap)):(this.targetEl.setAttribute("mode","source"),t.wrapEl.toggleAttribute("focused",!0),classes(t.iconEl).replace(t.swap,t.icon))}}}],super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.output={value:"",raw:""},this.tmpRaw="",super.useTpl(),this.renderMain(),this.setAttrs(),!this.options.deferred&&await this.fillCont(this.options.content||this.options.value||this.rawHtml),this.renderFinish(),this.contEl.addEventListener("input",this.inputEvt,!1),this.inputEl.addEventListener("input",this.inputEvt,!1),this.contEl.addEventListener("paste",this.pasteEvt,!1),this.inputEl.addEventListener("paste",this.pasteEvt,!1),this.contEl.addEventListener("keyup",this.keyupEvt,!1),this.contEl.addEventListener("pointerdown",this.pointerEvt,!1),super.listen({name:"initiated",cb:t}),this}insertNewPara(t,e,s){t===this.contEl?this.contEl.insertBefore(e,s!==this.contEl&&s?s.nextSibling:null):t.parentNode.insertBefore(e,t.nextSibling)}getTools(){return isEmpty(this.options.header.children)?"simple"===this.options.feature?["bold","align-left","align-center","align-right","highlight","p","h1","h2","h3","hr","br","paragraph","indent-more","indent-less","source"].map((t=>this.tools.find((e=>e.name===t)))):"comm"===this.options.feature?["bold","italic","underline","through","align-left","align-center","align-right","highlight","cite","blockquote","code-inline","code-block","p","h1","h2","h3","hr","br","list-ul","list-ol","paragraph","indent-more","indent-less","source"].map((t=>this.tools.find((e=>e.name===t)))):"flat"===this.options.feature?this.tools.filter((t=>!t.name.includes("dropdown-")&&!t.name.includes("group-"))):"group"===this.options.feature?this.tools.filter((t=>t.name.includes("dropdown-")||t.name.includes("group-"))):this.tools:this.options.header.children.map((t=>this.tools.find((e=>e.name===t))||t))}renderMain(){this.targetEl.innerHTML="",this.headEl=createEl("div",{class:`${s.prefix}editor-head`}),this.inputEl.placeholder=this.options.lang.placeholder,this.options.name&&(this.inputEl.name=this.options.name),this.bodyEl=createEl("div",{class:`${s.prefix}editor-body`}),this.bodyEl.append(this.contEl,this.inputEl),this.pathEl=createEl("div",{class:`${s.prefix}editor-path`}),this.stateEl=createEl("div",{class:`${s.prefix}editor-state`}),this.footEl=createEl("div",{class:`${s.prefix}editor-foot`}),this.footEl.append(this.pathEl,this.stateEl),this.maskEl=createEl("div",{class:`${s.prefix}editor-mask`},this.options.lang.defer),this.options.header.enable&&(this.toolsEl=createTools(this.getTools(),this.headEl),this.targetEl.appendChild(this.headEl)),this.targetEl.appendChild(this.bodyEl),this.options.footer.enable&&this.targetEl.appendChild(this.footEl),this.options.deferred&&this.bodyEl.appendChild(this.maskEl),this.updateInfo()}updateInfo(){this.setPathInfo(),this.setStateInfo(),this.output={value:this.inputEl.value,raw:this.tmpRaw},super.listen({name:"output",params:[this.output]}),this.tmpRaw=this.inputEl.value}setPathInfo(t=document.getSelection()){if(!t.rangeCount)return void(this.pathEl.innerHTML=this.options.lang.path+" -");let e=t.getRangeAt(0).startContainer,s=[];if(this.isValidRange(e)){for(;e&&this.isValidRange(e);)s.unshift(e.nodeName.toLowerCase()),e=e.parentNode;this.pathEl.innerHTML=this.options.lang.path+" "+s.join(" › ")}}setStateInfo(){let t=this.contEl.textContent.replace(/\s/g,"").length,e=this.contEl.childNodes.length,s=this.contEl.innerHTML;this.stateEl.innerHTML=this.options.lang.chars+" "+ +t+" , "+this.options.lang.paras+" "+ +e,super.updateCache({content:s}),super.listen({name:"edited",params:[s]})}setAttrs(){this.targetEl.classList.add(`${s.prefix}editor`),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.options.readonly?this.readonly():this.enable(),this.targetEl.toggleAttribute("inert",this.options.disabled),this.targetEl.setAttribute("mode",this.options.mode),this.options.minHeight?addStyle(this.contEl,"max-height",this.options.minHeight):removeStyle(this.contEl,"max-height");for(let t in this.options.appear){let e=this.options.appear[t];this.targetEl.toggleAttribute(t,e)}this.targetEl.toggleAttribute("deferred",this.options.deferred)}readonly(){this.headEl.toggleAttribute("inert",!0),this.contEl.addEventListener("keydown",this.readonlyEvt),this.contEl.addEventListener("paste",this.readonlyEvt),this.contEl.addEventListener("drop",this.readonlyEvt,!1),this.inputEl.addEventListener("keydown",this.readonlyEvt,!1),this.inputEl.addEventListener("paste",this.readonlyEvt,!1),this.inputEl.addEventListener("drop",this.readonlyEvt,!1),this.inputEl.readOnly=!0,super.listen({name:"readonly"})}disable(){this.headEl.toggleAttribute("inert",!0),this.targetEl.toggleAttribute("inert",!0),this.contEl.addEventListener("keydown",this.readonlyEvt,!1),this.contEl.addEventListener("paste",this.readonlyEvt,!1),this.contEl.addEventListener("drop",this.readonlyEvt,!1),this.inputEl.addEventListener("keydown",this.readonlyEvt,!1),this.inputEl.addEventListener("paste",this.readonlyEvt,!1),this.inputEl.addEventListener("drop",this.readonlyEvt,!1),this.inputEl.readOnly=!0,super.listen({name:"disabled"})}enable(){this.headEl.toggleAttribute("inert",!1),this.targetEl.toggleAttribute("inert",!1),this.contEl.removeEventListener("keydown",this.readonlyEvt),this.contEl.removeEventListener("paste",this.readonlyEvt),this.contEl.removeEventListener("drop",this.readonlyEvt),this.inputEl.removeEventListener("keydown",this.readonlyEvt),this.inputEl.removeEventListener("paste",this.readonlyEvt),this.inputEl.removeEventListener("drop",this.readonlyEvt),this.inputEl.readOnly=!1,super.listen({name:"enabled"})}renderFinish(){this.options.deferred&&(this.maskEl.onclick=async()=>{await this.fillCont(this.options.content||this.options.value),this.targetEl.removeAttribute("deferred"),this.maskEl.remove()})}fullTextNode(t){let e=t.startContainer;if(e===t.endContainer){if(3===e.nodeType){const s=e.textContent;return 0===t.startOffset&&t.endOffset===s.length}return 1===e.nodeType&&(0===t.startOffset&&1===t.endOffset)}return!1}setChildRange(t,e=document.getSelection()){let s=document.createRange();t.firstChild&&t.lastChild&&(s.setStartBefore(t.firstChild),s.setEndAfter(t.lastChild),e.removeAllRanges(),e.addRange(s))}setStyles(t,e,s=document.getSelection()){if(s.rangeCount>0){for(let i=0;i<s.rangeCount;i++){let a=s.getRangeAt(i),l=a.startContainer;if(!this.isValidRange(l))continue;let n=this.fullTextNode(a)?1===l.nodeType?l:l.parentNode:this.addOneWrap("i",a);n.style[t]=e,this.setChildRange(n,s)}this.updateInputVal()}}getParentNode(t){let e=t.commonAncestorContainer;return 1!==e.nodeType?e.parentNode:e}removeStyles(t,e=document.getSelection()){if(e.rangeCount>0)for(let s=0;s<e.rangeCount;s++){let i=e.getRangeAt(s),a=i.startContainer;if(!this.isValidRange(a))continue;let l=this.getParentNode(i);l&&(l.style[t]=null)}}toggleStyles(t,e,s=document.getSelection()){if(s.rangeCount>0){for(let i=0;i<s.rangeCount;i++){let a=s.getRangeAt(i),l=a.startContainer;if(!this.isValidRange(l))continue;let n=this.getParentNode(a);if(n&&n.style[t])n.style[t]=null;else{let i=this.fullTextNode(a)?1===l.nodeType?l:l.parentNode:this.addOneWrap("i",a);i.style[t]=e,this.setChildRange(i,s)}}this.updateInputVal()}}addOneWrap(t,e){let s=e.extractContents(),i=document.createElement(t);return i.appendChild(s),e.insertNode(i),i}addWraps(t,e=document.getSelection()){if(!e.rangeCount)return;let s;for(let i=0;i<e.rangeCount;i++){let a=e.getRangeAt(i),l=a.startContainer;if(!this.isValidRange(l))continue;let n=this.getParentNode(a);if(n&&n.nodeName===t.toUpperCase())continue;let r=this.addOneWrap(t,a);i===e.rangeCount-1&&(s=r)}s&&this.setChildRange(s,e),this.updateInputVal()}replaceLineTag(t,e=document.getSelection()){if(!e.rangeCount)return;let s=e.getRangeAt(0),i=s.startContainer,a=document.createElement(t),l=s.startOffset,n=document.createRange();if(!this.isValidRange(i))return;for(;i&&3===i.nodeType&&i.parentNode!==this.contEl;)i=i.parentNode;if(i?.tagName?.toLowerCase()===t)return;a.innerHTML=i.innerHTML||i.textContent,i.parentNode.replaceChild(a,i);let r=a.firstChild||a;try{n.setStart(r,l)}catch{n.setStart(r,0)}n.collapse(!0),e.removeAllRanges(),e.addRange(n),this.updateInputVal()}setLineStyles(t,e,s){let i=document.getSelection(),a=i.getRangeAt(0).startContainer,l=a?.parentNode;i.rangeCount&&this.isValidRange(a)&&l!==this.contEl&&(t&&(l.style[t]=e),this.updateInputVal(),s&&s(l))}createNestWrap(t){let e,s=document.createElement(t[0]);return t.slice(1).reduce(((s,i,a)=>{let l=document.createElement(i);return a===t.length-2&&(e=l),s.appendChild(l),l}),s),{root:s,leaf:e}}insertNestNodes(t,e=!1){if(!Array.isArray(t)||!t.length)return;let s=document.getSelection();if(!s)return;let i=s.getRangeAt(0),a=i.startContainer,{root:l,leaf:n}=this.createNestWrap(t),r=document.createRange();if(s.rangeCount&&this.isValidRange(a,!1)){if(e){let t=a,e=a;for(;t!==this.contEl;)e=t,t=t.parentNode;this.contEl.insertBefore(l,e===this.contEl?null:e.nextSibling)}else i.insertNode(l);r.setStart(n,0),r.collapse(!0),s.removeAllRanges(),s.addRange(r),this.updateInputVal()}}insertTag(t){let e=document.getSelection();if(!e.rangeCount||!this.isValidRange(null,!1))return;let s=e.getRangeAt(0),i=document.createElement(t);this.clearRanges(e),s.insertNode(i),s.setStartAfter(i),s.setEndAfter(i),e.removeAllRanges(),e.addRange(s),this.updateInputVal()}clearRanges(t=document.getSelection()){if(t.rangeCount>0)for(let e=0;e<t.rangeCount;e++){t.getRangeAt(e).deleteContents()}}isValidRange(t,e=!0){let s;if(t)s=t;else{s=document.getSelection().getRangeAt(0).startContainer}return this.contEl.contains(s)&&(!e||this.contEl!==s)}createFontsizeItems(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.setStyles("fontSize",t.value)}}})))}createToggleItems(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.toggleStyles(t.key,t.value)}}})))}createAlignItems(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.setLineStyles("textAlign",t.value)}}})))}createLineTags(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.replaceLineTag(t.value)}}})))}createSpanTags(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.addWraps(t.value)}}})))}createCloseTags(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.insertTag(t.value)}}})))}createNestTags(t){return t.map((t=>({name:t.name,label:t.label,tips:t.tips,icon:t.icon,action:e=>{e.wrapEl.onpointerdown=e=>{e.preventDefault(),this.insertNestNodes(t.value,t.isRoot)}}})))}async fillCont(t=this.options.content,e){if(isEmpty(t))return;let s,i=elState(this.maskEl).isVisible?{target:this.maskEl}:{spinSel:this.bodyEl};await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",...i,...this.options.ajax},request:t=>{super.listen({name:"request",params:[t]})},cb:async e=>{s=e,setContent({content:e,template:t?.tplStr||this.tplStr,engine:t?.tplEng||this.tplEng,target:this.contEl,prevent:t=>{getDataType(t).includes("HTML")?this.contEl.appendChild(t):this.contEl.innerHTML=t,this.inputEl.value=this.output.value=this.contEl.innerHTML,this.updateInfo()}})}}),super.listen({name:"filled",cb:e,params:[s]})}updateInputVal(){this.inputEl.value=this.output.value=this.contEl.innerHTML,this.updateInfo()}setVals(t,e){return this.destroyed||(this.inputEl.value=this.contEl.innerHTML=t,this.updateInfo(),super.listen({name:"set",cb:e,params:[t]})),this}getVals(){if(!this.destroyed)return this.contEl.innerHTML}clearVals(t){if(!this.destroyed)return this.inputEl.value=this.contEl.innerHTML="",this.updateInfo(),super.listen({name:"cleared",cb:t}),this}destroy(t){return this.destroyed||(this.contEl.removeEventListener("input",this.inputEvt),this.inputEl.removeEventListener("input",this.inputEvt),this.contEl.removeEventListener("keyup",this.keyupEvt),this.enable(),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const vt=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:""},{attr:"field",prop:"field",value:"label"},{attr:"type",prop:"type",value:"dropdown"},{attr:"manual",prop:"manual",value:!1},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"disabled",prop:"disabled",value:!1},{attr:"multiple",prop:"multiple",value:!1},{attr:"exclude",prop:"exclude",value:""},{attr:"readonly",prop:"readonly",value:!1},{attr:"full",prop:"full",value:!1},{attr:"min",prop:"min",value:0},{attr:"max",prop:"max",value:0},{attr:"sliced",prop:"sliced",value:!0},{attr:"removable",prop:"removable",value:!0},{attr:"max-height",prop:"maxHeight",value:""},{attr:"span",prop:"span",value:"leaf"},{attr:"unique",prop:"unique",value:!0},{attr:"collapse",prop:"collapse",value:!1},{attr:"size",prop:"size",value:"md"},{attr:"search",prop:"search",value:{enable:!1,value:"",fuzzy:!0,ignore:!0,result:!0}},{attr:"tools",prop:"tools",value:{enable:!1,children:["close"]}},{attr:"auto-width",prop:"autoWidth",value:!0},{attr:"status",prop:"status",value:!1},{attr:"tags",prop:"tags",value:{}},{attr:"popup",prop:"popup",value:{enable:!0}},{attr:"tree",prop:"tree",value:{}},{attr:"b4-expand",prop:"b4Expand",value:null},{attr:"b4-collapse",prop:"b4Collapse",value:null},{attr:"b4-add",prop:"b4Add",value:null},{attr:"b4-edit",prop:"b4Edit",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-graft",prop:"b4Graft",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-trigger",prop:"onTrigger",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-edited",prop:"onEdited",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-disabled",prop:"onDisabled",value:null},{attr:"on-enabled",prop:"onEnabled",value:null},{attr:"on-disabledall",prop:"onDisabledAll",value:null},{attr:"on-enabledall",prop:"onEnabledAll",value:null},{attr:"on-readonly",prop:"onReadonly",value:null},{attr:"on-readonlyall",prop:"onReadonlyAll",value:null},{attr:"on-expand",prop:"onExpand",value:null},{attr:"on-expanded",prop:"onExpanded",value:null},{attr:"on-collapse",prop:"onCollapse",value:null},{attr:"on-collapsed",prop:"onCollapsed",value:null},{attr:"on-expandall",prop:"onExpandAll",value:null},{attr:"on-expandedAll",prop:"onExpandedAll",value:null},{attr:"on-collapsedall",prop:"onCollapsedAll",value:null},{attr:"on-selected",prop:"onSelected",value:null},{attr:"on-deselected",prop:"onDeselected",value:null},{attr:"on-selectedall",prop:"onSelectedAll",value:null},{attr:"on-checked",prop:"onChecked",value:null},{attr:"on-unchecked",prop:"onUnchecked",value:null},{attr:"on-checkedall",prop:"onCheckedAll",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-turned",prop:"onTurned",value:null},{attr:"on-got",prop:"onGot",value:null},{attr:"on-set",prop:"onSet",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-grafted",prop:"onGrafted",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-toofew",prop:"onTooFew",value:null},{attr:"on-toomany",prop:"onTooMany",value:null},{attr:"on-locked",prop:"onLocked",value:null},{attr:"on-unlocked",prop:"onUnlocked",value:null},{attr:"on-output",prop:"onOutput",value:null},...p];class Select extends ModBaseListenCache{options={};flatData;selectData;inputEl;tagsEl;arrowEl;toolsEl;listEl;wrapEl;searchEl;resultEl;keysEl;checkEl;statsEl;statusEl;statusHolderEl;popupIns;tagsIns;treeIns;output;rawHmtl;clearVals;outputEvt;static hostType="node";static optMaps=vt;static dependencies=[InputElem,CheckboxElem];constructor(t,e={},i=!0){super();let a,l=getEl(t);if(!l)return this;["SELECT","INPUT"].includes(l.nodeName)?(this.inputEl=l,a=createEl("div",{class:`${s.prefix}select`}),l.insertAdjacentElement("afterend",a),a.appendChild(this.inputEl)):(a=l,a.classList.add(`${s.prefix}select`),this.inputEl=createEl("input",{type:"hidden"})),super.ready({options:e,host:a,maps:Select.optMaps,component:!0,spread:["popup","search","tools"]}),super.listen({name:"constructed"}),i&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.correctOpts(),super.useTpl(),this.renderMain(),this.setAttrs(),this.output={value:"",raw:"",items:[]},this.options.popup.enable&&!this.options.readonly?(this.setPopup(),await this.popupIns.init()):this.popupIns&&this.popupIns.destroy(),this.setTags(),await this.tagsIns.init(),this.setTree(),await this.treeIns.init(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}renderMain(){this.targetEl.innerHTML="",this.inputEl.setAttribute(s.alias,"input");let t=this.options.name;if("SELECT"===this.inputEl.nodeName&&this.options.multiple&&(t+="[]"),this.options.name&&(this.inputEl.name=t),this.targetEl.appendChild(this.inputEl),this.tagsEl=createEl("div",{[s.alias]:"tags"}),this.arrowEl=createEl("i",{[s.alias]:"arrow"}),this.targetEl.appendChild(this.tagsEl),this.options.tools.enable){this.toolsEl=createTools(this.options.tools.children,null,this),this.tagsEl.insertAdjacentElement("afterend",this.toolsEl),this.toolsEl.setAttribute(s.alias,"tools");for(let t of this.options.tools.children)!t.tips&&!t.title&&this.options.lang.title[t.name]&&t.wrapEl.setAttribute("title",this.options.lang.title[t.name]),"close"===t.name&&(t.wrapEl.onclick=()=>{this.clearVals()})}this.options.popup.enable&&this.targetEl.appendChild(this.arrowEl),this.listEl=createEl("div",{class:`${s.prefix}select-list`}),this.wrapEl=createEl("div",{class:`${s.prefix}select-wrap`},this.listEl),this.options.popup.enable&&this.options.search.enable&&(this.searchEl=createEl("div",{class:`${s.prefix}select-search`}),this.resultEl=createEl("div",{[s.alias]:"result"},this.options.lang.search.start),this.options.manual||(this.keysEl=createEl("ax-input",{tools:!0,placeholder:this.options.lang.search.placeholder,[s.alias]:"keys"}),this.searchEl.appendChild(this.keysEl)),this.options.search.result&&this.searchEl.appendChild(this.resultEl),this.wrapEl.insertAdjacentElement("afterbegin",this.searchEl)),this.options.popup.enable&&this.options.status&&(this.checkEl=createEl("ax-checkbox",{label:this.options.lang.check.all,[s.alias]:"check"}),!this.options.multiple&&this.checkEl.toggleAttribute("disabled",!0),this.statsEl=createEl("span",{[s.alias]:"stats"}),this.statusEl=createEl("div",{class:`${s.prefix}select-status`}),this.statusEl.append(this.checkEl,this.statsEl),this.wrapEl.appendChild(this.statusEl),this.checkEl.on("check",(t=>{"ed"===t.value?(this.treeIns.checkAll(),this.checkEl.setAttribute("label",this.options.lang.check.none)):"ing"===t.value?this.checkEl.setAttribute("label",this.options.lang.check.ing):(this.treeIns.uncheckAll(),this.checkEl.setAttribute("label",this.options.lang.check.ed))})),this.statusHolderEl=createEl("div",{class:`${s.prefix}select-holder`}),this.wrapEl.appendChild(this.statusHolderEl))}updateResult(t,e){this.options.popup.enable&&this.options.search.enable&&(this.resultEl.innerHTML=renderTpl(t?this.options.lang.search.succ:e.length?this.options.lang.search.fail:this.options.lang.search.start,{value:t,keys:e.toString()}))}updateStatus(){if(!this.options.popup.enable||!this.options.status)return;let t=this.treeIns.flatData.length,e=this.treeIns.getCheckeds().length;this.statsEl.innerHTML=renderTpl(this.options.lang.stats,{value:e,total:t}),this.checkEl.setAttribute("check",e?t===e?"ed":"ing":"")}setPopup(){let t=!(!this.options.multiple||this.options.manual)&&{children:[{name:"clear",action:t=>{t.el.onclick=()=>{this.treeIns.clearVals()}}},"confirm"]},e={trigger:"click",content:this.wrapEl,contType:"node",placement:"bottom-start",padding:!1,arrow:!1,tools:!1,footer:t,canClick:t=>{let e=[];if(this.options.manual)e=[this.arrowEl,this.targetEl,this.tagsEl];else{let t=[this.arrowEl,this.targetEl,this.tagsEl,this.tagsEl.emptyEl],s=this.tagsIns.data.map((t=>[t.wralEl,t.labelEl,t.iconEl,t.diskEl,t.cubeEl,t.imageEl])).flat().filter(Boolean);e=this.options.multiple?t:[...s,...t]}return!!e.includes(t)},onInitiated:()=>{this.popupIns.mainEl.classList.add(`${s.prefix}select-popup`),!this.options.autoWidth||this.popupIns.options.adaptive&&"xxs"===s.screen||this.popupIns.positionIns.on("changed",(()=>{this.popupIns.mainEl.style.width=this.popupIns.positionIns.targetData.width+"px"}))}},i=extend({target:e,source:this.options.popup});this.popupIns&&this.popupIns.destroy(),this.popupIns=new Popup(this.targetEl,i,!1)}setTags(){let t={...this.options.popup.enable?{content:""}:{content:this.rawHmtl||this.options.content,contType:this.options.contType,contData:this.options.contData,ajx:this.options.ajax},field:this.options.field,min:this.options.multiple?this.options.min:0,max:this.options.multiple?this.options.max:1,sliced:this.options.sliced,compact:!0,size:this.options.size,unique:{enable:!this.options.manual||this.options.unique},editor:!(!this.options.manual||this.options.readonly),removable:!(this.options.readonly||!this.options.removable),empty:{enable:!this.options.manual,content:this.options.lang.placeholder},onRemoved:t=>{for(let e of t)this.treeIns.check(e[this.options.field],!1)},onOutput:t=>{super.updateCache({value:t.value}),this.output=t,super.listen({name:"output",params:[this.output]})}};this.options.manual&&(t.b4Add=t=>new Promise((async(e,s)=>{let i=[];for(let e of t){let t=this.treeIns.flatData.find((t=>e[this.options.field]===t[this.options.field]));t?t.checked?i.push(e):await this.treeIns.check(t,!0):i.push(e)}e(i)})),t.onAdded=()=>{this.tagsIns.editEl.focus()}),this.tagsIns&&this.tagsIns.initiated&&this.tagsIns.destroy(),this.tagsIns=new Tags(this.tagsEl,extend({target:t,source:this.options.tags}),!1)}setTree(){this.listEl.innerHTML=this.rawHtml;let t={content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:this.options.ajax,passive:this.options.disabled,lang:{empty:this.options.lang.empty},search:{target:this.options.search.enable?this.options.manual?this.tagsIns.editEl:this.keysEl:null,trigger:this.options.manual?"input":"changed",ignore:this.options.search.ignore,fuzzy:this.options.search.fuzzy,value:this.options.search.value},disable:this.options.exclude,check:{type:this.options.multiple?"checkbox":"radio",value:this.options.value,sliced:this.options.sliced},feature:{type:this.options.type,check:{linkage:!1,span:this.options.span,only:!this.options.multiple},expand:{all:!this.options.collapse}},output:{field:this.options.field},onInitiated:()=>{this.updateStatus()},onChecked:t=>{this.options.manual&&(this.tagsIns.add(t.map((t=>t[this.options.field]))),this.tagsIns.editEl.value&&(this.treeIns.search(),this.tagsIns.editEl.value=""))},onUnchecked:t=>{this.options.manual&&this.tagsIns.remove(t.map((t=>t[this.options.field])))},onCheckedAll:()=>{if(!this.options.manual)return;let t=this.treeIns.getCheckeds();this.tagsIns.add(filterPrims(t))},onOutput:t=>{if(!this.options.manual){let e=filterPrims(t.items);this.popupIns&&"shown"===this.popupIns.state&&!this.options.multiple&&this.popupIns.hide(),this.tagsIns.updateCont(e),this.updateStatus()}E.setVals({target:this.inputEl,value:t.value.split(this.treeIns.options.output.separator),separator:this.treeIns.options.output.separator})},onSearched:(t,e)=>{this.options.manual&&this.popupIns&&this.popupIns.show(),this.updateResult(t.length,e)}},e=extend({target:t,source:this.options.tree});this.treeIns&&this.treeIns.initiated&&this.treeIns.destroy(),this.treeIns=new Tree(this.listEl,e,!1)}correctOpts(){"SELECT"===this.inputEl.nodeName&&(this.options.manual=!1,this.options.multiple=this.inputEl.multiple,this.options.span="leaf"),this.inputEl.disabled&&(this.options.disabled=!0),this.options.autoWidth&&(this.options.popup.size=""),!1===this.options.manual&&(this.options.popup.enable=!0)}setAttrs(){this.targetEl.classList.add(`${s.prefix}select`),this.targetEl.setAttribute("tabindex",0),this.options.classes&&classes(this.targetEl).add(this.options.classes),this.targetEl.toggleAttribute("inert",this.options.disabled),this.inputEl.disabled=this.options.disabled,this.targetEl.setAttribute("size",this.options.size),this.targetEl.toggleAttribute("readonly",this.options.readonly),this.targetEl.toggleAttribute("full",this.options.full),this.targetEl.toggleAttribute("manual",this.options.manual),this.targetEl.toggleAttribute("multiple",this.options.multiple),this.options.maxHeight?addStyle(this.listEl,"max-height",this.options.maxHeight):removeStyle(this.listEl,"max-height")}renderFinish(){}getVals(t){return this.destroyed?this:this.tagsIns.getVals((e=>{super.listen({name:"got",cb:t,params:[e]})}))}async select(t,e){if(this.destroyed)return this;let s;return this.options.manual?await this.tagsIns.add(t,(t=>{s=t})):await this.treeIns.check(t,!0,(t=>{s=t})),super.listen({name:"selected",cb:e,params:[s]}),this}async deselect(t,e){return this.destroyed||!this.tagsIns.data.length||await this.tagsIns.remove(t,(t=>{super.listen({name:"deselected",cb:e,params:[t]})})),this}clear(t){return this.destroyed||(this.treeIns.uncheckAll(),this.options.manual&&this.tagsIns.clear(),super.listen({name:"cleared",cb:t})),this}selectAll(t){return this.destroyed||(this.treeIns.checkAll(),super.listen({name:"selectedAll",cb:t})),this}disable(t){return this.treeIns.lock(),this.targetEl.toggleAttribute("inert",!0),this.inputEl.disabled=!0,super.listen({name:"disabled",cb:t}),this}enable(t){return this.treeIns.unlock(),this.targetEl.toggleAttribute("inert",!1),this.inputEl.disabled=!1,super.listen({name:"enabled",cb:t}),this}destroy(t){return this.destroyed||(this.options.popup.enable&&!this.options.readonly&&this.popupIns.destroy(),this.treeIns.destroy(),this.tagsIns.destroy(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}let yt=l.splitHyphen;const wt=[{attr:"name",prop:"name",value:""},{attr:"value",prop:"value",value:""},{attr:"url",prop:"url",value:""},{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"disabled",prop:"disabled",value:!1},{attr:"readonly",prop:"readonly",value:!1},{attr:"multiple",prop:"multiple",value:!0},{attr:"manual",prop:"manual",value:!1},{attr:"type",prop:"type",value:"text"},{attr:"icons",prop:"icons",value:{}},{attr:"cols",prop:"cols",value:4},{attr:"type-getter",prop:"typeGetter",value:null},{attr:"feature",prop:"feature",value:""},{attr:"limit",prop:"limit",value:{min:0,max:0,size:0,suffix:""}},{attr:"accept",prop:"accept",value:""},{attr:"size",prop:"size",value:"md"},{attr:"table",prop:"table",value:{header:!0}},{attr:"pastable",prop:"pastable",value:!0},{attr:"choose-btn",prop:"chooseBtn",value:{target:"",icon:`${s.prefix}icon-plus`,attrs:{}}},{attr:"upload-btn",prop:"uploadBtn",value:{enable:!1,target:"",icon:`${s.prefix}icon-upload`,attrs:{}}},{attr:"clear-btn",prop:"clearBtn",value:{enable:!1,target:"",icon:`${s.prefix}icon-trash`,attrs:{}}},{attr:"picture-btn",prop:"pictureBtn",value:{icon:`${s.prefix}icon-plus`,attrs:{}}},{attr:"gallery-btn",prop:"galleryBtn",value:{icon:`${s.prefix}icon-addpic`,attrs:{}}},{attr:"separator",prop:"separator",value:yt},{attr:"classes",prop:"classes",value:""},{attr:"status",prop:"status",value:""},{attr:"success",prop:"success",value:t=>200==t.code},{attr:"cloud",prop:"cloud",value:{enable:!1,field:"",server:"",domain:"",map:{name:"",url:"",size:"",time:""}}},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"b4-remove",prop:"b4Remove",value:null},{attr:"b4-upload",prop:"b4Upload",value:null},{attr:"b4-uploadall",prop:"b4UploadAll",value:null},{attr:"on-output",prop:"onOutput",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-added",prop:"onAdded",value:null},{attr:"on-removed",prop:"onRemoved",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-pasted",prop:"onPasted",value:null},{attr:"on-dropped",prop:"onDropped",value:null},{attr:"on-uploading",prop:"onUploading",value:null},{attr:"on-uploaded",prop:"onUploaded",value:null},{attr:"on-received",prop:"onReceived",value:null},{attr:"on-receivedAll",prop:"onReceivedAll",value:null},{attr:"on-uploadAll",prop:"onUploadAll",value:null},{attr:"on-uploadedAll",prop:"onUploadedAll",value:null},{attr:"on-failed",prop:"onFailed",value:null},{attr:"on-error",prop:"onError",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},{attr:"on-locked",prop:"onLocked",value:null},{attr:"on-unlocked",prop:"onUnlocked",value:null},...p];class Upload extends ModBaseListenCache{options={};flatData;treeData;dftTypes;fileChangeEvt;chooseEvt;clearEvt;uploadEvt;dragLeaveEvt;dragOverEvt;dragEnterEvt;dropEvt;tipsEl;summaryEl;infoEl;listEl;tableEl;theadEl;fileEl;inputEl;footEl;headEl;chooseBtn;uploadBtn;clearBtn;ctrlvEl;tipsText;name;singleSizeLimit;fileTypes;passedItems;allItems;output;files;value;validItems;fileInputEvt;static hostType="node";static optMaps=wt;static dependencies=[ProgressElem,BtnElem];constructor(t,e={},i=!0){super(),super.ready({options:e,host:t,maps:Upload.optMaps,component:!0,spread:["cloud","uploadBtn","clearBtn"]}),this.dftTypes={image:`${s.prefix}icon-image`,video:`${s.prefix}icon-video`,audio:`${s.prefix}icon-music`,file:`${s.prefix}icon-file-text`};let a=this;this.fileChangeEvt=function(t){t.stopPropagation();let e=[...this.files];a.renderList(e),this.value="",a.listen({name:"changed",params:[e]})},this.fileInputEvt=function(t){t.stopPropagation()},this.chooseEvt=()=>{let t=this.globalValid();t.passed?this.fileEl.click():new Message({content:t.msg,status:"error"}).show()},this.clearEvt=()=>{this.clear.call(this)},this.uploadEvt=()=>{this.uploadAll()},this.dragLeaveEvt=t=>{t.preventDefault(),this.targetEl.removeAttribute("dragging")},this.dragOverEvt=t=>{t.preventDefault(),this.targetEl.toggleAttribute("dragging",!0)},this.dragEnterEvt=t=>{t.preventDefault()},this.dropEvt=async t=>{t.preventDefault(),this.targetEl.removeAttribute("dragging");let e=t.dataTransfer.items;for(let t of e)if("file"===t.kind){let e=t.webkitGetAsEntry();this.getEntries(e)}super.listen({name:"dropped",params:[e]})},this.tipsEl=createEl("div",{[s.alias]:"tips"}),this.summaryEl=createEl("div",{[s.alias]:"summary"}),this.infoEl=createEl("div",{class:`${s.prefix}upload-info`}),this.createSetList(),super.listen({name:"constructed"}),i&&this.init()}createSetList(){let t=s.prefix+"reset";"card"===this.options.type&&(t+=` ${s.prefix}grid ${s.prefix}g-xs`,this.options.cols&&(t+=` ${s.prefix}avg-${this.options.cols}`)),this.listEl=createEl("table"===this.options.type?"table":"ul",{class:`${"table"!==this.options.type?t:""} ${s.prefix}upload-list`}),"table"===this.options.type?(this.tableEl=createEl("table"),this.listEl=createEl("tbody",{class:`${s.prefix}upload-list`}),this.options.table.header&&(this.theadEl=createEl("thead",{},this.options.lang.thead.map((t=>`<th>${t}</th>`)).join("")),this.tableEl.appendChild(this.theadEl)),this.tableEl.appendChild(this.listEl)):this.listEl=createEl("ul",{class:`${t} ${s.prefix}upload-list`})}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return this.passedItems=[],this.allItems=[],this.output={value:"",raw:"",items:[]},this.singleSizeLimit=1024*this.options.limit.size*1024,this.setFeature(),this.getFileTypes(),this.name=this.targetEl.name||this.options.name,this.createSkeleton(),this.setAttrs(),this.renderFinish(),this.initShow(),super.listen({name:"initiated",cb:t}),this}initShow(){if(isEmpty(this.options.value)){let t=this.rawHtml.trim();t&&this.add(t)}else this.add(this.options.value)}setFeature(){"picture"===this.options.feature&&(this.options.type="cube")}getFileTypes(){this.fileTypes={...this.dftTypes,...this.options.icons}}getTips(){return this.tipsText=[this.options.lang.tips.free],this.options.limit.suffix&&this.tipsText.push(renderTpl(this.options.lang.tips.suffix,{value:this.options.limit.suffix})),this.options.limit.size&&this.tipsText.push(renderTpl(this.options.lang.tips.size,{value:this.options.limit.size})),this.options.limit.min&&this.tipsText.push(renderTpl(this.options.lang.tips.min,{value:this.options.limit.min})),this.options.limit.max&&this.tipsText.push(renderTpl(this.options.lang.tips.max,{value:this.options.limit.max})),this.tipsText.join(",")}createStart(){"gallery"===this.options.feature?this.chooseBtn=this.createBox(this.options.feature,"div"):"picture"===this.options.feature?this.chooseBtn=this.createBox(this.options.feature,"li"):this.chooseBtn=getEl(this.options.chooseBtn.target)||this.createBtn("choose")}createBox(t,e="li"){let i=this.options[t+"Btn"].icon?`<i ${s.alias}="icon" class="${this.options[t+"Btn"].icon}"></i>`:"",a=this.options.lang.button[t]?`<div ${s.alias}="text">${this.options.lang.button[t]}</div>`:"";return createEl(e,Object.assign({[s.alias]:["picture","gallery"].includes(t)?"choose":t},"gallery"!==t?{tabindex:0}:{},this.options[t+"Btn"].attrs),`${i}${a}`)}createBtn(t){return createEl("ax-btn",Object.assign({[s.alias]:t,size:this.options.size,tabindex:0,icon:this.options[t+"Btn"].icon,label:this.options.lang.button[t]},this.options[t+"Btn"].attrs))}createInput(t=!0,e=!0){t&&(this.inputEl=createEl("input",{type:"hidden",readonly:"",name:this.name})),e&&(this.fileEl=createEl("input",{type:"file",readonly:""}))}createSkeleton(){if(this.targetEl)if("INPUT"===this.targetEl.nodeName){let t=this.targetEl;"file"===t.type?(this.fileEl=t,this.fileEl.readOnly=!0,this.createInput(!0,!1)):(this.inputEl=t,this.inputEl.type="hidden",this.inputEl.name=this.name,this.inputEl.readOnly=!0,this.createInput(!1,!0)),this.targetEl=createEl("div"),t.insertAdjacentElement("beforeBegin",this.targetEl)}else this.createInput(!0,!0);else this.targetEl=createEl("div"),this.createInput(!0,!0);if(this.inputEl.toggleAttribute(s.embedSign,!0),this.fileEl.toggleAttribute(s.embedSign,!0),this.targetEl.innerHTML=this.listEl.innerHTML="",this.options.accept&&this.fileEl.setAttribute("accept",this.options.accept),this.fileEl.multiple?this.options.multiple=!0:this.options.multiple&&this.fileEl.toggleAttribute("multiple",!0),!this.fileEl.multiple&&(this.options.limit.min=0,this.options.limit.max=1),this.targetEl.append(this.inputEl,this.fileEl),this.targetEl.appendChild("table"===this.options.type?this.tableEl:this.listEl),this.footEl=createEl("div",{class:`${s.prefix}upload-foot`},this.infoEl),this.options.status&&(this.targetEl.setAttribute("status",this.options.status),this.options.status.includes("tips")&&(this.tipsEl.innerHTML=this.getTips(),this.infoEl.appendChild(this.tipsEl)),this.options.status.includes("summary")&&(this.summaryEl.innerHTML=this.getSummary(),this.infoEl.appendChild(this.summaryEl))),"gallery"===this.options.feature)this.createCtrlv(),this.targetEl.appendChild(this.footEl),this.chooseBtn=this.createBox(this.options.feature,"div"),this.targetEl.insertAdjacentElement("afterBegin",this.chooseBtn),this.targetEl.setAttribute("tabindex",0),this.options.clearBtn.enable&&(this.clearBtn=this.createBtn("clear"),this.footEl.appendChild(this.clearBtn)),this.options.uploadBtn.enable&&(this.uploadBtn=this.createBtn("upload"),this.footEl.appendChild(this.uploadBtn));else if("picture"===this.options.feature)this.targetEl.appendChild(this.footEl),this.chooseBtn=this.createBox(this.options.feature,"li"),this.listEl.appendChild(this.chooseBtn),this.options.clearBtn.enable&&(this.clearBtn=this.createBox("clear","li"),this.chooseBtn.insertAdjacentElement("afterEnd",this.clearBtn)),this.options.uploadBtn.enable&&(this.uploadBtn=this.createBox("upload","li"),this.chooseBtn.insertAdjacentElement("afterEnd",this.uploadBtn));else{this.headEl=createEl("div",{class:`${s.prefix}upload-head`}),this.listEl.insertAdjacentElement("beforeBegin",this.footEl);let t=getEl(this.options.chooseBtn.target);if(t?this.chooseBtn=t:(this.chooseBtn=this.createBtn("choose"),this.headEl.appendChild(this.chooseBtn)),this.options.uploadBtn.enable){let t=getEl(this.options.uploadBtn.target);t?this.uploadBtn=t:(this.uploadBtn=this.createBtn("upload"),this.headEl.appendChild(this.uploadBtn))}if(this.options.clearBtn.enable){let t=getEl(this.options.clearBtn.target);t?this.clearBtn=t:(this.clearBtn=this.createBtn("clear"),this.headEl.appendChild(this.clearBtn))}this.targetEl.insertAdjacentElement("afterBegin",this.headEl)}}addEvts(){this.chooseBtn.addEventListener("click",this.chooseEvt,!1),this.uploadBtn&&this.uploadBtn.addEventListener("click",this.uploadEvt,!1),this.clearBtn&&this.clearBtn.addEventListener("click",this.clearEvt,!1),this.fileEl.addEventListener("change",this.fileChangeEvt,!1),this.fileEl.addEventListener("input",this.fileInputEvt,!0),this.targetEl.addEventListener("dragleave",this.dragLeaveEvt,!1),this.targetEl.addEventListener("dragover",this.dragOverEvt,!1),this.targetEl.addEventListener("dragenter",this.dragEnterEvt,!1),this.targetEl.addEventListener("drop",this.dropEvt,!1)}removeEvts(){this.chooseBtn.removeEventListener("click",this.chooseEvt),this.uploadBtn&&this.uploadBtn.removeEventListener("click",this.uploadEvt),this.clearBtn&&this.clearBtn.removeEventListener("click",this.clearEvt),this.fileEl.removeEventListener("change",this.fileChangeEvt),this.fileEl.removeEventListener("input",this.fileInputEvt),this.targetEl.removeEventListener("dragleave",this.dragLeaveEvt),this.targetEl.removeEventListener("dragover",this.dragOverEvt),this.targetEl.removeEventListener("dragenter",this.dragEnterEvt),this.targetEl.removeEventListener("drop",this.dropEvt)}renderFinish(){this.removeEvts(),this.addEvts()}setAttrs(){this.targetEl.classList.add(`${s.prefix}upload`),this.options.type?this.targetEl.setAttribute("type",this.options.type):this.targetEl.removeAttribute("type"),this.targetEl.toggleAttribute("pastable",this.options.pastable),this.targetEl.toggleAttribute("inert",this.options.disabled),this.options.feature?this.targetEl.setAttribute("feature",this.options.feature):this.targetEl.removeAttribute("feature"),this.targetEl.setAttribute("size",this.options.size),this.updateInsProg("ready")}createCtrlv(){this.options.pastable&&(this.ctrlvEl=createEl("i",{[s.alias]:"ctrlv"},this.options.lang.paste.before),this.targetEl.appendChild(this.ctrlvEl),this.ctrlvEl.onclick=()=>{this.ctrlvEl.innerHTML=this.options.lang.paste.ing,this.ctrlvEl.toggleAttribute("contenteditable",!0),this.ctrlvEl.focus()},this.ctrlvEl.onpaste=t=>{t.preventDefault(),this.ctrlvEl.toggleAttribute("contenteditable",!1);let e=t.clipboardData;if(e){let t=e.items[0];t&&"file"===t.kind&&t.type.includes("image")&&(this.renderList([t.getAsFile()]),this.ctrlvEl&&(this.ctrlvEl.innerHTML=this.options.lang.paste.after)),super.listen({name:"pasted",params:[t]})}},this.targetEl.onmouseleave=()=>{this.ctrlvEl.innerHTML=this.options.lang.paste.before})}getSummary(){let t,e=0,s=this.passedItems.length,i=this.passedItems.filter((t=>"received"==t.progress)),a=i.length;for(let t of i)e+=t.file.size;return t=convertByte({val:e}).str,renderTpl(this.options.lang.summary,{total:s,count:a,size:t})}createItem(t){let e=t.file.name,i=t.file.size,a=t.valid.passed,l=t.valid.msg,n="",r=`\n        <div class="${s.prefix}upload-mask">\n            ${this.options.manual?"<i "+s.alias+'="upload" class="'+s.prefix+'icon-upload"></i>':""}\n            <i ${s.alias}="view" class="${s.prefix}icon-zoomin"></i>\n            <a ${s.alias}="download" href="###" class="${s.prefix}icon-download"></a>\n            <i ${s.alias}="remove" class="${s.prefix}icon-trash"></i>\n        </div>\n        <ax-progress ${s.alias}="progress" thk="xs" size="sm" type="circle"></ax-progress>\n        <i ${s.alias}="state"></i>\n        <i ${s.alias}="sign" class="${s.prefix}icon-check"></i>\n        <div ${s.alias}="message">${a?l:""}</div>\n        `,o=`\n                <div class="${s.prefix}upload-info">\n                    <a href="###" ${s.alias}="title">${e}</a>\n                    ${"bullet"===this.options.type?"<div "+s.alias+'="size">'+convertByte({val:i}).str+"</div>":""}\n                </div>\n                <ax-progress ${s.alias}="progress" label="false" thk="xs"></ax-progress>\n                <i ${s.alias}="message">${a?l:""}</i>\n                <i ${s.alias}="percent"></i>\n                <i ${s.alias}="state"></i>\n                <i ${s.alias}="sign" class="${s.prefix}icon-check"></i>\n                ${this.options.manual?"<i "+s.alias+'="upload" class="'+s.prefix+'icon-upload"></i>':""}\n                <i ${s.alias}="remove" class="${s.prefix}icon-trash"></i>\n                `;if("card"===this.options.type)n=`\n                    <li valid=${a?"success":"failed"}>\n                        <div class="${s.prefix}upload-file">\n                            ${r}\n                        </div>\n                        <div class="${s.prefix}upload-info">\n                            <div ${s.alias}="title">${e}</div>\n                            <div ${s.alias}="size">${convertByte({val:i}).str}</div>\n                            <div ${s.alias}="url"></div>\n                        </div>\n                    </li>\n                    `;else if("cube"===this.options.type)n=`\n                    <li valid=${a?"success":"failed"}>\n                        <div class="${s.prefix}upload-file"></div>\n                        ${r}\n                    </li>\n                    `;else if("bullet"==this.options.type)n=`\n                    <li valid=${a?"success":"failed"}>\n                        <a href="###" class="${s.prefix}upload-file"></a>\n                        ${o}\n                    </li>\n                    `;else if("table"===this.options.type){let t=`\n                ${this.options.manual?"<i "+s.alias+'="upload" class="'+s.prefix+'icon-upload"></i>':""}\n                <i ${s.alias}="remove" class="${s.prefix}icon-trash"></i>\n            `;n=`\n                    <tr valid=${a?"success":"failed"}>\n                        <td><div class="${s.prefix}upload-file"></div></td>\n                        <td><div class="${s.prefix}upload-info"><a href="###" ${s.alias}="title">${e}</a></div></td>\n                        <td>${convertByte({val:i}).str}</td>\n                        <td><ax-progress ${s.alias}="progress" thk="sm"></ax-progress></td>\n                        <td><i ${s.alias}="message">${a?l:""}</i></td>\n                        <td><span ${s.alias}="state">${a?this.options.lang.progress.passed:this.options.lang.progress.notPassed}</span></td>\n                        <td>${t}</td>\n                    </tr>\n                    `}else n=`\n                    <li valid=${a?"success":"failed"}>\n                        <i ${s.alias}="icon" class="${s.prefix}icon-attach"></i>\n                        ${o}\n                    </li>\n                    `;t.wrapEl=tplToEl(n),t.fileEl=t.wrapEl.querySelector(`.${s.prefix}upload-file`),t.fileEl&&this.fillHeader(t),"picture"===this.options.feature?this.chooseBtn.insertAdjacentElement("beforeBegin",t.wrapEl):this.listEl.appendChild(t.wrapEl)}updateInsProg(t){this.targetEl.setAttribute("progress",t)}updateItemProg(t,e){t.progress=e,t.wrapEl.setAttribute("progress",e),t.stateEl&&(t.stateEl.innerHTML=this.options.lang.progress[e])}updateItemValid(t,e){t.wrapEl.setAttribute("valid",e)}renderItem(t){let e=this.fileValid(t),i={file:t,valid:e};return this.createItem(i),i.uploadEl=i.wrapEl.querySelector(`[${s.alias}="upload"]`),i.removeEl=i.wrapEl.querySelector(`[${s.alias}="remove"]`),i.stateEl=i.wrapEl.querySelector(`[${s.alias}="state"]`),i.msgEl=i.wrapEl.querySelector(`[${s.alias}="message"]`),i.progEl=i.wrapEl.querySelector("ax-progress"),i.uploadEl&&(i.uploadEl.onclick=async()=>{try{this.options.b4Upload&&await this.options.b4Upload.call(this,i)}catch(t){return this}this.upload(i)}),i.removeEl&&(i.removeEl.onclick=async()=>{try{this.options.b4Remove&&await this.options.b4Remove.call(this,i)}catch(t){return this}this.remove(i)}),this.allItems.push(i),e.passed&&this.passedItems.push(i),this.updateItemProg(i,"rendered"),super.listen({name:"rendered",params:[i]}),i}getEntries(t){t.isFile?t.file((t=>this.renderList([t]))):t.createReader().readEntries((t=>t.forEach((t=>this.getEntries(t)))))}hasSame(t){return!!this.allItems.length&&this.allItems.some((e=>e.file.name===t.name&&e.file.size===t.size))}renderList(t){if(t.length){for(let e of t)!this.hasSame(e)&&this.renderItem(e);!this.options.manual&&this.uploadAll(),this.updateInsProg("processing")}}async uploadAll(t){if(!this.options.url)throw new Error('The parameter "url" (the address of the page to send data) is required!');let e=this.globalValid();if(!e.passed)return new Message({content:e.msg,status:"error"}).show(),this;this.allItems.length<this.options.limit.min&&new Message({content:e.msg,status:"warn"}).show();let s=this.getUploadingItems();try{this.options.b4UploadAll&&await this.options.b4UploadAll.call(this,s)}catch(t){return this}return super.listen({name:"uploadAll",cb:t,params:[s]}),this.saveRaw(),await Promise.all(s.map((t=>this.upload(t,!0)))),this.setInputVal(),this.listenReceivedAll(),this}getUploadingItems(){return this.passedItems.filter((t=>this.canUpload(t)))}actOpt(t){let e=t.file,i=t.wrapEl,a=t.data.url;t.file.name,this.options.cloud.enable&&(a=a?this.options.cloud.domain+a:"javascript:void(0);");let l=i.querySelector(`[${s.alias}="download"]`),n=i.querySelector(`[${s.alias}="view"]`);if(l&&(this.options.cloud.enable?l.onclick=()=>T.download(a,e.name):(l.setAttribute("download",""),l.setAttribute("href",a))),n&&this.getFileType(e),["text","bullet","table"].includes(this.options.type)){let t=i.querySelector(`[${s.alias}="title"]`),e=i.querySelector(`.${s.prefix}upload-file`);t.setAttribute("href",a),t.setAttribute("target","_blank"),e&&(e.setAttribute("href",a),e.setAttribute("target","_blank"))}}canUpload(t){return t.valid.passed&&!["uploading","uploaded","received"].includes(t.progress)}async upload(t,e=!1){let i=new FormData,a=t.file,l=t.wrapEl,fixEl=(e,s)=>{e?(this.actOpt(t),this.updateItemProg(t,"received")):(this.updateItemProg(t,"failed"),this.updateItemValid(t,"failed"),t.msgEl.innerText=s,this.passedItems=this.allItems.filter((t=>t.valid.passed))),this.options.status.includes("summary")&&(this.summaryEl.innerHTML=this.getSummary())};if(!this.canUpload(t))return this;try{this.options.b4Upload&&await this.options.b4Upload.call(this,t)}catch(t){return this}i.append(this.name||"file",a),this.options.cloud.enable&&await ajax({url:this.options.url,before:()=>{this.updateItemProg(t,"getAuth")},success:e=>{for(let t in e.content)i.append(t,e.content[t]);this.options.cloud.append&&this.options.cloud.append(i,a),this.updateItemProg(t,"authorized")},error:()=>{this.updateItemProg(t,"unauthorized"),this.updateItemValid(t,"failed"),this.validItems=this.allItems.filter((t=>t.valid.passed))}}),this.updateItemProg(t,"uploading"),!e&&this.saveRaw(),await ajax({url:this.options.cloud.enable?this.options.cloud.server:this.options.url,data:i,uploading:e=>{t.abort=e.abort,t.progEl.setAttribute("value",e.percent),["text","bullet"].includes(this.options.type)&&(l.querySelector(`[${s.alias}="percent"]`).innerHTML=e.result),e.percent>=100?(this.updateItemProg(t,"uploaded"),super.listen({name:"uploaded",params:[t]}),this.passedItems.every((t=>t.valid.passed&&["uploaded","received"].includes(t.progress)))&&super.listen({name:"uploadedAll"})):(this.updateItemProg(t,"uploading"),super.listen({name:"uploading",params:[{item:t,content:e}]}))},success:async e=>{let s,i="",l="",n="",r=0,o=0,h=this.options.cloud.map,forceMsg=(t,e,s)=>{t.valid.msg=e||this.options.lang.message.single[s]},getKeys=(t,e)=>{if(!e)return"";if(!e.includes("."))return t[e];let s=e.split("."),i=s.length;return 1===i?t[s[0]]:2===i?t[s[0]][s[1]]:""};this.options.cloud.enable?(i=getKeys(e.content,h.name||"name"),n=getKeys(e.content,h.url||"url"),r=getKeys(e.content,h.size||"size"),o=getKeys(e.content,h.time||"time"),l=getKeys(e.content,h.msg||"msg")):(i=e.content.name||t.file.name,n=e.content.url,r=a.size,o=e.content.time,l=e.content.msg),s=this.options.success&&this.options.success(e.content)||!!n,t.resp=e.content,t.data={name:i,url:n,size:r,time:o},t.valid.passed=s,s?(forceMsg(t,l,"success"),super.listen({name:"received",params:[{item:t,content:e.content}]})):(forceMsg(t,l,"failed"),super.listen({name:"failed",params:[{item:t,content:e.content}]})),fixEl(s,t.valid.msg)},error:e=>{fixEl(!1,this.options.lang.message.single.failed),super.listen({name:"error",params:[{item:t,content:e.content}]})}}),e||(this.setInputVal(),this.listenReceivedAll())}listenReceivedAll(){this.passedItems.every((t=>t.valid.passed&&"received"==t.progress))&&super.listen({name:"receivedAll"})}items2Vals(t=this.passedItems){let e=t.map((t=>t.data)).filter(Boolean),s=[];for(let t of e)s.push(t.url);return{value:s.join(this.options.separator),items:e}}saveRaw(t=this.passedItems){this.output.raw=this.items2Vals(t).value}setInputVal(t=this.passedItems){Object.assign(this.output,this.items2Vals(t)),this.inputEl&&(this.inputEl.value=this.output.value,this.inputEl.onchange&&this.inputEl.onchange()),super.listen({name:"output",params:[this.output]})}getFileType(t){let e=t.type,s=T.getSuffix(t).toLowerCase(),i="";return i=e.startsWith("image")?"image":e.startsWith("video")?"video":e.startsWith("audio")?"audio":this.options.typeGetter?this.options.typeGetter(t,s):"file",i}async fillHeader(t){let e,i=t.file,a=this.getFileType(i);"image"===a?await T.getBase64(i,(t=>{e=createEl("img",{src:t})})):["video","audio"].includes(a)?await T.getBase64(i,(t=>e=createEl(a,{src:t,controls:""}))):e=createEl("i",{class:this.fileTypes[a]||this.fileTypes.file,[s.alias]:"icon"}),t.fileEl.appendChild(e)}fileValid(t){let e=this.options.lang.message.single.passed,s=!0,i=T.getSuffix(t);return this.allItems.length>this.options.limit.max&&this.options.limit.max?(e=this.options.lang.message.single.max,s=!1):this.singleSizeLimit&&t.size>this.singleSizeLimit?(e=this.options.lang.message.single.size,s=!1):this.options.limit.suffix&&!this.options.limit.suffix.includes(i)&&(e=this.options.lang.message.single.suffix,s=!1),{passed:s,msg:e}}globalValid(){let t=this.options.lang.message.global.passed,e=!0;return this.allItems.length<this.options.limit.min?(t=renderTpl(this.options.lang.message.global.min,{value:this.options.limit.min}),e=!0):this.options.limit.max&&this.allItems.length>this.options.limit.max&&(t=renderTpl(this.options.lang.message.global.max,{value:this.options.limit.max}),e=!1),{passed:e,msg:t}}findItem(t){let e,s=getDataType(t);return"String"===s?e=this.allItems.find((e=>e.file.name===t)):"Number"===s?e=this.allItems[t]:"File"===s?e=this.allItems.find((e=>e.file===t)):"Object"===s&&t.wrapEl&&(e=this.allItems.find((e=>e===t))),e}async remove(t,e){if(this.destroyed)return this;let s=this.findItem(t);if(!s)return this;try{this.options.b4Remove&&await this.options.b4Remove.call(this,s)}catch(t){return this}return this.saveRaw(),s.abort&&s.abort(),s.wrapEl.remove(),this.allItems=this.allItems.filter((t=>t!==s)),this.passedItems=this.passedItems.filter((t=>t!==s)),this.passedItems.length||this.updateInsProg("ready"),this.setInputVal(),this.options.status.includes("summary")&&(this.summaryEl.innerHTML=this.getSummary()),super.listen({name:"removed",cb:e,params:[s]}),this}async clear(t){if(this.destroyed)return this;try{this.options.b4Clear&&await this.options.b4Clear.call(this)}catch(t){return this}this.saveRaw();for(let t of this.passedItems)t.abort&&t.abort(),t.wrapEl.remove();return this.passedItems=[],this.allItems=[],this.setInputVal(),this.updateInsProg("ready"),this.options.status.includes("summary")&&(this.summaryEl.innerHTML=this.getSummary()),super.listen({name:"cleared",cb:t}),this}getVals(){return this.destroyed?this:this.inputEl.value}async add(t,e){if(this.destroyed)return this;let s=valToArr(t).map((t=>"string"==typeof t?{url:t,name:""}:t)).filter(Boolean),i=[];if(s.length){this.updateInsProg("processing"),this.saveRaw();for(let t of s)try{await T.urlToFile(t.url,t.name,(e=>{if(this.hasSame(e))return;let s=this.renderItem(e);s.valid={passed:!0,msg:this.options.lang.message.single.success},s.data={name:e.name,url:t.url,time:t.time||e.lastModified,size:e.size},this.updateItemProg(s,"received"),this.actOpt(s),i.push(s)}))}catch{continue}return this.options.status.includes("summary")&&(this.summaryEl.innerHTML=this.getSummary()),this.setInputVal(),super.listen({name:"added",cb:e,params:[i]}),this}}destroy(t){if(this.destroyed)return this;this.removeEvts();for(let t of this.passedItems)t.abort&&t.abort(),t.uploadEl&&(t.uploadEl.onclick=null),t.removeEl&&(t.removeEl.onclick=null);return this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const xt=[{attr:"content",prop:"content",value:""},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"tpl-str",prop:"tplStr",value:""},{attr:"tpl-eng",prop:"tplEng",value:null},{attr:"label",prop:"label",value:""},{attr:"tips",prop:"tips",value:""},{attr:"cube",prop:"cube",value:""},{attr:"disk",prop:"disk",value:""},{attr:"image",prop:"image",value:""},{attr:"icon",prop:"icon",value:""},{attr:"badge",prop:"badge",value:null},{attr:"annot",prop:"annot",value:""},{attr:"lamp",prop:"lamp",value:""},{attr:"custom",prop:"custom",value:""},{attr:"brief",prop:"brief",value:""},{attr:"classes",prop:"classes",value:""},{attr:"arrow",prop:"arrow",value:{enable:!1,show:`${s.prefix}icon-up`,hide:`${s.prefix}icon-up`,anim:`${s.prefix}rotate180`,type:"icon",placement:"end"}},{attr:"tab",prop:"tab",value:{enable:!0}},{attr:"tools",prop:"tools",value:{enable:!1,children:["toggle"]}},{attr:"deferred",prop:"deferred",value:!1},{attr:"feature",prop:"feature",value:""},{attr:"dividable",prop:"dividable",value:!1},{attr:"collapsed",prop:"collapsed",value:!1},{attr:"head-closable",prop:"headClosable",value:!1},{attr:"padded",prop:"padded",value:!0},{attr:"theme",prop:"theme",value:""},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"b4-expand",prop:"b4Expand",value:null},{attr:"b4-collapse",prop:"b4Collapse",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-rendered",prop:"onRendered",value:null},{attr:"on-expand",prop:"onExpand",value:null},{attr:"on-expanded",prop:"onExpanded",value:null},{attr:"on-collapse",prop:"onCollapse",value:null},{attr:"on-collapsed",prop:"onCollapsed",value:null},{attr:"on-updatedcont",prop:"onUpdatedCont",value:null},{attr:"on-request",prop:"onRequest",value:null},...p];class LineElem extends CompBaseComm{labelEl;startEl;endEl;contRaw;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["type","theme","size","align","dir",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,LineElem)}getRawData(){this.getRawProps(LineElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.labelEl),this.startEl=createEl("i",{[s.alias]:"start"}),this.endEl=createEl("i",{[s.alias]:"end"}),this.labelEl=createEl("i",{[s.alias]:"label"},t.label),this.wrapEl.appendChild(this.startEl),t.label&&this.wrapEl.append(this.labelEl,this.endEl)}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel};changedLabel(t){this.labelEl.innerHTML=t.newVal,t.newVal?elState(this.labelEl).isVirtual&&this.wrapEl.append(this.labelEl,this.endEl):(this.labelEl.remove(),this.endEl.remove())}}class Panel extends ModBaseListenCache{options={};flatData;treeData;wrapEl;headEl;innerEl;titleEl;groupEl;labelEl;iconEl;diskEl;cubeEl;imageEl;briefEl;annotEl;badgeEl;tipsEl;customEl;toolsEl;arrowEl;bodyEl;contEl;closeEl;tabIns;contXhr;transmitioned;data;closeEvt;static hostType="node";static optMaps=xt;static dependencies=[LineElem,BadgeElem];constructor(t,e={},s=!0){super(),super.ready({options:e,host:t,maps:Panel.optMaps,component:!0,spread:["arrow","tab","tools"]}),this.transmitioned=!0,this.closeEvt=()=>{this.transmitioned&&(elState(this.bodyEl).isHidden?this.expand():this.collapse())},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return super.useTpl(),this.renderMain(),this.setAttrs(),await this.getDataToRender(),this.renderFinish(),super.listen({name:"initiated",cb:t}),this}correctOpts(){"window"===this.options.feature&&(this.options.dividable=!1)}async fillBody(t,e){if(this.destroyed)return this;try{if(this.options.b4Fill){let e=await this.options.b4Fill.call(this,t);e&&(t=e)}}catch(t){return}return setContent({content:t,target:this.contEl,template:this.tplStr,engine:this.tplEng}),!this.options.deferred&&!this.options.collapsed||this.options.arrow.enable||this.options.headClosable||await this.expand(),super.listen({name:"filled",cb:e,params:[t]}),this}async getDataToRender(t=!1){(t||!this.options.deferred)&&(this.options.content?this.data=await getContent.call(this,{content:this.options.content,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.arrowEl,...this.options.ajax},request:t=>{this.listen({name:"request",params:[t]})}}):this.data=this.rawEl||this.rawHtml,this.data&&await this.fillBody(this.data))}toggleArrow(t){if(!this.arrowEl)return;let e=t?{new:"show",old:"hide",action:"remove"}:{new:"hide",old:"show",action:"add"};"image"===this.options.arrow.type?this.arrowEl.style.backgroundImage=`url("${this.options.arrow[e.new]}")`:this.options.arrow.show===this.options.arrow.hide?this.arrowEl.classList[e.action](this.options.arrow.anim):classes(this.arrowEl).replace(this.options.arrow[e.old],this.options.arrow[e.new])}setArrow(){if(!this.arrowEl)return;let t=this.options.collapsed||this.options.deferred?"hide":"show";"image"===this.options.arrow.type?this.options.arrow[t]&&(this.arrowEl.style.backgroundImage=`url("${this.options.arrow[t]}")`):(this.options.arrow[t]&&this.arrowEl.classList.add(this.options.arrow[t]),this.options.arrow.show===this.options.arrow.hide&&"hide"===t&&this.arrowEl.classList.add(this.options.arrow.anim))}createHeadEl(){let t=`\n        <div class="_panel-head">\n                <div class="_panel-inner">\n                    <div class="_panel-title">\n                        <div rep="group">\n                            <i rep="label">${this.options.label}</i>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        `;this.headEl=tplToEl(t),this.innerEl=this.headEl.querySelector(`.${s.prefix}panel-inner`),this.titleEl=this.headEl.querySelector(`.${s.prefix}panel-title`),this.groupEl=this.headEl.querySelector(`[${s.alias}="group"]`),this.labelEl=this.headEl.querySelector(`[${s.alias}="label"]`),this.options.icon&&(this.iconEl=createEl("i",{[s.alias]:"icon",class:this.options.icon}),("loose"===this.options.feature?this.innerEl:this.groupEl).insertAdjacentElement("beforebegin",this.iconEl)),this.options.disk&&(this.diskEl=createEl("img",{[s.alias]:"disk",src:this.options.disk}),("loose"===this.options.feature?this.innerEl:this.groupEl).insertAdjacentElement("beforebegin",this.diskEl)),this.options.cube&&(this.cubeEl=createEl("img",{[s.alias]:"cube",src:this.options.cube}),("loose"===this.options.feature?this.innerEl:this.groupEl).insertAdjacentElement("beforebegin",this.cubeEl)),this.options.image&&(this.imageEl=createEl("img",{[s.alias]:"image",src:this.options.image}),("loose"===this.options.feature?this.innerEl:this.groupEl).insertAdjacentElement("beforebegin",this.imageEl)),this.options.brief&&(this.briefEl=createEl("div",{class:`${s.prefix}panel-brief`},this.options.brief),this.titleEl.insertAdjacentElement("afterend",this.briefEl)),this.options.annot&&(this.annotEl=createEl("span",{[s.alias]:"annot"},this.options.annot),this.labelEl.insertAdjacentElement("afterend",this.annotEl)),isNull(this.options.badge)||(this.badgeEl=createEl("ax-badge",{label:this.options.badge}),this.groupEl.insertAdjacentElement("afterend",this.badgeEl)),this.options.tips&&(this.tipsEl=createEl("span",{[s.alias]:"tips"},this.options.tips),this.groupEl.insertAdjacentElement("afterend",this.tipsEl)),this.options.custom&&(this.customEl=createEl("div",{[s.alias]:"custum"},this.options.custom),this.groupEl.insertAdjacentElement("afterend",this.customEl)),this.options.tools.enable&&(this.toolsEl=createTools(this.options.tools.children,this.titleEl),this.toolsEl.setAttribute(s.alias,"tools")),this.options.arrow.enable&&(this.arrowEl=createEl("i",{[s.alias]:"arrow"}),this.setArrow(),"end"===this.options.arrow.placement?this.titleEl.appendChild(this.arrowEl):("loose"===this.options.feature?this.headEl:this.titleEl).insertAdjacentElement("afterbegin",this.arrowEl)),this.wrapEl.insertAdjacentElement("afterbegin",this.headEl),this.options.dividable&&this.headEl.insertAdjacentHTML("afterend",`<ax-line ${this.options.theme?'theme="'+this.options.theme+'"':""}></ax-line>`)}createBodyEl(){this.bodyEl=createEl("div",{class:`${s.prefix}panel-body`}),this.options.padded?(this.contEl=createEl("div",{class:`${s.prefix}panel-inner`}),this.bodyEl.appendChild(this.contEl)):this.contEl=this.bodyEl,this.wrapEl.appendChild(this.bodyEl)}renderMain(){this.targetEl.innerHTML="",this.wrapEl=createEl("div",{class:`${s.prefix}panel-wrap`}),this.targetEl.appendChild(this.wrapEl),this.createHeadEl(),this.createBodyEl(),super.listen({name:"rendered"})}setAttrs(){this.targetEl.classList.add(`${s.prefix}panel`),this.options.classes&&classes(this.targetEl).add(this.options.classes),(this.options.collapsed||this.options.deferred)&&this.targetEl.toggleAttribute("collapsed",!0),this.options.headClosable&&this.targetEl.toggleAttribute("headclosable",!0),this.options.feature&&this.targetEl.setAttribute("feature",this.options.feature),this.options.lamp&&this.targetEl.setAttribute("lamp",this.options.lamp),this.options.theme&&this.targetEl.setAttribute("theme",this.options.theme)}renderFinish(){this.closeEl=this.options.headClosable?this.headEl:this.arrowEl,this.closeEl&&(this.closeEl.removeEventListener("click",this.closeEvt),this.closeEl.addEventListener("click",this.closeEvt,!1));for(let t of this.options.tools.children)"toggle"===t.name?t.wrapEl.onclick=()=>{t.iconEl.classList.contains(t.icon)?(this.targetEl.toggleAttribute("max",!0),classes(t.iconEl).replace(t.icon,t.swap)):(this.targetEl.toggleAttribute("max",!1),classes(t.iconEl).replace(t.swap,t.icon))}:t.action&&t.action.call(this,t);this.options.tab.enable&&this.headEl.querySelector(`.${s.prefix}tab-head`)&&this.bodyEl.querySelector(`.${s.prefix}tab-body`)&&(this.tabIns=new Tab(this.targetEl,this.options.tab))}async expand(t){if(this.destroyed||!this.transmitioned||elState(this.bodyEl).isVisible)return this;try{this.options.b4Expand&&await this.options.b4Expand.call(this)}catch(t){return}return this.options.deferred&&!this.contEl.innerHTML&&await this.getDataToRender(!0),slideDown({el:this.bodyEl,before:()=>{this.transmitioned=!1,super.listen({name:"expand"})},doing:()=>{this.toggleArrow(!0)},done:()=>{this.transmitioned=!0,super.listen({name:"expanded",cb:t}),super.updateCache({collapsed:!1})}}),this}async collapse(t){if(this.destroyed||!this.transmitioned||elState(this.bodyEl).isHidden)return this;try{this.options.b4Collapse&&await this.options.b4Collapse.call(this)}catch(t){return}return slideUp({el:this.bodyEl,before:()=>{this.transmitioned=!1,super.listen({name:"collapse"})},doing:()=>{this.toggleArrow(!1)},done:()=>{this.transmitioned=!0,super.listen({name:"collapsed",cb:t}),super.updateCache({collapsed:!0})}}),this}destroy(t){return this.destroyed||(this.closeEl&&this.closeEl.removeEventListener("click",this.closeEvt),this.contXhr&&this.contXhr.abort(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const At=[{attr:"routes",prop:"routes",value:[]},{attr:"current",prop:"current",value:""},{attr:"redirect",prop:"redirect",value:[]},{attr:"before-check",prop:"beforeCheck",value:null},{attr:"after-check",prop:"afterCheck",value:null},{attr:"purpose",prop:"purpose",value:"sort"},{attr:"point",prop:"point",value:{before:["t/3"],after:["b/3"]}},{attr:"holder",prop:"holder",value:{from:!1,to:!1}},{attr:"arrow",prop:"arrow",value:{enable:!1,icon:`${s.prefix}icon-right`,placement:"left",selector:""}},{attr:"gesture",prop:"gesture",value:{}},{attr:"delay",prop:"delay",value:50},{attr:"duration",prop:"duration",value:200},{attr:"b4-drop",prop:"b4Drop",value:null},{attr:"on-dropping",prop:"onDropping",value:null},{attr:"on-dropped",prop:"onDropped",value:null},{attr:"on-dragstart",prop:"onDragStart",value:null},{attr:"on-dragmove",prop:"onDragMove",value:null},{attr:"on-dragend",prop:"onDragEnd",value:null},{attr:"on-located",prop:"onLocated",value:null},...p];class Router extends ModBaseListen{options={};routes;current;stateEvt;static hostType="none";constructor(t={},e=!0){super(),super.ready({options:t,maps:At}),this.routes=this.options.routes||[],this.current=this.options.current,this.stateEvt=t=>{if(t.state){if(this.current!==t.state.path){let e=this.getRoute(t.state.path),s=this.getRoute();if(this.options.beforeCheck){let t=this.options.beforeCheck(e,s);if("string"==typeof t){let e=this.getRoute(t);if(!e)return;this.push(e)}else if(!t)return}this.current=t.state.path,e.action&&e.action.call(this,e),super.listen({name:"located",params:[e]})}}else;},super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return window.addEventListener("popstate",this.stateEvt),this.current=this.getUrlPath(),this.add({path:this.current,action:null}),super.listen({name:"initiated",cb:t}),this}getUrlPath(){return window.location.pathname+window.location.search+window.location.hash}getRoute(t=this.current){return this.routes.find((e=>e.path===t))}add(t){let e=this.routes.find((e=>e.path===t.path));e?Object.assign(e,t):this.routes.push(t)}remove(t){this.routes.filter((e=>e.path!==t))}push(t,e){if(isNull(t)||this.destroyed)return;if(this.options.beforeCheck){let e=this.options.beforeCheck(t,this.getRoute());if("string"==typeof e)(t=this.getRoute(t.resp))||(window.location.href=e);else if(!e)return}let s=this.getRoute(t.path);return s?(this.replace(t),Object.assign(s,t),this):(this.add(t),history.pushState({path:t.path},Date.now()+"",t.path),this.current=t.path,t.action&&t.action.call(this,t),super.listen({name:"located",cb:e,params:[t]}),this)}replace(t,e){if(isNull(t)||this.destroyed)return;let s=this.getRoute(t.path);if(!s)return this.push(t),this;if(Object.assign(s,t),this.options.beforeCheck){let e=this.options.beforeCheck(s,this.getRoute());if("string"==typeof e){if(!(t=this.getRoute(t.resp)))return}else if(!e)return}return history.replaceState({path:t.path},Date.now()+"",t.path),this.current=t.path,t.action&&t.action.call(this,t),super.listen({name:"located",cb:e,params:[t]}),this}back(){if(!this.destroyed)return history.go(-1),this}forward(){if(!this.destroyed)return history.go(1),this}go(t){if(!this.destroyed)return"string"==typeof t?this.push(this.getRoute(t)):history.go(t),this}clear(){return this.routes=[],this}routeChange(t){if(!t)return;let e=this.routes[t];e&&(this.current=t,e.call(this))}beforeCheck(t,e,s){}afterCheck(){}restore(){return this}destroy(t){if(!this.destroyed)return this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const Tt=[{attr:"target",prop:"target",value:""},{attr:"auto-idx",prop:"autoIdx",value:!1},{attr:"content",prop:"content",value:""},{attr:"gallery",prop:"gallery",value:!0},{attr:"autoplay",prop:"autoplay",value:!1},{attr:"thumb",prop:"thumb",value:{enable:!1,show:!0,placement:"bottom",size:70,gap:8,divide:1}},{attr:"aside",prop:"aside",value:{enable:!1,expanded:!0,placement:"end",title:"",closable:!0,delay:0,getter:null,template:"",engine:renderTpl}},{attr:"mode",prop:"mode",value:"fixed"},{attr:"inverted",prop:"inverted",value:!1},{attr:"width",prop:"width",value:0},{attr:"height",prop:"height",value:0},{attr:"swipe",prop:"swipe",value:{}},{attr:"active",prop:"active",value:0},{attr:"z-index",prop:"zIndex",value:0},{attr:"tools",prop:"tools",value:{enable:!0,children:["close"]}},{attr:"total",prop:"total",value:{enable:!0,format:""}},{attr:"act-class",prop:"actClass",value:l.actClass},{attr:"cont-type",prop:"contType",value:"text"},{attr:"cont-data",prop:"contData",value:{}},{attr:"ajax",prop:"ajax",value:{}},{attr:"on-changed",prop:"onChanged",value:null},{attr:"on-filledaside",prop:"onFilledAside",value:null},...p],init=(t,e)=>{let i=getEl(e)||document.body,a=new Function("el","module",'"use strict";try {return new module(el)} catch {return null}'),l=[],getNodeList=t=>{let e=(()=>{let t=[];for(let[e,i]of Object.entries(s))"node"===i?.hostType&&t.push(e);return t})();return(isEmpty(t)?e:t.filter((t=>e.includes(t)))).map((t=>getEls(`[ax-${t}]`,i).filter((e=>!e.ax||e.ax&&!e.ax[t])).map((e=>({module:t,node:e})))))},activeFn=t=>{if(["Dialog","Drawer","Popup"].includes(t.module))higherParent(t.module,t.node);else{a(t.node,s[t.module])&&((t,e)=>{storeNode(t)?.addModule(e)})(t.node,t.module)}},higherParent=(t,e)=>{let eachInstance=(e,i)=>{let l,n=a(e,s[t]);if(n&&(e[t]=!0,i&&(n.targetEl.style.zIndex=parseInt(getComputedStyle(i.targetEl).zIndex)+1),l=getEls(`[ax-${t}]`,n.contEl),l.length>0))for(let t of l)eachInstance(t,n)};eachInstance(e)};if(isEmpty(t))l=getNodeList();else{let e,s=getDataType(t);e="String"===s?[t]:"Array"===s?t:[],l=e.length>0?getNodeList(e):[]}let n=l.flat();if(n.length&&decompTask({tasks:n,count:4,type:"idle",done:()=>{},run:t=>activeFn(t)}),isEmpty(t)||t?.includes("lazy")){let t=getEls("[lazy-src]",i),e=getEls("[lazy-async]",i);for(let e of t)e?.ax?.lazy||new Lazy(e,{content:e.getAttribute("lazy-src"),type:"src"});for(let t of e)t?.ax?.lazy||new Lazy(t,{content:t.getAttribute("lazy-async"),contType:t.getAttribute("lazy-type"),contData:strToJson(t.getAttribute("lazy-data")),tplStr:t.getAttribute("lazy-tpl"),type:"async"})}if(isEmpty(t)||t?.includes("viewer")){let t=getEls("[ax-viewer]",i),e=[];for(let s of t){let t=attrToJson(s,"ax-viewer"),i=t.insName,a=getEl("[src]",s),l=s.hasAttribute("src")?s:a,n=l?.nodeName?.toLocaleLowerCase()||"",r=l?.getAttribute("alt")||l?.getAttribute("title")||"",o=["video","audio","iframe"].includes(n)?n:"image",h=l?{media:l.getAttribute("src"),caption:r,type:o}:"",p=[t.content||h].flat();if(t.content=p,t.target=[],i){let a=e.find((t=>t.name===i)),l=0;a?(Reflect.deleteProperty(t,"content"),Reflect.deleteProperty(t,"target"),deepMerge(a,t),l=a.options.content.length,storeNode(s).addData("viewer",l),a.options.target.push(s),a.options.content.push(...p)):t.target.push(s),storeNode(s).addData("viewer",l)}else t.content=p,t.target.push(s);e.push({name:i,options:t})}for(let t of e)new Viewer(t.options)}return s};class Viewer extends ModBaseListen{data;maskEl;headEl;totalEl;toolsEl;bodyEl;stageEl;thumbEl;footEl;viewerEl;hideEvt;shown;stageIns;thumbIns;showEvt;targetEls;locateIdx;asideEl;titleEl;closeEl;contEl;overwritable;change2FillEvt;static hostType="none";static optMaps=Tt;constructor(t={},e=!0){super(),super.ready({options:t,maps:Viewer.optMaps,spread:["total","tools","thumb"]});let s=this;this.data=[],this.shown=!1,this.overwritable=!0,this.targetEls=getEls(this.options.target),this.hideEvt=()=>{if("inline"!==this.options.mode&&(!this.viewerEl.hasAttribute("show")&&this.viewerEl.remove(),this.targetEls.length))for(let t of this.targetEls)t.classList.remove(this.options.actClass)},this.showEvt=debounce((function(t){"inline"!==s.options.mode&&(preventDft(t),!s.shown&&s.show(),this.classList.add(s.options.actClass),s.locateIdx=isNull(this?.ax?.viewer)?s.options.autoIdx?s.targetEls.findIndex((t=>t===this)):null:this?.ax?.viewer,!isNull(s.locateIdx)&&s.stageIns.prepared&&s.stageIns.toLocate(s.locateIdx))})),this.change2FillEvt=debounce((t=>{(this.overwritable||!this.contEl.innerHTML)&&this.fillAside(null,t)}),this.options.aside.delay),super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}if(s.isPortraitScr&&(this.options.thumb.enable&&(this.options.thumb.placement="bottom"),this.options.aside.enable&&(this.options.aside.expanded=!1)),this.data=await this.getStdData(),this.getStructure(),this.setThumbIns(),this.setStageIns(),this.setAttrs(),this.setTools(),this.targetEls.length&&"inline"!==this.options.mode)for(let t of this.targetEls)t.addEventListener("click",this.showEvt,!1);this.options.aside.enable&&(this.options.aside.expanded?this.expand():this.collapse()),"inline"===this.options.mode&&this.targetEls[0]&&this.show(),super.listen({name:"initiated",cb:t})}setTools(){if(this.options.tools.enable){createTools(this.options.tools.children,this.toolsEl,this);for(let t of this.options.tools.children)"close"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.close),t.wrapEl.onclick=()=>{this.hide()}):"zoom"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.zoom),t.wrapEl.onclick=debounce((()=>{this.stageIns.enable2Init(this.stageIns.snapSlider),this.stageIns.toggleZoom(this.stageIns.snapSlider)}))):"zoomin"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.zoomin),t.wrapEl.onclick=debounce((()=>{this.stageIns.enable2Init(this.stageIns.snapSlider),this.stageIns.snapSlider.zoomIns.stepFn(null,1,"keyboard")}))):"zoomout"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.zoomout),t.wrapEl.onclick=debounce((()=>{this.stageIns?.snapSlider?.zoomIns&&(this.stageIns.snapSlider.zoomIns.stepFn(null,-1,"keyboard"),this.stageIns.snapSlider.zoomIns.nowVals.scale.x===this.stageIns.snapSlider.rawTrans.scale.x&&this.stageIns.snapSlider.zoomIns.destroy())}))):"play"===t.name?t.wrapEl.onclick=debounce((()=>{this.stageIns.paused?this.options.autoplay?this.stageIns.autoPlay():this.stageIns.play():this.options.autoplay?this.stageIns.autoPause():this.stageIns.pause()})):"flipv"===t.name||"fliph"===t.name?(t.wrapEl.setAttribute("title",this.options.lang[t.name]),t.wrapEl.onclick=debounce((()=>{let e=this.stageIns.snapSlider.slider.querySelector(`.${s.prefix}viewer-media`),i=C.get(e,["scale"]).scale,a={x:i.x*("fliph"===t.name?-1:1),y:i.y*("flipv"===t.name?-1:1)};C.set({el:e,data:{scale:a}})}))):"download"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.download),t.wrapEl.onclick=debounce((()=>{let t=this.data.find((t=>t.wrapEl===this.stageIns.snapSlider.slider)),e=t?.source||t?.media;if(!t||!e||t.type&&!["image","video","audio"].includes(t.type))return;let s=createEl("a",{download:"",style:"display:none",target:"_blank",href:e});document.body.appendChild(s),s.click(),setTimeout((()=>s.remove()),1e3)}))):"thumb"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.thumb),t.wrapEl.onclick=debounce((()=>{let t=this.viewerEl.hasAttribute("nonthumb");this.viewerEl.toggleAttribute("nonthumb",!t)}))):"fullscr"===t.name?(t.wrapEl.setAttribute("title",this.options.lang.fullscrOn),t.wrapEl.onclick=debounce((()=>{document.fullscreenElement?document.exitFullscreen().then((()=>{this.toggleScreenAttr(t,"on")})):document.documentElement.requestFullscreen().then((()=>{this.toggleScreenAttr(t,"off")}))}))):"rotatel"===t.name||"rotater"===t.name?(t.wrapEl.setAttribute("title",this.options.lang[t.name]),t.wrapEl.onclick=debounce((()=>{let e=this.stageIns.snapSlider.slider.querySelector(`.${s.prefix}viewer-media`),i=C.get(e,["rotate"]).rotate;C.set({el:e,data:{rotate:i+90*("rotatel"===t.name?-1:1)}})}))):"more"===t.name&&(t.wrapEl.setAttribute("title",this.options.lang.expand),t.wrapEl.onclick=debounce((()=>{this.options.aside.enable&&(this.viewerEl.hasAttribute("expanded")?this.collapse():this.expand())})))}}toggleMoreAttr(t){let e=this.options.tools.children.find((t=>"more"===t.name));if(!e)return;let s=classes(e.iconEl);"off"===t?(e.wrapEl.setAttribute("title",this.options.lang.collapse),s.replace(e.icon,e.swap)):(e.wrapEl.setAttribute("title",this.options.lang.expand),s.replace(e.swap,e.icon))}toggleScreenAttr(t,e){let s=classes(t.iconEl);"off"===e?(t.wrapEl.setAttribute("title",this.options.lang.fullscrOff),s.replace(t.icon,t.swap)):(t.wrapEl.setAttribute("title",this.options.lang.fullscrOn),s.replace(t.swap,t.icon))}togglePlayAttr(t,e){let s=classes(t.iconEl);"play"===e?(t.wrapEl.setAttribute("title",this.options.lang.play),s.replace(t.swap,t.icon)):(t.wrapEl.setAttribute("title",this.options.lang.pause),s.replace(t.icon,t.swap))}getCurData(t=this.stageIns.actIdx,e={}){let s=e.index,i=e.slider,a=e.thumb;if(isEmpty(e)){let e=getDataType(t);"Number"===e?s=t:"Object"===e?s=this.stageIns.sliders.findIndex((e=>e===t)):e.includes("HTML")&&(s=this.stageIns.sliders.findIndex((e=>e.slider===t))),s>-1&&(i=this.stageIns.sliders[s],a=this.thumbIns?.sliders[s])}return{index:s,slider:i,thumb:a,content:e.content||this.data[s]}}async fillAside(t=this.stageIns.actIdx,e={}){if(!this.options.aside.enable||!this.options.aside.getter)return;let s=this.getCurData(t,e),i=await this.options.aside.getter.call(this,s);!isNull(i)&&this.setAsideCont(i)}setAsideCont(t){this.options.aside.enable&&(setContent({content:t,target:this.contEl,template:this.options.aside.template,engine:this.options.aside.engine}),super.listen({name:"filledAside",params:[t]}))}setStageIns(){this.stageIns=new Swipe(this.stageEl,deepMerge({thumb:{content:this.thumbIns,mode:"locate"},zoom:{enable:!0},nav:{fill:!0},total:{enable:!0,selector:this.totalEl},keyboard:!0,active:this.options.active,autoplay:this.options.autoplay,onChanged:(t,e)=>{let s={index:e,slider:t,thumb:this.thumbIns?.sliders[e],content:this.data[e]};this.change2FillEvt(s),super.listen({name:"changed",params:[s]})},onPaused:()=>{let t=this.options.tools.children.find((t=>"play"===t.name));t&&this.togglePlayAttr(t,"play")},onPlayed:()=>{let t=this.options.tools.children.find((t=>"play"===t.name));t&&this.togglePlayAttr(t,"pause")},onPrepared:()=>{isNull(this.locateIdx)||(this.stageIns.scrollIns.tmpTarget=this.stageIns.sliders[this.locateIdx].slider)}},this.options.swipe))}setThumbIns(){if(!this.options.thumb.enable)return;let t={slides:"auto",nav:{enable:!1},flow:"bottom"===this.options.thumb.placement?"h":"v",scroll:{resizeThr:2}};t["bottom"===this.options.thumb.placement?"height":"width"]=this.options.thumb.size,this.thumbIns=new Swipe(this.thumbEl,deepMerge(t,this.options.thumb))}setAttrs(){this.viewerEl.toggleAttribute("nonthumb",!this.options.thumb.show),this.options.zIndex&&(this.viewerEl.style.zIndex=this.options.zIndex),this.options.thumb.enable&&this.viewerEl.setAttribute("thumb",this.options.thumb.placement),this.options.classes&&classes(this.viewerEl).add(this.options.classes),this.viewerEl.setAttribute("mode",this.options.mode),this.viewerEl.toggleAttribute("inverted",this.options.inverted),this.options.aside.enable?this.viewerEl.setAttribute("aside",this.options.aside.placement):this.viewerEl.removeAttribute("aside")}getStageSlideStr(t){if("video"==t.type)return`<video controls lazy-src="${t.media}"></video>`;if("audio"==t.type)return`<audio controls lazy-src="${t.media}"></audio>`;if("iframe"==t.type)return`<iframe lazy-src="${t.media}" frameborder="0" width="100%" height="100%"></iframe>`;if("html"==t.type){let e=getEl(t.media);return`<div class="${s.prefix}viewer-text" ${t.unfenced?"unfenced":""}>${e?.innerHTML||""}</div>`}return"text"==t.type?`<div class="${s.prefix}viewer-text" ${t.unfenced?"unfenced":""}>${t.media}</div>`:`<img lazy-src="${t.media}"/>`}fillStage(){let t=getEl("ul",this.stageEl),e=document.createDocumentFragment();for(let t of this.data){if(t.mediaEl=createEl("div",{class:`${s.prefix}viewer-media`}),t.captionEl=createEl("div",{class:`${s.prefix}viewer-caption`},t.caption),t.wrapEl=createEl("li",{},t.mediaEl),"dom"===t.type){let e=getEl(t.media),i=createEl("div",{class:`${s.prefix}viewer-dom`},e);t.unfenced&&i.toggleAttribute("unfenced",!0),t.mediaEl.appendChild(i)}else t.mediaEl.innerHTML=this.getStageSlideStr(t);if(t.srcEl=t.mediaEl.firstElementChild,t.caption&&t.wrapEl.appendChild(t.captionEl),t.attrs)for(let e in t.attrs)t.srcEl.setAttribute(e,t.attrs[e]);e.appendChild(t.wrapEl)}t.appendChild(e)}fillThumb(){if(!this.options.thumb.enable)return;let t=getEl("ul",this.thumbEl),e=document.createDocumentFragment();for(let t of this.data){let i=t.cover||("image"===t.type?t.media:"")||s.images.none;t.coverEl=createEl("li",{},`<img lazy-src="${i}"/>`),e.appendChild(t.coverEl)}t.appendChild(e)}getStructure(){let t="end"===this.options.aside.placement?"right":"left",e=`<div class="${s.prefix}viewer-aside">\n        ${this.options.aside.closable?"<i "+s.alias+'="close" class="'+s.prefix+"icon-arrow-"+t+'" title="'+this.options.lang.collapse+'"></i>':""}\n        ${this.options.aside.title?'<div class="'+s.prefix+'viewer-title"><span '+s.alias+'="title">'+this.options.aside.title+"</span></div>":""}\n        <div class="${s.prefix}viewer-wrap">\n            <div class="${s.prefix}viewer-cont"></div>\n        </div>\n      </div>\n      `;this.viewerEl=createEl("div",{class:`${s.prefix}viewer`},`\n            <div class="${s.prefix}viewer-mask"></div>\n            <div class="${s.prefix}viewer-body">\n                <div class="${s.prefix}viewer-head">\n                    <div class="${s.prefix}viewer-total"></div>\n                    <div class="${s.prefix}viewer-tools"></div>\n                </div>\n                <div class="${s.prefix}viewer-stage"><ul class="${s.prefix}reset"></ul></div>\n                <div class="${s.prefix}viewer-foot">\n                    <div class="${s.prefix}viewer-thumb"><ul class="${s.prefix}reset"></ul></div>\n                </div>\n            </div>\n            ${this.options.aside.enable?e:""}\n        `),this.maskEl=this.viewerEl.querySelector(`.${s.prefix}viewer-mask`),this.headEl=this.viewerEl.querySelector(`.${s.prefix}viewer-head`),this.totalEl=this.viewerEl.querySelector(`.${s.prefix}viewer-total`),this.toolsEl=this.viewerEl.querySelector(`.${s.prefix}viewer-tools`),this.bodyEl=this.viewerEl.querySelector(`.${s.prefix}viewer-body`),this.stageEl=this.viewerEl.querySelector(`.${s.prefix}viewer-stage`),this.thumbEl=this.viewerEl.querySelector(`.${s.prefix}viewer-thumb`),this.footEl=this.viewerEl.querySelector(`.${s.prefix}viewer-foot`),this.asideEl=this.viewerEl.querySelector(`.${s.prefix}viewer-aside`),this.titleEl=this.asideEl?.querySelector(`[${s.alias}="title]"`),this.closeEl=this.asideEl?.querySelector(`:scope > [${s.alias}="close"]`),this.contEl=this.asideEl?.querySelector(`.${s.prefix}viewer-cont`),"fixed"!==this.options.mode&&(this.options.width&&this.viewerEl.style.setProperty(`--${s.prefix}viewer-w`,isNaN(this.options.width)?this.options.width:this.options.width+"px"),this.options.height&&this.viewerEl.style.setProperty(`--${s.prefix}viewer-h`,isNaN(this.options.height)?this.options.height:this.options.height+"px")),this.fillStage(),this.fillThumb(),this.viewerEl.addEventListener("transitionend",this.hideEvt,!1),this.stageEl.onclick=t=>{let e=getEvtTarget(t);[this.maskEl,this.stageEl].includes(e)&&this.hide()},this.closeEl&&(this.closeEl.onclick=()=>{this.collapse()}),init("lazy",this.viewerEl)}getDataFromFigure(t){let e=[];return getEl("figure",t)?(e=getEls("figure",t),e.map((t=>{let e=getEl("img",t),s=e?.getAttribute("src")||"";return{media:s,cover:s,caption:t.querySelector("figcaption")?.innerHTML||e?.getAttribute("alt")||e?.getAttribute("title")||"",type:"image"}}))):(e=getEls("img",t),e.map((t=>{let e=t.getAttribute("src")||"";return{media:e,cover:e,caption:t.getAttribute("alt")||t.getAttribute("title")||"",type:"image"}})))}getDataFromStr(t){t=t.trim();let e=getEl(t);return e?this.getDataFromFigure(e):valToArr(t).map((t=>({media:t,cover:t,type:"image"})))}async getStdData(t=this.options.content){"async"===this.options.contType&&await getContent.call(this,{content:t,contType:this.options.contType,contData:this.options.contData,ajax:{xhrName:"contXhr",spinSel:this.targetEl,...this.options.ajax},cb:async e=>{t=e}});let getDataFromSingle=t=>{let e=getDataType(t);return"String"===e?this.getDataFromStr(t):e.includes("HTML")?this.getDataFromFigure(t):"Object"===e?[t]:"Array"===e?t.map((t=>getDataFromSingle(t))).flat():void 0};return getDataFromSingle(t).filter((t=>t.media))}show(t){return this.destroyed||(super.listen({name:"show"}),("inline"===this.options.mode&&this.targetEls[0]?this.targetEls[0]:document.body).appendChild(this.viewerEl),this.viewerEl.setAttribute("show",""),this.shown=!0,super.listen({name:"shown",cb:t})),this}hide(t){if(this.destroyed||"inline"===this.options.mode)return this;super.listen({name:"hide"}),this.viewerEl.removeAttribute("show"),this.viewerEl.addEventListener("transitionend",this.hideEvt,!1);for(let t of getEls("video,audio",this.stageEl))t.pause();return this.shown=!1,super.listen({name:"hiddden",cb:t}),this}expand(t){return this.destroyed||(this.viewerEl.toggleAttribute("expanded",!0),this.toggleMoreAttr("off"),super.listen({name:"expanded",cb:t})),this}collapse(t){return this.destroyed||(this.viewerEl.toggleAttribute("expanded",!1),this.toggleMoreAttr("on"),super.listen({name:"expanded",cb:t})),this}destroy(t){if(this.destroyed)return this;if(this.viewerEl.removeEventListener("transitionend",this.hideEvt),this.targetEls.length&&"inline"!==this.options.mode)for(let t of this.targetEls)t.removeEventListener("click",this.showEvt);if(this.options.tools.enable)for(let t of this.options.tools.children)t.wrapEl.onclick=null;return this.closeEl&&(this.closeEl.onclick=null),this.stageEl.onclick=null,this.destroyed=!0,super.listen({name:"destroyed",cb:t}),this}}const St=[{attr:"classes",prop:"classes",value:""},{attr:"placement",prop:"placement",value:"bottom"},{attr:"content",prop:"content",value:""},{attr:"status",prop:"status",value:"info"},{attr:"delay",prop:"delay",value:3e3},{attr:"iconized",prop:"iconized",value:!1},{attr:"eager",prop:"eager",value:!1},{attr:"feature",prop:"feature",value:""},{attr:"z-index",prop:"zIndex",value:0},{attr:"on-shown",prop:"onShown",value:null},{attr:"on-hidden",prop:"onHidden",value:null},...p];class Toast extends ModBaseListen{options={};hideEvt;template;shown;contEl;static hostType="none";static optMaps=St;constructor(t,e=!0){super(),super.ready({options:t,type:Toast.hostType,maps:Toast.optMaps}),this.hideEvt=()=>{!this.shown&&this.targetEl.remove()},super.listen({name:"constructed"}),e&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch{return this}return this.shown=!1,this.createSection(),this.setAttrs(),this.options.eager&&this.show(),super.listen({name:"initiated",cb:t}),this}setAttrs(){this.options.classes&&classes(this.targetEl).add(this.options.classes),this.options.zIndex&&(this.targetEl.style.zIndex=this.options.zIndex),this.options.feature&&this.targetEl.setAttribute("feature",this.options.feature)}createSection(){let t=this.options.iconized?'<i rep="icon"></i>':"",e=`\n            <div class="${s.prefix}toast" placement="${this.options.placement}" status="${this.options.status}" ${this.options.iconized?"iconized":""}>\n            <div rep="wrap">\n                ${t}<div rep="cont">${this.options.content||this.options.lang.content[this.options.status]}</div>\n            </div>\n        </div>\n        `;this.targetEl=tplToEl(e),this.contEl=getEl(`[${s.alias}="cont"]`,this.targetEl),this.targetEl.addEventListener("transitionend",this.hideEvt,!1)}hideOthers(){if(this.options.zIndex)return;let t=h.findAll("toast").filter((t=>t.shown));for(let e of t)e.hide()}show(t){return this.destroyed||this.shown||(this.hideOthers(),document.body.appendChild(this.targetEl),this.targetEl.toggleAttribute("show",!0),this.shown=!0,setTimeout((()=>{this.hide()}),this.options.delay),super.listen({name:"shown",cb:t})),this}hide(t){return this.destroyed||!this.shown||(this.targetEl.toggleAttribute("show",!1),this.shown=!1,super.listen({name:"hidden",cb:t})),this}updateCont(t,e){return this.destroyed||(this.contEl.innerHTML=t,this.options.content=t,super.listen({name:"updatedCont",cb:e,params:[t]})),this}async update(t,e){return this.destroyed||(this.targetEl.remove(),this.options=extend({target:this.options,source:t}),await this.init(),super.listen({name:"updated",cb:e,params:[t]})),this}destroy(t){return this.destroyed||(this.targetEl.remove(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}const kt=[{attr:"value",prop:"value",value:""},{attr:"layout",prop:"layout",value:"picker"},{attr:"classes",prop:"classes",value:""},{attr:"popup",prop:"popup",value:{}},{attr:"canvas",prop:"canvas",value:{showLabel:!0,showTools:!0,width:370,height:180,mode:"hsv",hue:0}},{attr:"output",prop:"output",value:{alpha:!0,mode:"hsl",format:"hsla",child:"",manual:!0}},{attr:"b4-assign",prop:"b4Assign",value:null},{attr:"b4-clear",prop:"b4Clear",value:null},{attr:"b4-fill",prop:"b4Fill",value:null},{attr:"b4-restore",prop:"b4Restore",value:null},{attr:"on-assigned",prop:"onAssigned",value:null},{attr:"on-cleared",prop:"onCleared",value:null},{attr:"on-restored",prop:"onRestored",value:null},{attr:"on-filled",prop:"onFilled",value:null},{attr:"on-output",prop:"onOutput",value:null},...p];class RadiosElem extends CompBaseCommField{labelEl;legendEl;inputs;setVals;setLabels;check;type;valMap;constructor(){super(),this.type="radios-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.reset=()=>{this.propsRaw.content!=this.propsRaw.content&&this.updateInputs(this.propsRaw.content,this.propsRaw);for(let t in this.propsRaw)"content"!==t&&(null!==this.propsRaw[t]&&!1!==this.propsRaw[t]?this.setAttribute(t,this.propsRaw[t]):this.removeAttribute(t));this.listen({name:"reset"})},this.clear=()=>{this.removeAttribute("checked"),this.listen({name:"cleared"})},this.check=(t,e="ed",s="value")=>{let i=Array.isArray(t)?t[0]:t;if(!i&&0!==i)return void this.setAttribute("checked","");let a=this.inputs.find((t=>t.propsProxy[s]==i));a&&("ing"===e?(a.checked&&this.setAttribute("checked",""),a.setAttribute("check",e)):"ed"===e?this.setAttribute("checked",a.propsProxy.value):a.checked&&this.setAttribute("checked",""))},this.propsObs.on("set",(t=>{"value"===t.key&&(this.valMap={newVal:t.value,oldVal:t.raw||""})})),this.propsObs.on("completed",(t=>{t.keys.set.includes("value")&&(this.updateCache({check:t.proxy.value}),this.listen({name:"changed",params:[this.valMap]}))}))}static dependencies=[{tag:"ax-radio",comp:RadioElem}];static custAttrs=["size","name","type","layout","cols","checked","disable","content","wrap-classes","item-classes","input-classes","on-checked",...this.evtsArr];static boolAttrs=["disabled","inverted"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,RadiosElem)}getRawData(){this.getRawProps(RadiosElem),!this.propsRaw.name&&(this.propsRaw.name=s.namePfx+Date.now()),this.propsRaw.content=super.getItemsData(),this.getProxyProps(),this.setFieldProps(["name","value","disabled"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),t["wrap-classes"]&&classes(this.wrapEl).add(t["wrap-classes"]),"grid"===t.layout?(this.wrapEl.classList.add(`${s.prefix}grid`),t.cols&&this.wrapEl.classList.add(`${s.prefix}avg-${t.cols}`)):"flex"===t.layout&&this.wrapEl.classList.add(`${s.prefix}row`),this.updateInputs(t.content,t)}updateInputs(t,e=this.propsProxy){this.inputs=[],this.wrapEl.innerHTML="";let i=super.getItemsData(t);for(let t of i){let i=createEl("div"),a=createEl("ax-radio",{label:t.label,value:isNull(t.value)?t.label:t.value,[s.embedSign]:""});e.name?a.setAttribute("name",e.name):a.removeAttribute("name"),e.type?a.setAttribute("type",e.type):a.removeAttribute("type"),t.checked?a.setAttribute("check","ed"):a.removeAttribute("check"),a.toggleAttribute("disabled",!!t.disabled),e["input-classes"]&&classes(a).add(e["input-classes"]),this.inputs.push(a),e.layout?("flex"===e.layout&&i.classList.add(`${s.prefix}flex`),e["item-classes"]&&classes(i).add(e["item-classes"]),i.appendChild(a),this.wrapEl.appendChild(i)):this.wrapEl.appendChild(a),a.on("changed",(t=>{let e=this.inputs.find((t=>"ed"===t.propsProxy.check));this.propsProxy.value=e?e.propsProxy.value:"",this.value=this.propsProxy.value,t.newVal&&this.listen({name:"checked",params:[a]})}))}}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={content:this.changedMultiCont,disabled:this.changedMultiDisabled,inverted:this.changedInverted,name:this.changedMultiName,type:this.changedMultiName,size:this.changedMultiName,checked:this.changedChecked,disable:this.changedMultiDisable};changedChecked(t){for(let e of this.inputs)null===t.newVal?e.check(""):e.check(e.propsProxy.value===t.newVal?"ed":"")}changedInverted(t){for(let t of this.inputs)t.toggleAttribute("inverted",this.propsProxy.inverted)}}class NumberElem extends CompBaseCommField{labelEl;tipsEl;incrEl;decrEl;type;select;oldVal;constructor(){super(),this.type="number-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.select=()=>this.inputEl.select(),this.oldVal=this.value="",this.on("input",(t=>{let e=parseFloat(this.propsProxy.step)||1,s=parseFloat(t),i=parseFloat(this.propsProxy.max),a=parseFloat(this.propsProxy.min);isNull(this.propsProxy.max)||(s+e>i?this.incrEl.toggleAttribute("disabled",!0):this.incrEl.removeAttribute("disabled")),isNull(this.propsProxy.min)||(s-e<a?this.decrEl.toggleAttribute("disabled",!0):this.decrEl.removeAttribute("disabled"))}))}static custAttrs=["name","placeholder","layout","size","max","min","step","label","attrs","on-exceeded",...this.evtsArr];static boolAttrs=["tips","disabled","readonly","full"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&(this.savePropsToListen(t,e,s,NumberElem),e!==s&&this.listen({name:"changed",params:[{oldVal:e,newVal:s}]}))}getRawData(){this.getRawProps(NumberElem),this.propsRaw.value=parseFloat(this.getAttribute("value")||this.getConnCont("text")),this.getProxyProps(),this.setFieldProps(["name","value","disabled","readOnly"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.inputEl=createEl("input",{type:"number",name:t.name,placeholder:t.placeholder||l.lang.form.placeholder,[s.embedSign]:""}),(t.value||0==t.value)&&(this.inputEl.value=t.value),this.decrEl=createEl("i",{[s.alias]:"decrease"},"minus"),this.incrEl=createEl("i",{[s.alias]:"increase"},"plus"),this.labelEl=createEl("span",{[s.alias]:"label"}),this.wrapEl.append(this.decrEl,this.inputEl,this.incrEl),this.tipsEl=createEl("div",{[s.alias]:"tips"})}updateTips(){let t=parseFloat(this.value);if(isNaN(t))return;let e=isNull(this.propsProxy.max)?"+∞":parseFloat(this.propsProxy.max),s=isNull(this.propsProxy.min)?"-∞":parseFloat(this.propsProxy.min),i=""===this.oldVal?"":parseFloat(this.oldVal),a="";if("+∞"===e&&"-∞"===s)return this;"+∞"!==e&&"-∞"!==s?(a=renderTpl(this.propsProxy.lang?.limit||l.lang.form.limitNumber,{max:e,min:s}),t>=s&&t<=e?this.removeAttribute("exceeded"):(this.setAttribute("exceeded",""),a+=this.propsProxy.lang?.exceed||l.lang.form.exceed,t=t<s?s:t>e?e:t,this.listen({name:"exceeded",params:[t,i]}))):"+∞"!==e?(a=renderTpl(this.propsProxy.lang?.max||l.lang.form.maxNumber,{max:e}),t>e?(t=e,this.setAttribute("exceeded",""),a+=this.propsProxy.lang?.exceed||l.lang.form.exceed,this.listen({name:"exceeded",params:[t,i]})):this.removeAttribute("exceeded")):"-∞"!==s&&(a=renderTpl(this.propsProxy.lang?.min||l.lang.form.minNumber,{min:s}),t<s?(t=s,this.setAttribute("exceeded",""),a+=this.propsProxy.lang?.exceed||l.lang.form.exceed,this.listen({name:"exceeded",params:[t,i]})):this.removeAttribute("exceeded")),t!==i&&this.setAttribute("value",t+""),this.tipsEl.innerHTML=a}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.tips&&(this.propsProxy.max||this.propsProxy.min)&&elState(this.tipsEl).isVirtual&&this.appendChild(this.tipsEl);let t=new Event("input",{bubbles:!0});this.decrEl.onclick=()=>{this.inputEl.stepDown(),this.inputEl.dispatchEvent(t)},this.incrEl.onclick=()=>{this.inputEl.stepUp(),this.inputEl.dispatchEvent(t)},this.inputEl.addEventListener("input",debounce((t=>{this.setBtnDisabled(),this.propsProxy.value!=this.inputEl.value&&(this.value=this.inputEl.value,this.updateTips(),this.oldVal=this.value,this.listen({name:"input",params:[this.inputEl.value]}))})),!1),this.setBtnDisabled()}setBtnDisabled(t=this.inputEl.value){let e=parseFloat(t);isNaN(e)||(this.decrEl.toggleAttribute("disabled",!!(this.propsProxy.min&&e<=parseFloat(this.propsProxy.min))),this.incrEl.toggleAttribute("disabled",!!(this.propsProxy.max&&e>=parseFloat(this.propsProxy.max))))}changedMaps={disabled:this.changedBool,readonly:this.changedBool,blocked:this.changedBool,tips:this.changedBool,name:this.changedName,placeholder:this.changedName,value:this.changedValue,min:this.changedValue,max:this.changedValue,step:this.changedValue,label:this.changedLabel,attrs:this.changedAttrs};changedBool(t){this.inputEl["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name],this["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name],"tips"===t.name&&(this.propsProxy.tips?elState(this.tipsEl).isVirtual&&this.appendChild(this.tipsEl):this.tipsEl.remove())}changedValue(t){this.inputEl[t.name]=t.newVal,"value"===t.name&&this.inputEl.dispatchEvent(new Event("input")),["min","max"].includes(t.name)&&this.updateTips()}changedName(t){this.inputEl.setAttribute(t.name,t.newVal),"name"===t.name&&(this.name=t.newVal)}changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.labelEl),this.setAttribute("layout","embed")):this.labelEl.remove()}}class Color extends ModBaseListenCache{spaceEl;outputEl;toolsEl;canvasEl;canvasModeEl;randomEl;previewEl;hRangeEl;aRangeEl;alphaEl;strawEl;restoreEl;clearEl;confirmEl;copyEl;indEl;valueEl;changeEl;hexEl;hexaEl;rgbrEl;rgbgEl;rgbbEl;rgbaEl;hslhEl;hslsEl;hsllEl;hslaEl;hwbhEl;hwbwEl;hwbbEl;hwbaEl;wrapEl;schemeEl;pickerEl;paletteEl;outputHexEl;outputRgbEl;outputHwbEl;outputHslEl;outputBodyEl;axisyEl;canvasCtx;curColors;indCoord;gestureIns;canvasRect;previewChildEl;canvasMode;canvasHue;hRangeEvt;aRangeEvt;alphaEvt;modeEvt;showAlpha;outputMode;outputMap;changeEvt;randomEvt;canvasWidth;canvasHeight;copyEvt;previewEvt;colorEvt;coloraEvt;colorhEvt;eyeDropper;strawEvt;stopOutput;themeColorsEl;themeWrapEl;historyColorsEl;historyWrapEl;presets1El;presets2El;colorEl;popupIns;fillEl;value;dialogEl;static hostType="node";static optMaps=kt;static dependencies=[RadiosElem,InputElem,NumberElem,BtnElem,CheckboxElem];constructor(t,e={},s=!0){super(),super.ready({options:e,host:t,maps:Color.optMaps,component:!0,spread:["output","arrow","check","lamp","tools","drag"]}),this.curColors={rgb:{r:255,g:0,b:0},hwb:{h:0,w:0,b:0},hsl:{h:0,s:100,l:50},hex:"#ff0000",a:1,a16:"ff"},this.indCoord={x:0,y:0},this.hRangeEvt=t=>{this.canvasHue=this.curColors.hsl.h=this.curColors.hwb.h=parseFloat(t.target.value),this.curColors.rgb=hsl2Rgb(this.curColors.hsl,!1),this.curColors.hex=rgb2Hex(this.curColors.rgb,!1),this.updateReverse(),this.updatePreviewOutput()},this.aRangeEvt=t=>{this.curColors.a=parseFloat(t.target.value),this.curColors.a16=alpha2Hex(this.curColors.a),this.updatePreviewOutput()},this.modeEvt=debounce((t=>{this.canvasMode=t.newVal,this.drawCanvas(),this.setAxisLabel()})),this.alphaEvt=debounce((t=>{this.showAlpha=t.newVal,this.aRangeEl.toggleAttribute("disabled",!t.newVal),this.hexaEl.toggleAttribute("disabled",!t.newVal),this.rgbaEl.toggleAttribute("disabled",!t.newVal),this.hslaEl.toggleAttribute("disabled",!t.newVal),this.hwbaEl.toggleAttribute("disabled",!t.newVal),this.updatePreviewOutput()})),this.changeEvt=debounce((()=>{this.toggleOutputAct()})),this.randomEvt=debounce((()=>{this.canvasRect=this.canvasEl.getBoundingClientRect(),this.setValFromCanvas({x:Math.random()*this.canvasWidth,y:Math.random()*this.canvasHeight})})),this.copyEvt=debounce((()=>{navigator.clipboard.writeText(this.valueEl.textContent).then((()=>new Toast({content:this.options.lang.message.copy,status:"succ",eager:!0})))})),this.previewEvt=debounce((()=>{navigator.clipboard.writeText(this.previewChildEl.style.backgroundColor).then((()=>new Toast({content:this.options.lang.message.copy,status:"succ",eager:!0})))}));let i=this;this.colorEvt=debounce((function(t){i.stopOutput=!0;let e={};if(this===i.hexEl){if(7!==t.target.value.length)return;e.hex=t.target.value}else{let s=parseFloat(t.target.value);if(isNaN(s))return;this===i.rgbrEl?(e={...i.curColors.rgb},e.r=s):this===i.rgbgEl?(e={...i.curColors.rgb},e.g=s):this===i.rgbbEl?(e={...i.curColors.rgb},e.b=s):this===i.hslsEl?(e={...i.curColors.hsl},e.s=s):this===i.hsllEl?(e={...i.curColors.hsl},e.l=s):this===i.hwbwEl?(e={...i.curColors.hwb},e.w=s):this===i.hwbbEl&&(e={...i.curColors.hwb},e.b=s)}e.a=i.curColors.a,i.assignVals(e),i.stopOutput=!1}),500),this.coloraEvt=debounce((t=>{i.stopOutput=!0;let e=parseFloat(t.target.value);if(isNaN(e))return;let s="hex"===this.outputMode?{hex:this.curColors[this.outputMode]}:{...this.curColors[this.outputMode]};s.a=e,this.assignVals(s),i.stopOutput=!1}),500),this.colorhEvt=debounce((t=>{i.stopOutput=!0;let e=parseFloat(t.target.value);if(isNaN(e))return;let s={...this.curColors[this.outputMode]};s.a=this.curColors.a,s.h=e,this.assignVals(s),i.stopOutput=!1}),500),this.strawEvt=async()=>{try{let t=(await this.eyeDropper.open()).sRGBHex;this.assignVals(t)}catch{}},super.listen({name:"constructed"}),s&&this.init()}async init(t){super.listen({name:"initiate"});try{this.options.b4Init&&await this.options.b4Init.call(this)}catch(t){return this}return!["picker","full"].includes(this.options.layout)&&(this.options.output.manual=!1),this.canvasMode=this.options.canvas.mode,this.canvasHue=this.options.canvas.hue,this.showAlpha=this.options.output.alpha,this.outputMode=this.options.output.mode,this.canvasWidth=toPixel("xxs"===s.screen?300:this.options.canvas.width),this.canvasHeight=toPixel("xxs"===s.screen?150:this.options.canvas.height),this.fillEl=getEl(this.options.fillEl,this.targetEl)||this.targetEl,this.setAttrs(),this.createPanel(),this.drawCanvas(),this.setGesture(),this.setPopup(),this.canvasModeEl.on("changed",this.modeEvt),this.alphaEl.on("changed",this.alphaEvt),this.hRangeEl.addEventListener("input",this.hRangeEvt,!1),this.aRangeEl.addEventListener("input",this.aRangeEvt,!1),this.changeEl.addEventListener("click",this.changeEvt,!1),this.randomEl.addEventListener("click",this.randomEvt,!1),this.hexEl.addEventListener("input",this.colorEvt,!1),this.rgbrEl.addEventListener("input",this.colorEvt,!1),this.rgbgEl.addEventListener("input",this.colorEvt,!1),this.rgbbEl.addEventListener("input",this.colorEvt,!1),this.hslsEl.addEventListener("input",this.colorEvt,!1),this.hsllEl.addEventListener("input",this.colorEvt,!1),this.hwbwEl.addEventListener("input",this.colorEvt,!1),this.hwbbEl.addEventListener("input",this.colorEvt,!1),this.hexaEl.addEventListener("input",this.coloraEvt,!1),this.rgbaEl.addEventListener("input",this.coloraEvt,!1),this.hslaEl.addEventListener("input",this.coloraEvt,!1),this.hwbaEl.addEventListener("input",this.coloraEvt,!1),this.hwbhEl.addEventListener("input",this.colorhEvt,!1),this.hslhEl.addEventListener("input",this.colorhEvt,!1),this.copyEl.addEventListener("click",this.copyEvt,!1),this.previewEl.addEventListener("click",this.previewEvt,!1),this.eyeDropper=new window.EyeDropper,this.strawEl.onclick=async()=>{try{let t=(await this.eyeDropper.open()).sRGBHex;this.assignVals(t)}catch{}},this.restoreEl.onclick=()=>{this.restoreVals()},this.confirmEl.onclick=()=>{this.value?this.fillVals():this.popupIns.hide()},this.clearEl.onclick=()=>{this.clearVals()},this.initVals(),super.listen({name:"initiated",cb:t}),this}updateReverse(){this.canvasHue=this.curColors.hsl.h,this.drawCanvas(),this.updateHueSlider(),this.updateAlphaSlider()}setAttrs(){this.options.classes&&this.colorEl&&classes(this.colorEl).add(this.options.classes)}toggleOutputAct(){let t=Object.keys(this.outputMap),e=t.find((t=>this.outputMap[t].active)),s=(t.indexOf(e)+1)%t.length;for(let e in this.outputMap)t[s]===e&&(this.outputMode=e,this.outputBodyEl.innerHTML="",this.outputBodyEl.appendChild(this.outputMap[e].el),this.setOutputStr(),this.setOutputVals()),this.outputMap[e].active=t[s]===e}updateHueSlider(){this.colorEl.style.setProperty(`--${s.prefix}color-thumb`,`hsl(${this.curColors.hsl.h}, 100%, 50%)`)}updateAlphaSlider(){this.colorEl.style.setProperty(`--${s.prefix}color-from`,`hsla(${this.curColors.hsl.h}, 100%, 50%,0)`),this.colorEl.style.setProperty(`--${s.prefix}color-to`,`hsla(${this.curColors.hsl.h}, 100%, 50%,1)`)}drawCanvas(t=this.canvasHue,e=this.canvasMode){this.canvasCtx=drawColor({el:this.canvasEl,width:this.canvasWidth,height:this.canvasHeight,hue:t,mode:e})}getColorFromCanvas(t,e){let s=this.canvasCtx.getImageData(t,e,1,1).data;return{r:s[0],g:s[1],b:s[2]}}canvasInteraction(t){let e=t.x,s=t.y,i=Math.max(0,Math.min(e,this.canvasEl.width-1)),a=Math.max(0,Math.min(s,this.canvasEl.height-1)),l=this.getColorFromCanvas(i,a),n=rgb2Hex(l,!1),r=rgb2Hsl(l,!1),o=rgb2Hwb(l,!1),h=.299*l.r+.587*l.g+.114*l.b>150;l.r===l.g&&l.g===l.b&&(r.h=o.h=this.curColors.hsl.h),this.curColors.rgb=l,this.curColors.hex=n,this.curColors.hsl=r,this.curColors.hwb=o,this.indEl.toggleAttribute("inverted",h),this.updatePreviewOutput()}updatePreview(){this.previewChildEl.style.backgroundColor=this.valueEl.textContent}updatePreviewOutput(){this.setOutputStr(),this.setOutputVals(),this.updatePreview()}setOutputStr(t=this.outputMode){let e,s,i;if("hex"===t)e=this.curColors[t],s=this.curColors.a16,i=`${e}${this.showAlpha?s:""}`;else{let a=deepClone(this.curColors[t]);"rgb"!==t&&(a.hasOwnProperty("s")&&(a.s+="%"),a.hasOwnProperty("l")&&(a.l+="%"),a.hasOwnProperty("w")&&(a.w+="%"),a.hasOwnProperty("b")&&(a.b+="%")),e=Object.values(a).join(","),s=this.curColors.a,i=`${t}${this.showAlpha?"a":""}(${e}${this.showAlpha?","+s:""})`}this.valueEl.innerHTML=i,this.value=this.getVals(),this.options.output.manual||this.fillVals(),super.listen({name:"output",params:[this.value]})}setOutputVals(){for(let t in this.outputMap[this.outputMode].children){this.outputMap[this.outputMode].children[t].setAttribute("value","a"===t?this.curColors.a:"hex"===this.outputMode?this.curColors[this.outputMode]:this.curColors[this.outputMode][t])}}setPopup(){this.popupIns&&this.popupIns.destroy();let t=deepMerge({content:this.colorEl,footer:!1,padding:!1,tools:!1,trigger:"click",size:"",adaptive:!1,canClose:t=>!this.dialogEl||!this.dialogEl.contains(t)},this.options.popup);this.popupIns=new Popup(this.targetEl,t)}createPanel(){this.wrapEl=createEl("div",{class:`${s.prefix}color-wrap`}),this.colorEl=createEl("div",{class:`${s.prefix}color`},this.wrapEl),this.pickerEl=createEl("div",{class:`${s.prefix}color-picker`,style:`width:${this.canvasWidth}px`}),this.schemeEl=createEl("div",{class:`${s.prefix}color-scheme`}),this.paletteEl=createEl("div",{class:`${s.prefix}color-palette`},`\n        <div class="${s.prefix}color-presets">\n                    <div class="${s.prefix}color-regular">\n                        <div ${s.alias}="body">\n                            <ul class="${s.prefix}color-preset-1 ${s.prefix}grid ${s.prefix}g-xs ${s.prefix}avg-10">\n                            </ul>\n                        </div>\n                    </div>\n                    <ax-br></ax-br>\n                    <ul class="${s.prefix}color-preset-2 ${s.prefix}reset ${s.prefix}grid ${s.prefix}g-sm"></ul>\n                </div>\n        `),this.presets1El=getEl(`.${s.prefix}color-preset-1`,this.paletteEl),this.presets2El=getEl(`.${s.prefix}color-preset-2`,this.paletteEl),this.presets1El.appendChild(this.getRegularPresets()),this.presets2El.append(this.getThemePresets(),this.getHistoryPresets()),"picker"===this.options.layout?this.wrapEl.append(this.pickerEl):"palette"===this.options.layout?this.wrapEl.append(this.paletteEl):"scheme"===this.options.layout?this.wrapEl.append(this.schemeEl):this.wrapEl.append(this.pickerEl,this.paletteEl);let t=this.options.canvas.showLabel?`<div class="${s.prefix}color-canvas-x">${this.options.lang.label.s}</div>`:"",e=this.options.canvas.showLabel?`<div class="${s.prefix}color-canvas-y">${"hsv"===this.options.canvas.mode?this.options.lang.label.v:this.options.lang.label.h}</div>`:"",i=this.options.canvas.showTools?`\n            <div class="${s.prefix}color-mode">\n                <div class="${s.prefix}flex">\n                    <ax-radios content="[{label:'${this.options.lang.label.hsv}',value:'hsv'},{label:'${this.options.lang.label.hsl}',value:'hsl'}]" checked="${this.options.canvas.mode}"></ax-radios>\n                </div>\n                <span ${s.alias}="random" title="${this.options.lang.btn.random}"><i class="${s.prefix}icon-random"></i></span>\n                <span ${s.alias}="straw" title="${this.options.lang.btn.straw}"><i class="${s.prefix}icon-straw"></i></span>\n            </div>`:"",a=`\n                <div class="${s.prefix}color-control">\n                    <span class="${s.prefix}color-preview"><i></i><s>${this.options.lang.btn.copy}</s></span>\n                    <div class="${s.prefix}color-sliders">\n                        <div class="${s.prefix}color-slider" title="${this.options.lang.label.h}">\n                            <input type="range" class="${s.prefix}color-hue" min="0" max="360" value="0" step="1">\n                        </div>\n                        <div class="${s.prefix}color-break"></div>\n                        <div class="${s.prefix}color-slider" title="${this.options.lang.label.a}">\n                            <input type="range" class="${s.prefix}color-alpha" min="0" max="1" value="1" step="0.01" ${this.showAlpha?"":"disabled"}>\n                        </div>\n                    </div>\n                </div>\n                `;this.spaceEl=createEl("div",{class:`${s.prefix}color-space`},`\n                    <div class="${s.prefix}color-canvas">\n                        <canvas></canvas>\n                        <i class="${s.prefix}color-canvas-ind"></i>\n                        ${t}\n                        ${e}\n                    </div>\n                    ${i}\n                    <ax-br></ax-br>\n                    ${a}\n                    `),this.canvasEl=getEl("canvas",this.spaceEl),this.indEl=getEl(`.${s.prefix}color-canvas-ind`,this.spaceEl),this.canvasModeEl=getEl("AX-RADIOS",this.spaceEl),this.randomEl=getEl(`[${s.alias}="random"]`,this.spaceEl),this.strawEl=getEl(`[${s.alias}="straw"]`,this.spaceEl),this.previewEl=getEl(`.${s.prefix}color-preview`,this.spaceEl),this.previewChildEl=getEl("i",this.previewEl),this.hRangeEl=getEl(`.${s.prefix}color-hue`,this.spaceEl),this.aRangeEl=getEl(`.${s.prefix}color-alpha`,this.spaceEl),this.axisyEl=getEl(`.${s.prefix}color-canvas-y`,this.spaceEl),this.outputEl=createEl("div",{class:`${s.prefix}color-output`},`\n                    <div class="${s.prefix}color-output-head">\n                        <div class="${s.prefix}flex">\n                            <span ${s.alias}="value">-</span><span ${s.alias}="copy" class="${s.prefix}icon-copy" title="${this.options.lang.btn.copy}"></span>\n                        </div>\n                        <span ${s.alias}="change" title="${this.options.lang.btn.change}"><i class="${s.prefix}icon-change"></i></span>\n                    </div>\n                    <div class="${s.prefix}color-output-body"></div>\n        `),this.outputBodyEl=getEl(`.${s.prefix}color-output-body`,this.outputEl),this.valueEl=getEl(`[${s.alias}="value"]`,this.outputEl),this.copyEl=getEl(`[${s.alias}="copy"]`,this.outputEl),this.changeEl=getEl(`[${s.alias}="change"]`,this.outputEl),this.outputHexEl=createEl("div",{class:`${s.prefix}row ${s.prefix}g-xs`},`\n            <div class="${s.prefix}flex">\n                <ax-input size="sm" full>${this.curColors.hex}</ax-input>\n                <div ${s.alias}="label">HEX (000000~ffffff)</div>\n            </div>\n            <div style="width:fit-content">\n                <ax-number size="sm" step="0.01" min="0" max="1" full layout="embed"  ${this.showAlpha?"":"disabled"}>${this.curColors.a}</ax-number>\n                <div ${s.alias}="label">A (0~1)</div>\n            </div>\n        `),this.hexEl=getEl("AX-INPUT",this.outputHexEl),this.hexaEl=getEl("AX-NUMBER",this.outputHexEl),this.outputRgbEl=createEl("ul",{class:`${s.prefix}grid ${s.prefix}avg-4 ${s.prefix}xxs-2 ${s.prefix}g-xs`},`\n        <li>\n            <ax-number size="sm" step="1" min="0" max="255" full layout="embed">${this.curColors.rgb.r}</ax-number>\n            <div ${s.alias}="label">R (0~255)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="1" min="0" max="255" full layout="embed">${this.curColors.rgb.g}</ax-number>\n            <div ${s.alias}="label">G (0~255)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="1" min="0" max="255" full layout="embed">${this.curColors.rgb.b}</ax-number>\n            <div ${s.alias}="label">B (0~255)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="0.01" min="0" max="1" full layout="embed"  ${this.showAlpha?"":"disabled"}>${this.curColors.a}</ax-number>\n            <div ${s.alias}="label">A (0~1)</div>\n        </li>\n        `),this.rgbrEl=getEls("AX-NUMBER",this.outputRgbEl)[0],this.rgbgEl=getEls("AX-NUMBER",this.outputRgbEl)[1],this.rgbbEl=getEls("AX-NUMBER",this.outputRgbEl)[2],this.rgbaEl=getEls("AX-NUMBER",this.outputRgbEl)[3],this.outputHwbEl=createEl("ul",{class:`${s.prefix}grid ${s.prefix}avg-4 ${s.prefix}xxs-2 ${s.prefix}g-xs`},`\n        <li>\n                                <ax-number size="sm" step="1" min="0" max="360" value="0" full layout="embed">${this.curColors.hwb.h}</ax-number>\n                                <div ${s.alias}="label">H (0~360°)</div>\n                            </li>\n                            <li>\n                                <ax-number size="sm" step="1" min="0" max="100" full layout="embed">${this.curColors.hwb.w}</ax-number>\n                                <div ${s.alias}="label">W (0~100%)</div>\n                            </li>\n                            <li>\n                                <ax-number size="sm" step="1" min="0" max="100" full layout="embed">${this.curColors.hwb.b}</ax-number>\n                                <div ${s.alias}="label">B (0~100%)</div>\n                            </li>\n                            <li>\n                                <ax-number size="sm" step="0.01" min="0" max="1" full layout="embed"  ${this.showAlpha?"":"disabled"}>${this.curColors.a}</ax-number>\n                                <div ${s.alias}="label">A (0~1)</div>\n                            </li>\n        `),this.hwbhEl=getEls("AX-NUMBER",this.outputHwbEl)[0],this.hwbwEl=getEls("AX-NUMBER",this.outputHwbEl)[1],this.hwbbEl=getEls("AX-NUMBER",this.outputHwbEl)[2],this.hwbaEl=getEls("AX-NUMBER",this.outputHwbEl)[3],this.outputHslEl=createEl("ul",{class:`${s.prefix}grid ${s.prefix}avg-4 ${s.prefix}xxs-2 ${s.prefix}g-xs`},`\n        <li>\n            <ax-number size="sm" step="1" min="0" max="360" full layout="embed">${this.curColors.hsl.h}</ax-number>\n            <div ${s.alias}="label">H (0~360°)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="1" min="0" max="100" full layout="embed">${this.curColors.hsl.s}</ax-number>\n            <div ${s.alias}="label">S (0~100%)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="1" min="0" max="100" full layout="embed">${this.curColors.hsl.l}</ax-number>\n            <div ${s.alias}="label">L (0~100%)</div>\n        </li>\n        <li>\n            <ax-number size="sm" step="0.01" min="0" max="1" full layout="embed"  ${this.showAlpha?"":"disabled"}>${this.curColors.a}</ax-number>\n            <div ${s.alias}="label">A (0~1)</div>\n        </li>\n        `),this.hslhEl=getEls("AX-NUMBER",this.outputHslEl)[0],this.hslsEl=getEls("AX-NUMBER",this.outputHslEl)[1],this.hsllEl=getEls("AX-NUMBER",this.outputHslEl)[2],this.hslaEl=getEls("AX-NUMBER",this.outputHslEl)[3],this.outputMap={hsl:{el:this.outputHslEl,active:"hsl"===this.outputMode,children:{h:this.hslhEl,s:this.hslsEl,l:this.hsllEl,a:this.hslaEl}},hwb:{el:this.outputHwbEl,active:"hwb"===this.outputMode,children:{h:this.hwbhEl,w:this.hwbwEl,b:this.hwbbEl,a:this.hwbaEl}},rgb:{el:this.outputRgbEl,active:"rgb"===this.outputMode,children:{r:this.rgbrEl,g:this.rgbgEl,b:this.rgbbEl,a:this.rgbaEl}},hex:{el:this.outputHexEl,active:"hex"===this.outputMode,children:{hex:this.hexEl,a:this.hexaEl}}},this.outputBodyEl.appendChild(this.outputMap[this.outputMode].el),this.toolsEl=createEl("div",{class:`${s.prefix}color-tools`},`\n                    <div class="${s.prefix}flex"><ax-checkbox check="ed">${this.options.lang.label.a}</ax-checkbox></div>\n                    <ax-btn ${s.alias}="restore" size="sm" type="plain">${this.options.lang.btn.restore}</ax-btn>\n                    <ax-btn ${s.alias}="clear" size="sm" type="plain">${this.options.lang.btn.clear}</ax-btn>\n        `),this.alphaEl=getEl("AX-CHECKBOX",this.toolsEl),this.clearEl=getEl(`[${s.alias}="clear"]`,this.toolsEl),this.restoreEl=getEl(`[${s.alias}="restore"]`,this.toolsEl),this.confirmEl=createEl("ax-btn",{[s.alias]:"confirm",size:"sm",theme:"prim",label:this.options.lang.btn.confirm}),this.options.output.manual&&this.toolsEl.appendChild(this.confirmEl),this.pickerEl.appendChild(this.spaceEl),this.pickerEl.appendChild(this.outputEl),this.pickerEl.appendChild(this.toolsEl)}getThemePresets(){this.themeColorsEl=createEl("li","",`<div ${s.alias}="head">${this.options.lang.theme}</div><div ${s.alias}="body"><ul class="${s.prefix}grid ${s.prefix}g-xs ${s.prefix}avg-10"></ul></div>`),this.themeWrapEl=getEl("ul",this.themeColorsEl);let t=["","-dp","-tl","-fg","-ht","-aj","-sd","-fc","-bd","-bs"],e=["prim","error","succ","issue","info","warn","text"],i=document.createDocumentFragment();for(let a of e)for(let e of t){let t=`var(--${s.prefix}c-${a}${e})`,l=this.createColorGrid(t);"-bs"===e&&l.toggleAttribute("bordered",!0),i.appendChild(l)}return this.themeWrapEl.appendChild(i),this.themeColorsEl}getHistoryPresets(){return this.historyColorsEl=createEl("li","",`<div ${s.alias}="head">${this.options.lang.history}</div><div ${s.alias}="body"><ul class="${s.prefix}grid ${s.prefix}g-xs ${s.prefix}avg-10"></ul></div>`),this.historyWrapEl=getEl("ul",this.historyColorsEl),this.historyColorsEl}addHistory(t){let e=this.createColorGrid(t);this.historyWrapEl.insertAdjacentElement("afterbegin",e);let s=this.historyWrapEl.children;Array.from(s).slice(10).forEach((t=>t.remove()))}storColor(t){let e=u.get(s.colorStor);e||(e=[]),e.unshift(t),u.set(s.colorStor,e)}getRegularPresets(){let t=document.createDocumentFragment(),e=createEl("li",{title:this.options.lang.btn.add,class:`${s.prefix}color-add`,bordered:""},`<i class="${s.prefix}icon-plus"></i>`);["picker","full"].includes(this.options.layout)&&t.appendChild(e),e.onclick=debounce((()=>{let t=this.value,i=this.createColorGrid(t);s.confirm({heading:this.options.lang.add.heading,content:`${renderTpl(this.options.lang.add.content,{value:t})}<ax-br></ax-br><div class="${s.prefix}h-2 ${s.prefix}r" style="background-color:${t}"></div>`,dialog:{zIndex:881},init:t=>{this.dialogEl=t.mainEl},yes:()=>{e.insertAdjacentElement("afterend",i),this.storColor(t)}})}));let i=u.get(s.colorStor),a=i?[...i,...s.swatches]:s.swatches;for(let e of a){let s=this.createColorGrid(e);"#ffffff"===e&&s.toggleAttribute("bordered",!0),t.appendChild(s)}return t}createColorGrid(t){let e=createEl("li",{title:t},`<i style="background-color:${t}"></i>`);return e.onclick=()=>{this.assignVals(style(e.querySelector("i")).backgroundColor)},e}setAxisLabel(t=this.canvasMode){this.axisyEl.innerHTML="hsv"===t?this.options.lang.label.v:this.options.lang.label.l}getIndCoord(t){return{x:Math.max(0,Math.min(t.x,this.canvasEl.width-1)),y:Math.max(0,Math.min(t.y,this.canvasEl.height-1))}}updateIndCoord(){this.indEl.style.left=`${this.indCoord.x}px`,this.indEl.style.top=`${this.indCoord.y}px`}getCanvasPos(t){return{x:t.x-this.canvasRect.left,y:t.y-this.canvasRect.top}}setValFromCanvas(t){this.canvasInteraction(t),this.indCoord=this.getIndCoord(t),this.updateIndCoord()}setGesture(){this.gestureIns=new s.Gesture(this.canvasEl,{onTranslate:t=>{this.canvasRect=this.canvasEl.getBoundingClientRect(),this.setValFromCanvas(this.getCanvasPos(t.coord))},onTranslating:t=>{this.setValFromCanvas(this.getCanvasPos(t.coord))},onTranslated:t=>{}})}parseVals(t=this.options.value){let e={rgb:{r:0,g:0,b:0},hwb:{h:0,w:0,b:0},hsl:{h:0,s:0,l:0},hex:"#ffffff",a:1,a16:"ff"};if("string"==typeof t){let s=t.startsWith("#")?hex2Rgb(t):t.startsWith("rgb")?parseRgb(t):t.startsWith("hsl")?hsl2Rgb(t):t.startsWith("hwb")?hwb2Rgb(t):{r:0,g:0,b:0,a:1};e.rgb={r:s.r,g:s.g,b:s.b},e.a=s.a,e.a16=alpha2Hex(s.a),e.hwb=rgb2Hwb(e.rgb,!1),e.hsl=rgb2Hsl(e.rgb,!1),e.hex=rgb2Hex(e.rgb,!1)}else t.hasOwnProperty("hex")?(e.hex=t.hex.trim().slice(0,7),"number"==typeof t.a?(e.a=t.a,e.a16=alpha2Hex(e.a)):(e.a16=t.a,e.a=hex2Alpha(e.a16)),e.rgb=hex2Rgb(t,!1),e.hwb=rgb2Hwb(e.rgb,!1),e.hsl=rgb2Hsl(e.rgb,!1)):t.hasOwnProperty("r")?(e.rgb={r:t.r,g:t.g,b:t.b},e.a=t.hasOwnProperty("a")?t.a:1,e.a16=alpha2Hex(e.a),e.hwb=rgb2Hwb(e.rgb,!1),e.hsl=rgb2Hsl(e.rgb,!1),e.hex=rgb2Hex(e.rgb,!1)):t.hasOwnProperty("l")?(e.hsl={h:t.h,s:t.s,l:t.l},e.hwb=hsl2Hwb(e.hsl,!1),e.a=t.hasOwnProperty("a")?t.a:1,e.a16=alpha2Hex(e.a),e.rgb=hsl2Rgb(e.hsl,!1),e.hex=rgb2Hex(e.rgb,!1)):t.hasOwnProperty("w")&&(e.hwb={h:t.h,w:t.w,b:t.b},e.hsl=hwb2Hsl(e.hwb,!1),e.a=t.hasOwnProperty("a")?t.a:1,e.a16=alpha2Hex(e.a),e.rgb=hwb2Rgb(e.hwb,!1),e.hex=rgb2Hex(e.rgb,!1));return e.rgb.r===e.rgb.g&&e.rgb.g===e.rgb.b&&(e.hsl.h=e.hwb.h=this.curColors.hsl.h),e}getCoordFromVal(t){let e=t.s,s=t.l;if("hsv"===this.canvasMode){let i=t.s/100,a=t.l/100,l=a+i*Math.min(a,1-a),n=0===l?0:2*(1-a/l);e=Math.round(100*n),s=Math.round(100*l)}return{x:e/100*this.canvasWidth,y:(1-s/100)*this.canvasHeight}}async assignVals(t=this.options.value,e){if(this.destroyed)return this;if(!t)return this;if(this.options.b4Assign){let e=await this.options.b4Assign.call(this,t);e&&(t=e)}let s=this.parseVals(t);deepMerge(this.curColors,s),this.hRangeEl.value=this.curColors.hsl.h,this.aRangeEl.value=this.curColors.a,this.updateReverse(),this.setOutputStr(),this.updatePreview(),!this.stopOutput&&this.setOutputVals();let{x:i,y:a}=this.getCoordFromVal(this.curColors.hsl);return this.indCoord={x:Math.max(0,Math.min(i,this.canvasWidth-1)),y:Math.max(0,Math.min(a,this.canvasHeight-1))},this.updateIndCoord(),super.listen({name:"assigned",cb:e,params:[t]}),this}initVals(t=this.options.value){t?this.assignVals(t):(this.indCoord={x:this.canvasWidth/2,y:this.canvasHeight/2},this.updateIndCoord(),this.canvasRect=this.canvasEl.getBoundingClientRect(),this.canvasInteraction({x:this.canvasRect.left+this.canvasWidth/2,y:this.canvasRect.top+this.canvasHeight/2}),this.updateHueSlider(),this.updateAlphaSlider())}getVals(){if(this.destroyed)return this;let t=this.curColors.hex;if(this.options.output.format.startsWith("hex"))this.options.output.format.endsWith("a")&&this.curColors.a16;else{let e=this.options.output.format.endsWith("a")?","+this.curColors.a:"";t=this.options.output.format.startsWith("rgb")?`${this.options.output.format}(${this.curColors.rgb.r},${this.curColors.rgb.g},${this.curColors.rgb.b}${e})`:this.options.output.format.startsWith("hwb")?`${this.options.output.format}(${this.curColors.hwb.h},${this.curColors.hwb.w}%,${this.curColors.hwb.b}%${e})`:`${this.options.output.format}(${this.curColors.hsl.h},${this.curColors.hsl.s}%,${this.curColors.hsl.l}%${e})`}return t}async fillVals(t=this.value,e){if(this.destroyed)return this;if(this.options.b4Fill){let e=await this.options.b4Fill.call(this,t);e&&(t=e)}return["INPUT","TEXTAREA"].includes(this.fillEl.nodeName)?this.fillEl.value=t:["AX-INPUT","AX-TEXTAREA"].includes(this.fillEl.nodeName)?this.fillEl.setAttribute("value",t):this.fillEl.innerHTML=t,this.addHistory(t),super.listen({name:"filled",cb:e,params:[t]}),this}async clearVals(t){return this.destroyed||(this.options.b4Clear&&await this.options.b4Clear.call(this),this.value="",["INPUT","TEXTAREA"].includes(this.fillEl.nodeName)?this.fillEl.value="":["AX-INPUT","AX-TEXTAREA"].includes(this.fillEl.nodeName)?this.fillEl.removeAttribute("value"):this.fillEl.innerHTML="",super.listen({name:"cleared",cb:t})),this}async restoreVals(t){return this.destroyed||(this.options.b4Clear&&await this.options.b4Clear.call(this),this.assignVals(this.options.value),super.listen({name:"restored",cb:t})),this}destroy(t){return this.destroyed||(this.canvasModeEl.off("changed",this.modeEvt),this.alphaEl.off("changed",this.alphaEvt),this.hRangeEl.removeEventListener("input",this.hRangeEvt),this.aRangeEl.removeEventListener("input",this.aRangeEvt),this.changeEl.removeEventListener("click",this.changeEvt),this.randomEl.removeEventListener("click",this.randomEvt),this.hexEl.removeEventListener("input",this.colorEvt),this.rgbrEl.removeEventListener("input",this.colorEvt),this.rgbgEl.removeEventListener("input",this.colorEvt),this.rgbbEl.removeEventListener("input",this.colorEvt),this.hslsEl.removeEventListener("input",this.colorEvt),this.hsllEl.removeEventListener("input",this.colorEvt),this.hwbwEl.removeEventListener("input",this.colorEvt),this.hwbbEl.removeEventListener("input",this.colorEvt),this.hexaEl.removeEventListener("input",this.coloraEvt),this.rgbaEl.removeEventListener("input",this.coloraEvt),this.hslaEl.removeEventListener("input",this.coloraEvt),this.hwbaEl.removeEventListener("input",this.coloraEvt),this.hwbhEl.removeEventListener("input",this.colorhEvt),this.hslhEl.removeEventListener("input",this.colorhEvt),this.copyEl.removeEventListener("click",this.copyEvt),this.previewEl.removeEventListener("click",this.previewEvt),this.strawEl.onclick=null,this.restoreEl.onclick=null,this.confirmEl.onclick=null,this.clearEl.onclick=null,this.popupIns.destroy(),this.gestureIns.destroy(),this.destroyed=!0,super.listen({name:"destroyed",cb:t})),this}}class CompBaseCommFieldMixin extends CompBaseCommField{modsOpts;canListenkeys;static custAttrs;static boolAttrs;constructor(){super(),this.modsOpts={},this.createShadow(),this.getRawData(),this.fillWrap(this.propsProxy),this.propsObs.on("completed",(t=>{this.ins&&this.ins.initialized&&t.keys.set.length&&this.completedEvt(t)}))}static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.evtsArr]}connectedCallback(){this.addEvts(["blur","focus","input","change"]),this.connectedRender()}mapVals(t,e,s,i=[]){return s.evtsArr.includes(t)?e:s.boolAttrs.includes(t)?Object.values(attrJoinVal(t,e,i))[0]:isNull(e)?null:Object.values(attrJoinVal(t,e,i))[0]}saveModsOpts(t,e=[],s="module"){if(!t||!s)return;let i=this.propsProxy[t],a=e.find((e=>e.attr===t));a&&(!this.modsOpts[s]&&(this.modsOpts[s]={}),isNull(i)?this.connected&&(this.modsOpts[s][a.prop]=a.value):this.modsOpts[s][a.prop]=i)}getRawProps(t,e=[]){for(let s of[...t.custAttrs,...t.lazyAttrs,...t.boolAttrs,...t.evtsArr])this.propsRaw[s]=this.mapVals(s,this.getAttribute(s),t,e)}filterModsOpts(t=[]){for(let e of Object.keys(this.properties).filter(keyCond))this.saveModsOpts(e,t)}getListenKeys(t,e=[]){this.canListenkeys=[...t.custAttrs,...t.boolAttrs].filter((t=>!e.includes(t)))}fillWrap(t){this.wrapEl=createEl("div",{},this.rawHtml)}updateProxyOpts(t,e=[],s,i,a){this.propsProxy[s]="async"===s?getAttrBool(i):this.mapVals(s,i,t,e),!t.evtsArr.includes(s)&&this.saveModsOpts(s,e),this.changedMaps[s]&&this.changedMaps[s].call(this,{name:s,newVal:i,oldVal:a,proxy:this.propsProxy})}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}getRawPropsOpts(t,e){this.getRawProps(t,e),this.getProxyProps(),this.filterModsOpts(e)}completedEvt(t){getIntArr([this.canListenkeys,t.keys.set]).length&&this.ins.update(this.modsOpts.module)}}class MoreElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...M.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){this.canListen&&super.updateProxy(t,s,M)}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new More(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class DeformElem extends CompBaseComm{constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["type","theme","shape","size",...this.baseAttrs];static boolAttrs=["disabled","bordered","filled","dark"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,DeformElem)}getRawData(){this.getRawProps(DeformElem),this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"},"<i></i>".repeat(3))}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={class:this.changedClass};changedClass(t){let e=t.newVal.includes(l.actClass),s=this.propsRaw.type;e?"left"===s?this.setAttribute("type","right"):"right"===s?this.setAttribute("type","left"):"up"===s?this.setAttribute("type","down"):"down"===s?this.setAttribute("type","up"):this.setAttribute("type","close"):this.setAttribute("type",this.propsRaw.type)}}class AvatarElem extends CompBaseComm{mainEl;badgeEl;tipsEl;contRaw;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-badge",comp:BadgeElem}];static custAttrs=["type","theme","tips","size","src","shape","badge","href","target","rel",...this.baseAttrs];static boolAttrs=["disabled"];static get observedAttributes(){return["src",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,AvatarElem)}getMainEl(t,e){return"text"===t?createEl("i",{[s.alias]:"main"},e||"null"):createEl("img",{[s.alias]:"main",src:e||s.images.avatar})}getRawData(){this.getRawProps(AvatarElem),this.propsRaw.src=this.getAttribute("src")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("a",{[s.alias]:"wrap"}),this.badgeEl=createEl("ax-badge",{[s.alias]:"badge",shadowed:"",label:t?.badge?.trim()}),this.tipsEl=createEl("i",{[s.alias]:"tips"},t.tips||""),this.mainEl=this.getMainEl(t.type,t.src),this.wrapEl.appendChild(this.mainEl),this.hasAttribute("badge")&&this.wrapEl.appendChild(this.badgeEl),this.getAttribute("tips")&&this.wrapEl.appendChild(this.tipsEl)}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={badge:this.changedBadge,tips:this.changedTips,src:this.changedSrc,href:this.changedHref,target:this.changedHref,rel:this.changedHref,type:this.changedType};changedSrc(t){"text"===this.propsProxy.type?this.mainEl.innerHTML=t.newVal:this.mainEl.src=t.newVal}changedHref(t){t.newVal?this.wrapEl.setAttribute(t.name,t.newVal):this.wrapEl.removeAttribute(t.name)}changedBadge(t){null===t.newVal?this.badgeEl.remove():(this.badgeEl.setAttribute("label","0"!==t.newVal&&t.newVal?t.newVal:""),elState(this.badgeEl).isVirtual&&this.wrapEl.appendChild(this.badgeEl))}changedTips(t){null===t.newVal?this.tipsEl.remove():(this.tipsEl.innerHTML=t.newVal,elState(this.tipsEl).isVirtual&&this.wrapEl.appendChild(this.tipsEl))}changedType(t){("IMG"===this.mainEl.nodeName&&"text"===t.newVal||"I"===this.mainEl.nodeName&&("image"===t.newVal||!t.newVal))&&(this.mainEl.remove(),this.mainEl=this.getMainEl(t.newVal,this.propsProxy.src),this.wrapEl.appendChild(this.mainEl))}}class FormatElem extends CompBaseComm{tipsIns;infoEl;separator;locale;prefixEl;suffixEl;prefixTips;suffixTips;labelEl;places;constructor(){super(),this.getRawData(),this.locale=navigator.language||"en-US",this.getSeparator(),this.places=2,this.fillWrap(this.propsProxy)}static custAttrs=["type","rts","info","tips","lines","size","width","locale","places",...this.baseAttrs];static boolAttrs=[];static jsonAttrs=["lang","prefix","suffix"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,FormatElem)}getRawData(){this.getRawProps(FormatElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml;let t=this.getAttribute("suffix")?.trim(),e=this.getAttribute("prefix")?.trim();this.propsRaw.prefix={content:e?.startsWith("{")||e?.endsWith("}")?"":e,tips:{}},this.propsRaw.suffix={content:t?.startsWith("{")||t?.endsWith("}")?"":t,tips:{}},this.getProxyProps()}fillWrap(t){this.labelEl=createEl("span",{[s.alias]:"label"},t.label),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.labelEl),this.fillCont(t)}fillCont(t){if("ruby"===t.type)this.labelEl.innerHTML=`<ruby>${this.getRuby(t.label,t.rts)}</ruby>`;else if("latex"===t.type)try{new Function("label","el",`"use strict";${t.engin||"katex.render(label, el)"}`)(t.label,this.labelEl)}catch{}else"break"===t.type?this.labelEl.innerHTML=this.getBrText(t.label,t.lines,t.size):"localenum"===t.type?this.labelEl.innerHTML=this.getLocaleNum(t.label):"plainnum"===t.type?this.labelEl.innerHTML=this.getPlainNum(t.label):"padstart"===t.type||"padend"===t.type?this.labelEl.innerHTML=this.getPadstr(t.label,t.type):this.labelEl.innerHTML=t.label}render(t){this.insertSource(),this.appendChild(this.wrapEl)}getRuby(t,e){let s="";if(!t)return s;if(!e)return t;let i=t.split(""),a=t.includes(l.splitHyphen)?l.splitHyphen:l.wordHyphen,n=e.split(a);return i=i.map(((t,e)=>`${t}<rt>${n[e]||""}</rt>`)),s=i.join(""),s}getBrText(t,e=2,i){if(!t)return"";if(1===e||!e)return t;let a=Math.ceil(t.length/e),l=i?'style="font-size:'+i+'"':"",n=`<i class="${s.prefix}t-br" ${l}>`;if(!!t.includes("<br"))n+=t;else for(let s=0;s<e;s++)n+=s===e-1?t.substring(s*a):t.substring(s*a,(s+1)*a)+"<br/>";return n+"</i>"}getLocaleNum(t){return new Intl.NumberFormat(this.locale).formatToParts(t.trim()).map((t=>t.value)).join("")}getPlainNum(t){return t.trim().replaceAll(this.separator[0],"").replaceAll(this.separator[1],".")}getSeparator(){this.separator="de-DE"==this.locale?[".",","]:"fr-FR"==this.locale?[" ",","]:"de-CH"==this.locale?["’","."]:"sv-SE"==this.locale?[" ",","]:[",","."]}getPadstr(t,e="padend"){let s=t.replaceAll(this.separator[0],""),i=s.split(this.separator[1]),a=i[0],l=i[1]||"",n=l?this.separator[1]:"";return"padstart"===e?a.length>this.places?s:a.padStart(this.places,"0")+n+l:l.length>this.places?s:a+n+l.padEnd(this.places,"0")}changedMaps={label:this.changedLabel,type:this.changedLabel,rts:this.changedRts,prefix:this.changedEnds,suffix:this.changedEnds,lines:this.changedLines,size:this.changedSize,width:this.changedWidth,locale:this.changedLocale,places:this.changedPlaces};changedLabel(t){this.labelEl.innerHTML="",this.fillCont(this.propsProxy)}changedRts(t){"ruby"===this.propsProxy.type&&(this.labelEl.innerHTML=`<ruby>${this.getRuby(this.propsProxy.label,t.newVal)}</ruby>`)}changedEnds(t){if(null===t.newVal)return void this[`${t.name}El`].remove();let e=this[`${t.name}El`],i=this[`${t.name}Tips`],a=this.propsProxy[t.name],l=isNull(a.content)?this.propsRaw[t.name].content:a.content;l?(e?e.innerHTML=l:(this[`${t.name}El`]=createEl("i",{[s.alias]:t.name},l),e=this[`${t.name}El`],this.wrapEl.insertAdjacentElement("suffix"===t.name?"beforeend":"afterbegin",e)),isEmpty(a.tips)?i&&i.update({asleep:!0}):("string"==typeof a.tips&&(this.propsProxy[t.name].tips={content:a.tips}),i?i.update(this.propsProxy[t.name].tips):this[`${t.name}Tips`]=new Tooltip(e,this.propsProxy[t.name].tips))):e&&e.remove()}changedLines(t){"break"===this.propsProxy.type&&(this.labelEl.innerHTML=this.getBrText(this.propsProxy.label,~~t.newVal,this.propsProxy.size))}changedSize(t){if("break"===this.propsProxy.type){let e=this.labelEl.firstElementChild;e&&(e.style.fontSize=t.newVal)}}changedWidth(t){if("break"===this.propsProxy.type){let e=this.labelEl.firstElementChild;e&&(e.style.width=t.newVal)}}changedLocale(t){this.locale=t.newVal?t.newVal:navigator.language||"en-US",this.getSeparator(),["localenum","plainnum"].includes(this.propsProxy.type)&&(this.labelEl.innerHTML="",this.fillCont(this.propsProxy))}changedPlaces(t){["padstart","padend"].includes(this.propsProxy.type)&&(null!==t.newVal&&(this.places=~~t.newVal),this.labelEl.innerHTML=this.getPadstr(this.propsProxy.label,this.propsProxy.type))}}class FlagElem extends CompBaseComm{labelEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["type","theme","placement",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,FlagElem)}getRawData(){this.getRawProps(FlagElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.labelEl=createEl("i",{[s.alias]:"label"},this.propsProxy.label),this.wrapEl=createEl("span",{[s.alias]:"wrap"},this.labelEl)}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel};changedLabel(t){this.labelEl.innerHTML=t.newVal||""}}class BuoyElem extends CompBaseComm{headEl;labelEl;iconEl;arrowEl;valueEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["icon","label","theme","size",...this.baseAttrs];static boolAttrs=["inverted","arrow"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,BuoyElem)}getRawData(){this.getRawProps(BuoyElem),this.propsRaw.value=this.getAttribute("value")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("span",{[s.alias]:"wrap"}),this.headEl=createEl("span",{[s.alias]:"head"}),this.labelEl=createEl("i",{[s.alias]:"label"},t.label||""),this.iconEl=createEl("i",{class:t.icon||"",[s.alias]:"icon"}),this.arrowEl=createEl("i",{class:`${s.prefix}icon-down`,[s.alias]:"arrow"}),this.valueEl=createEl("i",{[s.alias]:"value"},t.value||""),t.label&&this.headEl.appendChild(this.labelEl),t.icon&&this.headEl.insertAdjacentElement("afterBegin",this.iconEl),t.arrow&&this.headEl.insertAdjacentElement("beforeEnd",this.arrowEl),this.wrapEl.append(this.headEl,this.valueEl)}render(t){this.insertSource(),this.append(this.wrapEl)}changedMaps={value:this.changedValue,label:this.changedLabel,icon:this.changedIcon,arrow:this.changedArrow};changedValue(t){this.valueEl.innerHTML=t.newVal||""}changedLabel(t){null===t.newVal?this.labelEl.remove():(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&(elState(this.iconEl).isVirtual?this.headEl.insertAdjacentElement("afterBegin",this.labelEl):this.iconEl.insertAdjacentElement("afterEnd",this.labelEl)))}changedIcon(t){null===t.newVal?this.iconEl.remove():(this.iconEl.setAttribute("class",t.newVal),elState(this.iconEl).isVirtual&&this.headEl.insertAdjacentElement("afterBegin",this.iconEl))}changedArrow(t){attrValBool(t.newVal)?elState(this.arrowEl).isVirtual&&this.headEl.appendChild(this.arrowEl):this.arrowEl.remove()}}class GoodElem extends CompBaseComm{labelEl;iconEl;tipsEl;valueEl;increase;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy),this.increase=(t=1,e)=>{let s=parseInt(this.properties.value)+t,i=this.getAttribute("tips");this.canListen=!1,this.setAttribute("value",String(s)),i&&this.setAttribute("tips",i),this.toggleAttribute("increased",!0),e&&e.call(this,s),this.canListen=!0}}static custAttrs=["icon","label","tips",...this.baseAttrs];static boolAttrs=["disabled","increased"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,GoodElem)}getRawData(){this.getRawProps(GoodElem),this.propsRaw.value=this.getAttribute("value")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("span",{[s.alias]:"wrap"}),this.labelEl=createEl("i",{[s.alias]:"label"}),this.iconEl=createEl("i",{[s.alias]:"icon"}),this.valueEl=createEl("i",{[s.alias]:"value"},t.value||""),this.tipsEl=createEl("i",{[s.alias]:"tips"}),this.wrapEl.appendChild(this.valueEl)}render(t){this.insertSource(),this.append(this.labelEl,this.wrapEl,this.tipsEl)}changedMaps={label:this.changedLabel,value:this.changedLabel,tips:this.changedLabel,icon:this.changedIcon};changedLabel(t){this[t.name+"El"].innerHTML=t.newVal||""}changedIcon(t){null===t.newVal?this.iconEl.remove():(this.iconEl.setAttribute("class",t.newVal),elState(this.iconEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterBegin",this.iconEl))}}class AnchorsElem extends CompBaseComm{data;smoothEvent;interactIns;constructor(){super(),this.getRawData(),this.createInteract(),this.fillWrap(this.propsProxy),this.render(this.propsProxy)}static custAttrs=["root","active","offset",...this.baseAttrs];static boolAttrs=["smooth"];static get observedAttributes(){return["headings",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,AnchorsElem)}getRawData(){this.getRawProps(AnchorsElem),this.propsRaw.headings=this.getHeadings(this.getAttribute("headings")||this.rawHtml),this.getProxyProps()}createInteract(){this.interactIns=new IntersectionObserver((t=>{for(let e of t)e.isIntersecting&&1===e.intersectionRatio&&this.activate(e.target,!0,!1)}),{threshold:[1]})}getHeadings(t){return valToArr(t).map((t=>{let e=t.split("|");return{heading:e[0],exclude:e[1]}}))}getData(t){0===t.length&&(t=[{heading:"h2",exclude:""}]);let e=[],getChildren=(e,s,i,a)=>{let l=getEls(s.heading,this.propsProxy.root),n=getEls(s.exclude,this.propsProxy.root),r=t[e+1]?.heading;for(let[s,o]of l.entries()){let h={target:o,label:o.textContent.replace("§","")};getBetweenEls({selector:r,start:o,end:l[s+1]||a,root:this.propsProxy.root}).length>0&&(h.children=[],getChildren(e+1,t[e+1],h.children,l[s+1])),n.length&&n.find((t=>t.contains(o)))||i.push(h)}};return getChildren(0,t[0],e),S.addIdPath({source:e}),e}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.get2FillTreeNodes(t)}get2FillTreeNodes(t){this.data=this.getData(t.headings);let plantTree=(t,e)=>{let i=createEl("ul",{class:`${s.prefix}reset`});for(let t of e){t.wrapEl=createEl("li",{[s.alias]:"wrap"}),t.labelEl=createEl("a",{[s.alias]:"label",href:`#${t.label}`},t.label),t.headEl=createEl("div",{[s.alias]:"head",id:t.id},t.labelEl),t.wrapEl.appendChild(t.headEl),t.labelEl.onclick=()=>this.smoothToActive(t,!1),t.target.id=t.label,t.target.classList.add(`${s.prefix}anchor`);let e=t.target.querySelector(`${s.prefix}hash`);e&&e.remove(),t.hashEl=createEl("a",{href:`#${t.label}`,class:`${s.prefix}hash`},"§"),t.hashEl.onclick=()=>this.smoothToActive(t,!1),t.target.appendChild(t.hashEl),this.interactIns.observe(t.target),t.hasOwnProperty("children")&&(t.bodyEl=plantTree(t.wrapEl,t.children),t.bodyEl.setAttribute(s.alias,"body")),i.appendChild(t.wrapEl)}return t.appendChild(i),i};this.wrapEl.innerHTML="",plantTree(this.wrapEl,this.data)}render(t){this.insertSource(),this.appendChild(this.wrapEl)}activate(t,e=!0,s=!0){if(!t)return this;let i=S.toFlat(this.data),a=getDataType(t),l=Number(t),n=0===l||l?l:t,r=a.includes("HTML")?findItem(t,i,"target"):findItem(n,i);if(r){if(!r.active&&e){r.headEl.setAttribute("active",""),r.active=!0;let t=i.filter((t=>t!==r&&t.active));for(let e of t)e.headEl.removeAttribute("active"),Reflect.deleteProperty(e,"active")}s&&this.propsProxy.smooth&&scrollTo(r.target,{offset:this.propsProxy.offset})}}addSmooth(){let t=S.toFlat(this.data);for(let e of t)e.labelEl.onclick=()=>this.smoothToActive(e,!1),e.hashEl.onclick=()=>this.smoothToActive(e,!1)}removeSmooth(){let t=S.toFlat(this.data);for(let e of t)e.labelEl.onclick=null,e.hashEl.onclick=null}smoothToActive(t,e=!0){this.activate(t.target,e,this.propsProxy.smooth)}changedMaps={headings:this.changedRender,root:this.changedRender,active:this.changedActive,offset:this.changedOffset,smooth:this.changedSmooth};changedRender(t){this.get2FillTreeNodes(this.propsProxy)}changedActive(t){this.activate(t.newVal)}changedOffset(t){for(let e of this.data)e.target.style.scrollMarginTop=t.newVal}changedSmooth(t){attrValBool(t.newVal)?this.addSmooth():this.removeSmooth()}}class MenuElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...B.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){this.canListen&&("active"===t&&this.ins&&s&&this.ins.activate(s),"disable"===t?this.ins&&s&&this.ins.treeIns.disable(s):super.updateProxy(t,s,B))}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new Menu(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class FileElem extends CompBaseCommField{holderEl;meanEl;clickEvent;changeEvt;namesEl;type;clickEvt;labelEl;constructor(){super(),this.type="file-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.clickEvt=t=>{let e=getEvtTarget(t);this.toolsEl&&this.toolsEl.contains(e)||this.inputEl.click()},this.zeroEvt=new Event("change")}static custAttrs=["name","value","accept","size","label","show","tools","attrs",...this.evtsArr];static boolAttrs=["disabled","readonly","multiple","full"];static get observedAttributes(){return["placeholder",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,FileElem,{tools:getAttrArr(s,"close")})}getRawData(){this.getRawProps(FileElem),this.propsRaw.placeholder=this.getAttribute("placeholder")||this.rawHtml||l.lang.form.fileLabel,this.propsRaw.value=this.propsRaw.multiple?[]:"",this.getProxyProps(),this.propsProxy.tools=getAttrArr(this.getAttribute("tools"),"close"),this.value=this.propsProxy.value,this.setFieldProps(["name","value","disabled","readonly","multiple"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.inputEl=createEl("input",{type:"file",[s.embedSign]:""}),this.inputEl.multiple=t.multiple,this.labelEl=createEl("span",{[s.alias]:"label"}),t.name&&(this.inputEl.name=t.name+(this.inputEl.multiple?"[]":"")||""),super.getToolsEl(t.tools),this.holderEl=createEl("i",{[s.alias]:"placeholder"},t.placeholder),this.namesEl=createEl("i",{[s.alias]:"names"}),this.meanEl=createEl("i",{[s.alias]:"mean"},"file"),this.wrapEl.append(this.inputEl,this.namesEl,this.holderEl,this.meanEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.inputEl.addEventListener("change",(t=>{let e=[...this.inputEl.files],s=e.map((t=>t.name)),i=this.value;if(this.value=this.propsProxy.multiple?e:e[0]||"",e.length>0&&(this.propsProxy.value=s.join(",")),this.namesEl.innerHTML=0===e.length?"":1===e.length?this.inputEl.value:renderTpl(this.propsProxy.lang?.multi||l.lang.form.fileMulti,{data:e.length})+this.propsProxy.value,this.mediaEl){this.mediaEl.innerHTML="";for(let e of Array.from(t.target.files))this.read2Append(e,this.mediaEl)}this.listen({name:"changed",params:[{oldVal:i,newVal:this.value}]})}),!1),this.wrapEl.addEventListener("click",this.clickEvt)}read2Append(t,e){let i=new FileReader;i.readAsDataURL(t),i.onload=i=>{let a,l=i.target.result;t.type.startsWith("image/")?a=s.createEl("img",{src:l}):t.type.startsWith("video/")?a=s.createEl("video",{src:l,controls:!0}):t.type.startsWith("audio/")&&(a=s.createEl("audio",{src:l,controls:!0})),a&&e.appendChild(a)}}changedMaps={disabled:this.changedBool,readonly:this.changedBool,multiple:this.changedBool,full:this.changedBool,name:this.changedName,value:this.changedValue,accept:this.changedName,tools:this.changedTools,placeholder:this.changedHolder,label:this.changedLabel,show:this.changedShow,attrs:this.changedAttrs};changedBool(t){this.inputEl["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name],this["readonly"===t.name?"readOnly":t.name]=this.propsProxy[t.name]}changedTools(t){this.toolsEl&&this.toolsEl.remove(),this.propsProxy.tools.length>0&&(super.getToolsEl(this.propsProxy.tools),this.propsProxy.tools.forEach((t=>{"close"===t.name?t.wrapEl.onclick=()=>{this.clear()}:t.action&&t.action.bind(this)})),this.holderEl.insertAdjacentElement("afterEnd",this.toolsEl))}changedHolder(t){this.holderEl.innerHTML=t.newVal}changedName(t){this.inputEl.setAttribute(t.name,t.newVal),"name"===t.name&&(this.name=t.newVal+(this.propsProxy.multiple?"[]":"")),"name"===t.name&&(this.name=t.newVal||"",this.name?this.inputEl.name=this.propsProxy.multiple?`${this.name}[]`:this.name:this.inputEl.removeAttribute("name"))}changedValue(t){this.clear()}changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.labelEl)):this.labelEl.remove()}changedShow(t){if(this.mediaEl&&(this.mediaEl.innerHTML=""),t.newVal){this.mediaEl=getEl(t.newVal);let e=Array.from(this.inputEl.files);if(!this.mediaEl||!e.length)return;for(let t of e)this.read2Append(t,this.mediaEl)}}}class CheckboxesElem extends CompBaseCommField{labelEl;legendEl;inputs;checkedAll;switch;setVals;check;setLabels;switchType;switchEvt;valMap;checkedMore;checkedLess;type;constructor(){super(),this.type="checkboxes-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.reset=()=>{this.propsRaw.content!=this.propsRaw.content&&this.updateInputs(this.propsRaw.content,this.propsRaw);for(let t in this.propsRaw)"content"!==t&&(null!==this.propsRaw[t]&&!1!==this.propsRaw[t]?this.setAttribute(t,this.propsRaw[t]):this.removeAttribute(t));this.listen({name:"reset"})},this.clear=()=>{this.inputs.every((t=>!t.propsProxy.check))||(this.setAttribute("checked",""),this.listen({name:"cleared"}))},this.checkedAll=()=>{let t=this.inputs.filter((t=>!t.propsProxy.checked&&t.propsProxy.value)).map((t=>t.propsProxy.value));t.length&&(this.setAttribute("checked",t),this.listen({name:"checkedAll",params:[t]}))},this.checkedMore=t=>{let e=valToArr(t),s=this.value.split(","),i=unique([...s,...e]).filter(Boolean);this.setAttribute("checked",i.join(","))},this.checkedLess=t=>{let e=valToArr(t),s=this.value.split(",").filter((t=>!e.includes(t)));this.setAttribute("checked",s.join(","))},this.check=(t,e="ed",s="value")=>{let i=valToArr(t);if(!i.length)return void this.setAttribute("checked","");let a=i.map((t=>this.inputs.find((e=>e.propsProxy[s]==t)))).filter(Boolean);if(!a.length)return;let l=a.map((t=>t.value)),n=this.propsProxy.value.split(","),r=e?l:n.filter((t=>!l.includes(t)));"ing"===e?(a[0].checked&&this.setAttribute("checked",n.shift.join(",")),a[0].setAttribute("check",e)):this.setAttribute("checked",r.join(","))},this.propsObs.on("set",(t=>{"value"===t.key&&(this.valMap={newVal:t.value,oldVal:t.raw||""})})),this.propsObs.on("completed",(t=>{t.keys.set.includes("value")&&(this.referSwitch(t.proxy.value),this.updateCache({check:t.proxy.value}),this.listen({name:"changed",params:[this.valMap]}))})),this.switchEvt=t=>{"1"==this.switch.value||this.switch.checked?this.checkedAll():this.clear()}}static dependencies=[{tag:"ax-checkbox",comp:CheckboxElem}];static custAttrs=["size","name","type","layout","cols","checked","disable","content","switch","wrap-classes","item-classes","input-classes","on-checkedall",...this.evtsArr];static boolAttrs=["disabled","inverted"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,CheckboxesElem)}getRawData(){this.getRawProps(CheckboxesElem),!this.propsRaw.name&&(this.propsRaw.name=s.namePfx+Date.now()),this.propsRaw.content=super.getItemsData(),this.getProxyProps(),this.setFieldProps(["name","value","disabled"])}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),t["wrap-classes"]&&classes(this.wrapEl).add(t["wrap-classes"]),"grid"===t.layout?(this.wrapEl.classList.add(`${s.prefix}grid`),t.cols&&this.wrapEl.classList.add(`${s.prefix}avg-${t.cols}`)):"flex"===t.layout&&this.wrapEl.classList.add(`${s.prefix}row`),this.updateInputs(t.content,t)}updateInputs(t,e=this.propsProxy){this.inputs=[],this.wrapEl.innerHTML="";let i=super.getItemsData(t);for(let t of i){let i=createEl("div"),a=createEl("ax-checkbox",{label:t.label,value:isNull(t.value)?t.label:t.value,[s.embedSign]:""});e.name?a.setAttribute("name",`${e.name}[]`):a.removeAttribute("name"),e.type?a.setAttribute("type",e.type):a.removeAttribute("type"),t.checked?a.setAttribute("check","ed"):a.removeAttribute("check"),a.toggleAttribute("disabled",!!t.disabled),e["input-classes"]&&classes(a).add(e["input-classes"]),this.inputs.push(a),e.layout?("flex"===e.layout&&i.classList.add(`${s.prefix}flex`),e["item-classes"]&&classes(i).add(e["item-classes"]),i.appendChild(a),this.wrapEl.appendChild(i)):this.wrapEl.appendChild(a)}this.inputs.forEach((t=>{t.on("changed",(()=>{let t=this.inputs.filter((t=>"ed"===t.propsProxy.check)).map((t=>t.propsProxy.value)).join(",");this.propsProxy.value=t,this.value=this.propsProxy.value}))}))}referSwitch(t){if(this.switch)if(t){let e=t.split(",").length;if(e>0&&e<this.inputs.length)if(this.switch.clear(),["AX-CHECKBOX","AX-RADIO"].includes(this.switchType))this.switch.setAttribute("check","ing");else{let t=this.switch.inputs.find((t=>"1"==t.propsProxy.value));t&&t.setAttribute("check","ing")}else["AX-CHECKBOX","AX-RADIO"].includes(this.switchType)?this.switch.setAttribute("check","ed"):this.switch.check("1")}else["AX-CHECKBOXES","AX-CHECKBOX","AX-RADIO"].includes(this.switchType)?this.switch.clear():this.switch.check("0")}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={content:this.changedMultiCont,disabled:this.changedMultiDisabled,inverted:this.changedInverted,name:this.changedMultiName,type:this.changedMultiName,size:this.changedMultiName,checked:this.changedChecked,disable:this.changedMultiDisable,switch:this.changedSwitch};changedChecked(t){for(let e of this.inputs)if(null===t.newVal)e.check("");else{let s=t.newVal?getAttrArr(t.newVal):[""];e.check(s.includes(e.propsProxy.value)?"ed":"")}}changedSwitch(t){this.switch=getEl(`[name="${t.newVal}"]`),this.switch&&(this.switchType=this.switch.nodeName,this.switch.removeEventListener("change",this.switchEvt),this.switch.addEventListener("change",this.switchEvt,!1))}changedInverted(t){for(let t of this.inputs)t.toggleAttribute("inverted",this.propsProxy.inverted)}}class RangeElem extends CompBaseCommFieldMixin{type;constructor(){super(),this.type="range-comp"}static custAttrs=["name","value","step","max","min","flow","size","classes","separator","hyphen","fence","button","ruler","result","lang"];static boolAttrs=["async","disabled","full","limit-show","tip-show","multiple","locked","rtl"];attributeChangedCallback(t,e,s){this.canListen&&this.updateProxyOpts(RangeElem,ut,t,s,e)}getRawData(){this.getRawPropsOpts(RangeElem,ut),this.setFieldProps(["name","value","disabled"]),this.getListenKeys(RangeElem,["name","disabled","value","size"])}createIns(){if(this.ins)return;let t=Object.assign({onSet:t=>{this.modsOpts.module.value=this.propsProxy.value=this.value=t.value,this.canListen=!1,this.setAttribute("value",t.value),this.canListen=!0,this.dispatchEvent(this.events.input.event),this.listen({name:"input",params:[t.value]}),t.value!==t.raw&&(this.dispatchEvent(this.events.change.event),this.listen({name:"changed",params:[{newVal:t.value,oldVal:t.raw}]}))}},deepClone(this.modsOpts.module));this.ins=new Range(this.wrapEl,t),this.ins.inputEl.setAttribute(s.embedSign,""),this.focus=()=>{this.ins.handles[this.propsProxy.multiple?"from":"single"].focus()},this.blur=()=>{this.propsProxy.multiple?(this.ins.handles.from.blur(),this.ins.handles.to.blur()):this.ins.handles.single.blur()},this.clear=()=>{this.ins.clear(),this.listen({name:"cleared"})};for(let t in this.ins.handles)this.ins.handles[t]&&(this.ins.handles[t].addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.ins.handles[t].addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1))}changedMaps={size:this.changedSize,disabled:this.changedDisabled,name:this.changedName,value:this.changedValue};changedName(t){let e=t.newVal||"";this.ins&&(this.ins.inputEl.name=e),this.name=e}changedValue(t){this.ins&&this.ins.setVals(t.newVal),this.value=this.ins?this.ins.output.value:t.newVal}changedDisabled(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.disable():this.ins.enable())}changedSize(t){this.ins&&(t.newVal?this.ins.targetEl.setAttribute("size",t.newVal):this.ins.targetEl.removeAttribute("size"))}}class StatsElem extends CompBaseComm{mainEl;badgeEl;tipsEl;labelEl;unitEl;suffixEl;prefixEl;iconEl;cubeEl;diskEl;headEl;imageEl;coreEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-badge",comp:BadgeElem}];static custAttrs=["unit","tips","icon","disk","cube","image","badge","prefix","suffix","flow",...this.baseAttrs];static boolAttrs=["flipped","disabled"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,StatsElem)}getRawData(){this.getRawProps(StatsElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.mainEl=createEl("div",{[s.alias]:"main"}),this.iconEl=createEl("i",{[s.alias]:"icon",class:t.icon}),this.diskEl=createEl("span",{[s.alias]:"disk"},`<img src="${t.disk}"/>`),this.cubeEl=createEl("span",{[s.alias]:"cube"},`<img src="${t.cube}"/>`),this.imageEl=createEl("span",{[s.alias]:"image"},`<img src="${t.image}"/>`),this.labelEl=createEl("i",{[s.alias]:"label"},t.label),this.coreEl=createEl("span",{[s.alias]:"core"},this.labelEl),this.headEl=createEl("div",{[s.alias]:"head"},this.coreEl),this.tipsEl=createEl("div",{[s.alias]:"tips"},t.tips),this.unitEl=createEl("i",{[s.alias]:"unit"},t.unit),this.suffixEl=createEl("i",{[s.alias]:"suffix"},t.suffix),this.prefixEl=createEl("i",{[s.alias]:"prefix"},t.prefix),this.badgeEl=createEl("ax-badge",{[s.alias]:"badge",label:t?.badge?.trim()}),this.mainEl.appendChild(this.headEl),this.wrapEl.appendChild(this.mainEl)}render(){this.insertSource(),!this.hasAttribute("flow")&&this.setAttribute("flow","v"),this.append(this.wrapEl)}changedMaps={badge:this.changedBadge,label:this.changedLabel,icon:this.changedIcon,disk:this.changedDisk,cube:this.changedCube,image:this.changedImage,tips:this.changedTips,unit:this.changedUnit,suffix:this.changedSuffix,prefix:this.changedPrefix};changedBadge(t){null===t.newVal?this.badgeEl.remove():(this.badgeEl.setAttribute("label",t.newVal.trim()),elState(this.badgeEl).isVirtual&&this.coreEl.appendChild(this.badgeEl))}changedIcon(t){null===t.newVal?this.iconEl.remove():(this.iconEl.setAttribute("class",t.newVal),elState(this.iconEl).isVirtual&&(this.diskEl.remove(),this.cubeEl.remove(),this.imageEl.remove(),this.wrapEl.insertAdjacentElement("afterbegin",this.iconEl)))}changedDisk(t){null===t.newVal?this.diskEl.remove():(this.diskEl.querySelector("img").src=t.newVal,elState(this.diskEl).isVirtual&&(this.iconEl.remove(),this.cubeEl.remove(),this.imageEl.remove(),this.wrapEl.insertAdjacentElement("afterbegin",this.diskEl)))}changedCube(t){null===t.newVal?this.cubeEl.remove():(this.cubeEl.querySelector("img").src=t.newVal,elState(this.cubeEl).isVirtual&&(this.diskEl.remove(),this.imageEl.remove(),this.iconEl.remove(),this.wrapEl.insertAdjacentElement("afterbegin",this.cubeEl)))}changedImage(t){null===t.newVal?this.imageEl.remove():(this.imageEl.querySelector("img").src=t.newVal,elState(this.cubeEl).isVirtual&&(this.diskEl.remove(),this.cubeEl.remove(),this.iconEl.remove(),this.wrapEl.insertAdjacentElement("afterbegin",this.imageEl)))}changedTips(t){null===t.newVal?this.tipsEl.remove():(this.tipsEl.innerHTML=t.newVal,this.mainEl.appendChild(this.tipsEl))}changedUnit(t){null===t.newVal?this.unitEl.remove():(this.unitEl.innerHTML=t.newVal,this.headEl.appendChild(this.unitEl))}changedPrefix(t){null===t.newVal?this.prefixEl.remove():(this.prefixEl.innerHTML=t.newVal,elState(this.prefixEl).isVirtual&&this.coreEl.insertAdjacentElement("afterbegin",this.prefixEl))}changedSuffix(t){null===t.newVal?this.suffixEl.remove():(this.suffixEl.innerHTML=t.newVal,elState(this.suffixEl).isVirtual&&this.coreEl.insertAdjacentElement("beforeend",this.suffixEl))}changedLabel(t){this.labelEl.innerHTML=t.newVal||""}}class IconElem extends CompBaseComm{badgeEl;tipsEl;iconEl;cubeEl;diskEl;imageEl;headEl;legendEl;tmp;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-badge",comp:BadgeElem}];static custAttrs=["tips","type","badge","dir","bg","href","target","rel","download",...this.baseAttrs];static boolAttrs=["disabled"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,IconElem)}getRawData(){this.getRawProps(IconElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.headEl=createEl("span",{[s.alias]:"head"}),this.wrapEl=createEl(t.href?"a":"div",{[s.alias]:"wrap"},this.headEl),this.iconEl=createEl("i",{[s.alias]:"icon",class:t.label}),this.diskEl=createEl("span",{[s.alias]:"disk"},`<img src="${t.label}"/>`),this.cubeEl=createEl("span",{[s.alias]:"cube"},`<img src="${t.label}"/>`),this.imageEl=createEl("span",{[s.alias]:"image"},`<img src="${t.label}"/>`),this.tipsEl=createEl("div",{[s.alias]:"tips"},t.tips),this.toggleLegend("icon"),this.badgeEl=createEl("ax-badge",{[s.alias]:"badge",label:t?.badge?.trim()})}setLegendBg(t,e){t?(classes(this.iconEl).replace(`${s.prefix}bg-${e}`,`${s.prefix}bg-${t}`),classes(this.diskEl).replace(`${s.prefix}bg-${e}`,`${s.prefix}bg-${t}`),classes(this.cubeEl).replace(`${s.prefix}bg-${e}`,`${s.prefix}bg-${t}`)):(this.iconEl.classList.remove(`${s.prefix}bg-${e}`),this.diskEl.classList.remove(`${s.prefix}bg-${e}`),this.cubeEl.classList.remove(`${s.prefix}bg-${e}`))}toggleLegend(t){let e=[{type:"icon",show:this.iconEl,hide:[this.diskEl,this.imageEl,this.cubeEl]},{type:"disk",show:this.diskEl,hide:[this.iconEl,this.imageEl,this.cubeEl]},{type:"cube",show:this.cubeEl,hide:[this.diskEl,this.imageEl,this.iconEl]},{type:"image",show:this.imageEl,hide:[this.diskEl,this.cubeEl,this.iconEl]}].find((e=>e.type===t));if(e){for(let t of e.hide)t.remove();elState(e.show).isVirtual&&this.headEl.insertAdjacentElement("afterbegin",e.show),this.legendEl=e.show}else this.iconEl.remove(),this.cubeEl.remove(),this.diskEl.remove(),this.imageEl.remove()}render(){this.insertSource(),this.appendChild(this.wrapEl),!this.hasAttribute("dir")&&this.setAttribute("dir","h"),this.hasAttribute("type")||(this.canListen=!1,this.setAttribute("type","icon"),this.canListen=!0)}changedMaps={label:this.changedLabel,href:this.changedHref,badge:this.changedBadge,target:this.changedTarget,rel:this.changedTarget,download:this.changedTarget,tips:this.changedTips,type:this.changedType,bg:this.changedBg};changedLabel(t){null===t.newVal?this.toggleLegend():"I"===this.legendEl.nodeName?this.legendEl.setAttribute("class",t.newVal):this.legendEl.querySelector("img").src=t.newVal}changedBadge(t){null===t.newVal?this.badgeEl.remove():(this.badgeEl.setAttribute("label",t.newVal.trim()),elState(this.badgeEl).isVirtual&&this.headEl.appendChild(this.badgeEl))}changedHref(t){if(null===t.newVal){let t=this.wrapEl.children;this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.wrapEl.append(...t),this.render()}else"A"!==this.wrapEl.nodeName&&(this.wrapEl=createEl("a",{[s.alias]:"wrap"},[...this.wrapEl.children]),this.render()),this.wrapEl.setAttribute("href",t.newVal)}changedTarget(t){t.newVal?this.wrapEl[t.name]=t.newVal:this.wrapEl.removeAttribute(t.name)}changedTips(t){null===t.newVal?this.tipsEl.remove():(this.tipsEl.innerHTML=t.newVal,this.wrapEl.appendChild(this.tipsEl))}changedBg(t){this.setLegendBg(t.newVal,t.oldVal)}changedType(t){this.toggleLegend(t.newVal)}}class DividerElem extends CompBaseComm{startEl;endEl;labelEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["break","size","fs",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,DividerElem)}getRawData(){this.getRawProps(DividerElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.startEl=createEl("div",{[s.alias]:"start"}),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.startEl),this.endEl=createEl("div",{[s.alias]:"end"}),this.labelEl=createEl("div",{[s.alias]:"label"},this.propsProxy.label),this.propsProxy.label&&this.wrapEl.append(this.labelEl,this.endEl)}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel};changedLabel(t){null===t.newVal?(this.labelEl.remove(),this.endEl.remove()):(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&this.wrapEl.append(this.labelEl,this.endEl))}}class AlarmElem extends CompBaseComm{labelEl;iconEl;imageEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["icon","image","theme","size",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,AlarmElem)}getRawData(){this.getRawProps(AlarmElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("span",{[s.alias]:"wrap"}),this.labelEl=createEl("i",{[s.alias]:"label"},this.propsProxy.label),this.iconEl=createEl("i",{[s.alias]:"icon"}),this.imageEl=createEl("img",{[s.alias]:"image"}),this.propsProxy.label&&this.wrapEl.appendChild(this.labelEl)}render(t){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel,icon:this.changedIcon,image:this.changedImage};changedLabel(t){null===t.newVal?this.labelEl.remove():(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&(this.wrapEl.appendChild(this.labelEl),this.iconEl.remove(),this.imageEl.remove()))}changedIcon(t){null===t.newVal?this.iconEl.remove():(this.iconEl.setAttribute("class",t.newVal),elState(this.iconEl).isVirtual&&(this.wrapEl.appendChild(this.iconEl),this.labelEl.remove(),this.imageEl.remove()))}changedImage(t){null===t.newVal?this.imageEl.remove():(this.imageEl.src=t.newVal,elState(this.imageEl).isVirtual&&(this.wrapEl.appendChild(this.imageEl),this.labelEl.remove(),this.iconEl.remove()))}}class DatetimeElem extends CompBaseCommFieldMixin{labelEl;inputEvt;meanEl;datetimeIns;type;select;constructor(){super(),this.type="datetime-comp",this.select=()=>this.ins.inputEl.select()}static dependencies=[{tag:"ax-input",comp:InputElem},{tag:"ax-btn",comp:BtnElem},{tag:"ax-textarea",comp:TextareaElem},{tag:"ax-checkbox",comp:CheckboxElem}];static custAttrs=["name","value","size","format","classes","mode","feature","display","placeholder","label","tools","max-selection","min-date","max-date","datespan","timespan","rows","cols","week-start","separator","btn-sel","pos-sel","input-sel","child-sel","lunar","events","menu","bubble","footer","lang","attrs"];static boolAttrs=["async","disabled","to-drawer","full","multiline","now-hide","now-show","clear-show","close-show","cancel-show","confirm-hide","auto-fill","manual","auto-correct","required","fill-now","rtl"];attributeChangedCallback(t,e,s){this.canListen&&this.updateProxyOpts(DatetimeElem,gt,t,s,e)}getRawData(){this.getRawPropsOpts(DatetimeElem,gt),this.setFieldProps(["name","value","disabled","readOnly"]),this.getListenKeys(DatetimeElem,["name","disabled","value","size"])}fillWrap(t){this.wrapEl=createEl("div",{class:`${s.prefix}datetime-wrap`},this.rawHtml)}createIns(){if(this.ins)return;let t=Object.assign(this.modsOpts.module,{onOutput:t=>{this.modsOpts.module.value=this.propsProxy.value=this.value=t.value,this.canListen=!1,this.setAttribute("value",t.value),this.canListen=!0,this.dispatchEvent(this.events.input.event),this.listen({name:"input",params:[t.value]}),t.value!==t.raw&&(this.dispatchEvent(this.events.change.event),this.listen({name:"changed",params:[t]}))}});this.ins=new Datetime(this.wrapEl,t),this.ins.inputEl.setAttribute(s.embedSign,""),this.focus=()=>{this.ins.inputEl.focus()},this.blur=()=>{this.ins.inputEl.blur()},this.clear=()=>{this.ins.clear(),this.ins.inputEl.clear(),this.listen({name:"cleared"})},this.ins.inputEl.addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.ins.inputEl.addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1)}changedMaps={disabled:this.changedDisabled,size:this.changedSize,name:this.changedName,value:this.changedValue,attrs:this.changedAttrs};changedDisabled(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.disable():this.ins.enable())}changedName(t){let e=t.newVal||"";this.ins&&(this.ins.inputEl.name=e),this.name=e}changedValue(t){this.ins&&(this.ins.setVals(t.newVal),this.ins.confirm()),this.value=this.ins?this.ins.output.value:t.newVal}changedSize(t){this.ins&&(t.newVal?this.ins.inputEl.setAttribute("size",t.newVal):this.ins.inputEl.removeAttribute("size"))}}class RateElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...mt.map((t=>t.attr)),"options","async","attrs"]}attributeChangedCallback(t,e,s){this.canListen&&("value"===t?this.ins&&s&&this.ins.setVals(s):super.updateProxy(t,s,mt))}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new Rate(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class TreeElem extends CompBaseComm{name;value;constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...U.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){this.canListen&&("name"===t?this.name=s:super.updateProxy(t,s,U))}createIns(){this.ins||(this.ins=this.ins=new Tree(this.wrapEl,{onInitiated:function(){this.inputEl&&this.inputEl.setAttribute(s.embedSign,"")},onOutput:t=>{this.value=t.value}}))}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class AccordionElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...Et.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){this.canListen&&("value"===t?this.ins&&s&&this.ins.setVals(s):super.updateProxy(t,s,Et))}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new Accordion(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class EditorElem extends CompBaseCommFieldMixin{type;select;constructor(){super(),this.type="editor-comp",this.select=()=>this.ins.inputEl.select()}static custAttrs=["name","value","delay","classes","content","cont-type","cont-data","ajax","appear","header","mode","min-height","max-height","feature","lang"];static boolAttrs=["async","disabled","readonly","deferred"];attributeChangedCallback(t,e,s){this.canListen&&this.updateProxyOpts(EditorElem,ft,t,s,e)}getRawData(){this.getRawPropsOpts(EditorElem,ft),this.propsRaw.value=this.rawHtml||this.propsRaw.value||"",this.setFieldProps(["name","value","disabled","readOnly"]),this.getListenKeys(EditorElem,["name","disabled","value","readonly"])}createIns(){if(this.ins)return;let t=Object.assign(this.modsOpts.module,{onOutput:t=>{this.modsOpts.module.value=this.propsProxy.value=this.value=t.value,this.canListen=!1,this.setAttribute("value",t.value),this.canListen=!0,this.dispatchEvent(this.events.input.event),this.listen({name:"input",params:[t.value]}),t.value!==t.raw&&(this.dispatchEvent(this.events.change.event),this.listen({name:"changed",params:[{newVal:t.value,oldVal:t.raw}]}))}});this.ins=new Editor(this.wrapEl,t),this.ins.inputEl.setAttribute(s.embedSign,""),this.focus=()=>{(elState(this.ins.inputEl).isVisible?this.ins.inputEl:this.ins.contEl).focus()},this.blur=()=>{(elState(this.ins.inputEl).isVisible?this.ins.inputEl:this.ins.contEl).blur()},this.clear=()=>{this.ins.clearVals(),this.listen({name:"cleared"})},this.ins.inputEl.addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.ins.contEl.addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.ins.inputEl.addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1),this.ins.contEl.addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1),this.ins.inputEl.addEventListener("input",(t=>{t.stopPropagation()}),!1),this.ins.contEl.addEventListener("input",(t=>{t.stopPropagation()}),!1),this.ins.inputEl.addEventListener("change",(t=>{t.stopPropagation()}),!1)}changedMaps={readOnly:this.changedReadOnly,disabled:this.changedDisabled,name:this.changedName,value:this.changedValue};changedBool(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.disable():this.ins.enable())}changedName(t){let e=t.newVal||"";this.ins&&(this.ins.inputEl.name=e),this.name=e}changedValue(t){this.ins&&this.ins.setVals(t.newVal)}changedDisabled(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.disable():this.ins.enable())}changedReadOnly(t){this.readOnly=this.propsProxy[t.name],this.ins&&(this.readOnly?this.ins.readonly():this.ins.enable())}}class SelectElem extends CompBaseCommFieldMixin{type;constructor(){super(),this.type="select-comp"}static custAttrs=["name","value","field","type","exclude","min","max","span","content","cont-type","cont-Data","ajax","size","max-height","search","tools","popup","lang","attrs"];static boolAttrs=["async","manual","disabled","readonly","full","multiple","sliced","removable","unique","collapse","status","auto-width"];attributeChangedCallback(t,e,s){this.canListen&&this.updateProxyOpts(SelectElem,vt,t,s,e)}getRawData(){this.getRawPropsOpts(SelectElem,vt),this.setFieldProps(["name","disabled"]),this.value="",this.getListenKeys(SelectElem,["name","disabled","value","size"])}createIns(){if(this.ins)return;let t=Object.assign(this.modsOpts.module,{onOutput:t=>{this.modsOpts.module.value=this.propsProxy.value=this.value=t.value,this.canListen=!1,this.setAttribute("value",t.value),this.canListen=!0,this.dispatchEvent(this.events.input.event),this.listen({name:"input",params:[t.value]}),t.value!==t.raw&&(this.dispatchEvent(this.events.change.event),this.listen({name:"changed",params:[{newVal:t.value,oldVal:t.raw}]}))}});this.ins=new Select(this.wrapEl,t),this.ins.inputEl.setAttribute(s.embedSign,""),this.focus=()=>{this.wrapEl.focus()},this.blur=()=>{this.wrapEl.blur()},this.clear=()=>{this.ins.clear(),this.listen({name:"cleared"})},this.wrapEl.addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.wrapEl.addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1)}changedMaps={size:this.changedSize,disabled:this.changedDisabled,name:this.changedName,value:this.changedValue,attrs:this.changedAttrs};changedName(t){let e=t.newVal||"";this.ins&&(this.ins.inputEl.name=e),this.name=e}changedValue(t){this.ins&&this.ins.select(t.newVal)}changedDisabled(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.disable():this.ins.enable())}changedSize(t){this.ins&&(t.newVal?this.ins.targetEl.setAttribute("size",t.newVal):this.ins.targetEl.removeAttribute("size"))}}class UploadElem extends CompBaseCommFieldMixin{type;focusEl;constructor(){super(),this.type="upload-comp"}static custAttrs=["name","value","url","content","cont-type","cont-data","ajax","limit","accept","type","feature","size","table","classes","status","choose-btn","upload-btn","clear-btn","cloud","attrs"];static boolAttrs=["async","disabled","readonly","multiple","manual","pastable"];attributeChangedCallback(t,e,s){this.canListen&&this.updateProxyOpts(UploadElem,wt,t,s,e)}getRawData(){this.getRawPropsOpts(UploadElem,wt),this.setFieldProps(["name","value","disabled"]),this.getListenKeys(UploadElem,["name","disabled","value","size"])}createIns(){if(this.ins)return;let t=Object.assign(this.modsOpts.module,{onOutput:t=>{this.modsOpts.module.value=this.propsProxy.value=this.value=t.value,this.canListen=!1,this.setAttribute("value",t.value),this.canListen=!0,this.dispatchEvent(this.events.input.event),this.listen({name:"input",params:[t.value]}),t.value!==t.raw&&(this.dispatchEvent(this.events.change.event),this.listen({name:"changed",params:[{newVal:t.value,oldVal:t.raw}]}))}});this.ins=new Upload(this.wrapEl,t),this.ins.inputEl.setAttribute(s.embedSign,""),this.focusEl="gallery"===this.ins.options.feature?this.wrapEl:this.ins.chooseBtn,this.focus=()=>{this.focusEl.focus()},this.blur=()=>{this.focusEl.blur()},this.clear=()=>{this.ins.clear(),this.listen({name:"cleared"})},this.focusEl.addEventListener("focus",(()=>{this.dispatchEvent(this.events.focus.event)}),!1),this.focusEl.addEventListener("blur",(()=>{this.dispatchEvent(this.events.blur.event)}),!1)}changedMaps={size:this.changedSize,disabled:this.changedDisabled,name:this.changedName,value:this.changedValue,attrs:this.changedAttrs};changedName(t){let e=t.newVal||"";this.ins&&(this.ins.inputEl.name=e),this.name=e}changedValue(t){this.ins&&this.ins.add(t.newVal),this.value=this.ins?this.ins.output.value:t.newVal}changedDisabled(t){this.disabled=this.propsProxy[t.name],this.ins&&(this.disabled?this.ins.lock():this.ins.unlock())}changedSize(t){this.ins&&(t.newVal?this.ins.targetEl.setAttribute("size",t.newVal):this.ins.targetEl.removeAttribute("size"))}}class FieldsElem extends CompBaseCommField{labelEl;limitEl;diskEl;cubeEl;iconEl;btnEl;meanEl;type;childEls;compEls;fieldsEl;unitEl;constructor(){super(),this.type="fields-comp",this.getRawData(),this.btnEl=getEl(":scope > AX-BTN",this),this.childEls=[...this.children].filter((t=>t!==this.btnEl)),this.compEls=this.childEls.filter((t=>i.includes(t.nodeName.toLowerCase().replace("ax-","")))),this.fillWrap(this.propsProxy)}static custAttrs=["size","label","unit","connector","align","shape"];static boolAttrs=["disabled","full","dividable"];static get observedAttributes(){return[...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,FieldsElem)}getRawData(){this.getRawProps(FieldsElem),this.getProxyProps()}fillWrap(t){this.fieldsEl=createEl("div",{[s.alias]:"fields"}),this.fieldsEl.append(...this.childEls),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.fieldsEl),this.btnEl&&this.wrapEl.appendChild(this.btnEl),this.labelEl=createEl("span",{[s.alias]:"label"}),this.unitEl=createEl("span",{[s.alias]:"unit"})}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={size:this.changedSize,align:this.changedSize,label:this.changedLabel,unit:this.changedUnit,connector:this.changedConn,shape:this.changedShape};changedLabel(t){t.newVal?(this.labelEl.innerHTML=t.newVal,elState(this.labelEl).isVirtual&&this.wrapEl.insertAdjacentElement("afterbegin",this.labelEl)):this.labelEl.remove()}changedUnit(t){t.newVal?(this.unitEl.innerHTML=t.newVal,elState(this.unitEl).isVirtual&&this.fieldsEl.insertAdjacentElement("afterend",this.unitEl)):this.unitEl.remove()}changedSize(t){if(t.newVal){for(let e of this.compEls)e.setAttribute(t.name,t.newVal);this.btnEl&&"size"===t.name&&this.btnEl.setAttribute(t.name,t.newVal)}else{for(let e of this.compEls)e.removeAttribute(t.name);this.btnEl&&"size"===t.name&&this.btnEl.removeAttribute(t.name)}}changedConn(t){if(t.newVal)for(let[e,i]of this.childEls.entries())e!==this.childEls.length-1&&i.insertAdjacentHTML("afterend",`<i ${s.alias}="connector">${t.newVal}</i>`);else{let t=getEls(`[${s.alias}="connector"]`,this.fieldsEl);for(let e of t)e.remove()}}changedShape(t){t.newVal?this.btnEl&&this.btnEl.setAttribute("shape",t.newVal):this.btnEl&&this.btnEl.removeAttribute("shape")}}class SearchElem extends CompBaseCommField{labelEl;limitEl;diskEl;cubeEl;iconEl;btnEl;meanEl;type;fieldsEl;constructor(){super(),this.type="search-comp",this.getRawData(),this.fieldsEl=getEl(":scope > AX-FIELDS",this),this.fillWrap(this.propsProxy)}static dependencies=[{tag:"ax-fields",comp:FieldsElem}];static custAttrs=["size","label","feature","shape"];static boolAttrs=["disabled","full","notable"];static get observedAttributes(){return[...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&(this.propsProxy[t]=SearchElem.boolAttrs.includes(t)?getAttrBool(s):s,this.changedMaps[t]&&this.changedMaps[t].call(this,{name:t,newVal:s,oldVal:e,proxy:this.propsProxy}))}getRawData(){for(let t of[...SearchElem.custAttrs,...SearchElem.lazyAttrs])this.propsRaw[t]=this.getAttribute(t);for(let t of SearchElem.boolAttrs)this.propsRaw[t]=getAttrBool(this.getAttribute(t));this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.fieldsEl)}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={full:this.changedFull,size:this.changedSize,notable:this.changedNotable,shape:this.changedShape};changedFull(t){this.fieldsEl&&this.fieldsEl.toggleAttribute("full",!!t.newVal)}changedSize(t){this.fieldsEl&&(t.newVal?this.fieldsEl.setAttribute("size",t.newVal):this.fieldsEl.removeAttribute("size"))}changedNotable(t){this.fieldsEl?.btnEl&&(this.propsProxy.notable?this.fieldsEl.btnEl.setAttribute("theme","prim"):this.fieldsEl.btnEl.removeAttribute("theme"))}changedShape(t){this.fieldsEl?.btnEl&&(t.newVal?this.fieldsEl.setAttribute("shape",t.newVal):this.fieldsEl.removeAttribute("shape"))}}class TwilightElem extends CompBaseComm{labelEl;legendEl;targetEl;labels;isDay;toggleEvt;constructor(){super(),this.getRawData(),this.labels=[l.lang.twilight.day,l.lang.twilight.night],this.isDay=!0,this.toggleEvt=()=>{let t=this.targetEl||document.body;t.hasAttribute("scheme")?(this.labelEl.innerHTML=this.labels[0],t.removeAttribute("scheme"),this.isDay=!0):(this.labelEl.innerHTML=this.labels[1],t.setAttribute("scheme","dark"),this.isDay=!1)},this.fillWrap(this.propsProxy)}static custAttrs=["labels","target","feature",...this.baseAttrs];static boolAttrs=[""];static get observedAttributes(){return[...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,TwilightElem)}getRawData(){this.getRawProps(TwilightElem),this.getProxyProps()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"}),this.labelEl=createEl("i",{[s.alias]:"label"},this.labels[0]);let e=Date.now();this.legendEl=createEl("i",{[s.alias]:"legend"},`\n                <svg viewBox="0 0 24 24">\n                    <mask id="mask-${e}">\n                        <rect x="0" y="0" width="100%" height="100%" fill="white" />\n                        <circle  cy="13" r="6" stroke="none" class="${s.prefix}twilight-mask" fill="dark" />\n                    </mask>\n                    <circle fill="currentColor" cx="12" cy="12" r="6" class="${s.prefix}twilight-main" mask="url(#mask-${e})" />\n                    <g stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" class="${s.prefix}twilight-rays">\n                        <line x1="12" y1="1" x2="12" y2="3" />\n                        <line x1="12" y1="21" x2="12" y2="23" />\n                        <line x1="4.22" y1="4.22" x2="5.64" y2="5.64" />\n                        <line x1="18.36" y1="18.36" x2="19.78" y2="19.78" />\n                        <line x1="1" y1="12" x2="3" y2="12" />\n                        <line x1="21" y1="12" x2="23" y2="12" />\n                        <line x1="4.22" y1="19.78" x2="5.64" y2="18.36" />\n                        <line x1="18.36" y1="5.64" x2="19.78" y2="4.22" />\n                    </g>\n                </svg>\n        `),this.wrapEl.append(this.labelEl,this.legendEl)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.removeEventListener("click",this.toggleEvt),this.addEventListener("click",this.toggleEvt,!1)}changedMaps={feature:this.changedFeature,target:this.changedTarget,labels:this.changedLabels};changedTarget(t){this.targetEl=getEl(t.newVal)}changedFeature(t){t.newVal?this.labelEl.remove():this.wrapEl.insertAdjacentElement("afterbegin",this.labelEl)}changedLabels(t){t.newVal&&(this.labels=valToArr(t.newVal),this.labelEl.innerHTML=this.labels[this.isDay?0:1])}}class PaginationElem extends CompBaseComm{constructor(){super(),this.createShadow(),super.createPropsObs(),this.fillWrap(this.propsProxy)}static get observedAttributes(){return[...pt.map((t=>t.attr)),"options","async"]}attributeChangedCallback(t,e,s){this.canListen&&("current"===t?this.ins&&s&&this.ins.locate(s):super.updateProxy(t,s,pt))}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"slot-host"},this.rawHtml)}createIns(){this.ins||(this.ins=new Pagination(this.wrapEl))}render(){this.insertSource(),this.appendChild(this.wrapEl),this.propsProxy.async?requestIdleCallback((()=>this.createIns())):this.createIns()}}class StepElem extends CompBaseComm{content;template;constructor(){super(),this.template=`\n        {{let active = this.active?'active':'',\n            href = this.href ?'href="'+this.href+'"':'',\n            name = href?'a':'div',\n            target = href && this.target?'target="'+this.target+'"':'',\n            rel= href && this.rel?'rel="'+this.rel+'"':'';\n        /}}\n        <{{name}} {{href}} {{target}} {{rel}} {{active}} class="_step-item _reset">\n            <div class="_step-track">\n                <div></div>\n                <span ${s.alias}="node"></span>\n                <div></div>\n            </div>\n        </{{name}}>\n    `,this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["active","type","theme","dir","error",...this.baseAttrs];static boolAttrs=["head-show","body-show","inverted","justify"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,StepElem)}getRawData(){this.getRawProps(StepElem),this.propsRaw.content=this.getAttribute("content")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.content=this.stdContent(this.getArrContent());let e=document.createDocumentFragment();for(let t of this.content){let i=tplToEl(renderTpl(this.template,t));t.wrapEl=i,t.wrapEl.querySelector(`[${s.alias}="node"]`).innerHTML=this.getLegend(t),t.headEl=createEl("div",{class:`${s.prefix}step-head`},t.tips),t.labelEl=createEl("div",{[s.alias]:"label"},t.label),t.briefEl=createEl("div",{[s.alias]:"brief"},t.brief),t.bodyEl=createEl("div",{class:`${s.prefix}step-body`},[t.labelEl,t.briefEl]),e.appendChild(i)}this.wrapEl=createEl("div",{[s.alias]:"wrap"},t.label),this.wrapEl.appendChild(e)}getArrContent(t=this.propsProxy.content){let e=t.trim(),s=createEl("div",{},e),i=s.firstElementChild,a=[];if(e.startsWith("<")&&i){a="SCRIPT"===i.nodeName&&i.getAttribute("type").includes("content")?parseStr({content:i.textContent,type:"array",error:t=>{}}):[...s.children].map(((t,e)=>{let s={label:t.getAttribute("label")||t.textContent.trim(),brief:t.getAttribute("brief"),tips:t.getAttribute("tips"),icon:t.getAttribute("icon"),cube:t.getAttribute("cube"),image:t.getAttribute("image"),disk:t.getAttribute("disk")};return"A"===t.nodeName&&(s.target=t.getAttribute("target"),s.rel=t.getAttribute("rel"),s.href=t.getAttribute("href")),s}))}else a=parseStr({content:t,type:"array",error:t=>{}});return a}stdContent(t){return Array.isArray(t)?t.map(((t,e)=>"string"==typeof t||"number"==typeof t?{label:t,index:e+1}:Object.assign(t,{index:e+1}))):[]}getLegend(t){let e=this.propsProxy.type,s=t.icon?'<i class="'+t.icon+'"></i>':t.image?'<img src="'+t.image+'"/>':t.index,i="";return e?.includes("circle")?i=s:"plain"===e&&(i=t.field?"icon"===t.field?'<i class="'+t.icon+'"></i>':"image"===t.field?'<img src="'+t.image+'"/>':t[t.field]:s),i}setLegendType(){for(let t of this.content){let e=this.getLegend(t);t.wrapEl.querySelector(`[${s.alias}="node"]`).innerHTML=e}}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={"head-show":this.changedHeadshow,"body-show":this.changedBodyshow,active:this.changedActive,error:this.changedError,content:this.changedContent,type:this.changedType};changedHeadshow(t){for(let t of this.content)this.propsProxy["head-show"]?t.wrapEl.insertAdjacentElement("afterbegin",t.headEl):t.headEl.remove()}changedBodyshow(t){for(let t of this.content)this.propsProxy["body-show"]?t.wrapEl.insertAdjacentElement("beforeend",t.bodyEl):t.bodyEl.remove()}changedActive(t){if(t.newVal){let e=Math.min(~~t.newVal,this.content.length-1);for(let[t,s]of this.content.entries()){let i=t===e;s.wrapEl.toggleAttribute("active",i),s.active=i}}}changedError(t){let e=t.newVal?valToArr(t.newVal):[];if(e.length)for(let[t,s]of this.content.entries())s.wrapEl.toggleAttribute("error",!!e.includes(t));else for(let t of this.content)t.wrapEl.toggleAttribute("error",!1)}changedContent(t){t.newVal&&(this.wrapEl.remove(),this.fillWrap(this.propsProxy),this.appendChild(this.wrapEl))}changedType(t){this.setLegendType()}}class StatusElem extends CompBaseComm{lampEl;labelEl;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["type","lamp","current",...this.baseAttrs];static boolAttrs=[];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,StatusElem)}getRawData(){this.getRawProps(StatusElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.lampEl=createEl("i",{[s.alias]:"lamp"}),this.labelEl=createEl("i",{[s.alias]:"label"},this.propsProxy.lang?.info||l.lang.status.info),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.lampEl),this.propsRaw.label&&this.wrapEl.appendChild(this.labelEl)}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel,lamp:this.changedLamp,current:this.changedCurrent};changedLabel(t){if(null===t.newVal)this.labelEl.remove();else{elState(this.labelEl).isVirtual&&this.wrapEl.appendChild(this.labelEl);let e=this.propsProxy.current||"info";this.labelEl.innerHTML=t.newVal?t.newVal:this.propsProxy.lang?.[e]||l.lang.status[e]}}changedLamp(t){let e="circle"===this.propsProxy.type?"borderColor":"background";this.lampEl.style[e]=t.newVal||null}changedCurrent(t){t.newVal&&(this.labelEl.innerHTML=this.propsProxy.lang?.[t.newVal]||l.lang.status[t.newVal])}}class CategoryElem extends CompBaseComm{headEl;iconEl;diskEl;cubeEl;imageEl;labelEl;tipsEl;arrowEl;legends;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=[...this.baseAttrs,"size","theme","icon","disk","cube","image","tips","arrow"];static get observedAttributes(){return["label",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,CategoryElem)}getRawData(){this.getRawProps(CategoryElem),this.propsRaw.label=this.getAttribute("label")||this.rawHtml,this.getProxyProps()}fillWrap(t){this.labelEl=createEl("i",{[s.alias]:"label"},t.label),this.headEl=createEl("div",{[s.alias]:"head"},this.labelEl),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.headEl),this.arrowEl=createEl("i",{[s.alias]:"arrow",class:`${s.prefix}icon-right`}),this.tipsEl=createEl("i",{[s.alias]:"tips"},t.tips),this.iconEl=createEl("i",{[s.alias]:"icon",class:t.label}),this.diskEl=createEl("img",{[s.alias]:"disk",src:t.disk}),this.cubeEl=createEl("img",{[s.alias]:"cube",src:t.cube}),this.imageEl=createEl("img",{[s.alias]:"image",src:t.image}),this.legends=[{name:"icon",el:this.iconEl,attr:"class"},{name:"disk",el:this.diskEl,attr:"src"},{name:"cube",el:this.cubeEl,attr:"src"},{name:"image",el:this.imageEl,attr:"src"}]}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={label:this.changedLabel,icon:this.changedLegend,disk:this.changedLegend,cube:this.changedLegend,image:this.changedLegend,tips:this.changedTips,arrow:this.changedArrow};changedLabel(t){this.labelEl.innerHTML=t.newVal}changedTips(t){null===t.newVal?this.tipsEl.remove():(this.tipsEl.innerHTML=t.newVal,this.headEl.insertAdjacentElement("afterend",this.tipsEl))}changedArrow(t){null===t.newVal?this.arrowEl.remove():(this.arrowEl.setAttribute("class",t.newVal?t.newVal:`${s.prefix}icon-right`),this.wrapEl.appendChild(this.arrowEl))}changedLegend(t){let e=this.legends.find((e=>e.name===t.name));if(t.newVal){e.el.setAttribute(e.attr,t.newVal),elState(e.el).isVirtual&&this.headEl.insertAdjacentElement("beforebegin",e.el);for(let t of this.legends)t!==e&&!elState(t.el).isVirtual&&t.el.remove()}else e.el.remove()}}class SkeletonElem extends CompBaseComm{headEl;iconEl;diskEl;cubeEl;imageEl;labelEl;tipsEl;arrowEl;legends;cols;rows;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["type","anim","cols","rows",...this.baseAttrs];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,SkeletonElem)}getRawData(){this.getRawProps(SkeletonElem),this.propsRaw.content=this.getAttribute("content")||this.rawHtml,this.getProxyProps(),this.cols=this.getCols(),this.rows=this.getRows()}fillWrap(t){this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.getSkelStr())}getRows(t=this.propsProxy.rows){return~~this.propsProxy.rows||1}getCols(t=this.propsProxy.cols){let e,s=null;return isNull(t)?s:(t?.includes(",")?(e=strToJson(t),s=~~e[getScreenSize()]):s=~~t,s||4)}getSkelStr(){if(!this.propsProxy.type)return this.propsProxy.content?this.propsProxy.content.repeat((this.cols||1)*this.rows):"";if("article"===this.propsProxy.type)return`\n            <section>\n                <div rep="legend">\n                </div>\n                <div rep="text">\n                ${"<div></div>".repeat(this.rows>1?this.rows:19)}\n                </div>\n            </section>\n            `;{let t=this.propsProxy.type.includes("avatar")?2:"paragraph"===this.propsProxy.type?4:3;return`\n        <section>\n                <div rep="legend"></div>\n                <div rep="text">\n                ${"<div></div>".repeat(t)}\n                </div>\n            </section>\n        `.repeat((this.cols||1)*this.rows)}}render(){this.insertSource(),this.appendChild(this.wrapEl)}changedMaps={content:this.changedContent,cols:this.changedCols,rows:this.changedRows,type:this.changedType};changedContent(t){this.wrapEl.innerHTML=this.getSkelStr()}changedType(t){this.wrapEl.innerHTML=this.getSkelStr()}changedCols(t){this.cols=this.getCols(t.newVal),this.wrapEl.style.gridTemplateColumns=this.cols?`repeat(${this.cols}, 1fr)`:null,this.wrapEl.innerHTML=this.getSkelStr()}changedRows(t){this.rows=this.getRows(t.newVal),this.wrapEl.innerHTML=this.getSkelStr()}}class PillElem extends CompBaseComm{content;itemsEl;thumbEl;activeItem;bodyEl;inputEl;value;name;constructor(){super(),this.getRawData(),this.fillWrap(this.propsProxy)}static custAttrs=["active","disable","refer","name","on-changed",...this.baseAttrs];static boolAttrs=["disabled"];static get observedAttributes(){return["content",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&this.savePropsToListen(t,e,s,PillElem)}getRawData(){this.getRawProps(PillElem),this.propsRaw.content=this.getAttribute("content")||this.rawHtml,this.propsRaw.active=~~this.propsRaw.active||0,this.getProxyProps()}getLegend(t){let e=t.disk||t.cube||t.image;return t.icon?`<i class="${t.icon}" rep="icon"></i>`:e?`<img src="${e}" rep="${e}" />`:""}getItemsData(t){let e=super.getAttrHtmlData(t);return Array.isArray(e)?e.map(((t,e)=>"string"==typeof t||"number"==typeof t?{label:t,index:e}:Object.assign(t,{index:e}))):[]}getItems(t=this.propsProxy){this.content=this.getItemsData(t.content);let e=document.createDocumentFragment();for(let[t,i]of this.content.entries()){let a=this.getLegend(i),l=tplToEl(renderTpl(`<span ${s.alias}="item" {{this.selected?'selected':''}}  {{this.disabled?'disabled':''}}>${a}<i rep=label>{{this.label}}</i></span>`,i));i.wrapEl=l,e.appendChild(l),i.wrapEl.onclick=()=>{!i.selected&&!i.disabled&&this.active(t)}}return e}active(t=0){let e=this.content.find((t=>t.selected)),s=Math.min(~~t,this.content.length-1);for(let[t,i]of this.content.entries()){let a=t===s;i.wrapEl.toggleAttribute("selected",a),i.selected=a,a&&(this.setTranslate(i.wrapEl),this.activeItem=i,this.value=i.label,this.inputEl&&(this.inputEl.value=i.label),this.listen({name:"changed",params:[{oldVal:e,newVal:i}]}))}if(this.bodyEl)for(let[t,e]of[...this.bodyEl.children].entries()){let i=t===s;e.toggleAttribute("selected",i)}this.updateCache({active:t})}disable(t){let e=valToArr(t);if(e.length){for(let t of e){let e=Math.min(~~t,this.content.length-1);for(let[t,s]of this.content.entries()){let i=t===e;s.wrapEl.toggleAttribute("disabled",i),s.disabled=i}}this.updateCache({disable:t}),this.listen({name:"disabled",params:[e.map((t=>this.content[t]))]})}}setTranslate(t){this.style.setProperty(`--${s.prefix}pill-thumb-offset`,t.offsetLeft+"px"),this.style.setProperty(`--${s.prefix}pill-thumb-w`,t.offsetWidth+"px")}fillWrap(t=this.propsProxy){this.itemsEl=createEl("div",{[s.alias]:"items"}),this.thumbEl=createEl("span",{[s.alias]:"thumb"}),this.bodyEl=getEl(t.refer),this.wrapEl=createEl("div",{[s.alias]:"wrap"},[this.itemsEl,this.thumbEl]),this.itemsEl.appendChild(this.getItems(t))}render(t=this.propsProxy){this.insertSource(),this.appendChild(this.wrapEl),this.active(t.active)}changedMaps={active:this.changedActive,disable:this.changedDisable,content:this.changedContent,refer:this.changedRefer,name:this.changedName};changedActive(t){t.newVal&&this.active(t.newVal)}changedContent(t){t.newVal&&(this.itemsEl.innerHTML="",this.itemsEl.appendChild(this.getItems()),this.propsProxy.active&&this.active(this.propsProxy.active),this.propsProxy.disable&&this.disable(this.propsProxy.disable))}changedDisable(t){t.newVal&&this.disable(t.newVal)}changedRefer(t){t.newVal&&(this.bodyEl=getEl(t.newVal),this.bodyEl&&this.bodyEl.classList.add(`${s.prefix}pill-body`))}changedName(t){this.name=t.newVal||"",t.newVal?this.inputEl?this.inputEl.setAttribute(t.name,t.newVal):(this.inputEl=createEl("input",{type:"text",name:t.newVal,[s.embedSign]:""}),this.wrapEl.appendChild(this.inputEl)):this.inputEl&&this.inputEl.remove()}}class ColorElem extends CompBaseCommField{labelEl;inputEvt;meanEl;colorIns;type;select;updateEvt;copyEl;closeEl;insOpts;constructor(){super(),this.type="color-comp",this.getRawData(),this.fillWrap(this.propsProxy),this.select=()=>this.inputEl.inputEl.select(),this.updateEvt=debounce((()=>{this.ins.update(deepMerge(this.insOpts,this.propsProxy.color))})),this.clear=t=>{this.removeAttribute("value"),this.value="",this.setLamp(),this.inputEl.removeAttribute("value"),this.listen({name:"cleared",cb:t})},this.insOpts={output:{}}}static dependencies=[{tag:"ax-input",comp:InputElem},{tag:"ax-btn",comp:BtnElem},{tag:"ax-textarea",comp:TextareaElem},{tag:"ax-checkbox",comp:CheckboxElem},{tag:"ax-radio",comp:RadioElem},{tag:"ax-radios",comp:RadiosElem}];static custAttrs=["name","value","size","format","layout","placeholder","label",...this.evtsArr];static boolAttrs=["manual","disabled","readonly","full","detectable"];static jsonAttrs=["color","lang"];static get observedAttributes(){return["value",...this.custAttrs,...this.boolAttrs,...this.jsonAttrs]}attributeChangedCallback(t,e,s){this.canListen&&(this.savePropsToListen(t,e,s,ColorElem),e!==s&&this.listen({name:"changed",params:[{oldVal:e,newVal:s}]}))}getRawData(){this.getRawProps(ColorElem),this.propsRaw.value=this.value=this.getAttribute("value")||this.rawHtml,this.getProxyProps(),this.setFieldProps(["name","value","disabled","readOnly"])}fillWrap(t){this.inputEl=createEl("ax-input",{value:this.value,icon:`${s.prefix}color-lamp`,tools:"['copy','close']"}),this.propsProxy.placeholder&&this.inputEl.setAttribute("placeholder",this.propsProxy.placeholder),this.propsProxy.disabled&&this.inputEl.setAttribute("disabled",""),this.propsProxy.readonly&&this.inputEl.setAttribute("readonly",""),this.propsProxy.full&&this.inputEl.setAttribute("full",""),this.wrapEl=createEl("div",{[s.alias]:"wrap"},this.inputEl)}createIns(){this.ins||(this.ins=new Color(this.inputEl,deepMerge({value:this.value,popup:{canClick:t=>!this.copyEl.contains(t)&&!this.closeEl.contains(t),b4Show:()=>new Promise((t=>{!this.propsProxy.readonly&&t()})),onShow:()=>{this.propsProxy.detectable&&this.value!==this.ins.value&&this.ins.assignVals(this.value)}},onCleared:()=>{this.clear()},onFilled:t=>{this.setAttribute("value",t)}},this.propsProxy.color)))}setLamp(t=this.value){this.style.setProperty(`--${s.prefix}color-lamp`,t)}render(){this.insertSource(),this.appendChild(this.wrapEl),this.copyEl=getEl(`[${s.alias}="copy"]`,this.inputEl.toolsEl),this.closeEl=getEl(`[${s.alias}="close"]`,this.inputEl.toolsEl),this.closeEl.onclick=()=>{this.clear()},this.copyEl.onclick=()=>{this.value&&navigator.clipboard.writeText(this.value).then((()=>new Toast({content:this.ins.options.lang.message.copy,status:"succ",eager:!0})))},this.setLamp(),setTimeout((()=>{this.createIns()}),0)}changedMaps={disabled:this.changedDisabled,readonly:this.changedReadonly,size:this.changedSize,label:this.changedSize,name:this.changedName,value:this.changedName,format:this.changedFormat,manual:this.changedManual,layout:this.changedLayout,color:this.changedColor};changedDisabled(t){this.disabled=this.propsProxy[t.name],this.inputEl.toggleAttribute(t.name,this.propsProxy[t.name])}changedReadonly(t){this.readOnly=this.propsProxy[t.name],this.inputEl.toggleAttribute(t.name,this.propsProxy[t.name])}changedName(t){this[t.name]=t.newVal||"",this.inputEl.setAttribute(t.name,this[t.name]),"value"===t.name&&this.setLamp()}changedSize(t){t.newVal?this.inputEl.setAttribute(t.name,this[t.name]):this.inputEl.removeAttribute(t.name)}changedColor(t){this.updateEvt()}changedFormat(t){this.insOpts.output.format=t.newVal,this.updateEvt()}changedManual(t){this.insOpts.output.manual=this.propsProxy.manual,this.updateEvt()}changedLayout(t){this.insOpts.layout=t.newVal,this.updateEvt()}}var Ct={ax:s,config:l,fieldTypes:i,getDataType:getDataType,renderTpl:renderTpl,getScreenSize:getScreenSize,sliceStrEnd:sliceStrEnd,delay:delay,toNumber:toNumber,toPixel:toPixel,preventDft:preventDft,events:n,icons:r,propsMap:o,augment:augment,privacy:privacy,support:support,requireTypes:requireTypes,trim:trim,getSelectorType:getSelectorType,isEmpty:isEmpty,isNull:isNull,getEl:getEl,deepClone:deepClone,deepMerge:deepMerge,strToJson:strToJson,attrToJson:attrToJson,attrJoinVal:attrJoinVal,extend:extend,plan:m,instance:h,breakpoints:breakpoints,createEl:createEl,purifyHtml:purifyHtml,startUpper:startUpper,storage:u,isDateStr:isDateStr,getExpiration:getExpiration,ajax:ajax,offset:offset,elState:elState,contains:contains,getEls:getEls,getContent:getContent,setContent:setContent,createBtns:createBtns,createFooter:createFooter,createTools:createTools,tplToEl:tplToEl,tplToEls:tplToEls,getHeights:getHeights,getWidths:getWidths,getElSpace:getElSpace,slideDown:slideDown,slideUp:slideUp,slideToggle:slideToggle,curveFns:v,ease:ease,easeHeight:easeHeight,fadeIn:fadeIn,fadeOut:fadeOut,fadeToggle:fadeToggle,style:style,show:show,hide:hide,toggle:toggle,spreadBool:spreadBool,getClasses:getClasses,classes:classes,validTools:w,toLocalTime:toLocalTime,regExps:A,replaceFrag:replaceFrag,combineArr:combineArr,sliceFrags:sliceFrags,paramToJson:paramToJson,getLast:getLast,fieldTools:E,isSubset:isSubset,debounce:debounce,throttle:throttle,storeNode:storeNode,convertByte:convertByte,clampVal:clampVal,formTools:x,fileTools:T,unique:unique,increaseId:increaseId,treeTools:S,valToArr:valToArr,moveItem:moveItem,getValsFromAttrs:getValsFromAttrs,dl2Tree:dl2Tree,findItem:findItem,findItems:findItems,getAttrBool:getAttrBool,getAttrArr:getAttrArr,theme:k,attrValBool:attrValBool,getBetweenEls:getBetweenEls,scrollTo:scrollTo,allToEls:allToEls,getUTCTimestamp:getUTCTimestamp,setAttr:setAttr,setAttrs:setAttrs,getScrollObj:getScrollObj,transformTools:C,isScrollUp:isScrollUp,eventMap:$,getClientObj:getClientObj,bulletTools:b,arrSearch:arrSearch,arrSort:arrSort,isProxy:isProxy,getNestProp:getNestProp,getIntArr:getIntArr,clearRegx:clearRegx,isOutside:isOutside,getRectPoints:getRectPoints,elsSort:elsSort,getEvtTarget:getEvtTarget,getEvtClient:getEvtClient,getStrFromTpl:getStrFromTpl,stdParam:stdParam,setSingleSel:setSingleSel,splitNum:splitNum,parseUrlArr:parseUrlArr,getPlaces:getPlaces,dateTools:D,repeatStr:repeatStr,createModule:createModule,createComp:createComp,getArrMap:getArrMap,includes:includes,capStart:capStart,removeItem:removeItem,deepEqual:deepEqual,splice:splice,appendEls:appendEls,decompTask:decompTask,filterPrims:filterPrims,createEvt:createEvt,confirm:confirm,alert:alert,notice:notice,prompt:prompt,keyCond:keyCond,removeStyle:removeStyle,removeStyles:removeStyles,addStyle:addStyle,addStyles:addStyles,regComp:regComp,getComputedVar:getComputedVar,select2Tree:select2Tree,ul2Tree:ul2Tree,parseStr:parseStr,getAutoDur:getAutoDur,getHypotenuse:getHypotenuse,promiseRaf:promiseRaf,getRtl:getRtl,setRtl:setRtl,isChildVisible:isChildVisible,drawColor:drawColor,alpha2Hex:alpha2Hex,hex2Alpha:hex2Alpha,rgb2Hex:rgb2Hex,rgb2Hsl:rgb2Hsl,rgb2Hwb:rgb2Hwb,hwb2Rgb:hwb2Rgb,hsl2Rgb:hsl2Rgb,hex2Rgb:hex2Rgb,parseRgb:parseRgb,hsl2Hwb:hsl2Hwb,hwb2Hsl:hwb2Hsl,ModBase:ModBase,ModBaseListen:ModBaseListen,ModBaseListenCache:ModBaseListenCache,ModBaseListenCacheBubble:ModBaseListenCacheBubble,ModBaseListenCacheNest:ModBaseListenCacheNest,More:More,Observe:Observe,Position:Position,Hover:Hover,Popup:Popup,Dodge:Dodge,Message:Message,Valid:Valid,Menu:Menu,Tab:Tab,Drawer:Drawer,Dialog:Dialog,Spy:Spy,Tooltip:Tooltip,Dropdown:Dropdown,Gesture:Gesture,Tags:Tags,Retrieval:Retrieval,Autocomplete:Autocomplete,Scroll:Scroll,Drag:Drag,Masonry:Masonry,Swipe:Swipe,Lazy:Lazy,Progress:Progress,Infinite:Infinite,Virtualize:Virtualize,Pagination:Pagination,Range:Range,Datetime:Datetime,Tree:Tree,Rate:Rate,Accordion:Accordion,Editor:Editor,Select:Select,Upload:Upload,Panel:Panel,Router:Router,Flip:Flip,Viewer:Viewer,Toast:Toast,Color:Color,CompBase:CompBase,CompBaseComm:CompBaseComm,CompBaseCommField:CompBaseCommField,CompBaseCommFieldMixin:CompBaseCommFieldMixin,MoreElem:MoreElem,ResultElem:ResultElem,DeformElem:DeformElem,RadioElem:RadioElem,CheckboxElem:CheckboxElem,BtnElem:BtnElem,LineElem:LineElem,AvatarElem:AvatarElem,FormatElem:FormatElem,FlagElem:FlagElem,BuoyElem:BuoyElem,GoodElem:GoodElem,AnchorsElem:AnchorsElem,MenuElem:MenuElem,FileElem:FileElem,InputElem:InputElem,TextareaElem:TextareaElem,RadiosElem:RadiosElem,CheckboxesElem:CheckboxesElem,NumberElem:NumberElem,RangeElem:RangeElem,StatsElem:StatsElem,IconElem:IconElem,BadgeElem:BadgeElem,DividerElem:DividerElem,AlarmElem:AlarmElem,ProgressElem:ProgressElem,DatetimeElem:DatetimeElem,RateElem:RateElem,TreeElem:TreeElem,AccordionElem:AccordionElem,EditorElem:EditorElem,SelectElem:SelectElem,UploadElem:UploadElem,FieldsElem:FieldsElem,SearchElem:SearchElem,CalloutElem:CalloutElem,TwilightElem:TwilightElem,PaginationElem:PaginationElem,StepElem:StepElem,StatusElem:StatusElem,CategoryElem:CategoryElem,SkeletonElem:SkeletonElem,PillElem:PillElem,ColorElem:ColorElem,init:init};const $t={...Object.freeze({__proto__:null,Accordion:Accordion,AccordionElem:AccordionElem,AlarmElem:AlarmElem,AnchorsElem:AnchorsElem,Autocomplete:Autocomplete,AvatarElem:AvatarElem,BadgeElem:BadgeElem,BtnElem:BtnElem,BuoyElem:BuoyElem,CalloutElem:CalloutElem,CategoryElem:CategoryElem,CheckboxElem:CheckboxElem,CheckboxesElem:CheckboxesElem,Color:Color,ColorElem:ColorElem,CompBase:CompBase,CompBaseComm:CompBaseComm,CompBaseCommField:CompBaseCommField,CompBaseCommFieldMixin:CompBaseCommFieldMixin,Datetime:Datetime,DatetimeElem:DatetimeElem,DeformElem:DeformElem,Dialog:Dialog,DividerElem:DividerElem,Dodge:Dodge,Drag:Drag,Drawer:Drawer,Dropdown:Dropdown,Editor:Editor,EditorElem:EditorElem,FieldsElem:FieldsElem,FileElem:FileElem,FlagElem:FlagElem,Flip:Flip,FormatElem:FormatElem,Gesture:Gesture,GoodElem:GoodElem,Hover:Hover,IconElem:IconElem,Infinite:Infinite,InputElem:InputElem,Lazy:Lazy,LineElem:LineElem,Masonry:Masonry,Menu:Menu,MenuElem:MenuElem,Message:Message,ModBase:ModBase,ModBaseListen:ModBaseListen,ModBaseListenCache:ModBaseListenCache,ModBaseListenCacheBubble:ModBaseListenCacheBubble,ModBaseListenCacheNest:ModBaseListenCacheNest,More:More,MoreElem:MoreElem,NumberElem:NumberElem,Observe:Observe,Pagination:Pagination,PaginationElem:PaginationElem,Panel:Panel,PillElem:PillElem,Popup:Popup,Position:Position,Progress:Progress,ProgressElem:ProgressElem,RadioElem:RadioElem,RadiosElem:RadiosElem,Range:Range,RangeElem:RangeElem,Rate:Rate,RateElem:RateElem,ResultElem:ResultElem,Retrieval:Retrieval,Router:Router,Scroll:Scroll,SearchElem:SearchElem,Select:Select,SelectElem:SelectElem,SkeletonElem:SkeletonElem,Spy:Spy,StatsElem:StatsElem,StatusElem:StatusElem,StepElem:StepElem,Swipe:Swipe,Tab:Tab,Tags:Tags,TextareaElem:TextareaElem,Toast:Toast,Tooltip:Tooltip,Tree:Tree,TreeElem:TreeElem,TwilightElem:TwilightElem,Upload:Upload,UploadElem:UploadElem,Valid:Valid,Viewer:Viewer,Virtualize:Virtualize,addStyle:addStyle,addStyles:addStyles,ajax:ajax,alert:alert,allToEls:allToEls,alpha2Hex:alpha2Hex,appendEls:appendEls,arrSearch:arrSearch,arrSort:arrSort,attrJoinVal:attrJoinVal,attrToJson:attrToJson,attrValBool:attrValBool,augment:augment,ax:s,breakpoints:breakpoints,bulletTools:b,capStart:capStart,clampVal:clampVal,classes:classes,clearRegx:clearRegx,combineArr:combineArr,config:l,confirm:confirm,contains:contains,convertByte:convertByte,createBtns:createBtns,createComp:createComp,createEl:createEl,createEvt:createEvt,createFooter:createFooter,createModule:createModule,createTools:createTools,curveFns:v,dateTools:D,debounce:debounce,decompTask:decompTask,deepClone:deepClone,deepEqual:deepEqual,deepMerge:deepMerge,default:Ct,delay:delay,dl2Tree:dl2Tree,drawColor:drawColor,ease:ease,easeHeight:easeHeight,elState:elState,elsSort:elsSort,eventMap:$,events:n,extend:extend,fadeIn:fadeIn,fadeOut:fadeOut,fadeToggle:fadeToggle,fieldTools:E,fieldTypes:i,fileTools:T,filterPrims:filterPrims,findItem:findItem,findItems:findItems,formTools:x,getArrMap:getArrMap,getAttrArr:getAttrArr,getAttrBool:getAttrBool,getAutoDur:getAutoDur,getBetweenEls:getBetweenEls,getClasses:getClasses,getClientObj:getClientObj,getComputedVar:getComputedVar,getContent:getContent,getDataType:getDataType,getEl:getEl,getElSpace:getElSpace,getEls:getEls,getEvtClient:getEvtClient,getEvtTarget:getEvtTarget,getExpiration:getExpiration,getHeights:getHeights,getHypotenuse:getHypotenuse,getIntArr:getIntArr,getLast:getLast,getNestProp:getNestProp,getPlaces:getPlaces,getRectPoints:getRectPoints,getRtl:getRtl,getScreenSize:getScreenSize,getScrollObj:getScrollObj,getSelectorType:getSelectorType,getStrFromTpl:getStrFromTpl,getUTCTimestamp:getUTCTimestamp,getValsFromAttrs:getValsFromAttrs,getWidths:getWidths,hex2Alpha:hex2Alpha,hex2Rgb:hex2Rgb,hide:hide,hsl2Hwb:hsl2Hwb,hsl2Rgb:hsl2Rgb,hwb2Hsl:hwb2Hsl,hwb2Rgb:hwb2Rgb,icons:r,includes:includes,increaseId:increaseId,init:init,instance:h,isChildVisible:isChildVisible,isDateStr:isDateStr,isEmpty:isEmpty,isNull:isNull,isOutside:isOutside,isProxy:isProxy,isScrollUp:isScrollUp,isSubset:isSubset,keyCond:keyCond,moveItem:moveItem,notice:notice,offset:offset,paramToJson:paramToJson,parseRgb:parseRgb,parseStr:parseStr,parseUrlArr:parseUrlArr,plan:m,preventDft:preventDft,privacy:privacy,promiseRaf:promiseRaf,prompt:prompt,propsMap:o,purifyHtml:purifyHtml,regComp:regComp,regExps:A,removeItem:removeItem,removeStyle:removeStyle,removeStyles:removeStyles,renderTpl:renderTpl,repeatStr:repeatStr,replaceFrag:replaceFrag,requireTypes:requireTypes,rgb2Hex:rgb2Hex,rgb2Hsl:rgb2Hsl,rgb2Hwb:rgb2Hwb,scrollTo:scrollTo,select2Tree:select2Tree,setAttr:setAttr,setAttrs:setAttrs,setContent:setContent,setRtl:setRtl,setSingleSel:setSingleSel,show:show,sliceFrags:sliceFrags,sliceStrEnd:sliceStrEnd,slideDown:slideDown,slideToggle:slideToggle,slideUp:slideUp,splice:splice,splitNum:splitNum,spreadBool:spreadBool,startUpper:startUpper,stdParam:stdParam,storage:u,storeNode:storeNode,strToJson:strToJson,style:style,support:support,theme:k,throttle:throttle,toLocalTime:toLocalTime,toNumber:toNumber,toPixel:toPixel,toggle:toggle,tplToEl:tplToEl,tplToEls:tplToEls,transformTools:C,treeTools:S,trim:trim,ul2Tree:ul2Tree,unique:unique,valToArr:valToArr,validTools:w})};for(let t in $t){let e=$t[t];"function"==typeof e&&e?.name?.endsWith("Elem")&&$t.regComp(e)}return document.addEventListener("DOMContentLoaded",(()=>{for(let t of s.tasks)t();s.tasks=[]})),s.config.support&&$t.support(!0),s.config.privacy&&$t.privacy({}),Reflect.deleteProperty($t,"ax"),Object.assign(s,$t),s}));