/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.MaxNumberOfRetriesException;
import com.crowdin.cli.client.RepeatException;
import com.crowdin.cli.client.ResponseException;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

abstract class CrowdinClientCore {
    protected static final Map<BiPredicate<String, String>, Function<String, RuntimeException>> standardErrorHandlers = new LinkedHashMap<BiPredicate<String, String>, Function<String, RuntimeException>>(){
        {
            this.put((code, message) -> code.equals("401"), msg -> new ExitCodeExceptionMapper.AuthorizationException(BaseCli.RESOURCE_BUNDLE.getString("error.response.401")));
            this.put((code, message) -> code.equals("403") && message.contains("upgrade your subscription plan to upload more file formats"), msg -> new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("error.response.403_upgrade_subscription")));
            this.put((code, message) -> code.equals("404") && StringUtils.containsIgnoreCase(message, "Project Not Found"), msg -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.response.404_project_not_found")));
            this.put((code, message) -> code.equals("404") && StringUtils.containsIgnoreCase(message, "Organization Not Found"), msg -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.response.404_organization_not_found")));
            this.put((code, message) -> code.equals("404") && StringUtils.containsIgnoreCase(message, "Bundle Not Found"), msg -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.bundle.not_found_by_id")));
            this.put((code, message) -> code.equals("404") && StringUtils.containsIgnoreCase(message, "Screenshot Not Found"), msg -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.screenshot.not_found_by_id")));
            this.put((code, message) -> code.equals("429"), msg -> new ExitCodeExceptionMapper.RateLimitException(BaseCli.RESOURCE_BUNDLE.getString("error.response.429")));
            this.put((code, message) -> StringUtils.containsAny((CharSequence)message, "PKIX path building failed", "sun.security.provider.certpath.SunCertPathBuilderException", "unable to find valid certification path to requested target"), msg -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.response.certificate")));
            this.put((code, message) -> message.equals("Name or service not known"), msg -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.response.url_not_known")));
            this.put((code, message) -> code.equals("<empty_code>") && message.equals("<empty_message>"), msg -> new RuntimeException("Empty error message from server"));
            this.put((code, message) -> code.equals("404"), ExitCodeExceptionMapper.NotFoundException::new);
            this.put((code, message) -> code.equals("403"), msg -> new ExitCodeExceptionMapper.ForbiddenException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.response.403"), msg)));
        }
    };

    CrowdinClientCore() {
    }

    protected static <T> List<T> executeRequestFullList(BiFunction<Integer, Integer, ResponseList<T>> request) {
        List<T> dirs;
        long counter;
        ArrayList directories = new ArrayList();
        int limit = 500;
        do {
            dirs = CrowdinClientCore.unwrap(CrowdinClientCore.executeRequest(() -> (ResponseList)request.apply(limit, directories.size())));
            directories.addAll(dirs);
        } while ((counter = (long)dirs.size()) == (long)limit);
        return directories;
    }

    protected static <T> T executeRequestWithPossibleRetries(Map<BiPredicate<String, String>, ResponseException> errorHandlers, Supplier<T> request, int maxAttempts, long millisToRetry) throws ResponseException {
        if (maxAttempts < 1) {
            throw new MaxNumberOfRetriesException();
        }
        try {
            return CrowdinClientCore.executeRequest(errorHandlers, request);
        }
        catch (RepeatException e) {
            try {
                Thread.sleep(millisToRetry);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println(String.format("%nAttempting to retry the request due to the error: %s", e.getMessage()));
            return CrowdinClientCore.executeRequestWithPossibleRetries(errorHandlers, request, maxAttempts - 1, millisToRetry);
        }
    }

    protected static <T> T executeRequest(Supplier<T> r) {
        return CrowdinClientCore.executeRequest(new HashMap(), r);
    }

    protected static void executeRequest(Runnable r) {
        CrowdinClientCore.executeRequest(() -> {
            r.run();
            return null;
        });
    }

    protected static <T, R extends Exception> T executeRequest(Map<BiPredicate<String, String>, R> errorHandlers, Supplier<T> r) throws R {
        try {
            return r.get();
        }
        catch (HttpBadRequestException e) {
            for (HttpBadRequestException.ErrorHolder eh : e.getErrors()) {
                for (HttpBadRequestException.Error error : eh.getError().errors) {
                    String code = error.code != null ? error.code : "<empty_code>";
                    String message = error.message != null ? error.message : "<empty_message>";
                    CrowdinClientCore.searchErrorHandler(errorHandlers, code, message);
                }
            }
            String errorMessage = "Wrong parameters: \n" + e.getErrors().stream().flatMap(holder -> holder.getError().getErrors().stream().map(error -> String.format("<key: %s, code: %s, message: %s>", holder.getError().getKey(), error.getCode(), error.getMessage()))).collect(Collectors.joining("\n"));
            throw new RuntimeException(errorMessage);
        }
        catch (HttpException e) {
            String code = e.getError() != null && e.getError().code != null ? e.getError().code : "<empty_code>";
            String message = e.getError() != null && e.getError().message != null ? e.getError().message : "<empty_message>";
            CrowdinClientCore.searchErrorHandler(errorHandlers, code, message);
            Object errorMessage = String.format("Error from server: <Code: %s, Message: %s>", code, message);
            if (e.getHttpResponse() != null) {
                errorMessage = (String)errorMessage + ", Response: " + e.getHttpResponse();
            }
            throw new RuntimeException((String)errorMessage);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static <R extends Exception> void searchErrorHandler(Map<BiPredicate<String, String>, R> errorHandlers, String code, String message) throws R {
        for (Map.Entry<BiPredicate<String, String>, R> entry : errorHandlers.entrySet()) {
            if (!entry.getKey().test(code, message)) continue;
            throw (Exception)entry.getValue();
        }
        for (Map.Entry<BiPredicate<String, String>, Object> entry : standardErrorHandlers.entrySet()) {
            if (!entry.getKey().test(code, message)) continue;
            throw (RuntimeException)((Function)entry.getValue()).apply(message);
        }
    }

    private static <T> List<T> unwrap(ResponseList<T> list) {
        return list.getData().stream().map(ResponseObject::getData).collect(Collectors.toList());
    }

    protected URL url(DownloadLink downloadLink) {
        try {
            return new URL(downloadLink.getUrl());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: malformed download url: " + downloadLink.getUrl(), e);
        }
    }
}

