/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.client.ClientTm;
import com.crowdin.cli.client.CrowdinClientCore;
import com.crowdin.client.Client;
import com.crowdin.client.storage.model.Storage;
import com.crowdin.client.translationmemory.model.AddTranslationMemoryRequest;
import com.crowdin.client.translationmemory.model.TranslationMemory;
import com.crowdin.client.translationmemory.model.TranslationMemoryExportRequest;
import com.crowdin.client.translationmemory.model.TranslationMemoryExportStatus;
import com.crowdin.client.translationmemory.model.TranslationMemoryImportRequest;
import com.crowdin.client.translationmemory.model.TranslationMemoryImportStatus;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class CrowdinClientTm
extends CrowdinClientCore
implements ClientTm {
    private final Client client;

    public CrowdinClientTm(Client client) {
        this.client = client;
    }

    @Override
    public List<TranslationMemory> listTms() {
        return CrowdinClientTm.executeRequestFullList((limit, offset) -> this.client.getTranslationMemoryApi().listTms(null, (Integer)limit, (Integer)offset, null));
    }

    @Override
    public TranslationMemory getTm(Long tmId) {
        return CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().getTm(tmId).getData());
    }

    @Override
    public TranslationMemory addTm(AddTranslationMemoryRequest request) {
        return CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().addTm(request).getData());
    }

    @Override
    public TranslationMemoryImportStatus importTm(Long tmId, TranslationMemoryImportRequest request) {
        return CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().importTm(tmId, request).getData());
    }

    @Override
    public TranslationMemoryExportStatus startExportingTm(Long tmId, TranslationMemoryExportRequest request) {
        return CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().exportTm(tmId, request).getData());
    }

    @Override
    public TranslationMemoryExportStatus checkExportingTm(Long tmId, String exportId) {
        return CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().checkTmExportStatus(tmId, exportId).getData());
    }

    @Override
    public URL downloadTm(Long tmId, String exportId) {
        return this.url(CrowdinClientTm.executeRequest(() -> this.client.getTranslationMemoryApi().downloadTm(tmId, exportId).getData()));
    }

    @Override
    public Long uploadStorage(String fileName, InputStream content) {
        Storage storage = CrowdinClientTm.executeRequest(() -> this.client.getStorageApi().addStorage(fileName, content).getData());
        return storage.getId();
    }
}

