/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.client;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProject;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.Directory;
import com.crowdin.client.sourcefiles.model.File;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CrowdinProjectFull
extends CrowdinProject {
    private List<? extends FileInfo> files;
    private List<Directory> directories;
    private List<Branch> branches;
    private Branch branch;

    void setFiles(List<? extends FileInfo> files) {
        this.files = files;
    }

    void setDirectories(List<Directory> directories) {
        this.directories = directories;
    }

    void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public Map<Long, Branch> getBranches() {
        return this.branches.stream().collect(Collectors.toMap(Branch::getId, Function.identity()));
    }

    public Branch getBranch() {
        return this.branch;
    }

    public void setBranch(Branch branch) {
        this.branch = branch;
    }

    public void addBranchToLocalList(Branch branch) {
        this.branches.add(branch);
    }

    public Optional<Branch> findBranchByName(String branchName) {
        return BranchUtils.getBranch(branchName, this.branches);
    }

    public Map<Long, Directory> getDirectories() {
        return this.directories.stream().collect(Collectors.toMap(Directory::getId, Function.identity()));
    }

    public Map<Long, Directory> getDirectories(Long branchId) {
        return this.directories.stream().filter(dir -> Objects.equals(dir.getBranchId(), branchId)).collect(Collectors.toMap(Directory::getId, Function.identity()));
    }

    public List<File> getFiles() {
        if (this.files.isEmpty()) {
            return new ArrayList<File>();
        }
        FileInfo first = this.files.get(0);
        if (first instanceof File) {
            return this.files;
        }
        throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
    }

    public List<File> getFiles(Long branchId) {
        ArrayList<File> result = new ArrayList<File>();
        for (File file : this.getFiles()) {
            if (!Objects.equals(file.getBranchId(), branchId)) continue;
            result.add(file);
        }
        return result;
    }

    public List<FileInfo> getFileInfos() {
        return this.files;
    }

    public List<FileInfo> getFileInfos(Long branchId) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        for (FileInfo file : this.getFileInfos()) {
            if (!Objects.equals(file.getBranchId(), branchId)) continue;
            result.add(file);
        }
        return result;
    }
}

