/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import java.util.Optional;

class AppInstallAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String id;

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        Optional<String> manifestUrl = client.findManifestUrl(this.id);
        if (manifestUrl.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.application_not_found"), this.id));
        }
        client.installApplication(manifestUrl.get());
        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.application.install"), this.id)));
    }

    public AppInstallAction(String id) {
        this.id = id;
    }
}

