/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.branches.model.BranchMergeStatus;
import com.crowdin.client.branches.model.BranchMergeSummary;
import com.crowdin.client.branches.model.MergeBranchRequest;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class BranchMergeAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String source;
    private final String target;
    private final boolean noProgress;
    private final boolean plainView;
    private final boolean dryrun;
    private final boolean deleteAfterMerge;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadFullProject);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (!isStringsBasedProject) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.string_based_only"));
        }
        String normalizedSource = BranchUtils.normalizeBranchName(this.source);
        Optional<Branch> sourceBranch = project.findBranchByName(normalizedSource);
        if (sourceBranch.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.branch_not_exists"), this.source));
        }
        String normalizedTarget = BranchUtils.normalizeBranchName(this.target);
        Optional<Branch> targetBranch = project.findBranchByName(normalizedTarget);
        if (targetBranch.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.branch_not_exists"), this.target));
        }
        MergeBranchRequest request = new MergeBranchRequest();
        request.setSourceBranchId(sourceBranch.get().getId());
        request.setDeleteAfterMerge(this.deleteAfterMerge);
        request.setDryRun(this.dryrun);
        BranchMergeSummary summary = this.mergeBranch(out, client, targetBranch.get().getId(), request);
        String summaryStr = summary.getDetails().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch.merge"), this.source, this.target)));
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch.merge_details"), summaryStr));
        } else {
            out.println(String.valueOf(summary.getTargetBranchId()));
        }
    }

    private BranchMergeSummary mergeBranch(Outputter out, ProjectClient client, Long branchId, MergeBranchRequest request) {
        return ConsoleSpinner.execute(out, "message.spinner.merging_branch", "error.branch.merge", this.noProgress, false, () -> {
            BranchMergeStatus status = client.mergeBranch(branchId, request);
            while (!status.getStatus().equalsIgnoreCase("finished")) {
                ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.merging_branch_percents"), status.getProgress()));
                Thread.sleep(1000L);
                if (!(status = client.checkMergeBranchStatus(branchId, status.getIdentifier())).getStatus().equalsIgnoreCase("failed")) continue;
                throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.branch.merge"));
            }
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.merging_branch_percents"), 100));
            return client.getBranchMergeSummary(branchId, status.getIdentifier());
        });
    }

    public BranchMergeAction(String source, String target, boolean noProgress, boolean plainView, boolean dryrun, boolean deleteAfterMerge) {
        this.source = source;
        this.target = target;
        this.noProgress = noProgress;
        this.plainView = plainView;
        this.dryrun = dryrun;
        this.deleteAfterMerge = deleteAfterMerge;
    }
}

