/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.bundles.model.AddBundleRequest;
import com.crowdin.client.bundles.model.Bundle;
import java.util.List;
import java.util.Optional;

class BundleAddAction
implements NewAction<ProjectProperties, ClientBundle> {
    private String name;
    private String format;
    private List<String> source;
    private List<String> ignore;
    private String translation;
    private List<Long> labels;
    private boolean plainView;
    private boolean includeProjectSourceLanguage;
    private boolean includePseudoLanguage;
    private boolean isMultilingual;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientBundle client) {
        Bundle bundle;
        AddBundleRequest addBundleRequest = new AddBundleRequest();
        Optional.ofNullable(this.name).ifPresent(addBundleRequest::setName);
        Optional.ofNullable(this.format).ifPresent(addBundleRequest::setFormat);
        Optional.ofNullable(this.source).ifPresent(addBundleRequest::setSourcePatterns);
        Optional.ofNullable(this.ignore).ifPresent(addBundleRequest::setIgnorePatterns);
        Optional.ofNullable(this.translation).ifPresent(addBundleRequest::setExportPattern);
        addBundleRequest.setIncludeProjectSourceLanguage(this.includeProjectSourceLanguage);
        addBundleRequest.setIncludeInContextPseudoLanguage(this.includePseudoLanguage);
        addBundleRequest.setIsMultilingual(this.isMultilingual);
        Optional.ofNullable(this.labels).ifPresent(addBundleRequest::setLabelIds);
        try {
            bundle = client.addBundle(addBundleRequest);
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.bundle_is_not_added"), addBundleRequest));
        }
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.list"), bundle.getId(), bundle.getFormat(), bundle.getExportPattern(), bundle.getName())));
        } else {
            out.println(String.valueOf(bundle.getId()));
        }
    }

    public BundleAddAction(String name, String format, List<String> source, List<String> ignore, String translation, List<Long> labels, boolean plainView, boolean includeProjectSourceLanguage, boolean includePseudoLanguage, boolean isMultilingual) {
        this.name = name;
        this.format = format;
        this.source = source;
        this.ignore = ignore;
        this.translation = translation;
        this.labels = labels;
        this.plainView = plainView;
        this.includeProjectSourceLanguage = includeProjectSourceLanguage;
        this.includePseudoLanguage = includePseudoLanguage;
        this.isMultilingual = isMultilingual;
    }
}

