/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.bundles.model.Bundle;
import java.util.Objects;

class BundleDeleteAction
implements NewAction<ProjectProperties, ClientBundle> {
    private final Long id;

    public BundleDeleteAction(Long id) {
        this.id = id;
    }

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientBundle client) {
        Bundle bundleToDelete = client.getBundle(this.id);
        if (Objects.isNull(bundleToDelete)) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.not_found")));
            return;
        }
        client.deleteBundle(this.id);
        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.bundle_deleted"), this.id)));
    }
}

