/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientBundle;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.bundles.model.Bundle;
import java.util.List;

class BundleListAction
implements NewAction<ProjectProperties, ClientBundle> {
    private final boolean plainView;

    public BundleListAction(boolean plainView) {
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientBundle client) {
        List<Bundle> bundles = client.listBundle();
        for (Bundle bundle : bundles) {
            if (!this.plainView) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.list"), bundle.getId(), bundle.getFormat(), bundle.getExportPattern(), bundle.getName()));
                continue;
            }
            out.println(String.format("%d %s", bundle.getId(), bundle.getName()));
        }
        if (bundles.isEmpty()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.list_empty")));
            } else {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.bundle.list_empty"));
            }
        }
    }
}

