/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.NoClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.NoProperties;
import com.crowdin.cli.utils.Utils;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

class CheckNewVersionAction
implements NewAction<NoProperties, NoClient> {
    CheckNewVersionAction() {
    }

    @Override
    public void act(Outputter out, NoProperties pb, NoClient client) {
        CheckNewVersionAction.getNewVersionMessage().ifPresent(out::println);
    }

    private static Optional<String> getAppNewLatestVersion() {
        try {
            List<String> versionFile = IOUtils.readLines(new URL(Utils.getLatestVersionUrl()).openStream(), "UTF-8");
            return versionFile.size() > 0 && !Utils.getAppVersion().equals(versionFile.get(0)) ? Optional.of(versionFile.get(0)) : Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private static Optional<String> getNewVersionMessage() {
        String message2 = BaseCli.RESOURCE_BUNDLE.getString("message.new_version_text.2");
        String message3 = BaseCli.RESOURCE_BUNDLE.getString("message.new_version_text.3");
        String c1 = Utils.isWindows() != false ? "\u250c" : "\u256d";
        String c2 = Utils.isWindows() != false ? "\u2510" : "\u256e";
        String c3 = Utils.isWindows() != false ? "\u2514" : "\u2570";
        String c4 = Utils.isWindows() != false ? "\u2518" : "\u256f";
        return CheckNewVersionAction.getAppNewLatestVersion().map(newVersion -> String.format(BaseCli.RESOURCE_BUNDLE.getString("message.new_version_text"), Utils.getAppVersion(), newVersion)).map(newVersionText -> "\n@|yellow " + c1 + "\u2500\u2500" + StringUtils.repeat("\u2500", message2.length()) + "\u2500\u2500" + c2 + "|@\n@|yellow \u2502|@  " + StringUtils.center(newVersionText, message2.length()) + "  @|yellow \u2502|@\n@|yellow \u251c\u2500\u2500" + StringUtils.repeat("\u2500", message2.length()) + "\u2500\u2500\u2524|@\n@|yellow \u2502|@  " + StringUtils.center(message2, message2.length() + "@|cyan |@".length()) + "  @|yellow \u2502|@\n@|yellow \u2502|@  " + StringUtils.center(message3, message2.length()) + "  @|yellow \u2502|@\n@|yellow " + c3 + "\u2500\u2500" + StringUtils.repeat("\u2500", message2.length()) + "\u2500\u2500" + c4 + "|@");
    }
}

