/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.stringcomments.model.AddStringCommentRequest;
import com.crowdin.client.stringcomments.model.StringComment;

class CommentAddAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final boolean plainView;
    private final String text;
    private final String stringId;
    private final String language;
    private final String type;
    private final String issueType;

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        AddStringCommentRequest request = RequestBuilder.addComment(this.text, this.type, this.language, this.issueType, this.stringId);
        try {
            StringComment stringComment = client.commentString(request);
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.comment.list"), stringComment.getId(), stringComment.getText())));
            } else {
                out.println(stringComment.getId().toString());
            }
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.comment_is_not_added"), new Object[0]));
        }
    }

    public CommentAddAction(boolean plainView, String text, String stringId, String language, String type, String issueType) {
        this.plainView = plainView;
        this.text = text;
        this.stringId = stringId;
        this.language = language;
        this.type = type;
        this.issueType = issueType;
    }
}

