/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientComment;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.stringcomments.model.IssueStatus;
import com.crowdin.client.stringcomments.model.StringComment;
import com.crowdin.client.stringcomments.model.Type;
import java.util.List;
import java.util.Objects;

class CommentListAction
implements NewAction<ProjectProperties, ClientComment> {
    private final boolean plainView;
    private final boolean isVerbose;
    private final String stringId;
    private Type type;
    private final com.crowdin.client.issues.model.Type issueType;
    private final IssueStatus status;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientComment client) {
        if (this.status != null && this.type == null) {
            this.type = Type.ISSUE;
        }
        List<StringComment> comments = client.listComment(this.stringId, this.type, this.issueType, this.status);
        for (StringComment comment : comments) {
            if (this.plainView) {
                out.println(comment.getId().toString());
                continue;
            }
            String commentText = comment.getText().replaceAll(System.lineSeparator(), " ");
            if (this.isVerbose) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.comment.list.verbose"), comment.getId(), commentText, comment.getLanguageId(), Objects.toString(comment.getIssueType(), ""), Objects.toString(comment.getIssueStatus(), "").toLowerCase()));
                continue;
            }
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.comment.list"), comment.getId(), commentText));
        }
        if (comments.isEmpty()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.comment.list_empty")));
            } else {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.comment.list_empty"));
            }
        }
    }

    public CommentListAction(boolean plainView, boolean isVerbose, String stringId, Type type, com.crowdin.client.issues.model.Type issueType, IssueStatus status) {
        this.plainView = plainView;
        this.isVerbose = isVerbose;
        this.stringId = stringId;
        this.type = type;
        this.issueType = issueType;
        this.status = status;
    }
}

