/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.FilesInterface;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.functionality.TranslationsUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.concurrency.ConcurrencyUtil;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.BuildReviewedSourceFilesRequest;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.ReviewedStringsBuild;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadSourcesAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private FilesInterface files;
    private boolean noProgress;
    private boolean plainView;
    private String branchName;
    private boolean debug;
    private boolean reviewedOnly;
    private boolean dryrun;
    private Outputter out;

    public DownloadSourcesAction(FilesInterface files, boolean noProgress, boolean plainView, String branchName, boolean debug, boolean reviewedOnly, boolean dryrun) {
        this.files = files;
        this.noProgress = noProgress;
        this.plainView = plainView;
        this.branchName = branchName;
        this.debug = debug;
        this.reviewedOnly = reviewedOnly;
        this.dryrun = dryrun;
    }

    @Override
    public void act(Outputter out, PropertiesWithFiles properties, ProjectClient client) {
        CrowdinProjectFull project;
        this.out = out;
        boolean isOrganization = PropertiesBeanUtils.isOrganization(properties.getBaseUrl());
        if (!isOrganization && this.reviewedOnly) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.only_enterprise")));
            return;
        }
        if (!this.plainView && !properties.getPreserveHierarchy().booleanValue()) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.download_sources.preserve_hierarchy_warning")));
        }
        if (Objects.equals((project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName))).getType(), Type.STRINGS_BASED)) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
        }
        Long branchId = Optional.ofNullable(project.getBranch()).map(Branch::getId).orElse(null);
        String reviewedFilesTempDir = StringUtils.removeEnd(properties.getBasePath(), Utils.PATH_SEPARATOR) + Utils.PATH_SEPARATOR + "CrowdinReviewedSources_" + RandomStringUtils.random(11, false, true);
        Map reviewedFiles = this.reviewedOnly ? this.getReviewedSourceFiles(reviewedFilesTempDir, client, project) : Collections.emptyMap();
        List fileInfos = project.getFileInfos().stream().filter(f -> Objects.equals(f.getBranchId(), branchId)).collect(Collectors.toList());
        Map filePaths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), fileInfos);
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(true), properties.getBasePath());
        AtomicBoolean isAnyFileDownloaded = new AtomicBoolean(false);
        List<Runnable> tasks = properties.getFiles().stream().flatMap(fileBean -> {
            List<String> foundSources;
            ArrayList<String> filePaths2;
            String searchPattern;
            String string = searchPattern = fileBean.getDest() != null ? fileBean.getDest() : fileBean.getSource();
            if (project.isManagerAccess()) {
                filePaths2 = new ArrayList();
                if (properties.getPreserveHierarchy().booleanValue()) {
                    for (String filePathKey : filePaths.keySet()) {
                        String sourceName;
                        String exportPattern = Utils.normalizePath(ProjectFilesUtils.getExportPattern(((com.crowdin.client.sourcefiles.model.File)filePaths.get(filePathKey)).getExportOptions()));
                        String translationPattern = TranslationsUtils.replaceDoubleAsterisk(fileBean.getSource(), fileBean.getTranslation(), filePathKey);
                        if (exportPattern != null && !translationPattern.endsWith(exportPattern) || !(sourceName = new File(fileBean.getSource()).getName()).equals(new File(filePathKey).getName()) && !SourcesUtils.containsPattern(sourceName) && !searchPattern.contains(filePathKey)) continue;
                        filePaths2.add(filePathKey);
                    }
                } else {
                    String translationPrepared = fileBean.getTranslation().replaceAll(Utils.PATH_SEPARATOR_REGEX + "\\*\\*", "(" + Utils.PATH_SEPARATOR_REGEX + ".+)?").replaceAll("\\\\", "\\\\\\\\");
                    Predicate<String> translationPred = Pattern.compile(translationPrepared).asPredicate();
                    for (String filePathKey : filePaths.keySet()) {
                        String exportPattern = ProjectFilesUtils.getExportPattern(((com.crowdin.client.sourcefiles.model.File)filePaths.get(filePathKey)).getExportOptions());
                        if (exportPattern != null && !translationPred.test(exportPattern)) continue;
                        filePaths2.add(filePathKey);
                    }
                }
            } else {
                filePaths2 = new ArrayList(filePaths.keySet());
            }
            if ((foundSources = SourcesUtils.filterProjectFiles(filePaths2, searchPattern, fileBean.getIgnore(), properties.getPreserveHierarchy(), placeholderUtil)).isEmpty()) {
                return Stream.of(() -> {
                    if (!this.plainView) {
                        out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.no_sources"), searchPattern)));
                    }
                });
            }
            return foundSources.stream().sorted().map(filePath -> () -> {
                String fileDestination;
                if (fileBean.getDest() != null) {
                    fileDestination = SourcesUtils.replaceUnaryAsterisk(fileBean.getSource(), filePath);
                    fileDestination = placeholderUtil.replaceFileDependentPlaceholders(fileDestination, new File((String)filePath));
                } else {
                    fileDestination = filePath;
                }
                boolean downloaded = false;
                if (!this.reviewedOnly && !this.dryrun) {
                    Long fileId = ((FileInfo)filePaths.get(filePath)).getId();
                    this.downloadFile(client, fileId, Utils.joinPaths(properties.getBasePath(), fileDestination));
                    isAnyFileDownloaded.set(true);
                    downloaded = true;
                } else {
                    FileInfo fileInfo = (FileInfo)filePaths.get(filePath);
                    if (Objects.equals(fileInfo.getBranchId(), branchId) && reviewedFiles.containsKey(fileInfo.getPath()) && !this.dryrun) {
                        File file = (File)reviewedFiles.get(fileInfo.getPath());
                        String fileTargetPath = Utils.joinPaths(properties.getBasePath(), fileDestination);
                        this.extractFile(file, fileTargetPath);
                        isAnyFileDownloaded.set(true);
                        downloaded = true;
                    }
                }
                if (downloaded || this.dryrun) {
                    if (!this.plainView) {
                        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file_path"), filePath)));
                    } else {
                        out.println((String)filePath);
                    }
                }
            });
        }).collect(Collectors.toList());
        ConcurrencyUtil.executeAndWait(tasks, this.debug);
        if (this.reviewedOnly) {
            this.deleteTempReviewedSources(reviewedFilesTempDir);
        }
    }

    private Map<String, File> getReviewedSourceFiles(String baseTemp, ProjectClient client, CrowdinProjectFull project) {
        BuildReviewedSourceFilesRequest request = new BuildReviewedSourceFilesRequest();
        ReviewedStringsBuild build = this.buildReviewedSources(client, request);
        File baseTempDir = new File(baseTemp + Utils.PATH_SEPARATOR);
        String downloadedZipArchivePath = baseTemp + ".zip";
        File downloadedZipArchive = new File(downloadedZipArchivePath);
        this.downloadReviewedSources(client, build.getId(), downloadedZipArchivePath);
        List<File> downloadedFiles = this.extractArchive(downloadedZipArchive, baseTempDir);
        return downloadedFiles.stream().collect(Collectors.toMap(file -> {
            String path = StringUtils.removeStart(file.getAbsolutePath(), baseTempDir.getAbsolutePath() + Utils.PATH_SEPARATOR + project.getSourceLanguageId() + "-REV");
            return Utils.toUnixPath(path);
        }, Function.identity()));
    }

    private void downloadFile(ProjectClient client, Long fileId, String filePath) {
        URL url = client.downloadFile(fileId);
        try (InputStream data = url.openStream();){
            this.files.writeToFile(filePath, data);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), filePath), e);
        }
    }

    private void extractFile(File file, String fileTargetPath) {
        try (FileInputStream data = new FileInputStream(file);){
            this.files.writeToFile(fileTargetPath, data);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), fileTargetPath), e);
        }
    }

    private ReviewedStringsBuild buildReviewedSources(ProjectClient client, BuildReviewedSourceFilesRequest request) {
        return ConsoleSpinner.execute(this.out, "message.spinner.building_reviewed_sources", "error.spinner.reviewed_sources", this.noProgress, this.plainView, () -> {
            ReviewedStringsBuild build = client.startBuildingReviewedSources(request);
            while (!build.getStatus().equalsIgnoreCase("finished")) {
                ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.building_reviewed_sources"), Math.toIntExact(build.getProgress())));
                Thread.sleep(1000L);
                if (!(build = client.checkBuildingReviewedSources(build.getId())).getStatus().equalsIgnoreCase("failed")) continue;
                throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.build_has_failed"));
            }
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.building_reviewed_sources"), 100));
            return build;
        });
    }

    private void deleteTempReviewedSources(String baseTemp) {
        try {
            List files = Files.walk(new File(baseTemp + Utils.PATH_SEPARATOR).toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            for (Path file : files) {
                this.files.deleteFile(file.toFile());
            }
            this.files.deleteFile(new File(baseTemp + ".zip"));
        }
        catch (IOException e) {
            this.out.println(ExecutionStatus.ERROR.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.deleting_archive"), baseTemp)));
        }
    }

    private void downloadReviewedSources(ProjectClient client, Long buildId, String archivePath) {
        ConsoleSpinner.execute(this.out, "message.spinner.downloading_reviewed_sources", "error.downloading_file", this.noProgress, this.plainView, () -> {
            URL url = client.downloadReviewedSourcesBuild(buildId);
            try (InputStream data = url.openStream();){
                this.files.writeToFile(archivePath, data);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), archivePath), e);
            }
            return url;
        });
    }

    private List<File> extractArchive(File zipArchive, File dir) {
        return ConsoleSpinner.execute(this.out, "message.spinner.extracting_archive", "error.extracting_files", this.noProgress, this.plainView, () -> this.files.extractZipArchive(zipArchive, dir));
    }
}

