/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.FsFiles;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

class FileDownloadAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String file;
    private final String branch;
    private final boolean noProgress;
    private final String dest;

    public FileDownloadAction(String file, String branch, String dest) {
        this.file = file;
        this.branch = branch;
        this.noProgress = false;
        this.dest = dest;
    }

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, false, () -> client.downloadFullProject(this.branch));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (isStringsBasedProject) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project")));
            return;
        }
        if (!project.isManagerAccess()) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
            return;
        }
        String branchPrefix = Objects.nonNull(this.branch) ? this.branch + Utils.PATH_SEPARATOR : "";
        String filePath = Utils.toUnixPath(Utils.sepAtStart(branchPrefix + this.file));
        FileInfo foundFile = project.getFileInfos().stream().filter(f -> Objects.equals(filePath, f.getPath())).findFirst().orElseThrow(() -> new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_found"), filePath)));
        ConsoleSpinner.execute(out, "message.spinner.downloading_file", "error.downloading_file", this.noProgress, false, () -> {
            URL url = client.downloadFile(foundFile.getId());
            String destPath = Objects.nonNull(this.dest) ? Utils.sepAtEnd(this.dest) + foundFile.getName() : this.file;
            this.saveToFile(Utils.normalizePath(Utils.joinPaths(properties.getBasePath(), destPath)), url);
            return url;
        });
        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.downloaded_file"), filePath)));
    }

    private void saveToFile(String destPath, URL url) {
        FsFiles files = new FsFiles();
        try (InputStream data = url.openStream();){
            files.writeToFile(destPath, data);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), destPath), e);
        }
    }

    public FileDownloadAction(String file, String branch, boolean noProgress, String dest) {
        this.file = file;
        this.branch = branch;
        this.noProgress = noProgress;
        this.dest = dest;
    }
}

