/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.FsFiles;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.translations.model.BuildProjectFileTranslationRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FileDownloadTranslationAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String file;
    private final String languageId;
    private final String branch;
    private final boolean noProgress;
    private final String dest;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        List<Language> languagesToDownload;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, false, client::downloadFullProject);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (isStringsBasedProject) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project")));
            return;
        }
        if (!project.isManagerAccess()) {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
            return;
        }
        if (Objects.equals(this.languageId, "all")) {
            languagesToDownload = project.getProjectLanguages(false);
        } else {
            Language languageToDownload = project.findLanguageById(this.languageId, true).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), this.languageId)));
            languagesToDownload = Collections.singletonList(languageToDownload);
        }
        String branchPrefix = Objects.nonNull(this.branch) ? this.branch + Utils.PATH_SEPARATOR : "";
        String sourcePath = Utils.toUnixPath(Utils.sepAtStart(branchPrefix + this.file));
        FileInfo sourceFileInfo = project.getFileInfos().stream().filter(fi -> Objects.equals(sourcePath, fi.getPath())).findFirst().orElseThrow(() -> new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_found"), sourcePath)));
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(true), properties.getBasePath());
        for (Language lang : languagesToDownload) {
            BuildProjectFileTranslationRequest request = new BuildProjectFileTranslationRequest();
            request.setTargetLanguageId(lang.getId());
            URL url = ConsoleSpinner.execute(out, "message.spinner.building_translation", "error.building_translation", this.noProgress, false, () -> client.buildProjectFileTranslation(sourceFileInfo.getId(), request));
            String destPath = Objects.nonNull(this.dest) ? placeholderUtil.replaceLanguageDependentPlaceholders(this.dest + Utils.PATH_SEPARATOR + sourceFileInfo.getName(), lang) : lang.getId() + sourcePath;
            this.saveToFile(Utils.normalizePath(Utils.joinPaths(properties.getBasePath(), destPath)), url, out);
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.downloaded_file"), destPath)));
        }
    }

    private void saveToFile(String destPath, URL url, Outputter out) {
        ConsoleSpinner.execute(out, "message.spinner.downloading_translation", "error.write_file", this.noProgress, false, () -> {
            FsFiles files = new FsFiles();
            try (InputStream data = url.openStream();){
                files.writeToFile(destPath, data);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.write_file"), destPath), e);
            }
            return url;
        });
    }

    public FileDownloadTranslationAction(String file, String languageId, String branch, boolean noProgress, String dest) {
        this.file = file;
        this.languageId = languageId;
        this.branch = branch;
        this.noProgress = noProgress;
        this.dest = dest;
    }
}

