/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.EmptyFileException;
import com.crowdin.cli.client.ExistsResponseException;
import com.crowdin.cli.client.FileInUpdateException;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.ProjectUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.labels.model.AddLabelRequest;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.AddFileRequest;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.UpdateFileRequest;
import com.crowdin.client.sourcestrings.model.UploadStringsProgress;
import com.crowdin.client.sourcestrings.model.UploadStringsRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class FileUploadAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final File file;
    private final String branchName;
    private final boolean autoUpdate;
    private final List<String> labels;
    private final String dest;
    private final String context;
    private final String type;
    private final Integer parserVersion;
    private final boolean cleanupMode;
    private final boolean updateStrings;
    private final List<String> excludedLanguages;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        Object request;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.plainView, this.plainView, client::downloadFullProject);
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (isStringsBasedProject && Objects.nonNull(this.context)) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.file.context_file_based_only"));
        }
        if (!project.isManagerAccess()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
        }
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(false), properties.getBasePath());
        Optional<Object> attachLabelIds = Optional.empty();
        if (Objects.nonNull(this.labels) && !this.labels.isEmpty()) {
            attachLabelIds = Optional.of(this.labels.stream().map(l -> this.getOrCreateLabel((String)l, client)).collect(Collectors.toList()));
        }
        Object fileFullPath = this.file.getPath();
        String fileDestName = this.file.getName();
        if (!isStringsBasedProject) {
            String commonPath = SourcesUtils.getCommonPath(Collections.singletonList(this.file.getAbsolutePath()), properties.getBasePath());
            String filePath = Objects.nonNull(this.dest) ? PropertiesBeanUtils.prepareDest(this.dest, StringUtils.removeStart(this.file.getAbsolutePath(), properties.getBasePath()), placeholderUtil) : StringUtils.removeStart(this.file.getAbsolutePath(), properties.getBasePath() + commonPath);
            fileFullPath = (String)(Objects.nonNull(this.branchName) ? this.branchName + Utils.PATH_SEPARATOR : "") + filePath;
            fileDestName = ((String)fileFullPath).substring(((String)fileFullPath).lastIndexOf(Utils.PATH_SEPARATOR) + 1);
            Map<String, FileInfo> paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFileInfos());
            Map.Entry<FileInfo, Boolean> projectFile = ProjectFilesUtils.fileLookup((String)fileFullPath, paths);
            if (Objects.nonNull(projectFile)) {
                if (!this.autoUpdate) {
                    out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_already_exists"), fileFullPath)));
                    return;
                }
                UpdateFileRequest request2 = new UpdateFileRequest();
                Long sourceId = projectFile.getKey().getId();
                attachLabelIds.ifPresent(request2::setAttachLabelIds);
                Long storageId = this.getStorageId(client, fileDestName);
                request2.setStorageId(storageId);
                try {
                    List<String> projectFileExcludedTargetLanguages;
                    client.updateSource(sourceId, request2);
                    if (Objects.nonNull(this.excludedLanguages) && !this.excludedLanguages.isEmpty() && !Objects.equals(this.excludedLanguages, projectFileExcludedTargetLanguages = ((com.crowdin.client.sourcefiles.model.File)projectFile.getKey()).getExcludedTargetLanguages())) {
                        List<PatchRequest> editRequest = RequestBuilder.updateExcludedTargetLanguages(this.excludedLanguages);
                        client.editSource(sourceId, editRequest);
                    }
                    if (!this.plainView) {
                        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
                    } else {
                        out.println((String)fileFullPath);
                    }
                }
                catch (FileInUpdateException e) {
                    if (!this.plainView) {
                        out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file_being_updated"), fileFullPath)));
                    } else {
                        out.println(BaseCli.RESOURCE_BUNDLE.getString("message.file_being_updated"));
                    }
                }
                catch (Exception e) {
                    throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.uploading_file"), fileFullPath));
                }
                return;
            }
        }
        Optional<Object> branch = Optional.empty();
        if (StringUtils.isNotEmpty(this.branchName)) {
            branch = Optional.ofNullable(BranchUtils.getOrCreateBranch(out, this.branchName, client, project, this.plainView));
        } else if (isStringsBasedProject) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project"));
        }
        Long storageId = this.getStorageId(client, fileDestName);
        Optional<Object> excludedLanguageNames = Optional.empty();
        if (Objects.nonNull(this.excludedLanguages) && !this.excludedLanguages.isEmpty()) {
            excludedLanguageNames = Optional.of(this.filterExcludedLanguages(this.excludedLanguages, project));
        }
        if (!isStringsBasedProject) {
            request = new AddFileRequest();
            ((AddFileRequest)request).setName(fileDestName);
            ((AddFileRequest)request).setStorageId(storageId);
            if (Objects.nonNull(this.type)) {
                ((AddFileRequest)request).setType(this.type);
            }
            if (Objects.nonNull(this.parserVersion)) {
                ((AddFileRequest)request).setParserVersion(this.parserVersion);
            }
            if (Objects.nonNull(this.context)) {
                ((AddFileRequest)request).setContext(this.context);
            }
            Optional<Long> directoryId = this.getOrCreateDirectoryId(out, client, project, properties, branch.orElse(null));
            directoryId.ifPresent(((AddFileRequest)request)::setDirectoryId);
            attachLabelIds.ifPresent(((AddFileRequest)request)::setAttachLabelIds);
            branch.ifPresent(arg_0 -> FileUploadAction.lambda$act$1((AddFileRequest)request, arg_0));
            excludedLanguageNames.ifPresent(((AddFileRequest)request)::setExcludedTargetLanguages);
            try {
                FileInfo fileInfo = client.addSource((AddFileRequest)request);
                if (!this.plainView) {
                    out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file.list"), fileInfo.getId(), fileFullPath)));
                } else {
                    out.println((String)fileFullPath);
                }
            }
            catch (ExistsResponseException e) {
                throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_already_exists"), fileFullPath));
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.uploading_file"), fileFullPath));
            }
        }
        if (isStringsBasedProject) {
            request = new UploadStringsRequest();
            ((UploadStringsRequest)request).setBranchId(((Branch)branch.orElseThrow(() -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project")))).getId());
            ((UploadStringsRequest)request).setCleanupMode(this.cleanupMode);
            attachLabelIds.ifPresent(((UploadStringsRequest)request)::setLabelIds);
            ((UploadStringsRequest)request).setUpdateStrings(this.updateStrings);
            ((UploadStringsRequest)request).setStorageId(storageId);
            ConsoleSpinner.execute(out, "message.spinner.uploading_strings", "message.spinner.upload_strings_failed", this.plainView, this.plainView, () -> FileUploadAction.lambda$act$3(client, (UploadStringsRequest)request));
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), fileFullPath)));
            } else {
                out.println((String)fileFullPath);
            }
        }
    }

    private List<String> filterExcludedLanguages(List<String> excludedLanguages, CrowdinProjectFull project) {
        List projectLanguageNames = project.getProjectLanguages(false).stream().map(Language::getId).collect(Collectors.toList());
        return excludedLanguages.stream().filter(projectLanguageNames::contains).collect(Collectors.toList());
    }

    private Long getOrCreateLabel(String labelName, ProjectClient client) {
        Map<String, Long> labelList = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        if (labelList.containsKey(labelName)) {
            return labelList.get(labelName);
        }
        AddLabelRequest request = new AddLabelRequest();
        request.setTitle(labelName);
        Label createdLabel = client.addLabel(request);
        return createdLabel.getId();
    }

    private Optional<Long> getOrCreateDirectoryId(Outputter out, ProjectClient client, CrowdinProjectFull project, ProjectProperties properties, Branch branch) {
        Optional<Long> directoryId;
        Map<String, Long> directoryPaths = ProjectFilesUtils.buildDirectoryPaths(project.getDirectories(), project.getBranches()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        String commonPath = SourcesUtils.getCommonPath(Collections.singletonList(this.file.getAbsolutePath()), properties.getBasePath());
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(false), properties.getBasePath());
        String filePath = Objects.nonNull(this.dest) ? PropertiesBeanUtils.prepareDest(this.dest, StringUtils.removeStart(this.file.getAbsolutePath(), properties.getBasePath()), placeholderUtil) : StringUtils.removeStart(this.file.getAbsolutePath(), properties.getBasePath() + commonPath);
        try {
            directoryId = Optional.ofNullable(ProjectUtils.createPath(out, client, directoryPaths, filePath, branch, this.plainView));
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.creating_directories"));
        }
        return directoryId;
    }

    private Long getStorageId(ProjectClient client, String fileName) {
        Long l;
        block10: {
            InputStream fileStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            try {
                l = client.uploadStorage(fileName, fileStream);
                if (fileStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.local_file_not_found"), this.file.getAbsolutePath()));
                }
                catch (EmptyFileException e) {
                    throw new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file_skipped"), this.file.getAbsolutePath()));
                }
                catch (Exception e) {
                    throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), this.file.getAbsolutePath()));
                }
            }
            fileStream.close();
        }
        return l;
    }

    public FileUploadAction(File file, String branchName, boolean autoUpdate, List<String> labels, String dest, String context, String type, Integer parserVersion, boolean cleanupMode, boolean updateStrings, List<String> excludedLanguages, boolean plainView) {
        this.file = file;
        this.branchName = branchName;
        this.autoUpdate = autoUpdate;
        this.labels = labels;
        this.dest = dest;
        this.context = context;
        this.type = type;
        this.parserVersion = parserVersion;
        this.cleanupMode = cleanupMode;
        this.updateStrings = updateStrings;
        this.excludedLanguages = excludedLanguages;
        this.plainView = plainView;
    }

    private static /* synthetic */ UploadStringsProgress lambda$act$3(ProjectClient client, UploadStringsRequest request) throws Exception {
        UploadStringsProgress uploadStrings = client.addSourceStringsBased(request);
        String uploadId = uploadStrings.getIdentifier();
        while (!"finished".equalsIgnoreCase(uploadStrings.getStatus())) {
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.uploading_strings_percents"), uploadStrings.getProgress()));
            Thread.sleep(1000L);
            uploadStrings = client.getUploadStringsStatus(uploadId);
            if (!"failed".equalsIgnoreCase(uploadStrings.getStatus())) continue;
            throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.upload_strings_failed"));
        }
        ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.uploading_strings_percents"), 100));
        return uploadStrings;
    }

    private static /* synthetic */ void lambda$act$1(AddFileRequest request, Branch b) {
        request.setBranchId(b.getId());
    }
}

