/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.EmptyFileException;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.translations.model.UploadTranslationsRequest;
import com.crowdin.client.translations.model.UploadTranslationsStringsRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FileUploadTranslationAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final File file;
    private final String branchName;
    private final String dest;
    private final String languageId;
    private final boolean xliff;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.plainView, this.plainView, () -> client.downloadFullProject(this.branchName));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (!project.isManagerAccess()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
        }
        if (!project.findLanguageById(this.languageId, true).isPresent()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), this.languageId));
        }
        if (this.xliff) {
            UploadTranslationsRequest request = new UploadTranslationsRequest();
            Long storageId = this.getStorageId(client);
            request.setStorageId(storageId);
            try {
                client.uploadTranslations(this.languageId, request);
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_translation"), this.file.getPath()));
            }
        } else if (!isStringsBasedProject) {
            String branchPath = StringUtils.isNotEmpty(this.branchName) ? BranchUtils.normalizeBranchName(this.branchName) + Utils.PATH_SEPARATOR : "";
            String destination = this.dest;
            if (Objects.isNull(destination)) {
                String commonPath = SourcesUtils.getCommonPath(Collections.singletonList(this.file.getAbsolutePath()), properties.getBasePath());
                destination = StringUtils.removeStart(this.file.getAbsolutePath(), properties.getBasePath() + commonPath);
            }
            String sourcePath = Utils.toUnixPath(Utils.sepAtStart(branchPath + destination));
            FileInfo sourceFileInfo = project.getFileInfos().stream().filter(fi -> Objects.equals(sourcePath, fi.getPath())).findFirst().orElseThrow(() -> new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_found"), sourcePath)));
            UploadTranslationsRequest request = new UploadTranslationsRequest();
            Long storageId = this.getStorageId(client);
            request.setFileId(sourceFileInfo.getId());
            request.setStorageId(storageId);
            try {
                client.uploadTranslations(this.languageId, request);
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_translation"), this.file.getPath()));
            }
        } else {
            UploadTranslationsStringsRequest request = new UploadTranslationsStringsRequest();
            Branch branch = project.findBranchByName(this.branchName).orElseThrow(() -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project")));
            Long storageId = this.getStorageId(client);
            request.setBranchId(branch.getId());
            request.setStorageId(storageId);
            client.uploadTranslationStringsBased(this.languageId, request);
        }
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), this.file.getPath())));
        } else {
            out.println(this.file.getPath());
        }
    }

    private Long getStorageId(ProjectClient client) {
        Long l;
        block10: {
            InputStream fileStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            try {
                l = client.uploadStorage(this.file.getName(), fileStream);
                if (fileStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.local_file_not_found"), this.file.getAbsolutePath()));
                }
                catch (EmptyFileException e) {
                    throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file_skipped"), this.file.getAbsolutePath()));
                }
                catch (Exception e) {
                    throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), this.file.getAbsolutePath()));
                }
            }
            fileStream.close();
        }
        return l;
    }

    public FileUploadTranslationAction(File file, String branchName, String dest, String languageId, boolean xliff, boolean plainView) {
        this.file = file;
        this.branchName = branchName;
        this.dest = dest;
        this.languageId = languageId;
        this.xliff = xliff;
        this.plainView = plainView;
    }
}

