/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.Clients;
import com.crowdin.cli.client.NoClient;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.FilesInterface;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.NoProperties;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.cli.utils.http.OAuthUtil;
import com.crowdin.client.projectsgroups.model.Project;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class InitAction
implements NewAction<NoProperties, NoClient> {
    public static final String BASE_PATH_DEFAULT = ".";
    public static final String BASE_URL_DEFAULT = "https://api.crowdin.com";
    public static final String BASE_ENTERPRISE_URL_DEFAULT = "https://%s.api.crowdin.com";
    private boolean isEnterprise;
    private boolean withBrowser;
    private final FilesInterface files;
    private final String token;
    private final String baseUrl;
    private final String basePath;
    private final String projectId;
    private final String source;
    private final String translation;
    private final Boolean preserveHierarchy;
    private final Path destinationPath;
    private final boolean quiet;

    @Override
    public void act(Outputter out, NoProperties noProperties, NoClient noClient) {
        Scanner scanner = new Scanner(System.in, "UTF-8");
        Asking asking = new Asking(out, scanner);
        try {
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.command_generate_description"), this.destinationPath.toAbsolutePath()));
            if (Files.exists(this.destinationPath, new LinkOption[0])) {
                out.println(ExecutionStatus.SKIPPED.getIcon() + String.format(BaseCli.RESOURCE_BUNDLE.getString("message.already_exists"), this.destinationPath.toAbsolutePath()));
                return;
            }
            List<String> localFileLines = Utils.readResource("/crowdin.yml");
            List<String> sharedFileLines = this.getSharedFileLines();
            if (!this.quiet) {
                Map<String, String> inputs = this.collectUserInputs(out, asking);
                boolean sharedUpdated = InitAction.updateYmlValues(sharedFileLines, Map.of("api_token", inputs.get("api_token")));
                if (sharedUpdated) {
                    HashMap<String, String> localInputs = new HashMap<String, String>(inputs);
                    localInputs.remove("api_token");
                    localFileLines = localFileLines.stream().filter(line -> !line.contains(String.format("\"%s\"", "api_token"))).collect(Collectors.toList());
                    InitAction.updateYmlValues(localFileLines, localInputs);
                } else {
                    InitAction.updateYmlValues(localFileLines, inputs);
                }
            }
            this.saveSharedFileLines(sharedFileLines);
            this.files.writeToFile(this.destinationPath.toString(), new ByteArrayInputStream(StringUtils.join(localFileLines, "\n").getBytes(StandardCharsets.UTF_8)));
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.generate_successful"), new Object[0]));
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.create_file"));
        }
    }

    protected List<String> getSharedFileLines() {
        String sharedFile = System.getProperty("user.home") + Utils.PATH_SEPARATOR + ".crowdin.yml";
        try {
            if (!Files.exists(Paths.get(sharedFile, new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(sharedFile, new String[0]), new FileAttribute[0]);
            }
            return new ArrayList<String>(Files.lines(Paths.get(sharedFile, new String[0])).toList());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void saveSharedFileLines(List<String> sharedFileLines) {
        if (Objects.isNull(sharedFileLines)) {
            return;
        }
        String sharedFile = System.getProperty("user.home") + Utils.PATH_SEPARATOR + ".crowdin.yml";
        this.files.writeToFile(sharedFile, new ByteArrayInputStream(StringUtils.join(sharedFileLines, "\n").getBytes(StandardCharsets.UTF_8)));
    }

    private Map<String, String> collectUserInputs(Outputter out, Asking asking) {
        String sourceInput;
        HashMap<String, String> values = new HashMap<String, String>();
        this.setGivenParams(values);
        boolean bl = this.withBrowser = Objects.isNull(this.token) && !StringUtils.startsWithAny(asking.ask(BaseCli.RESOURCE_BUNDLE.getString("message.ask_auth_via_browser") + ": (Y/n) "), "n", "N", "-");
        if (this.withBrowser) {
            String token;
            try {
                ConsoleSpinner.start(out, "Waiting for authorization to complete (Press <Ctrl>+C to exit)", false);
                token = OAuthUtil.getToken(out, "wQEqvhU3vLOa2XicmUyT");
                ConsoleSpinner.stop(ExecutionStatus.OK, "Authorization finished successfully");
            }
            catch (Exception e) {
                ConsoleSpinner.stop(ExecutionStatus.ERROR, e.getMessage());
                throw e;
            }
            String organizationName = OAuthUtil.getDomainFromToken(token);
            values.put("api_token", token);
            if (StringUtils.isNotEmpty(organizationName)) {
                values.put("base_url", String.format(BASE_ENTERPRISE_URL_DEFAULT, organizationName));
            } else {
                values.put("base_url", BASE_URL_DEFAULT);
            }
        } else {
            String apiToken;
            if (Objects.isNull(this.baseUrl)) {
                this.isEnterprise = StringUtils.startsWithAny(asking.ask(BaseCli.RESOURCE_BUNDLE.getString("message.ask_is_enterprise") + ": (N/y) "), "y", "Y", "+");
                if (this.isEnterprise) {
                    String organizationName = asking.ask(BaseCli.RESOURCE_BUNDLE.getString("message.ask_organization_name") + ": ");
                    if (StringUtils.isNotEmpty(organizationName)) {
                        if (PropertiesBeanUtils.isUrlValid(organizationName)) {
                            String realOrganizationName = PropertiesBeanUtils.getOrganization(organizationName);
                            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.extracted_organization_name"), realOrganizationName));
                            values.put("base_url", String.format(BASE_ENTERPRISE_URL_DEFAULT, realOrganizationName));
                        } else {
                            values.put("base_url", String.format(BASE_ENTERPRISE_URL_DEFAULT, PropertiesBeanUtils.getOrganization(organizationName)));
                        }
                    } else {
                        this.isEnterprise = false;
                        values.put("base_url", BASE_URL_DEFAULT);
                    }
                } else {
                    values.put("base_url", BASE_URL_DEFAULT);
                }
            }
            if (Objects.isNull(this.token) && !(apiToken = asking.askParam("api_token")).isEmpty()) {
                values.put("api_token", apiToken);
            }
        }
        this.verifyAuth(out, values);
        boolean projectIdSpecified = Objects.nonNull(this.projectId);
        boolean printProjects = true;
        while (true) {
            String projectIdToSet;
            if (!projectIdSpecified && printProjects) {
                this.listProjects(out, values);
                printProjects = false;
            }
            String string = projectIdToSet = projectIdSpecified ? this.projectId : asking.ask(BaseCli.RESOURCE_BUNDLE.getString("message.ask_project_id"));
            if (projectIdToSet.isEmpty()) break;
            if (StringUtils.isNumeric(projectIdToSet)) {
                values.put("project_id", projectIdToSet);
                break;
            }
            projectIdSpecified = false;
            values.remove("project_id");
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.init.project_id_is_not_number"), projectIdToSet));
        }
        if (values.containsKey("base_url") && values.containsKey("project_id") && values.containsKey("api_token")) {
            this.checkParametersForExistence(out, (String)values.get("api_token"), (String)values.get("base_url"), Long.parseLong((String)values.get("project_id")));
        } else {
            out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.init.skip_project_validation")));
        }
        String basePathToSet = Objects.nonNull(this.basePath) ? this.basePath : asking.askWithDefault(BaseCli.RESOURCE_BUNDLE.getString("message.ask_project_directory"), BASE_PATH_DEFAULT);
        File basePathFile = Paths.get(basePathToSet, new String[0]).normalize().toAbsolutePath().toFile();
        if (!basePathFile.exists()) {
            out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.init.path_not_exist"), basePathFile)));
        }
        values.put("base_path", basePathToSet);
        if (Objects.isNull(this.source) && !(sourceInput = asking.ask(BaseCli.RESOURCE_BUNDLE.getString("message.ask_source"))).isEmpty()) {
            values.put("source", sourceInput);
        }
        if (Objects.isNull(this.translation)) {
            String translationInput;
            while (!(translationInput = asking.ask(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.ask_translation"), PlaceholderUtil.ALL_PLACEHOLDERS))).isEmpty()) {
                if (PlaceholderUtil.validStringPattern(translationInput, PlaceholderUtil.ALL_PLACEHOLDERS)) {
                    values.put("translation", translationInput);
                    break;
                }
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.init.translation_not_valid"), translationInput));
            }
        }
        return values;
    }

    protected void verifyAuth(Outputter out, Map<String, String> values) {
        ProjectClient client = Clients.getProjectClient(values.get("api_token"), values.get("base_url"), Long.parseLong(values.getOrDefault("project_id", "0")));
        client.getAuthenticatedUser();
        out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.auth_successful")));
    }

    protected void listProjects(Outputter out, Map<String, String> values) {
        ProjectClient client = Clients.getProjectClient(values.get("api_token"), values.get("base_url"), Long.parseLong(values.getOrDefault("project_id", "0")));
        List<? extends Project> projects = client.listProjects();
        for (Project project : projects) {
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.project.list"), project.getId(), project.getName()));
        }
    }

    public static boolean updateYmlValues(List<String> fileLines, Map<String, String> values) {
        if (Objects.isNull(fileLines)) {
            return false;
        }
        for (Map.Entry<String, String> entry : values.entrySet()) {
            boolean found = false;
            for (int i = 0; i < fileLines.size(); ++i) {
                String updatedLine;
                String keyToSearch = String.format("\"%s\"", entry.getKey());
                String fileLine = fileLines.get(i);
                if (!fileLine.contains(keyToSearch)) continue;
                if ("preserve_hierarchy".equals(entry.getKey())) {
                    updatedLine = fileLine.replace(String.valueOf(Boolean.TRUE), entry.getValue());
                } else {
                    String value = Utils.regexPath(entry.getValue());
                    updatedLine = InitAction.replacePreservingQuoting(fileLine, value);
                }
                fileLines.set(i, updatedLine);
                found = true;
                break;
            }
            if (found) continue;
            fileLines.add(String.format("\"%s\": \"%s\"", entry.getKey(), entry.getValue()));
        }
        return true;
    }

    private static String replacePreservingQuoting(String line, String newValue) {
        Pattern p = Pattern.compile("^(\\s*(?:[\\[{]\\s*)?\"?[^\\s\":]+\"?\\s*:\\s*)(?:\"((?:\\\\.|[^\"\\\\]|\"(?!\\s*(?:,?\\s*[\\]\\}\\)]*)?\\s*(?:#.*)?$))*)\"|((?!\")[^,#\\]\\}\\)\\r\\n]*?))\\s*(,?\\s*[\\]\\}\\)]*)?\\s*(#.*)?$");
        Matcher m = p.matcher(line);
        if (!m.matches()) {
            return line;
        }
        String prefix = m.group(1);
        String dqValue = m.group(2);
        String bareVal = m.group(3);
        String suffix = m.group(4);
        String comment = m.group(5);
        String rebuilt = dqValue != null ? prefix + "\"" + newValue.replace("\\", "\\\\").replace("\"", "\\\"") + "\"" : prefix + newValue;
        if (suffix != null && !suffix.isEmpty()) {
            rebuilt = rebuilt + suffix;
        }
        if (comment != null && !comment.isEmpty()) {
            rebuilt = rebuilt + " " + comment;
        }
        return rebuilt;
    }

    private void setGivenParams(Map<String, String> values) {
        Optional.ofNullable(this.token).ifPresent(v -> values.put("api_token", this.token));
        Optional.ofNullable(this.baseUrl).ifPresent(v -> values.put("base_url", this.baseUrl));
        Optional.ofNullable(this.basePath).ifPresent(v -> values.put("base_path", this.basePath));
        Optional.ofNullable(this.projectId).ifPresent(v -> values.put("project_id", this.projectId));
        Optional.ofNullable(this.source).ifPresent(v -> values.put("source", this.source));
        Optional.ofNullable(this.translation).ifPresent(v -> values.put("translation", this.translation));
        Optional.ofNullable(this.preserveHierarchy).ifPresent(v -> values.put("preserve_hierarchy", String.valueOf(this.preserveHierarchy)));
    }

    private void checkParametersForExistence(Outputter out, String apiToken, String baseUrl, Long projectId) {
        ProjectClient client = Clients.getProjectClient(apiToken, baseUrl, projectId);
        try {
            ConsoleSpinner.start(out, BaseCli.RESOURCE_BUNDLE.getString("message.spinner.validating_project"), false);
            client.downloadProjectInfo();
            ConsoleSpinner.stop(ExecutionStatus.OK, BaseCli.RESOURCE_BUNDLE.getString("message.spinner.validation_success"));
        }
        catch (Exception e) {
            ConsoleSpinner.stop(ExecutionStatus.WARNING, e.getMessage());
        }
    }

    public InitAction(FilesInterface files, String token, String baseUrl, String basePath, String projectId, String source, String translation, Boolean preserveHierarchy, Path destinationPath, boolean quiet) {
        this.files = files;
        this.token = token;
        this.baseUrl = baseUrl;
        this.basePath = basePath;
        this.projectId = projectId;
        this.source = source;
        this.translation = translation;
        this.preserveHierarchy = preserveHierarchy;
        this.destinationPath = destinationPath;
        this.quiet = quiet;
    }

    public static class Asking {
        private Outputter out;
        private Scanner scanner;

        public Asking(Outputter out, Scanner scanner) {
            this.out = out;
            this.scanner = scanner;
        }

        public String askParam(String key) {
            return this.ask(StringUtils.capitalize(key.replaceAll("_", " ")) + ": ");
        }

        public String askWithDefault(String question, String def) {
            String input = this.ask(question + ": (" + def + ") ");
            return StringUtils.isNotEmpty(input) ? input : def;
        }

        public String ask(String question) {
            this.out.print(question);
            return this.scanner.nextLine();
        }
    }
}

