/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientLabel;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import java.util.List;

class LabelListAction
implements NewAction<ProjectProperties, ClientLabel> {
    private final boolean plainView;
    private final boolean isVerbose;

    @Override
    public void act(Outputter out, ProjectProperties properties, ClientLabel client) {
        List<Label> labels = client.listLabels();
        for (Label label : labels) {
            if (!this.plainView || this.isVerbose) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.label.list"), label.getId(), label.getTitle()));
                continue;
            }
            out.println(label.getTitle());
        }
        if (labels.isEmpty()) {
            if (!this.plainView && !this.isVerbose) {
                out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.label.list_empty")));
            } else {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.label.list_empty"));
            }
        }
    }

    public LabelListAction(boolean plainView, boolean isVerbose) {
        this.plainView = plainView;
        this.isVerbose = isVerbose;
    }
}

