/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProject;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.DryrunObsoleteSources;
import com.crowdin.cli.commands.functionality.DryrunSources;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.sourcefiles.model.Branch;
import java.util.Optional;

class ListSourcesAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private boolean deleteObsolete;
    private String branchName;
    private boolean noProgress;
    private boolean treeView;
    private boolean plainView;

    public ListSourcesAction(boolean deleteObsolete, String branchName, boolean noProgress, boolean treeView, boolean plainView) {
        this.deleteObsolete = deleteObsolete && !plainView;
        this.branchName = branchName;
        this.noProgress = noProgress || plainView;
        this.treeView = treeView;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, PropertiesWithFiles pb, ProjectClient client) {
        CrowdinProject project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, this.deleteObsolete ? () -> client.downloadFullProject(this.branchName) : client::downloadProjectWithLanguages);
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(false), pb.getBasePath());
        if (!project.isManagerAccess() && this.deleteObsolete) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access_in_upload_sources_dryrun")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access_in_upload_sources_dryrun"));
        }
        if (this.deleteObsolete) {
            CrowdinProjectFull projectFull = (CrowdinProjectFull)project;
            Long branchId = Optional.ofNullable(((CrowdinProjectFull)project).getBranch()).map(Branch::getId).orElse(null);
            new DryrunObsoleteSources(pb, placeholderUtil, projectFull.getDirectories(branchId), projectFull.getFiles(branchId)).run(out, this.treeView, this.plainView);
        }
        new DryrunSources(pb, placeholderUtil).run(out, this.treeView, this.plainView);
    }
}

