/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.DryrunTranslations;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.sourcefiles.model.File;
import java.util.Map;

class ListTranslationsAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private boolean noProgress;
    private boolean treeView;
    private boolean isLocal;
    private boolean plainView;
    private boolean useServerSources;
    private boolean withInContextLang;
    private boolean isUpload;

    public ListTranslationsAction(boolean noProgress, boolean treeView, boolean isLocal, boolean plainView, boolean useServerSources, boolean withInContextLang, boolean isUpload) {
        this.noProgress = noProgress;
        this.treeView = treeView;
        this.isLocal = isLocal;
        this.plainView = plainView;
        this.useServerSources = useServerSources;
        this.withInContextLang = withInContextLang;
        this.isUpload = isUpload;
    }

    @Override
    public void act(Outputter out, PropertiesWithFiles pb, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadFullProject);
        if (!project.isManagerAccess()) {
            if (!this.plainView) {
                System.out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
        }
        Map<String, File> files = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFiles());
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(!this.isLocal), pb.getBasePath());
        new DryrunTranslations(pb, project.getLanguageMapping(), placeholderUtil, project.getProjectLanguages(this.withInContextLang), false, files, this.useServerSources, this.isUpload).run(out, this.treeView, this.plainView);
    }
}

