/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.CrowdinProjectInfo;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.client.ResponseException;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.machinetranslationengines.model.MachineTranslation;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.translations.model.ApplyPreTranslationRequest;
import com.crowdin.client.translations.model.ApplyPreTranslationStringsBasedRequest;
import com.crowdin.client.translations.model.AutoApproveOption;
import com.crowdin.client.translations.model.Method;
import com.crowdin.client.translations.model.PreTranslationReportResponse;
import com.crowdin.client.translations.model.PreTranslationStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class PreTranslateAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private final List<String> languageIds;
    private final List<String> files;
    private final Method method;
    private final Long engineId;
    private final String branchName;
    private final String directory;
    private final AutoApproveOption autoApproveOption;
    private final Boolean duplicateTranslations;
    private final Boolean translateUntranslatedOnly;
    private final Boolean translateWithPerfectMatchOnly;
    private final boolean noProgress;
    private final boolean plainView;
    private final List<String> labelNames;
    private final Long aiPrompt;
    private final boolean isVerbose;

    @Override
    public void act(Outputter out, PropertiesWithFiles properties, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        List<String> languages = this.prepareLanguageIds(project, client, out);
        List<Long> labelIds = this.prepareLabelIds(out, client);
        if (isStringsBasedProject) {
            if (this.files != null && !this.files.isEmpty() || this.directory != null) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("message.no_file_string_project"));
            }
            Branch branch = project.findBranchByName(this.branchName).orElseThrow(() -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project")));
            ApplyPreTranslationStringsBasedRequest request = RequestBuilder.applyPreTranslationStringsBased(languages, Collections.singletonList(branch.getId()), this.method, this.engineId, this.autoApproveOption, this.duplicateTranslations, this.translateUntranslatedOnly, this.translateWithPerfectMatchOnly, labelIds, this.aiPrompt);
            PreTranslationStatus status = this.applyPreTranslationStringsBased(out, client, request);
            this.printVerbose(client, status, out);
            return;
        }
        Optional branch = Optional.ofNullable(this.branchName).flatMap(project::findBranchByName);
        if (!branch.isPresent() && this.branchName != null) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.branch_does_not_exist"), this.branchName));
        }
        List fileInfos = project.getFileInfos().stream().filter(f -> branch.isEmpty() && f.getBranchId() == null || branch.isPresent() && ((Branch)branch.get()).getId().equals(f.getBranchId())).collect(Collectors.toList());
        Map paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), fileInfos);
        boolean containsError = false;
        List<Object> fileIds = new ArrayList();
        if (this.files != null && !this.files.isEmpty()) {
            for (String string : this.files) {
                if (!paths.containsKey(string)) {
                    if (this.files.size() > 1) {
                        containsError = true;
                        out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), string)));
                        continue;
                    }
                    throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), string));
                }
                Long fileId = ((FileInfo)paths.get(string)).getId();
                fileIds.add(fileId);
            }
        } else if (!StringUtils.isEmpty(this.directory)) {
            for (Map.Entry entry : paths.entrySet()) {
                if (!((String)entry.getKey()).startsWith(this.directory)) continue;
                fileIds.add(((FileInfo)entry.getValue()).getId());
            }
        } else {
            fileIds = paths.values().stream().map(FileInfo::getId).toList();
        }
        if (fileIds.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.no_files_found_for_pre_translate"), new Object[0]));
        }
        ApplyPreTranslationRequest request = RequestBuilder.applyPreTranslation(languages, fileIds, this.method, this.engineId, this.autoApproveOption, this.duplicateTranslations, this.translateUntranslatedOnly, this.translateWithPerfectMatchOnly, labelIds, this.aiPrompt);
        PreTranslationStatus preTranslationStatus = this.applyPreTranslation(out, client, request);
        this.printVerbose(client, preTranslationStatus, out);
        if (containsError) {
            throw new RuntimeException();
        }
    }

    private List<String> prepareLanguageIds(CrowdinProjectInfo projectInfo, ProjectClient client, Outputter out) {
        List<String> projectLanguages = projectInfo.getProjectLanguages(false).stream().map(Language::getId).collect(Collectors.toList());
        if (this.languageIds == null || this.languageIds.size() == 1 && "ALL".equalsIgnoreCase(this.languageIds.get(0))) {
            if (Method.MT.equals(this.method)) {
                try {
                    ConsoleSpinner.start(out, BaseCli.RESOURCE_BUNDLE.getString("message.spinner.validating_mt_languages"), this.noProgress);
                    MachineTranslation mt = client.getMt(this.engineId);
                    ConsoleSpinner.stop(ExecutionStatus.OK, BaseCli.RESOURCE_BUNDLE.getString("message.spinner.validation_success"));
                    HashSet<String> supportedMtLanguageIds = new HashSet<String>(mt.getSupportedLanguageIds());
                    return projectLanguages.stream().filter(supportedMtLanguageIds::contains).collect(Collectors.toList());
                }
                catch (ResponseException e) {
                    ConsoleSpinner.stop(ExecutionStatus.WARNING, String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.validation_error"), e.getMessage()));
                }
            }
            return projectLanguages;
        }
        String wrongLanguageIds = this.languageIds.stream().filter(langId -> !projectLanguages.contains(langId)).map(id -> "'" + id + "'").collect(Collectors.joining(", "));
        if (!wrongLanguageIds.isEmpty()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.languages_not_exist"), wrongLanguageIds));
        }
        return this.languageIds;
    }

    private List<Long> prepareLabelIds(Outputter out, ProjectClient client) {
        if (this.labelNames != null && !this.labelNames.isEmpty()) {
            Map<String, Long> labels = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
            this.labelNames.stream().distinct().forEach(labelName -> {
                if (!labels.containsKey(labelName)) {
                    out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.pre_translate.missing_label"), labelName)));
                }
            });
            return this.labelNames.stream().map(labels::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    private PreTranslationStatus applyPreTranslation(Outputter out, ProjectClient client, ApplyPreTranslationRequest request) {
        return ConsoleSpinner.execute(out, "message.spinner.pre_translate", "error.spinner.pre_translate", this.noProgress, this.plainView, () -> {
            PreTranslationStatus preTranslationStatus = client.startPreTranslation(request);
            preTranslationStatus = this.handlePreTranslationStatus(client, preTranslationStatus);
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.pre_translate_done"), 100));
            return preTranslationStatus;
        });
    }

    private PreTranslationStatus applyPreTranslationStringsBased(Outputter out, ProjectClient client, ApplyPreTranslationStringsBasedRequest request) {
        return ConsoleSpinner.execute(out, "message.spinner.pre_translate", "error.spinner.pre_translate", this.noProgress, this.plainView, () -> {
            PreTranslationStatus preTranslationStatus = client.startPreTranslationStringsBased(request);
            preTranslationStatus = this.handlePreTranslationStatus(client, preTranslationStatus);
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.pre_translate_done"), 100));
            return preTranslationStatus;
        });
    }

    private PreTranslationStatus handlePreTranslationStatus(ProjectClient client, PreTranslationStatus preTranslationStatus) throws InterruptedException {
        while (!preTranslationStatus.getStatus().equalsIgnoreCase("finished")) {
            ConsoleSpinner.update(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.spinner.pre_translate_percents"), Math.toIntExact(preTranslationStatus.getProgress().intValue())));
            Thread.sleep(1000L);
            if (!(preTranslationStatus = client.checkPreTranslation(preTranslationStatus.getIdentifier())).getStatus().equalsIgnoreCase("failed")) continue;
            throw new RuntimeException();
        }
        return preTranslationStatus;
    }

    private void printVerbose(ProjectClient client, PreTranslationStatus status, Outputter out) {
        if (!this.isVerbose) {
            return;
        }
        PreTranslationReportResponse preTranslationReport = client.getPreTranslationReport(status.getIdentifier());
        int filesCount = preTranslationReport.getLanguages().stream().mapToInt(l -> Optional.ofNullable(l.getFiles()).map(List::size).orElse(0)).sum();
        int phrasesCount = preTranslationReport.getLanguages().stream().flatMap(l -> Optional.ofNullable(l.getFiles()).orElse(List.of()).stream()).mapToInt(f -> Optional.ofNullable(f.getStatistics()).map(PreTranslationReportResponse.Statistics::getPhrases).orElse(0)).sum();
        int wordsCount = preTranslationReport.getLanguages().stream().flatMap(l -> Optional.ofNullable(l.getFiles()).orElse(List.of()).stream()).mapToInt(f -> Optional.ofNullable(f.getStatistics()).map(PreTranslationReportResponse.Statistics::getWords).orElse(0)).sum();
        int skippedCount = preTranslationReport.getLanguages().stream().flatMapToInt(l -> ((Collection)Optional.ofNullable(l.getSkipped()).map(Map::values).orElse(List.of())).stream().mapToInt(i -> i)).sum();
        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.pre_translate.files_count"), filesCount));
        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.pre_translate.phrases_count"), phrasesCount));
        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.pre_translate.words_count"), wordsCount));
        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.pre_translate.skipped_count"), skippedCount));
    }

    public PreTranslateAction(List<String> languageIds, List<String> files, Method method, Long engineId, String branchName, String directory, AutoApproveOption autoApproveOption, Boolean duplicateTranslations, Boolean translateUntranslatedOnly, Boolean translateWithPerfectMatchOnly, boolean noProgress, boolean plainView, List<String> labelNames, Long aiPrompt, boolean isVerbose) {
        this.languageIds = languageIds;
        this.files = files;
        this.method = method;
        this.engineId = engineId;
        this.branchName = branchName;
        this.directory = directory;
        this.autoApproveOption = autoApproveOption;
        this.duplicateTranslations = duplicateTranslations;
        this.translateUntranslatedOnly = translateUntranslatedOnly;
        this.translateWithPerfectMatchOnly = translateWithPerfectMatchOnly;
        this.noProgress = noProgress;
        this.plainView = plainView;
        this.labelNames = labelNames;
        this.aiPrompt = aiPrompt;
        this.isVerbose = isVerbose;
    }
}

