/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.AutoTagInProgressException;
import com.crowdin.cli.client.ClientScreenshot;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import com.crowdin.client.screenshots.model.AddScreenshotRequest;
import com.crowdin.client.screenshots.model.AutoTagReplaceTagsRequest;
import com.crowdin.client.screenshots.model.Screenshot;
import com.crowdin.client.screenshots.model.UpdateScreenshotRequest;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.Directory;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class ScreenshotUploadAction
implements NewAction<ProjectProperties, ClientScreenshot> {
    private final File file;
    private final String branchName;
    private final List<String> labelNames;
    private final String pathToSourceFile;
    private final String directoryPath;
    private final boolean autoTag;
    private final boolean plainView;
    private final boolean noProgress;

    @Override
    public void act(Outputter out, ProjectProperties properties, ClientScreenshot client) {
        List<Screenshot> screenshotList;
        Optional existingScreenshot;
        ProjectClient projectClient = GenericActCommand.getProjectClient(properties);
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, projectClient::downloadFullProject);
        Long branchId = null;
        if (Objects.nonNull(this.branchName)) {
            Branch branch = project.findBranchByName(this.branchName).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.branch_not_exists"), this.branchName)));
            branchId = branch.getId();
        }
        Long fileId = null;
        if (Objects.nonNull(this.pathToSourceFile)) {
            String normalizedPath = Utils.toUnixPath(Utils.sepAtStart(this.pathToSourceFile));
            FileInfo fileInfo = project.getFileInfos().stream().filter(f -> normalizedPath.equals(f.getPath())).findFirst().orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), this.pathToSourceFile)));
            fileId = fileInfo.getId();
        }
        Long directoryId = null;
        if (Objects.nonNull(this.directoryPath)) {
            String normalizedPath = Utils.toUnixPath(Utils.sepAtStart(this.directoryPath));
            Directory directory = project.getDirectories().values().stream().filter(d -> normalizedPath.equals(d.getPath())).findFirst().orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.dir_not_exists"), this.directoryPath)));
            directoryId = directory.getId();
        }
        if ((existingScreenshot = (screenshotList = client.listScreenshotsByName(this.file.getName())).stream().findFirst()).isPresent()) {
            UpdateScreenshotRequest request = new UpdateScreenshotRequest();
            request.setStorageId(this.uploadToStorage(projectClient, this.file));
            request.setName(this.file.getName());
            request.setUsePreviousTags(!this.autoTag);
            try {
                Screenshot screenshot = client.updateScreenshot(((Screenshot)existingScreenshot.get()).getId(), request);
                if (this.autoTag) {
                    AutoTagReplaceTagsRequest autoTagReplaceTagsRequest = new AutoTagReplaceTagsRequest();
                    autoTagReplaceTagsRequest.setAutoTag(true);
                    autoTagReplaceTagsRequest.setBranchId(branchId);
                    autoTagReplaceTagsRequest.setDirectoryId(directoryId);
                    autoTagReplaceTagsRequest.setFileId(fileId);
                    client.replaceTags(((Screenshot)existingScreenshot.get()).getId(), autoTagReplaceTagsRequest);
                }
                if (!this.plainView) {
                    out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.list"), screenshot.getId(), screenshot.getTagsCount(), screenshot.getName())));
                } else {
                    out.println(this.file.getName());
                }
            }
            catch (Exception e) {
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.screenshot.not_updated"), request));
            }
            return;
        }
        AddScreenshotRequest request = new AddScreenshotRequest();
        if (Objects.nonNull(this.labelNames) && !this.labelNames.isEmpty()) {
            request.setLabelIds(this.prepareLabelIds(projectClient));
        }
        request.setBranchId(branchId);
        request.setDirectoryId(directoryId);
        request.setFileId(fileId);
        request.setStorageId(this.uploadToStorage(projectClient, this.file));
        request.setName(this.file.getName());
        request.setAutoTag(this.autoTag);
        try {
            Screenshot screenshot = client.uploadScreenshot(request);
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.list"), screenshot.getId(), screenshot.getTagsCount(), screenshot.getName())));
            } else {
                out.println(this.file.getName());
            }
        }
        catch (AutoTagInProgressException e) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.not_auto-tagged"), this.file.getName())));
            } else {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.not_auto-tagged"), this.file.getName()));
            }
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.screenshot.not_uploaded"), request));
        }
    }

    private Long uploadToStorage(ProjectClient projectClient, File fileToUpload) {
        Long storageId;
        try (InputStream fileStream = Files.newInputStream(fileToUpload.toPath(), new OpenOption[0]);){
            storageId = projectClient.uploadStorage(fileToUpload.getName(), fileStream);
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"), fileToUpload.getName()));
        }
        return storageId;
    }

    private Long[] prepareLabelIds(ProjectClient projectClient) {
        Map<String, Long> labels = projectClient.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        this.labelNames.stream().distinct().forEach(labelName -> labels.computeIfAbsent((String)labelName, title -> projectClient.addLabel(RequestBuilder.addLabel(title)).getId()));
        return (Long[])this.labelNames.stream().map(labels::get).toArray(Long[]::new);
    }

    public ScreenshotUploadAction(File file, String branchName, List<String> labelNames, String pathToSourceFile, String directoryPath, boolean autoTag, boolean plainView, boolean noProgress) {
        this.file = file;
        this.branchName = branchName;
        this.labelNames = labelNames;
        this.pathToSourceFile = pathToSourceFile;
        this.directoryPath = directoryPath;
        this.autoTag = autoTag;
        this.plainView = plainView;
        this.noProgress = noProgress;
    }
}

