/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.translationstatus.model.LanguageProgress;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StatusAction
implements NewAction<ProjectProperties, ProjectClient> {
    private boolean noProgress;
    private String branchName;
    private String languageId;
    private String file;
    private String directory;
    private boolean isVerbose;
    private boolean showTranslated;
    private boolean showApproved;
    private boolean failIfIncomplete;
    private boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        List<LanguageProgress> progresses;
        Long branchId;
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
        if (this.languageId != null) {
            project.findLanguageById(this.languageId, true).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), this.languageId)));
        }
        List<Branch> branches = client.listBranches();
        Long l = branchId = this.branchName == null ? null : BranchUtils.getBranch(this.branchName, branches).orElseThrow(() -> new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.not_found_branch"))).getId();
        if (this.file != null) {
            String filePath = Utils.toUnixPath(Utils.sepAtStart(this.file));
            Long fileId = project.getFileInfos().stream().filter(f -> filePath.equals(f.getPath())).findFirst().orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), this.file))).getId();
            progresses = client.getFileProgress(fileId);
        } else if (this.directory != null) {
            String directoryPath = Utils.toUnixPath(Utils.sepAtStart(this.directory));
            Long directoryId = project.getDirectories().values().stream().filter(d -> directoryPath.equals(d.getPath())).findFirst().orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.dir_not_exists"), this.directory))).getId();
            progresses = client.getDirectoryProgress(directoryId);
        } else {
            progresses = branchId != null ? client.getBranchProgress(branchId) : client.getProjectProgress(this.languageId);
        }
        if (this.languageId != null) {
            progresses = progresses.stream().filter(langProgress -> this.languageId.equals(langProgress.getLanguageId())).collect(Collectors.toList());
        }
        if (this.isVerbose) {
            progresses.forEach(pr -> {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.language"), project.findLanguageById(pr.getLanguageId(), true).get().getName(), pr.getLanguageId()));
                if (this.showTranslated) {
                    out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.translation_progress"), pr.getTranslationProgress(), pr.getWords().getTranslated(), pr.getWords().getTotal(), pr.getPhrases().getTranslated(), pr.getPhrases().getTotal()));
                }
                if (this.showApproved) {
                    out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.approval_progress"), pr.getApprovalProgress(), pr.getWords().getApproved(), pr.getWords().getTotal(), pr.getPhrases().getApproved(), pr.getPhrases().getTotal()));
                }
            });
        } else {
            if (this.showTranslated && this.showApproved) {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.translation"));
            }
            if (this.showTranslated) {
                progresses.forEach(pr -> {
                    if (!this.plainView) {
                        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.item_list_with_percents"), pr.getLanguageId(), pr.getTranslationProgress()));
                    } else {
                        out.println(String.format("%s %d", pr.getLanguageId(), pr.getTranslationProgress()));
                    }
                });
            }
            if (this.showTranslated && this.showApproved) {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.approval"));
            }
            if (this.showApproved) {
                progresses.forEach(pr -> {
                    if (!this.plainView) {
                        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.item_list_with_percents"), pr.getLanguageId(), pr.getApprovalProgress()));
                    } else {
                        out.println(String.format("%s %d", pr.getLanguageId(), pr.getApprovalProgress()));
                    }
                });
            }
            this.throwExceptionIfIncomplete(progresses.stream());
        }
    }

    private Consumer<? super LanguageProgress> throwException(String msg) {
        throw new RuntimeException(msg);
    }

    private void throwExceptionIfIncomplete(Stream<LanguageProgress> failedLanguageProjects) {
        block3: {
            List collect;
            block2: {
                collect = failedLanguageProjects.collect(Collectors.toList());
                if (!this.showApproved || !this.failIfIncomplete) break block2;
                for (LanguageProgress p : collect) {
                    if (p.getApprovalProgress() >= 100) continue;
                    this.throwException(BaseCli.RESOURCE_BUNDLE.getString("error.project_is_incomplete"));
                }
                break block3;
            }
            if (!this.showTranslated || !this.failIfIncomplete) break block3;
            for (LanguageProgress p : collect) {
                if (p.getTranslationProgress() >= 100) continue;
                this.throwException(BaseCli.RESOURCE_BUNDLE.getString("error.project_is_incomplete"));
            }
        }
    }

    public StatusAction(boolean noProgress, String branchName, String languageId, String file, String directory, boolean isVerbose, boolean showTranslated, boolean showApproved, boolean failIfIncomplete, boolean plainView) {
        this.noProgress = noProgress;
        this.branchName = branchName;
        this.languageId = languageId;
        this.file = file;
        this.directory = directory;
        this.isVerbose = isVerbose;
        this.showTranslated = showTranslated;
        this.showApproved = showApproved;
        this.failIfIncomplete = failIfIncomplete;
        this.plainView = plainView;
    }
}

